package software.amazon.awscdk.services.ses;

/**
 * Properties for defining a <code>CfnVdmAttributes</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.ses.*;
 * CfnVdmAttributesProps cfnVdmAttributesProps = CfnVdmAttributesProps.builder()
 *         .dashboardAttributes(DashboardAttributesProperty.builder()
 *                 .engagementMetrics("engagementMetrics")
 *                 .build())
 *         .guardianAttributes(GuardianAttributesProperty.builder()
 *                 .optimizedSharedDelivery("optimizedSharedDelivery")
 *                 .build())
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ses-vdmattributes.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ses-vdmattributes.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.106.0 (build e852934)", date = "2025-02-17T19:20:37.303Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ses.CfnVdmAttributesProps")
@software.amazon.jsii.Jsii.Proxy(CfnVdmAttributesProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnVdmAttributesProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * Specifies additional settings for your VDM configuration as applicable to the Dashboard.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ses-vdmattributes.html#cfn-ses-vdmattributes-dashboardattributes">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ses-vdmattributes.html#cfn-ses-vdmattributes-dashboardattributes</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getDashboardAttributes() {
        return null;
    }

    /**
     * Specifies additional settings for your VDM configuration as applicable to the Guardian.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ses-vdmattributes.html#cfn-ses-vdmattributes-guardianattributes">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ses-vdmattributes.html#cfn-ses-vdmattributes-guardianattributes</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getGuardianAttributes() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnVdmAttributesProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnVdmAttributesProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnVdmAttributesProps> {
        java.lang.Object dashboardAttributes;
        java.lang.Object guardianAttributes;

        /**
         * Sets the value of {@link CfnVdmAttributesProps#getDashboardAttributes}
         * @param dashboardAttributes Specifies additional settings for your VDM configuration as applicable to the Dashboard.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder dashboardAttributes(software.amazon.awscdk.IResolvable dashboardAttributes) {
            this.dashboardAttributes = dashboardAttributes;
            return this;
        }

        /**
         * Sets the value of {@link CfnVdmAttributesProps#getDashboardAttributes}
         * @param dashboardAttributes Specifies additional settings for your VDM configuration as applicable to the Dashboard.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder dashboardAttributes(software.amazon.awscdk.services.ses.CfnVdmAttributes.DashboardAttributesProperty dashboardAttributes) {
            this.dashboardAttributes = dashboardAttributes;
            return this;
        }

        /**
         * Sets the value of {@link CfnVdmAttributesProps#getGuardianAttributes}
         * @param guardianAttributes Specifies additional settings for your VDM configuration as applicable to the Guardian.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder guardianAttributes(software.amazon.awscdk.IResolvable guardianAttributes) {
            this.guardianAttributes = guardianAttributes;
            return this;
        }

        /**
         * Sets the value of {@link CfnVdmAttributesProps#getGuardianAttributes}
         * @param guardianAttributes Specifies additional settings for your VDM configuration as applicable to the Guardian.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder guardianAttributes(software.amazon.awscdk.services.ses.CfnVdmAttributes.GuardianAttributesProperty guardianAttributes) {
            this.guardianAttributes = guardianAttributes;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnVdmAttributesProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnVdmAttributesProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnVdmAttributesProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnVdmAttributesProps {
        private final java.lang.Object dashboardAttributes;
        private final java.lang.Object guardianAttributes;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.dashboardAttributes = software.amazon.jsii.Kernel.get(this, "dashboardAttributes", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.guardianAttributes = software.amazon.jsii.Kernel.get(this, "guardianAttributes", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.dashboardAttributes = builder.dashboardAttributes;
            this.guardianAttributes = builder.guardianAttributes;
        }

        @Override
        public final java.lang.Object getDashboardAttributes() {
            return this.dashboardAttributes;
        }

        @Override
        public final java.lang.Object getGuardianAttributes() {
            return this.guardianAttributes;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getDashboardAttributes() != null) {
                data.set("dashboardAttributes", om.valueToTree(this.getDashboardAttributes()));
            }
            if (this.getGuardianAttributes() != null) {
                data.set("guardianAttributes", om.valueToTree(this.getGuardianAttributes()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_ses.CfnVdmAttributesProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnVdmAttributesProps.Jsii$Proxy that = (CfnVdmAttributesProps.Jsii$Proxy) o;

            if (this.dashboardAttributes != null ? !this.dashboardAttributes.equals(that.dashboardAttributes) : that.dashboardAttributes != null) return false;
            return this.guardianAttributes != null ? this.guardianAttributes.equals(that.guardianAttributes) : that.guardianAttributes == null;
        }

        @Override
        public final int hashCode() {
            int result = this.dashboardAttributes != null ? this.dashboardAttributes.hashCode() : 0;
            result = 31 * result + (this.guardianAttributes != null ? this.guardianAttributes.hashCode() : 0);
            return result;
        }
    }
}
