package software.amazon.awscdk.services.ses;

/**
 * Reasons for which recipient email addresses should be automatically added to your account's suppression list.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // Only bounces will be suppressed.
 * // Only bounces will be suppressed.
 * ConfigurationSet.Builder.create(this, "ConfigurationSet")
 *         .suppressionReasons(SuppressionReasons.BOUNCES_ONLY)
 *         .build();
 * // Only complaints will be suppressed.
 * // Only complaints will be suppressed.
 * ConfigurationSet.Builder.create(this, "ConfigurationSet")
 *         .suppressionReasons(SuppressionReasons.COMPLAINTS_ONLY)
 *         .build();
 * // Both bounces and complaints will be suppressed.
 * // Both bounces and complaints will be suppressed.
 * ConfigurationSet.Builder.create(this, "ConfigurationSet")
 *         .suppressionReasons(SuppressionReasons.BOUNCES_AND_COMPLAINTS)
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.106.0 (build e852934)", date = "2025-02-17T19:20:37.337Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ses.SuppressionReasons")
public enum SuppressionReasons {
    /**
     * Bounces and complaints.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    BOUNCES_AND_COMPLAINTS,
    /**
     * Bounces only.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    BOUNCES_ONLY,
    /**
     * Complaints only.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    COMPLAINTS_ONLY,
}
