package software.amazon.awscdk.services.sns;

/**
 * Conditions that can be applied to numeric attributes.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * import software.amazon.awscdk.services.lambda.*;
 * Function fn;
 * Topic myTopic = new Topic(this, "MyTopic");
 * // Lambda should receive only message matching the following conditions on attributes:
 * // color: 'red' or 'orange' or begins with 'bl'
 * // size: anything but 'small' or 'medium'
 * // price: between 100 and 200 or greater than 300
 * // store: attribute must be present
 * myTopic.addSubscription(LambdaSubscription.Builder.create(fn)
 *         .filterPolicy(Map.of(
 *                 "color", SubscriptionFilter.stringFilter(StringConditions.builder()
 *                         .allowlist(List.of("red", "orange"))
 *                         .matchPrefixes(List.of("bl"))
 *                         .matchSuffixes(List.of("ue"))
 *                         .build()),
 *                 "size", SubscriptionFilter.stringFilter(StringConditions.builder()
 *                         .denylist(List.of("small", "medium"))
 *                         .build()),
 *                 "price", SubscriptionFilter.numericFilter(NumericConditions.builder()
 *                         .between(BetweenCondition.builder().start(100).stop(200).build())
 *                         .greaterThan(300)
 *                         .build()),
 *                 "store", SubscriptionFilter.existsFilter()))
 *         .build());
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.106.0 (build e852934)", date = "2025-02-17T19:20:37.414Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_sns.NumericConditions")
@software.amazon.jsii.Jsii.Proxy(NumericConditions.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface NumericConditions extends software.amazon.jsii.JsiiSerializable {

    /**
     * Match one or more values.
     * <p>
     * Default: - None
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<java.lang.Number> getAllowlist() {
        return null;
    }

    /**
     * Match values that are between the specified values.
     * <p>
     * Default: - None
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.sns.BetweenCondition getBetween() {
        return null;
    }

    /**
     * Match values that are strictly between the specified values.
     * <p>
     * Default: - None
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.sns.BetweenCondition getBetweenStrict() {
        return null;
    }

    /**
     * Match values that are greater than the specified value.
     * <p>
     * Default: - None
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getGreaterThan() {
        return null;
    }

    /**
     * Match values that are greater than or equal to the specified value.
     * <p>
     * Default: - None
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getGreaterThanOrEqualTo() {
        return null;
    }

    /**
     * Match values that are less than the specified value.
     * <p>
     * Default: - None
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getLessThan() {
        return null;
    }

    /**
     * Match values that are less than or equal to the specified value.
     * <p>
     * Default: - None
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getLessThanOrEqualTo() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link NumericConditions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link NumericConditions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<NumericConditions> {
        java.util.List<java.lang.Number> allowlist;
        software.amazon.awscdk.services.sns.BetweenCondition between;
        software.amazon.awscdk.services.sns.BetweenCondition betweenStrict;
        java.lang.Number greaterThan;
        java.lang.Number greaterThanOrEqualTo;
        java.lang.Number lessThan;
        java.lang.Number lessThanOrEqualTo;

        /**
         * Sets the value of {@link NumericConditions#getAllowlist}
         * @param allowlist Match one or more values.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder allowlist(java.util.List<? extends java.lang.Number> allowlist) {
            this.allowlist = (java.util.List<java.lang.Number>)allowlist;
            return this;
        }

        /**
         * Sets the value of {@link NumericConditions#getBetween}
         * @param between Match values that are between the specified values.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder between(software.amazon.awscdk.services.sns.BetweenCondition between) {
            this.between = between;
            return this;
        }

        /**
         * Sets the value of {@link NumericConditions#getBetweenStrict}
         * @param betweenStrict Match values that are strictly between the specified values.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder betweenStrict(software.amazon.awscdk.services.sns.BetweenCondition betweenStrict) {
            this.betweenStrict = betweenStrict;
            return this;
        }

        /**
         * Sets the value of {@link NumericConditions#getGreaterThan}
         * @param greaterThan Match values that are greater than the specified value.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder greaterThan(java.lang.Number greaterThan) {
            this.greaterThan = greaterThan;
            return this;
        }

        /**
         * Sets the value of {@link NumericConditions#getGreaterThanOrEqualTo}
         * @param greaterThanOrEqualTo Match values that are greater than or equal to the specified value.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder greaterThanOrEqualTo(java.lang.Number greaterThanOrEqualTo) {
            this.greaterThanOrEqualTo = greaterThanOrEqualTo;
            return this;
        }

        /**
         * Sets the value of {@link NumericConditions#getLessThan}
         * @param lessThan Match values that are less than the specified value.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder lessThan(java.lang.Number lessThan) {
            this.lessThan = lessThan;
            return this;
        }

        /**
         * Sets the value of {@link NumericConditions#getLessThanOrEqualTo}
         * @param lessThanOrEqualTo Match values that are less than or equal to the specified value.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder lessThanOrEqualTo(java.lang.Number lessThanOrEqualTo) {
            this.lessThanOrEqualTo = lessThanOrEqualTo;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link NumericConditions}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public NumericConditions build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link NumericConditions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements NumericConditions {
        private final java.util.List<java.lang.Number> allowlist;
        private final software.amazon.awscdk.services.sns.BetweenCondition between;
        private final software.amazon.awscdk.services.sns.BetweenCondition betweenStrict;
        private final java.lang.Number greaterThan;
        private final java.lang.Number greaterThanOrEqualTo;
        private final java.lang.Number lessThan;
        private final java.lang.Number lessThanOrEqualTo;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.allowlist = software.amazon.jsii.Kernel.get(this, "allowlist", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.Number.class)));
            this.between = software.amazon.jsii.Kernel.get(this, "between", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.sns.BetweenCondition.class));
            this.betweenStrict = software.amazon.jsii.Kernel.get(this, "betweenStrict", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.sns.BetweenCondition.class));
            this.greaterThan = software.amazon.jsii.Kernel.get(this, "greaterThan", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.greaterThanOrEqualTo = software.amazon.jsii.Kernel.get(this, "greaterThanOrEqualTo", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.lessThan = software.amazon.jsii.Kernel.get(this, "lessThan", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.lessThanOrEqualTo = software.amazon.jsii.Kernel.get(this, "lessThanOrEqualTo", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.allowlist = (java.util.List<java.lang.Number>)builder.allowlist;
            this.between = builder.between;
            this.betweenStrict = builder.betweenStrict;
            this.greaterThan = builder.greaterThan;
            this.greaterThanOrEqualTo = builder.greaterThanOrEqualTo;
            this.lessThan = builder.lessThan;
            this.lessThanOrEqualTo = builder.lessThanOrEqualTo;
        }

        @Override
        public final java.util.List<java.lang.Number> getAllowlist() {
            return this.allowlist;
        }

        @Override
        public final software.amazon.awscdk.services.sns.BetweenCondition getBetween() {
            return this.between;
        }

        @Override
        public final software.amazon.awscdk.services.sns.BetweenCondition getBetweenStrict() {
            return this.betweenStrict;
        }

        @Override
        public final java.lang.Number getGreaterThan() {
            return this.greaterThan;
        }

        @Override
        public final java.lang.Number getGreaterThanOrEqualTo() {
            return this.greaterThanOrEqualTo;
        }

        @Override
        public final java.lang.Number getLessThan() {
            return this.lessThan;
        }

        @Override
        public final java.lang.Number getLessThanOrEqualTo() {
            return this.lessThanOrEqualTo;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getAllowlist() != null) {
                data.set("allowlist", om.valueToTree(this.getAllowlist()));
            }
            if (this.getBetween() != null) {
                data.set("between", om.valueToTree(this.getBetween()));
            }
            if (this.getBetweenStrict() != null) {
                data.set("betweenStrict", om.valueToTree(this.getBetweenStrict()));
            }
            if (this.getGreaterThan() != null) {
                data.set("greaterThan", om.valueToTree(this.getGreaterThan()));
            }
            if (this.getGreaterThanOrEqualTo() != null) {
                data.set("greaterThanOrEqualTo", om.valueToTree(this.getGreaterThanOrEqualTo()));
            }
            if (this.getLessThan() != null) {
                data.set("lessThan", om.valueToTree(this.getLessThan()));
            }
            if (this.getLessThanOrEqualTo() != null) {
                data.set("lessThanOrEqualTo", om.valueToTree(this.getLessThanOrEqualTo()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_sns.NumericConditions"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            NumericConditions.Jsii$Proxy that = (NumericConditions.Jsii$Proxy) o;

            if (this.allowlist != null ? !this.allowlist.equals(that.allowlist) : that.allowlist != null) return false;
            if (this.between != null ? !this.between.equals(that.between) : that.between != null) return false;
            if (this.betweenStrict != null ? !this.betweenStrict.equals(that.betweenStrict) : that.betweenStrict != null) return false;
            if (this.greaterThan != null ? !this.greaterThan.equals(that.greaterThan) : that.greaterThan != null) return false;
            if (this.greaterThanOrEqualTo != null ? !this.greaterThanOrEqualTo.equals(that.greaterThanOrEqualTo) : that.greaterThanOrEqualTo != null) return false;
            if (this.lessThan != null ? !this.lessThan.equals(that.lessThan) : that.lessThan != null) return false;
            return this.lessThanOrEqualTo != null ? this.lessThanOrEqualTo.equals(that.lessThanOrEqualTo) : that.lessThanOrEqualTo == null;
        }

        @Override
        public final int hashCode() {
            int result = this.allowlist != null ? this.allowlist.hashCode() : 0;
            result = 31 * result + (this.between != null ? this.between.hashCode() : 0);
            result = 31 * result + (this.betweenStrict != null ? this.betweenStrict.hashCode() : 0);
            result = 31 * result + (this.greaterThan != null ? this.greaterThan.hashCode() : 0);
            result = 31 * result + (this.greaterThanOrEqualTo != null ? this.greaterThanOrEqualTo.hashCode() : 0);
            result = 31 * result + (this.lessThan != null ? this.lessThan.hashCode() : 0);
            result = 31 * result + (this.lessThanOrEqualTo != null ? this.lessThanOrEqualTo.hashCode() : 0);
            return result;
        }
    }
}
