package software.amazon.awscdk.services.stepfunctions.tasks;

/**
 * Create a new AWS EventBridge Scheduler schedule.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * import software.amazon.awscdk.services.scheduler.*;
 * import software.amazon.awscdk.services.kms.*;
 * Key key;
 * CfnScheduleGroup scheduleGroup;
 * Queue targetQueue;
 * Queue deadLetterQueue;
 * Role schedulerRole = Role.Builder.create(this, "SchedulerRole")
 *         .assumedBy(new ServicePrincipal("scheduler.amazonaws.com"))
 *         .build();
 * // To send the message to the queue
 * // This policy changes depending on the type of target.
 * schedulerRole.addToPrincipalPolicy(PolicyStatement.Builder.create()
 *         .actions(List.of("sqs:SendMessage"))
 *         .resources(List.of(targetQueue.getQueueArn()))
 *         .build());
 * EventBridgeSchedulerCreateScheduleTask createScheduleTask1 = EventBridgeSchedulerCreateScheduleTask.Builder.create(this, "createSchedule")
 *         .scheduleName("TestSchedule")
 *         .actionAfterCompletion(ActionAfterCompletion.NONE)
 *         .clientToken("testToken")
 *         .description("TestDescription")
 *         .startDate(new Date())
 *         .endDate(new Date(new Date().getTime() + 1000 * 60 * 60))
 *         .flexibleTimeWindow(Duration.minutes(5))
 *         .groupName(scheduleGroup.getRef())
 *         .kmsKey(key)
 *         .schedule(Schedule.rate(Duration.minutes(5)))
 *         .timezone("UTC")
 *         .enabled(true)
 *         .target(EventBridgeSchedulerTarget.Builder.create()
 *                 .arn(targetQueue.getQueueArn())
 *                 .role(schedulerRole)
 *                 .retryPolicy(RetryPolicy.builder()
 *                         .maximumRetryAttempts(2)
 *                         .maximumEventAge(Duration.minutes(5))
 *                         .build())
 *                 .deadLetterQueue(deadLetterQueue)
 *                 .build())
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="https://docs.aws.amazon.com/scheduler/latest/APIReference/API_CreateSchedule.html">https://docs.aws.amazon.com/scheduler/latest/APIReference/API_CreateSchedule.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.106.0 (build e852934)", date = "2025-02-17T19:20:38.126Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_stepfunctions_tasks.EventBridgeSchedulerCreateScheduleTask")
public class EventBridgeSchedulerCreateScheduleTask extends software.amazon.awscdk.services.stepfunctions.TaskStateBase {

    protected EventBridgeSchedulerCreateScheduleTask(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected EventBridgeSchedulerCreateScheduleTask(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param scope This parameter is required.
     * @param id Descriptive identifier for this chainable. This parameter is required.
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public EventBridgeSchedulerCreateScheduleTask(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.stepfunctions.tasks.EventBridgeSchedulerCreateScheduleTaskProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Create an AWS EventBridge Scheduler schedule using JSONata.
     * <p>
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.stepfunctions.tasks.EventBridgeSchedulerCreateScheduleTask jsonata(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.stepfunctions.tasks.EventBridgeSchedulerCreateScheduleTaskJsonataProps props) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.stepfunctions.tasks.EventBridgeSchedulerCreateScheduleTask.class, "jsonata", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.stepfunctions.tasks.EventBridgeSchedulerCreateScheduleTask.class), new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Create an AWS EventBridge Scheduler schedule using JSONPath.
     * <p>
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.stepfunctions.tasks.EventBridgeSchedulerCreateScheduleTask jsonPath(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.stepfunctions.tasks.EventBridgeSchedulerCreateScheduleTaskJsonPathProps props) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.stepfunctions.tasks.EventBridgeSchedulerCreateScheduleTask.class, "jsonPath", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.stepfunctions.tasks.EventBridgeSchedulerCreateScheduleTask.class), new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.stepfunctions.TaskMetricsConfig getTaskMetrics() {
        return software.amazon.jsii.Kernel.get(this, "taskMetrics", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.stepfunctions.TaskMetricsConfig.class));
    }

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.services.iam.PolicyStatement> getTaskPolicies() {
        return java.util.Optional.ofNullable((java.util.List<software.amazon.awscdk.services.iam.PolicyStatement>)(software.amazon.jsii.Kernel.get(this, "taskPolicies", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.PolicyStatement.class))))).map(java.util.Collections::unmodifiableList).orElse(null);
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.stepfunctions.tasks.EventBridgeSchedulerCreateScheduleTask}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.stepfunctions.tasks.EventBridgeSchedulerCreateScheduleTask> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope This parameter is required.
         * @param id Descriptive identifier for this chainable. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.stepfunctions.tasks.EventBridgeSchedulerCreateScheduleTaskProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.stepfunctions.tasks.EventBridgeSchedulerCreateScheduleTaskProps.Builder();
        }

        /**
         * A comment describing this state.
         * <p>
         * Default: No comment
         * <p>
         * @return {@code this}
         * @param comment A comment describing this state. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder comment(final java.lang.String comment) {
            this.props.comment(comment);
            return this;
        }

        /**
         * The name of the query language used by the state.
         * <p>
         * If the state does not contain a <code>queryLanguage</code> field,
         * then it will use the query language specified in the top-level <code>queryLanguage</code> field.
         * <p>
         * Default: - JSONPath
         * <p>
         * @return {@code this}
         * @param queryLanguage The name of the query language used by the state. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder queryLanguage(final software.amazon.awscdk.services.stepfunctions.QueryLanguage queryLanguage) {
            this.props.queryLanguage(queryLanguage);
            return this;
        }

        /**
         * Optional name for this state.
         * <p>
         * Default: - The construct ID will be used as state name
         * <p>
         * @return {@code this}
         * @param stateName Optional name for this state. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder stateName(final java.lang.String stateName) {
            this.props.stateName(stateName);
            return this;
        }

        /**
         * Credentials for an IAM Role that the State Machine assumes for executing the task.
         * <p>
         * This enables cross-account resource invocations.
         * <p>
         * Default: - None (Task is executed using the State Machine's execution role)
         * <p>
         * @return {@code this}
         * @see <a href="https://docs.aws.amazon.com/step-functions/latest/dg/concepts-access-cross-acct-resources.html">https://docs.aws.amazon.com/step-functions/latest/dg/concepts-access-cross-acct-resources.html</a>
         * @param credentials Credentials for an IAM Role that the State Machine assumes for executing the task. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder credentials(final software.amazon.awscdk.services.stepfunctions.Credentials credentials) {
            this.props.credentials(credentials);
            return this;
        }

        /**
         * (deprecated) Timeout for the heartbeat.
         * <p>
         * Default: - None
         * <p>
         * @return {@code this}
         * @deprecated use <code>heartbeatTimeout</code>
         * @param heartbeat Timeout for the heartbeat. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
        @Deprecated
        public Builder heartbeat(final software.amazon.awscdk.Duration heartbeat) {
            this.props.heartbeat(heartbeat);
            return this;
        }

        /**
         * Timeout for the heartbeat.
         * <p>
         * [disable-awslint:duration-prop-type] is needed because all props interface in
         * aws-stepfunctions-tasks extend this interface
         * <p>
         * Default: - None
         * <p>
         * @return {@code this}
         * @param heartbeatTimeout Timeout for the heartbeat. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder heartbeatTimeout(final software.amazon.awscdk.services.stepfunctions.Timeout heartbeatTimeout) {
            this.props.heartbeatTimeout(heartbeatTimeout);
            return this;
        }

        /**
         * AWS Step Functions integrates with services directly in the Amazon States Language.
         * <p>
         * You can control these AWS services using service integration patterns.
         * <p>
         * Depending on the AWS Service, the Service Integration Pattern availability will vary.
         * <p>
         * Default: - `IntegrationPattern.REQUEST_RESPONSE` for most tasks.
         * `IntegrationPattern.RUN_JOB` for the following exceptions:
         * `BatchSubmitJob`, `EmrAddStep`, `EmrCreateCluster`, `EmrTerminationCluster`, and `EmrContainersStartJobRun`.
         * <p>
         * @return {@code this}
         * @see <a href="https://docs.aws.amazon.com/step-functions/latest/dg/connect-supported-services.html">https://docs.aws.amazon.com/step-functions/latest/dg/connect-supported-services.html</a>
         * @param integrationPattern AWS Step Functions integrates with services directly in the Amazon States Language. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder integrationPattern(final software.amazon.awscdk.services.stepfunctions.IntegrationPattern integrationPattern) {
            this.props.integrationPattern(integrationPattern);
            return this;
        }

        /**
         * Timeout for the task.
         * <p>
         * [disable-awslint:duration-prop-type] is needed because all props interface in
         * aws-stepfunctions-tasks extend this interface
         * <p>
         * Default: - None
         * <p>
         * @return {@code this}
         * @param taskTimeout Timeout for the task. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder taskTimeout(final software.amazon.awscdk.services.stepfunctions.Timeout taskTimeout) {
            this.props.taskTimeout(taskTimeout);
            return this;
        }

        /**
         * (deprecated) Timeout for the task.
         * <p>
         * Default: - None
         * <p>
         * @return {@code this}
         * @deprecated use <code>taskTimeout</code>
         * @param timeout Timeout for the task. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
        @Deprecated
        public Builder timeout(final software.amazon.awscdk.Duration timeout) {
            this.props.timeout(timeout);
            return this;
        }

        /**
         * Workflow variables to store in this step.
         * <p>
         * Using workflow variables, you can store data in a step and retrieve that data in future steps.
         * <p>
         * Default: - Not assign variables
         * <p>
         * @return {@code this}
         * @see <a href="https://docs.aws.amazon.com/ja_jp/step-functions/latest/dg/workflow-variables.html">https://docs.aws.amazon.com/ja_jp/step-functions/latest/dg/workflow-variables.html</a>
         * @param assign Workflow variables to store in this step. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder assign(final java.util.Map<java.lang.String, ? extends java.lang.Object> assign) {
            this.props.assign(assign);
            return this;
        }

        /**
         * JSONPath expression to select part of the state to be the input to this state.
         * <p>
         * May also be the special value JsonPath.DISCARD, which will cause the effective
         * input to be the empty object {}.
         * <p>
         * Default: $
         * <p>
         * @return {@code this}
         * @param inputPath JSONPath expression to select part of the state to be the input to this state. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder inputPath(final java.lang.String inputPath) {
            this.props.inputPath(inputPath);
            return this;
        }

        /**
         * JSONPath expression to select part of the state to be the output to this state.
         * <p>
         * May also be the special value JsonPath.DISCARD, which will cause the effective
         * output to be the empty object {}.
         * <p>
         * Default: $
         * <p>
         * @return {@code this}
         * @param outputPath JSONPath expression to select part of the state to be the output to this state. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder outputPath(final java.lang.String outputPath) {
            this.props.outputPath(outputPath);
            return this;
        }

        /**
         * Used to specify and transform output from the state.
         * <p>
         * When specified, the value overrides the state output default.
         * The output field accepts any JSON value (object, array, string, number, boolean, null).
         * Any string value, including those inside objects or arrays,
         * will be evaluated as JSONata if surrounded by {% %} characters.
         * Output also accepts a JSONata expression directly.
         * <p>
         * Default: - $states.result or $states.errorOutput
         * <p>
         * @return {@code this}
         * @see <a href="https://docs.aws.amazon.com/step-functions/latest/dg/concepts-input-output-filtering.html">https://docs.aws.amazon.com/step-functions/latest/dg/concepts-input-output-filtering.html</a>
         * @param outputs Used to specify and transform output from the state. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder outputs(final java.lang.Object outputs) {
            this.props.outputs(outputs);
            return this;
        }

        /**
         * JSONPath expression to indicate where to inject the state's output.
         * <p>
         * May also be the special value JsonPath.DISCARD, which will cause the state's
         * input to become its output.
         * <p>
         * Default: $
         * <p>
         * @return {@code this}
         * @param resultPath JSONPath expression to indicate where to inject the state's output. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder resultPath(final java.lang.String resultPath) {
            this.props.resultPath(resultPath);
            return this;
        }

        /**
         * The JSON that will replace the state's raw result and become the effective result before ResultPath is applied.
         * <p>
         * You can use ResultSelector to create a payload with values that are static
         * or selected from the state's raw result.
         * <p>
         * Default: - None
         * <p>
         * @return {@code this}
         * @see <a href="https://docs.aws.amazon.com/step-functions/latest/dg/input-output-inputpath-params.html#input-output-resultselector">https://docs.aws.amazon.com/step-functions/latest/dg/input-output-inputpath-params.html#input-output-resultselector</a>
         * @param resultSelector The JSON that will replace the state's raw result and become the effective result before ResultPath is applied. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder resultSelector(final java.util.Map<java.lang.String, ? extends java.lang.Object> resultSelector) {
            this.props.resultSelector(resultSelector);
            return this;
        }

        /**
         * The schedule that defines when the schedule will trigger.
         * <p>
         * @return {@code this}
         * @see <a href="https://docs.aws.amazon.com/scheduler/latest/UserGuide/schedule-types.html">https://docs.aws.amazon.com/scheduler/latest/UserGuide/schedule-types.html</a>
         * @param schedule The schedule that defines when the schedule will trigger. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder schedule(final software.amazon.awscdk.services.stepfunctions.tasks.Schedule schedule) {
            this.props.schedule(schedule);
            return this;
        }

        /**
         * Schedule name.
         * <p>
         * @return {@code this}
         * @param scheduleName Schedule name. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder scheduleName(final java.lang.String scheduleName) {
            this.props.scheduleName(scheduleName);
            return this;
        }

        /**
         * The schedule's target.
         * <p>
         * @return {@code this}
         * @param target The schedule's target. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder target(final software.amazon.awscdk.services.stepfunctions.tasks.EventBridgeSchedulerTarget target) {
            this.props.target(target);
            return this;
        }

        /**
         * Specifies the action that EventBridge Scheduler applies to the schedule after the schedule completes invoking the target.
         * <p>
         * Default: ActionAfterCompletion.NONE
         * <p>
         * @return {@code this}
         * @param actionAfterCompletion Specifies the action that EventBridge Scheduler applies to the schedule after the schedule completes invoking the target. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder actionAfterCompletion(final software.amazon.awscdk.services.stepfunctions.tasks.ActionAfterCompletion actionAfterCompletion) {
            this.props.actionAfterCompletion(actionAfterCompletion);
            return this;
        }

        /**
         * Unique, case-sensitive identifier to ensure the idempotency of the request.
         * <p>
         * Default: - Automatically generated
         * <p>
         * @return {@code this}
         * @param clientToken Unique, case-sensitive identifier to ensure the idempotency of the request. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder clientToken(final java.lang.String clientToken) {
            this.props.clientToken(clientToken);
            return this;
        }

        /**
         * The description for the schedule.
         * <p>
         * Default: - No description
         * <p>
         * @return {@code this}
         * @param description The description for the schedule. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder description(final java.lang.String description) {
            this.props.description(description);
            return this;
        }

        /**
         * Specifies whether the schedule is enabled or disabled.
         * <p>
         * Default: true
         * <p>
         * @return {@code this}
         * @param enabled Specifies whether the schedule is enabled or disabled. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder enabled(final java.lang.Boolean enabled) {
            this.props.enabled(enabled);
            return this;
        }

        /**
         * The date, in UTC, before which the schedule can invoke its target.
         * <p>
         * Depending on the schedule's recurrence expression, invocations might stop on, or before, the EndDate you specify.
         * EventBridge Scheduler ignores EndDate for one-time schedules.
         * <p>
         * Default: - No end date
         * <p>
         * @return {@code this}
         * @param endDate The date, in UTC, before which the schedule can invoke its target. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder endDate(final java.time.Instant endDate) {
            this.props.endDate(endDate);
            return this;
        }

        /**
         * The maximum time window during which a schedule can be invoked.
         * <p>
         * Minimum value is 1 minute.
         * Maximum value is 1440 minutes (1 day).
         * <p>
         * Default: - Flexible time window is not enabled.
         * <p>
         * @return {@code this}
         * @param flexibleTimeWindow The maximum time window during which a schedule can be invoked. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder flexibleTimeWindow(final software.amazon.awscdk.Duration flexibleTimeWindow) {
            this.props.flexibleTimeWindow(flexibleTimeWindow);
            return this;
        }

        /**
         * The name of the schedule group to associate with this schedule.
         * <p>
         * Default: - The default schedule group is used.
         * <p>
         * @return {@code this}
         * @param groupName The name of the schedule group to associate with this schedule. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder groupName(final java.lang.String groupName) {
            this.props.groupName(groupName);
            return this;
        }

        /**
         * The customer managed KMS key that EventBridge Scheduler will use to encrypt and decrypt payload.
         * <p>
         * Default: - Use automatically generated KMS key
         * <p>
         * @return {@code this}
         * @see <a href="https://docs.aws.amazon.com/scheduler/latest/UserGuide/encryption-rest.html">https://docs.aws.amazon.com/scheduler/latest/UserGuide/encryption-rest.html</a>
         * @param kmsKey The customer managed KMS key that EventBridge Scheduler will use to encrypt and decrypt payload. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder kmsKey(final software.amazon.awscdk.services.kms.IKey kmsKey) {
            this.props.kmsKey(kmsKey);
            return this;
        }

        /**
         * The date, in UTC, after which the schedule can begin invoking its target.
         * <p>
         * Depending on the schedule's recurrence expression, invocations might occur on, or after, the StartDate you specify.
         * EventBridge Scheduler ignores StartDate for one-time schedules.
         * <p>
         * Default: - No start date
         * <p>
         * @return {@code this}
         * @param startDate The date, in UTC, after which the schedule can begin invoking its target. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder startDate(final java.time.Instant startDate) {
            this.props.startDate(startDate);
            return this;
        }

        /**
         * The timezone in which the scheduling expression is evaluated.
         * <p>
         * Default: - UTC
         * <p>
         * @return {@code this}
         * @param timezone The timezone in which the scheduling expression is evaluated. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder timezone(final java.lang.String timezone) {
            this.props.timezone(timezone);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.stepfunctions.tasks.EventBridgeSchedulerCreateScheduleTask}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.stepfunctions.tasks.EventBridgeSchedulerCreateScheduleTask build() {
            return new software.amazon.awscdk.services.stepfunctions.tasks.EventBridgeSchedulerCreateScheduleTask(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
