package software.amazon.awscdk.services.stepfunctions.tasks;

/**
 * Properties for calling an external HTTP endpoint with HttpInvoke using JSONata.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * import software.amazon.awscdk.services.events.*;
 * Connection connection;
 * HttpInvoke getIssue = HttpInvoke.jsonata(this, "Get Issue", HttpInvokeJsonataProps.builder()
 *         .connection(connection)
 *         .apiRoot("{% 'https://' &amp; $states.input.hostname %}")
 *         .apiEndpoint(TaskInput.fromText("{% 'issues/' &amp; $states.input.issue.id %}"))
 *         .method(TaskInput.fromText("GET"))
 *         // Parse the API call result to object and set to the variables
 *         .assign(Map.of(
 *                 "hostname", "{% $states.input.hostname %}",
 *                 "issue", "{% $parse($states.result.ResponseBody) %}"))
 *         .build());
 * HttpInvoke updateLabels = HttpInvoke.jsonata(this, "Update Issue Labels", HttpInvokeJsonataProps.builder()
 *         .connection(connection)
 *         .apiRoot("{% 'https://' &amp; $states.input.hostname %}")
 *         .apiEndpoint(TaskInput.fromText("{% 'issues/' &amp; $states.input.issue.id &amp; 'labels' %}"))
 *         .method(TaskInput.fromText("POST"))
 *         .body(TaskInput.fromObject(Map.of(
 *                 "labels", "{% [$type, $component] %}")))
 *         .build());
 * Pass notMatchTitleTemplate = Pass.jsonata(this, "Not Match Title Template");
 * Chain definition = getIssue.next(Choice.jsonata(this, "Match Title Template?").when(Condition.jsonata("{% $contains($issue.title, /(feat)|(fix)|(chore)(w*):.*&#47;) %}"), updateLabels, ChoiceTransitionOptions.builder()
 *         .assign(Map.of(
 *                 "type", "{% $match($states.input.title, /(w*)((.*))/).groups[0] %}",
 *                 "component", "{% $match($states.input.title, /(w*)((.*))/).groups[1] %}"))
 *         .build()).otherwise(notMatchTitleTemplate));
 * StateMachine.Builder.create(this, "StateMachine")
 *         .definitionBody(DefinitionBody.fromChainable(definition))
 *         .timeout(Duration.minutes(5))
 *         .comment("automate issue labeling state machine")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.106.0 (build e852934)", date = "2025-02-17T19:20:38.166Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_stepfunctions_tasks.HttpInvokeJsonataProps")
@software.amazon.jsii.Jsii.Proxy(HttpInvokeJsonataProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface HttpInvokeJsonataProps extends software.amazon.jsii.JsiiSerializable, software.amazon.awscdk.services.stepfunctions.TaskStateJsonataBaseProps {

    /**
     * The API endpoint to call, relative to <code>apiRoot</code>.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * TaskInput.fromText("path/to/resource");
     * </pre></blockquote>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.stepfunctions.TaskInput getApiEndpoint();

    /**
     * Permissions are granted to call all resources under this path.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * "https://api.example.com";
     * </pre></blockquote>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getApiRoot();

    /**
     * The EventBridge Connection to use for authentication.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.events.IConnection getConnection();

    /**
     * The HTTP method to use.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * TaskInput.fromText("GET");
     * </pre></blockquote>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.stepfunctions.TaskInput getMethod();

    /**
     * The body to send to the HTTP endpoint.
     * <p>
     * Default: - No body is sent with the request.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.stepfunctions.TaskInput getBody() {
        return null;
    }

    /**
     * The headers to send to the HTTP endpoint.
     * <p>
     * Default: - No additional headers are added to the request.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * TaskInput.fromObject(Map.of("Content-Type", "application/json"));
     * </pre></blockquote>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.stepfunctions.TaskInput getHeaders() {
        return null;
    }

    /**
     * The query string parameters to send to the HTTP endpoint.
     * <p>
     * Default: - No query string parameters are sent in the request.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.stepfunctions.TaskInput getQueryStringParameters() {
        return null;
    }

    /**
     * Determines whether to apply URL encoding to the request body, and which array encoding format to use.
     * <p>
     * <code>URLEncodingFormat.NONE</code> passes the JSON-serialized <code>RequestBody</code> field as the HTTP request body.
     * Otherwise, the HTTP request body is the URL-encoded form data of the <code>RequestBody</code> field using the
     * specified array encoding format, and the <code>Content-Type</code> header is set to <code>application/x-www-form-urlencoded</code>.
     * <p>
     * Default: - URLEncodingFormat.NONE
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.stepfunctions.tasks.URLEncodingFormat getUrlEncodingFormat() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link HttpInvokeJsonataProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link HttpInvokeJsonataProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<HttpInvokeJsonataProps> {
        software.amazon.awscdk.services.stepfunctions.TaskInput apiEndpoint;
        java.lang.String apiRoot;
        software.amazon.awscdk.services.events.IConnection connection;
        software.amazon.awscdk.services.stepfunctions.TaskInput method;
        software.amazon.awscdk.services.stepfunctions.TaskInput body;
        software.amazon.awscdk.services.stepfunctions.TaskInput headers;
        software.amazon.awscdk.services.stepfunctions.TaskInput queryStringParameters;
        software.amazon.awscdk.services.stepfunctions.tasks.URLEncodingFormat urlEncodingFormat;
        java.lang.String comment;
        software.amazon.awscdk.services.stepfunctions.QueryLanguage queryLanguage;
        java.lang.String stateName;
        software.amazon.awscdk.services.stepfunctions.Credentials credentials;
        software.amazon.awscdk.Duration heartbeat;
        software.amazon.awscdk.services.stepfunctions.Timeout heartbeatTimeout;
        software.amazon.awscdk.services.stepfunctions.IntegrationPattern integrationPattern;
        software.amazon.awscdk.services.stepfunctions.Timeout taskTimeout;
        software.amazon.awscdk.Duration timeout;
        java.util.Map<java.lang.String, java.lang.Object> assign;
        java.lang.Object outputs;

        /**
         * Sets the value of {@link HttpInvokeJsonataProps#getApiEndpoint}
         * @param apiEndpoint The API endpoint to call, relative to <code>apiRoot</code>. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder apiEndpoint(software.amazon.awscdk.services.stepfunctions.TaskInput apiEndpoint) {
            this.apiEndpoint = apiEndpoint;
            return this;
        }

        /**
         * Sets the value of {@link HttpInvokeJsonataProps#getApiRoot}
         * @param apiRoot Permissions are granted to call all resources under this path. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder apiRoot(java.lang.String apiRoot) {
            this.apiRoot = apiRoot;
            return this;
        }

        /**
         * Sets the value of {@link HttpInvokeJsonataProps#getConnection}
         * @param connection The EventBridge Connection to use for authentication. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder connection(software.amazon.awscdk.services.events.IConnection connection) {
            this.connection = connection;
            return this;
        }

        /**
         * Sets the value of {@link HttpInvokeJsonataProps#getMethod}
         * @param method The HTTP method to use. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder method(software.amazon.awscdk.services.stepfunctions.TaskInput method) {
            this.method = method;
            return this;
        }

        /**
         * Sets the value of {@link HttpInvokeJsonataProps#getBody}
         * @param body The body to send to the HTTP endpoint.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder body(software.amazon.awscdk.services.stepfunctions.TaskInput body) {
            this.body = body;
            return this;
        }

        /**
         * Sets the value of {@link HttpInvokeJsonataProps#getHeaders}
         * @param headers The headers to send to the HTTP endpoint.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder headers(software.amazon.awscdk.services.stepfunctions.TaskInput headers) {
            this.headers = headers;
            return this;
        }

        /**
         * Sets the value of {@link HttpInvokeJsonataProps#getQueryStringParameters}
         * @param queryStringParameters The query string parameters to send to the HTTP endpoint.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder queryStringParameters(software.amazon.awscdk.services.stepfunctions.TaskInput queryStringParameters) {
            this.queryStringParameters = queryStringParameters;
            return this;
        }

        /**
         * Sets the value of {@link HttpInvokeJsonataProps#getUrlEncodingFormat}
         * @param urlEncodingFormat Determines whether to apply URL encoding to the request body, and which array encoding format to use.
         *                          <code>URLEncodingFormat.NONE</code> passes the JSON-serialized <code>RequestBody</code> field as the HTTP request body.
         *                          Otherwise, the HTTP request body is the URL-encoded form data of the <code>RequestBody</code> field using the
         *                          specified array encoding format, and the <code>Content-Type</code> header is set to <code>application/x-www-form-urlencoded</code>.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder urlEncodingFormat(software.amazon.awscdk.services.stepfunctions.tasks.URLEncodingFormat urlEncodingFormat) {
            this.urlEncodingFormat = urlEncodingFormat;
            return this;
        }

        /**
         * Sets the value of {@link HttpInvokeJsonataProps#getComment}
         * @param comment A comment describing this state.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder comment(java.lang.String comment) {
            this.comment = comment;
            return this;
        }

        /**
         * Sets the value of {@link HttpInvokeJsonataProps#getQueryLanguage}
         * @param queryLanguage The name of the query language used by the state.
         *                      If the state does not contain a <code>queryLanguage</code> field,
         *                      then it will use the query language specified in the top-level <code>queryLanguage</code> field.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder queryLanguage(software.amazon.awscdk.services.stepfunctions.QueryLanguage queryLanguage) {
            this.queryLanguage = queryLanguage;
            return this;
        }

        /**
         * Sets the value of {@link HttpInvokeJsonataProps#getStateName}
         * @param stateName Optional name for this state.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder stateName(java.lang.String stateName) {
            this.stateName = stateName;
            return this;
        }

        /**
         * Sets the value of {@link HttpInvokeJsonataProps#getCredentials}
         * @param credentials Credentials for an IAM Role that the State Machine assumes for executing the task.
         *                    This enables cross-account resource invocations.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder credentials(software.amazon.awscdk.services.stepfunctions.Credentials credentials) {
            this.credentials = credentials;
            return this;
        }

        /**
         * Sets the value of {@link HttpInvokeJsonataProps#getHeartbeat}
         * @param heartbeat Timeout for the heartbeat.
         * @return {@code this}
         * @deprecated use `heartbeatTimeout`
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
        @Deprecated
        public Builder heartbeat(software.amazon.awscdk.Duration heartbeat) {
            this.heartbeat = heartbeat;
            return this;
        }

        /**
         * Sets the value of {@link HttpInvokeJsonataProps#getHeartbeatTimeout}
         * @param heartbeatTimeout Timeout for the heartbeat.
         *                         [disable-awslint:duration-prop-type] is needed because all props interface in
         *                         aws-stepfunctions-tasks extend this interface
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder heartbeatTimeout(software.amazon.awscdk.services.stepfunctions.Timeout heartbeatTimeout) {
            this.heartbeatTimeout = heartbeatTimeout;
            return this;
        }

        /**
         * Sets the value of {@link HttpInvokeJsonataProps#getIntegrationPattern}
         * @param integrationPattern AWS Step Functions integrates with services directly in the Amazon States Language.
         *                           You can control these AWS services using service integration patterns.
         *                           <p>
         *                           Depending on the AWS Service, the Service Integration Pattern availability will vary.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder integrationPattern(software.amazon.awscdk.services.stepfunctions.IntegrationPattern integrationPattern) {
            this.integrationPattern = integrationPattern;
            return this;
        }

        /**
         * Sets the value of {@link HttpInvokeJsonataProps#getTaskTimeout}
         * @param taskTimeout Timeout for the task.
         *                    [disable-awslint:duration-prop-type] is needed because all props interface in
         *                    aws-stepfunctions-tasks extend this interface
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder taskTimeout(software.amazon.awscdk.services.stepfunctions.Timeout taskTimeout) {
            this.taskTimeout = taskTimeout;
            return this;
        }

        /**
         * Sets the value of {@link HttpInvokeJsonataProps#getTimeout}
         * @param timeout Timeout for the task.
         * @return {@code this}
         * @deprecated use `taskTimeout`
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
        @Deprecated
        public Builder timeout(software.amazon.awscdk.Duration timeout) {
            this.timeout = timeout;
            return this;
        }

        /**
         * Sets the value of {@link HttpInvokeJsonataProps#getAssign}
         * @param assign Workflow variables to store in this step.
         *               Using workflow variables, you can store data in a step and retrieve that data in future steps.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder assign(java.util.Map<java.lang.String, ? extends java.lang.Object> assign) {
            this.assign = (java.util.Map<java.lang.String, java.lang.Object>)assign;
            return this;
        }

        /**
         * Sets the value of {@link HttpInvokeJsonataProps#getOutputs}
         * @param outputs Used to specify and transform output from the state.
         *                When specified, the value overrides the state output default.
         *                The output field accepts any JSON value (object, array, string, number, boolean, null).
         *                Any string value, including those inside objects or arrays,
         *                will be evaluated as JSONata if surrounded by {% %} characters.
         *                Output also accepts a JSONata expression directly.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder outputs(java.lang.Object outputs) {
            this.outputs = outputs;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link HttpInvokeJsonataProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public HttpInvokeJsonataProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link HttpInvokeJsonataProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements HttpInvokeJsonataProps {
        private final software.amazon.awscdk.services.stepfunctions.TaskInput apiEndpoint;
        private final java.lang.String apiRoot;
        private final software.amazon.awscdk.services.events.IConnection connection;
        private final software.amazon.awscdk.services.stepfunctions.TaskInput method;
        private final software.amazon.awscdk.services.stepfunctions.TaskInput body;
        private final software.amazon.awscdk.services.stepfunctions.TaskInput headers;
        private final software.amazon.awscdk.services.stepfunctions.TaskInput queryStringParameters;
        private final software.amazon.awscdk.services.stepfunctions.tasks.URLEncodingFormat urlEncodingFormat;
        private final java.lang.String comment;
        private final software.amazon.awscdk.services.stepfunctions.QueryLanguage queryLanguage;
        private final java.lang.String stateName;
        private final software.amazon.awscdk.services.stepfunctions.Credentials credentials;
        private final software.amazon.awscdk.Duration heartbeat;
        private final software.amazon.awscdk.services.stepfunctions.Timeout heartbeatTimeout;
        private final software.amazon.awscdk.services.stepfunctions.IntegrationPattern integrationPattern;
        private final software.amazon.awscdk.services.stepfunctions.Timeout taskTimeout;
        private final software.amazon.awscdk.Duration timeout;
        private final java.util.Map<java.lang.String, java.lang.Object> assign;
        private final java.lang.Object outputs;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.apiEndpoint = software.amazon.jsii.Kernel.get(this, "apiEndpoint", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.stepfunctions.TaskInput.class));
            this.apiRoot = software.amazon.jsii.Kernel.get(this, "apiRoot", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.connection = software.amazon.jsii.Kernel.get(this, "connection", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.events.IConnection.class));
            this.method = software.amazon.jsii.Kernel.get(this, "method", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.stepfunctions.TaskInput.class));
            this.body = software.amazon.jsii.Kernel.get(this, "body", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.stepfunctions.TaskInput.class));
            this.headers = software.amazon.jsii.Kernel.get(this, "headers", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.stepfunctions.TaskInput.class));
            this.queryStringParameters = software.amazon.jsii.Kernel.get(this, "queryStringParameters", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.stepfunctions.TaskInput.class));
            this.urlEncodingFormat = software.amazon.jsii.Kernel.get(this, "urlEncodingFormat", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.stepfunctions.tasks.URLEncodingFormat.class));
            this.comment = software.amazon.jsii.Kernel.get(this, "comment", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.queryLanguage = software.amazon.jsii.Kernel.get(this, "queryLanguage", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.stepfunctions.QueryLanguage.class));
            this.stateName = software.amazon.jsii.Kernel.get(this, "stateName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.credentials = software.amazon.jsii.Kernel.get(this, "credentials", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.stepfunctions.Credentials.class));
            this.heartbeat = software.amazon.jsii.Kernel.get(this, "heartbeat", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.Duration.class));
            this.heartbeatTimeout = software.amazon.jsii.Kernel.get(this, "heartbeatTimeout", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.stepfunctions.Timeout.class));
            this.integrationPattern = software.amazon.jsii.Kernel.get(this, "integrationPattern", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.stepfunctions.IntegrationPattern.class));
            this.taskTimeout = software.amazon.jsii.Kernel.get(this, "taskTimeout", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.stepfunctions.Timeout.class));
            this.timeout = software.amazon.jsii.Kernel.get(this, "timeout", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.Duration.class));
            this.assign = software.amazon.jsii.Kernel.get(this, "assign", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)));
            this.outputs = software.amazon.jsii.Kernel.get(this, "outputs", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.apiEndpoint = java.util.Objects.requireNonNull(builder.apiEndpoint, "apiEndpoint is required");
            this.apiRoot = java.util.Objects.requireNonNull(builder.apiRoot, "apiRoot is required");
            this.connection = java.util.Objects.requireNonNull(builder.connection, "connection is required");
            this.method = java.util.Objects.requireNonNull(builder.method, "method is required");
            this.body = builder.body;
            this.headers = builder.headers;
            this.queryStringParameters = builder.queryStringParameters;
            this.urlEncodingFormat = builder.urlEncodingFormat;
            this.comment = builder.comment;
            this.queryLanguage = builder.queryLanguage;
            this.stateName = builder.stateName;
            this.credentials = builder.credentials;
            this.heartbeat = builder.heartbeat;
            this.heartbeatTimeout = builder.heartbeatTimeout;
            this.integrationPattern = builder.integrationPattern;
            this.taskTimeout = builder.taskTimeout;
            this.timeout = builder.timeout;
            this.assign = (java.util.Map<java.lang.String, java.lang.Object>)builder.assign;
            this.outputs = builder.outputs;
        }

        @Override
        public final software.amazon.awscdk.services.stepfunctions.TaskInput getApiEndpoint() {
            return this.apiEndpoint;
        }

        @Override
        public final java.lang.String getApiRoot() {
            return this.apiRoot;
        }

        @Override
        public final software.amazon.awscdk.services.events.IConnection getConnection() {
            return this.connection;
        }

        @Override
        public final software.amazon.awscdk.services.stepfunctions.TaskInput getMethod() {
            return this.method;
        }

        @Override
        public final software.amazon.awscdk.services.stepfunctions.TaskInput getBody() {
            return this.body;
        }

        @Override
        public final software.amazon.awscdk.services.stepfunctions.TaskInput getHeaders() {
            return this.headers;
        }

        @Override
        public final software.amazon.awscdk.services.stepfunctions.TaskInput getQueryStringParameters() {
            return this.queryStringParameters;
        }

        @Override
        public final software.amazon.awscdk.services.stepfunctions.tasks.URLEncodingFormat getUrlEncodingFormat() {
            return this.urlEncodingFormat;
        }

        @Override
        public final java.lang.String getComment() {
            return this.comment;
        }

        @Override
        public final software.amazon.awscdk.services.stepfunctions.QueryLanguage getQueryLanguage() {
            return this.queryLanguage;
        }

        @Override
        public final java.lang.String getStateName() {
            return this.stateName;
        }

        @Override
        public final software.amazon.awscdk.services.stepfunctions.Credentials getCredentials() {
            return this.credentials;
        }

        @Override
        public final software.amazon.awscdk.Duration getHeartbeat() {
            return this.heartbeat;
        }

        @Override
        public final software.amazon.awscdk.services.stepfunctions.Timeout getHeartbeatTimeout() {
            return this.heartbeatTimeout;
        }

        @Override
        public final software.amazon.awscdk.services.stepfunctions.IntegrationPattern getIntegrationPattern() {
            return this.integrationPattern;
        }

        @Override
        public final software.amazon.awscdk.services.stepfunctions.Timeout getTaskTimeout() {
            return this.taskTimeout;
        }

        @Override
        public final software.amazon.awscdk.Duration getTimeout() {
            return this.timeout;
        }

        @Override
        public final java.util.Map<java.lang.String, java.lang.Object> getAssign() {
            return this.assign;
        }

        @Override
        public final java.lang.Object getOutputs() {
            return this.outputs;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("apiEndpoint", om.valueToTree(this.getApiEndpoint()));
            data.set("apiRoot", om.valueToTree(this.getApiRoot()));
            data.set("connection", om.valueToTree(this.getConnection()));
            data.set("method", om.valueToTree(this.getMethod()));
            if (this.getBody() != null) {
                data.set("body", om.valueToTree(this.getBody()));
            }
            if (this.getHeaders() != null) {
                data.set("headers", om.valueToTree(this.getHeaders()));
            }
            if (this.getQueryStringParameters() != null) {
                data.set("queryStringParameters", om.valueToTree(this.getQueryStringParameters()));
            }
            if (this.getUrlEncodingFormat() != null) {
                data.set("urlEncodingFormat", om.valueToTree(this.getUrlEncodingFormat()));
            }
            if (this.getComment() != null) {
                data.set("comment", om.valueToTree(this.getComment()));
            }
            if (this.getQueryLanguage() != null) {
                data.set("queryLanguage", om.valueToTree(this.getQueryLanguage()));
            }
            if (this.getStateName() != null) {
                data.set("stateName", om.valueToTree(this.getStateName()));
            }
            if (this.getCredentials() != null) {
                data.set("credentials", om.valueToTree(this.getCredentials()));
            }
            if (this.getHeartbeat() != null) {
                data.set("heartbeat", om.valueToTree(this.getHeartbeat()));
            }
            if (this.getHeartbeatTimeout() != null) {
                data.set("heartbeatTimeout", om.valueToTree(this.getHeartbeatTimeout()));
            }
            if (this.getIntegrationPattern() != null) {
                data.set("integrationPattern", om.valueToTree(this.getIntegrationPattern()));
            }
            if (this.getTaskTimeout() != null) {
                data.set("taskTimeout", om.valueToTree(this.getTaskTimeout()));
            }
            if (this.getTimeout() != null) {
                data.set("timeout", om.valueToTree(this.getTimeout()));
            }
            if (this.getAssign() != null) {
                data.set("assign", om.valueToTree(this.getAssign()));
            }
            if (this.getOutputs() != null) {
                data.set("outputs", om.valueToTree(this.getOutputs()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_stepfunctions_tasks.HttpInvokeJsonataProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            HttpInvokeJsonataProps.Jsii$Proxy that = (HttpInvokeJsonataProps.Jsii$Proxy) o;

            if (!apiEndpoint.equals(that.apiEndpoint)) return false;
            if (!apiRoot.equals(that.apiRoot)) return false;
            if (!connection.equals(that.connection)) return false;
            if (!method.equals(that.method)) return false;
            if (this.body != null ? !this.body.equals(that.body) : that.body != null) return false;
            if (this.headers != null ? !this.headers.equals(that.headers) : that.headers != null) return false;
            if (this.queryStringParameters != null ? !this.queryStringParameters.equals(that.queryStringParameters) : that.queryStringParameters != null) return false;
            if (this.urlEncodingFormat != null ? !this.urlEncodingFormat.equals(that.urlEncodingFormat) : that.urlEncodingFormat != null) return false;
            if (this.comment != null ? !this.comment.equals(that.comment) : that.comment != null) return false;
            if (this.queryLanguage != null ? !this.queryLanguage.equals(that.queryLanguage) : that.queryLanguage != null) return false;
            if (this.stateName != null ? !this.stateName.equals(that.stateName) : that.stateName != null) return false;
            if (this.credentials != null ? !this.credentials.equals(that.credentials) : that.credentials != null) return false;
            if (this.heartbeat != null ? !this.heartbeat.equals(that.heartbeat) : that.heartbeat != null) return false;
            if (this.heartbeatTimeout != null ? !this.heartbeatTimeout.equals(that.heartbeatTimeout) : that.heartbeatTimeout != null) return false;
            if (this.integrationPattern != null ? !this.integrationPattern.equals(that.integrationPattern) : that.integrationPattern != null) return false;
            if (this.taskTimeout != null ? !this.taskTimeout.equals(that.taskTimeout) : that.taskTimeout != null) return false;
            if (this.timeout != null ? !this.timeout.equals(that.timeout) : that.timeout != null) return false;
            if (this.assign != null ? !this.assign.equals(that.assign) : that.assign != null) return false;
            return this.outputs != null ? this.outputs.equals(that.outputs) : that.outputs == null;
        }

        @Override
        public final int hashCode() {
            int result = this.apiEndpoint.hashCode();
            result = 31 * result + (this.apiRoot.hashCode());
            result = 31 * result + (this.connection.hashCode());
            result = 31 * result + (this.method.hashCode());
            result = 31 * result + (this.body != null ? this.body.hashCode() : 0);
            result = 31 * result + (this.headers != null ? this.headers.hashCode() : 0);
            result = 31 * result + (this.queryStringParameters != null ? this.queryStringParameters.hashCode() : 0);
            result = 31 * result + (this.urlEncodingFormat != null ? this.urlEncodingFormat.hashCode() : 0);
            result = 31 * result + (this.comment != null ? this.comment.hashCode() : 0);
            result = 31 * result + (this.queryLanguage != null ? this.queryLanguage.hashCode() : 0);
            result = 31 * result + (this.stateName != null ? this.stateName.hashCode() : 0);
            result = 31 * result + (this.credentials != null ? this.credentials.hashCode() : 0);
            result = 31 * result + (this.heartbeat != null ? this.heartbeat.hashCode() : 0);
            result = 31 * result + (this.heartbeatTimeout != null ? this.heartbeatTimeout.hashCode() : 0);
            result = 31 * result + (this.integrationPattern != null ? this.integrationPattern.hashCode() : 0);
            result = 31 * result + (this.taskTimeout != null ? this.taskTimeout.hashCode() : 0);
            result = 31 * result + (this.timeout != null ? this.timeout.hashCode() : 0);
            result = 31 * result + (this.assign != null ? this.assign.hashCode() : 0);
            result = 31 * result + (this.outputs != null ? this.outputs.hashCode() : 0);
            return result;
        }
    }
}
