package software.amazon.awscdk.services.waf.regional;

/**
 * Properties for defining a <code>CfnIPSet</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.waf.regional.*;
 * CfnIPSetProps cfnIPSetProps = CfnIPSetProps.builder()
 *         .name("name")
 *         // the properties below are optional
 *         .ipSetDescriptors(List.of(Map.of(
 *                 "type", "type",
 *                 "value", "value")))
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wafregional-ipset.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wafregional-ipset.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.106.0 (build e852934)", date = "2025-02-17T19:20:38.551Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_wafregional.CfnIPSetProps")
@software.amazon.jsii.Jsii.Proxy(CfnIPSetProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnIPSetProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * A friendly name or description of the <code>IPSet</code> .
     * <p>
     * You can't change the name of an <code>IPSet</code> after you create it.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wafregional-ipset.html#cfn-wafregional-ipset-name">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wafregional-ipset.html#cfn-wafregional-ipset-name</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getName();

    /**
     * The IP address type ( <code>IPV4</code> or <code>IPV6</code> ) and the IP address range (in CIDR notation) that web requests originate from.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wafregional-ipset.html#cfn-wafregional-ipset-ipsetdescriptors">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wafregional-ipset.html#cfn-wafregional-ipset-ipsetdescriptors</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getIpSetDescriptors() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnIPSetProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnIPSetProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnIPSetProps> {
        java.lang.String name;
        java.lang.Object ipSetDescriptors;

        /**
         * Sets the value of {@link CfnIPSetProps#getName}
         * @param name A friendly name or description of the <code>IPSet</code> . This parameter is required.
         *             You can't change the name of an <code>IPSet</code> after you create it.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder name(java.lang.String name) {
            this.name = name;
            return this;
        }

        /**
         * Sets the value of {@link CfnIPSetProps#getIpSetDescriptors}
         * @param ipSetDescriptors The IP address type ( <code>IPV4</code> or <code>IPV6</code> ) and the IP address range (in CIDR notation) that web requests originate from.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder ipSetDescriptors(software.amazon.awscdk.IResolvable ipSetDescriptors) {
            this.ipSetDescriptors = ipSetDescriptors;
            return this;
        }

        /**
         * Sets the value of {@link CfnIPSetProps#getIpSetDescriptors}
         * @param ipSetDescriptors The IP address type ( <code>IPV4</code> or <code>IPV6</code> ) and the IP address range (in CIDR notation) that web requests originate from.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder ipSetDescriptors(java.util.List<? extends java.lang.Object> ipSetDescriptors) {
            this.ipSetDescriptors = ipSetDescriptors;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnIPSetProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnIPSetProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnIPSetProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnIPSetProps {
        private final java.lang.String name;
        private final java.lang.Object ipSetDescriptors;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.ipSetDescriptors = software.amazon.jsii.Kernel.get(this, "ipSetDescriptors", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.name = java.util.Objects.requireNonNull(builder.name, "name is required");
            this.ipSetDescriptors = builder.ipSetDescriptors;
        }

        @Override
        public final java.lang.String getName() {
            return this.name;
        }

        @Override
        public final java.lang.Object getIpSetDescriptors() {
            return this.ipSetDescriptors;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("name", om.valueToTree(this.getName()));
            if (this.getIpSetDescriptors() != null) {
                data.set("ipSetDescriptors", om.valueToTree(this.getIpSetDescriptors()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_wafregional.CfnIPSetProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnIPSetProps.Jsii$Proxy that = (CfnIPSetProps.Jsii$Proxy) o;

            if (!name.equals(that.name)) return false;
            return this.ipSetDescriptors != null ? this.ipSetDescriptors.equals(that.ipSetDescriptors) : that.ipSetDescriptors == null;
        }

        @Override
        public final int hashCode() {
            int result = this.name.hashCode();
            result = 31 * result + (this.ipSetDescriptors != null ? this.ipSetDescriptors.hashCode() : 0);
            return result;
        }
    }
}
