package software.amazon.awscdk.services.waf.regional;

/**
 * Properties for defining a <code>CfnXssMatchSet</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.waf.regional.*;
 * CfnXssMatchSetProps cfnXssMatchSetProps = CfnXssMatchSetProps.builder()
 *         .name("name")
 *         // the properties below are optional
 *         .xssMatchTuples(List.of(XssMatchTupleProperty.builder()
 *                 .fieldToMatch(FieldToMatchProperty.builder()
 *                         .type("type")
 *                         // the properties below are optional
 *                         .data("data")
 *                         .build())
 *                 .textTransformation("textTransformation")
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wafregional-xssmatchset.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wafregional-xssmatchset.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.106.0 (build e852934)", date = "2025-02-17T19:20:38.581Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_wafregional.CfnXssMatchSetProps")
@software.amazon.jsii.Jsii.Proxy(CfnXssMatchSetProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnXssMatchSetProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The name, if any, of the <code>XssMatchSet</code> .
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wafregional-xssmatchset.html#cfn-wafregional-xssmatchset-name">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wafregional-xssmatchset.html#cfn-wafregional-xssmatchset-name</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getName();

    /**
     * Specifies the parts of web requests that you want to inspect for cross-site scripting attacks.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wafregional-xssmatchset.html#cfn-wafregional-xssmatchset-xssmatchtuples">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-wafregional-xssmatchset.html#cfn-wafregional-xssmatchset-xssmatchtuples</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getXssMatchTuples() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnXssMatchSetProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnXssMatchSetProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnXssMatchSetProps> {
        java.lang.String name;
        java.lang.Object xssMatchTuples;

        /**
         * Sets the value of {@link CfnXssMatchSetProps#getName}
         * @param name The name, if any, of the <code>XssMatchSet</code> . This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder name(java.lang.String name) {
            this.name = name;
            return this;
        }

        /**
         * Sets the value of {@link CfnXssMatchSetProps#getXssMatchTuples}
         * @param xssMatchTuples Specifies the parts of web requests that you want to inspect for cross-site scripting attacks.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder xssMatchTuples(software.amazon.awscdk.IResolvable xssMatchTuples) {
            this.xssMatchTuples = xssMatchTuples;
            return this;
        }

        /**
         * Sets the value of {@link CfnXssMatchSetProps#getXssMatchTuples}
         * @param xssMatchTuples Specifies the parts of web requests that you want to inspect for cross-site scripting attacks.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder xssMatchTuples(java.util.List<? extends java.lang.Object> xssMatchTuples) {
            this.xssMatchTuples = xssMatchTuples;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnXssMatchSetProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnXssMatchSetProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnXssMatchSetProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnXssMatchSetProps {
        private final java.lang.String name;
        private final java.lang.Object xssMatchTuples;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.xssMatchTuples = software.amazon.jsii.Kernel.get(this, "xssMatchTuples", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.name = java.util.Objects.requireNonNull(builder.name, "name is required");
            this.xssMatchTuples = builder.xssMatchTuples;
        }

        @Override
        public final java.lang.String getName() {
            return this.name;
        }

        @Override
        public final java.lang.Object getXssMatchTuples() {
            return this.xssMatchTuples;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("name", om.valueToTree(this.getName()));
            if (this.getXssMatchTuples() != null) {
                data.set("xssMatchTuples", om.valueToTree(this.getXssMatchTuples()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_wafregional.CfnXssMatchSetProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnXssMatchSetProps.Jsii$Proxy that = (CfnXssMatchSetProps.Jsii$Proxy) o;

            if (!name.equals(that.name)) return false;
            return this.xssMatchTuples != null ? this.xssMatchTuples.equals(that.xssMatchTuples) : that.xssMatchTuples == null;
        }

        @Override
        public final int hashCode() {
            int result = this.name.hashCode();
            result = 31 * result + (this.xssMatchTuples != null ? this.xssMatchTuples.hashCode() : 0);
            return result;
        }
    }
}
