/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.batch;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.amazon.awscdk.$Module;
import software.amazon.awscdk.Duration;
import software.amazon.awscdk.Resource;
import software.amazon.awscdk.services.batch.IJobDefinition;
import software.amazon.awscdk.services.batch.MultiNodeContainer;
import software.amazon.awscdk.services.batch.MultiNodeJobDefinitionProps;
import software.amazon.awscdk.services.batch.RetryStrategy;
import software.amazon.awscdk.services.ec2.InstanceType;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiEngine;
import software.amazon.jsii.JsiiObject;
import software.amazon.jsii.JsiiObjectRef;
import software.amazon.jsii.Kernel;
import software.amazon.jsii.NativeType;
import software.constructs.Construct;

@Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_batch.MultiNodeJobDefinition")
public class MultiNodeJobDefinition
extends Resource
implements IJobDefinition {
    protected MultiNodeJobDefinition(JsiiObjectRef objRef) {
        super(objRef);
    }

    protected MultiNodeJobDefinition(JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    public MultiNodeJobDefinition(@NotNull Construct scope, @NotNull String id, @Nullable MultiNodeJobDefinitionProps props) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), props});
    }

    public MultiNodeJobDefinition(@NotNull Construct scope, @NotNull String id) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required")});
    }

    @NotNull
    public static IJobDefinition fromJobDefinitionArn(@NotNull Construct scope, @NotNull String id, @NotNull String jobDefinitionArn) {
        return (IJobDefinition)JsiiObject.jsiiStaticCall(MultiNodeJobDefinition.class, (String)"fromJobDefinitionArn", (NativeType)NativeType.forClass(IJobDefinition.class), (Object[])new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(jobDefinitionArn, "jobDefinitionArn is required")});
    }

    public void addContainer(@NotNull MultiNodeContainer container) {
        Kernel.call((Object)this, (String)"addContainer", (NativeType)NativeType.VOID, (Object[])new Object[]{Objects.requireNonNull(container, "container is required")});
    }

    @Override
    public void addRetryStrategy(@NotNull RetryStrategy strategy) {
        Kernel.call((Object)this, (String)"addRetryStrategy", (NativeType)NativeType.VOID, (Object[])new Object[]{Objects.requireNonNull(strategy, "strategy is required")});
    }

    @NotNull
    public List<MultiNodeContainer> getContainers() {
        return Collections.unmodifiableList((List)Kernel.get((Object)this, (String)"containers", (NativeType)NativeType.listOf((NativeType)NativeType.forClass(MultiNodeContainer.class))));
    }

    @NotNull
    public InstanceType getInstanceType() {
        return (InstanceType)((Object)Kernel.get((Object)this, (String)"instanceType", (NativeType)NativeType.forClass(InstanceType.class)));
    }

    @Override
    @NotNull
    public String getJobDefinitionArn() {
        return (String)Kernel.get((Object)this, (String)"jobDefinitionArn", (NativeType)NativeType.forClass(String.class));
    }

    @Override
    @NotNull
    public String getJobDefinitionName() {
        return (String)Kernel.get((Object)this, (String)"jobDefinitionName", (NativeType)NativeType.forClass(String.class));
    }

    @Override
    @NotNull
    public List<RetryStrategy> getRetryStrategies() {
        return Collections.unmodifiableList((List)Kernel.get((Object)this, (String)"retryStrategies", (NativeType)NativeType.listOf((NativeType)NativeType.forClass(RetryStrategy.class))));
    }

    @Nullable
    public Number getMainNode() {
        return (Number)Kernel.get((Object)this, (String)"mainNode", (NativeType)NativeType.forClass(Number.class));
    }

    @Override
    @Nullable
    public Map<String, Object> getParameters() {
        return Optional.ofNullable((Map)Kernel.get((Object)this, (String)"parameters", (NativeType)NativeType.mapOf((NativeType)NativeType.forClass(Object.class)))).map(Collections::unmodifiableMap).orElse(null);
    }

    @Nullable
    public Boolean getPropagateTags() {
        return (Boolean)Kernel.get((Object)this, (String)"propagateTags", (NativeType)NativeType.forClass(Boolean.class));
    }

    @Override
    @Nullable
    public Number getRetryAttempts() {
        return (Number)Kernel.get((Object)this, (String)"retryAttempts", (NativeType)NativeType.forClass(Number.class));
    }

    @Override
    @Nullable
    public Number getSchedulingPriority() {
        return (Number)Kernel.get((Object)this, (String)"schedulingPriority", (NativeType)NativeType.forClass(Number.class));
    }

    @Override
    @Nullable
    public Duration getTimeout() {
        return (Duration)((Object)Kernel.get((Object)this, (String)"timeout", (NativeType)NativeType.forClass(Duration.class)));
    }

    public static final class Builder
    implements software.amazon.jsii.Builder<MultiNodeJobDefinition> {
        private final Construct scope;
        private final String id;
        private MultiNodeJobDefinitionProps.Builder props;

        public static Builder create(Construct scope, String id) {
            return new Builder(scope, id);
        }

        private Builder(Construct scope, String id) {
            this.scope = scope;
            this.id = id;
        }

        public Builder jobDefinitionName(String jobDefinitionName) {
            this.props().jobDefinitionName(jobDefinitionName);
            return this;
        }

        public Builder parameters(Map<String, ? extends Object> parameters) {
            this.props().parameters(parameters);
            return this;
        }

        public Builder retryAttempts(Number retryAttempts) {
            this.props().retryAttempts(retryAttempts);
            return this;
        }

        public Builder retryStrategies(List<? extends RetryStrategy> retryStrategies) {
            this.props().retryStrategies(retryStrategies);
            return this;
        }

        public Builder schedulingPriority(Number schedulingPriority) {
            this.props().schedulingPriority(schedulingPriority);
            return this;
        }

        public Builder timeout(Duration timeout) {
            this.props().timeout(timeout);
            return this;
        }

        public Builder containers(List<? extends MultiNodeContainer> containers) {
            this.props().containers(containers);
            return this;
        }

        public Builder instanceType(InstanceType instanceType) {
            this.props().instanceType(instanceType);
            return this;
        }

        public Builder mainNode(Number mainNode) {
            this.props().mainNode(mainNode);
            return this;
        }

        public Builder propagateTags(Boolean propagateTags) {
            this.props().propagateTags(propagateTags);
            return this;
        }

        public MultiNodeJobDefinition build() {
            return new MultiNodeJobDefinition(this.scope, this.id, this.props != null ? this.props.build() : null);
        }

        private MultiNodeJobDefinitionProps.Builder props() {
            if (this.props == null) {
                this.props = new MultiNodeJobDefinitionProps.Builder();
            }
            return this.props;
        }
    }
}

