/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.bcmdataexports;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.amazon.awscdk.$Module;
import software.amazon.awscdk.CfnResource;
import software.amazon.awscdk.IInspectable;
import software.amazon.awscdk.IResolvable;
import software.amazon.awscdk.ITaggableV2;
import software.amazon.awscdk.TagManager;
import software.amazon.awscdk.TreeInspector;
import software.amazon.awscdk.services.bcmdataexports.CfnExport;
import software.amazon.awscdk.services.bcmdataexports.CfnExportProps;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiEngine;
import software.amazon.jsii.JsiiObject;
import software.amazon.jsii.JsiiObjectRef;
import software.amazon.jsii.JsiiSerializable;
import software.amazon.jsii.Kernel;
import software.amazon.jsii.NativeType;
import software.constructs.Construct;

@Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_bcmdataexports.CfnExport")
public class CfnExport
extends CfnResource
implements IInspectable,
ITaggableV2 {
    public static final String CFN_RESOURCE_TYPE_NAME = (String)JsiiObject.jsiiStaticGet(CfnExport.class, (String)"CFN_RESOURCE_TYPE_NAME", (NativeType)NativeType.forClass(String.class));

    protected CfnExport(JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnExport(JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    public CfnExport(@NotNull Construct scope, @NotNull String id, @NotNull CfnExportProps props) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(scope, "scope is required"), Objects.requireNonNull(id, "id is required"), Objects.requireNonNull(props, "props is required")});
    }

    @Override
    public void inspect(@NotNull TreeInspector inspector) {
        Kernel.call((Object)this, (String)"inspect", (NativeType)NativeType.VOID, (Object[])new Object[]{Objects.requireNonNull(inspector, "inspector is required")});
    }

    @Override
    @NotNull
    protected Map<String, Object> renderProperties(@NotNull Map<String, Object> props) {
        return Collections.unmodifiableMap((Map)Kernel.call((Object)this, (String)"renderProperties", (NativeType)NativeType.mapOf((NativeType)NativeType.forClass(Object.class)), (Object[])new Object[]{Objects.requireNonNull(props, "props is required")}));
    }

    @NotNull
    public String getAttrExportArn() {
        return (String)Kernel.get((Object)this, (String)"attrExportArn", (NativeType)NativeType.forClass(String.class));
    }

    @Override
    @NotNull
    public TagManager getCdkTagManager() {
        return (TagManager)((Object)Kernel.get((Object)this, (String)"cdkTagManager", (NativeType)NativeType.forClass(TagManager.class)));
    }

    @Override
    @NotNull
    protected Map<String, Object> getCfnProperties() {
        return Collections.unmodifiableMap((Map)Kernel.get((Object)this, (String)"cfnProperties", (NativeType)NativeType.mapOf((NativeType)NativeType.forClass(Object.class))));
    }

    @NotNull
    public Object getExport() {
        return Kernel.get((Object)this, (String)"export", (NativeType)NativeType.forClass(Object.class));
    }

    public void setExport(@NotNull IResolvable value) {
        Kernel.set((Object)this, (String)"export", (Object)Objects.requireNonNull(value, "export is required"));
    }

    public void setExport(@NotNull ExportProperty value) {
        Kernel.set((Object)this, (String)"export", (Object)Objects.requireNonNull(value, "export is required"));
    }

    @Nullable
    public List<ResourceTagProperty> getTags() {
        return Optional.ofNullable((List)Kernel.get((Object)this, (String)"tags", (NativeType)NativeType.listOf((NativeType)NativeType.forClass(ResourceTagProperty.class)))).map(Collections::unmodifiableList).orElse(null);
    }

    public void setTags(@Nullable List<ResourceTagProperty> value) {
        Kernel.set((Object)this, (String)"tags", value);
    }

    @Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_bcmdataexports.CfnExport.ResourceTagProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface ResourceTagProperty
    extends JsiiSerializable {
        @NotNull
        public String getKey();

        @NotNull
        public String getValue();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<ResourceTagProperty> {
            String key;
            String value;

            public Builder key(String key) {
                this.key = key;
                return this;
            }

            public Builder value(String value) {
                this.value = value;
                return this;
            }

            public ResourceTagProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    public static final class Builder
    implements software.amazon.jsii.Builder<CfnExport> {
        private final Construct scope;
        private final String id;
        private final CfnExportProps.Builder props;

        public static Builder create(Construct scope, String id) {
            return new Builder(scope, id);
        }

        private Builder(Construct scope, String id) {
            this.scope = scope;
            this.id = id;
            this.props = new CfnExportProps.Builder();
        }

        public Builder export(IResolvable export) {
            this.props.export(export);
            return this;
        }

        public Builder export(ExportProperty export) {
            this.props.export(export);
            return this;
        }

        public Builder tags(List<? extends ResourceTagProperty> tags) {
            this.props.tags(tags);
            return this;
        }

        public CfnExport build() {
            return new CfnExport(this.scope, this.id, this.props.build());
        }
    }

    @Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_bcmdataexports.CfnExport.S3OutputConfigurationsProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface S3OutputConfigurationsProperty
    extends JsiiSerializable {
        @NotNull
        public String getCompression();

        @NotNull
        public String getFormat();

        @NotNull
        public String getOutputType();

        @NotNull
        public String getOverwrite();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<S3OutputConfigurationsProperty> {
            String compression;
            String format;
            String outputType;
            String overwrite;

            public Builder compression(String compression) {
                this.compression = compression;
                return this;
            }

            public Builder format(String format) {
                this.format = format;
                return this;
            }

            public Builder outputType(String outputType) {
                this.outputType = outputType;
                return this;
            }

            public Builder overwrite(String overwrite) {
                this.overwrite = overwrite;
                return this;
            }

            public S3OutputConfigurationsProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_bcmdataexports.CfnExport.S3DestinationProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface S3DestinationProperty
    extends JsiiSerializable {
        @NotNull
        public String getS3Bucket();

        @NotNull
        public Object getS3OutputConfigurations();

        @NotNull
        public String getS3Prefix();

        @NotNull
        public String getS3Region();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<S3DestinationProperty> {
            String s3Bucket;
            Object s3OutputConfigurations;
            String s3Prefix;
            String s3Region;

            public Builder s3Bucket(String s3Bucket) {
                this.s3Bucket = s3Bucket;
                return this;
            }

            public Builder s3OutputConfigurations(IResolvable s3OutputConfigurations) {
                this.s3OutputConfigurations = s3OutputConfigurations;
                return this;
            }

            public Builder s3OutputConfigurations(S3OutputConfigurationsProperty s3OutputConfigurations) {
                this.s3OutputConfigurations = s3OutputConfigurations;
                return this;
            }

            public Builder s3Prefix(String s3Prefix) {
                this.s3Prefix = s3Prefix;
                return this;
            }

            public Builder s3Region(String s3Region) {
                this.s3Region = s3Region;
                return this;
            }

            public S3DestinationProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_bcmdataexports.CfnExport.RefreshCadenceProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface RefreshCadenceProperty
    extends JsiiSerializable {
        @NotNull
        public String getFrequency();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<RefreshCadenceProperty> {
            String frequency;

            public Builder frequency(String frequency) {
                this.frequency = frequency;
                return this;
            }

            public RefreshCadenceProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_bcmdataexports.CfnExport.ExportProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface ExportProperty
    extends JsiiSerializable {
        @NotNull
        public Object getDataQuery();

        @NotNull
        public Object getDestinationConfigurations();

        @NotNull
        public String getName();

        @NotNull
        public Object getRefreshCadence();

        @Nullable
        default public String getDescription() {
            return null;
        }

        @Nullable
        default public String getExportArn() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<ExportProperty> {
            Object dataQuery;
            Object destinationConfigurations;
            String name;
            Object refreshCadence;
            String description;
            String exportArn;

            public Builder dataQuery(IResolvable dataQuery) {
                this.dataQuery = dataQuery;
                return this;
            }

            public Builder dataQuery(DataQueryProperty dataQuery) {
                this.dataQuery = dataQuery;
                return this;
            }

            public Builder destinationConfigurations(IResolvable destinationConfigurations) {
                this.destinationConfigurations = destinationConfigurations;
                return this;
            }

            public Builder destinationConfigurations(DestinationConfigurationsProperty destinationConfigurations) {
                this.destinationConfigurations = destinationConfigurations;
                return this;
            }

            public Builder name(String name) {
                this.name = name;
                return this;
            }

            public Builder refreshCadence(IResolvable refreshCadence) {
                this.refreshCadence = refreshCadence;
                return this;
            }

            public Builder refreshCadence(RefreshCadenceProperty refreshCadence) {
                this.refreshCadence = refreshCadence;
                return this;
            }

            public Builder description(String description) {
                this.description = description;
                return this;
            }

            public Builder exportArn(String exportArn) {
                this.exportArn = exportArn;
                return this;
            }

            public ExportProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_bcmdataexports.CfnExport.DestinationConfigurationsProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface DestinationConfigurationsProperty
    extends JsiiSerializable {
        @NotNull
        public Object getS3Destination();

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<DestinationConfigurationsProperty> {
            Object s3Destination;

            public Builder s3Destination(IResolvable s3Destination) {
                this.s3Destination = s3Destination;
                return this;
            }

            public Builder s3Destination(S3DestinationProperty s3Destination) {
                this.s3Destination = s3Destination;
                return this;
            }

            public DestinationConfigurationsProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }

    @Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_bcmdataexports.CfnExport.DataQueryProperty")
    @software.amazon.jsii.Jsii$Proxy(value=Jsii.Proxy.class)
    public static interface DataQueryProperty
    extends JsiiSerializable {
        @NotNull
        public String getQueryStatement();

        @Nullable
        default public Object getTableConfigurations() {
            return null;
        }

        public static Builder builder() {
            return new Builder();
        }

        public static final class Builder
        implements software.amazon.jsii.Builder<DataQueryProperty> {
            String queryStatement;
            Object tableConfigurations;

            public Builder queryStatement(String queryStatement) {
                this.queryStatement = queryStatement;
                return this;
            }

            public Builder tableConfigurations(IResolvable tableConfigurations) {
                this.tableConfigurations = tableConfigurations;
                return this;
            }

            public Builder tableConfigurations(Map<String, ? extends Object> tableConfigurations) {
                this.tableConfigurations = tableConfigurations;
                return this;
            }

            public DataQueryProperty build() {
                return new Jsii.Proxy(this);
            }
        }
    }
}

