/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.fsx;

import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.amazon.awscdk.$Module;
import software.amazon.awscdk.RemovalPolicy;
import software.amazon.awscdk.services.ec2.ISecurityGroup;
import software.amazon.awscdk.services.ec2.ISubnet;
import software.amazon.awscdk.services.ec2.IVpc;
import software.amazon.awscdk.services.fsx.FileSystemProps;
import software.amazon.awscdk.services.fsx.FileSystemTypeVersion;
import software.amazon.awscdk.services.fsx.LustreConfiguration;
import software.amazon.awscdk.services.fsx.LustreFileSystemProps;
import software.amazon.awscdk.services.fsx.StorageType;
import software.amazon.awscdk.services.kms.IKey;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiSerializable;

@Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_fsx.LustreFileSystemProps")
@Jsii.Proxy(value=Jsii.Proxy.class)
public interface LustreFileSystemProps
extends JsiiSerializable,
FileSystemProps {
    @NotNull
    public LustreConfiguration getLustreConfiguration();

    @NotNull
    public ISubnet getVpcSubnet();

    @Nullable
    default public FileSystemTypeVersion getFileSystemTypeVersion() {
        return null;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static final class Builder
    implements software.amazon.jsii.Builder<LustreFileSystemProps> {
        LustreConfiguration lustreConfiguration;
        ISubnet vpcSubnet;
        FileSystemTypeVersion fileSystemTypeVersion;
        Number storageCapacityGiB;
        IVpc vpc;
        String backupId;
        IKey kmsKey;
        RemovalPolicy removalPolicy;
        ISecurityGroup securityGroup;
        StorageType storageType;

        public Builder lustreConfiguration(LustreConfiguration lustreConfiguration) {
            this.lustreConfiguration = lustreConfiguration;
            return this;
        }

        public Builder vpcSubnet(ISubnet vpcSubnet) {
            this.vpcSubnet = vpcSubnet;
            return this;
        }

        public Builder fileSystemTypeVersion(FileSystemTypeVersion fileSystemTypeVersion) {
            this.fileSystemTypeVersion = fileSystemTypeVersion;
            return this;
        }

        public Builder storageCapacityGiB(Number storageCapacityGiB) {
            this.storageCapacityGiB = storageCapacityGiB;
            return this;
        }

        public Builder vpc(IVpc vpc) {
            this.vpc = vpc;
            return this;
        }

        public Builder backupId(String backupId) {
            this.backupId = backupId;
            return this;
        }

        public Builder kmsKey(IKey kmsKey) {
            this.kmsKey = kmsKey;
            return this;
        }

        public Builder removalPolicy(RemovalPolicy removalPolicy) {
            this.removalPolicy = removalPolicy;
            return this;
        }

        public Builder securityGroup(ISecurityGroup securityGroup) {
            this.securityGroup = securityGroup;
            return this;
        }

        public Builder storageType(StorageType storageType) {
            this.storageType = storageType;
            return this;
        }

        public LustreFileSystemProps build() {
            return new Jsii.Proxy(this);
        }
    }
}

