/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awscdk.services.kinesisfirehose;

import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import software.amazon.awscdk.$Module;
import software.amazon.awscdk.Duration;
import software.amazon.awscdk.Size;
import software.amazon.awscdk.services.kinesisfirehose.DataProcessorBindOptions;
import software.amazon.awscdk.services.kinesisfirehose.DataProcessorConfig;
import software.amazon.awscdk.services.kinesisfirehose.DataProcessorProps;
import software.amazon.awscdk.services.kinesisfirehose.IDataProcessor;
import software.amazon.awscdk.services.lambda.IFunction;
import software.amazon.jsii.Jsii;
import software.amazon.jsii.JsiiEngine;
import software.amazon.jsii.JsiiObject;
import software.amazon.jsii.JsiiObjectRef;
import software.amazon.jsii.Kernel;
import software.amazon.jsii.NativeType;
import software.constructs.Construct;

@Jsii(module=$Module.class, fqn="aws-cdk-lib.aws_kinesisfirehose.LambdaFunctionProcessor")
public class LambdaFunctionProcessor
extends JsiiObject
implements IDataProcessor {
    protected LambdaFunctionProcessor(JsiiObjectRef objRef) {
        super(objRef);
    }

    protected LambdaFunctionProcessor(JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    public LambdaFunctionProcessor(@NotNull IFunction lambdaFunction, @Nullable DataProcessorProps props) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(lambdaFunction, "lambdaFunction is required"), props});
    }

    public LambdaFunctionProcessor(@NotNull IFunction lambdaFunction) {
        super(JsiiObject.InitializationMode.JSII);
        JsiiEngine.getInstance().createNewObject((Object)this, new Object[]{Objects.requireNonNull(lambdaFunction, "lambdaFunction is required")});
    }

    @Override
    @NotNull
    public DataProcessorConfig bind(@NotNull Construct _scope, @NotNull DataProcessorBindOptions options) {
        return (DataProcessorConfig)Kernel.call((Object)this, (String)"bind", (NativeType)NativeType.forClass(DataProcessorConfig.class), (Object[])new Object[]{Objects.requireNonNull(_scope, "_scope is required"), Objects.requireNonNull(options, "options is required")});
    }

    @Override
    @NotNull
    public DataProcessorProps getProps() {
        return (DataProcessorProps)Kernel.get((Object)this, (String)"props", (NativeType)NativeType.forClass(DataProcessorProps.class));
    }

    public static final class Builder
    implements software.amazon.jsii.Builder<LambdaFunctionProcessor> {
        private final IFunction lambdaFunction;
        private DataProcessorProps.Builder props;

        public static Builder create(IFunction lambdaFunction) {
            return new Builder(lambdaFunction);
        }

        private Builder(IFunction lambdaFunction) {
            this.lambdaFunction = lambdaFunction;
        }

        public Builder bufferInterval(Duration bufferInterval) {
            this.props().bufferInterval(bufferInterval);
            return this;
        }

        public Builder bufferSize(Size bufferSize) {
            this.props().bufferSize(bufferSize);
            return this;
        }

        public Builder retries(Number retries) {
            this.props().retries(retries);
            return this;
        }

        public LambdaFunctionProcessor build() {
            return new LambdaFunctionProcessor(this.lambdaFunction, this.props != null ? this.props.build() : null);
        }

        private DataProcessorProps.Builder props() {
            if (this.props == null) {
                this.props = new DataProcessorProps.Builder();
            }
            return this.props;
        }
    }
}

