package software.amazon.awscdk;

/**
 * The access mechanism used to make source files available to the bundling container and to return the bundling output back to the host.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * GoFunction.Builder.create(this, "GoFunction")
 *         .entry("app/cmd/api")
 *         .bundling(BundlingOptions.builder()
 *                 .bundlingFileAccess(BundlingFileAccess.VOLUME_COPY)
 *                 .build())
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.106.0 (build e852934)", date = "2025-02-21T03:20:26.877Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.BundlingFileAccess")
public enum BundlingFileAccess {
    /**
     * Creates temporary volumes and containers to copy files from the host to the bundling container and back.
     * <p>
     * This is slower, but works also in more complex situations with remote or shared docker sockets.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    VOLUME_COPY,
    /**
     * The source and output folders will be mounted as bind mount from the host system This is faster and simpler, but less portable than <code>VOLUME_COPY</code>.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    BIND_MOUNT,
}
