package software.amazon.awscdk.aws_apigatewayv2_authorizers;

/**
 * Authorize Http Api routes on whether the requester is registered as part of an AWS Cognito user pool.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * import software.amazon.awscdk.aws_apigatewayv2_authorizers.HttpJwtAuthorizer;
 * import software.amazon.awscdk.aws_apigatewayv2_integrations.HttpUrlIntegration;
 * String issuer = "https://test.us.auth0.com";
 * HttpJwtAuthorizer authorizer = HttpJwtAuthorizer.Builder.create("BooksAuthorizer", issuer)
 *         .jwtAudience(List.of("3131231"))
 *         .build();
 * HttpApi api = new HttpApi(this, "HttpApi");
 * api.addRoutes(AddRoutesOptions.builder()
 *         .integration(new HttpUrlIntegration("BooksIntegration", "https://get-books-proxy.example.com"))
 *         .path("/books")
 *         .authorizer(authorizer)
 *         .build());
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.106.0 (build e852934)", date = "2025-02-21T03:20:27.694Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_apigatewayv2_authorizers.HttpJwtAuthorizer")
public class HttpJwtAuthorizer extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.apigatewayv2.IHttpRouteAuthorizer {

    protected HttpJwtAuthorizer(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected HttpJwtAuthorizer(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * Initialize a JWT authorizer to be bound with HTTP route.
     * <p>
     * @param id The id of the underlying construct. This parameter is required.
     * @param jwtIssuer The base domain of the identity provider that issues JWT. This parameter is required.
     * @param props Properties to configure the authorizer. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public HttpJwtAuthorizer(final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull java.lang.String jwtIssuer, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.aws_apigatewayv2_authorizers.HttpJwtAuthorizerProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(jwtIssuer, "jwtIssuer is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Bind this authorizer to a specified Http route.
     * <p>
     * @param options This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.apigatewayv2.HttpRouteAuthorizerConfig bind(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.apigatewayv2.HttpRouteAuthorizerBindOptions options) {
        return software.amazon.jsii.Kernel.call(this, "bind", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.apigatewayv2.HttpRouteAuthorizerConfig.class), new Object[] { java.util.Objects.requireNonNull(options, "options is required") });
    }

    /**
     * The authorizationType used for JWT Authorizer.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAuthorizationType() {
        return software.amazon.jsii.Kernel.get(this, "authorizationType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Return the id of the authorizer if it's been constructed.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAuthorizerId() {
        return software.amazon.jsii.Kernel.get(this, "authorizerId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.aws_apigatewayv2_authorizers.HttpJwtAuthorizer}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.aws_apigatewayv2_authorizers.HttpJwtAuthorizer> {
        /**
         * @return a new instance of {@link Builder}.
         * @param id The id of the underlying construct. This parameter is required.
         * @param jwtIssuer The base domain of the identity provider that issues JWT. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final java.lang.String id, final java.lang.String jwtIssuer) {
            return new Builder(id, jwtIssuer);
        }

        private final java.lang.String id;
        private final java.lang.String jwtIssuer;
        private final software.amazon.awscdk.aws_apigatewayv2_authorizers.HttpJwtAuthorizerProps.Builder props;

        private Builder(final java.lang.String id, final java.lang.String jwtIssuer) {
            this.id = id;
            this.jwtIssuer = jwtIssuer;
            this.props = new software.amazon.awscdk.aws_apigatewayv2_authorizers.HttpJwtAuthorizerProps.Builder();
        }

        /**
         * A list of the intended recipients of the JWT.
         * <p>
         * A valid JWT must provide an aud that matches at least one entry in this list.
         * <p>
         * @return {@code this}
         * @param jwtAudience A list of the intended recipients of the JWT. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder jwtAudience(final java.util.List<java.lang.String> jwtAudience) {
            this.props.jwtAudience(jwtAudience);
            return this;
        }

        /**
         * The name of the authorizer.
         * <p>
         * Default: - same value as `id` passed in the constructor
         * <p>
         * @return {@code this}
         * @param authorizerName The name of the authorizer. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder authorizerName(final java.lang.String authorizerName) {
            this.props.authorizerName(authorizerName);
            return this;
        }

        /**
         * The identity source for which authorization is requested.
         * <p>
         * Default: ['$request.header.Authorization']
         * <p>
         * @return {@code this}
         * @param identitySource The identity source for which authorization is requested. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder identitySource(final java.util.List<java.lang.String> identitySource) {
            this.props.identitySource(identitySource);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.aws_apigatewayv2_authorizers.HttpJwtAuthorizer}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.aws_apigatewayv2_authorizers.HttpJwtAuthorizer build() {
            return new software.amazon.awscdk.aws_apigatewayv2_authorizers.HttpJwtAuthorizer(
                this.id,
                this.jwtIssuer,
                this.props.build()
            );
        }
    }
}
