package software.amazon.awscdk.aws_apigatewayv2_integrations;

/**
 * The Sqs integration resource for HTTP API.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * import software.amazon.awscdk.services.sqs.*;
 * import software.amazon.awscdk.aws_apigatewayv2_integrations.HttpSqsIntegration;
 * IQueue queue;
 * HttpApi httpApi;
 * // default integration (send message)
 * httpApi.addRoutes(AddRoutesOptions.builder()
 *         .path("/default")
 *         .methods(List.of(HttpMethod.POST))
 *         .integration(HttpSqsIntegration.Builder.create("defaultIntegration")
 *                 .queue(queue)
 *                 .build())
 *         .build());
 * // send message integration
 * httpApi.addRoutes(AddRoutesOptions.builder()
 *         .path("/send-message")
 *         .methods(List.of(HttpMethod.POST))
 *         .integration(HttpSqsIntegration.Builder.create("sendMessageIntegration")
 *                 .queue(queue)
 *                 .subtype(HttpIntegrationSubtype.SQS_SEND_MESSAGE)
 *                 .build())
 *         .build());
 * // receive message integration
 * httpApi.addRoutes(AddRoutesOptions.builder()
 *         .path("/receive-message")
 *         .methods(List.of(HttpMethod.POST))
 *         .integration(HttpSqsIntegration.Builder.create("receiveMessageIntegration")
 *                 .queue(queue)
 *                 .subtype(HttpIntegrationSubtype.SQS_RECEIVE_MESSAGE)
 *                 .build())
 *         .build());
 * // delete message integration
 * httpApi.addRoutes(AddRoutesOptions.builder()
 *         .path("/delete-message")
 *         .methods(List.of(HttpMethod.POST))
 *         .integration(HttpSqsIntegration.Builder.create("deleteMessageIntegration")
 *                 .queue(queue)
 *                 .subtype(HttpIntegrationSubtype.SQS_DELETE_MESSAGE)
 *                 .build())
 *         .build());
 * // purge queue integration
 * httpApi.addRoutes(AddRoutesOptions.builder()
 *         .path("/purge-queue")
 *         .methods(List.of(HttpMethod.POST))
 *         .integration(HttpSqsIntegration.Builder.create("purgeQueueIntegration")
 *                 .queue(queue)
 *                 .subtype(HttpIntegrationSubtype.SQS_PURGE_QUEUE)
 *                 .build())
 *         .build());
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.106.0 (build e852934)", date = "2025-02-21T03:20:27.709Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_apigatewayv2_integrations.HttpSqsIntegration")
public class HttpSqsIntegration extends software.amazon.awscdk.services.apigatewayv2.HttpRouteIntegration {

    protected HttpSqsIntegration(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected HttpSqsIntegration(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param id id of the underlying integration construct. This parameter is required.
     * @param props properties to configure the integration. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public HttpSqsIntegration(final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.aws_apigatewayv2_integrations.HttpSqsIntegrationProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Bind this integration to the route.
     * <p>
     * @param options This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.apigatewayv2.HttpRouteIntegrationConfig bind(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.apigatewayv2.HttpRouteIntegrationBindOptions options) {
        return software.amazon.jsii.Kernel.call(this, "bind", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.apigatewayv2.HttpRouteIntegrationConfig.class), new Object[] { java.util.Objects.requireNonNull(options, "options is required") });
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.aws_apigatewayv2_integrations.HttpSqsIntegration}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.aws_apigatewayv2_integrations.HttpSqsIntegration> {
        /**
         * @return a new instance of {@link Builder}.
         * @param id id of the underlying integration construct. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final java.lang.String id) {
            return new Builder(id);
        }

        private final java.lang.String id;
        private final software.amazon.awscdk.aws_apigatewayv2_integrations.HttpSqsIntegrationProps.Builder props;

        private Builder(final java.lang.String id) {
            this.id = id;
            this.props = new software.amazon.awscdk.aws_apigatewayv2_integrations.HttpSqsIntegrationProps.Builder();
        }

        /**
         * SQS queue that Integrates with API Gateway.
         * <p>
         * @return {@code this}
         * @param queue SQS queue that Integrates with API Gateway. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder queue(final software.amazon.awscdk.services.sqs.IQueue queue) {
            this.props.queue(queue);
            return this;
        }

        /**
         * Specifies how to transform HTTP requests before sending them to the backend.
         * <p>
         * Default: - specify `QueueUrl`. Additionally, set `MessageBody` to `$request.body.MessageBody` for `SQS_SEND_MESSAGE` subtype
         * and set `ReceiptHandle` to `$request.body.ReceiptHandle` for `SQS_DELETE_MESSAGE` subtype.
         * <p>
         * @return {@code this}
         * @see <a href="https://docs.aws.amazon.com/apigateway/latest/developerguide/http-api-develop-integrations-aws-services-reference.html">https://docs.aws.amazon.com/apigateway/latest/developerguide/http-api-develop-integrations-aws-services-reference.html</a>
         * @param parameterMapping Specifies how to transform HTTP requests before sending them to the backend. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder parameterMapping(final software.amazon.awscdk.services.apigatewayv2.ParameterMapping parameterMapping) {
            this.props.parameterMapping(parameterMapping);
            return this;
        }

        /**
         * The subtype of the HTTP integration.
         * <p>
         * Only subtypes starting with SQS_ can be specified.
         * <p>
         * Default: HttpIntegrationSubtype.SQS_SEND_MESSAGE
         * <p>
         * @return {@code this}
         * @param subtype The subtype of the HTTP integration. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder subtype(final software.amazon.awscdk.services.apigatewayv2.HttpIntegrationSubtype subtype) {
            this.props.subtype(subtype);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.aws_apigatewayv2_integrations.HttpSqsIntegration}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.aws_apigatewayv2_integrations.HttpSqsIntegration build() {
            return new software.amazon.awscdk.aws_apigatewayv2_integrations.HttpSqsIntegration(
                this.id,
                this.props.build()
            );
        }
    }
}
