package software.amazon.awscdk.cloud_assembly_schema;

/**
 * Definitions for the asset manifest.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.cloud_assembly_schema.*;
 * Object assumeRoleAdditionalOptions;
 * AssetManifest assetManifest = AssetManifest.builder()
 *         .version("version")
 *         // the properties below are optional
 *         .dockerImages(Map.of(
 *                 "dockerImagesKey", DockerImageAsset.builder()
 *                         .destinations(Map.of(
 *                                 "destinationsKey", DockerImageDestination.builder()
 *                                         .imageTag("imageTag")
 *                                         .repositoryName("repositoryName")
 *                                         // the properties below are optional
 *                                         .assumeRoleAdditionalOptions(Map.of(
 *                                                 "assumeRoleAdditionalOptionsKey", assumeRoleAdditionalOptions))
 *                                         .assumeRoleArn("assumeRoleArn")
 *                                         .assumeRoleExternalId("assumeRoleExternalId")
 *                                         .region("region")
 *                                         .build()))
 *                         .source(DockerImageSource.builder()
 *                                 .cacheDisabled(false)
 *                                 .cacheFrom(List.of(DockerCacheOption.builder()
 *                                         .type("type")
 *                                         // the properties below are optional
 *                                         .params(Map.of(
 *                                                 "paramsKey", "params"))
 *                                         .build()))
 *                                 .cacheTo(DockerCacheOption.builder()
 *                                         .type("type")
 *                                         // the properties below are optional
 *                                         .params(Map.of(
 *                                                 "paramsKey", "params"))
 *                                         .build())
 *                                 .directory("directory")
 *                                 .dockerBuildArgs(Map.of(
 *                                         "dockerBuildArgsKey", "dockerBuildArgs"))
 *                                 .dockerBuildSecrets(Map.of(
 *                                         "dockerBuildSecretsKey", "dockerBuildSecrets"))
 *                                 .dockerBuildSsh("dockerBuildSsh")
 *                                 .dockerBuildTarget("dockerBuildTarget")
 *                                 .dockerFile("dockerFile")
 *                                 .dockerOutputs(List.of("dockerOutputs"))
 *                                 .executable(List.of("executable"))
 *                                 .networkMode("networkMode")
 *                                 .platform("platform")
 *                                 .build())
 *                         .build()))
 *         .files(Map.of(
 *                 "filesKey", FileAsset.builder()
 *                         .destinations(Map.of(
 *                                 "destinationsKey", FileDestination.builder()
 *                                         .bucketName("bucketName")
 *                                         .objectKey("objectKey")
 *                                         // the properties below are optional
 *                                         .assumeRoleAdditionalOptions(Map.of(
 *                                                 "assumeRoleAdditionalOptionsKey", assumeRoleAdditionalOptions))
 *                                         .assumeRoleArn("assumeRoleArn")
 *                                         .assumeRoleExternalId("assumeRoleExternalId")
 *                                         .region("region")
 *                                         .build()))
 *                         .source(FileSource.builder()
 *                                 .executable(List.of("executable"))
 *                                 .packaging(FileAssetPackaging.FILE)
 *                                 .path("path")
 *                                 .build())
 *                         .build()))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.106.0 (build e852934)", date = "2025-02-21T03:20:43.237Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.cloud_assembly_schema.AssetManifest")
@software.amazon.jsii.Jsii.Proxy(AssetManifest.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface AssetManifest extends software.amazon.jsii.JsiiSerializable {

    /**
     * Version of the manifest.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getVersion();

    /**
     * The Docker image assets in this manifest.
     * <p>
     * Default: - No Docker images
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.Map<java.lang.String, software.amazon.awscdk.cloud_assembly_schema.DockerImageAsset> getDockerImages() {
        return null;
    }

    /**
     * The file assets in this manifest.
     * <p>
     * Default: - No files
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.Map<java.lang.String, software.amazon.awscdk.cloud_assembly_schema.FileAsset> getFiles() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link AssetManifest}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link AssetManifest}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<AssetManifest> {
        java.lang.String version;
        java.util.Map<java.lang.String, software.amazon.awscdk.cloud_assembly_schema.DockerImageAsset> dockerImages;
        java.util.Map<java.lang.String, software.amazon.awscdk.cloud_assembly_schema.FileAsset> files;

        /**
         * Sets the value of {@link AssetManifest#getVersion}
         * @param version Version of the manifest. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder version(java.lang.String version) {
            this.version = version;
            return this;
        }

        /**
         * Sets the value of {@link AssetManifest#getDockerImages}
         * @param dockerImages The Docker image assets in this manifest.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder dockerImages(java.util.Map<java.lang.String, ? extends software.amazon.awscdk.cloud_assembly_schema.DockerImageAsset> dockerImages) {
            this.dockerImages = (java.util.Map<java.lang.String, software.amazon.awscdk.cloud_assembly_schema.DockerImageAsset>)dockerImages;
            return this;
        }

        /**
         * Sets the value of {@link AssetManifest#getFiles}
         * @param files The file assets in this manifest.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder files(java.util.Map<java.lang.String, ? extends software.amazon.awscdk.cloud_assembly_schema.FileAsset> files) {
            this.files = (java.util.Map<java.lang.String, software.amazon.awscdk.cloud_assembly_schema.FileAsset>)files;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link AssetManifest}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public AssetManifest build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link AssetManifest}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements AssetManifest {
        private final java.lang.String version;
        private final java.util.Map<java.lang.String, software.amazon.awscdk.cloud_assembly_schema.DockerImageAsset> dockerImages;
        private final java.util.Map<java.lang.String, software.amazon.awscdk.cloud_assembly_schema.FileAsset> files;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.version = software.amazon.jsii.Kernel.get(this, "version", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.dockerImages = software.amazon.jsii.Kernel.get(this, "dockerImages", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.cloud_assembly_schema.DockerImageAsset.class)));
            this.files = software.amazon.jsii.Kernel.get(this, "files", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.cloud_assembly_schema.FileAsset.class)));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.version = java.util.Objects.requireNonNull(builder.version, "version is required");
            this.dockerImages = (java.util.Map<java.lang.String, software.amazon.awscdk.cloud_assembly_schema.DockerImageAsset>)builder.dockerImages;
            this.files = (java.util.Map<java.lang.String, software.amazon.awscdk.cloud_assembly_schema.FileAsset>)builder.files;
        }

        @Override
        public final java.lang.String getVersion() {
            return this.version;
        }

        @Override
        public final java.util.Map<java.lang.String, software.amazon.awscdk.cloud_assembly_schema.DockerImageAsset> getDockerImages() {
            return this.dockerImages;
        }

        @Override
        public final java.util.Map<java.lang.String, software.amazon.awscdk.cloud_assembly_schema.FileAsset> getFiles() {
            return this.files;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("version", om.valueToTree(this.getVersion()));
            if (this.getDockerImages() != null) {
                data.set("dockerImages", om.valueToTree(this.getDockerImages()));
            }
            if (this.getFiles() != null) {
                data.set("files", om.valueToTree(this.getFiles()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.cloud_assembly_schema.AssetManifest"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            AssetManifest.Jsii$Proxy that = (AssetManifest.Jsii$Proxy) o;

            if (!version.equals(that.version)) return false;
            if (this.dockerImages != null ? !this.dockerImages.equals(that.dockerImages) : that.dockerImages != null) return false;
            return this.files != null ? this.files.equals(that.files) : that.files == null;
        }

        @Override
        public final int hashCode() {
            int result = this.version.hashCode();
            result = 31 * result + (this.dockerImages != null ? this.dockerImages.hashCode() : 0);
            result = 31 * result + (this.files != null ? this.files.hashCode() : 0);
            return result;
        }
    }
}
