package software.amazon.awscdk.cloud_assembly_schema;

/**
 * Options to use with cdk deploy.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.cloud_assembly_schema.*;
 * DeployOptions deployOptions = DeployOptions.builder()
 *         .all(false)
 *         .app("app")
 *         .assetMetadata(false)
 *         .caBundlePath("caBundlePath")
 *         .changeSetName("changeSetName")
 *         .ci(false)
 *         .color(false)
 *         .concurrency(123)
 *         .context(Map.of(
 *                 "contextKey", "context"))
 *         .debug(false)
 *         .ec2Creds(false)
 *         .exclusively(false)
 *         .execute(false)
 *         .force(false)
 *         .ignoreErrors(false)
 *         .json(false)
 *         .lookups(false)
 *         .notices(false)
 *         .notificationArns(List.of("notificationArns"))
 *         .output("output")
 *         .outputsFile("outputsFile")
 *         .parameters(Map.of(
 *                 "parametersKey", "parameters"))
 *         .pathMetadata(false)
 *         .profile("profile")
 *         .proxy("proxy")
 *         .requireApproval(RequireApproval.NEVER)
 *         .reuseAssets(List.of("reuseAssets"))
 *         .roleArn("roleArn")
 *         .rollback(false)
 *         .stacks(List.of("stacks"))
 *         .staging(false)
 *         .strict(false)
 *         .toolkitStackName("toolkitStackName")
 *         .trace(false)
 *         .usePreviousParameters(false)
 *         .verbose(false)
 *         .versionReporting(false)
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.106.0 (build e852934)", date = "2025-02-21T03:20:43.246Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.cloud_assembly_schema.DeployOptions")
@software.amazon.jsii.Jsii.Proxy(DeployOptions.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface DeployOptions extends software.amazon.jsii.JsiiSerializable, software.amazon.awscdk.cloud_assembly_schema.DefaultCdkOptions {

    /**
     * Optional name to use for the CloudFormation change set.
     * <p>
     * If not provided, a name will be generated automatically.
     * <p>
     * Default: - auto generate a name
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getChangeSetName() {
        return null;
    }

    /**
     * Whether we are on a CI system.
     * <p>
     * Default: false
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getCi() {
        return null;
    }

    /**
     * Deploy multiple stacks in parallel.
     * <p>
     * Default: 1
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getConcurrency() {
        return null;
    }

    /**
     * Only perform action on the given stack.
     * <p>
     * Default: false
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getExclusively() {
        return null;
    }

    /**
     * Whether to execute the ChangeSet Not providing <code>execute</code> parameter will result in execution of ChangeSet.
     * <p>
     * Default: true
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getExecute() {
        return null;
    }

    /**
     * Always deploy, even if templates are identical.
     * <p>
     * Default: false
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getForce() {
        return null;
    }

    /**
     * ARNs of SNS topics that CloudFormation will notify with stack related events.
     * <p>
     * Default: - no notifications
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getNotificationArns() {
        return null;
    }

    /**
     * Path to file where stack outputs will be written after a successful deploy as JSON.
     * <p>
     * Default: - Outputs are not written to any file
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getOutputsFile() {
        return null;
    }

    /**
     * Additional parameters for CloudFormation at deploy time.
     * <p>
     * Default: {}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.Map<java.lang.String, java.lang.String> getParameters() {
        return null;
    }

    /**
     * What kind of security changes require approval.
     * <p>
     * Default: RequireApproval.Never
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.cloud_assembly_schema.RequireApproval getRequireApproval() {
        return null;
    }

    /**
     * Reuse the assets with the given asset IDs.
     * <p>
     * Default: - do not reuse assets
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getReuseAssets() {
        return null;
    }

    /**
     * Rollback failed deployments.
     * <p>
     * Default: true
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getRollback() {
        return null;
    }

    /**
     * Name of the toolkit stack to use/deploy.
     * <p>
     * Default: CDKToolkit
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getToolkitStackName() {
        return null;
    }

    /**
     * Use previous values for unspecified parameters.
     * <p>
     * If not set, all parameters must be specified for every deployment.
     * <p>
     * Default: true
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getUsePreviousParameters() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link DeployOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link DeployOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<DeployOptions> {
        java.lang.String changeSetName;
        java.lang.Boolean ci;
        java.lang.Number concurrency;
        java.lang.Boolean exclusively;
        java.lang.Boolean execute;
        java.lang.Boolean force;
        java.util.List<java.lang.String> notificationArns;
        java.lang.String outputsFile;
        java.util.Map<java.lang.String, java.lang.String> parameters;
        software.amazon.awscdk.cloud_assembly_schema.RequireApproval requireApproval;
        java.util.List<java.lang.String> reuseAssets;
        java.lang.Boolean rollback;
        java.lang.String toolkitStackName;
        java.lang.Boolean usePreviousParameters;
        java.lang.Boolean all;
        java.lang.String app;
        java.lang.Boolean assetMetadata;
        java.lang.String caBundlePath;
        java.lang.Boolean color;
        java.util.Map<java.lang.String, java.lang.String> context;
        java.lang.Boolean debug;
        java.lang.Boolean ec2Creds;
        java.lang.Boolean ignoreErrors;
        java.lang.Boolean json;
        java.lang.Boolean lookups;
        java.lang.Boolean notices;
        java.lang.String output;
        java.lang.Boolean pathMetadata;
        java.lang.String profile;
        java.lang.String proxy;
        java.lang.String roleArn;
        java.util.List<java.lang.String> stacks;
        java.lang.Boolean staging;
        java.lang.Boolean strict;
        java.lang.Boolean trace;
        java.lang.Boolean verbose;
        java.lang.Boolean versionReporting;

        /**
         * Sets the value of {@link DeployOptions#getChangeSetName}
         * @param changeSetName Optional name to use for the CloudFormation change set.
         *                      If not provided, a name will be generated automatically.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder changeSetName(java.lang.String changeSetName) {
            this.changeSetName = changeSetName;
            return this;
        }

        /**
         * Sets the value of {@link DeployOptions#getCi}
         * @param ci Whether we are on a CI system.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder ci(java.lang.Boolean ci) {
            this.ci = ci;
            return this;
        }

        /**
         * Sets the value of {@link DeployOptions#getConcurrency}
         * @param concurrency Deploy multiple stacks in parallel.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder concurrency(java.lang.Number concurrency) {
            this.concurrency = concurrency;
            return this;
        }

        /**
         * Sets the value of {@link DeployOptions#getExclusively}
         * @param exclusively Only perform action on the given stack.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder exclusively(java.lang.Boolean exclusively) {
            this.exclusively = exclusively;
            return this;
        }

        /**
         * Sets the value of {@link DeployOptions#getExecute}
         * @param execute Whether to execute the ChangeSet Not providing <code>execute</code> parameter will result in execution of ChangeSet.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder execute(java.lang.Boolean execute) {
            this.execute = execute;
            return this;
        }

        /**
         * Sets the value of {@link DeployOptions#getForce}
         * @param force Always deploy, even if templates are identical.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder force(java.lang.Boolean force) {
            this.force = force;
            return this;
        }

        /**
         * Sets the value of {@link DeployOptions#getNotificationArns}
         * @param notificationArns ARNs of SNS topics that CloudFormation will notify with stack related events.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder notificationArns(java.util.List<java.lang.String> notificationArns) {
            this.notificationArns = notificationArns;
            return this;
        }

        /**
         * Sets the value of {@link DeployOptions#getOutputsFile}
         * @param outputsFile Path to file where stack outputs will be written after a successful deploy as JSON.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder outputsFile(java.lang.String outputsFile) {
            this.outputsFile = outputsFile;
            return this;
        }

        /**
         * Sets the value of {@link DeployOptions#getParameters}
         * @param parameters Additional parameters for CloudFormation at deploy time.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder parameters(java.util.Map<java.lang.String, java.lang.String> parameters) {
            this.parameters = parameters;
            return this;
        }

        /**
         * Sets the value of {@link DeployOptions#getRequireApproval}
         * @param requireApproval What kind of security changes require approval.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder requireApproval(software.amazon.awscdk.cloud_assembly_schema.RequireApproval requireApproval) {
            this.requireApproval = requireApproval;
            return this;
        }

        /**
         * Sets the value of {@link DeployOptions#getReuseAssets}
         * @param reuseAssets Reuse the assets with the given asset IDs.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder reuseAssets(java.util.List<java.lang.String> reuseAssets) {
            this.reuseAssets = reuseAssets;
            return this;
        }

        /**
         * Sets the value of {@link DeployOptions#getRollback}
         * @param rollback Rollback failed deployments.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder rollback(java.lang.Boolean rollback) {
            this.rollback = rollback;
            return this;
        }

        /**
         * Sets the value of {@link DeployOptions#getToolkitStackName}
         * @param toolkitStackName Name of the toolkit stack to use/deploy.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder toolkitStackName(java.lang.String toolkitStackName) {
            this.toolkitStackName = toolkitStackName;
            return this;
        }

        /**
         * Sets the value of {@link DeployOptions#getUsePreviousParameters}
         * @param usePreviousParameters Use previous values for unspecified parameters.
         *                              If not set, all parameters must be specified for every deployment.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder usePreviousParameters(java.lang.Boolean usePreviousParameters) {
            this.usePreviousParameters = usePreviousParameters;
            return this;
        }

        /**
         * Sets the value of {@link DeployOptions#getAll}
         * @param all Deploy all stacks.
         *            Requried if <code>stacks</code> is not set
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder all(java.lang.Boolean all) {
            this.all = all;
            return this;
        }

        /**
         * Sets the value of {@link DeployOptions#getApp}
         * @param app command-line for executing your app or a cloud assembly directory e.g. "node bin/my-app.js" or "cdk.out".
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder app(java.lang.String app) {
            this.app = app;
            return this;
        }

        /**
         * Sets the value of {@link DeployOptions#getAssetMetadata}
         * @param assetMetadata Include "aws:asset:*" CloudFormation metadata for resources that use assets.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder assetMetadata(java.lang.Boolean assetMetadata) {
            this.assetMetadata = assetMetadata;
            return this;
        }

        /**
         * Sets the value of {@link DeployOptions#getCaBundlePath}
         * @param caBundlePath Path to CA certificate to use when validating HTTPS requests.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder caBundlePath(java.lang.String caBundlePath) {
            this.caBundlePath = caBundlePath;
            return this;
        }

        /**
         * Sets the value of {@link DeployOptions#getColor}
         * @param color Show colors and other style from console output.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder color(java.lang.Boolean color) {
            this.color = color;
            return this;
        }

        /**
         * Sets the value of {@link DeployOptions#getContext}
         * @param context Additional context.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder context(java.util.Map<java.lang.String, java.lang.String> context) {
            this.context = context;
            return this;
        }

        /**
         * Sets the value of {@link DeployOptions#getDebug}
         * @param debug enable emission of additional debugging information, such as creation stack traces of tokens.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder debug(java.lang.Boolean debug) {
            this.debug = debug;
            return this;
        }

        /**
         * Sets the value of {@link DeployOptions#getEc2Creds}
         * @param ec2Creds Force trying to fetch EC2 instance credentials.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder ec2Creds(java.lang.Boolean ec2Creds) {
            this.ec2Creds = ec2Creds;
            return this;
        }

        /**
         * Sets the value of {@link DeployOptions#getIgnoreErrors}
         * @param ignoreErrors Ignores synthesis errors, which will likely produce an invalid output.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder ignoreErrors(java.lang.Boolean ignoreErrors) {
            this.ignoreErrors = ignoreErrors;
            return this;
        }

        /**
         * Sets the value of {@link DeployOptions#getJson}
         * @param json Use JSON output instead of YAML when templates are printed to STDOUT.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder json(java.lang.Boolean json) {
            this.json = json;
            return this;
        }

        /**
         * Sets the value of {@link DeployOptions#getLookups}
         * @param lookups Perform context lookups.
         *                Synthesis fails if this is disabled and context lookups need
         *                to be performed
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder lookups(java.lang.Boolean lookups) {
            this.lookups = lookups;
            return this;
        }

        /**
         * Sets the value of {@link DeployOptions#getNotices}
         * @param notices Show relevant notices.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder notices(java.lang.Boolean notices) {
            this.notices = notices;
            return this;
        }

        /**
         * Sets the value of {@link DeployOptions#getOutput}
         * @param output Emits the synthesized cloud assembly into a directory.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder output(java.lang.String output) {
            this.output = output;
            return this;
        }

        /**
         * Sets the value of {@link DeployOptions#getPathMetadata}
         * @param pathMetadata Include "aws:cdk:path" CloudFormation metadata for each resource.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder pathMetadata(java.lang.Boolean pathMetadata) {
            this.pathMetadata = pathMetadata;
            return this;
        }

        /**
         * Sets the value of {@link DeployOptions#getProfile}
         * @param profile Use the indicated AWS profile as the default environment.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder profile(java.lang.String profile) {
            this.profile = profile;
            return this;
        }

        /**
         * Sets the value of {@link DeployOptions#getProxy}
         * @param proxy Use the indicated proxy.
         *              Will read from
         *              HTTPS_PROXY environment if specified
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder proxy(java.lang.String proxy) {
            this.proxy = proxy;
            return this;
        }

        /**
         * Sets the value of {@link DeployOptions#getRoleArn}
         * @param roleArn Role to pass to CloudFormation for deployment.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder roleArn(java.lang.String roleArn) {
            this.roleArn = roleArn;
            return this;
        }

        /**
         * Sets the value of {@link DeployOptions#getStacks}
         * @param stacks List of stacks to deploy.
         *               Requried if <code>all</code> is not set
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder stacks(java.util.List<java.lang.String> stacks) {
            this.stacks = stacks;
            return this;
        }

        /**
         * Sets the value of {@link DeployOptions#getStaging}
         * @param staging Copy assets to the output directory.
         *                Needed for local debugging the source files with SAM CLI
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder staging(java.lang.Boolean staging) {
            this.staging = staging;
            return this;
        }

        /**
         * Sets the value of {@link DeployOptions#getStrict}
         * @param strict Do not construct stacks with warnings.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder strict(java.lang.Boolean strict) {
            this.strict = strict;
            return this;
        }

        /**
         * Sets the value of {@link DeployOptions#getTrace}
         * @param trace Print trace for stack warnings.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder trace(java.lang.Boolean trace) {
            this.trace = trace;
            return this;
        }

        /**
         * Sets the value of {@link DeployOptions#getVerbose}
         * @param verbose show debug logs.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder verbose(java.lang.Boolean verbose) {
            this.verbose = verbose;
            return this;
        }

        /**
         * Sets the value of {@link DeployOptions#getVersionReporting}
         * @param versionReporting Include "AWS::CDK::Metadata" resource in synthesized templates.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder versionReporting(java.lang.Boolean versionReporting) {
            this.versionReporting = versionReporting;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link DeployOptions}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public DeployOptions build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link DeployOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements DeployOptions {
        private final java.lang.String changeSetName;
        private final java.lang.Boolean ci;
        private final java.lang.Number concurrency;
        private final java.lang.Boolean exclusively;
        private final java.lang.Boolean execute;
        private final java.lang.Boolean force;
        private final java.util.List<java.lang.String> notificationArns;
        private final java.lang.String outputsFile;
        private final java.util.Map<java.lang.String, java.lang.String> parameters;
        private final software.amazon.awscdk.cloud_assembly_schema.RequireApproval requireApproval;
        private final java.util.List<java.lang.String> reuseAssets;
        private final java.lang.Boolean rollback;
        private final java.lang.String toolkitStackName;
        private final java.lang.Boolean usePreviousParameters;
        private final java.lang.Boolean all;
        private final java.lang.String app;
        private final java.lang.Boolean assetMetadata;
        private final java.lang.String caBundlePath;
        private final java.lang.Boolean color;
        private final java.util.Map<java.lang.String, java.lang.String> context;
        private final java.lang.Boolean debug;
        private final java.lang.Boolean ec2Creds;
        private final java.lang.Boolean ignoreErrors;
        private final java.lang.Boolean json;
        private final java.lang.Boolean lookups;
        private final java.lang.Boolean notices;
        private final java.lang.String output;
        private final java.lang.Boolean pathMetadata;
        private final java.lang.String profile;
        private final java.lang.String proxy;
        private final java.lang.String roleArn;
        private final java.util.List<java.lang.String> stacks;
        private final java.lang.Boolean staging;
        private final java.lang.Boolean strict;
        private final java.lang.Boolean trace;
        private final java.lang.Boolean verbose;
        private final java.lang.Boolean versionReporting;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.changeSetName = software.amazon.jsii.Kernel.get(this, "changeSetName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.ci = software.amazon.jsii.Kernel.get(this, "ci", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.concurrency = software.amazon.jsii.Kernel.get(this, "concurrency", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.exclusively = software.amazon.jsii.Kernel.get(this, "exclusively", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.execute = software.amazon.jsii.Kernel.get(this, "execute", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.force = software.amazon.jsii.Kernel.get(this, "force", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.notificationArns = software.amazon.jsii.Kernel.get(this, "notificationArns", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.outputsFile = software.amazon.jsii.Kernel.get(this, "outputsFile", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.parameters = software.amazon.jsii.Kernel.get(this, "parameters", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.requireApproval = software.amazon.jsii.Kernel.get(this, "requireApproval", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.cloud_assembly_schema.RequireApproval.class));
            this.reuseAssets = software.amazon.jsii.Kernel.get(this, "reuseAssets", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.rollback = software.amazon.jsii.Kernel.get(this, "rollback", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.toolkitStackName = software.amazon.jsii.Kernel.get(this, "toolkitStackName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.usePreviousParameters = software.amazon.jsii.Kernel.get(this, "usePreviousParameters", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.all = software.amazon.jsii.Kernel.get(this, "all", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.app = software.amazon.jsii.Kernel.get(this, "app", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.assetMetadata = software.amazon.jsii.Kernel.get(this, "assetMetadata", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.caBundlePath = software.amazon.jsii.Kernel.get(this, "caBundlePath", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.color = software.amazon.jsii.Kernel.get(this, "color", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.context = software.amazon.jsii.Kernel.get(this, "context", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.debug = software.amazon.jsii.Kernel.get(this, "debug", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.ec2Creds = software.amazon.jsii.Kernel.get(this, "ec2Creds", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.ignoreErrors = software.amazon.jsii.Kernel.get(this, "ignoreErrors", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.json = software.amazon.jsii.Kernel.get(this, "json", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.lookups = software.amazon.jsii.Kernel.get(this, "lookups", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.notices = software.amazon.jsii.Kernel.get(this, "notices", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.output = software.amazon.jsii.Kernel.get(this, "output", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.pathMetadata = software.amazon.jsii.Kernel.get(this, "pathMetadata", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.profile = software.amazon.jsii.Kernel.get(this, "profile", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.proxy = software.amazon.jsii.Kernel.get(this, "proxy", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.roleArn = software.amazon.jsii.Kernel.get(this, "roleArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.stacks = software.amazon.jsii.Kernel.get(this, "stacks", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.staging = software.amazon.jsii.Kernel.get(this, "staging", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.strict = software.amazon.jsii.Kernel.get(this, "strict", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.trace = software.amazon.jsii.Kernel.get(this, "trace", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.verbose = software.amazon.jsii.Kernel.get(this, "verbose", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.versionReporting = software.amazon.jsii.Kernel.get(this, "versionReporting", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.changeSetName = builder.changeSetName;
            this.ci = builder.ci;
            this.concurrency = builder.concurrency;
            this.exclusively = builder.exclusively;
            this.execute = builder.execute;
            this.force = builder.force;
            this.notificationArns = builder.notificationArns;
            this.outputsFile = builder.outputsFile;
            this.parameters = builder.parameters;
            this.requireApproval = builder.requireApproval;
            this.reuseAssets = builder.reuseAssets;
            this.rollback = builder.rollback;
            this.toolkitStackName = builder.toolkitStackName;
            this.usePreviousParameters = builder.usePreviousParameters;
            this.all = builder.all;
            this.app = builder.app;
            this.assetMetadata = builder.assetMetadata;
            this.caBundlePath = builder.caBundlePath;
            this.color = builder.color;
            this.context = builder.context;
            this.debug = builder.debug;
            this.ec2Creds = builder.ec2Creds;
            this.ignoreErrors = builder.ignoreErrors;
            this.json = builder.json;
            this.lookups = builder.lookups;
            this.notices = builder.notices;
            this.output = builder.output;
            this.pathMetadata = builder.pathMetadata;
            this.profile = builder.profile;
            this.proxy = builder.proxy;
            this.roleArn = builder.roleArn;
            this.stacks = builder.stacks;
            this.staging = builder.staging;
            this.strict = builder.strict;
            this.trace = builder.trace;
            this.verbose = builder.verbose;
            this.versionReporting = builder.versionReporting;
        }

        @Override
        public final java.lang.String getChangeSetName() {
            return this.changeSetName;
        }

        @Override
        public final java.lang.Boolean getCi() {
            return this.ci;
        }

        @Override
        public final java.lang.Number getConcurrency() {
            return this.concurrency;
        }

        @Override
        public final java.lang.Boolean getExclusively() {
            return this.exclusively;
        }

        @Override
        public final java.lang.Boolean getExecute() {
            return this.execute;
        }

        @Override
        public final java.lang.Boolean getForce() {
            return this.force;
        }

        @Override
        public final java.util.List<java.lang.String> getNotificationArns() {
            return this.notificationArns;
        }

        @Override
        public final java.lang.String getOutputsFile() {
            return this.outputsFile;
        }

        @Override
        public final java.util.Map<java.lang.String, java.lang.String> getParameters() {
            return this.parameters;
        }

        @Override
        public final software.amazon.awscdk.cloud_assembly_schema.RequireApproval getRequireApproval() {
            return this.requireApproval;
        }

        @Override
        public final java.util.List<java.lang.String> getReuseAssets() {
            return this.reuseAssets;
        }

        @Override
        public final java.lang.Boolean getRollback() {
            return this.rollback;
        }

        @Override
        public final java.lang.String getToolkitStackName() {
            return this.toolkitStackName;
        }

        @Override
        public final java.lang.Boolean getUsePreviousParameters() {
            return this.usePreviousParameters;
        }

        @Override
        public final java.lang.Boolean getAll() {
            return this.all;
        }

        @Override
        public final java.lang.String getApp() {
            return this.app;
        }

        @Override
        public final java.lang.Boolean getAssetMetadata() {
            return this.assetMetadata;
        }

        @Override
        public final java.lang.String getCaBundlePath() {
            return this.caBundlePath;
        }

        @Override
        public final java.lang.Boolean getColor() {
            return this.color;
        }

        @Override
        public final java.util.Map<java.lang.String, java.lang.String> getContext() {
            return this.context;
        }

        @Override
        public final java.lang.Boolean getDebug() {
            return this.debug;
        }

        @Override
        public final java.lang.Boolean getEc2Creds() {
            return this.ec2Creds;
        }

        @Override
        public final java.lang.Boolean getIgnoreErrors() {
            return this.ignoreErrors;
        }

        @Override
        public final java.lang.Boolean getJson() {
            return this.json;
        }

        @Override
        public final java.lang.Boolean getLookups() {
            return this.lookups;
        }

        @Override
        public final java.lang.Boolean getNotices() {
            return this.notices;
        }

        @Override
        public final java.lang.String getOutput() {
            return this.output;
        }

        @Override
        public final java.lang.Boolean getPathMetadata() {
            return this.pathMetadata;
        }

        @Override
        public final java.lang.String getProfile() {
            return this.profile;
        }

        @Override
        public final java.lang.String getProxy() {
            return this.proxy;
        }

        @Override
        public final java.lang.String getRoleArn() {
            return this.roleArn;
        }

        @Override
        public final java.util.List<java.lang.String> getStacks() {
            return this.stacks;
        }

        @Override
        public final java.lang.Boolean getStaging() {
            return this.staging;
        }

        @Override
        public final java.lang.Boolean getStrict() {
            return this.strict;
        }

        @Override
        public final java.lang.Boolean getTrace() {
            return this.trace;
        }

        @Override
        public final java.lang.Boolean getVerbose() {
            return this.verbose;
        }

        @Override
        public final java.lang.Boolean getVersionReporting() {
            return this.versionReporting;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getChangeSetName() != null) {
                data.set("changeSetName", om.valueToTree(this.getChangeSetName()));
            }
            if (this.getCi() != null) {
                data.set("ci", om.valueToTree(this.getCi()));
            }
            if (this.getConcurrency() != null) {
                data.set("concurrency", om.valueToTree(this.getConcurrency()));
            }
            if (this.getExclusively() != null) {
                data.set("exclusively", om.valueToTree(this.getExclusively()));
            }
            if (this.getExecute() != null) {
                data.set("execute", om.valueToTree(this.getExecute()));
            }
            if (this.getForce() != null) {
                data.set("force", om.valueToTree(this.getForce()));
            }
            if (this.getNotificationArns() != null) {
                data.set("notificationArns", om.valueToTree(this.getNotificationArns()));
            }
            if (this.getOutputsFile() != null) {
                data.set("outputsFile", om.valueToTree(this.getOutputsFile()));
            }
            if (this.getParameters() != null) {
                data.set("parameters", om.valueToTree(this.getParameters()));
            }
            if (this.getRequireApproval() != null) {
                data.set("requireApproval", om.valueToTree(this.getRequireApproval()));
            }
            if (this.getReuseAssets() != null) {
                data.set("reuseAssets", om.valueToTree(this.getReuseAssets()));
            }
            if (this.getRollback() != null) {
                data.set("rollback", om.valueToTree(this.getRollback()));
            }
            if (this.getToolkitStackName() != null) {
                data.set("toolkitStackName", om.valueToTree(this.getToolkitStackName()));
            }
            if (this.getUsePreviousParameters() != null) {
                data.set("usePreviousParameters", om.valueToTree(this.getUsePreviousParameters()));
            }
            if (this.getAll() != null) {
                data.set("all", om.valueToTree(this.getAll()));
            }
            if (this.getApp() != null) {
                data.set("app", om.valueToTree(this.getApp()));
            }
            if (this.getAssetMetadata() != null) {
                data.set("assetMetadata", om.valueToTree(this.getAssetMetadata()));
            }
            if (this.getCaBundlePath() != null) {
                data.set("caBundlePath", om.valueToTree(this.getCaBundlePath()));
            }
            if (this.getColor() != null) {
                data.set("color", om.valueToTree(this.getColor()));
            }
            if (this.getContext() != null) {
                data.set("context", om.valueToTree(this.getContext()));
            }
            if (this.getDebug() != null) {
                data.set("debug", om.valueToTree(this.getDebug()));
            }
            if (this.getEc2Creds() != null) {
                data.set("ec2Creds", om.valueToTree(this.getEc2Creds()));
            }
            if (this.getIgnoreErrors() != null) {
                data.set("ignoreErrors", om.valueToTree(this.getIgnoreErrors()));
            }
            if (this.getJson() != null) {
                data.set("json", om.valueToTree(this.getJson()));
            }
            if (this.getLookups() != null) {
                data.set("lookups", om.valueToTree(this.getLookups()));
            }
            if (this.getNotices() != null) {
                data.set("notices", om.valueToTree(this.getNotices()));
            }
            if (this.getOutput() != null) {
                data.set("output", om.valueToTree(this.getOutput()));
            }
            if (this.getPathMetadata() != null) {
                data.set("pathMetadata", om.valueToTree(this.getPathMetadata()));
            }
            if (this.getProfile() != null) {
                data.set("profile", om.valueToTree(this.getProfile()));
            }
            if (this.getProxy() != null) {
                data.set("proxy", om.valueToTree(this.getProxy()));
            }
            if (this.getRoleArn() != null) {
                data.set("roleArn", om.valueToTree(this.getRoleArn()));
            }
            if (this.getStacks() != null) {
                data.set("stacks", om.valueToTree(this.getStacks()));
            }
            if (this.getStaging() != null) {
                data.set("staging", om.valueToTree(this.getStaging()));
            }
            if (this.getStrict() != null) {
                data.set("strict", om.valueToTree(this.getStrict()));
            }
            if (this.getTrace() != null) {
                data.set("trace", om.valueToTree(this.getTrace()));
            }
            if (this.getVerbose() != null) {
                data.set("verbose", om.valueToTree(this.getVerbose()));
            }
            if (this.getVersionReporting() != null) {
                data.set("versionReporting", om.valueToTree(this.getVersionReporting()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.cloud_assembly_schema.DeployOptions"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            DeployOptions.Jsii$Proxy that = (DeployOptions.Jsii$Proxy) o;

            if (this.changeSetName != null ? !this.changeSetName.equals(that.changeSetName) : that.changeSetName != null) return false;
            if (this.ci != null ? !this.ci.equals(that.ci) : that.ci != null) return false;
            if (this.concurrency != null ? !this.concurrency.equals(that.concurrency) : that.concurrency != null) return false;
            if (this.exclusively != null ? !this.exclusively.equals(that.exclusively) : that.exclusively != null) return false;
            if (this.execute != null ? !this.execute.equals(that.execute) : that.execute != null) return false;
            if (this.force != null ? !this.force.equals(that.force) : that.force != null) return false;
            if (this.notificationArns != null ? !this.notificationArns.equals(that.notificationArns) : that.notificationArns != null) return false;
            if (this.outputsFile != null ? !this.outputsFile.equals(that.outputsFile) : that.outputsFile != null) return false;
            if (this.parameters != null ? !this.parameters.equals(that.parameters) : that.parameters != null) return false;
            if (this.requireApproval != null ? !this.requireApproval.equals(that.requireApproval) : that.requireApproval != null) return false;
            if (this.reuseAssets != null ? !this.reuseAssets.equals(that.reuseAssets) : that.reuseAssets != null) return false;
            if (this.rollback != null ? !this.rollback.equals(that.rollback) : that.rollback != null) return false;
            if (this.toolkitStackName != null ? !this.toolkitStackName.equals(that.toolkitStackName) : that.toolkitStackName != null) return false;
            if (this.usePreviousParameters != null ? !this.usePreviousParameters.equals(that.usePreviousParameters) : that.usePreviousParameters != null) return false;
            if (this.all != null ? !this.all.equals(that.all) : that.all != null) return false;
            if (this.app != null ? !this.app.equals(that.app) : that.app != null) return false;
            if (this.assetMetadata != null ? !this.assetMetadata.equals(that.assetMetadata) : that.assetMetadata != null) return false;
            if (this.caBundlePath != null ? !this.caBundlePath.equals(that.caBundlePath) : that.caBundlePath != null) return false;
            if (this.color != null ? !this.color.equals(that.color) : that.color != null) return false;
            if (this.context != null ? !this.context.equals(that.context) : that.context != null) return false;
            if (this.debug != null ? !this.debug.equals(that.debug) : that.debug != null) return false;
            if (this.ec2Creds != null ? !this.ec2Creds.equals(that.ec2Creds) : that.ec2Creds != null) return false;
            if (this.ignoreErrors != null ? !this.ignoreErrors.equals(that.ignoreErrors) : that.ignoreErrors != null) return false;
            if (this.json != null ? !this.json.equals(that.json) : that.json != null) return false;
            if (this.lookups != null ? !this.lookups.equals(that.lookups) : that.lookups != null) return false;
            if (this.notices != null ? !this.notices.equals(that.notices) : that.notices != null) return false;
            if (this.output != null ? !this.output.equals(that.output) : that.output != null) return false;
            if (this.pathMetadata != null ? !this.pathMetadata.equals(that.pathMetadata) : that.pathMetadata != null) return false;
            if (this.profile != null ? !this.profile.equals(that.profile) : that.profile != null) return false;
            if (this.proxy != null ? !this.proxy.equals(that.proxy) : that.proxy != null) return false;
            if (this.roleArn != null ? !this.roleArn.equals(that.roleArn) : that.roleArn != null) return false;
            if (this.stacks != null ? !this.stacks.equals(that.stacks) : that.stacks != null) return false;
            if (this.staging != null ? !this.staging.equals(that.staging) : that.staging != null) return false;
            if (this.strict != null ? !this.strict.equals(that.strict) : that.strict != null) return false;
            if (this.trace != null ? !this.trace.equals(that.trace) : that.trace != null) return false;
            if (this.verbose != null ? !this.verbose.equals(that.verbose) : that.verbose != null) return false;
            return this.versionReporting != null ? this.versionReporting.equals(that.versionReporting) : that.versionReporting == null;
        }

        @Override
        public final int hashCode() {
            int result = this.changeSetName != null ? this.changeSetName.hashCode() : 0;
            result = 31 * result + (this.ci != null ? this.ci.hashCode() : 0);
            result = 31 * result + (this.concurrency != null ? this.concurrency.hashCode() : 0);
            result = 31 * result + (this.exclusively != null ? this.exclusively.hashCode() : 0);
            result = 31 * result + (this.execute != null ? this.execute.hashCode() : 0);
            result = 31 * result + (this.force != null ? this.force.hashCode() : 0);
            result = 31 * result + (this.notificationArns != null ? this.notificationArns.hashCode() : 0);
            result = 31 * result + (this.outputsFile != null ? this.outputsFile.hashCode() : 0);
            result = 31 * result + (this.parameters != null ? this.parameters.hashCode() : 0);
            result = 31 * result + (this.requireApproval != null ? this.requireApproval.hashCode() : 0);
            result = 31 * result + (this.reuseAssets != null ? this.reuseAssets.hashCode() : 0);
            result = 31 * result + (this.rollback != null ? this.rollback.hashCode() : 0);
            result = 31 * result + (this.toolkitStackName != null ? this.toolkitStackName.hashCode() : 0);
            result = 31 * result + (this.usePreviousParameters != null ? this.usePreviousParameters.hashCode() : 0);
            result = 31 * result + (this.all != null ? this.all.hashCode() : 0);
            result = 31 * result + (this.app != null ? this.app.hashCode() : 0);
            result = 31 * result + (this.assetMetadata != null ? this.assetMetadata.hashCode() : 0);
            result = 31 * result + (this.caBundlePath != null ? this.caBundlePath.hashCode() : 0);
            result = 31 * result + (this.color != null ? this.color.hashCode() : 0);
            result = 31 * result + (this.context != null ? this.context.hashCode() : 0);
            result = 31 * result + (this.debug != null ? this.debug.hashCode() : 0);
            result = 31 * result + (this.ec2Creds != null ? this.ec2Creds.hashCode() : 0);
            result = 31 * result + (this.ignoreErrors != null ? this.ignoreErrors.hashCode() : 0);
            result = 31 * result + (this.json != null ? this.json.hashCode() : 0);
            result = 31 * result + (this.lookups != null ? this.lookups.hashCode() : 0);
            result = 31 * result + (this.notices != null ? this.notices.hashCode() : 0);
            result = 31 * result + (this.output != null ? this.output.hashCode() : 0);
            result = 31 * result + (this.pathMetadata != null ? this.pathMetadata.hashCode() : 0);
            result = 31 * result + (this.profile != null ? this.profile.hashCode() : 0);
            result = 31 * result + (this.proxy != null ? this.proxy.hashCode() : 0);
            result = 31 * result + (this.roleArn != null ? this.roleArn.hashCode() : 0);
            result = 31 * result + (this.stacks != null ? this.stacks.hashCode() : 0);
            result = 31 * result + (this.staging != null ? this.staging.hashCode() : 0);
            result = 31 * result + (this.strict != null ? this.strict.hashCode() : 0);
            result = 31 * result + (this.trace != null ? this.trace.hashCode() : 0);
            result = 31 * result + (this.verbose != null ? this.verbose.hashCode() : 0);
            result = 31 * result + (this.versionReporting != null ? this.versionReporting.hashCode() : 0);
            return result;
        }
    }
}
