package software.amazon.awscdk.customresources;

/**
 * Properties for AwsCustomResource.
 * <p>
 * Note that at least onCreate, onUpdate or onDelete must be specified.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * AwsCustomResource getParameter = AwsCustomResource.Builder.create(this, "GetParameter")
 *         .onUpdate(AwsSdkCall.builder() // will also be called for a CREATE event
 *                 .service("SSM")
 *                 .action("GetParameter")
 *                 .parameters(Map.of(
 *                         "Name", "my-parameter",
 *                         "WithDecryption", true))
 *                 .physicalResourceId(PhysicalResourceId.of(Date.now().toString())).build())
 *         .policy(AwsCustomResourcePolicy.fromSdkCalls(SdkCallsPolicyOptions.builder()
 *                 .resources(AwsCustomResourcePolicy.ANY_RESOURCE)
 *                 .build()))
 *         .build();
 * // Use the value in another construct with
 * getParameter.getResponseField("Parameter.Value");
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.106.0 (build e852934)", date = "2025-02-21T03:20:43.320Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.custom_resources.AwsCustomResourceProps")
@software.amazon.jsii.Jsii.Proxy(AwsCustomResourceProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface AwsCustomResourceProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * A name for the singleton Lambda function implementing this custom resource.
     * <p>
     * The function name will remain the same after the first AwsCustomResource is created in a stack.
     * <p>
     * Default: - AWS CloudFormation generates a unique physical ID and uses that
     * ID for the function's name. For more information, see Name Type.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getFunctionName() {
        return null;
    }

    /**
     * Whether to install the latest AWS SDK v2.
     * <p>
     * If not specified, this uses whatever JavaScript SDK version is the default in
     * AWS Lambda at the time of execution.
     * <p>
     * Otherwise, installs the latest version from 'npmjs.com'. The installation takes
     * around 60 seconds and requires internet connectivity.
     * <p>
     * The default can be controlled using the context key
     * <code>&#64;aws-cdk/customresources:installLatestAwsSdkDefault</code> is.
     * <p>
     * Default: - The value of `@aws-cdk/customresources:installLatestAwsSdkDefault`, otherwise `true`
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getInstallLatestAwsSdk() {
        return null;
    }

    /**
     * The Log Group used for logging of events emitted by the custom resource's lambda function.
     * <p>
     * Providing a user-controlled log group was rolled out to commercial regions on 2023-11-16.
     * If you are deploying to another type of region, please check regional availability first.
     * <p>
     * Default: - a default log group created by AWS Lambda
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.logs.ILogGroup getLogGroup() {
        return null;
    }

    /**
     * The number of days log events of the singleton Lambda function implementing this custom resource are kept in CloudWatch Logs.
     * <p>
     * This is a legacy API and we strongly recommend you migrate to <code>logGroup</code> if you can.
     * <code>logGroup</code> allows you to create a fully customizable log group and instruct the Lambda function to send logs to it.
     * <p>
     * Default: logs.RetentionDays.INFINITE
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.logs.RetentionDays getLogRetention() {
        return null;
    }

    /**
     * The memory size for the singleton Lambda function implementing this custom resource.
     * <p>
     * Default: 512 mega in case if installLatestAwsSdk is false.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getMemorySize() {
        return null;
    }

    /**
     * The AWS SDK call to make when the resource is created.
     * <p>
     * Default: - the call when the resource is updated
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.customresources.AwsSdkCall getOnCreate() {
        return null;
    }

    /**
     * The AWS SDK call to make when the resource is deleted.
     * <p>
     * Default: - no call
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.customresources.AwsSdkCall getOnDelete() {
        return null;
    }

    /**
     * The AWS SDK call to make when the resource is updated.
     * <p>
     * Default: - no call
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.customresources.AwsSdkCall getOnUpdate() {
        return null;
    }

    /**
     * The policy that will be added to the execution role of the Lambda function implementing this custom resource provider.
     * <p>
     * The custom resource also implements <code>iam.IGrantable</code>, making it possible
     * to use the <code>grantXxx()</code> methods.
     * <p>
     * As this custom resource uses a singleton Lambda function, it's important
     * to note the that function's role will eventually accumulate the
     * permissions/grants from all resources.
     * <p>
     * Note that a policy must be specified if <code>role</code> is not provided, as
     * by default a new role is created which requires policy changes to access
     * resources.
     * <p>
     * Default: - no policy added
     * <p>
     * @see <a href="Policy.fromSdkCalls">Policy.fromSdkCalls</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.customresources.AwsCustomResourcePolicy getPolicy() {
        return null;
    }

    /**
     * The policy to apply when this resource is removed from the application.
     * <p>
     * Default: cdk.RemovalPolicy.Destroy
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.RemovalPolicy getRemovalPolicy() {
        return null;
    }

    /**
     * Cloudformation Resource type.
     * <p>
     * Default: - Custom::AWS
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getResourceType() {
        return null;
    }

    /**
     * The execution role for the singleton Lambda function implementing this custom resource provider.
     * <p>
     * This role will apply to all <code>AwsCustomResource</code>
     * instances in the stack. The role must be assumable by the
     * <code>lambda.amazonaws.com</code> service principal.
     * <p>
     * Default: - a new role is created
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.iam.IRole getRole() {
        return null;
    }

    /**
     * The maximum time that can elapse before a custom resource operation times out.
     * <p>
     * You should not need to set this property. It is intended to allow quick turnaround
     * even if the implementor of the custom resource forgets to include a <code>try/catch</code>.
     * We have included the <code>try/catch</code>, and AWS service calls usually do not take an hour
     * to complete.
     * <p>
     * The value must be between 1 second and 3600 seconds.
     * <p>
     * Default: Duration.seconds(3600)
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.Duration getServiceTimeout() {
        return null;
    }

    /**
     * The timeout for the singleton Lambda function implementing this custom resource.
     * <p>
     * Default: Duration.minutes(2)
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.Duration getTimeout() {
        return null;
    }

    /**
     * The vpc to provision the lambda function in.
     * <p>
     * Default: - the function is not provisioned inside a vpc.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.ec2.IVpc getVpc() {
        return null;
    }

    /**
     * Which subnets from the VPC to place the lambda function in.
     * <p>
     * Only used if 'vpc' is supplied. Note: internet access for Lambdas
     * requires a NAT gateway, so picking Public subnets is not allowed.
     * <p>
     * Default: - the Vpc default strategy if not specified
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.ec2.SubnetSelection getVpcSubnets() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link AwsCustomResourceProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link AwsCustomResourceProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<AwsCustomResourceProps> {
        java.lang.String functionName;
        java.lang.Boolean installLatestAwsSdk;
        software.amazon.awscdk.services.logs.ILogGroup logGroup;
        software.amazon.awscdk.services.logs.RetentionDays logRetention;
        java.lang.Number memorySize;
        software.amazon.awscdk.customresources.AwsSdkCall onCreate;
        software.amazon.awscdk.customresources.AwsSdkCall onDelete;
        software.amazon.awscdk.customresources.AwsSdkCall onUpdate;
        software.amazon.awscdk.customresources.AwsCustomResourcePolicy policy;
        software.amazon.awscdk.RemovalPolicy removalPolicy;
        java.lang.String resourceType;
        software.amazon.awscdk.services.iam.IRole role;
        software.amazon.awscdk.Duration serviceTimeout;
        software.amazon.awscdk.Duration timeout;
        software.amazon.awscdk.services.ec2.IVpc vpc;
        software.amazon.awscdk.services.ec2.SubnetSelection vpcSubnets;

        /**
         * Sets the value of {@link AwsCustomResourceProps#getFunctionName}
         * @param functionName A name for the singleton Lambda function implementing this custom resource.
         *                     The function name will remain the same after the first AwsCustomResource is created in a stack.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder functionName(java.lang.String functionName) {
            this.functionName = functionName;
            return this;
        }

        /**
         * Sets the value of {@link AwsCustomResourceProps#getInstallLatestAwsSdk}
         * @param installLatestAwsSdk Whether to install the latest AWS SDK v2.
         *                            If not specified, this uses whatever JavaScript SDK version is the default in
         *                            AWS Lambda at the time of execution.
         *                            <p>
         *                            Otherwise, installs the latest version from 'npmjs.com'. The installation takes
         *                            around 60 seconds and requires internet connectivity.
         *                            <p>
         *                            The default can be controlled using the context key
         *                            <code>&#64;aws-cdk/customresources:installLatestAwsSdkDefault</code> is.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder installLatestAwsSdk(java.lang.Boolean installLatestAwsSdk) {
            this.installLatestAwsSdk = installLatestAwsSdk;
            return this;
        }

        /**
         * Sets the value of {@link AwsCustomResourceProps#getLogGroup}
         * @param logGroup The Log Group used for logging of events emitted by the custom resource's lambda function.
         *                 Providing a user-controlled log group was rolled out to commercial regions on 2023-11-16.
         *                 If you are deploying to another type of region, please check regional availability first.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder logGroup(software.amazon.awscdk.services.logs.ILogGroup logGroup) {
            this.logGroup = logGroup;
            return this;
        }

        /**
         * Sets the value of {@link AwsCustomResourceProps#getLogRetention}
         * @param logRetention The number of days log events of the singleton Lambda function implementing this custom resource are kept in CloudWatch Logs.
         *                     This is a legacy API and we strongly recommend you migrate to <code>logGroup</code> if you can.
         *                     <code>logGroup</code> allows you to create a fully customizable log group and instruct the Lambda function to send logs to it.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder logRetention(software.amazon.awscdk.services.logs.RetentionDays logRetention) {
            this.logRetention = logRetention;
            return this;
        }

        /**
         * Sets the value of {@link AwsCustomResourceProps#getMemorySize}
         * @param memorySize The memory size for the singleton Lambda function implementing this custom resource.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder memorySize(java.lang.Number memorySize) {
            this.memorySize = memorySize;
            return this;
        }

        /**
         * Sets the value of {@link AwsCustomResourceProps#getOnCreate}
         * @param onCreate The AWS SDK call to make when the resource is created.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder onCreate(software.amazon.awscdk.customresources.AwsSdkCall onCreate) {
            this.onCreate = onCreate;
            return this;
        }

        /**
         * Sets the value of {@link AwsCustomResourceProps#getOnDelete}
         * @param onDelete The AWS SDK call to make when the resource is deleted.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder onDelete(software.amazon.awscdk.customresources.AwsSdkCall onDelete) {
            this.onDelete = onDelete;
            return this;
        }

        /**
         * Sets the value of {@link AwsCustomResourceProps#getOnUpdate}
         * @param onUpdate The AWS SDK call to make when the resource is updated.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder onUpdate(software.amazon.awscdk.customresources.AwsSdkCall onUpdate) {
            this.onUpdate = onUpdate;
            return this;
        }

        /**
         * Sets the value of {@link AwsCustomResourceProps#getPolicy}
         * @param policy The policy that will be added to the execution role of the Lambda function implementing this custom resource provider.
         *               The custom resource also implements <code>iam.IGrantable</code>, making it possible
         *               to use the <code>grantXxx()</code> methods.
         *               <p>
         *               As this custom resource uses a singleton Lambda function, it's important
         *               to note the that function's role will eventually accumulate the
         *               permissions/grants from all resources.
         *               <p>
         *               Note that a policy must be specified if <code>role</code> is not provided, as
         *               by default a new role is created which requires policy changes to access
         *               resources.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder policy(software.amazon.awscdk.customresources.AwsCustomResourcePolicy policy) {
            this.policy = policy;
            return this;
        }

        /**
         * Sets the value of {@link AwsCustomResourceProps#getRemovalPolicy}
         * @param removalPolicy The policy to apply when this resource is removed from the application.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder removalPolicy(software.amazon.awscdk.RemovalPolicy removalPolicy) {
            this.removalPolicy = removalPolicy;
            return this;
        }

        /**
         * Sets the value of {@link AwsCustomResourceProps#getResourceType}
         * @param resourceType Cloudformation Resource type.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder resourceType(java.lang.String resourceType) {
            this.resourceType = resourceType;
            return this;
        }

        /**
         * Sets the value of {@link AwsCustomResourceProps#getRole}
         * @param role The execution role for the singleton Lambda function implementing this custom resource provider.
         *             This role will apply to all <code>AwsCustomResource</code>
         *             instances in the stack. The role must be assumable by the
         *             <code>lambda.amazonaws.com</code> service principal.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder role(software.amazon.awscdk.services.iam.IRole role) {
            this.role = role;
            return this;
        }

        /**
         * Sets the value of {@link AwsCustomResourceProps#getServiceTimeout}
         * @param serviceTimeout The maximum time that can elapse before a custom resource operation times out.
         *                       You should not need to set this property. It is intended to allow quick turnaround
         *                       even if the implementor of the custom resource forgets to include a <code>try/catch</code>.
         *                       We have included the <code>try/catch</code>, and AWS service calls usually do not take an hour
         *                       to complete.
         *                       <p>
         *                       The value must be between 1 second and 3600 seconds.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder serviceTimeout(software.amazon.awscdk.Duration serviceTimeout) {
            this.serviceTimeout = serviceTimeout;
            return this;
        }

        /**
         * Sets the value of {@link AwsCustomResourceProps#getTimeout}
         * @param timeout The timeout for the singleton Lambda function implementing this custom resource.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder timeout(software.amazon.awscdk.Duration timeout) {
            this.timeout = timeout;
            return this;
        }

        /**
         * Sets the value of {@link AwsCustomResourceProps#getVpc}
         * @param vpc The vpc to provision the lambda function in.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder vpc(software.amazon.awscdk.services.ec2.IVpc vpc) {
            this.vpc = vpc;
            return this;
        }

        /**
         * Sets the value of {@link AwsCustomResourceProps#getVpcSubnets}
         * @param vpcSubnets Which subnets from the VPC to place the lambda function in.
         *                   Only used if 'vpc' is supplied. Note: internet access for Lambdas
         *                   requires a NAT gateway, so picking Public subnets is not allowed.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder vpcSubnets(software.amazon.awscdk.services.ec2.SubnetSelection vpcSubnets) {
            this.vpcSubnets = vpcSubnets;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link AwsCustomResourceProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public AwsCustomResourceProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link AwsCustomResourceProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements AwsCustomResourceProps {
        private final java.lang.String functionName;
        private final java.lang.Boolean installLatestAwsSdk;
        private final software.amazon.awscdk.services.logs.ILogGroup logGroup;
        private final software.amazon.awscdk.services.logs.RetentionDays logRetention;
        private final java.lang.Number memorySize;
        private final software.amazon.awscdk.customresources.AwsSdkCall onCreate;
        private final software.amazon.awscdk.customresources.AwsSdkCall onDelete;
        private final software.amazon.awscdk.customresources.AwsSdkCall onUpdate;
        private final software.amazon.awscdk.customresources.AwsCustomResourcePolicy policy;
        private final software.amazon.awscdk.RemovalPolicy removalPolicy;
        private final java.lang.String resourceType;
        private final software.amazon.awscdk.services.iam.IRole role;
        private final software.amazon.awscdk.Duration serviceTimeout;
        private final software.amazon.awscdk.Duration timeout;
        private final software.amazon.awscdk.services.ec2.IVpc vpc;
        private final software.amazon.awscdk.services.ec2.SubnetSelection vpcSubnets;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.functionName = software.amazon.jsii.Kernel.get(this, "functionName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.installLatestAwsSdk = software.amazon.jsii.Kernel.get(this, "installLatestAwsSdk", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.logGroup = software.amazon.jsii.Kernel.get(this, "logGroup", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.logs.ILogGroup.class));
            this.logRetention = software.amazon.jsii.Kernel.get(this, "logRetention", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.logs.RetentionDays.class));
            this.memorySize = software.amazon.jsii.Kernel.get(this, "memorySize", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.onCreate = software.amazon.jsii.Kernel.get(this, "onCreate", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.customresources.AwsSdkCall.class));
            this.onDelete = software.amazon.jsii.Kernel.get(this, "onDelete", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.customresources.AwsSdkCall.class));
            this.onUpdate = software.amazon.jsii.Kernel.get(this, "onUpdate", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.customresources.AwsSdkCall.class));
            this.policy = software.amazon.jsii.Kernel.get(this, "policy", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.customresources.AwsCustomResourcePolicy.class));
            this.removalPolicy = software.amazon.jsii.Kernel.get(this, "removalPolicy", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.RemovalPolicy.class));
            this.resourceType = software.amazon.jsii.Kernel.get(this, "resourceType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.role = software.amazon.jsii.Kernel.get(this, "role", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.IRole.class));
            this.serviceTimeout = software.amazon.jsii.Kernel.get(this, "serviceTimeout", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.Duration.class));
            this.timeout = software.amazon.jsii.Kernel.get(this, "timeout", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.Duration.class));
            this.vpc = software.amazon.jsii.Kernel.get(this, "vpc", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.IVpc.class));
            this.vpcSubnets = software.amazon.jsii.Kernel.get(this, "vpcSubnets", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.SubnetSelection.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.functionName = builder.functionName;
            this.installLatestAwsSdk = builder.installLatestAwsSdk;
            this.logGroup = builder.logGroup;
            this.logRetention = builder.logRetention;
            this.memorySize = builder.memorySize;
            this.onCreate = builder.onCreate;
            this.onDelete = builder.onDelete;
            this.onUpdate = builder.onUpdate;
            this.policy = builder.policy;
            this.removalPolicy = builder.removalPolicy;
            this.resourceType = builder.resourceType;
            this.role = builder.role;
            this.serviceTimeout = builder.serviceTimeout;
            this.timeout = builder.timeout;
            this.vpc = builder.vpc;
            this.vpcSubnets = builder.vpcSubnets;
        }

        @Override
        public final java.lang.String getFunctionName() {
            return this.functionName;
        }

        @Override
        public final java.lang.Boolean getInstallLatestAwsSdk() {
            return this.installLatestAwsSdk;
        }

        @Override
        public final software.amazon.awscdk.services.logs.ILogGroup getLogGroup() {
            return this.logGroup;
        }

        @Override
        public final software.amazon.awscdk.services.logs.RetentionDays getLogRetention() {
            return this.logRetention;
        }

        @Override
        public final java.lang.Number getMemorySize() {
            return this.memorySize;
        }

        @Override
        public final software.amazon.awscdk.customresources.AwsSdkCall getOnCreate() {
            return this.onCreate;
        }

        @Override
        public final software.amazon.awscdk.customresources.AwsSdkCall getOnDelete() {
            return this.onDelete;
        }

        @Override
        public final software.amazon.awscdk.customresources.AwsSdkCall getOnUpdate() {
            return this.onUpdate;
        }

        @Override
        public final software.amazon.awscdk.customresources.AwsCustomResourcePolicy getPolicy() {
            return this.policy;
        }

        @Override
        public final software.amazon.awscdk.RemovalPolicy getRemovalPolicy() {
            return this.removalPolicy;
        }

        @Override
        public final java.lang.String getResourceType() {
            return this.resourceType;
        }

        @Override
        public final software.amazon.awscdk.services.iam.IRole getRole() {
            return this.role;
        }

        @Override
        public final software.amazon.awscdk.Duration getServiceTimeout() {
            return this.serviceTimeout;
        }

        @Override
        public final software.amazon.awscdk.Duration getTimeout() {
            return this.timeout;
        }

        @Override
        public final software.amazon.awscdk.services.ec2.IVpc getVpc() {
            return this.vpc;
        }

        @Override
        public final software.amazon.awscdk.services.ec2.SubnetSelection getVpcSubnets() {
            return this.vpcSubnets;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getFunctionName() != null) {
                data.set("functionName", om.valueToTree(this.getFunctionName()));
            }
            if (this.getInstallLatestAwsSdk() != null) {
                data.set("installLatestAwsSdk", om.valueToTree(this.getInstallLatestAwsSdk()));
            }
            if (this.getLogGroup() != null) {
                data.set("logGroup", om.valueToTree(this.getLogGroup()));
            }
            if (this.getLogRetention() != null) {
                data.set("logRetention", om.valueToTree(this.getLogRetention()));
            }
            if (this.getMemorySize() != null) {
                data.set("memorySize", om.valueToTree(this.getMemorySize()));
            }
            if (this.getOnCreate() != null) {
                data.set("onCreate", om.valueToTree(this.getOnCreate()));
            }
            if (this.getOnDelete() != null) {
                data.set("onDelete", om.valueToTree(this.getOnDelete()));
            }
            if (this.getOnUpdate() != null) {
                data.set("onUpdate", om.valueToTree(this.getOnUpdate()));
            }
            if (this.getPolicy() != null) {
                data.set("policy", om.valueToTree(this.getPolicy()));
            }
            if (this.getRemovalPolicy() != null) {
                data.set("removalPolicy", om.valueToTree(this.getRemovalPolicy()));
            }
            if (this.getResourceType() != null) {
                data.set("resourceType", om.valueToTree(this.getResourceType()));
            }
            if (this.getRole() != null) {
                data.set("role", om.valueToTree(this.getRole()));
            }
            if (this.getServiceTimeout() != null) {
                data.set("serviceTimeout", om.valueToTree(this.getServiceTimeout()));
            }
            if (this.getTimeout() != null) {
                data.set("timeout", om.valueToTree(this.getTimeout()));
            }
            if (this.getVpc() != null) {
                data.set("vpc", om.valueToTree(this.getVpc()));
            }
            if (this.getVpcSubnets() != null) {
                data.set("vpcSubnets", om.valueToTree(this.getVpcSubnets()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.custom_resources.AwsCustomResourceProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            AwsCustomResourceProps.Jsii$Proxy that = (AwsCustomResourceProps.Jsii$Proxy) o;

            if (this.functionName != null ? !this.functionName.equals(that.functionName) : that.functionName != null) return false;
            if (this.installLatestAwsSdk != null ? !this.installLatestAwsSdk.equals(that.installLatestAwsSdk) : that.installLatestAwsSdk != null) return false;
            if (this.logGroup != null ? !this.logGroup.equals(that.logGroup) : that.logGroup != null) return false;
            if (this.logRetention != null ? !this.logRetention.equals(that.logRetention) : that.logRetention != null) return false;
            if (this.memorySize != null ? !this.memorySize.equals(that.memorySize) : that.memorySize != null) return false;
            if (this.onCreate != null ? !this.onCreate.equals(that.onCreate) : that.onCreate != null) return false;
            if (this.onDelete != null ? !this.onDelete.equals(that.onDelete) : that.onDelete != null) return false;
            if (this.onUpdate != null ? !this.onUpdate.equals(that.onUpdate) : that.onUpdate != null) return false;
            if (this.policy != null ? !this.policy.equals(that.policy) : that.policy != null) return false;
            if (this.removalPolicy != null ? !this.removalPolicy.equals(that.removalPolicy) : that.removalPolicy != null) return false;
            if (this.resourceType != null ? !this.resourceType.equals(that.resourceType) : that.resourceType != null) return false;
            if (this.role != null ? !this.role.equals(that.role) : that.role != null) return false;
            if (this.serviceTimeout != null ? !this.serviceTimeout.equals(that.serviceTimeout) : that.serviceTimeout != null) return false;
            if (this.timeout != null ? !this.timeout.equals(that.timeout) : that.timeout != null) return false;
            if (this.vpc != null ? !this.vpc.equals(that.vpc) : that.vpc != null) return false;
            return this.vpcSubnets != null ? this.vpcSubnets.equals(that.vpcSubnets) : that.vpcSubnets == null;
        }

        @Override
        public final int hashCode() {
            int result = this.functionName != null ? this.functionName.hashCode() : 0;
            result = 31 * result + (this.installLatestAwsSdk != null ? this.installLatestAwsSdk.hashCode() : 0);
            result = 31 * result + (this.logGroup != null ? this.logGroup.hashCode() : 0);
            result = 31 * result + (this.logRetention != null ? this.logRetention.hashCode() : 0);
            result = 31 * result + (this.memorySize != null ? this.memorySize.hashCode() : 0);
            result = 31 * result + (this.onCreate != null ? this.onCreate.hashCode() : 0);
            result = 31 * result + (this.onDelete != null ? this.onDelete.hashCode() : 0);
            result = 31 * result + (this.onUpdate != null ? this.onUpdate.hashCode() : 0);
            result = 31 * result + (this.policy != null ? this.policy.hashCode() : 0);
            result = 31 * result + (this.removalPolicy != null ? this.removalPolicy.hashCode() : 0);
            result = 31 * result + (this.resourceType != null ? this.resourceType.hashCode() : 0);
            result = 31 * result + (this.role != null ? this.role.hashCode() : 0);
            result = 31 * result + (this.serviceTimeout != null ? this.serviceTimeout.hashCode() : 0);
            result = 31 * result + (this.timeout != null ? this.timeout.hashCode() : 0);
            result = 31 * result + (this.vpc != null ? this.vpc.hashCode() : 0);
            result = 31 * result + (this.vpcSubnets != null ? this.vpcSubnets.hashCode() : 0);
            return result;
        }
    }
}
