package software.amazon.awscdk.services.amplify;

/**
 * Properties for defining a <code>CfnDomain</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.amplify.*;
 * CfnDomainProps cfnDomainProps = CfnDomainProps.builder()
 *         .appId("appId")
 *         .domainName("domainName")
 *         .subDomainSettings(List.of(SubDomainSettingProperty.builder()
 *                 .branchName("branchName")
 *                 .prefix("prefix")
 *                 .build()))
 *         // the properties below are optional
 *         .autoSubDomainCreationPatterns(List.of("autoSubDomainCreationPatterns"))
 *         .autoSubDomainIamRole("autoSubDomainIamRole")
 *         .certificateSettings(CertificateSettingsProperty.builder()
 *                 .certificateType("certificateType")
 *                 .customCertificateArn("customCertificateArn")
 *                 .build())
 *         .enableAutoSubDomain(false)
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amplify-domain.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amplify-domain.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.106.0 (build e852934)", date = "2025-02-21T03:20:27.230Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_amplify.CfnDomainProps")
@software.amazon.jsii.Jsii.Proxy(CfnDomainProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnDomainProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The unique ID for an Amplify app.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amplify-domain.html#cfn-amplify-domain-appid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amplify-domain.html#cfn-amplify-domain-appid</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getAppId();

    /**
     * The domain name for the domain association.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amplify-domain.html#cfn-amplify-domain-domainname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amplify-domain.html#cfn-amplify-domain-domainname</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getDomainName();

    /**
     * The setting for the subdomain.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amplify-domain.html#cfn-amplify-domain-subdomainsettings">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amplify-domain.html#cfn-amplify-domain-subdomainsettings</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.Object getSubDomainSettings();

    /**
     * Sets the branch patterns for automatic subdomain creation.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amplify-domain.html#cfn-amplify-domain-autosubdomaincreationpatterns">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amplify-domain.html#cfn-amplify-domain-autosubdomaincreationpatterns</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getAutoSubDomainCreationPatterns() {
        return null;
    }

    /**
     * The required AWS Identity and Access Management (IAMlong) service role for the Amazon Resource Name (ARN) for automatically creating subdomains.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amplify-domain.html#cfn-amplify-domain-autosubdomainiamrole">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amplify-domain.html#cfn-amplify-domain-autosubdomainiamrole</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getAutoSubDomainIamRole() {
        return null;
    }

    /**
     * The type of SSL/TLS certificate to use for your custom domain.
     * <p>
     * If you don't specify a certificate type, Amplify uses the default certificate that it provisions and manages for you.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amplify-domain.html#cfn-amplify-domain-certificatesettings">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amplify-domain.html#cfn-amplify-domain-certificatesettings</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getCertificateSettings() {
        return null;
    }

    /**
     * Enables the automated creation of subdomains for branches.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amplify-domain.html#cfn-amplify-domain-enableautosubdomain">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-amplify-domain.html#cfn-amplify-domain-enableautosubdomain</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getEnableAutoSubDomain() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnDomainProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnDomainProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnDomainProps> {
        java.lang.String appId;
        java.lang.String domainName;
        java.lang.Object subDomainSettings;
        java.util.List<java.lang.String> autoSubDomainCreationPatterns;
        java.lang.String autoSubDomainIamRole;
        java.lang.Object certificateSettings;
        java.lang.Object enableAutoSubDomain;

        /**
         * Sets the value of {@link CfnDomainProps#getAppId}
         * @param appId The unique ID for an Amplify app. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder appId(java.lang.String appId) {
            this.appId = appId;
            return this;
        }

        /**
         * Sets the value of {@link CfnDomainProps#getDomainName}
         * @param domainName The domain name for the domain association. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder domainName(java.lang.String domainName) {
            this.domainName = domainName;
            return this;
        }

        /**
         * Sets the value of {@link CfnDomainProps#getSubDomainSettings}
         * @param subDomainSettings The setting for the subdomain. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder subDomainSettings(software.amazon.awscdk.IResolvable subDomainSettings) {
            this.subDomainSettings = subDomainSettings;
            return this;
        }

        /**
         * Sets the value of {@link CfnDomainProps#getSubDomainSettings}
         * @param subDomainSettings The setting for the subdomain. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder subDomainSettings(java.util.List<? extends java.lang.Object> subDomainSettings) {
            this.subDomainSettings = subDomainSettings;
            return this;
        }

        /**
         * Sets the value of {@link CfnDomainProps#getAutoSubDomainCreationPatterns}
         * @param autoSubDomainCreationPatterns Sets the branch patterns for automatic subdomain creation.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder autoSubDomainCreationPatterns(java.util.List<java.lang.String> autoSubDomainCreationPatterns) {
            this.autoSubDomainCreationPatterns = autoSubDomainCreationPatterns;
            return this;
        }

        /**
         * Sets the value of {@link CfnDomainProps#getAutoSubDomainIamRole}
         * @param autoSubDomainIamRole The required AWS Identity and Access Management (IAMlong) service role for the Amazon Resource Name (ARN) for automatically creating subdomains.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder autoSubDomainIamRole(java.lang.String autoSubDomainIamRole) {
            this.autoSubDomainIamRole = autoSubDomainIamRole;
            return this;
        }

        /**
         * Sets the value of {@link CfnDomainProps#getCertificateSettings}
         * @param certificateSettings The type of SSL/TLS certificate to use for your custom domain.
         *                            If you don't specify a certificate type, Amplify uses the default certificate that it provisions and manages for you.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder certificateSettings(software.amazon.awscdk.IResolvable certificateSettings) {
            this.certificateSettings = certificateSettings;
            return this;
        }

        /**
         * Sets the value of {@link CfnDomainProps#getCertificateSettings}
         * @param certificateSettings The type of SSL/TLS certificate to use for your custom domain.
         *                            If you don't specify a certificate type, Amplify uses the default certificate that it provisions and manages for you.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder certificateSettings(software.amazon.awscdk.services.amplify.CfnDomain.CertificateSettingsProperty certificateSettings) {
            this.certificateSettings = certificateSettings;
            return this;
        }

        /**
         * Sets the value of {@link CfnDomainProps#getEnableAutoSubDomain}
         * @param enableAutoSubDomain Enables the automated creation of subdomains for branches.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder enableAutoSubDomain(java.lang.Boolean enableAutoSubDomain) {
            this.enableAutoSubDomain = enableAutoSubDomain;
            return this;
        }

        /**
         * Sets the value of {@link CfnDomainProps#getEnableAutoSubDomain}
         * @param enableAutoSubDomain Enables the automated creation of subdomains for branches.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder enableAutoSubDomain(software.amazon.awscdk.IResolvable enableAutoSubDomain) {
            this.enableAutoSubDomain = enableAutoSubDomain;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnDomainProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnDomainProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnDomainProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnDomainProps {
        private final java.lang.String appId;
        private final java.lang.String domainName;
        private final java.lang.Object subDomainSettings;
        private final java.util.List<java.lang.String> autoSubDomainCreationPatterns;
        private final java.lang.String autoSubDomainIamRole;
        private final java.lang.Object certificateSettings;
        private final java.lang.Object enableAutoSubDomain;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.appId = software.amazon.jsii.Kernel.get(this, "appId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.domainName = software.amazon.jsii.Kernel.get(this, "domainName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.subDomainSettings = software.amazon.jsii.Kernel.get(this, "subDomainSettings", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.autoSubDomainCreationPatterns = software.amazon.jsii.Kernel.get(this, "autoSubDomainCreationPatterns", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.autoSubDomainIamRole = software.amazon.jsii.Kernel.get(this, "autoSubDomainIamRole", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.certificateSettings = software.amazon.jsii.Kernel.get(this, "certificateSettings", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.enableAutoSubDomain = software.amazon.jsii.Kernel.get(this, "enableAutoSubDomain", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.appId = java.util.Objects.requireNonNull(builder.appId, "appId is required");
            this.domainName = java.util.Objects.requireNonNull(builder.domainName, "domainName is required");
            this.subDomainSettings = java.util.Objects.requireNonNull(builder.subDomainSettings, "subDomainSettings is required");
            this.autoSubDomainCreationPatterns = builder.autoSubDomainCreationPatterns;
            this.autoSubDomainIamRole = builder.autoSubDomainIamRole;
            this.certificateSettings = builder.certificateSettings;
            this.enableAutoSubDomain = builder.enableAutoSubDomain;
        }

        @Override
        public final java.lang.String getAppId() {
            return this.appId;
        }

        @Override
        public final java.lang.String getDomainName() {
            return this.domainName;
        }

        @Override
        public final java.lang.Object getSubDomainSettings() {
            return this.subDomainSettings;
        }

        @Override
        public final java.util.List<java.lang.String> getAutoSubDomainCreationPatterns() {
            return this.autoSubDomainCreationPatterns;
        }

        @Override
        public final java.lang.String getAutoSubDomainIamRole() {
            return this.autoSubDomainIamRole;
        }

        @Override
        public final java.lang.Object getCertificateSettings() {
            return this.certificateSettings;
        }

        @Override
        public final java.lang.Object getEnableAutoSubDomain() {
            return this.enableAutoSubDomain;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("appId", om.valueToTree(this.getAppId()));
            data.set("domainName", om.valueToTree(this.getDomainName()));
            data.set("subDomainSettings", om.valueToTree(this.getSubDomainSettings()));
            if (this.getAutoSubDomainCreationPatterns() != null) {
                data.set("autoSubDomainCreationPatterns", om.valueToTree(this.getAutoSubDomainCreationPatterns()));
            }
            if (this.getAutoSubDomainIamRole() != null) {
                data.set("autoSubDomainIamRole", om.valueToTree(this.getAutoSubDomainIamRole()));
            }
            if (this.getCertificateSettings() != null) {
                data.set("certificateSettings", om.valueToTree(this.getCertificateSettings()));
            }
            if (this.getEnableAutoSubDomain() != null) {
                data.set("enableAutoSubDomain", om.valueToTree(this.getEnableAutoSubDomain()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_amplify.CfnDomainProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnDomainProps.Jsii$Proxy that = (CfnDomainProps.Jsii$Proxy) o;

            if (!appId.equals(that.appId)) return false;
            if (!domainName.equals(that.domainName)) return false;
            if (!subDomainSettings.equals(that.subDomainSettings)) return false;
            if (this.autoSubDomainCreationPatterns != null ? !this.autoSubDomainCreationPatterns.equals(that.autoSubDomainCreationPatterns) : that.autoSubDomainCreationPatterns != null) return false;
            if (this.autoSubDomainIamRole != null ? !this.autoSubDomainIamRole.equals(that.autoSubDomainIamRole) : that.autoSubDomainIamRole != null) return false;
            if (this.certificateSettings != null ? !this.certificateSettings.equals(that.certificateSettings) : that.certificateSettings != null) return false;
            return this.enableAutoSubDomain != null ? this.enableAutoSubDomain.equals(that.enableAutoSubDomain) : that.enableAutoSubDomain == null;
        }

        @Override
        public final int hashCode() {
            int result = this.appId.hashCode();
            result = 31 * result + (this.domainName.hashCode());
            result = 31 * result + (this.subDomainSettings.hashCode());
            result = 31 * result + (this.autoSubDomainCreationPatterns != null ? this.autoSubDomainCreationPatterns.hashCode() : 0);
            result = 31 * result + (this.autoSubDomainIamRole != null ? this.autoSubDomainIamRole.hashCode() : 0);
            result = 31 * result + (this.certificateSettings != null ? this.certificateSettings.hashCode() : 0);
            result = 31 * result + (this.enableAutoSubDomain != null ? this.enableAutoSubDomain.hashCode() : 0);
            return result;
        }
    }
}
