package software.amazon.awscdk.services.apigateway;

/**
 * Example:
 * <p>
 * <blockquote><pre>
 * RestApi api;
 * IDomainName domainName = DomainName.fromDomainNameAttributes(this, "DomainName", DomainNameAttributes.builder()
 *         .domainName("domainName")
 *         .domainNameAliasHostedZoneId("domainNameAliasHostedZoneId")
 *         .domainNameAliasTarget("domainNameAliasTarget")
 *         .build());
 * BasePathMapping.Builder.create(this, "BasePathMapping")
 *         .domainName(domainName)
 *         .restApi(api)
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.106.0 (build e852934)", date = "2025-02-21T03:20:27.430Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_apigateway.DomainName")
public class DomainName extends software.amazon.awscdk.Resource implements software.amazon.awscdk.services.apigateway.IDomainName {

    protected DomainName(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected DomainName(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public DomainName(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.apigateway.DomainNameProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Imports an existing domain name.
     * <p>
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param attrs This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.apigateway.IDomainName fromDomainNameAttributes(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.apigateway.DomainNameAttributes attrs) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.apigateway.DomainName.class, "fromDomainNameAttributes", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.apigateway.IDomainName.class), new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(attrs, "attrs is required") });
    }

    /**
     * Maps this domain to an API endpoint.
     * <p>
     * This uses the ApiMapping from ApiGatewayV2 which supports multi-level paths, but
     * also only supports:
     * <p>
     * <ul>
     * <li>SecurityPolicy.TLS_1_2</li>
     * <li>EndpointType.REGIONAL</li>
     * </ul>
     * <p>
     * @param targetStage the target API stage. This parameter is required.
     * @param options Options for mapping to a stage.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void addApiMapping(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.apigateway.IStage targetStage, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.apigateway.ApiMappingOptions options) {
        software.amazon.jsii.Kernel.call(this, "addApiMapping", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(targetStage, "targetStage is required"), options });
    }

    /**
     * Maps this domain to an API endpoint.
     * <p>
     * This uses the ApiMapping from ApiGatewayV2 which supports multi-level paths, but
     * also only supports:
     * <p>
     * <ul>
     * <li>SecurityPolicy.TLS_1_2</li>
     * <li>EndpointType.REGIONAL</li>
     * </ul>
     * <p>
     * @param targetStage the target API stage. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void addApiMapping(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.apigateway.IStage targetStage) {
        software.amazon.jsii.Kernel.call(this, "addApiMapping", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(targetStage, "targetStage is required") });
    }

    /**
     * Maps this domain to an API endpoint.
     * <p>
     * This uses the BasePathMapping from ApiGateway v1 which does not support multi-level paths.
     * <p>
     * If you need to create a mapping for a multi-level path use <code>addApiMapping</code> instead.
     * <p>
     * @param targetApi That target API endpoint, requests will be mapped to the deployment stage. This parameter is required.
     * @param options Options for mapping to base path with or without a stage.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.apigateway.BasePathMapping addBasePathMapping(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.apigateway.IRestApi targetApi, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.apigateway.BasePathMappingOptions options) {
        return software.amazon.jsii.Kernel.call(this, "addBasePathMapping", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.apigateway.BasePathMapping.class), new Object[] { java.util.Objects.requireNonNull(targetApi, "targetApi is required"), options });
    }

    /**
     * Maps this domain to an API endpoint.
     * <p>
     * This uses the BasePathMapping from ApiGateway v1 which does not support multi-level paths.
     * <p>
     * If you need to create a mapping for a multi-level path use <code>addApiMapping</code> instead.
     * <p>
     * @param targetApi That target API endpoint, requests will be mapped to the deployment stage. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.apigateway.BasePathMapping addBasePathMapping(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.apigateway.IRestApi targetApi) {
        return software.amazon.jsii.Kernel.call(this, "addBasePathMapping", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.apigateway.BasePathMapping.class), new Object[] { java.util.Objects.requireNonNull(targetApi, "targetApi is required") });
    }

    /**
     * The domain name (e.g. <code>example.com</code>).
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getDomainName() {
        return software.amazon.jsii.Kernel.get(this, "domainName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The Route53 alias target to use in order to connect a record set to this domain through an alias.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getDomainNameAliasDomainName() {
        return software.amazon.jsii.Kernel.get(this, "domainNameAliasDomainName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The Route53 hosted zone ID to use in order to connect a record set to this domain through an alias.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getDomainNameAliasHostedZoneId() {
        return software.amazon.jsii.Kernel.get(this, "domainNameAliasHostedZoneId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.apigateway.DomainName}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.apigateway.DomainName> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope This parameter is required.
         * @param id This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.apigateway.DomainNameProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.apigateway.DomainNameProps.Builder();
        }

        /**
         * The reference to an AWS-managed certificate for use by the edge-optimized endpoint for the domain name.
         * <p>
         * For "EDGE" domain names, the certificate
         * needs to be in the US East (N. Virginia) region.
         * <p>
         * @return {@code this}
         * @param certificate The reference to an AWS-managed certificate for use by the edge-optimized endpoint for the domain name. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder certificate(final software.amazon.awscdk.services.certificatemanager.ICertificate certificate) {
            this.props.certificate(certificate);
            return this;
        }

        /**
         * The custom domain name for your API.
         * <p>
         * Uppercase letters are not supported.
         * <p>
         * @return {@code this}
         * @param domainName The custom domain name for your API. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder domainName(final java.lang.String domainName) {
            this.props.domainName(domainName);
            return this;
        }

        /**
         * The base path name that callers of the API must provide in the URL after the domain name (e.g. <code>example.com/base-path</code>). If you specify this property, it can't be an empty string.
         * <p>
         * Default: - map requests from the domain root (e.g. `example.com`).
         * <p>
         * @return {@code this}
         * @param basePath The base path name that callers of the API must provide in the URL after the domain name (e.g. <code>example.com/base-path</code>). If you specify this property, it can't be an empty string. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder basePath(final java.lang.String basePath) {
            this.props.basePath(basePath);
            return this;
        }

        /**
         * The type of endpoint for this DomainName.
         * <p>
         * Default: REGIONAL
         * <p>
         * @return {@code this}
         * @param endpointType The type of endpoint for this DomainName. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder endpointType(final software.amazon.awscdk.services.apigateway.EndpointType endpointType) {
            this.props.endpointType(endpointType);
            return this;
        }

        /**
         * The mutual TLS authentication configuration for a custom domain name.
         * <p>
         * Default: - mTLS is not configured.
         * <p>
         * @return {@code this}
         * @param mtls The mutual TLS authentication configuration for a custom domain name. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder mtls(final software.amazon.awscdk.services.apigateway.MTLSConfig mtls) {
            this.props.mtls(mtls);
            return this;
        }

        /**
         * The Transport Layer Security (TLS) version + cipher suite for this domain name.
         * <p>
         * Default: SecurityPolicy.TLS_1_2
         * <p>
         * @return {@code this}
         * @see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-domainname.html">https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-apigateway-domainname.html</a>
         * @param securityPolicy The Transport Layer Security (TLS) version + cipher suite for this domain name. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder securityPolicy(final software.amazon.awscdk.services.apigateway.SecurityPolicy securityPolicy) {
            this.props.securityPolicy(securityPolicy);
            return this;
        }

        /**
         * If specified, all requests to this domain will be mapped to the production deployment of this API.
         * <p>
         * If you wish to map this domain to multiple APIs
         * with different base paths, use <code>addBasePathMapping</code> or <code>addApiMapping</code>.
         * <p>
         * Default: - you will have to call `addBasePathMapping` to map this domain to
         * API endpoints.
         * <p>
         * @return {@code this}
         * @param mapping If specified, all requests to this domain will be mapped to the production deployment of this API. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder mapping(final software.amazon.awscdk.services.apigateway.IRestApi mapping) {
            this.props.mapping(mapping);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.apigateway.DomainName}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.apigateway.DomainName build() {
            return new software.amazon.awscdk.services.apigateway.DomainName(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
