package software.amazon.awscdk.services.apigatewayv2;

/**
 * Results of binding an authorizer to an http route.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.apigatewayv2.*;
 * HttpRouteAuthorizerConfig httpRouteAuthorizerConfig = HttpRouteAuthorizerConfig.builder()
 *         .authorizationType("authorizationType")
 *         // the properties below are optional
 *         .authorizationScopes(List.of("authorizationScopes"))
 *         .authorizerId("authorizerId")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.106.0 (build e852934)", date = "2025-02-21T03:20:27.630Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_apigatewayv2.HttpRouteAuthorizerConfig")
@software.amazon.jsii.Jsii.Proxy(HttpRouteAuthorizerConfig.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface HttpRouteAuthorizerConfig extends software.amazon.jsii.JsiiSerializable {

    /**
     * The type of authorization.
     * <p>
     * Possible values are:
     * <p>
     * <ul>
     * <li>AWS_IAM - IAM Authorizer</li>
     * <li>JWT - JSON Web Token Authorizer</li>
     * <li>CUSTOM - Lambda Authorizer</li>
     * <li>NONE - No Authorization</li>
     * </ul>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getAuthorizationType();

    /**
     * The list of OIDC scopes to include in the authorization.
     * <p>
     * Default: - no authorization scopes
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getAuthorizationScopes() {
        return null;
    }

    /**
     * The authorizer id.
     * <p>
     * Default: - No authorizer id (useful for AWS_IAM route authorizer)
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getAuthorizerId() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link HttpRouteAuthorizerConfig}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link HttpRouteAuthorizerConfig}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<HttpRouteAuthorizerConfig> {
        java.lang.String authorizationType;
        java.util.List<java.lang.String> authorizationScopes;
        java.lang.String authorizerId;

        /**
         * Sets the value of {@link HttpRouteAuthorizerConfig#getAuthorizationType}
         * @param authorizationType The type of authorization. This parameter is required.
         *                          Possible values are:
         *                          <p>
         *                          <ul>
         *                          <li>AWS_IAM - IAM Authorizer</li>
         *                          <li>JWT - JSON Web Token Authorizer</li>
         *                          <li>CUSTOM - Lambda Authorizer</li>
         *                          <li>NONE - No Authorization</li>
         *                          </ul>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder authorizationType(java.lang.String authorizationType) {
            this.authorizationType = authorizationType;
            return this;
        }

        /**
         * Sets the value of {@link HttpRouteAuthorizerConfig#getAuthorizationScopes}
         * @param authorizationScopes The list of OIDC scopes to include in the authorization.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder authorizationScopes(java.util.List<java.lang.String> authorizationScopes) {
            this.authorizationScopes = authorizationScopes;
            return this;
        }

        /**
         * Sets the value of {@link HttpRouteAuthorizerConfig#getAuthorizerId}
         * @param authorizerId The authorizer id.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder authorizerId(java.lang.String authorizerId) {
            this.authorizerId = authorizerId;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link HttpRouteAuthorizerConfig}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public HttpRouteAuthorizerConfig build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link HttpRouteAuthorizerConfig}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements HttpRouteAuthorizerConfig {
        private final java.lang.String authorizationType;
        private final java.util.List<java.lang.String> authorizationScopes;
        private final java.lang.String authorizerId;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.authorizationType = software.amazon.jsii.Kernel.get(this, "authorizationType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.authorizationScopes = software.amazon.jsii.Kernel.get(this, "authorizationScopes", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.authorizerId = software.amazon.jsii.Kernel.get(this, "authorizerId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.authorizationType = java.util.Objects.requireNonNull(builder.authorizationType, "authorizationType is required");
            this.authorizationScopes = builder.authorizationScopes;
            this.authorizerId = builder.authorizerId;
        }

        @Override
        public final java.lang.String getAuthorizationType() {
            return this.authorizationType;
        }

        @Override
        public final java.util.List<java.lang.String> getAuthorizationScopes() {
            return this.authorizationScopes;
        }

        @Override
        public final java.lang.String getAuthorizerId() {
            return this.authorizerId;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("authorizationType", om.valueToTree(this.getAuthorizationType()));
            if (this.getAuthorizationScopes() != null) {
                data.set("authorizationScopes", om.valueToTree(this.getAuthorizationScopes()));
            }
            if (this.getAuthorizerId() != null) {
                data.set("authorizerId", om.valueToTree(this.getAuthorizerId()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_apigatewayv2.HttpRouteAuthorizerConfig"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            HttpRouteAuthorizerConfig.Jsii$Proxy that = (HttpRouteAuthorizerConfig.Jsii$Proxy) o;

            if (!authorizationType.equals(that.authorizationType)) return false;
            if (this.authorizationScopes != null ? !this.authorizationScopes.equals(that.authorizationScopes) : that.authorizationScopes != null) return false;
            return this.authorizerId != null ? this.authorizerId.equals(that.authorizerId) : that.authorizerId == null;
        }

        @Override
        public final int hashCode() {
            int result = this.authorizationType.hashCode();
            result = 31 * result + (this.authorizationScopes != null ? this.authorizationScopes.hashCode() : 0);
            result = 31 * result + (this.authorizerId != null ? this.authorizerId.hashCode() : 0);
            return result;
        }
    }
}
