package software.amazon.awscdk.services.apigatewayv2;

/**
 * Options to the WebSocketRouteIntegration during its bind operation.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.apigatewayv2.*;
 * import software.constructs.*;
 * Construct construct;
 * WebSocketRoute webSocketRoute;
 * WebSocketRouteIntegrationBindOptions webSocketRouteIntegrationBindOptions = WebSocketRouteIntegrationBindOptions.builder()
 *         .route(webSocketRoute)
 *         .scope(construct)
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.106.0 (build e852934)", date = "2025-02-21T03:20:27.675Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_apigatewayv2.WebSocketRouteIntegrationBindOptions")
@software.amazon.jsii.Jsii.Proxy(WebSocketRouteIntegrationBindOptions.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface WebSocketRouteIntegrationBindOptions extends software.amazon.jsii.JsiiSerializable {

    /**
     * The route to which this is being bound.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.apigatewayv2.IWebSocketRoute getRoute();

    /**
     * The current scope in which the bind is occurring.
     * <p>
     * If the <code>WebSocketRouteIntegration</code> being bound creates additional constructs,
     * this will be used as their parent scope.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.constructs.Construct getScope();

    /**
     * @return a {@link Builder} of {@link WebSocketRouteIntegrationBindOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link WebSocketRouteIntegrationBindOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<WebSocketRouteIntegrationBindOptions> {
        software.amazon.awscdk.services.apigatewayv2.IWebSocketRoute route;
        software.constructs.Construct scope;

        /**
         * Sets the value of {@link WebSocketRouteIntegrationBindOptions#getRoute}
         * @param route The route to which this is being bound. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder route(software.amazon.awscdk.services.apigatewayv2.IWebSocketRoute route) {
            this.route = route;
            return this;
        }

        /**
         * Sets the value of {@link WebSocketRouteIntegrationBindOptions#getScope}
         * @param scope The current scope in which the bind is occurring. This parameter is required.
         *              If the <code>WebSocketRouteIntegration</code> being bound creates additional constructs,
         *              this will be used as their parent scope.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder scope(software.constructs.Construct scope) {
            this.scope = scope;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link WebSocketRouteIntegrationBindOptions}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public WebSocketRouteIntegrationBindOptions build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link WebSocketRouteIntegrationBindOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements WebSocketRouteIntegrationBindOptions {
        private final software.amazon.awscdk.services.apigatewayv2.IWebSocketRoute route;
        private final software.constructs.Construct scope;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.route = software.amazon.jsii.Kernel.get(this, "route", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.apigatewayv2.IWebSocketRoute.class));
            this.scope = software.amazon.jsii.Kernel.get(this, "scope", software.amazon.jsii.NativeType.forClass(software.constructs.Construct.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.route = java.util.Objects.requireNonNull(builder.route, "route is required");
            this.scope = java.util.Objects.requireNonNull(builder.scope, "scope is required");
        }

        @Override
        public final software.amazon.awscdk.services.apigatewayv2.IWebSocketRoute getRoute() {
            return this.route;
        }

        @Override
        public final software.constructs.Construct getScope() {
            return this.scope;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("route", om.valueToTree(this.getRoute()));
            data.set("scope", om.valueToTree(this.getScope()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_apigatewayv2.WebSocketRouteIntegrationBindOptions"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            WebSocketRouteIntegrationBindOptions.Jsii$Proxy that = (WebSocketRouteIntegrationBindOptions.Jsii$Proxy) o;

            if (!route.equals(that.route)) return false;
            return this.scope.equals(that.scope);
        }

        @Override
        public final int hashCode() {
            int result = this.route.hashCode();
            result = 31 * result + (this.scope.hashCode());
            return result;
        }
    }
}
