package software.amazon.awscdk.services.appconfig;

/**
 * Properties for the Environment construct.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * Application app = new Application(this, "MyApp");
 * Environment env = Environment.Builder.create(this, "MyEnv")
 *         .application(app)
 *         .build();
 * HostedConfiguration.Builder.create(this, "MyHostedConfig")
 *         .application(app)
 *         .deployTo(List.of(env))
 *         .content(ConfigurationContent.fromInlineText("This is my configuration content."))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.106.0 (build e852934)", date = "2025-02-21T03:20:27.767Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_appconfig.EnvironmentProps")
@software.amazon.jsii.Jsii.Proxy(EnvironmentProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface EnvironmentProps extends software.amazon.jsii.JsiiSerializable, software.amazon.awscdk.services.appconfig.EnvironmentOptions {

    /**
     * The application to be associated with the environment.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appconfig.IApplication getApplication();

    /**
     * @return a {@link Builder} of {@link EnvironmentProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link EnvironmentProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<EnvironmentProps> {
        software.amazon.awscdk.services.appconfig.IApplication application;
        software.amazon.awscdk.services.appconfig.DeletionProtectionCheck deletionProtectionCheck;
        java.lang.String description;
        java.lang.String environmentName;
        java.util.List<software.amazon.awscdk.services.appconfig.Monitor> monitors;

        /**
         * Sets the value of {@link EnvironmentProps#getApplication}
         * @param application The application to be associated with the environment. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder application(software.amazon.awscdk.services.appconfig.IApplication application) {
            this.application = application;
            return this;
        }

        /**
         * Sets the value of {@link EnvironmentProps#getDeletionProtectionCheck}
         * @param deletionProtectionCheck A property to prevent accidental deletion of active environments.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder deletionProtectionCheck(software.amazon.awscdk.services.appconfig.DeletionProtectionCheck deletionProtectionCheck) {
            this.deletionProtectionCheck = deletionProtectionCheck;
            return this;
        }

        /**
         * Sets the value of {@link EnvironmentProps#getDescription}
         * @param description The description of the environment.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder description(java.lang.String description) {
            this.description = description;
            return this;
        }

        /**
         * Sets the value of {@link EnvironmentProps#getEnvironmentName}
         * @param environmentName The name of the environment.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder environmentName(java.lang.String environmentName) {
            this.environmentName = environmentName;
            return this;
        }

        /**
         * Sets the value of {@link EnvironmentProps#getMonitors}
         * @param monitors The monitors for the environment.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder monitors(java.util.List<? extends software.amazon.awscdk.services.appconfig.Monitor> monitors) {
            this.monitors = (java.util.List<software.amazon.awscdk.services.appconfig.Monitor>)monitors;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link EnvironmentProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public EnvironmentProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link EnvironmentProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements EnvironmentProps {
        private final software.amazon.awscdk.services.appconfig.IApplication application;
        private final software.amazon.awscdk.services.appconfig.DeletionProtectionCheck deletionProtectionCheck;
        private final java.lang.String description;
        private final java.lang.String environmentName;
        private final java.util.List<software.amazon.awscdk.services.appconfig.Monitor> monitors;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.application = software.amazon.jsii.Kernel.get(this, "application", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.appconfig.IApplication.class));
            this.deletionProtectionCheck = software.amazon.jsii.Kernel.get(this, "deletionProtectionCheck", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.appconfig.DeletionProtectionCheck.class));
            this.description = software.amazon.jsii.Kernel.get(this, "description", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.environmentName = software.amazon.jsii.Kernel.get(this, "environmentName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.monitors = software.amazon.jsii.Kernel.get(this, "monitors", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.appconfig.Monitor.class)));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.application = java.util.Objects.requireNonNull(builder.application, "application is required");
            this.deletionProtectionCheck = builder.deletionProtectionCheck;
            this.description = builder.description;
            this.environmentName = builder.environmentName;
            this.monitors = (java.util.List<software.amazon.awscdk.services.appconfig.Monitor>)builder.monitors;
        }

        @Override
        public final software.amazon.awscdk.services.appconfig.IApplication getApplication() {
            return this.application;
        }

        @Override
        public final software.amazon.awscdk.services.appconfig.DeletionProtectionCheck getDeletionProtectionCheck() {
            return this.deletionProtectionCheck;
        }

        @Override
        public final java.lang.String getDescription() {
            return this.description;
        }

        @Override
        public final java.lang.String getEnvironmentName() {
            return this.environmentName;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.services.appconfig.Monitor> getMonitors() {
            return this.monitors;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("application", om.valueToTree(this.getApplication()));
            if (this.getDeletionProtectionCheck() != null) {
                data.set("deletionProtectionCheck", om.valueToTree(this.getDeletionProtectionCheck()));
            }
            if (this.getDescription() != null) {
                data.set("description", om.valueToTree(this.getDescription()));
            }
            if (this.getEnvironmentName() != null) {
                data.set("environmentName", om.valueToTree(this.getEnvironmentName()));
            }
            if (this.getMonitors() != null) {
                data.set("monitors", om.valueToTree(this.getMonitors()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_appconfig.EnvironmentProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            EnvironmentProps.Jsii$Proxy that = (EnvironmentProps.Jsii$Proxy) o;

            if (!application.equals(that.application)) return false;
            if (this.deletionProtectionCheck != null ? !this.deletionProtectionCheck.equals(that.deletionProtectionCheck) : that.deletionProtectionCheck != null) return false;
            if (this.description != null ? !this.description.equals(that.description) : that.description != null) return false;
            if (this.environmentName != null ? !this.environmentName.equals(that.environmentName) : that.environmentName != null) return false;
            return this.monitors != null ? this.monitors.equals(that.monitors) : that.monitors == null;
        }

        @Override
        public final int hashCode() {
            int result = this.application.hashCode();
            result = 31 * result + (this.deletionProtectionCheck != null ? this.deletionProtectionCheck.hashCode() : 0);
            result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
            result = 31 * result + (this.environmentName != null ? this.environmentName.hashCode() : 0);
            result = 31 * result + (this.monitors != null ? this.monitors.hashCode() : 0);
            return result;
        }
    }
}
