package software.amazon.awscdk.services.appconfig;

/**
 * Use an Amazon EventBridge event bus as an event destination.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * IEventBus bus = EventBus.fromEventBusName(this, "MyEventBus", "default");
 * Extension.Builder.create(this, "MyExtension")
 *         .actions(List.of(
 *             Action.Builder.create()
 *                     .actionPoints(List.of(ActionPoint.ON_DEPLOYMENT_START))
 *                     .eventDestination(new EventBridgeDestination(bus))
 *                     .build()))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.106.0 (build e852934)", date = "2025-02-21T03:20:27.768Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_appconfig.EventBridgeDestination")
public class EventBridgeDestination extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.appconfig.IEventDestination {

    protected EventBridgeDestination(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected EventBridgeDestination(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param bus This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public EventBridgeDestination(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.events.IEventBus bus) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(bus, "bus is required") });
    }

    /**
     * The URI of the extension event destination.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getExtensionUri() {
        return software.amazon.jsii.Kernel.get(this, "extensionUri", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The type of the extension event destination.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appconfig.SourceType getType() {
        return software.amazon.jsii.Kernel.get(this, "type", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.appconfig.SourceType.class));
    }
}
