package software.amazon.awscdk.services.appconfig;

/**
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.106.0 (build e852934)", date = "2025-02-21T03:20:27.792Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_appconfig.IEnvironment")
@software.amazon.jsii.Jsii.Proxy(IEnvironment.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface IEnvironment extends software.amazon.jsii.JsiiSerializable, software.amazon.awscdk.IResource {

    /**
     * The ID of the application associated to the environment.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getApplicationId();

    /**
     * The Amazon Resource Name (ARN) of the environment.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getEnvironmentArn();

    /**
     * The ID of the environment.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getEnvironmentId();

    /**
     * The application associated with the environment.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.appconfig.IApplication getApplication() {
        return null;
    }

    /**
     * The description of the environment.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getDescription() {
        return null;
    }

    /**
     * The monitors for the environment.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.services.appconfig.Monitor> getMonitors() {
        return null;
    }

    /**
     * The name of the environment.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getName() {
        return null;
    }

    /**
     * Creates a deployment of the supplied configuration to this environment.
     * <p>
     * Note that you can only deploy one configuration at a time to an environment.
     * However, you can deploy one configuration each to different environments at the same time.
     * If more than one deployment is requested for this environment, they will occur in the same order they were provided.
     * <p>
     * @param configuration The configuration that will be deployed to this environment. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    void addDeployment(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appconfig.IConfiguration configuration);

    /**
     * Creates a deployment for each of the supplied configurations to this environment.
     * <p>
     * These configurations will be deployed in the same order as the input array.
     * <p>
     * @param configurations The configurations that will be deployed to this environment. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    void addDeployments(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appconfig.IConfiguration... configurations);

    /**
     * Adds an extension association to the environment.
     * <p>
     * @param extension The extension to create an association for. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    void addExtension(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appconfig.IExtension extension);

    /**
     * Adds an AT_DEPLOYMENT_TICK extension with the provided event destination and also creates an extension association to an application.
     * <p>
     * @param eventDestination The event that occurs during the extension. This parameter is required.
     * @param options Options for the extension.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    void atDeploymentTick(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appconfig.IEventDestination eventDestination, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.appconfig.ExtensionOptions options);

    /**
     * Adds an AT_DEPLOYMENT_TICK extension with the provided event destination and also creates an extension association to an application.
     * <p>
     * @param eventDestination The event that occurs during the extension. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    void atDeploymentTick(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appconfig.IEventDestination eventDestination);

    /**
     * Adds an IAM policy statement associated with this environment to an IAM principal's policy.
     * <p>
     * @param grantee the principal (no-op if undefined). This parameter is required.
     * @param actions the set of actions to allow (i.e., 'appconfig:GetLatestConfiguration', 'appconfig:StartConfigurationSession', etc.). This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.Grant grant(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.IGrantable grantee, final @org.jetbrains.annotations.NotNull java.lang.String... actions);

    /**
     * Permits an IAM principal to perform read operations on this environment's configurations.
     * <p>
     * Actions: GetLatestConfiguration, StartConfigurationSession.
     * <p>
     * @param grantee Principal to grant read rights to. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.Grant grantReadConfig(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.IGrantable grantee);

    /**
     * Adds an extension defined by the action point and event destination and also creates an extension association to the environment.
     * <p>
     * @param actionPoint The action point which triggers the event. This parameter is required.
     * @param eventDestination The event that occurs during the extension. This parameter is required.
     * @param options Options for the extension.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    void on(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appconfig.ActionPoint actionPoint, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appconfig.IEventDestination eventDestination, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.appconfig.ExtensionOptions options);

    /**
     * Adds an extension defined by the action point and event destination and also creates an extension association to the environment.
     * <p>
     * @param actionPoint The action point which triggers the event. This parameter is required.
     * @param eventDestination The event that occurs during the extension. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    void on(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appconfig.ActionPoint actionPoint, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appconfig.IEventDestination eventDestination);

    /**
     * Adds an ON_DEPLOYMENT_BAKING extension with the provided event destination and also creates an extension association to the environment.
     * <p>
     * @param eventDestination The event that occurs during the extension. This parameter is required.
     * @param options Options for the extension.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    void onDeploymentBaking(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appconfig.IEventDestination eventDestination, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.appconfig.ExtensionOptions options);

    /**
     * Adds an ON_DEPLOYMENT_BAKING extension with the provided event destination and also creates an extension association to the environment.
     * <p>
     * @param eventDestination The event that occurs during the extension. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    void onDeploymentBaking(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appconfig.IEventDestination eventDestination);

    /**
     * Adds an ON_DEPLOYMENT_COMPLETE extension with the provided event destination and also creates an extension association to the environment.
     * <p>
     * @param eventDestination The event that occurs during the extension. This parameter is required.
     * @param options Options for the extension.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    void onDeploymentComplete(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appconfig.IEventDestination eventDestination, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.appconfig.ExtensionOptions options);

    /**
     * Adds an ON_DEPLOYMENT_COMPLETE extension with the provided event destination and also creates an extension association to the environment.
     * <p>
     * @param eventDestination The event that occurs during the extension. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    void onDeploymentComplete(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appconfig.IEventDestination eventDestination);

    /**
     * Adds an ON_DEPLOYMENT_ROLLED_BACK extension with the provided event destination and also creates an extension association to the environment.
     * <p>
     * @param eventDestination The event that occurs during the extension. This parameter is required.
     * @param options Options for the extension.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    void onDeploymentRolledBack(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appconfig.IEventDestination eventDestination, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.appconfig.ExtensionOptions options);

    /**
     * Adds an ON_DEPLOYMENT_ROLLED_BACK extension with the provided event destination and also creates an extension association to the environment.
     * <p>
     * @param eventDestination The event that occurs during the extension. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    void onDeploymentRolledBack(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appconfig.IEventDestination eventDestination);

    /**
     * Adds an ON_DEPLOYMENT_START extension with the provided event destination and also creates an extension association to the environment.
     * <p>
     * @param eventDestination The event that occurs during the extension. This parameter is required.
     * @param options Options for the extension.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    void onDeploymentStart(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appconfig.IEventDestination eventDestination, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.appconfig.ExtensionOptions options);

    /**
     * Adds an ON_DEPLOYMENT_START extension with the provided event destination and also creates an extension association to the environment.
     * <p>
     * @param eventDestination The event that occurs during the extension. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    void onDeploymentStart(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appconfig.IEventDestination eventDestination);

    /**
     * Adds an ON_DEPLOYMENT_STEP extension with the provided event destination and also creates an extension association to the environment.
     * <p>
     * @param eventDestination The event that occurs during the extension. This parameter is required.
     * @param options Options for the extension.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    void onDeploymentStep(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appconfig.IEventDestination eventDestination, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.appconfig.ExtensionOptions options);

    /**
     * Adds an ON_DEPLOYMENT_STEP extension with the provided event destination and also creates an extension association to the environment.
     * <p>
     * @param eventDestination The event that occurs during the extension. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    void onDeploymentStep(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appconfig.IEventDestination eventDestination);

    /**
     * Adds a PRE_CREATE_HOSTED_CONFIGURATION_VERSION extension with the provided event destination and also creates an extension association to the environment.
     * <p>
     * @param eventDestination The event that occurs during the extension. This parameter is required.
     * @param options Options for the extension.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    void preCreateHostedConfigurationVersion(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appconfig.IEventDestination eventDestination, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.appconfig.ExtensionOptions options);

    /**
     * Adds a PRE_CREATE_HOSTED_CONFIGURATION_VERSION extension with the provided event destination and also creates an extension association to the environment.
     * <p>
     * @param eventDestination The event that occurs during the extension. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    void preCreateHostedConfigurationVersion(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appconfig.IEventDestination eventDestination);

    /**
     * Adds a PRE_START_DEPLOYMENT extension with the provided event destination and also creates an extension association to the environment.
     * <p>
     * @param eventDestination The event that occurs during the extension. This parameter is required.
     * @param options Options for the extension.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    void preStartDeployment(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appconfig.IEventDestination eventDestination, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.appconfig.ExtensionOptions options);

    /**
     * Adds a PRE_START_DEPLOYMENT extension with the provided event destination and also creates an extension association to the environment.
     * <p>
     * @param eventDestination The event that occurs during the extension. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    void preStartDeployment(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appconfig.IEventDestination eventDestination);

    /**
     * A proxy class which represents a concrete javascript instance of this type.
     */
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements software.amazon.awscdk.services.appconfig.IEnvironment.Jsii$Default {
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
        }

        /**
         * The tree node.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public final @org.jetbrains.annotations.NotNull software.constructs.Node getNode() {
            return software.amazon.jsii.Kernel.get(this, "node", software.amazon.jsii.NativeType.forClass(software.constructs.Node.class));
        }

        /**
         * The environment this resource belongs to.
         * <p>
         * For resources that are created and managed by the CDK
         * (generally, those created by creating new class instances like Role, Bucket, etc.),
         * this is always the same as the environment of the stack they belong to;
         * however, for imported resources
         * (those obtained from static methods like fromRoleArn, fromBucketName, etc.),
         * that might be different than the stack they were imported into.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public final @org.jetbrains.annotations.NotNull software.amazon.awscdk.ResourceEnvironment getEnv() {
            return software.amazon.jsii.Kernel.get(this, "env", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.ResourceEnvironment.class));
        }

        /**
         * The stack in which this resource is defined.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public final @org.jetbrains.annotations.NotNull software.amazon.awscdk.Stack getStack() {
            return software.amazon.jsii.Kernel.get(this, "stack", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.Stack.class));
        }

        /**
         * The ID of the application associated to the environment.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public final @org.jetbrains.annotations.NotNull java.lang.String getApplicationId() {
            return software.amazon.jsii.Kernel.get(this, "applicationId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * The Amazon Resource Name (ARN) of the environment.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public final @org.jetbrains.annotations.NotNull java.lang.String getEnvironmentArn() {
            return software.amazon.jsii.Kernel.get(this, "environmentArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * The ID of the environment.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public final @org.jetbrains.annotations.NotNull java.lang.String getEnvironmentId() {
            return software.amazon.jsii.Kernel.get(this, "environmentId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * The application associated with the environment.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.appconfig.IApplication getApplication() {
            return software.amazon.jsii.Kernel.get(this, "application", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.appconfig.IApplication.class));
        }

        /**
         * The description of the environment.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public final @org.jetbrains.annotations.Nullable java.lang.String getDescription() {
            return software.amazon.jsii.Kernel.get(this, "description", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * The monitors for the environment.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public final @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.services.appconfig.Monitor> getMonitors() {
            return java.util.Optional.ofNullable((java.util.List<software.amazon.awscdk.services.appconfig.Monitor>)(software.amazon.jsii.Kernel.get(this, "monitors", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.appconfig.Monitor.class))))).map(java.util.Collections::unmodifiableList).orElse(null);
        }

        /**
         * The name of the environment.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public final @org.jetbrains.annotations.Nullable java.lang.String getName() {
            return software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Apply the given removal policy to this resource.
         * <p>
         * The Removal Policy controls what happens to this resource when it stops
         * being managed by CloudFormation, either because you've removed it from the
         * CDK application or because you've made a change that requires the resource
         * to be replaced.
         * <p>
         * The resource can be deleted (<code>RemovalPolicy.DESTROY</code>), or left in your AWS
         * account for data recovery and cleanup later (<code>RemovalPolicy.RETAIN</code>).
         * <p>
         * @param policy This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public final void applyRemovalPolicy(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.RemovalPolicy policy) {
            software.amazon.jsii.Kernel.call(this, "applyRemovalPolicy", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(policy, "policy is required") });
        }

        /**
         * Creates a deployment of the supplied configuration to this environment.
         * <p>
         * Note that you can only deploy one configuration at a time to an environment.
         * However, you can deploy one configuration each to different environments at the same time.
         * If more than one deployment is requested for this environment, they will occur in the same order they were provided.
         * <p>
         * @param configuration The configuration that will be deployed to this environment. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public final void addDeployment(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appconfig.IConfiguration configuration) {
            software.amazon.jsii.Kernel.call(this, "addDeployment", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(configuration, "configuration is required") });
        }

        /**
         * Creates a deployment for each of the supplied configurations to this environment.
         * <p>
         * These configurations will be deployed in the same order as the input array.
         * <p>
         * @param configurations The configurations that will be deployed to this environment. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public final void addDeployments(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appconfig.IConfiguration... configurations) {
            software.amazon.jsii.Kernel.call(this, "addDeployments", software.amazon.jsii.NativeType.VOID, java.util.Arrays.<Object>stream(configurations).toArray(Object[]::new));
        }

        /**
         * Adds an extension association to the environment.
         * <p>
         * @param extension The extension to create an association for. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public final void addExtension(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appconfig.IExtension extension) {
            software.amazon.jsii.Kernel.call(this, "addExtension", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(extension, "extension is required") });
        }

        /**
         * Adds an AT_DEPLOYMENT_TICK extension with the provided event destination and also creates an extension association to an application.
         * <p>
         * @param eventDestination The event that occurs during the extension. This parameter is required.
         * @param options Options for the extension.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public final void atDeploymentTick(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appconfig.IEventDestination eventDestination, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.appconfig.ExtensionOptions options) {
            software.amazon.jsii.Kernel.call(this, "atDeploymentTick", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(eventDestination, "eventDestination is required"), options });
        }

        /**
         * Adds an AT_DEPLOYMENT_TICK extension with the provided event destination and also creates an extension association to an application.
         * <p>
         * @param eventDestination The event that occurs during the extension. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public final void atDeploymentTick(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appconfig.IEventDestination eventDestination) {
            software.amazon.jsii.Kernel.call(this, "atDeploymentTick", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(eventDestination, "eventDestination is required") });
        }

        /**
         * Adds an IAM policy statement associated with this environment to an IAM principal's policy.
         * <p>
         * @param grantee the principal (no-op if undefined). This parameter is required.
         * @param actions the set of actions to allow (i.e., 'appconfig:GetLatestConfiguration', 'appconfig:StartConfigurationSession', etc.). This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.Grant grant(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.IGrantable grantee, final @org.jetbrains.annotations.NotNull java.lang.String... actions) {
            return software.amazon.jsii.Kernel.call(this, "grant", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.Grant.class), java.util.stream.Stream.concat(java.util.Arrays.<Object>stream(new Object[] { java.util.Objects.requireNonNull(grantee, "grantee is required") }), java.util.Arrays.<Object>stream(actions)).toArray(Object[]::new));
        }

        /**
         * Permits an IAM principal to perform read operations on this environment's configurations.
         * <p>
         * Actions: GetLatestConfiguration, StartConfigurationSession.
         * <p>
         * @param grantee Principal to grant read rights to. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.Grant grantReadConfig(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.IGrantable grantee) {
            return software.amazon.jsii.Kernel.call(this, "grantReadConfig", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.Grant.class), new Object[] { java.util.Objects.requireNonNull(grantee, "grantee is required") });
        }

        /**
         * Adds an extension defined by the action point and event destination and also creates an extension association to the environment.
         * <p>
         * @param actionPoint The action point which triggers the event. This parameter is required.
         * @param eventDestination The event that occurs during the extension. This parameter is required.
         * @param options Options for the extension.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public final void on(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appconfig.ActionPoint actionPoint, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appconfig.IEventDestination eventDestination, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.appconfig.ExtensionOptions options) {
            software.amazon.jsii.Kernel.call(this, "on", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(actionPoint, "actionPoint is required"), java.util.Objects.requireNonNull(eventDestination, "eventDestination is required"), options });
        }

        /**
         * Adds an extension defined by the action point and event destination and also creates an extension association to the environment.
         * <p>
         * @param actionPoint The action point which triggers the event. This parameter is required.
         * @param eventDestination The event that occurs during the extension. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public final void on(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appconfig.ActionPoint actionPoint, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appconfig.IEventDestination eventDestination) {
            software.amazon.jsii.Kernel.call(this, "on", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(actionPoint, "actionPoint is required"), java.util.Objects.requireNonNull(eventDestination, "eventDestination is required") });
        }

        /**
         * Adds an ON_DEPLOYMENT_BAKING extension with the provided event destination and also creates an extension association to the environment.
         * <p>
         * @param eventDestination The event that occurs during the extension. This parameter is required.
         * @param options Options for the extension.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public final void onDeploymentBaking(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appconfig.IEventDestination eventDestination, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.appconfig.ExtensionOptions options) {
            software.amazon.jsii.Kernel.call(this, "onDeploymentBaking", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(eventDestination, "eventDestination is required"), options });
        }

        /**
         * Adds an ON_DEPLOYMENT_BAKING extension with the provided event destination and also creates an extension association to the environment.
         * <p>
         * @param eventDestination The event that occurs during the extension. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public final void onDeploymentBaking(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appconfig.IEventDestination eventDestination) {
            software.amazon.jsii.Kernel.call(this, "onDeploymentBaking", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(eventDestination, "eventDestination is required") });
        }

        /**
         * Adds an ON_DEPLOYMENT_COMPLETE extension with the provided event destination and also creates an extension association to the environment.
         * <p>
         * @param eventDestination The event that occurs during the extension. This parameter is required.
         * @param options Options for the extension.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public final void onDeploymentComplete(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appconfig.IEventDestination eventDestination, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.appconfig.ExtensionOptions options) {
            software.amazon.jsii.Kernel.call(this, "onDeploymentComplete", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(eventDestination, "eventDestination is required"), options });
        }

        /**
         * Adds an ON_DEPLOYMENT_COMPLETE extension with the provided event destination and also creates an extension association to the environment.
         * <p>
         * @param eventDestination The event that occurs during the extension. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public final void onDeploymentComplete(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appconfig.IEventDestination eventDestination) {
            software.amazon.jsii.Kernel.call(this, "onDeploymentComplete", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(eventDestination, "eventDestination is required") });
        }

        /**
         * Adds an ON_DEPLOYMENT_ROLLED_BACK extension with the provided event destination and also creates an extension association to the environment.
         * <p>
         * @param eventDestination The event that occurs during the extension. This parameter is required.
         * @param options Options for the extension.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public final void onDeploymentRolledBack(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appconfig.IEventDestination eventDestination, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.appconfig.ExtensionOptions options) {
            software.amazon.jsii.Kernel.call(this, "onDeploymentRolledBack", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(eventDestination, "eventDestination is required"), options });
        }

        /**
         * Adds an ON_DEPLOYMENT_ROLLED_BACK extension with the provided event destination and also creates an extension association to the environment.
         * <p>
         * @param eventDestination The event that occurs during the extension. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public final void onDeploymentRolledBack(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appconfig.IEventDestination eventDestination) {
            software.amazon.jsii.Kernel.call(this, "onDeploymentRolledBack", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(eventDestination, "eventDestination is required") });
        }

        /**
         * Adds an ON_DEPLOYMENT_START extension with the provided event destination and also creates an extension association to the environment.
         * <p>
         * @param eventDestination The event that occurs during the extension. This parameter is required.
         * @param options Options for the extension.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public final void onDeploymentStart(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appconfig.IEventDestination eventDestination, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.appconfig.ExtensionOptions options) {
            software.amazon.jsii.Kernel.call(this, "onDeploymentStart", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(eventDestination, "eventDestination is required"), options });
        }

        /**
         * Adds an ON_DEPLOYMENT_START extension with the provided event destination and also creates an extension association to the environment.
         * <p>
         * @param eventDestination The event that occurs during the extension. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public final void onDeploymentStart(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appconfig.IEventDestination eventDestination) {
            software.amazon.jsii.Kernel.call(this, "onDeploymentStart", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(eventDestination, "eventDestination is required") });
        }

        /**
         * Adds an ON_DEPLOYMENT_STEP extension with the provided event destination and also creates an extension association to the environment.
         * <p>
         * @param eventDestination The event that occurs during the extension. This parameter is required.
         * @param options Options for the extension.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public final void onDeploymentStep(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appconfig.IEventDestination eventDestination, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.appconfig.ExtensionOptions options) {
            software.amazon.jsii.Kernel.call(this, "onDeploymentStep", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(eventDestination, "eventDestination is required"), options });
        }

        /**
         * Adds an ON_DEPLOYMENT_STEP extension with the provided event destination and also creates an extension association to the environment.
         * <p>
         * @param eventDestination The event that occurs during the extension. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public final void onDeploymentStep(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appconfig.IEventDestination eventDestination) {
            software.amazon.jsii.Kernel.call(this, "onDeploymentStep", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(eventDestination, "eventDestination is required") });
        }

        /**
         * Adds a PRE_CREATE_HOSTED_CONFIGURATION_VERSION extension with the provided event destination and also creates an extension association to the environment.
         * <p>
         * @param eventDestination The event that occurs during the extension. This parameter is required.
         * @param options Options for the extension.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public final void preCreateHostedConfigurationVersion(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appconfig.IEventDestination eventDestination, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.appconfig.ExtensionOptions options) {
            software.amazon.jsii.Kernel.call(this, "preCreateHostedConfigurationVersion", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(eventDestination, "eventDestination is required"), options });
        }

        /**
         * Adds a PRE_CREATE_HOSTED_CONFIGURATION_VERSION extension with the provided event destination and also creates an extension association to the environment.
         * <p>
         * @param eventDestination The event that occurs during the extension. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public final void preCreateHostedConfigurationVersion(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appconfig.IEventDestination eventDestination) {
            software.amazon.jsii.Kernel.call(this, "preCreateHostedConfigurationVersion", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(eventDestination, "eventDestination is required") });
        }

        /**
         * Adds a PRE_START_DEPLOYMENT extension with the provided event destination and also creates an extension association to the environment.
         * <p>
         * @param eventDestination The event that occurs during the extension. This parameter is required.
         * @param options Options for the extension.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public final void preStartDeployment(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appconfig.IEventDestination eventDestination, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.appconfig.ExtensionOptions options) {
            software.amazon.jsii.Kernel.call(this, "preStartDeployment", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(eventDestination, "eventDestination is required"), options });
        }

        /**
         * Adds a PRE_START_DEPLOYMENT extension with the provided event destination and also creates an extension association to the environment.
         * <p>
         * @param eventDestination The event that occurs during the extension. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public final void preStartDeployment(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appconfig.IEventDestination eventDestination) {
            software.amazon.jsii.Kernel.call(this, "preStartDeployment", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(eventDestination, "eventDestination is required") });
        }
    }

    /**
     * Internal default implementation for {@link IEnvironment}.
     */
    @software.amazon.jsii.Internal
    interface Jsii$Default extends IEnvironment, software.amazon.awscdk.IResource.Jsii$Default {

        /**
         * The tree node.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.NotNull software.constructs.Node getNode() {
            return software.amazon.jsii.Kernel.get(this, "node", software.amazon.jsii.NativeType.forClass(software.constructs.Node.class));
        }

        /**
         * The environment this resource belongs to.
         * <p>
         * For resources that are created and managed by the CDK
         * (generally, those created by creating new class instances like Role, Bucket, etc.),
         * this is always the same as the environment of the stack they belong to;
         * however, for imported resources
         * (those obtained from static methods like fromRoleArn, fromBucketName, etc.),
         * that might be different than the stack they were imported into.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.NotNull software.amazon.awscdk.ResourceEnvironment getEnv() {
            return software.amazon.jsii.Kernel.get(this, "env", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.ResourceEnvironment.class));
        }

        /**
         * The stack in which this resource is defined.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.NotNull software.amazon.awscdk.Stack getStack() {
            return software.amazon.jsii.Kernel.get(this, "stack", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.Stack.class));
        }

        /**
         * The ID of the application associated to the environment.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.NotNull java.lang.String getApplicationId() {
            return software.amazon.jsii.Kernel.get(this, "applicationId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * The Amazon Resource Name (ARN) of the environment.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.NotNull java.lang.String getEnvironmentArn() {
            return software.amazon.jsii.Kernel.get(this, "environmentArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * The ID of the environment.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.NotNull java.lang.String getEnvironmentId() {
            return software.amazon.jsii.Kernel.get(this, "environmentId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * The application associated with the environment.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.appconfig.IApplication getApplication() {
            return software.amazon.jsii.Kernel.get(this, "application", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.appconfig.IApplication.class));
        }

        /**
         * The description of the environment.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getDescription() {
            return software.amazon.jsii.Kernel.get(this, "description", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * The monitors for the environment.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.services.appconfig.Monitor> getMonitors() {
            return java.util.Optional.ofNullable((java.util.List<software.amazon.awscdk.services.appconfig.Monitor>)(software.amazon.jsii.Kernel.get(this, "monitors", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.appconfig.Monitor.class))))).map(java.util.Collections::unmodifiableList).orElse(null);
        }

        /**
         * The name of the environment.
         */
        @Override
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getName() {
            return software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Apply the given removal policy to this resource.
         * <p>
         * The Removal Policy controls what happens to this resource when it stops
         * being managed by CloudFormation, either because you've removed it from the
         * CDK application or because you've made a change that requires the resource
         * to be replaced.
         * <p>
         * The resource can be deleted (<code>RemovalPolicy.DESTROY</code>), or left in your AWS
         * account for data recovery and cleanup later (<code>RemovalPolicy.RETAIN</code>).
         * <p>
         * @param policy This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        default void applyRemovalPolicy(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.RemovalPolicy policy) {
            software.amazon.jsii.Kernel.call(this, "applyRemovalPolicy", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(policy, "policy is required") });
        }

        /**
         * Creates a deployment of the supplied configuration to this environment.
         * <p>
         * Note that you can only deploy one configuration at a time to an environment.
         * However, you can deploy one configuration each to different environments at the same time.
         * If more than one deployment is requested for this environment, they will occur in the same order they were provided.
         * <p>
         * @param configuration The configuration that will be deployed to this environment. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        default void addDeployment(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appconfig.IConfiguration configuration) {
            software.amazon.jsii.Kernel.call(this, "addDeployment", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(configuration, "configuration is required") });
        }

        /**
         * Creates a deployment for each of the supplied configurations to this environment.
         * <p>
         * These configurations will be deployed in the same order as the input array.
         * <p>
         * @param configurations The configurations that will be deployed to this environment. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        default void addDeployments(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appconfig.IConfiguration... configurations) {
            software.amazon.jsii.Kernel.call(this, "addDeployments", software.amazon.jsii.NativeType.VOID, java.util.Arrays.<Object>stream(configurations).toArray(Object[]::new));
        }

        /**
         * Adds an extension association to the environment.
         * <p>
         * @param extension The extension to create an association for. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        default void addExtension(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appconfig.IExtension extension) {
            software.amazon.jsii.Kernel.call(this, "addExtension", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(extension, "extension is required") });
        }

        /**
         * Adds an AT_DEPLOYMENT_TICK extension with the provided event destination and also creates an extension association to an application.
         * <p>
         * @param eventDestination The event that occurs during the extension. This parameter is required.
         * @param options Options for the extension.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        default void atDeploymentTick(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appconfig.IEventDestination eventDestination, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.appconfig.ExtensionOptions options) {
            software.amazon.jsii.Kernel.call(this, "atDeploymentTick", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(eventDestination, "eventDestination is required"), options });
        }

        /**
         * Adds an IAM policy statement associated with this environment to an IAM principal's policy.
         * <p>
         * @param grantee the principal (no-op if undefined). This parameter is required.
         * @param actions the set of actions to allow (i.e., 'appconfig:GetLatestConfiguration', 'appconfig:StartConfigurationSession', etc.). This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        default @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.Grant grant(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.IGrantable grantee, final @org.jetbrains.annotations.NotNull java.lang.String... actions) {
            return software.amazon.jsii.Kernel.call(this, "grant", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.Grant.class), java.util.stream.Stream.concat(java.util.Arrays.<Object>stream(new Object[] { java.util.Objects.requireNonNull(grantee, "grantee is required") }), java.util.Arrays.<Object>stream(actions)).toArray(Object[]::new));
        }

        /**
         * Permits an IAM principal to perform read operations on this environment's configurations.
         * <p>
         * Actions: GetLatestConfiguration, StartConfigurationSession.
         * <p>
         * @param grantee Principal to grant read rights to. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        default @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.Grant grantReadConfig(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.IGrantable grantee) {
            return software.amazon.jsii.Kernel.call(this, "grantReadConfig", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.Grant.class), new Object[] { java.util.Objects.requireNonNull(grantee, "grantee is required") });
        }

        /**
         * Adds an extension defined by the action point and event destination and also creates an extension association to the environment.
         * <p>
         * @param actionPoint The action point which triggers the event. This parameter is required.
         * @param eventDestination The event that occurs during the extension. This parameter is required.
         * @param options Options for the extension.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        default void on(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appconfig.ActionPoint actionPoint, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appconfig.IEventDestination eventDestination, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.appconfig.ExtensionOptions options) {
            software.amazon.jsii.Kernel.call(this, "on", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(actionPoint, "actionPoint is required"), java.util.Objects.requireNonNull(eventDestination, "eventDestination is required"), options });
        }

        /**
         * Adds an ON_DEPLOYMENT_BAKING extension with the provided event destination and also creates an extension association to the environment.
         * <p>
         * @param eventDestination The event that occurs during the extension. This parameter is required.
         * @param options Options for the extension.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        default void onDeploymentBaking(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appconfig.IEventDestination eventDestination, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.appconfig.ExtensionOptions options) {
            software.amazon.jsii.Kernel.call(this, "onDeploymentBaking", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(eventDestination, "eventDestination is required"), options });
        }

        /**
         * Adds an ON_DEPLOYMENT_COMPLETE extension with the provided event destination and also creates an extension association to the environment.
         * <p>
         * @param eventDestination The event that occurs during the extension. This parameter is required.
         * @param options Options for the extension.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        default void onDeploymentComplete(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appconfig.IEventDestination eventDestination, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.appconfig.ExtensionOptions options) {
            software.amazon.jsii.Kernel.call(this, "onDeploymentComplete", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(eventDestination, "eventDestination is required"), options });
        }

        /**
         * Adds an ON_DEPLOYMENT_ROLLED_BACK extension with the provided event destination and also creates an extension association to the environment.
         * <p>
         * @param eventDestination The event that occurs during the extension. This parameter is required.
         * @param options Options for the extension.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        default void onDeploymentRolledBack(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appconfig.IEventDestination eventDestination, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.appconfig.ExtensionOptions options) {
            software.amazon.jsii.Kernel.call(this, "onDeploymentRolledBack", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(eventDestination, "eventDestination is required"), options });
        }

        /**
         * Adds an ON_DEPLOYMENT_START extension with the provided event destination and also creates an extension association to the environment.
         * <p>
         * @param eventDestination The event that occurs during the extension. This parameter is required.
         * @param options Options for the extension.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        default void onDeploymentStart(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appconfig.IEventDestination eventDestination, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.appconfig.ExtensionOptions options) {
            software.amazon.jsii.Kernel.call(this, "onDeploymentStart", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(eventDestination, "eventDestination is required"), options });
        }

        /**
         * Adds an ON_DEPLOYMENT_STEP extension with the provided event destination and also creates an extension association to the environment.
         * <p>
         * @param eventDestination The event that occurs during the extension. This parameter is required.
         * @param options Options for the extension.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        default void onDeploymentStep(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appconfig.IEventDestination eventDestination, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.appconfig.ExtensionOptions options) {
            software.amazon.jsii.Kernel.call(this, "onDeploymentStep", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(eventDestination, "eventDestination is required"), options });
        }

        /**
         * Adds a PRE_CREATE_HOSTED_CONFIGURATION_VERSION extension with the provided event destination and also creates an extension association to the environment.
         * <p>
         * @param eventDestination The event that occurs during the extension. This parameter is required.
         * @param options Options for the extension.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        default void preCreateHostedConfigurationVersion(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appconfig.IEventDestination eventDestination, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.appconfig.ExtensionOptions options) {
            software.amazon.jsii.Kernel.call(this, "preCreateHostedConfigurationVersion", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(eventDestination, "eventDestination is required"), options });
        }

        /**
         * Adds a PRE_START_DEPLOYMENT extension with the provided event destination and also creates an extension association to the environment.
         * <p>
         * @param eventDestination The event that occurs during the extension. This parameter is required.
         * @param options Options for the extension.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        default void preStartDeployment(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appconfig.IEventDestination eventDestination, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.appconfig.ExtensionOptions options) {
            software.amazon.jsii.Kernel.call(this, "preStartDeployment", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(eventDestination, "eventDestination is required"), options });
        }
    }
}
