package software.amazon.awscdk.services.appmesh;

/**
 * Interface with properties ncecessary to import a reusable VirtualService.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.appmesh.*;
 * Mesh mesh;
 * VirtualServiceAttributes virtualServiceAttributes = VirtualServiceAttributes.builder()
 *         .mesh(mesh)
 *         .virtualServiceName("virtualServiceName")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.106.0 (build e852934)", date = "2025-02-21T03:20:28.231Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_appmesh.VirtualServiceAttributes")
@software.amazon.jsii.Jsii.Proxy(VirtualServiceAttributes.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface VirtualServiceAttributes extends software.amazon.jsii.JsiiSerializable {

    /**
     * The Mesh which the VirtualService belongs to.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.appmesh.IMesh getMesh();

    /**
     * The name of the VirtualService, it is recommended this follows the fully-qualified domain name format.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getVirtualServiceName();

    /**
     * @return a {@link Builder} of {@link VirtualServiceAttributes}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link VirtualServiceAttributes}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<VirtualServiceAttributes> {
        software.amazon.awscdk.services.appmesh.IMesh mesh;
        java.lang.String virtualServiceName;

        /**
         * Sets the value of {@link VirtualServiceAttributes#getMesh}
         * @param mesh The Mesh which the VirtualService belongs to. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder mesh(software.amazon.awscdk.services.appmesh.IMesh mesh) {
            this.mesh = mesh;
            return this;
        }

        /**
         * Sets the value of {@link VirtualServiceAttributes#getVirtualServiceName}
         * @param virtualServiceName The name of the VirtualService, it is recommended this follows the fully-qualified domain name format. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder virtualServiceName(java.lang.String virtualServiceName) {
            this.virtualServiceName = virtualServiceName;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link VirtualServiceAttributes}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public VirtualServiceAttributes build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link VirtualServiceAttributes}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements VirtualServiceAttributes {
        private final software.amazon.awscdk.services.appmesh.IMesh mesh;
        private final java.lang.String virtualServiceName;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.mesh = software.amazon.jsii.Kernel.get(this, "mesh", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.appmesh.IMesh.class));
            this.virtualServiceName = software.amazon.jsii.Kernel.get(this, "virtualServiceName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.mesh = java.util.Objects.requireNonNull(builder.mesh, "mesh is required");
            this.virtualServiceName = java.util.Objects.requireNonNull(builder.virtualServiceName, "virtualServiceName is required");
        }

        @Override
        public final software.amazon.awscdk.services.appmesh.IMesh getMesh() {
            return this.mesh;
        }

        @Override
        public final java.lang.String getVirtualServiceName() {
            return this.virtualServiceName;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("mesh", om.valueToTree(this.getMesh()));
            data.set("virtualServiceName", om.valueToTree(this.getVirtualServiceName()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_appmesh.VirtualServiceAttributes"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            VirtualServiceAttributes.Jsii$Proxy that = (VirtualServiceAttributes.Jsii$Proxy) o;

            if (!mesh.equals(that.mesh)) return false;
            return this.virtualServiceName.equals(that.virtualServiceName);
        }

        @Override
        public final int hashCode() {
            int result = this.mesh.hashCode();
            result = 31 * result + (this.virtualServiceName.hashCode());
            return result;
        }
    }
}
