package software.amazon.awscdk.services.appsync;

/**
 * log-level for fields in AppSync.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * import software.amazon.awscdk.services.logs.*;
 * AppSyncAuthProvider apiKeyProvider = AppSyncAuthProvider.builder()
 *         .authorizationType(AppSyncAuthorizationType.API_KEY)
 *         .build();
 * EventApi api = EventApi.Builder.create(this, "api")
 *         .apiName("Api")
 *         .ownerContact("OwnerContact")
 *         .authorizationConfig(EventApiAuthConfig.builder()
 *                 .authProviders(List.of(apiKeyProvider))
 *                 .connectionAuthModeTypes(List.of(AppSyncAuthorizationType.API_KEY))
 *                 .defaultPublishAuthModeTypes(List.of(AppSyncAuthorizationType.API_KEY))
 *                 .defaultSubscribeAuthModeTypes(List.of(AppSyncAuthorizationType.API_KEY))
 *                 .build())
 *         .logConfig(AppSyncLogConfig.builder()
 *                 .fieldLogLevel(AppSyncFieldLogLevel.INFO)
 *                 .retention(RetentionDays.ONE_WEEK)
 *                 .build())
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.106.0 (build e852934)", date = "2025-02-21T03:20:28.328Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_appsync.AppSyncFieldLogLevel")
public enum AppSyncFieldLogLevel {
    /**
     * Resolver logging is disabled.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    NONE,
    /**
     * Only Error messages appear in logs.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    ERROR,
    /**
     * Info and Error messages appear in logs.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    INFO,
    /**
     * Debug, Info, and Error messages, appear in logs.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    DEBUG,
    /**
     * All messages (Debug, Error, Info, and Trace) appear in logs.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    ALL,
}
