package software.amazon.awscdk.services.backup;

/**
 * Properties for defining a <code>CfnBackupPlan</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.backup.*;
 * Object backupOptions;
 * CfnBackupPlanProps cfnBackupPlanProps = CfnBackupPlanProps.builder()
 *         .backupPlan(BackupPlanResourceTypeProperty.builder()
 *                 .backupPlanName("backupPlanName")
 *                 .backupPlanRule(List.of(BackupRuleResourceTypeProperty.builder()
 *                         .ruleName("ruleName")
 *                         .targetBackupVault("targetBackupVault")
 *                         // the properties below are optional
 *                         .completionWindowMinutes(123)
 *                         .copyActions(List.of(CopyActionResourceTypeProperty.builder()
 *                                 .destinationBackupVaultArn("destinationBackupVaultArn")
 *                                 // the properties below are optional
 *                                 .lifecycle(LifecycleResourceTypeProperty.builder()
 *                                         .deleteAfterDays(123)
 *                                         .moveToColdStorageAfterDays(123)
 *                                         .optInToArchiveForSupportedResources(false)
 *                                         .build())
 *                                 .build()))
 *                         .enableContinuousBackup(false)
 *                         .indexActions(List.of(IndexActionsResourceTypeProperty.builder()
 *                                 .resourceTypes(List.of("resourceTypes"))
 *                                 .build()))
 *                         .lifecycle(LifecycleResourceTypeProperty.builder()
 *                                 .deleteAfterDays(123)
 *                                 .moveToColdStorageAfterDays(123)
 *                                 .optInToArchiveForSupportedResources(false)
 *                                 .build())
 *                         .recoveryPointTags(Map.of(
 *                                 "recoveryPointTagsKey", "recoveryPointTags"))
 *                         .scheduleExpression("scheduleExpression")
 *                         .scheduleExpressionTimezone("scheduleExpressionTimezone")
 *                         .startWindowMinutes(123)
 *                         .build()))
 *                 // the properties below are optional
 *                 .advancedBackupSettings(List.of(AdvancedBackupSettingResourceTypeProperty.builder()
 *                         .backupOptions(backupOptions)
 *                         .resourceType("resourceType")
 *                         .build()))
 *                 .build())
 *         // the properties below are optional
 *         .backupPlanTags(Map.of(
 *                 "backupPlanTagsKey", "backupPlanTags"))
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-backup-backupplan.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-backup-backupplan.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.106.0 (build e852934)", date = "2025-02-21T03:20:28.785Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_backup.CfnBackupPlanProps")
@software.amazon.jsii.Jsii.Proxy(CfnBackupPlanProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnBackupPlanProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * Uniquely identifies the backup plan to be associated with the selection of resources.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-backup-backupplan.html#cfn-backup-backupplan-backupplan">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-backup-backupplan.html#cfn-backup-backupplan-backupplan</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.Object getBackupPlan();

    /**
     * The tags to assign to the backup plan.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-backup-backupplan.html#cfn-backup-backupplan-backupplantags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-backup-backupplan.html#cfn-backup-backupplan-backupplantags</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.Map<java.lang.String, java.lang.String> getBackupPlanTags() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnBackupPlanProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnBackupPlanProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnBackupPlanProps> {
        java.lang.Object backupPlan;
        java.util.Map<java.lang.String, java.lang.String> backupPlanTags;

        /**
         * Sets the value of {@link CfnBackupPlanProps#getBackupPlan}
         * @param backupPlan Uniquely identifies the backup plan to be associated with the selection of resources. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder backupPlan(software.amazon.awscdk.IResolvable backupPlan) {
            this.backupPlan = backupPlan;
            return this;
        }

        /**
         * Sets the value of {@link CfnBackupPlanProps#getBackupPlan}
         * @param backupPlan Uniquely identifies the backup plan to be associated with the selection of resources. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder backupPlan(software.amazon.awscdk.services.backup.CfnBackupPlan.BackupPlanResourceTypeProperty backupPlan) {
            this.backupPlan = backupPlan;
            return this;
        }

        /**
         * Sets the value of {@link CfnBackupPlanProps#getBackupPlanTags}
         * @param backupPlanTags The tags to assign to the backup plan.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder backupPlanTags(java.util.Map<java.lang.String, java.lang.String> backupPlanTags) {
            this.backupPlanTags = backupPlanTags;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnBackupPlanProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnBackupPlanProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnBackupPlanProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnBackupPlanProps {
        private final java.lang.Object backupPlan;
        private final java.util.Map<java.lang.String, java.lang.String> backupPlanTags;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.backupPlan = software.amazon.jsii.Kernel.get(this, "backupPlan", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.backupPlanTags = software.amazon.jsii.Kernel.get(this, "backupPlanTags", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.backupPlan = java.util.Objects.requireNonNull(builder.backupPlan, "backupPlan is required");
            this.backupPlanTags = builder.backupPlanTags;
        }

        @Override
        public final java.lang.Object getBackupPlan() {
            return this.backupPlan;
        }

        @Override
        public final java.util.Map<java.lang.String, java.lang.String> getBackupPlanTags() {
            return this.backupPlanTags;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("backupPlan", om.valueToTree(this.getBackupPlan()));
            if (this.getBackupPlanTags() != null) {
                data.set("backupPlanTags", om.valueToTree(this.getBackupPlanTags()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_backup.CfnBackupPlanProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnBackupPlanProps.Jsii$Proxy that = (CfnBackupPlanProps.Jsii$Proxy) o;

            if (!backupPlan.equals(that.backupPlan)) return false;
            return this.backupPlanTags != null ? this.backupPlanTags.equals(that.backupPlanTags) : that.backupPlanTags == null;
        }

        @Override
        public final int hashCode() {
            int result = this.backupPlan.hashCode();
            result = 31 * result + (this.backupPlanTags != null ? this.backupPlanTags.hashCode() : 0);
            return result;
        }
    }
}
