package software.amazon.awscdk.services.backup;

/**
 * Creates a logical container where backups are stored.
 * <p>
 * A <code>CreateBackupVault</code> request includes a name, optionally one or more resource tags, an encryption key, and a request ID.
 * <p>
 * Do not include sensitive data, such as passport numbers, in the name of a backup vault.
 * <p>
 * For a sample AWS CloudFormation template, see the <a href="https://docs.aws.amazon.com/aws-backup/latest/devguide/assigning-resources.html#assigning-resources-cfn">AWS Backup Developer Guide</a> .
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.backup.*;
 * Object accessPolicy;
 * CfnBackupVault cfnBackupVault = CfnBackupVault.Builder.create(this, "MyCfnBackupVault")
 *         .backupVaultName("backupVaultName")
 *         // the properties below are optional
 *         .accessPolicy(accessPolicy)
 *         .backupVaultTags(Map.of(
 *                 "backupVaultTagsKey", "backupVaultTags"))
 *         .encryptionKeyArn("encryptionKeyArn")
 *         .lockConfiguration(LockConfigurationTypeProperty.builder()
 *                 .minRetentionDays(123)
 *                 // the properties below are optional
 *                 .changeableForDays(123)
 *                 .maxRetentionDays(123)
 *                 .build())
 *         .notifications(NotificationObjectTypeProperty.builder()
 *                 .backupVaultEvents(List.of("backupVaultEvents"))
 *                 .snsTopicArn("snsTopicArn")
 *                 .build())
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-backup-backupvault.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-backup-backupvault.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.106.0 (build e852934)", date = "2025-02-21T03:20:28.789Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_backup.CfnBackupVault")
public class CfnBackupVault extends software.amazon.awscdk.CfnResource implements software.amazon.awscdk.IInspectable, software.amazon.awscdk.ITaggableV2 {

    protected CfnBackupVault(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnBackupVault(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.backup.CfnBackupVault.class, "CFN_RESOURCE_TYPE_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * @param scope Scope in which this resource is defined. This parameter is required.
     * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
     * @param props Resource properties. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnBackupVault(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.backup.CfnBackupVaultProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * @param inspector tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.TreeInspector inspector) {
        software.amazon.jsii.Kernel.call(this, "inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     * An Amazon Resource Name (ARN) that uniquely identifies a backup vault;
     * <p>
     * for example, <code>arn:aws:backup:us-east-1:123456789012:backup-vault:aBackupVault</code> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrBackupVaultArn() {
        return software.amazon.jsii.Kernel.get(this, "attrBackupVaultArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The name of a logical container where backups are stored.
     * <p>
     * Backup vaults are identified by names that are unique to the account used to create them and the Region where they are created. They consist of lowercase and uppercase letters, numbers, and hyphens.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrBackupVaultName() {
        return software.amazon.jsii.Kernel.get(this, "attrBackupVaultName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Tag Manager which manages the tags for this resource.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.TagManager getCdkTagManager() {
        return software.amazon.jsii.Kernel.get(this, "cdkTagManager", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TagManager.class));
    }

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * The name of a logical container where backups are stored.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getBackupVaultName() {
        return software.amazon.jsii.Kernel.get(this, "backupVaultName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The name of a logical container where backups are stored.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setBackupVaultName(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "backupVaultName", java.util.Objects.requireNonNull(value, "backupVaultName is required"));
    }

    /**
     * A resource-based policy that is used to manage access permissions on the target backup vault.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getAccessPolicy() {
        return software.amazon.jsii.Kernel.get(this, "accessPolicy", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * A resource-based policy that is used to manage access permissions on the target backup vault.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setAccessPolicy(final @org.jetbrains.annotations.Nullable java.lang.Object value) {
        software.amazon.jsii.Kernel.set(this, "accessPolicy", value);
    }

    /**
     * The tags to assign to the backup vault.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.util.Map<java.lang.String, java.lang.String> getBackupVaultTags() {
        return java.util.Optional.ofNullable((java.util.Map<java.lang.String, java.lang.String>)(software.amazon.jsii.Kernel.get(this, "backupVaultTags", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class))))).map(java.util.Collections::unmodifiableMap).orElse(null);
    }

    /**
     * The tags to assign to the backup vault.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setBackupVaultTags(final @org.jetbrains.annotations.Nullable java.util.Map<java.lang.String, java.lang.String> value) {
        software.amazon.jsii.Kernel.set(this, "backupVaultTags", value);
    }

    /**
     * A server-side encryption key you can specify to encrypt your backups from services that support full AWS Backup management;
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getEncryptionKeyArn() {
        return software.amazon.jsii.Kernel.get(this, "encryptionKeyArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * A server-side encryption key you can specify to encrypt your backups from services that support full AWS Backup management;
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setEncryptionKeyArn(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "encryptionKeyArn", value);
    }

    /**
     * Configuration for <a href="https://docs.aws.amazon.com/aws-backup/latest/devguide/vault-lock.html">AWS Backup Vault Lock</a> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getLockConfiguration() {
        return software.amazon.jsii.Kernel.get(this, "lockConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Configuration for <a href="https://docs.aws.amazon.com/aws-backup/latest/devguide/vault-lock.html">AWS Backup Vault Lock</a> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setLockConfiguration(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "lockConfiguration", value);
    }

    /**
     * Configuration for <a href="https://docs.aws.amazon.com/aws-backup/latest/devguide/vault-lock.html">AWS Backup Vault Lock</a> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setLockConfiguration(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.backup.CfnBackupVault.LockConfigurationTypeProperty value) {
        software.amazon.jsii.Kernel.set(this, "lockConfiguration", value);
    }

    /**
     * The SNS event notifications for the specified backup vault.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getNotifications() {
        return software.amazon.jsii.Kernel.get(this, "notifications", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The SNS event notifications for the specified backup vault.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setNotifications(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "notifications", value);
    }

    /**
     * The SNS event notifications for the specified backup vault.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setNotifications(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.backup.CfnBackupVault.NotificationObjectTypeProperty value) {
        software.amazon.jsii.Kernel.set(this, "notifications", value);
    }
    /**
     * The <code>LockConfigurationType</code> property type specifies configuration for <a href="https://docs.aws.amazon.com/aws-backup/latest/devguide/vault-lock.html">AWS Backup Vault Lock</a> .
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.backup.*;
     * LockConfigurationTypeProperty lockConfigurationTypeProperty = LockConfigurationTypeProperty.builder()
     *         .minRetentionDays(123)
     *         // the properties below are optional
     *         .changeableForDays(123)
     *         .maxRetentionDays(123)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-backup-backupvault-lockconfigurationtype.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-backup-backupvault-lockconfigurationtype.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_backup.CfnBackupVault.LockConfigurationTypeProperty")
    @software.amazon.jsii.Jsii.Proxy(LockConfigurationTypeProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface LockConfigurationTypeProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The AWS Backup Vault Lock configuration that specifies the minimum retention period that the vault retains its recovery points.
         * <p>
         * This setting can be useful if, for example, your organization's policies require you to retain certain data for at least seven years (2555 days).
         * <p>
         * If this parameter is not specified, Vault Lock will not enforce a minimum retention period.
         * <p>
         * If this parameter is specified, any backup or copy job to the vault must have a lifecycle policy with a retention period equal to or longer than the minimum retention period. If the job's retention period is shorter than that minimum retention period, then the vault fails that backup or copy job, and you should either modify your lifecycle settings or use a different vault. Recovery points already saved in the vault prior to Vault Lock are not affected.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-backup-backupvault-lockconfigurationtype.html#cfn-backup-backupvault-lockconfigurationtype-minretentiondays">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-backup-backupvault-lockconfigurationtype.html#cfn-backup-backupvault-lockconfigurationtype-minretentiondays</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Number getMinRetentionDays();

        /**
         * The AWS Backup Vault Lock configuration that specifies the number of days before the lock date.
         * <p>
         * For example, setting <code>ChangeableForDays</code> to 30 on Jan. 1, 2022 at 8pm UTC will set the lock date to Jan. 31, 2022 at 8pm UTC.
         * <p>
         * AWS Backup enforces a 72-hour cooling-off period before Vault Lock takes effect and becomes immutable. Therefore, you must set <code>ChangeableForDays</code> to 3 or greater.
         * <p>
         * Before the lock date, you can delete Vault Lock from the vault using <code>DeleteBackupVaultLockConfiguration</code> or change the Vault Lock configuration using <code>PutBackupVaultLockConfiguration</code> . On and after the lock date, the Vault Lock becomes immutable and cannot be changed or deleted.
         * <p>
         * If this parameter is not specified, you can delete Vault Lock from the vault using <code>DeleteBackupVaultLockConfiguration</code> or change the Vault Lock configuration using <code>PutBackupVaultLockConfiguration</code> at any time.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-backup-backupvault-lockconfigurationtype.html#cfn-backup-backupvault-lockconfigurationtype-changeablefordays">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-backup-backupvault-lockconfigurationtype.html#cfn-backup-backupvault-lockconfigurationtype-changeablefordays</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getChangeableForDays() {
            return null;
        }

        /**
         * The AWS Backup Vault Lock configuration that specifies the maximum retention period that the vault retains its recovery points.
         * <p>
         * This setting can be useful if, for example, your organization's policies require you to destroy certain data after retaining it for four years (1460 days).
         * <p>
         * If this parameter is not included, Vault Lock does not enforce a maximum retention period on the recovery points in the vault. If this parameter is included without a value, Vault Lock will not enforce a maximum retention period.
         * <p>
         * If this parameter is specified, any backup or copy job to the vault must have a lifecycle policy with a retention period equal to or shorter than the maximum retention period. If the job's retention period is longer than that maximum retention period, then the vault fails the backup or copy job, and you should either modify your lifecycle settings or use a different vault. Recovery points already saved in the vault prior to Vault Lock are not affected.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-backup-backupvault-lockconfigurationtype.html#cfn-backup-backupvault-lockconfigurationtype-maxretentiondays">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-backup-backupvault-lockconfigurationtype.html#cfn-backup-backupvault-lockconfigurationtype-maxretentiondays</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getMaxRetentionDays() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link LockConfigurationTypeProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link LockConfigurationTypeProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<LockConfigurationTypeProperty> {
            java.lang.Number minRetentionDays;
            java.lang.Number changeableForDays;
            java.lang.Number maxRetentionDays;

            /**
             * Sets the value of {@link LockConfigurationTypeProperty#getMinRetentionDays}
             * @param minRetentionDays The AWS Backup Vault Lock configuration that specifies the minimum retention period that the vault retains its recovery points. This parameter is required.
             *                         This setting can be useful if, for example, your organization's policies require you to retain certain data for at least seven years (2555 days).
             *                         <p>
             *                         If this parameter is not specified, Vault Lock will not enforce a minimum retention period.
             *                         <p>
             *                         If this parameter is specified, any backup or copy job to the vault must have a lifecycle policy with a retention period equal to or longer than the minimum retention period. If the job's retention period is shorter than that minimum retention period, then the vault fails that backup or copy job, and you should either modify your lifecycle settings or use a different vault. Recovery points already saved in the vault prior to Vault Lock are not affected.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder minRetentionDays(java.lang.Number minRetentionDays) {
                this.minRetentionDays = minRetentionDays;
                return this;
            }

            /**
             * Sets the value of {@link LockConfigurationTypeProperty#getChangeableForDays}
             * @param changeableForDays The AWS Backup Vault Lock configuration that specifies the number of days before the lock date.
             *                          For example, setting <code>ChangeableForDays</code> to 30 on Jan. 1, 2022 at 8pm UTC will set the lock date to Jan. 31, 2022 at 8pm UTC.
             *                          <p>
             *                          AWS Backup enforces a 72-hour cooling-off period before Vault Lock takes effect and becomes immutable. Therefore, you must set <code>ChangeableForDays</code> to 3 or greater.
             *                          <p>
             *                          Before the lock date, you can delete Vault Lock from the vault using <code>DeleteBackupVaultLockConfiguration</code> or change the Vault Lock configuration using <code>PutBackupVaultLockConfiguration</code> . On and after the lock date, the Vault Lock becomes immutable and cannot be changed or deleted.
             *                          <p>
             *                          If this parameter is not specified, you can delete Vault Lock from the vault using <code>DeleteBackupVaultLockConfiguration</code> or change the Vault Lock configuration using <code>PutBackupVaultLockConfiguration</code> at any time.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder changeableForDays(java.lang.Number changeableForDays) {
                this.changeableForDays = changeableForDays;
                return this;
            }

            /**
             * Sets the value of {@link LockConfigurationTypeProperty#getMaxRetentionDays}
             * @param maxRetentionDays The AWS Backup Vault Lock configuration that specifies the maximum retention period that the vault retains its recovery points.
             *                         This setting can be useful if, for example, your organization's policies require you to destroy certain data after retaining it for four years (1460 days).
             *                         <p>
             *                         If this parameter is not included, Vault Lock does not enforce a maximum retention period on the recovery points in the vault. If this parameter is included without a value, Vault Lock will not enforce a maximum retention period.
             *                         <p>
             *                         If this parameter is specified, any backup or copy job to the vault must have a lifecycle policy with a retention period equal to or shorter than the maximum retention period. If the job's retention period is longer than that maximum retention period, then the vault fails the backup or copy job, and you should either modify your lifecycle settings or use a different vault. Recovery points already saved in the vault prior to Vault Lock are not affected.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder maxRetentionDays(java.lang.Number maxRetentionDays) {
                this.maxRetentionDays = maxRetentionDays;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link LockConfigurationTypeProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public LockConfigurationTypeProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link LockConfigurationTypeProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements LockConfigurationTypeProperty {
            private final java.lang.Number minRetentionDays;
            private final java.lang.Number changeableForDays;
            private final java.lang.Number maxRetentionDays;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.minRetentionDays = software.amazon.jsii.Kernel.get(this, "minRetentionDays", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.changeableForDays = software.amazon.jsii.Kernel.get(this, "changeableForDays", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.maxRetentionDays = software.amazon.jsii.Kernel.get(this, "maxRetentionDays", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.minRetentionDays = java.util.Objects.requireNonNull(builder.minRetentionDays, "minRetentionDays is required");
                this.changeableForDays = builder.changeableForDays;
                this.maxRetentionDays = builder.maxRetentionDays;
            }

            @Override
            public final java.lang.Number getMinRetentionDays() {
                return this.minRetentionDays;
            }

            @Override
            public final java.lang.Number getChangeableForDays() {
                return this.changeableForDays;
            }

            @Override
            public final java.lang.Number getMaxRetentionDays() {
                return this.maxRetentionDays;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("minRetentionDays", om.valueToTree(this.getMinRetentionDays()));
                if (this.getChangeableForDays() != null) {
                    data.set("changeableForDays", om.valueToTree(this.getChangeableForDays()));
                }
                if (this.getMaxRetentionDays() != null) {
                    data.set("maxRetentionDays", om.valueToTree(this.getMaxRetentionDays()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_backup.CfnBackupVault.LockConfigurationTypeProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                LockConfigurationTypeProperty.Jsii$Proxy that = (LockConfigurationTypeProperty.Jsii$Proxy) o;

                if (!minRetentionDays.equals(that.minRetentionDays)) return false;
                if (this.changeableForDays != null ? !this.changeableForDays.equals(that.changeableForDays) : that.changeableForDays != null) return false;
                return this.maxRetentionDays != null ? this.maxRetentionDays.equals(that.maxRetentionDays) : that.maxRetentionDays == null;
            }

            @Override
            public final int hashCode() {
                int result = this.minRetentionDays.hashCode();
                result = 31 * result + (this.changeableForDays != null ? this.changeableForDays.hashCode() : 0);
                result = 31 * result + (this.maxRetentionDays != null ? this.maxRetentionDays.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Specifies an object containing SNS event notification properties for the target backup vault.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.backup.*;
     * NotificationObjectTypeProperty notificationObjectTypeProperty = NotificationObjectTypeProperty.builder()
     *         .backupVaultEvents(List.of("backupVaultEvents"))
     *         .snsTopicArn("snsTopicArn")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-backup-backupvault-notificationobjecttype.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-backup-backupvault-notificationobjecttype.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_backup.CfnBackupVault.NotificationObjectTypeProperty")
    @software.amazon.jsii.Jsii.Proxy(NotificationObjectTypeProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface NotificationObjectTypeProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * An array of events that indicate the status of jobs to back up resources to the backup vault.
         * <p>
         * For valid events, see <a href="https://docs.aws.amazon.com/aws-backup/latest/devguide/API_PutBackupVaultNotifications.html#API_PutBackupVaultNotifications_RequestSyntax">BackupVaultEvents</a> in the <em>AWS Backup API Guide</em> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-backup-backupvault-notificationobjecttype.html#cfn-backup-backupvault-notificationobjecttype-backupvaultevents">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-backup-backupvault-notificationobjecttype.html#cfn-backup-backupvault-notificationobjecttype-backupvaultevents</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> getBackupVaultEvents();

        /**
         * An ARN that uniquely identifies an Amazon Simple Notification Service (Amazon SNS) topic;
         * <p>
         * for example, <code>arn:aws:sns:us-west-2:111122223333:MyTopic</code> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-backup-backupvault-notificationobjecttype.html#cfn-backup-backupvault-notificationobjecttype-snstopicarn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-backup-backupvault-notificationobjecttype.html#cfn-backup-backupvault-notificationobjecttype-snstopicarn</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getSnsTopicArn();

        /**
         * @return a {@link Builder} of {@link NotificationObjectTypeProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link NotificationObjectTypeProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<NotificationObjectTypeProperty> {
            java.util.List<java.lang.String> backupVaultEvents;
            java.lang.String snsTopicArn;

            /**
             * Sets the value of {@link NotificationObjectTypeProperty#getBackupVaultEvents}
             * @param backupVaultEvents An array of events that indicate the status of jobs to back up resources to the backup vault. This parameter is required.
             *                          For valid events, see <a href="https://docs.aws.amazon.com/aws-backup/latest/devguide/API_PutBackupVaultNotifications.html#API_PutBackupVaultNotifications_RequestSyntax">BackupVaultEvents</a> in the <em>AWS Backup API Guide</em> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder backupVaultEvents(java.util.List<java.lang.String> backupVaultEvents) {
                this.backupVaultEvents = backupVaultEvents;
                return this;
            }

            /**
             * Sets the value of {@link NotificationObjectTypeProperty#getSnsTopicArn}
             * @param snsTopicArn An ARN that uniquely identifies an Amazon Simple Notification Service (Amazon SNS) topic;. This parameter is required.
             *                    for example, <code>arn:aws:sns:us-west-2:111122223333:MyTopic</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder snsTopicArn(java.lang.String snsTopicArn) {
                this.snsTopicArn = snsTopicArn;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link NotificationObjectTypeProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public NotificationObjectTypeProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link NotificationObjectTypeProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements NotificationObjectTypeProperty {
            private final java.util.List<java.lang.String> backupVaultEvents;
            private final java.lang.String snsTopicArn;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.backupVaultEvents = software.amazon.jsii.Kernel.get(this, "backupVaultEvents", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.snsTopicArn = software.amazon.jsii.Kernel.get(this, "snsTopicArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.backupVaultEvents = java.util.Objects.requireNonNull(builder.backupVaultEvents, "backupVaultEvents is required");
                this.snsTopicArn = java.util.Objects.requireNonNull(builder.snsTopicArn, "snsTopicArn is required");
            }

            @Override
            public final java.util.List<java.lang.String> getBackupVaultEvents() {
                return this.backupVaultEvents;
            }

            @Override
            public final java.lang.String getSnsTopicArn() {
                return this.snsTopicArn;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("backupVaultEvents", om.valueToTree(this.getBackupVaultEvents()));
                data.set("snsTopicArn", om.valueToTree(this.getSnsTopicArn()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_backup.CfnBackupVault.NotificationObjectTypeProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                NotificationObjectTypeProperty.Jsii$Proxy that = (NotificationObjectTypeProperty.Jsii$Proxy) o;

                if (!backupVaultEvents.equals(that.backupVaultEvents)) return false;
                return this.snsTopicArn.equals(that.snsTopicArn);
            }

            @Override
            public final int hashCode() {
                int result = this.backupVaultEvents.hashCode();
                result = 31 * result + (this.snsTopicArn.hashCode());
                return result;
            }
        }
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.backup.CfnBackupVault}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.backup.CfnBackupVault> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope Scope in which this resource is defined. This parameter is required.
         * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.backup.CfnBackupVaultProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.backup.CfnBackupVaultProps.Builder();
        }

        /**
         * The name of a logical container where backups are stored.
         * <p>
         * Backup vaults are identified by names that are unique to the account used to create them and the AWS Region where they are created.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-backup-backupvault.html#cfn-backup-backupvault-backupvaultname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-backup-backupvault.html#cfn-backup-backupvault-backupvaultname</a>
         * @param backupVaultName The name of a logical container where backups are stored. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder backupVaultName(final java.lang.String backupVaultName) {
            this.props.backupVaultName(backupVaultName);
            return this;
        }

        /**
         * A resource-based policy that is used to manage access permissions on the target backup vault.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-backup-backupvault.html#cfn-backup-backupvault-accesspolicy">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-backup-backupvault.html#cfn-backup-backupvault-accesspolicy</a>
         * @param accessPolicy A resource-based policy that is used to manage access permissions on the target backup vault. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder accessPolicy(final java.lang.Object accessPolicy) {
            this.props.accessPolicy(accessPolicy);
            return this;
        }

        /**
         * The tags to assign to the backup vault.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-backup-backupvault.html#cfn-backup-backupvault-backupvaulttags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-backup-backupvault.html#cfn-backup-backupvault-backupvaulttags</a>
         * @param backupVaultTags The tags to assign to the backup vault. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder backupVaultTags(final java.util.Map<java.lang.String, java.lang.String> backupVaultTags) {
            this.props.backupVaultTags(backupVaultTags);
            return this;
        }

        /**
         * A server-side encryption key you can specify to encrypt your backups from services that support full AWS Backup management;
         * <p>
         * for example, <code>arn:aws:kms:us-west-2:111122223333:key/1234abcd-12ab-34cd-56ef-1234567890ab</code> . If you specify a key, you must specify its ARN, not its alias. If you do not specify a key, AWS Backup creates a KMS key for you by default.
         * <p>
         * To learn which AWS Backup services support full AWS Backup management and how AWS Backup handles encryption for backups from services that do not yet support full AWS Backup , see <a href="https://docs.aws.amazon.com/aws-backup/latest/devguide/encryption.html">Encryption for backups in AWS Backup</a>
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-backup-backupvault.html#cfn-backup-backupvault-encryptionkeyarn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-backup-backupvault.html#cfn-backup-backupvault-encryptionkeyarn</a>
         * @param encryptionKeyArn A server-side encryption key you can specify to encrypt your backups from services that support full AWS Backup management;. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder encryptionKeyArn(final java.lang.String encryptionKeyArn) {
            this.props.encryptionKeyArn(encryptionKeyArn);
            return this;
        }

        /**
         * Configuration for <a href="https://docs.aws.amazon.com/aws-backup/latest/devguide/vault-lock.html">AWS Backup Vault Lock</a> .
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-backup-backupvault.html#cfn-backup-backupvault-lockconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-backup-backupvault.html#cfn-backup-backupvault-lockconfiguration</a>
         * @param lockConfiguration Configuration for <a href="https://docs.aws.amazon.com/aws-backup/latest/devguide/vault-lock.html">AWS Backup Vault Lock</a> . This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder lockConfiguration(final software.amazon.awscdk.IResolvable lockConfiguration) {
            this.props.lockConfiguration(lockConfiguration);
            return this;
        }
        /**
         * Configuration for <a href="https://docs.aws.amazon.com/aws-backup/latest/devguide/vault-lock.html">AWS Backup Vault Lock</a> .
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-backup-backupvault.html#cfn-backup-backupvault-lockconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-backup-backupvault.html#cfn-backup-backupvault-lockconfiguration</a>
         * @param lockConfiguration Configuration for <a href="https://docs.aws.amazon.com/aws-backup/latest/devguide/vault-lock.html">AWS Backup Vault Lock</a> . This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder lockConfiguration(final software.amazon.awscdk.services.backup.CfnBackupVault.LockConfigurationTypeProperty lockConfiguration) {
            this.props.lockConfiguration(lockConfiguration);
            return this;
        }

        /**
         * The SNS event notifications for the specified backup vault.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-backup-backupvault.html#cfn-backup-backupvault-notifications">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-backup-backupvault.html#cfn-backup-backupvault-notifications</a>
         * @param notifications The SNS event notifications for the specified backup vault. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder notifications(final software.amazon.awscdk.IResolvable notifications) {
            this.props.notifications(notifications);
            return this;
        }
        /**
         * The SNS event notifications for the specified backup vault.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-backup-backupvault.html#cfn-backup-backupvault-notifications">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-backup-backupvault.html#cfn-backup-backupvault-notifications</a>
         * @param notifications The SNS event notifications for the specified backup vault. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder notifications(final software.amazon.awscdk.services.backup.CfnBackupVault.NotificationObjectTypeProperty notifications) {
            this.props.notifications(notifications);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.backup.CfnBackupVault}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.backup.CfnBackupVault build() {
            return new software.amazon.awscdk.services.backup.CfnBackupVault(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
