package software.amazon.awscdk.services.batch;

/**
 * A JobDefinition that uses ECS orchestration.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * IVpc vpc;
 * EcsJobDefinition ecsJob = EcsJobDefinition.Builder.create(this, "JobDefn")
 *         .container(EcsEc2ContainerDefinition.Builder.create(this, "containerDefn")
 *                 .image(ContainerImage.fromRegistry("public.ecr.aws/amazonlinux/amazonlinux:latest"))
 *                 .memory(Size.mebibytes(2048))
 *                 .cpu(256)
 *                 .build())
 *         .build();
 * JobQueue queue = JobQueue.Builder.create(this, "JobQueue")
 *         .computeEnvironments(List.of(OrderedComputeEnvironment.builder()
 *                 .computeEnvironment(ManagedEc2EcsComputeEnvironment.Builder.create(this, "managedEc2CE")
 *                         .vpc(vpc)
 *                         .build())
 *                 .order(1)
 *                 .build()))
 *         .priority(10)
 *         .build();
 * User user = new User(this, "MyUser");
 * ecsJob.grantSubmitJob(user, queue);
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.106.0 (build e852934)", date = "2025-02-21T03:20:28.947Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_batch.EcsJobDefinition")
public class EcsJobDefinition extends software.amazon.awscdk.Resource implements software.amazon.awscdk.services.batch.IJobDefinition {

    protected EcsJobDefinition(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected EcsJobDefinition(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public EcsJobDefinition(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.batch.EcsJobDefinitionProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Import a JobDefinition by its arn.
     * <p>
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param jobDefinitionArn This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.batch.IJobDefinition fromJobDefinitionArn(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull java.lang.String jobDefinitionArn) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.batch.EcsJobDefinition.class, "fromJobDefinitionArn", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.batch.IJobDefinition.class), new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(jobDefinitionArn, "jobDefinitionArn is required") });
    }

    /**
     * Add a RetryStrategy to this JobDefinition.
     * <p>
     * @param strategy This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void addRetryStrategy(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.batch.RetryStrategy strategy) {
        software.amazon.jsii.Kernel.call(this, "addRetryStrategy", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(strategy, "strategy is required") });
    }

    /**
     * Grants the <code>batch:submitJob</code> permission to the identity on both this job definition and the <code>queue</code>.
     * <p>
     * @param identity This parameter is required.
     * @param queue This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void grantSubmitJob(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.iam.IGrantable identity, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.batch.IJobQueue queue) {
        software.amazon.jsii.Kernel.call(this, "grantSubmitJob", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(identity, "identity is required"), java.util.Objects.requireNonNull(queue, "queue is required") });
    }

    /**
     * The container that this job will run.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.batch.IEcsContainerDefinition getContainer() {
        return software.amazon.jsii.Kernel.get(this, "container", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.batch.IEcsContainerDefinition.class));
    }

    /**
     * The ARN of this job definition.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getJobDefinitionArn() {
        return software.amazon.jsii.Kernel.get(this, "jobDefinitionArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The name of this job definition.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getJobDefinitionName() {
        return software.amazon.jsii.Kernel.get(this, "jobDefinitionName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Defines the retry behavior for this job.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.util.List<software.amazon.awscdk.services.batch.RetryStrategy> getRetryStrategies() {
        return java.util.Collections.unmodifiableList(software.amazon.jsii.Kernel.get(this, "retryStrategies", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.batch.RetryStrategy.class))));
    }

    /**
     * The default parameters passed to the container These parameters can be referenced in the <code>command</code> that you give to the container.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.util.Map<java.lang.String, java.lang.Object> getParameters() {
        return java.util.Optional.ofNullable((java.util.Map<java.lang.String, java.lang.Object>)(software.amazon.jsii.Kernel.get(this, "parameters", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))))).map(java.util.Collections::unmodifiableMap).orElse(null);
    }

    /**
     * Whether to propagate tags from the JobDefinition to the ECS task that Batch spawns.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Boolean getPropagateTags() {
        return software.amazon.jsii.Kernel.get(this, "propagateTags", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
    }

    /**
     * The number of times to retry a job.
     * <p>
     * The job is retried on failure the same number of attempts as the value.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Number getRetryAttempts() {
        return software.amazon.jsii.Kernel.get(this, "retryAttempts", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
    }

    /**
     * The priority of this Job.
     * <p>
     * Only used in Fairshare Scheduling
     * to decide which job to run first when there are multiple jobs
     * with the same share identifier.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Number getSchedulingPriority() {
        return software.amazon.jsii.Kernel.get(this, "schedulingPriority", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
    }

    /**
     * The timeout time for jobs that are submitted with this job definition.
     * <p>
     * After the amount of time you specify passes,
     * Batch terminates your jobs if they aren't finished.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable software.amazon.awscdk.Duration getTimeout() {
        return software.amazon.jsii.Kernel.get(this, "timeout", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.Duration.class));
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.batch.EcsJobDefinition}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.batch.EcsJobDefinition> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope This parameter is required.
         * @param id This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.batch.EcsJobDefinitionProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.batch.EcsJobDefinitionProps.Builder();
        }

        /**
         * The name of this job definition.
         * <p>
         * Default: - generated by CloudFormation
         * <p>
         * @return {@code this}
         * @param jobDefinitionName The name of this job definition. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder jobDefinitionName(final java.lang.String jobDefinitionName) {
            this.props.jobDefinitionName(jobDefinitionName);
            return this;
        }

        /**
         * The default parameters passed to the container These parameters can be referenced in the <code>command</code> that you give to the container.
         * <p>
         * Default: none
         * <p>
         * @return {@code this}
         * @see <a href="https://docs.aws.amazon.com/batch/latest/userguide/job_definition_parameters.html#parameters">https://docs.aws.amazon.com/batch/latest/userguide/job_definition_parameters.html#parameters</a>
         * @param parameters The default parameters passed to the container These parameters can be referenced in the <code>command</code> that you give to the container. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder parameters(final java.util.Map<java.lang.String, ? extends java.lang.Object> parameters) {
            this.props.parameters(parameters);
            return this;
        }

        /**
         * The number of times to retry a job.
         * <p>
         * The job is retried on failure the same number of attempts as the value.
         * <p>
         * Default: 1
         * <p>
         * @return {@code this}
         * @param retryAttempts The number of times to retry a job. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder retryAttempts(final java.lang.Number retryAttempts) {
            this.props.retryAttempts(retryAttempts);
            return this;
        }

        /**
         * Defines the retry behavior for this job.
         * <p>
         * Default: - no `RetryStrategy`
         * <p>
         * @return {@code this}
         * @param retryStrategies Defines the retry behavior for this job. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder retryStrategies(final java.util.List<? extends software.amazon.awscdk.services.batch.RetryStrategy> retryStrategies) {
            this.props.retryStrategies(retryStrategies);
            return this;
        }

        /**
         * The priority of this Job.
         * <p>
         * Only used in Fairshare Scheduling
         * to decide which job to run first when there are multiple jobs
         * with the same share identifier.
         * <p>
         * Default: none
         * <p>
         * @return {@code this}
         * @param schedulingPriority The priority of this Job. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder schedulingPriority(final java.lang.Number schedulingPriority) {
            this.props.schedulingPriority(schedulingPriority);
            return this;
        }

        /**
         * The timeout time for jobs that are submitted with this job definition.
         * <p>
         * After the amount of time you specify passes,
         * Batch terminates your jobs if they aren't finished.
         * <p>
         * Default: - no timeout
         * <p>
         * @return {@code this}
         * @param timeout The timeout time for jobs that are submitted with this job definition. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder timeout(final software.amazon.awscdk.Duration timeout) {
            this.props.timeout(timeout);
            return this;
        }

        /**
         * The container that this job will run.
         * <p>
         * @return {@code this}
         * @param container The container that this job will run. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder container(final software.amazon.awscdk.services.batch.IEcsContainerDefinition container) {
            this.props.container(container);
            return this;
        }

        /**
         * Whether to propagate tags from the JobDefinition to the ECS task that Batch spawns.
         * <p>
         * Default: false
         * <p>
         * @return {@code this}
         * @param propagateTags Whether to propagate tags from the JobDefinition to the ECS task that Batch spawns. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder propagateTags(final java.lang.Boolean propagateTags) {
            this.props.propagateTags(propagateTags);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.batch.EcsJobDefinition}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.batch.EcsJobDefinition build() {
            return new software.amazon.awscdk.services.batch.EcsJobDefinition(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
