package software.amazon.awscdk.services.batch;

/**
 * JobQueues can receive Jobs, which are removed from the queue when sent to the linked ComputeEnvironment(s) to be executed.
 * <p>
 * Jobs exit the queue in FIFO order unless a <code>SchedulingPolicy</code> is linked.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * IVpc vpc;
 * EcsJobDefinition ecsJob = EcsJobDefinition.Builder.create(this, "JobDefn")
 *         .container(EcsEc2ContainerDefinition.Builder.create(this, "containerDefn")
 *                 .image(ContainerImage.fromRegistry("public.ecr.aws/amazonlinux/amazonlinux:latest"))
 *                 .memory(Size.mebibytes(2048))
 *                 .cpu(256)
 *                 .build())
 *         .build();
 * JobQueue queue = JobQueue.Builder.create(this, "JobQueue")
 *         .computeEnvironments(List.of(OrderedComputeEnvironment.builder()
 *                 .computeEnvironment(ManagedEc2EcsComputeEnvironment.Builder.create(this, "managedEc2CE")
 *                         .vpc(vpc)
 *                         .build())
 *                 .order(1)
 *                 .build()))
 *         .priority(10)
 *         .build();
 * User user = new User(this, "MyUser");
 * ecsJob.grantSubmitJob(user, queue);
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.106.0 (build e852934)", date = "2025-02-21T03:20:29.006Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_batch.JobQueue")
public class JobQueue extends software.amazon.awscdk.Resource implements software.amazon.awscdk.services.batch.IJobQueue {

    protected JobQueue(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected JobQueue(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public JobQueue(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.batch.JobQueueProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), props });
    }

    /**
     * @param scope This parameter is required.
     * @param id This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public JobQueue(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required") });
    }

    /**
     * refer to an existing JobQueue by its arn.
     * <p>
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param jobQueueArn This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.batch.IJobQueue fromJobQueueArn(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull java.lang.String jobQueueArn) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.batch.JobQueue.class, "fromJobQueueArn", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.batch.IJobQueue.class), new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(jobQueueArn, "jobQueueArn is required") });
    }

    /**
     * Add a <code>ComputeEnvironment</code> to this Queue.
     * <p>
     * The Queue will prefer lower-order <code>ComputeEnvironment</code>s.
     * <p>
     * @param computeEnvironment This parameter is required.
     * @param order This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void addComputeEnvironment(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.batch.IComputeEnvironment computeEnvironment, final @org.jetbrains.annotations.NotNull java.lang.Number order) {
        software.amazon.jsii.Kernel.call(this, "addComputeEnvironment", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(computeEnvironment, "computeEnvironment is required"), java.util.Objects.requireNonNull(order, "order is required") });
    }

    /**
     * The set of compute environments mapped to a job queue and their order relative to each other.
     * <p>
     * The job scheduler uses this parameter to determine which compute environment runs a specific job.
     * Compute environments must be in the VALID state before you can associate them with a job queue.
     * You can associate up to three compute environments with a job queue.
     * All of the compute environments must be either EC2 (EC2 or SPOT) or Fargate (FARGATE or FARGATE_SPOT);
     * EC2 and Fargate compute environments can't be mixed.
     * <p>
     * <em>Note</em>: All compute environments that are associated with a job queue must share the same architecture.
     * AWS Batch doesn't support mixing compute environment architecture types in a single job queue.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.util.List<software.amazon.awscdk.services.batch.OrderedComputeEnvironment> getComputeEnvironments() {
        return java.util.Collections.unmodifiableList(software.amazon.jsii.Kernel.get(this, "computeEnvironments", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.batch.OrderedComputeEnvironment.class))));
    }

    /**
     * The ARN of this job queue.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getJobQueueArn() {
        return software.amazon.jsii.Kernel.get(this, "jobQueueArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The name of the job queue.
     * <p>
     * It can be up to 128 letters long.
     * It can contain uppercase and lowercase letters, numbers, hyphens (-), and underscores (_)
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getJobQueueName() {
        return software.amazon.jsii.Kernel.get(this, "jobQueueName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The priority of the job queue.
     * <p>
     * Job queues with a higher priority are evaluated first when associated with the same compute environment.
     * Priority is determined in descending order.
     * For example, a job queue with a priority value of 10 is given scheduling preference over a job queue with a priority value of 1.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Number getPriority() {
        return software.amazon.jsii.Kernel.get(this, "priority", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
    }

    /**
     * If the job queue is enabled, it is able to accept jobs.
     * <p>
     * Otherwise, new jobs can't be added to the queue, but jobs already in the queue can finish.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Boolean getEnabled() {
        return software.amazon.jsii.Kernel.get(this, "enabled", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
    }

    /**
     * The SchedulingPolicy for this JobQueue.
     * <p>
     * Instructs the Scheduler how to schedule different jobs.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.batch.ISchedulingPolicy getSchedulingPolicy() {
        return software.amazon.jsii.Kernel.get(this, "schedulingPolicy", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.batch.ISchedulingPolicy.class));
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.batch.JobQueue}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.batch.JobQueue> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope This parameter is required.
         * @param id This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private software.amazon.awscdk.services.batch.JobQueueProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
        }

        /**
         * The set of compute environments mapped to a job queue and their order relative to each other.
         * <p>
         * The job scheduler uses this parameter to determine which compute environment runs a specific job.
         * Compute environments must be in the VALID state before you can associate them with a job queue.
         * You can associate up to three compute environments with a job queue.
         * All of the compute environments must be either EC2 (EC2 or SPOT) or Fargate (FARGATE or FARGATE_SPOT);
         * EC2 and Fargate compute environments can't be mixed.
         * <p>
         * <em>Note</em>: All compute environments that are associated with a job queue must share the same architecture.
         * AWS Batch doesn't support mixing compute environment architecture types in a single job queue.
         * <p>
         * Default: none
         * <p>
         * @return {@code this}
         * @param computeEnvironments The set of compute environments mapped to a job queue and their order relative to each other. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder computeEnvironments(final java.util.List<? extends software.amazon.awscdk.services.batch.OrderedComputeEnvironment> computeEnvironments) {
            this.props().computeEnvironments(computeEnvironments);
            return this;
        }

        /**
         * If the job queue is enabled, it is able to accept jobs.
         * <p>
         * Otherwise, new jobs can't be added to the queue, but jobs already in the queue can finish.
         * <p>
         * Default: true
         * <p>
         * @return {@code this}
         * @param enabled If the job queue is enabled, it is able to accept jobs. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder enabled(final java.lang.Boolean enabled) {
            this.props().enabled(enabled);
            return this;
        }

        /**
         * The name of the job queue.
         * <p>
         * It can be up to 128 letters long.
         * It can contain uppercase and lowercase letters, numbers, hyphens (-), and underscores (_)
         * <p>
         * Default: - no name
         * <p>
         * @return {@code this}
         * @param jobQueueName The name of the job queue. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder jobQueueName(final java.lang.String jobQueueName) {
            this.props().jobQueueName(jobQueueName);
            return this;
        }

        /**
         * The set of actions that AWS Batch perform on jobs that remain at the head of the job queue in the specified state longer than specified times.
         * <p>
         * Default: - no actions
         * <p>
         * @return {@code this}
         * @param jobStateTimeLimitActions The set of actions that AWS Batch perform on jobs that remain at the head of the job queue in the specified state longer than specified times. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder jobStateTimeLimitActions(final java.util.List<? extends software.amazon.awscdk.services.batch.JobStateTimeLimitAction> jobStateTimeLimitActions) {
            this.props().jobStateTimeLimitActions(jobStateTimeLimitActions);
            return this;
        }

        /**
         * The priority of the job queue.
         * <p>
         * Job queues with a higher priority are evaluated first when associated with the same compute environment.
         * Priority is determined in descending order.
         * For example, a job queue with a priority of 10 is given scheduling preference over a job queue with a priority of 1.
         * <p>
         * Default: 1
         * <p>
         * @return {@code this}
         * @param priority The priority of the job queue. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder priority(final java.lang.Number priority) {
            this.props().priority(priority);
            return this;
        }

        /**
         * The SchedulingPolicy for this JobQueue.
         * <p>
         * Instructs the Scheduler how to schedule different jobs.
         * <p>
         * Default: - no scheduling policy
         * <p>
         * @return {@code this}
         * @param schedulingPolicy The SchedulingPolicy for this JobQueue. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder schedulingPolicy(final software.amazon.awscdk.services.batch.ISchedulingPolicy schedulingPolicy) {
            this.props().schedulingPolicy(schedulingPolicy);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.batch.JobQueue}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.batch.JobQueue build() {
            return new software.amazon.awscdk.services.batch.JobQueue(
                this.scope,
                this.id,
                this.props != null ? this.props.build() : null
            );
        }

        private software.amazon.awscdk.services.batch.JobQueueProps.Builder props() {
            if (this.props == null) {
                this.props = new software.amazon.awscdk.services.batch.JobQueueProps.Builder();
            }
            return this.props;
        }
    }
}
