package software.amazon.awscdk.services.bedrock;

/**
 * Properties for defining a <code>CfnAgent</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.bedrock.*;
 * CfnAgentProps cfnAgentProps = CfnAgentProps.builder()
 *         .agentName("agentName")
 *         // the properties below are optional
 *         .actionGroups(List.of(AgentActionGroupProperty.builder()
 *                 .actionGroupName("actionGroupName")
 *                 // the properties below are optional
 *                 .actionGroupExecutor(ActionGroupExecutorProperty.builder()
 *                         .customControl("customControl")
 *                         .lambda("lambda")
 *                         .build())
 *                 .actionGroupState("actionGroupState")
 *                 .apiSchema(APISchemaProperty.builder()
 *                         .payload("payload")
 *                         .s3(S3IdentifierProperty.builder()
 *                                 .s3BucketName("s3BucketName")
 *                                 .s3ObjectKey("s3ObjectKey")
 *                                 .build())
 *                         .build())
 *                 .description("description")
 *                 .functionSchema(FunctionSchemaProperty.builder()
 *                         .functions(List.of(FunctionProperty.builder()
 *                                 .name("name")
 *                                 // the properties below are optional
 *                                 .description("description")
 *                                 .parameters(Map.of(
 *                                         "parametersKey", ParameterDetailProperty.builder()
 *                                                 .type("type")
 *                                                 // the properties below are optional
 *                                                 .description("description")
 *                                                 .required(false)
 *                                                 .build()))
 *                                 .requireConfirmation("requireConfirmation")
 *                                 .build()))
 *                         .build())
 *                 .parentActionGroupSignature("parentActionGroupSignature")
 *                 .skipResourceInUseCheckOnDelete(false)
 *                 .build()))
 *         .agentResourceRoleArn("agentResourceRoleArn")
 *         .autoPrepare(false)
 *         .customerEncryptionKeyArn("customerEncryptionKeyArn")
 *         .description("description")
 *         .foundationModel("foundationModel")
 *         .guardrailConfiguration(GuardrailConfigurationProperty.builder()
 *                 .guardrailIdentifier("guardrailIdentifier")
 *                 .guardrailVersion("guardrailVersion")
 *                 .build())
 *         .idleSessionTtlInSeconds(123)
 *         .instruction("instruction")
 *         .knowledgeBases(List.of(AgentKnowledgeBaseProperty.builder()
 *                 .description("description")
 *                 .knowledgeBaseId("knowledgeBaseId")
 *                 // the properties below are optional
 *                 .knowledgeBaseState("knowledgeBaseState")
 *                 .build()))
 *         .promptOverrideConfiguration(PromptOverrideConfigurationProperty.builder()
 *                 .promptConfigurations(List.of(PromptConfigurationProperty.builder()
 *                         .basePromptTemplate("basePromptTemplate")
 *                         .inferenceConfiguration(InferenceConfigurationProperty.builder()
 *                                 .maximumLength(123)
 *                                 .stopSequences(List.of("stopSequences"))
 *                                 .temperature(123)
 *                                 .topK(123)
 *                                 .topP(123)
 *                                 .build())
 *                         .parserMode("parserMode")
 *                         .promptCreationMode("promptCreationMode")
 *                         .promptState("promptState")
 *                         .promptType("promptType")
 *                         .build()))
 *                 // the properties below are optional
 *                 .overrideLambda("overrideLambda")
 *                 .build())
 *         .skipResourceInUseCheckOnDelete(false)
 *         .tags(Map.of(
 *                 "tagsKey", "tags"))
 *         .testAliasTags(Map.of(
 *                 "testAliasTagsKey", "testAliasTags"))
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-bedrock-agent.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-bedrock-agent.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.106.0 (build e852934)", date = "2025-02-21T03:20:29.058Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_bedrock.CfnAgentProps")
@software.amazon.jsii.Jsii.Proxy(CfnAgentProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnAgentProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The name of the agent.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-bedrock-agent.html#cfn-bedrock-agent-agentname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-bedrock-agent.html#cfn-bedrock-agent-agentname</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getAgentName();

    /**
     * The action groups that belong to an agent.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-bedrock-agent.html#cfn-bedrock-agent-actiongroups">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-bedrock-agent.html#cfn-bedrock-agent-actiongroups</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getActionGroups() {
        return null;
    }

    /**
     * The Amazon Resource Name (ARN) of the IAM role with permissions to invoke API operations on the agent.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-bedrock-agent.html#cfn-bedrock-agent-agentresourcerolearn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-bedrock-agent.html#cfn-bedrock-agent-agentresourcerolearn</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getAgentResourceRoleArn() {
        return null;
    }

    /**
     * Specifies whether to automatically update the <code>DRAFT</code> version of the agent after making changes to the agent.
     * <p>
     * The <code>DRAFT</code> version can be continually iterated upon during internal development. By default, this value is <code>false</code> .
     * <p>
     * Default: - false
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-bedrock-agent.html#cfn-bedrock-agent-autoprepare">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-bedrock-agent.html#cfn-bedrock-agent-autoprepare</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getAutoPrepare() {
        return null;
    }

    /**
     * The Amazon Resource Name (ARN) of the AWS KMS key that encrypts the agent.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-bedrock-agent.html#cfn-bedrock-agent-customerencryptionkeyarn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-bedrock-agent.html#cfn-bedrock-agent-customerencryptionkeyarn</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getCustomerEncryptionKeyArn() {
        return null;
    }

    /**
     * The description of the agent.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-bedrock-agent.html#cfn-bedrock-agent-description">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-bedrock-agent.html#cfn-bedrock-agent-description</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getDescription() {
        return null;
    }

    /**
     * The foundation model used for orchestration by the agent.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-bedrock-agent.html#cfn-bedrock-agent-foundationmodel">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-bedrock-agent.html#cfn-bedrock-agent-foundationmodel</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getFoundationModel() {
        return null;
    }

    /**
     * Details about the guardrail associated with the agent.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-bedrock-agent.html#cfn-bedrock-agent-guardrailconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-bedrock-agent.html#cfn-bedrock-agent-guardrailconfiguration</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getGuardrailConfiguration() {
        return null;
    }

    /**
     * The number of seconds for which Amazon Bedrock keeps information about a user's conversation with the agent.
     * <p>
     * A user interaction remains active for the amount of time specified. If no conversation occurs during this time, the session expires and Amazon Bedrock deletes any data provided before the timeout.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-bedrock-agent.html#cfn-bedrock-agent-idlesessionttlinseconds">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-bedrock-agent.html#cfn-bedrock-agent-idlesessionttlinseconds</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getIdleSessionTtlInSeconds() {
        return null;
    }

    /**
     * Instructions that tell the agent what it should do and how it should interact with users.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-bedrock-agent.html#cfn-bedrock-agent-instruction">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-bedrock-agent.html#cfn-bedrock-agent-instruction</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getInstruction() {
        return null;
    }

    /**
     * The knowledge bases associated with the agent.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-bedrock-agent.html#cfn-bedrock-agent-knowledgebases">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-bedrock-agent.html#cfn-bedrock-agent-knowledgebases</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getKnowledgeBases() {
        return null;
    }

    /**
     * Contains configurations to override prompt templates in different parts of an agent sequence.
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/bedrock/latest/userguide/advanced-prompts.html">Advanced prompts</a> .
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-bedrock-agent.html#cfn-bedrock-agent-promptoverrideconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-bedrock-agent.html#cfn-bedrock-agent-promptoverrideconfiguration</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getPromptOverrideConfiguration() {
        return null;
    }

    /**
     * Specifies whether to delete the resource even if it's in use.
     * <p>
     * By default, this value is <code>false</code> .
     * <p>
     * Default: - false
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-bedrock-agent.html#cfn-bedrock-agent-skipresourceinusecheckondelete">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-bedrock-agent.html#cfn-bedrock-agent-skipresourceinusecheckondelete</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getSkipResourceInUseCheckOnDelete() {
        return null;
    }

    /**
     * Metadata that you can assign to a resource as key-value pairs. For more information, see the following resources:.
     * <p>
     * <ul>
     * <li><a href="https://docs.aws.amazon.com/tag-editor/latest/userguide/tagging.html#tag-conventions">Tag naming limits and requirements</a></li>
     * <li><a href="https://docs.aws.amazon.com/tag-editor/latest/userguide/tagging.html#tag-best-practices">Tagging best practices</a></li>
     * </ul>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-bedrock-agent.html#cfn-bedrock-agent-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-bedrock-agent.html#cfn-bedrock-agent-tags</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.Map<java.lang.String, java.lang.String> getTags() {
        return null;
    }

    /**
     * Metadata that you can assign to a resource as key-value pairs. For more information, see the following resources:.
     * <p>
     * <ul>
     * <li><a href="https://docs.aws.amazon.com/tag-editor/latest/userguide/tagging.html#tag-conventions">Tag naming limits and requirements</a></li>
     * <li><a href="https://docs.aws.amazon.com/tag-editor/latest/userguide/tagging.html#tag-best-practices">Tagging best practices</a></li>
     * </ul>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-bedrock-agent.html#cfn-bedrock-agent-testaliastags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-bedrock-agent.html#cfn-bedrock-agent-testaliastags</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getTestAliasTags() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnAgentProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnAgentProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnAgentProps> {
        java.lang.String agentName;
        java.lang.Object actionGroups;
        java.lang.String agentResourceRoleArn;
        java.lang.Object autoPrepare;
        java.lang.String customerEncryptionKeyArn;
        java.lang.String description;
        java.lang.String foundationModel;
        java.lang.Object guardrailConfiguration;
        java.lang.Number idleSessionTtlInSeconds;
        java.lang.String instruction;
        java.lang.Object knowledgeBases;
        java.lang.Object promptOverrideConfiguration;
        java.lang.Object skipResourceInUseCheckOnDelete;
        java.util.Map<java.lang.String, java.lang.String> tags;
        java.lang.Object testAliasTags;

        /**
         * Sets the value of {@link CfnAgentProps#getAgentName}
         * @param agentName The name of the agent. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder agentName(java.lang.String agentName) {
            this.agentName = agentName;
            return this;
        }

        /**
         * Sets the value of {@link CfnAgentProps#getActionGroups}
         * @param actionGroups The action groups that belong to an agent.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder actionGroups(software.amazon.awscdk.IResolvable actionGroups) {
            this.actionGroups = actionGroups;
            return this;
        }

        /**
         * Sets the value of {@link CfnAgentProps#getActionGroups}
         * @param actionGroups The action groups that belong to an agent.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder actionGroups(java.util.List<? extends java.lang.Object> actionGroups) {
            this.actionGroups = actionGroups;
            return this;
        }

        /**
         * Sets the value of {@link CfnAgentProps#getAgentResourceRoleArn}
         * @param agentResourceRoleArn The Amazon Resource Name (ARN) of the IAM role with permissions to invoke API operations on the agent.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder agentResourceRoleArn(java.lang.String agentResourceRoleArn) {
            this.agentResourceRoleArn = agentResourceRoleArn;
            return this;
        }

        /**
         * Sets the value of {@link CfnAgentProps#getAutoPrepare}
         * @param autoPrepare Specifies whether to automatically update the <code>DRAFT</code> version of the agent after making changes to the agent.
         *                    The <code>DRAFT</code> version can be continually iterated upon during internal development. By default, this value is <code>false</code> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder autoPrepare(java.lang.Boolean autoPrepare) {
            this.autoPrepare = autoPrepare;
            return this;
        }

        /**
         * Sets the value of {@link CfnAgentProps#getAutoPrepare}
         * @param autoPrepare Specifies whether to automatically update the <code>DRAFT</code> version of the agent after making changes to the agent.
         *                    The <code>DRAFT</code> version can be continually iterated upon during internal development. By default, this value is <code>false</code> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder autoPrepare(software.amazon.awscdk.IResolvable autoPrepare) {
            this.autoPrepare = autoPrepare;
            return this;
        }

        /**
         * Sets the value of {@link CfnAgentProps#getCustomerEncryptionKeyArn}
         * @param customerEncryptionKeyArn The Amazon Resource Name (ARN) of the AWS KMS key that encrypts the agent.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder customerEncryptionKeyArn(java.lang.String customerEncryptionKeyArn) {
            this.customerEncryptionKeyArn = customerEncryptionKeyArn;
            return this;
        }

        /**
         * Sets the value of {@link CfnAgentProps#getDescription}
         * @param description The description of the agent.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder description(java.lang.String description) {
            this.description = description;
            return this;
        }

        /**
         * Sets the value of {@link CfnAgentProps#getFoundationModel}
         * @param foundationModel The foundation model used for orchestration by the agent.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder foundationModel(java.lang.String foundationModel) {
            this.foundationModel = foundationModel;
            return this;
        }

        /**
         * Sets the value of {@link CfnAgentProps#getGuardrailConfiguration}
         * @param guardrailConfiguration Details about the guardrail associated with the agent.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder guardrailConfiguration(software.amazon.awscdk.IResolvable guardrailConfiguration) {
            this.guardrailConfiguration = guardrailConfiguration;
            return this;
        }

        /**
         * Sets the value of {@link CfnAgentProps#getGuardrailConfiguration}
         * @param guardrailConfiguration Details about the guardrail associated with the agent.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder guardrailConfiguration(software.amazon.awscdk.services.bedrock.CfnAgent.GuardrailConfigurationProperty guardrailConfiguration) {
            this.guardrailConfiguration = guardrailConfiguration;
            return this;
        }

        /**
         * Sets the value of {@link CfnAgentProps#getIdleSessionTtlInSeconds}
         * @param idleSessionTtlInSeconds The number of seconds for which Amazon Bedrock keeps information about a user's conversation with the agent.
         *                                A user interaction remains active for the amount of time specified. If no conversation occurs during this time, the session expires and Amazon Bedrock deletes any data provided before the timeout.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder idleSessionTtlInSeconds(java.lang.Number idleSessionTtlInSeconds) {
            this.idleSessionTtlInSeconds = idleSessionTtlInSeconds;
            return this;
        }

        /**
         * Sets the value of {@link CfnAgentProps#getInstruction}
         * @param instruction Instructions that tell the agent what it should do and how it should interact with users.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder instruction(java.lang.String instruction) {
            this.instruction = instruction;
            return this;
        }

        /**
         * Sets the value of {@link CfnAgentProps#getKnowledgeBases}
         * @param knowledgeBases The knowledge bases associated with the agent.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder knowledgeBases(software.amazon.awscdk.IResolvable knowledgeBases) {
            this.knowledgeBases = knowledgeBases;
            return this;
        }

        /**
         * Sets the value of {@link CfnAgentProps#getKnowledgeBases}
         * @param knowledgeBases The knowledge bases associated with the agent.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder knowledgeBases(java.util.List<? extends java.lang.Object> knowledgeBases) {
            this.knowledgeBases = knowledgeBases;
            return this;
        }

        /**
         * Sets the value of {@link CfnAgentProps#getPromptOverrideConfiguration}
         * @param promptOverrideConfiguration Contains configurations to override prompt templates in different parts of an agent sequence.
         *                                    For more information, see <a href="https://docs.aws.amazon.com/bedrock/latest/userguide/advanced-prompts.html">Advanced prompts</a> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder promptOverrideConfiguration(software.amazon.awscdk.IResolvable promptOverrideConfiguration) {
            this.promptOverrideConfiguration = promptOverrideConfiguration;
            return this;
        }

        /**
         * Sets the value of {@link CfnAgentProps#getPromptOverrideConfiguration}
         * @param promptOverrideConfiguration Contains configurations to override prompt templates in different parts of an agent sequence.
         *                                    For more information, see <a href="https://docs.aws.amazon.com/bedrock/latest/userguide/advanced-prompts.html">Advanced prompts</a> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder promptOverrideConfiguration(software.amazon.awscdk.services.bedrock.CfnAgent.PromptOverrideConfigurationProperty promptOverrideConfiguration) {
            this.promptOverrideConfiguration = promptOverrideConfiguration;
            return this;
        }

        /**
         * Sets the value of {@link CfnAgentProps#getSkipResourceInUseCheckOnDelete}
         * @param skipResourceInUseCheckOnDelete Specifies whether to delete the resource even if it's in use.
         *                                       By default, this value is <code>false</code> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder skipResourceInUseCheckOnDelete(java.lang.Boolean skipResourceInUseCheckOnDelete) {
            this.skipResourceInUseCheckOnDelete = skipResourceInUseCheckOnDelete;
            return this;
        }

        /**
         * Sets the value of {@link CfnAgentProps#getSkipResourceInUseCheckOnDelete}
         * @param skipResourceInUseCheckOnDelete Specifies whether to delete the resource even if it's in use.
         *                                       By default, this value is <code>false</code> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder skipResourceInUseCheckOnDelete(software.amazon.awscdk.IResolvable skipResourceInUseCheckOnDelete) {
            this.skipResourceInUseCheckOnDelete = skipResourceInUseCheckOnDelete;
            return this;
        }

        /**
         * Sets the value of {@link CfnAgentProps#getTags}
         * @param tags Metadata that you can assign to a resource as key-value pairs. For more information, see the following resources:.
         *             <ul>
         *             <li><a href="https://docs.aws.amazon.com/tag-editor/latest/userguide/tagging.html#tag-conventions">Tag naming limits and requirements</a></li>
         *             <li><a href="https://docs.aws.amazon.com/tag-editor/latest/userguide/tagging.html#tag-best-practices">Tagging best practices</a></li>
         *             </ul>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tags(java.util.Map<java.lang.String, java.lang.String> tags) {
            this.tags = tags;
            return this;
        }

        /**
         * Sets the value of {@link CfnAgentProps#getTestAliasTags}
         * @param testAliasTags Metadata that you can assign to a resource as key-value pairs. For more information, see the following resources:.
         *                      <ul>
         *                      <li><a href="https://docs.aws.amazon.com/tag-editor/latest/userguide/tagging.html#tag-conventions">Tag naming limits and requirements</a></li>
         *                      <li><a href="https://docs.aws.amazon.com/tag-editor/latest/userguide/tagging.html#tag-best-practices">Tagging best practices</a></li>
         *                      </ul>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder testAliasTags(java.util.Map<java.lang.String, java.lang.String> testAliasTags) {
            this.testAliasTags = testAliasTags;
            return this;
        }

        /**
         * Sets the value of {@link CfnAgentProps#getTestAliasTags}
         * @param testAliasTags Metadata that you can assign to a resource as key-value pairs. For more information, see the following resources:.
         *                      <ul>
         *                      <li><a href="https://docs.aws.amazon.com/tag-editor/latest/userguide/tagging.html#tag-conventions">Tag naming limits and requirements</a></li>
         *                      <li><a href="https://docs.aws.amazon.com/tag-editor/latest/userguide/tagging.html#tag-best-practices">Tagging best practices</a></li>
         *                      </ul>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder testAliasTags(software.amazon.awscdk.IResolvable testAliasTags) {
            this.testAliasTags = testAliasTags;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnAgentProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnAgentProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnAgentProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnAgentProps {
        private final java.lang.String agentName;
        private final java.lang.Object actionGroups;
        private final java.lang.String agentResourceRoleArn;
        private final java.lang.Object autoPrepare;
        private final java.lang.String customerEncryptionKeyArn;
        private final java.lang.String description;
        private final java.lang.String foundationModel;
        private final java.lang.Object guardrailConfiguration;
        private final java.lang.Number idleSessionTtlInSeconds;
        private final java.lang.String instruction;
        private final java.lang.Object knowledgeBases;
        private final java.lang.Object promptOverrideConfiguration;
        private final java.lang.Object skipResourceInUseCheckOnDelete;
        private final java.util.Map<java.lang.String, java.lang.String> tags;
        private final java.lang.Object testAliasTags;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.agentName = software.amazon.jsii.Kernel.get(this, "agentName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.actionGroups = software.amazon.jsii.Kernel.get(this, "actionGroups", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.agentResourceRoleArn = software.amazon.jsii.Kernel.get(this, "agentResourceRoleArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.autoPrepare = software.amazon.jsii.Kernel.get(this, "autoPrepare", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.customerEncryptionKeyArn = software.amazon.jsii.Kernel.get(this, "customerEncryptionKeyArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.description = software.amazon.jsii.Kernel.get(this, "description", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.foundationModel = software.amazon.jsii.Kernel.get(this, "foundationModel", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.guardrailConfiguration = software.amazon.jsii.Kernel.get(this, "guardrailConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.idleSessionTtlInSeconds = software.amazon.jsii.Kernel.get(this, "idleSessionTtlInSeconds", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.instruction = software.amazon.jsii.Kernel.get(this, "instruction", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.knowledgeBases = software.amazon.jsii.Kernel.get(this, "knowledgeBases", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.promptOverrideConfiguration = software.amazon.jsii.Kernel.get(this, "promptOverrideConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.skipResourceInUseCheckOnDelete = software.amazon.jsii.Kernel.get(this, "skipResourceInUseCheckOnDelete", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.tags = software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.testAliasTags = software.amazon.jsii.Kernel.get(this, "testAliasTags", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.agentName = java.util.Objects.requireNonNull(builder.agentName, "agentName is required");
            this.actionGroups = builder.actionGroups;
            this.agentResourceRoleArn = builder.agentResourceRoleArn;
            this.autoPrepare = builder.autoPrepare;
            this.customerEncryptionKeyArn = builder.customerEncryptionKeyArn;
            this.description = builder.description;
            this.foundationModel = builder.foundationModel;
            this.guardrailConfiguration = builder.guardrailConfiguration;
            this.idleSessionTtlInSeconds = builder.idleSessionTtlInSeconds;
            this.instruction = builder.instruction;
            this.knowledgeBases = builder.knowledgeBases;
            this.promptOverrideConfiguration = builder.promptOverrideConfiguration;
            this.skipResourceInUseCheckOnDelete = builder.skipResourceInUseCheckOnDelete;
            this.tags = builder.tags;
            this.testAliasTags = builder.testAliasTags;
        }

        @Override
        public final java.lang.String getAgentName() {
            return this.agentName;
        }

        @Override
        public final java.lang.Object getActionGroups() {
            return this.actionGroups;
        }

        @Override
        public final java.lang.String getAgentResourceRoleArn() {
            return this.agentResourceRoleArn;
        }

        @Override
        public final java.lang.Object getAutoPrepare() {
            return this.autoPrepare;
        }

        @Override
        public final java.lang.String getCustomerEncryptionKeyArn() {
            return this.customerEncryptionKeyArn;
        }

        @Override
        public final java.lang.String getDescription() {
            return this.description;
        }

        @Override
        public final java.lang.String getFoundationModel() {
            return this.foundationModel;
        }

        @Override
        public final java.lang.Object getGuardrailConfiguration() {
            return this.guardrailConfiguration;
        }

        @Override
        public final java.lang.Number getIdleSessionTtlInSeconds() {
            return this.idleSessionTtlInSeconds;
        }

        @Override
        public final java.lang.String getInstruction() {
            return this.instruction;
        }

        @Override
        public final java.lang.Object getKnowledgeBases() {
            return this.knowledgeBases;
        }

        @Override
        public final java.lang.Object getPromptOverrideConfiguration() {
            return this.promptOverrideConfiguration;
        }

        @Override
        public final java.lang.Object getSkipResourceInUseCheckOnDelete() {
            return this.skipResourceInUseCheckOnDelete;
        }

        @Override
        public final java.util.Map<java.lang.String, java.lang.String> getTags() {
            return this.tags;
        }

        @Override
        public final java.lang.Object getTestAliasTags() {
            return this.testAliasTags;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("agentName", om.valueToTree(this.getAgentName()));
            if (this.getActionGroups() != null) {
                data.set("actionGroups", om.valueToTree(this.getActionGroups()));
            }
            if (this.getAgentResourceRoleArn() != null) {
                data.set("agentResourceRoleArn", om.valueToTree(this.getAgentResourceRoleArn()));
            }
            if (this.getAutoPrepare() != null) {
                data.set("autoPrepare", om.valueToTree(this.getAutoPrepare()));
            }
            if (this.getCustomerEncryptionKeyArn() != null) {
                data.set("customerEncryptionKeyArn", om.valueToTree(this.getCustomerEncryptionKeyArn()));
            }
            if (this.getDescription() != null) {
                data.set("description", om.valueToTree(this.getDescription()));
            }
            if (this.getFoundationModel() != null) {
                data.set("foundationModel", om.valueToTree(this.getFoundationModel()));
            }
            if (this.getGuardrailConfiguration() != null) {
                data.set("guardrailConfiguration", om.valueToTree(this.getGuardrailConfiguration()));
            }
            if (this.getIdleSessionTtlInSeconds() != null) {
                data.set("idleSessionTtlInSeconds", om.valueToTree(this.getIdleSessionTtlInSeconds()));
            }
            if (this.getInstruction() != null) {
                data.set("instruction", om.valueToTree(this.getInstruction()));
            }
            if (this.getKnowledgeBases() != null) {
                data.set("knowledgeBases", om.valueToTree(this.getKnowledgeBases()));
            }
            if (this.getPromptOverrideConfiguration() != null) {
                data.set("promptOverrideConfiguration", om.valueToTree(this.getPromptOverrideConfiguration()));
            }
            if (this.getSkipResourceInUseCheckOnDelete() != null) {
                data.set("skipResourceInUseCheckOnDelete", om.valueToTree(this.getSkipResourceInUseCheckOnDelete()));
            }
            if (this.getTags() != null) {
                data.set("tags", om.valueToTree(this.getTags()));
            }
            if (this.getTestAliasTags() != null) {
                data.set("testAliasTags", om.valueToTree(this.getTestAliasTags()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_bedrock.CfnAgentProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnAgentProps.Jsii$Proxy that = (CfnAgentProps.Jsii$Proxy) o;

            if (!agentName.equals(that.agentName)) return false;
            if (this.actionGroups != null ? !this.actionGroups.equals(that.actionGroups) : that.actionGroups != null) return false;
            if (this.agentResourceRoleArn != null ? !this.agentResourceRoleArn.equals(that.agentResourceRoleArn) : that.agentResourceRoleArn != null) return false;
            if (this.autoPrepare != null ? !this.autoPrepare.equals(that.autoPrepare) : that.autoPrepare != null) return false;
            if (this.customerEncryptionKeyArn != null ? !this.customerEncryptionKeyArn.equals(that.customerEncryptionKeyArn) : that.customerEncryptionKeyArn != null) return false;
            if (this.description != null ? !this.description.equals(that.description) : that.description != null) return false;
            if (this.foundationModel != null ? !this.foundationModel.equals(that.foundationModel) : that.foundationModel != null) return false;
            if (this.guardrailConfiguration != null ? !this.guardrailConfiguration.equals(that.guardrailConfiguration) : that.guardrailConfiguration != null) return false;
            if (this.idleSessionTtlInSeconds != null ? !this.idleSessionTtlInSeconds.equals(that.idleSessionTtlInSeconds) : that.idleSessionTtlInSeconds != null) return false;
            if (this.instruction != null ? !this.instruction.equals(that.instruction) : that.instruction != null) return false;
            if (this.knowledgeBases != null ? !this.knowledgeBases.equals(that.knowledgeBases) : that.knowledgeBases != null) return false;
            if (this.promptOverrideConfiguration != null ? !this.promptOverrideConfiguration.equals(that.promptOverrideConfiguration) : that.promptOverrideConfiguration != null) return false;
            if (this.skipResourceInUseCheckOnDelete != null ? !this.skipResourceInUseCheckOnDelete.equals(that.skipResourceInUseCheckOnDelete) : that.skipResourceInUseCheckOnDelete != null) return false;
            if (this.tags != null ? !this.tags.equals(that.tags) : that.tags != null) return false;
            return this.testAliasTags != null ? this.testAliasTags.equals(that.testAliasTags) : that.testAliasTags == null;
        }

        @Override
        public final int hashCode() {
            int result = this.agentName.hashCode();
            result = 31 * result + (this.actionGroups != null ? this.actionGroups.hashCode() : 0);
            result = 31 * result + (this.agentResourceRoleArn != null ? this.agentResourceRoleArn.hashCode() : 0);
            result = 31 * result + (this.autoPrepare != null ? this.autoPrepare.hashCode() : 0);
            result = 31 * result + (this.customerEncryptionKeyArn != null ? this.customerEncryptionKeyArn.hashCode() : 0);
            result = 31 * result + (this.description != null ? this.description.hashCode() : 0);
            result = 31 * result + (this.foundationModel != null ? this.foundationModel.hashCode() : 0);
            result = 31 * result + (this.guardrailConfiguration != null ? this.guardrailConfiguration.hashCode() : 0);
            result = 31 * result + (this.idleSessionTtlInSeconds != null ? this.idleSessionTtlInSeconds.hashCode() : 0);
            result = 31 * result + (this.instruction != null ? this.instruction.hashCode() : 0);
            result = 31 * result + (this.knowledgeBases != null ? this.knowledgeBases.hashCode() : 0);
            result = 31 * result + (this.promptOverrideConfiguration != null ? this.promptOverrideConfiguration.hashCode() : 0);
            result = 31 * result + (this.skipResourceInUseCheckOnDelete != null ? this.skipResourceInUseCheckOnDelete.hashCode() : 0);
            result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
            result = 31 * result + (this.testAliasTags != null ? this.testAliasTags.hashCode() : 0);
            return result;
        }
    }
}
