package software.amazon.awscdk.services.bedrock;

/**
 * Creates a prompt flow that you can use to send an input through various steps to yield an output.
 * <p>
 * You define a flow by configuring nodes, each of which corresponds to a step of the flow, and creating connections between the nodes to create paths to different outputs. You can define the flow in one of the following ways:
 * <p>
 * <ul>
 * <li>Define a <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-flow-flowdefinition.html">FlowDefinition</a> in the <code>Definition</code> property.</li>
 * <li>Provide the definition in the <code>DefinitionString</code> property as a JSON-formatted string matching the <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-flow-flowdefinition.html">FlowDefinition</a> property.</li>
 * <li>Provide an Amazon S3 location in the <code>DefinitionS3Location</code> property that matches the <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-flow-flowdefinition.html">FlowDefinition</a> .</li>
 * </ul>
 * <p>
 * If you use the <code>DefinitionString</code> or <code>DefinitionS3Location</code> property, you can use the <code>DefinitionSubstitutions</code> property to define key-value pairs to replace at runtime.
 * <p>
 * For more information, see <a href="https://docs.aws.amazon.com/bedrock/latest/userguide/flows-how-it-works.html">How it works</a> and <a href="https://docs.aws.amazon.com/bedrock/latest/userguide/flows-create.html">Create a prompt flow in Amazon Bedrock</a> in the Amazon Bedrock User Guide.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.bedrock.*;
 * Object collector;
 * Object input;
 * Object iterator;
 * Object output;
 * CfnFlow cfnFlow = CfnFlow.Builder.create(this, "MyCfnFlow")
 *         .executionRoleArn("executionRoleArn")
 *         .name("name")
 *         // the properties below are optional
 *         .customerEncryptionKeyArn("customerEncryptionKeyArn")
 *         .definition(FlowDefinitionProperty.builder()
 *                 .connections(List.of(FlowConnectionProperty.builder()
 *                         .name("name")
 *                         .source("source")
 *                         .target("target")
 *                         .type("type")
 *                         // the properties below are optional
 *                         .configuration(FlowConnectionConfigurationProperty.builder()
 *                                 .conditional(FlowConditionalConnectionConfigurationProperty.builder()
 *                                         .condition("condition")
 *                                         .build())
 *                                 .data(FlowDataConnectionConfigurationProperty.builder()
 *                                         .sourceOutput("sourceOutput")
 *                                         .targetInput("targetInput")
 *                                         .build())
 *                                 .build())
 *                         .build()))
 *                 .nodes(List.of(FlowNodeProperty.builder()
 *                         .name("name")
 *                         .type("type")
 *                         // the properties below are optional
 *                         .configuration(FlowNodeConfigurationProperty.builder()
 *                                 .agent(AgentFlowNodeConfigurationProperty.builder()
 *                                         .agentAliasArn("agentAliasArn")
 *                                         .build())
 *                                 .collector(collector)
 *                                 .condition(ConditionFlowNodeConfigurationProperty.builder()
 *                                         .conditions(List.of(FlowConditionProperty.builder()
 *                                                 .name("name")
 *                                                 // the properties below are optional
 *                                                 .expression("expression")
 *                                                 .build()))
 *                                         .build())
 *                                 .input(input)
 *                                 .iterator(iterator)
 *                                 .knowledgeBase(KnowledgeBaseFlowNodeConfigurationProperty.builder()
 *                                         .knowledgeBaseId("knowledgeBaseId")
 *                                         // the properties below are optional
 *                                         .guardrailConfiguration(GuardrailConfigurationProperty.builder()
 *                                                 .guardrailIdentifier("guardrailIdentifier")
 *                                                 .guardrailVersion("guardrailVersion")
 *                                                 .build())
 *                                         .modelId("modelId")
 *                                         .build())
 *                                 .lambdaFunction(LambdaFunctionFlowNodeConfigurationProperty.builder()
 *                                         .lambdaArn("lambdaArn")
 *                                         .build())
 *                                 .lex(LexFlowNodeConfigurationProperty.builder()
 *                                         .botAliasArn("botAliasArn")
 *                                         .localeId("localeId")
 *                                         .build())
 *                                 .output(output)
 *                                 .prompt(PromptFlowNodeConfigurationProperty.builder()
 *                                         .sourceConfiguration(PromptFlowNodeSourceConfigurationProperty.builder()
 *                                                 .inline(PromptFlowNodeInlineConfigurationProperty.builder()
 *                                                         .modelId("modelId")
 *                                                         .templateConfiguration(PromptTemplateConfigurationProperty.builder()
 *                                                                 .text(TextPromptTemplateConfigurationProperty.builder()
 *                                                                         .text("text")
 *                                                                         // the properties below are optional
 *                                                                         .inputVariables(List.of(PromptInputVariableProperty.builder()
 *                                                                                 .name("name")
 *                                                                                 .build()))
 *                                                                         .build())
 *                                                                 .build())
 *                                                         .templateType("templateType")
 *                                                         // the properties below are optional
 *                                                         .inferenceConfiguration(PromptInferenceConfigurationProperty.builder()
 *                                                                 .text(PromptModelInferenceConfigurationProperty.builder()
 *                                                                         .maxTokens(123)
 *                                                                         .stopSequences(List.of("stopSequences"))
 *                                                                         .temperature(123)
 *                                                                         .topP(123)
 *                                                                         .build())
 *                                                                 .build())
 *                                                         .build())
 *                                                 .resource(PromptFlowNodeResourceConfigurationProperty.builder()
 *                                                         .promptArn("promptArn")
 *                                                         .build())
 *                                                 .build())
 *                                         // the properties below are optional
 *                                         .guardrailConfiguration(GuardrailConfigurationProperty.builder()
 *                                                 .guardrailIdentifier("guardrailIdentifier")
 *                                                 .guardrailVersion("guardrailVersion")
 *                                                 .build())
 *                                         .build())
 *                                 .retrieval(RetrievalFlowNodeConfigurationProperty.builder()
 *                                         .serviceConfiguration(RetrievalFlowNodeServiceConfigurationProperty.builder()
 *                                                 .s3(RetrievalFlowNodeS3ConfigurationProperty.builder()
 *                                                         .bucketName("bucketName")
 *                                                         .build())
 *                                                 .build())
 *                                         .build())
 *                                 .storage(StorageFlowNodeConfigurationProperty.builder()
 *                                         .serviceConfiguration(StorageFlowNodeServiceConfigurationProperty.builder()
 *                                                 .s3(StorageFlowNodeS3ConfigurationProperty.builder()
 *                                                         .bucketName("bucketName")
 *                                                         .build())
 *                                                 .build())
 *                                         .build())
 *                                 .build())
 *                         .inputs(List.of(FlowNodeInputProperty.builder()
 *                                 .expression("expression")
 *                                 .name("name")
 *                                 .type("type")
 *                                 .build()))
 *                         .outputs(List.of(FlowNodeOutputProperty.builder()
 *                                 .name("name")
 *                                 .type("type")
 *                                 .build()))
 *                         .build()))
 *                 .build())
 *         .definitionS3Location(S3LocationProperty.builder()
 *                 .bucket("bucket")
 *                 .key("key")
 *                 // the properties below are optional
 *                 .version("version")
 *                 .build())
 *         .definitionString("definitionString")
 *         .definitionSubstitutions(Map.of(
 *                 "definitionSubstitutionsKey", "definitionSubstitutions"))
 *         .description("description")
 *         .tags(Map.of(
 *                 "tagsKey", "tags"))
 *         .testAliasTags(Map.of(
 *                 "testAliasTagsKey", "testAliasTags"))
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-bedrock-flow.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-bedrock-flow.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.106.0 (build e852934)", date = "2025-02-21T03:20:29.096Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_bedrock.CfnFlow")
public class CfnFlow extends software.amazon.awscdk.CfnResource implements software.amazon.awscdk.IInspectable, software.amazon.awscdk.ITaggableV2 {

    protected CfnFlow(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnFlow(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.bedrock.CfnFlow.class, "CFN_RESOURCE_TYPE_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * @param scope Scope in which this resource is defined. This parameter is required.
     * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
     * @param props Resource properties. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnFlow(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.bedrock.CfnFlowProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * @param inspector tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.TreeInspector inspector) {
        software.amazon.jsii.Kernel.call(this, "inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     * The Amazon Resource Name (ARN) of the flow.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrArn() {
        return software.amazon.jsii.Kernel.get(this, "attrArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The time at which the flow was created.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrCreatedAt() {
        return software.amazon.jsii.Kernel.get(this, "attrCreatedAt", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The unique identifier of the flow.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrId() {
        return software.amazon.jsii.Kernel.get(this, "attrId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The status of the flow. The following statuses are possible:.
     * <p>
     * <ul>
     * <li>NotPrepared – The flow has been created or updated, but hasn't been prepared. If you just created the flow, you can't test it. If you updated the flow, the <code>DRAFT</code> version won't contain the latest changes for testing. Send a <a href="https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent_PrepareFlow.html">PrepareFlow</a> request to package the latest changes into the <code>DRAFT</code> version.</li>
     * <li>Preparing – The flow is being prepared so that the <code>DRAFT</code> version contains the latest changes for testing.</li>
     * <li>Prepared – The flow is prepared and the <code>DRAFT</code> version contains the latest changes for testing.</li>
     * <li>Failed – The last API operation that you invoked on the flow failed. Send a <a href="https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent_GetFlow.html">GetFlow</a> request and check the error message in the <code>validations</code> field.</li>
     * </ul>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrStatus() {
        return software.amazon.jsii.Kernel.get(this, "attrStatus", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The time at which the flow was last updated.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrUpdatedAt() {
        return software.amazon.jsii.Kernel.get(this, "attrUpdatedAt", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * List of flow validations.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.IResolvable getAttrValidations() {
        return software.amazon.jsii.Kernel.get(this, "attrValidations", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.IResolvable.class));
    }

    /**
     * The latest version of the flow.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrVersion() {
        return software.amazon.jsii.Kernel.get(this, "attrVersion", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Tag Manager which manages the tags for this resource.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.TagManager getCdkTagManager() {
        return software.amazon.jsii.Kernel.get(this, "cdkTagManager", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TagManager.class));
    }

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * The Amazon Resource Name (ARN) of the service role with permissions to create a flow.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getExecutionRoleArn() {
        return software.amazon.jsii.Kernel.get(this, "executionRoleArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The Amazon Resource Name (ARN) of the service role with permissions to create a flow.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setExecutionRoleArn(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "executionRoleArn", java.util.Objects.requireNonNull(value, "executionRoleArn is required"));
    }

    /**
     * The name of the flow.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getName() {
        return software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The name of the flow.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setName(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "name", java.util.Objects.requireNonNull(value, "name is required"));
    }

    /**
     * The Amazon Resource Name (ARN) of the KMS key that the flow is encrypted with.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getCustomerEncryptionKeyArn() {
        return software.amazon.jsii.Kernel.get(this, "customerEncryptionKeyArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The Amazon Resource Name (ARN) of the KMS key that the flow is encrypted with.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setCustomerEncryptionKeyArn(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "customerEncryptionKeyArn", value);
    }

    /**
     * The definition of the nodes and connections between the nodes in the flow.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getDefinition() {
        return software.amazon.jsii.Kernel.get(this, "definition", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The definition of the nodes and connections between the nodes in the flow.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDefinition(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "definition", value);
    }

    /**
     * The definition of the nodes and connections between the nodes in the flow.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDefinition(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.bedrock.CfnFlow.FlowDefinitionProperty value) {
        software.amazon.jsii.Kernel.set(this, "definition", value);
    }

    /**
     * The Amazon S3 location of the flow definition.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getDefinitionS3Location() {
        return software.amazon.jsii.Kernel.get(this, "definitionS3Location", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The Amazon S3 location of the flow definition.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDefinitionS3Location(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "definitionS3Location", value);
    }

    /**
     * The Amazon S3 location of the flow definition.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDefinitionS3Location(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.bedrock.CfnFlow.S3LocationProperty value) {
        software.amazon.jsii.Kernel.set(this, "definitionS3Location", value);
    }

    /**
     * The definition of the flow as a JSON-formatted string.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getDefinitionString() {
        return software.amazon.jsii.Kernel.get(this, "definitionString", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The definition of the flow as a JSON-formatted string.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDefinitionString(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "definitionString", value);
    }

    /**
     * A map that specifies the mappings for placeholder variables in the prompt flow definition.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getDefinitionSubstitutions() {
        return software.amazon.jsii.Kernel.get(this, "definitionSubstitutions", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * A map that specifies the mappings for placeholder variables in the prompt flow definition.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDefinitionSubstitutions(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "definitionSubstitutions", value);
    }

    /**
     * A map that specifies the mappings for placeholder variables in the prompt flow definition.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDefinitionSubstitutions(final @org.jetbrains.annotations.Nullable java.util.Map<java.lang.String, java.lang.Object> value) {
        if (software.amazon.jsii.Configuration.getRuntimeTypeChecking()) {
            if (!(value.keySet().toArray()[0] instanceof String)) {
                throw new IllegalArgumentException(
                    new java.lang.StringBuilder("Expected ")
                        .append("value").append(".keySet()")
                        .append(" to contain class String; received ")
                        .append(value.keySet().toArray()[0].getClass()).toString());
            }
            for (final java.util.Map.Entry<String, java.lang.Object> __item_ac66f0: value.entrySet()) {
                final java.lang.Object __val_ac66f0 = __item_ac66f0.getValue();
                if (
                     !(__val_ac66f0 instanceof java.lang.String)
                    && !(__val_ac66f0 instanceof java.lang.Number)
                    && !(__val_ac66f0 instanceof java.lang.Boolean)
                    && !(__val_ac66f0 instanceof software.amazon.awscdk.IResolvable)
                    && !(__val_ac66f0.getClass().equals(software.amazon.jsii.JsiiObject.class))
                ) {
                    throw new IllegalArgumentException(
                        new java.lang.StringBuilder("Expected ")
                            .append("value").append(".get(\"").append((__item_ac66f0.getKey())).append("\")")
                            .append(" to be one of: java.lang.String, java.lang.Number, java.lang.Boolean, software.amazon.awscdk.IResolvable; received ")
                            .append(__val_ac66f0.getClass()).toString());
                }
            }
        }
        software.amazon.jsii.Kernel.set(this, "definitionSubstitutions", value);
    }

    /**
     * A description of the flow.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getDescription() {
        return software.amazon.jsii.Kernel.get(this, "description", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * A description of the flow.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDescription(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "description", value);
    }

    /**
     * Metadata that you can assign to a resource as key-value pairs.
     * <p>
     * For more information, see the following resources:.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.util.Map<java.lang.String, java.lang.String> getTags() {
        return java.util.Optional.ofNullable((java.util.Map<java.lang.String, java.lang.String>)(software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class))))).map(java.util.Collections::unmodifiableMap).orElse(null);
    }

    /**
     * Metadata that you can assign to a resource as key-value pairs.
     * <p>
     * For more information, see the following resources:.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setTags(final @org.jetbrains.annotations.Nullable java.util.Map<java.lang.String, java.lang.String> value) {
        software.amazon.jsii.Kernel.set(this, "tags", value);
    }

    /**
     * A map of tag keys and values.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getTestAliasTags() {
        return software.amazon.jsii.Kernel.get(this, "testAliasTags", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * A map of tag keys and values.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setTestAliasTags(final @org.jetbrains.annotations.Nullable java.util.Map<java.lang.String, java.lang.String> value) {
        software.amazon.jsii.Kernel.set(this, "testAliasTags", value);
    }

    /**
     * A map of tag keys and values.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setTestAliasTags(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "testAliasTags", value);
    }
    /**
     * Defines an agent node in your flow.
     * <p>
     * You specify the agent to invoke at this point in the flow. For more information, see <a href="https://docs.aws.amazon.com/bedrock/latest/userguide/flows-nodes.html">Node types in Amazon Bedrock works</a> in the Amazon Bedrock User Guide.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.bedrock.*;
     * AgentFlowNodeConfigurationProperty agentFlowNodeConfigurationProperty = AgentFlowNodeConfigurationProperty.builder()
     *         .agentAliasArn("agentAliasArn")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-flow-agentflownodeconfiguration.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-flow-agentflownodeconfiguration.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_bedrock.CfnFlow.AgentFlowNodeConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(AgentFlowNodeConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface AgentFlowNodeConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The Amazon Resource Name (ARN) of the alias of the agent to invoke.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-flow-agentflownodeconfiguration.html#cfn-bedrock-flow-agentflownodeconfiguration-agentaliasarn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-flow-agentflownodeconfiguration.html#cfn-bedrock-flow-agentflownodeconfiguration-agentaliasarn</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getAgentAliasArn();

        /**
         * @return a {@link Builder} of {@link AgentFlowNodeConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link AgentFlowNodeConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<AgentFlowNodeConfigurationProperty> {
            java.lang.String agentAliasArn;

            /**
             * Sets the value of {@link AgentFlowNodeConfigurationProperty#getAgentAliasArn}
             * @param agentAliasArn The Amazon Resource Name (ARN) of the alias of the agent to invoke. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder agentAliasArn(java.lang.String agentAliasArn) {
                this.agentAliasArn = agentAliasArn;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link AgentFlowNodeConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public AgentFlowNodeConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link AgentFlowNodeConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements AgentFlowNodeConfigurationProperty {
            private final java.lang.String agentAliasArn;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.agentAliasArn = software.amazon.jsii.Kernel.get(this, "agentAliasArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.agentAliasArn = java.util.Objects.requireNonNull(builder.agentAliasArn, "agentAliasArn is required");
            }

            @Override
            public final java.lang.String getAgentAliasArn() {
                return this.agentAliasArn;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("agentAliasArn", om.valueToTree(this.getAgentAliasArn()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_bedrock.CfnFlow.AgentFlowNodeConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                AgentFlowNodeConfigurationProperty.Jsii$Proxy that = (AgentFlowNodeConfigurationProperty.Jsii$Proxy) o;

                return this.agentAliasArn.equals(that.agentAliasArn);
            }

            @Override
            public final int hashCode() {
                int result = this.agentAliasArn.hashCode();
                return result;
            }
        }
    }
    /**
     * Defines a condition node in your flow.
     * <p>
     * You can specify conditions that determine which node comes next in the flow. For more information, see <a href="https://docs.aws.amazon.com/bedrock/latest/userguide/flows-nodes.html">Node types in Amazon Bedrock works</a> in the Amazon Bedrock User Guide.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.bedrock.*;
     * ConditionFlowNodeConfigurationProperty conditionFlowNodeConfigurationProperty = ConditionFlowNodeConfigurationProperty.builder()
     *         .conditions(List.of(FlowConditionProperty.builder()
     *                 .name("name")
     *                 // the properties below are optional
     *                 .expression("expression")
     *                 .build()))
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-flow-conditionflownodeconfiguration.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-flow-conditionflownodeconfiguration.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_bedrock.CfnFlow.ConditionFlowNodeConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(ConditionFlowNodeConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ConditionFlowNodeConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * An array of conditions.
         * <p>
         * Each member contains the name of a condition and an expression that defines the condition.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-flow-conditionflownodeconfiguration.html#cfn-bedrock-flow-conditionflownodeconfiguration-conditions">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-flow-conditionflownodeconfiguration.html#cfn-bedrock-flow-conditionflownodeconfiguration-conditions</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getConditions();

        /**
         * @return a {@link Builder} of {@link ConditionFlowNodeConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ConditionFlowNodeConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ConditionFlowNodeConfigurationProperty> {
            java.lang.Object conditions;

            /**
             * Sets the value of {@link ConditionFlowNodeConfigurationProperty#getConditions}
             * @param conditions An array of conditions. This parameter is required.
             *                   Each member contains the name of a condition and an expression that defines the condition.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder conditions(software.amazon.awscdk.IResolvable conditions) {
                this.conditions = conditions;
                return this;
            }

            /**
             * Sets the value of {@link ConditionFlowNodeConfigurationProperty#getConditions}
             * @param conditions An array of conditions. This parameter is required.
             *                   Each member contains the name of a condition and an expression that defines the condition.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder conditions(java.util.List<? extends java.lang.Object> conditions) {
                this.conditions = conditions;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ConditionFlowNodeConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ConditionFlowNodeConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ConditionFlowNodeConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ConditionFlowNodeConfigurationProperty {
            private final java.lang.Object conditions;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.conditions = software.amazon.jsii.Kernel.get(this, "conditions", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.conditions = java.util.Objects.requireNonNull(builder.conditions, "conditions is required");
            }

            @Override
            public final java.lang.Object getConditions() {
                return this.conditions;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("conditions", om.valueToTree(this.getConditions()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_bedrock.CfnFlow.ConditionFlowNodeConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ConditionFlowNodeConfigurationProperty.Jsii$Proxy that = (ConditionFlowNodeConfigurationProperty.Jsii$Proxy) o;

                return this.conditions.equals(that.conditions);
            }

            @Override
            public final int hashCode() {
                int result = this.conditions.hashCode();
                return result;
            }
        }
    }
    /**
     * Defines a condition in the condition node.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.bedrock.*;
     * FlowConditionProperty flowConditionProperty = FlowConditionProperty.builder()
     *         .name("name")
     *         // the properties below are optional
     *         .expression("expression")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-flow-flowcondition.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-flow-flowcondition.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_bedrock.CfnFlow.FlowConditionProperty")
    @software.amazon.jsii.Jsii.Proxy(FlowConditionProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface FlowConditionProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * A name for the condition that you can reference.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-flow-flowcondition.html#cfn-bedrock-flow-flowcondition-name">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-flow-flowcondition.html#cfn-bedrock-flow-flowcondition-name</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getName();

        /**
         * Defines the condition.
         * <p>
         * You must refer to at least one of the inputs in the condition. For more information, expand the Condition node section in <a href="https://docs.aws.amazon.com/bedrock/latest/userguide/flows-how-it-works.html#flows-nodes">Node types in prompt flows</a> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-flow-flowcondition.html#cfn-bedrock-flow-flowcondition-expression">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-flow-flowcondition.html#cfn-bedrock-flow-flowcondition-expression</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getExpression() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link FlowConditionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link FlowConditionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<FlowConditionProperty> {
            java.lang.String name;
            java.lang.String expression;

            /**
             * Sets the value of {@link FlowConditionProperty#getName}
             * @param name A name for the condition that you can reference. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder name(java.lang.String name) {
                this.name = name;
                return this;
            }

            /**
             * Sets the value of {@link FlowConditionProperty#getExpression}
             * @param expression Defines the condition.
             *                   You must refer to at least one of the inputs in the condition. For more information, expand the Condition node section in <a href="https://docs.aws.amazon.com/bedrock/latest/userguide/flows-how-it-works.html#flows-nodes">Node types in prompt flows</a> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder expression(java.lang.String expression) {
                this.expression = expression;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link FlowConditionProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public FlowConditionProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link FlowConditionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements FlowConditionProperty {
            private final java.lang.String name;
            private final java.lang.String expression;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.expression = software.amazon.jsii.Kernel.get(this, "expression", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.name = java.util.Objects.requireNonNull(builder.name, "name is required");
                this.expression = builder.expression;
            }

            @Override
            public final java.lang.String getName() {
                return this.name;
            }

            @Override
            public final java.lang.String getExpression() {
                return this.expression;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("name", om.valueToTree(this.getName()));
                if (this.getExpression() != null) {
                    data.set("expression", om.valueToTree(this.getExpression()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_bedrock.CfnFlow.FlowConditionProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                FlowConditionProperty.Jsii$Proxy that = (FlowConditionProperty.Jsii$Proxy) o;

                if (!name.equals(that.name)) return false;
                return this.expression != null ? this.expression.equals(that.expression) : that.expression == null;
            }

            @Override
            public final int hashCode() {
                int result = this.name.hashCode();
                result = 31 * result + (this.expression != null ? this.expression.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The configuration of a connection between a condition node and another node.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.bedrock.*;
     * FlowConditionalConnectionConfigurationProperty flowConditionalConnectionConfigurationProperty = FlowConditionalConnectionConfigurationProperty.builder()
     *         .condition("condition")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-flow-flowconditionalconnectionconfiguration.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-flow-flowconditionalconnectionconfiguration.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_bedrock.CfnFlow.FlowConditionalConnectionConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(FlowConditionalConnectionConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface FlowConditionalConnectionConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The condition that triggers this connection.
         * <p>
         * For more information about how to write conditions, see the <em>Condition</em> node type in the <a href="https://docs.aws.amazon.com/bedrock/latest/userguide/node-types.html">Node types</a> topic in the Amazon Bedrock User Guide.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-flow-flowconditionalconnectionconfiguration.html#cfn-bedrock-flow-flowconditionalconnectionconfiguration-condition">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-flow-flowconditionalconnectionconfiguration.html#cfn-bedrock-flow-flowconditionalconnectionconfiguration-condition</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getCondition();

        /**
         * @return a {@link Builder} of {@link FlowConditionalConnectionConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link FlowConditionalConnectionConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<FlowConditionalConnectionConfigurationProperty> {
            java.lang.String condition;

            /**
             * Sets the value of {@link FlowConditionalConnectionConfigurationProperty#getCondition}
             * @param condition The condition that triggers this connection. This parameter is required.
             *                  For more information about how to write conditions, see the <em>Condition</em> node type in the <a href="https://docs.aws.amazon.com/bedrock/latest/userguide/node-types.html">Node types</a> topic in the Amazon Bedrock User Guide.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder condition(java.lang.String condition) {
                this.condition = condition;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link FlowConditionalConnectionConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public FlowConditionalConnectionConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link FlowConditionalConnectionConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements FlowConditionalConnectionConfigurationProperty {
            private final java.lang.String condition;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.condition = software.amazon.jsii.Kernel.get(this, "condition", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.condition = java.util.Objects.requireNonNull(builder.condition, "condition is required");
            }

            @Override
            public final java.lang.String getCondition() {
                return this.condition;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("condition", om.valueToTree(this.getCondition()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_bedrock.CfnFlow.FlowConditionalConnectionConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                FlowConditionalConnectionConfigurationProperty.Jsii$Proxy that = (FlowConditionalConnectionConfigurationProperty.Jsii$Proxy) o;

                return this.condition.equals(that.condition);
            }

            @Override
            public final int hashCode() {
                int result = this.condition.hashCode();
                return result;
            }
        }
    }
    /**
     * The configuration of the connection.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.bedrock.*;
     * FlowConnectionConfigurationProperty flowConnectionConfigurationProperty = FlowConnectionConfigurationProperty.builder()
     *         .conditional(FlowConditionalConnectionConfigurationProperty.builder()
     *                 .condition("condition")
     *                 .build())
     *         .data(FlowDataConnectionConfigurationProperty.builder()
     *                 .sourceOutput("sourceOutput")
     *                 .targetInput("targetInput")
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-flow-flowconnectionconfiguration.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-flow-flowconnectionconfiguration.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_bedrock.CfnFlow.FlowConnectionConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(FlowConnectionConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface FlowConnectionConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The configuration of a connection originating from a Condition node.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-flow-flowconnectionconfiguration.html#cfn-bedrock-flow-flowconnectionconfiguration-conditional">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-flow-flowconnectionconfiguration.html#cfn-bedrock-flow-flowconnectionconfiguration-conditional</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getConditional() {
            return null;
        }

        /**
         * The configuration of a connection originating from a node that isn't a Condition node.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-flow-flowconnectionconfiguration.html#cfn-bedrock-flow-flowconnectionconfiguration-data">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-flow-flowconnectionconfiguration.html#cfn-bedrock-flow-flowconnectionconfiguration-data</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getData() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link FlowConnectionConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link FlowConnectionConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<FlowConnectionConfigurationProperty> {
            java.lang.Object conditional;
            java.lang.Object data;

            /**
             * Sets the value of {@link FlowConnectionConfigurationProperty#getConditional}
             * @param conditional The configuration of a connection originating from a Condition node.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder conditional(software.amazon.awscdk.IResolvable conditional) {
                this.conditional = conditional;
                return this;
            }

            /**
             * Sets the value of {@link FlowConnectionConfigurationProperty#getConditional}
             * @param conditional The configuration of a connection originating from a Condition node.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder conditional(software.amazon.awscdk.services.bedrock.CfnFlow.FlowConditionalConnectionConfigurationProperty conditional) {
                this.conditional = conditional;
                return this;
            }

            /**
             * Sets the value of {@link FlowConnectionConfigurationProperty#getData}
             * @param data The configuration of a connection originating from a node that isn't a Condition node.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder data(software.amazon.awscdk.IResolvable data) {
                this.data = data;
                return this;
            }

            /**
             * Sets the value of {@link FlowConnectionConfigurationProperty#getData}
             * @param data The configuration of a connection originating from a node that isn't a Condition node.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder data(software.amazon.awscdk.services.bedrock.CfnFlow.FlowDataConnectionConfigurationProperty data) {
                this.data = data;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link FlowConnectionConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public FlowConnectionConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link FlowConnectionConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements FlowConnectionConfigurationProperty {
            private final java.lang.Object conditional;
            private final java.lang.Object data;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.conditional = software.amazon.jsii.Kernel.get(this, "conditional", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.data = software.amazon.jsii.Kernel.get(this, "data", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.conditional = builder.conditional;
                this.data = builder.data;
            }

            @Override
            public final java.lang.Object getConditional() {
                return this.conditional;
            }

            @Override
            public final java.lang.Object getData() {
                return this.data;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getConditional() != null) {
                    data.set("conditional", om.valueToTree(this.getConditional()));
                }
                if (this.getData() != null) {
                    data.set("data", om.valueToTree(this.getData()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_bedrock.CfnFlow.FlowConnectionConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                FlowConnectionConfigurationProperty.Jsii$Proxy that = (FlowConnectionConfigurationProperty.Jsii$Proxy) o;

                if (this.conditional != null ? !this.conditional.equals(that.conditional) : that.conditional != null) return false;
                return this.data != null ? this.data.equals(that.data) : that.data == null;
            }

            @Override
            public final int hashCode() {
                int result = this.conditional != null ? this.conditional.hashCode() : 0;
                result = 31 * result + (this.data != null ? this.data.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Contains information about a connection between two nodes in the flow.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.bedrock.*;
     * FlowConnectionProperty flowConnectionProperty = FlowConnectionProperty.builder()
     *         .name("name")
     *         .source("source")
     *         .target("target")
     *         .type("type")
     *         // the properties below are optional
     *         .configuration(FlowConnectionConfigurationProperty.builder()
     *                 .conditional(FlowConditionalConnectionConfigurationProperty.builder()
     *                         .condition("condition")
     *                         .build())
     *                 .data(FlowDataConnectionConfigurationProperty.builder()
     *                         .sourceOutput("sourceOutput")
     *                         .targetInput("targetInput")
     *                         .build())
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-flow-flowconnection.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-flow-flowconnection.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_bedrock.CfnFlow.FlowConnectionProperty")
    @software.amazon.jsii.Jsii.Proxy(FlowConnectionProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface FlowConnectionProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * A name for the connection that you can reference.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-flow-flowconnection.html#cfn-bedrock-flow-flowconnection-name">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-flow-flowconnection.html#cfn-bedrock-flow-flowconnection-name</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getName();

        /**
         * The node that the connection starts at.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-flow-flowconnection.html#cfn-bedrock-flow-flowconnection-source">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-flow-flowconnection.html#cfn-bedrock-flow-flowconnection-source</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getSource();

        /**
         * The node that the connection ends at.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-flow-flowconnection.html#cfn-bedrock-flow-flowconnection-target">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-flow-flowconnection.html#cfn-bedrock-flow-flowconnection-target</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getTarget();

        /**
         * Whether the source node that the connection begins from is a condition node ( <code>Conditional</code> ) or not ( <code>Data</code> ).
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-flow-flowconnection.html#cfn-bedrock-flow-flowconnection-type">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-flow-flowconnection.html#cfn-bedrock-flow-flowconnection-type</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getType();

        /**
         * The configuration of the connection.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-flow-flowconnection.html#cfn-bedrock-flow-flowconnection-configuration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-flow-flowconnection.html#cfn-bedrock-flow-flowconnection-configuration</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getConfiguration() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link FlowConnectionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link FlowConnectionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<FlowConnectionProperty> {
            java.lang.String name;
            java.lang.String source;
            java.lang.String target;
            java.lang.String type;
            java.lang.Object configuration;

            /**
             * Sets the value of {@link FlowConnectionProperty#getName}
             * @param name A name for the connection that you can reference. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder name(java.lang.String name) {
                this.name = name;
                return this;
            }

            /**
             * Sets the value of {@link FlowConnectionProperty#getSource}
             * @param source The node that the connection starts at. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder source(java.lang.String source) {
                this.source = source;
                return this;
            }

            /**
             * Sets the value of {@link FlowConnectionProperty#getTarget}
             * @param target The node that the connection ends at. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder target(java.lang.String target) {
                this.target = target;
                return this;
            }

            /**
             * Sets the value of {@link FlowConnectionProperty#getType}
             * @param type Whether the source node that the connection begins from is a condition node ( <code>Conditional</code> ) or not ( <code>Data</code> ). This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder type(java.lang.String type) {
                this.type = type;
                return this;
            }

            /**
             * Sets the value of {@link FlowConnectionProperty#getConfiguration}
             * @param configuration The configuration of the connection.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder configuration(software.amazon.awscdk.IResolvable configuration) {
                this.configuration = configuration;
                return this;
            }

            /**
             * Sets the value of {@link FlowConnectionProperty#getConfiguration}
             * @param configuration The configuration of the connection.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder configuration(software.amazon.awscdk.services.bedrock.CfnFlow.FlowConnectionConfigurationProperty configuration) {
                this.configuration = configuration;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link FlowConnectionProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public FlowConnectionProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link FlowConnectionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements FlowConnectionProperty {
            private final java.lang.String name;
            private final java.lang.String source;
            private final java.lang.String target;
            private final java.lang.String type;
            private final java.lang.Object configuration;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.source = software.amazon.jsii.Kernel.get(this, "source", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.target = software.amazon.jsii.Kernel.get(this, "target", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.type = software.amazon.jsii.Kernel.get(this, "type", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.configuration = software.amazon.jsii.Kernel.get(this, "configuration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.name = java.util.Objects.requireNonNull(builder.name, "name is required");
                this.source = java.util.Objects.requireNonNull(builder.source, "source is required");
                this.target = java.util.Objects.requireNonNull(builder.target, "target is required");
                this.type = java.util.Objects.requireNonNull(builder.type, "type is required");
                this.configuration = builder.configuration;
            }

            @Override
            public final java.lang.String getName() {
                return this.name;
            }

            @Override
            public final java.lang.String getSource() {
                return this.source;
            }

            @Override
            public final java.lang.String getTarget() {
                return this.target;
            }

            @Override
            public final java.lang.String getType() {
                return this.type;
            }

            @Override
            public final java.lang.Object getConfiguration() {
                return this.configuration;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("name", om.valueToTree(this.getName()));
                data.set("source", om.valueToTree(this.getSource()));
                data.set("target", om.valueToTree(this.getTarget()));
                data.set("type", om.valueToTree(this.getType()));
                if (this.getConfiguration() != null) {
                    data.set("configuration", om.valueToTree(this.getConfiguration()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_bedrock.CfnFlow.FlowConnectionProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                FlowConnectionProperty.Jsii$Proxy that = (FlowConnectionProperty.Jsii$Proxy) o;

                if (!name.equals(that.name)) return false;
                if (!source.equals(that.source)) return false;
                if (!target.equals(that.target)) return false;
                if (!type.equals(that.type)) return false;
                return this.configuration != null ? this.configuration.equals(that.configuration) : that.configuration == null;
            }

            @Override
            public final int hashCode() {
                int result = this.name.hashCode();
                result = 31 * result + (this.source.hashCode());
                result = 31 * result + (this.target.hashCode());
                result = 31 * result + (this.type.hashCode());
                result = 31 * result + (this.configuration != null ? this.configuration.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * The configuration of a connection originating from a node that isn't a Condition node.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.bedrock.*;
     * FlowDataConnectionConfigurationProperty flowDataConnectionConfigurationProperty = FlowDataConnectionConfigurationProperty.builder()
     *         .sourceOutput("sourceOutput")
     *         .targetInput("targetInput")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-flow-flowdataconnectionconfiguration.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-flow-flowdataconnectionconfiguration.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_bedrock.CfnFlow.FlowDataConnectionConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(FlowDataConnectionConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface FlowDataConnectionConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The name of the output in the source node that the connection begins from.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-flow-flowdataconnectionconfiguration.html#cfn-bedrock-flow-flowdataconnectionconfiguration-sourceoutput">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-flow-flowdataconnectionconfiguration.html#cfn-bedrock-flow-flowdataconnectionconfiguration-sourceoutput</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getSourceOutput();

        /**
         * The name of the input in the target node that the connection ends at.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-flow-flowdataconnectionconfiguration.html#cfn-bedrock-flow-flowdataconnectionconfiguration-targetinput">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-flow-flowdataconnectionconfiguration.html#cfn-bedrock-flow-flowdataconnectionconfiguration-targetinput</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getTargetInput();

        /**
         * @return a {@link Builder} of {@link FlowDataConnectionConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link FlowDataConnectionConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<FlowDataConnectionConfigurationProperty> {
            java.lang.String sourceOutput;
            java.lang.String targetInput;

            /**
             * Sets the value of {@link FlowDataConnectionConfigurationProperty#getSourceOutput}
             * @param sourceOutput The name of the output in the source node that the connection begins from. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder sourceOutput(java.lang.String sourceOutput) {
                this.sourceOutput = sourceOutput;
                return this;
            }

            /**
             * Sets the value of {@link FlowDataConnectionConfigurationProperty#getTargetInput}
             * @param targetInput The name of the input in the target node that the connection ends at. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder targetInput(java.lang.String targetInput) {
                this.targetInput = targetInput;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link FlowDataConnectionConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public FlowDataConnectionConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link FlowDataConnectionConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements FlowDataConnectionConfigurationProperty {
            private final java.lang.String sourceOutput;
            private final java.lang.String targetInput;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.sourceOutput = software.amazon.jsii.Kernel.get(this, "sourceOutput", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.targetInput = software.amazon.jsii.Kernel.get(this, "targetInput", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.sourceOutput = java.util.Objects.requireNonNull(builder.sourceOutput, "sourceOutput is required");
                this.targetInput = java.util.Objects.requireNonNull(builder.targetInput, "targetInput is required");
            }

            @Override
            public final java.lang.String getSourceOutput() {
                return this.sourceOutput;
            }

            @Override
            public final java.lang.String getTargetInput() {
                return this.targetInput;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("sourceOutput", om.valueToTree(this.getSourceOutput()));
                data.set("targetInput", om.valueToTree(this.getTargetInput()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_bedrock.CfnFlow.FlowDataConnectionConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                FlowDataConnectionConfigurationProperty.Jsii$Proxy that = (FlowDataConnectionConfigurationProperty.Jsii$Proxy) o;

                if (!sourceOutput.equals(that.sourceOutput)) return false;
                return this.targetInput.equals(that.targetInput);
            }

            @Override
            public final int hashCode() {
                int result = this.sourceOutput.hashCode();
                result = 31 * result + (this.targetInput.hashCode());
                return result;
            }
        }
    }
    /**
     * The definition of the nodes and connections between nodes in the flow.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.bedrock.*;
     * Object collector;
     * Object input;
     * Object iterator;
     * Object output;
     * FlowDefinitionProperty flowDefinitionProperty = FlowDefinitionProperty.builder()
     *         .connections(List.of(FlowConnectionProperty.builder()
     *                 .name("name")
     *                 .source("source")
     *                 .target("target")
     *                 .type("type")
     *                 // the properties below are optional
     *                 .configuration(FlowConnectionConfigurationProperty.builder()
     *                         .conditional(FlowConditionalConnectionConfigurationProperty.builder()
     *                                 .condition("condition")
     *                                 .build())
     *                         .data(FlowDataConnectionConfigurationProperty.builder()
     *                                 .sourceOutput("sourceOutput")
     *                                 .targetInput("targetInput")
     *                                 .build())
     *                         .build())
     *                 .build()))
     *         .nodes(List.of(FlowNodeProperty.builder()
     *                 .name("name")
     *                 .type("type")
     *                 // the properties below are optional
     *                 .configuration(FlowNodeConfigurationProperty.builder()
     *                         .agent(AgentFlowNodeConfigurationProperty.builder()
     *                                 .agentAliasArn("agentAliasArn")
     *                                 .build())
     *                         .collector(collector)
     *                         .condition(ConditionFlowNodeConfigurationProperty.builder()
     *                                 .conditions(List.of(FlowConditionProperty.builder()
     *                                         .name("name")
     *                                         // the properties below are optional
     *                                         .expression("expression")
     *                                         .build()))
     *                                 .build())
     *                         .input(input)
     *                         .iterator(iterator)
     *                         .knowledgeBase(KnowledgeBaseFlowNodeConfigurationProperty.builder()
     *                                 .knowledgeBaseId("knowledgeBaseId")
     *                                 // the properties below are optional
     *                                 .guardrailConfiguration(GuardrailConfigurationProperty.builder()
     *                                         .guardrailIdentifier("guardrailIdentifier")
     *                                         .guardrailVersion("guardrailVersion")
     *                                         .build())
     *                                 .modelId("modelId")
     *                                 .build())
     *                         .lambdaFunction(LambdaFunctionFlowNodeConfigurationProperty.builder()
     *                                 .lambdaArn("lambdaArn")
     *                                 .build())
     *                         .lex(LexFlowNodeConfigurationProperty.builder()
     *                                 .botAliasArn("botAliasArn")
     *                                 .localeId("localeId")
     *                                 .build())
     *                         .output(output)
     *                         .prompt(PromptFlowNodeConfigurationProperty.builder()
     *                                 .sourceConfiguration(PromptFlowNodeSourceConfigurationProperty.builder()
     *                                         .inline(PromptFlowNodeInlineConfigurationProperty.builder()
     *                                                 .modelId("modelId")
     *                                                 .templateConfiguration(PromptTemplateConfigurationProperty.builder()
     *                                                         .text(TextPromptTemplateConfigurationProperty.builder()
     *                                                                 .text("text")
     *                                                                 // the properties below are optional
     *                                                                 .inputVariables(List.of(PromptInputVariableProperty.builder()
     *                                                                         .name("name")
     *                                                                         .build()))
     *                                                                 .build())
     *                                                         .build())
     *                                                 .templateType("templateType")
     *                                                 // the properties below are optional
     *                                                 .inferenceConfiguration(PromptInferenceConfigurationProperty.builder()
     *                                                         .text(PromptModelInferenceConfigurationProperty.builder()
     *                                                                 .maxTokens(123)
     *                                                                 .stopSequences(List.of("stopSequences"))
     *                                                                 .temperature(123)
     *                                                                 .topP(123)
     *                                                                 .build())
     *                                                         .build())
     *                                                 .build())
     *                                         .resource(PromptFlowNodeResourceConfigurationProperty.builder()
     *                                                 .promptArn("promptArn")
     *                                                 .build())
     *                                         .build())
     *                                 // the properties below are optional
     *                                 .guardrailConfiguration(GuardrailConfigurationProperty.builder()
     *                                         .guardrailIdentifier("guardrailIdentifier")
     *                                         .guardrailVersion("guardrailVersion")
     *                                         .build())
     *                                 .build())
     *                         .retrieval(RetrievalFlowNodeConfigurationProperty.builder()
     *                                 .serviceConfiguration(RetrievalFlowNodeServiceConfigurationProperty.builder()
     *                                         .s3(RetrievalFlowNodeS3ConfigurationProperty.builder()
     *                                                 .bucketName("bucketName")
     *                                                 .build())
     *                                         .build())
     *                                 .build())
     *                         .storage(StorageFlowNodeConfigurationProperty.builder()
     *                                 .serviceConfiguration(StorageFlowNodeServiceConfigurationProperty.builder()
     *                                         .s3(StorageFlowNodeS3ConfigurationProperty.builder()
     *                                                 .bucketName("bucketName")
     *                                                 .build())
     *                                         .build())
     *                                 .build())
     *                         .build())
     *                 .inputs(List.of(FlowNodeInputProperty.builder()
     *                         .expression("expression")
     *                         .name("name")
     *                         .type("type")
     *                         .build()))
     *                 .outputs(List.of(FlowNodeOutputProperty.builder()
     *                         .name("name")
     *                         .type("type")
     *                         .build()))
     *                 .build()))
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-flow-flowdefinition.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-flow-flowdefinition.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_bedrock.CfnFlow.FlowDefinitionProperty")
    @software.amazon.jsii.Jsii.Proxy(FlowDefinitionProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface FlowDefinitionProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * An array of connection definitions in the flow.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-flow-flowdefinition.html#cfn-bedrock-flow-flowdefinition-connections">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-flow-flowdefinition.html#cfn-bedrock-flow-flowdefinition-connections</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getConnections() {
            return null;
        }

        /**
         * An array of node definitions in the flow.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-flow-flowdefinition.html#cfn-bedrock-flow-flowdefinition-nodes">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-flow-flowdefinition.html#cfn-bedrock-flow-flowdefinition-nodes</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getNodes() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link FlowDefinitionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link FlowDefinitionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<FlowDefinitionProperty> {
            java.lang.Object connections;
            java.lang.Object nodes;

            /**
             * Sets the value of {@link FlowDefinitionProperty#getConnections}
             * @param connections An array of connection definitions in the flow.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder connections(software.amazon.awscdk.IResolvable connections) {
                this.connections = connections;
                return this;
            }

            /**
             * Sets the value of {@link FlowDefinitionProperty#getConnections}
             * @param connections An array of connection definitions in the flow.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder connections(java.util.List<? extends java.lang.Object> connections) {
                this.connections = connections;
                return this;
            }

            /**
             * Sets the value of {@link FlowDefinitionProperty#getNodes}
             * @param nodes An array of node definitions in the flow.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder nodes(software.amazon.awscdk.IResolvable nodes) {
                this.nodes = nodes;
                return this;
            }

            /**
             * Sets the value of {@link FlowDefinitionProperty#getNodes}
             * @param nodes An array of node definitions in the flow.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder nodes(java.util.List<? extends java.lang.Object> nodes) {
                this.nodes = nodes;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link FlowDefinitionProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public FlowDefinitionProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link FlowDefinitionProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements FlowDefinitionProperty {
            private final java.lang.Object connections;
            private final java.lang.Object nodes;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.connections = software.amazon.jsii.Kernel.get(this, "connections", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.nodes = software.amazon.jsii.Kernel.get(this, "nodes", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.connections = builder.connections;
                this.nodes = builder.nodes;
            }

            @Override
            public final java.lang.Object getConnections() {
                return this.connections;
            }

            @Override
            public final java.lang.Object getNodes() {
                return this.nodes;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getConnections() != null) {
                    data.set("connections", om.valueToTree(this.getConnections()));
                }
                if (this.getNodes() != null) {
                    data.set("nodes", om.valueToTree(this.getNodes()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_bedrock.CfnFlow.FlowDefinitionProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                FlowDefinitionProperty.Jsii$Proxy that = (FlowDefinitionProperty.Jsii$Proxy) o;

                if (this.connections != null ? !this.connections.equals(that.connections) : that.connections != null) return false;
                return this.nodes != null ? this.nodes.equals(that.nodes) : that.nodes == null;
            }

            @Override
            public final int hashCode() {
                int result = this.connections != null ? this.connections.hashCode() : 0;
                result = 31 * result + (this.nodes != null ? this.nodes.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Contains configurations for a node in your flow.
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/bedrock/latest/userguide/flows-nodes.html">Node types in Amazon Bedrock works</a> in the Amazon Bedrock User Guide.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.bedrock.*;
     * Object collector;
     * Object input;
     * Object iterator;
     * Object output;
     * FlowNodeConfigurationProperty flowNodeConfigurationProperty = FlowNodeConfigurationProperty.builder()
     *         .agent(AgentFlowNodeConfigurationProperty.builder()
     *                 .agentAliasArn("agentAliasArn")
     *                 .build())
     *         .collector(collector)
     *         .condition(ConditionFlowNodeConfigurationProperty.builder()
     *                 .conditions(List.of(FlowConditionProperty.builder()
     *                         .name("name")
     *                         // the properties below are optional
     *                         .expression("expression")
     *                         .build()))
     *                 .build())
     *         .input(input)
     *         .iterator(iterator)
     *         .knowledgeBase(KnowledgeBaseFlowNodeConfigurationProperty.builder()
     *                 .knowledgeBaseId("knowledgeBaseId")
     *                 // the properties below are optional
     *                 .guardrailConfiguration(GuardrailConfigurationProperty.builder()
     *                         .guardrailIdentifier("guardrailIdentifier")
     *                         .guardrailVersion("guardrailVersion")
     *                         .build())
     *                 .modelId("modelId")
     *                 .build())
     *         .lambdaFunction(LambdaFunctionFlowNodeConfigurationProperty.builder()
     *                 .lambdaArn("lambdaArn")
     *                 .build())
     *         .lex(LexFlowNodeConfigurationProperty.builder()
     *                 .botAliasArn("botAliasArn")
     *                 .localeId("localeId")
     *                 .build())
     *         .output(output)
     *         .prompt(PromptFlowNodeConfigurationProperty.builder()
     *                 .sourceConfiguration(PromptFlowNodeSourceConfigurationProperty.builder()
     *                         .inline(PromptFlowNodeInlineConfigurationProperty.builder()
     *                                 .modelId("modelId")
     *                                 .templateConfiguration(PromptTemplateConfigurationProperty.builder()
     *                                         .text(TextPromptTemplateConfigurationProperty.builder()
     *                                                 .text("text")
     *                                                 // the properties below are optional
     *                                                 .inputVariables(List.of(PromptInputVariableProperty.builder()
     *                                                         .name("name")
     *                                                         .build()))
     *                                                 .build())
     *                                         .build())
     *                                 .templateType("templateType")
     *                                 // the properties below are optional
     *                                 .inferenceConfiguration(PromptInferenceConfigurationProperty.builder()
     *                                         .text(PromptModelInferenceConfigurationProperty.builder()
     *                                                 .maxTokens(123)
     *                                                 .stopSequences(List.of("stopSequences"))
     *                                                 .temperature(123)
     *                                                 .topP(123)
     *                                                 .build())
     *                                         .build())
     *                                 .build())
     *                         .resource(PromptFlowNodeResourceConfigurationProperty.builder()
     *                                 .promptArn("promptArn")
     *                                 .build())
     *                         .build())
     *                 // the properties below are optional
     *                 .guardrailConfiguration(GuardrailConfigurationProperty.builder()
     *                         .guardrailIdentifier("guardrailIdentifier")
     *                         .guardrailVersion("guardrailVersion")
     *                         .build())
     *                 .build())
     *         .retrieval(RetrievalFlowNodeConfigurationProperty.builder()
     *                 .serviceConfiguration(RetrievalFlowNodeServiceConfigurationProperty.builder()
     *                         .s3(RetrievalFlowNodeS3ConfigurationProperty.builder()
     *                                 .bucketName("bucketName")
     *                                 .build())
     *                         .build())
     *                 .build())
     *         .storage(StorageFlowNodeConfigurationProperty.builder()
     *                 .serviceConfiguration(StorageFlowNodeServiceConfigurationProperty.builder()
     *                         .s3(StorageFlowNodeS3ConfigurationProperty.builder()
     *                                 .bucketName("bucketName")
     *                                 .build())
     *                         .build())
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-flow-flownodeconfiguration.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-flow-flownodeconfiguration.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_bedrock.CfnFlow.FlowNodeConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(FlowNodeConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface FlowNodeConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Contains configurations for an agent node in your flow.
         * <p>
         * Invokes an alias of an agent and returns the response.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-flow-flownodeconfiguration.html#cfn-bedrock-flow-flownodeconfiguration-agent">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-flow-flownodeconfiguration.html#cfn-bedrock-flow-flownodeconfiguration-agent</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getAgent() {
            return null;
        }

        /**
         * Contains configurations for a collector node in your flow.
         * <p>
         * Collects an iteration of inputs and consolidates them into an array of outputs.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-flow-flownodeconfiguration.html#cfn-bedrock-flow-flownodeconfiguration-collector">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-flow-flownodeconfiguration.html#cfn-bedrock-flow-flownodeconfiguration-collector</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getCollector() {
            return null;
        }

        /**
         * Contains configurations for a Condition node in your flow.
         * <p>
         * Defines conditions that lead to different branches of the flow.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-flow-flownodeconfiguration.html#cfn-bedrock-flow-flownodeconfiguration-condition">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-flow-flownodeconfiguration.html#cfn-bedrock-flow-flownodeconfiguration-condition</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getCondition() {
            return null;
        }

        /**
         * Contains configurations for an input flow node in your flow.
         * <p>
         * The first node in the flow. <code>inputs</code> can't be specified for this node.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-flow-flownodeconfiguration.html#cfn-bedrock-flow-flownodeconfiguration-input">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-flow-flownodeconfiguration.html#cfn-bedrock-flow-flownodeconfiguration-input</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getInput() {
            return null;
        }

        /**
         * Contains configurations for an iterator node in your flow.
         * <p>
         * Takes an input that is an array and iteratively sends each item of the array as an output to the following node. The size of the array is also returned in the output.
         * <p>
         * The output flow node at the end of the flow iteration will return a response for each member of the array. To return only one response, you can include a collector node downstream from the iterator node.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-flow-flownodeconfiguration.html#cfn-bedrock-flow-flownodeconfiguration-iterator">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-flow-flownodeconfiguration.html#cfn-bedrock-flow-flownodeconfiguration-iterator</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getIterator() {
            return null;
        }

        /**
         * Contains configurations for a knowledge base node in your flow.
         * <p>
         * Queries a knowledge base and returns the retrieved results or generated response.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-flow-flownodeconfiguration.html#cfn-bedrock-flow-flownodeconfiguration-knowledgebase">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-flow-flownodeconfiguration.html#cfn-bedrock-flow-flownodeconfiguration-knowledgebase</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getKnowledgeBase() {
            return null;
        }

        /**
         * Contains configurations for a Lambda function node in your flow.
         * <p>
         * Invokes an AWS Lambda function.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-flow-flownodeconfiguration.html#cfn-bedrock-flow-flownodeconfiguration-lambdafunction">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-flow-flownodeconfiguration.html#cfn-bedrock-flow-flownodeconfiguration-lambdafunction</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getLambdaFunction() {
            return null;
        }

        /**
         * Contains configurations for a Lex node in your flow.
         * <p>
         * Invokes an Amazon Lex bot to identify the intent of the input and return the intent as the output.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-flow-flownodeconfiguration.html#cfn-bedrock-flow-flownodeconfiguration-lex">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-flow-flownodeconfiguration.html#cfn-bedrock-flow-flownodeconfiguration-lex</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getLex() {
            return null;
        }

        /**
         * Contains configurations for an output flow node in your flow.
         * <p>
         * The last node in the flow. <code>outputs</code> can't be specified for this node.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-flow-flownodeconfiguration.html#cfn-bedrock-flow-flownodeconfiguration-output">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-flow-flownodeconfiguration.html#cfn-bedrock-flow-flownodeconfiguration-output</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getOutput() {
            return null;
        }

        /**
         * Contains configurations for a prompt node in your flow.
         * <p>
         * Runs a prompt and generates the model response as the output. You can use a prompt from Prompt management or you can configure one in this node.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-flow-flownodeconfiguration.html#cfn-bedrock-flow-flownodeconfiguration-prompt">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-flow-flownodeconfiguration.html#cfn-bedrock-flow-flownodeconfiguration-prompt</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getPrompt() {
            return null;
        }

        /**
         * Contains configurations for a Retrieval node in your flow.
         * <p>
         * Retrieves data from an Amazon S3 location and returns it as the output.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-flow-flownodeconfiguration.html#cfn-bedrock-flow-flownodeconfiguration-retrieval">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-flow-flownodeconfiguration.html#cfn-bedrock-flow-flownodeconfiguration-retrieval</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getRetrieval() {
            return null;
        }

        /**
         * Contains configurations for a Storage node in your flow.
         * <p>
         * Stores an input in an Amazon S3 location.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-flow-flownodeconfiguration.html#cfn-bedrock-flow-flownodeconfiguration-storage">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-flow-flownodeconfiguration.html#cfn-bedrock-flow-flownodeconfiguration-storage</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getStorage() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link FlowNodeConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link FlowNodeConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<FlowNodeConfigurationProperty> {
            java.lang.Object agent;
            java.lang.Object collector;
            java.lang.Object condition;
            java.lang.Object input;
            java.lang.Object iterator;
            java.lang.Object knowledgeBase;
            java.lang.Object lambdaFunction;
            java.lang.Object lex;
            java.lang.Object output;
            java.lang.Object prompt;
            java.lang.Object retrieval;
            java.lang.Object storage;

            /**
             * Sets the value of {@link FlowNodeConfigurationProperty#getAgent}
             * @param agent Contains configurations for an agent node in your flow.
             *              Invokes an alias of an agent and returns the response.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder agent(software.amazon.awscdk.IResolvable agent) {
                this.agent = agent;
                return this;
            }

            /**
             * Sets the value of {@link FlowNodeConfigurationProperty#getAgent}
             * @param agent Contains configurations for an agent node in your flow.
             *              Invokes an alias of an agent and returns the response.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder agent(software.amazon.awscdk.services.bedrock.CfnFlow.AgentFlowNodeConfigurationProperty agent) {
                this.agent = agent;
                return this;
            }

            /**
             * Sets the value of {@link FlowNodeConfigurationProperty#getCollector}
             * @param collector Contains configurations for a collector node in your flow.
             *                  Collects an iteration of inputs and consolidates them into an array of outputs.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder collector(java.lang.Object collector) {
                this.collector = collector;
                return this;
            }

            /**
             * Sets the value of {@link FlowNodeConfigurationProperty#getCondition}
             * @param condition Contains configurations for a Condition node in your flow.
             *                  Defines conditions that lead to different branches of the flow.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder condition(software.amazon.awscdk.IResolvable condition) {
                this.condition = condition;
                return this;
            }

            /**
             * Sets the value of {@link FlowNodeConfigurationProperty#getCondition}
             * @param condition Contains configurations for a Condition node in your flow.
             *                  Defines conditions that lead to different branches of the flow.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder condition(software.amazon.awscdk.services.bedrock.CfnFlow.ConditionFlowNodeConfigurationProperty condition) {
                this.condition = condition;
                return this;
            }

            /**
             * Sets the value of {@link FlowNodeConfigurationProperty#getInput}
             * @param input Contains configurations for an input flow node in your flow.
             *              The first node in the flow. <code>inputs</code> can't be specified for this node.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder input(java.lang.Object input) {
                this.input = input;
                return this;
            }

            /**
             * Sets the value of {@link FlowNodeConfigurationProperty#getIterator}
             * @param iterator Contains configurations for an iterator node in your flow.
             *                 Takes an input that is an array and iteratively sends each item of the array as an output to the following node. The size of the array is also returned in the output.
             *                 <p>
             *                 The output flow node at the end of the flow iteration will return a response for each member of the array. To return only one response, you can include a collector node downstream from the iterator node.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder iterator(java.lang.Object iterator) {
                this.iterator = iterator;
                return this;
            }

            /**
             * Sets the value of {@link FlowNodeConfigurationProperty#getKnowledgeBase}
             * @param knowledgeBase Contains configurations for a knowledge base node in your flow.
             *                      Queries a knowledge base and returns the retrieved results or generated response.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder knowledgeBase(software.amazon.awscdk.IResolvable knowledgeBase) {
                this.knowledgeBase = knowledgeBase;
                return this;
            }

            /**
             * Sets the value of {@link FlowNodeConfigurationProperty#getKnowledgeBase}
             * @param knowledgeBase Contains configurations for a knowledge base node in your flow.
             *                      Queries a knowledge base and returns the retrieved results or generated response.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder knowledgeBase(software.amazon.awscdk.services.bedrock.CfnFlow.KnowledgeBaseFlowNodeConfigurationProperty knowledgeBase) {
                this.knowledgeBase = knowledgeBase;
                return this;
            }

            /**
             * Sets the value of {@link FlowNodeConfigurationProperty#getLambdaFunction}
             * @param lambdaFunction Contains configurations for a Lambda function node in your flow.
             *                       Invokes an AWS Lambda function.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder lambdaFunction(software.amazon.awscdk.IResolvable lambdaFunction) {
                this.lambdaFunction = lambdaFunction;
                return this;
            }

            /**
             * Sets the value of {@link FlowNodeConfigurationProperty#getLambdaFunction}
             * @param lambdaFunction Contains configurations for a Lambda function node in your flow.
             *                       Invokes an AWS Lambda function.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder lambdaFunction(software.amazon.awscdk.services.bedrock.CfnFlow.LambdaFunctionFlowNodeConfigurationProperty lambdaFunction) {
                this.lambdaFunction = lambdaFunction;
                return this;
            }

            /**
             * Sets the value of {@link FlowNodeConfigurationProperty#getLex}
             * @param lex Contains configurations for a Lex node in your flow.
             *            Invokes an Amazon Lex bot to identify the intent of the input and return the intent as the output.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder lex(software.amazon.awscdk.IResolvable lex) {
                this.lex = lex;
                return this;
            }

            /**
             * Sets the value of {@link FlowNodeConfigurationProperty#getLex}
             * @param lex Contains configurations for a Lex node in your flow.
             *            Invokes an Amazon Lex bot to identify the intent of the input and return the intent as the output.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder lex(software.amazon.awscdk.services.bedrock.CfnFlow.LexFlowNodeConfigurationProperty lex) {
                this.lex = lex;
                return this;
            }

            /**
             * Sets the value of {@link FlowNodeConfigurationProperty#getOutput}
             * @param output Contains configurations for an output flow node in your flow.
             *               The last node in the flow. <code>outputs</code> can't be specified for this node.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder output(java.lang.Object output) {
                this.output = output;
                return this;
            }

            /**
             * Sets the value of {@link FlowNodeConfigurationProperty#getPrompt}
             * @param prompt Contains configurations for a prompt node in your flow.
             *               Runs a prompt and generates the model response as the output. You can use a prompt from Prompt management or you can configure one in this node.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder prompt(software.amazon.awscdk.IResolvable prompt) {
                this.prompt = prompt;
                return this;
            }

            /**
             * Sets the value of {@link FlowNodeConfigurationProperty#getPrompt}
             * @param prompt Contains configurations for a prompt node in your flow.
             *               Runs a prompt and generates the model response as the output. You can use a prompt from Prompt management or you can configure one in this node.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder prompt(software.amazon.awscdk.services.bedrock.CfnFlow.PromptFlowNodeConfigurationProperty prompt) {
                this.prompt = prompt;
                return this;
            }

            /**
             * Sets the value of {@link FlowNodeConfigurationProperty#getRetrieval}
             * @param retrieval Contains configurations for a Retrieval node in your flow.
             *                  Retrieves data from an Amazon S3 location and returns it as the output.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder retrieval(software.amazon.awscdk.IResolvable retrieval) {
                this.retrieval = retrieval;
                return this;
            }

            /**
             * Sets the value of {@link FlowNodeConfigurationProperty#getRetrieval}
             * @param retrieval Contains configurations for a Retrieval node in your flow.
             *                  Retrieves data from an Amazon S3 location and returns it as the output.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder retrieval(software.amazon.awscdk.services.bedrock.CfnFlow.RetrievalFlowNodeConfigurationProperty retrieval) {
                this.retrieval = retrieval;
                return this;
            }

            /**
             * Sets the value of {@link FlowNodeConfigurationProperty#getStorage}
             * @param storage Contains configurations for a Storage node in your flow.
             *                Stores an input in an Amazon S3 location.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder storage(software.amazon.awscdk.IResolvable storage) {
                this.storage = storage;
                return this;
            }

            /**
             * Sets the value of {@link FlowNodeConfigurationProperty#getStorage}
             * @param storage Contains configurations for a Storage node in your flow.
             *                Stores an input in an Amazon S3 location.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder storage(software.amazon.awscdk.services.bedrock.CfnFlow.StorageFlowNodeConfigurationProperty storage) {
                this.storage = storage;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link FlowNodeConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public FlowNodeConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link FlowNodeConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements FlowNodeConfigurationProperty {
            private final java.lang.Object agent;
            private final java.lang.Object collector;
            private final java.lang.Object condition;
            private final java.lang.Object input;
            private final java.lang.Object iterator;
            private final java.lang.Object knowledgeBase;
            private final java.lang.Object lambdaFunction;
            private final java.lang.Object lex;
            private final java.lang.Object output;
            private final java.lang.Object prompt;
            private final java.lang.Object retrieval;
            private final java.lang.Object storage;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.agent = software.amazon.jsii.Kernel.get(this, "agent", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.collector = software.amazon.jsii.Kernel.get(this, "collector", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.condition = software.amazon.jsii.Kernel.get(this, "condition", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.input = software.amazon.jsii.Kernel.get(this, "input", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.iterator = software.amazon.jsii.Kernel.get(this, "iterator", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.knowledgeBase = software.amazon.jsii.Kernel.get(this, "knowledgeBase", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.lambdaFunction = software.amazon.jsii.Kernel.get(this, "lambdaFunction", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.lex = software.amazon.jsii.Kernel.get(this, "lex", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.output = software.amazon.jsii.Kernel.get(this, "output", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.prompt = software.amazon.jsii.Kernel.get(this, "prompt", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.retrieval = software.amazon.jsii.Kernel.get(this, "retrieval", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.storage = software.amazon.jsii.Kernel.get(this, "storage", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.agent = builder.agent;
                this.collector = builder.collector;
                this.condition = builder.condition;
                this.input = builder.input;
                this.iterator = builder.iterator;
                this.knowledgeBase = builder.knowledgeBase;
                this.lambdaFunction = builder.lambdaFunction;
                this.lex = builder.lex;
                this.output = builder.output;
                this.prompt = builder.prompt;
                this.retrieval = builder.retrieval;
                this.storage = builder.storage;
            }

            @Override
            public final java.lang.Object getAgent() {
                return this.agent;
            }

            @Override
            public final java.lang.Object getCollector() {
                return this.collector;
            }

            @Override
            public final java.lang.Object getCondition() {
                return this.condition;
            }

            @Override
            public final java.lang.Object getInput() {
                return this.input;
            }

            @Override
            public final java.lang.Object getIterator() {
                return this.iterator;
            }

            @Override
            public final java.lang.Object getKnowledgeBase() {
                return this.knowledgeBase;
            }

            @Override
            public final java.lang.Object getLambdaFunction() {
                return this.lambdaFunction;
            }

            @Override
            public final java.lang.Object getLex() {
                return this.lex;
            }

            @Override
            public final java.lang.Object getOutput() {
                return this.output;
            }

            @Override
            public final java.lang.Object getPrompt() {
                return this.prompt;
            }

            @Override
            public final java.lang.Object getRetrieval() {
                return this.retrieval;
            }

            @Override
            public final java.lang.Object getStorage() {
                return this.storage;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getAgent() != null) {
                    data.set("agent", om.valueToTree(this.getAgent()));
                }
                if (this.getCollector() != null) {
                    data.set("collector", om.valueToTree(this.getCollector()));
                }
                if (this.getCondition() != null) {
                    data.set("condition", om.valueToTree(this.getCondition()));
                }
                if (this.getInput() != null) {
                    data.set("input", om.valueToTree(this.getInput()));
                }
                if (this.getIterator() != null) {
                    data.set("iterator", om.valueToTree(this.getIterator()));
                }
                if (this.getKnowledgeBase() != null) {
                    data.set("knowledgeBase", om.valueToTree(this.getKnowledgeBase()));
                }
                if (this.getLambdaFunction() != null) {
                    data.set("lambdaFunction", om.valueToTree(this.getLambdaFunction()));
                }
                if (this.getLex() != null) {
                    data.set("lex", om.valueToTree(this.getLex()));
                }
                if (this.getOutput() != null) {
                    data.set("output", om.valueToTree(this.getOutput()));
                }
                if (this.getPrompt() != null) {
                    data.set("prompt", om.valueToTree(this.getPrompt()));
                }
                if (this.getRetrieval() != null) {
                    data.set("retrieval", om.valueToTree(this.getRetrieval()));
                }
                if (this.getStorage() != null) {
                    data.set("storage", om.valueToTree(this.getStorage()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_bedrock.CfnFlow.FlowNodeConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                FlowNodeConfigurationProperty.Jsii$Proxy that = (FlowNodeConfigurationProperty.Jsii$Proxy) o;

                if (this.agent != null ? !this.agent.equals(that.agent) : that.agent != null) return false;
                if (this.collector != null ? !this.collector.equals(that.collector) : that.collector != null) return false;
                if (this.condition != null ? !this.condition.equals(that.condition) : that.condition != null) return false;
                if (this.input != null ? !this.input.equals(that.input) : that.input != null) return false;
                if (this.iterator != null ? !this.iterator.equals(that.iterator) : that.iterator != null) return false;
                if (this.knowledgeBase != null ? !this.knowledgeBase.equals(that.knowledgeBase) : that.knowledgeBase != null) return false;
                if (this.lambdaFunction != null ? !this.lambdaFunction.equals(that.lambdaFunction) : that.lambdaFunction != null) return false;
                if (this.lex != null ? !this.lex.equals(that.lex) : that.lex != null) return false;
                if (this.output != null ? !this.output.equals(that.output) : that.output != null) return false;
                if (this.prompt != null ? !this.prompt.equals(that.prompt) : that.prompt != null) return false;
                if (this.retrieval != null ? !this.retrieval.equals(that.retrieval) : that.retrieval != null) return false;
                return this.storage != null ? this.storage.equals(that.storage) : that.storage == null;
            }

            @Override
            public final int hashCode() {
                int result = this.agent != null ? this.agent.hashCode() : 0;
                result = 31 * result + (this.collector != null ? this.collector.hashCode() : 0);
                result = 31 * result + (this.condition != null ? this.condition.hashCode() : 0);
                result = 31 * result + (this.input != null ? this.input.hashCode() : 0);
                result = 31 * result + (this.iterator != null ? this.iterator.hashCode() : 0);
                result = 31 * result + (this.knowledgeBase != null ? this.knowledgeBase.hashCode() : 0);
                result = 31 * result + (this.lambdaFunction != null ? this.lambdaFunction.hashCode() : 0);
                result = 31 * result + (this.lex != null ? this.lex.hashCode() : 0);
                result = 31 * result + (this.output != null ? this.output.hashCode() : 0);
                result = 31 * result + (this.prompt != null ? this.prompt.hashCode() : 0);
                result = 31 * result + (this.retrieval != null ? this.retrieval.hashCode() : 0);
                result = 31 * result + (this.storage != null ? this.storage.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Contains configurations for an input to a node.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.bedrock.*;
     * FlowNodeInputProperty flowNodeInputProperty = FlowNodeInputProperty.builder()
     *         .expression("expression")
     *         .name("name")
     *         .type("type")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-flow-flownodeinput.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-flow-flownodeinput.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_bedrock.CfnFlow.FlowNodeInputProperty")
    @software.amazon.jsii.Jsii.Proxy(FlowNodeInputProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface FlowNodeInputProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * An expression that formats the input for the node.
         * <p>
         * For an explanation of how to create expressions, see <a href="https://docs.aws.amazon.com/bedrock/latest/userguide/flows-expressions.html">Expressions in Prompt flows in Amazon Bedrock</a> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-flow-flownodeinput.html#cfn-bedrock-flow-flownodeinput-expression">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-flow-flownodeinput.html#cfn-bedrock-flow-flownodeinput-expression</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getExpression();

        /**
         * A name for the input that you can reference.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-flow-flownodeinput.html#cfn-bedrock-flow-flownodeinput-name">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-flow-flownodeinput.html#cfn-bedrock-flow-flownodeinput-name</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getName();

        /**
         * The data type of the input.
         * <p>
         * If the input doesn't match this type at runtime, a validation error will be thrown.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-flow-flownodeinput.html#cfn-bedrock-flow-flownodeinput-type">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-flow-flownodeinput.html#cfn-bedrock-flow-flownodeinput-type</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getType();

        /**
         * @return a {@link Builder} of {@link FlowNodeInputProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link FlowNodeInputProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<FlowNodeInputProperty> {
            java.lang.String expression;
            java.lang.String name;
            java.lang.String type;

            /**
             * Sets the value of {@link FlowNodeInputProperty#getExpression}
             * @param expression An expression that formats the input for the node. This parameter is required.
             *                   For an explanation of how to create expressions, see <a href="https://docs.aws.amazon.com/bedrock/latest/userguide/flows-expressions.html">Expressions in Prompt flows in Amazon Bedrock</a> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder expression(java.lang.String expression) {
                this.expression = expression;
                return this;
            }

            /**
             * Sets the value of {@link FlowNodeInputProperty#getName}
             * @param name A name for the input that you can reference. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder name(java.lang.String name) {
                this.name = name;
                return this;
            }

            /**
             * Sets the value of {@link FlowNodeInputProperty#getType}
             * @param type The data type of the input. This parameter is required.
             *             If the input doesn't match this type at runtime, a validation error will be thrown.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder type(java.lang.String type) {
                this.type = type;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link FlowNodeInputProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public FlowNodeInputProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link FlowNodeInputProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements FlowNodeInputProperty {
            private final java.lang.String expression;
            private final java.lang.String name;
            private final java.lang.String type;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.expression = software.amazon.jsii.Kernel.get(this, "expression", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.type = software.amazon.jsii.Kernel.get(this, "type", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.expression = java.util.Objects.requireNonNull(builder.expression, "expression is required");
                this.name = java.util.Objects.requireNonNull(builder.name, "name is required");
                this.type = java.util.Objects.requireNonNull(builder.type, "type is required");
            }

            @Override
            public final java.lang.String getExpression() {
                return this.expression;
            }

            @Override
            public final java.lang.String getName() {
                return this.name;
            }

            @Override
            public final java.lang.String getType() {
                return this.type;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("expression", om.valueToTree(this.getExpression()));
                data.set("name", om.valueToTree(this.getName()));
                data.set("type", om.valueToTree(this.getType()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_bedrock.CfnFlow.FlowNodeInputProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                FlowNodeInputProperty.Jsii$Proxy that = (FlowNodeInputProperty.Jsii$Proxy) o;

                if (!expression.equals(that.expression)) return false;
                if (!name.equals(that.name)) return false;
                return this.type.equals(that.type);
            }

            @Override
            public final int hashCode() {
                int result = this.expression.hashCode();
                result = 31 * result + (this.name.hashCode());
                result = 31 * result + (this.type.hashCode());
                return result;
            }
        }
    }
    /**
     * Contains configurations for an output from a node.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.bedrock.*;
     * FlowNodeOutputProperty flowNodeOutputProperty = FlowNodeOutputProperty.builder()
     *         .name("name")
     *         .type("type")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-flow-flownodeoutput.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-flow-flownodeoutput.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_bedrock.CfnFlow.FlowNodeOutputProperty")
    @software.amazon.jsii.Jsii.Proxy(FlowNodeOutputProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface FlowNodeOutputProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * A name for the output that you can reference.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-flow-flownodeoutput.html#cfn-bedrock-flow-flownodeoutput-name">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-flow-flownodeoutput.html#cfn-bedrock-flow-flownodeoutput-name</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getName();

        /**
         * The data type of the output.
         * <p>
         * If the output doesn't match this type at runtime, a validation error will be thrown.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-flow-flownodeoutput.html#cfn-bedrock-flow-flownodeoutput-type">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-flow-flownodeoutput.html#cfn-bedrock-flow-flownodeoutput-type</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getType();

        /**
         * @return a {@link Builder} of {@link FlowNodeOutputProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link FlowNodeOutputProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<FlowNodeOutputProperty> {
            java.lang.String name;
            java.lang.String type;

            /**
             * Sets the value of {@link FlowNodeOutputProperty#getName}
             * @param name A name for the output that you can reference. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder name(java.lang.String name) {
                this.name = name;
                return this;
            }

            /**
             * Sets the value of {@link FlowNodeOutputProperty#getType}
             * @param type The data type of the output. This parameter is required.
             *             If the output doesn't match this type at runtime, a validation error will be thrown.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder type(java.lang.String type) {
                this.type = type;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link FlowNodeOutputProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public FlowNodeOutputProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link FlowNodeOutputProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements FlowNodeOutputProperty {
            private final java.lang.String name;
            private final java.lang.String type;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.type = software.amazon.jsii.Kernel.get(this, "type", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.name = java.util.Objects.requireNonNull(builder.name, "name is required");
                this.type = java.util.Objects.requireNonNull(builder.type, "type is required");
            }

            @Override
            public final java.lang.String getName() {
                return this.name;
            }

            @Override
            public final java.lang.String getType() {
                return this.type;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("name", om.valueToTree(this.getName()));
                data.set("type", om.valueToTree(this.getType()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_bedrock.CfnFlow.FlowNodeOutputProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                FlowNodeOutputProperty.Jsii$Proxy that = (FlowNodeOutputProperty.Jsii$Proxy) o;

                if (!name.equals(that.name)) return false;
                return this.type.equals(that.type);
            }

            @Override
            public final int hashCode() {
                int result = this.name.hashCode();
                result = 31 * result + (this.type.hashCode());
                return result;
            }
        }
    }
    /**
     * Contains configurations about a node in the flow.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.bedrock.*;
     * Object collector;
     * Object input;
     * Object iterator;
     * Object output;
     * FlowNodeProperty flowNodeProperty = FlowNodeProperty.builder()
     *         .name("name")
     *         .type("type")
     *         // the properties below are optional
     *         .configuration(FlowNodeConfigurationProperty.builder()
     *                 .agent(AgentFlowNodeConfigurationProperty.builder()
     *                         .agentAliasArn("agentAliasArn")
     *                         .build())
     *                 .collector(collector)
     *                 .condition(ConditionFlowNodeConfigurationProperty.builder()
     *                         .conditions(List.of(FlowConditionProperty.builder()
     *                                 .name("name")
     *                                 // the properties below are optional
     *                                 .expression("expression")
     *                                 .build()))
     *                         .build())
     *                 .input(input)
     *                 .iterator(iterator)
     *                 .knowledgeBase(KnowledgeBaseFlowNodeConfigurationProperty.builder()
     *                         .knowledgeBaseId("knowledgeBaseId")
     *                         // the properties below are optional
     *                         .guardrailConfiguration(GuardrailConfigurationProperty.builder()
     *                                 .guardrailIdentifier("guardrailIdentifier")
     *                                 .guardrailVersion("guardrailVersion")
     *                                 .build())
     *                         .modelId("modelId")
     *                         .build())
     *                 .lambdaFunction(LambdaFunctionFlowNodeConfigurationProperty.builder()
     *                         .lambdaArn("lambdaArn")
     *                         .build())
     *                 .lex(LexFlowNodeConfigurationProperty.builder()
     *                         .botAliasArn("botAliasArn")
     *                         .localeId("localeId")
     *                         .build())
     *                 .output(output)
     *                 .prompt(PromptFlowNodeConfigurationProperty.builder()
     *                         .sourceConfiguration(PromptFlowNodeSourceConfigurationProperty.builder()
     *                                 .inline(PromptFlowNodeInlineConfigurationProperty.builder()
     *                                         .modelId("modelId")
     *                                         .templateConfiguration(PromptTemplateConfigurationProperty.builder()
     *                                                 .text(TextPromptTemplateConfigurationProperty.builder()
     *                                                         .text("text")
     *                                                         // the properties below are optional
     *                                                         .inputVariables(List.of(PromptInputVariableProperty.builder()
     *                                                                 .name("name")
     *                                                                 .build()))
     *                                                         .build())
     *                                                 .build())
     *                                         .templateType("templateType")
     *                                         // the properties below are optional
     *                                         .inferenceConfiguration(PromptInferenceConfigurationProperty.builder()
     *                                                 .text(PromptModelInferenceConfigurationProperty.builder()
     *                                                         .maxTokens(123)
     *                                                         .stopSequences(List.of("stopSequences"))
     *                                                         .temperature(123)
     *                                                         .topP(123)
     *                                                         .build())
     *                                                 .build())
     *                                         .build())
     *                                 .resource(PromptFlowNodeResourceConfigurationProperty.builder()
     *                                         .promptArn("promptArn")
     *                                         .build())
     *                                 .build())
     *                         // the properties below are optional
     *                         .guardrailConfiguration(GuardrailConfigurationProperty.builder()
     *                                 .guardrailIdentifier("guardrailIdentifier")
     *                                 .guardrailVersion("guardrailVersion")
     *                                 .build())
     *                         .build())
     *                 .retrieval(RetrievalFlowNodeConfigurationProperty.builder()
     *                         .serviceConfiguration(RetrievalFlowNodeServiceConfigurationProperty.builder()
     *                                 .s3(RetrievalFlowNodeS3ConfigurationProperty.builder()
     *                                         .bucketName("bucketName")
     *                                         .build())
     *                                 .build())
     *                         .build())
     *                 .storage(StorageFlowNodeConfigurationProperty.builder()
     *                         .serviceConfiguration(StorageFlowNodeServiceConfigurationProperty.builder()
     *                                 .s3(StorageFlowNodeS3ConfigurationProperty.builder()
     *                                         .bucketName("bucketName")
     *                                         .build())
     *                                 .build())
     *                         .build())
     *                 .build())
     *         .inputs(List.of(FlowNodeInputProperty.builder()
     *                 .expression("expression")
     *                 .name("name")
     *                 .type("type")
     *                 .build()))
     *         .outputs(List.of(FlowNodeOutputProperty.builder()
     *                 .name("name")
     *                 .type("type")
     *                 .build()))
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-flow-flownode.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-flow-flownode.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_bedrock.CfnFlow.FlowNodeProperty")
    @software.amazon.jsii.Jsii.Proxy(FlowNodeProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface FlowNodeProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * A name for the node.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-flow-flownode.html#cfn-bedrock-flow-flownode-name">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-flow-flownode.html#cfn-bedrock-flow-flownode-name</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getName();

        /**
         * The type of node.
         * <p>
         * This value must match the name of the key that you provide in the configuration you provide in the <code>FlowNodeConfiguration</code> field.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-flow-flownode.html#cfn-bedrock-flow-flownode-type">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-flow-flownode.html#cfn-bedrock-flow-flownode-type</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getType();

        /**
         * Contains configurations for the node.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-flow-flownode.html#cfn-bedrock-flow-flownode-configuration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-flow-flownode.html#cfn-bedrock-flow-flownode-configuration</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getConfiguration() {
            return null;
        }

        /**
         * An array of objects, each of which contains information about an input into the node.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-flow-flownode.html#cfn-bedrock-flow-flownode-inputs">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-flow-flownode.html#cfn-bedrock-flow-flownode-inputs</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getInputs() {
            return null;
        }

        /**
         * A list of objects, each of which contains information about an output from the node.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-flow-flownode.html#cfn-bedrock-flow-flownode-outputs">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-flow-flownode.html#cfn-bedrock-flow-flownode-outputs</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getOutputs() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link FlowNodeProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link FlowNodeProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<FlowNodeProperty> {
            java.lang.String name;
            java.lang.String type;
            java.lang.Object configuration;
            java.lang.Object inputs;
            java.lang.Object outputs;

            /**
             * Sets the value of {@link FlowNodeProperty#getName}
             * @param name A name for the node. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder name(java.lang.String name) {
                this.name = name;
                return this;
            }

            /**
             * Sets the value of {@link FlowNodeProperty#getType}
             * @param type The type of node. This parameter is required.
             *             This value must match the name of the key that you provide in the configuration you provide in the <code>FlowNodeConfiguration</code> field.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder type(java.lang.String type) {
                this.type = type;
                return this;
            }

            /**
             * Sets the value of {@link FlowNodeProperty#getConfiguration}
             * @param configuration Contains configurations for the node.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder configuration(software.amazon.awscdk.IResolvable configuration) {
                this.configuration = configuration;
                return this;
            }

            /**
             * Sets the value of {@link FlowNodeProperty#getConfiguration}
             * @param configuration Contains configurations for the node.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder configuration(software.amazon.awscdk.services.bedrock.CfnFlow.FlowNodeConfigurationProperty configuration) {
                this.configuration = configuration;
                return this;
            }

            /**
             * Sets the value of {@link FlowNodeProperty#getInputs}
             * @param inputs An array of objects, each of which contains information about an input into the node.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder inputs(software.amazon.awscdk.IResolvable inputs) {
                this.inputs = inputs;
                return this;
            }

            /**
             * Sets the value of {@link FlowNodeProperty#getInputs}
             * @param inputs An array of objects, each of which contains information about an input into the node.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder inputs(java.util.List<? extends java.lang.Object> inputs) {
                this.inputs = inputs;
                return this;
            }

            /**
             * Sets the value of {@link FlowNodeProperty#getOutputs}
             * @param outputs A list of objects, each of which contains information about an output from the node.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder outputs(software.amazon.awscdk.IResolvable outputs) {
                this.outputs = outputs;
                return this;
            }

            /**
             * Sets the value of {@link FlowNodeProperty#getOutputs}
             * @param outputs A list of objects, each of which contains information about an output from the node.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder outputs(java.util.List<? extends java.lang.Object> outputs) {
                this.outputs = outputs;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link FlowNodeProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public FlowNodeProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link FlowNodeProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements FlowNodeProperty {
            private final java.lang.String name;
            private final java.lang.String type;
            private final java.lang.Object configuration;
            private final java.lang.Object inputs;
            private final java.lang.Object outputs;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.type = software.amazon.jsii.Kernel.get(this, "type", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.configuration = software.amazon.jsii.Kernel.get(this, "configuration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.inputs = software.amazon.jsii.Kernel.get(this, "inputs", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.outputs = software.amazon.jsii.Kernel.get(this, "outputs", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.name = java.util.Objects.requireNonNull(builder.name, "name is required");
                this.type = java.util.Objects.requireNonNull(builder.type, "type is required");
                this.configuration = builder.configuration;
                this.inputs = builder.inputs;
                this.outputs = builder.outputs;
            }

            @Override
            public final java.lang.String getName() {
                return this.name;
            }

            @Override
            public final java.lang.String getType() {
                return this.type;
            }

            @Override
            public final java.lang.Object getConfiguration() {
                return this.configuration;
            }

            @Override
            public final java.lang.Object getInputs() {
                return this.inputs;
            }

            @Override
            public final java.lang.Object getOutputs() {
                return this.outputs;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("name", om.valueToTree(this.getName()));
                data.set("type", om.valueToTree(this.getType()));
                if (this.getConfiguration() != null) {
                    data.set("configuration", om.valueToTree(this.getConfiguration()));
                }
                if (this.getInputs() != null) {
                    data.set("inputs", om.valueToTree(this.getInputs()));
                }
                if (this.getOutputs() != null) {
                    data.set("outputs", om.valueToTree(this.getOutputs()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_bedrock.CfnFlow.FlowNodeProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                FlowNodeProperty.Jsii$Proxy that = (FlowNodeProperty.Jsii$Proxy) o;

                if (!name.equals(that.name)) return false;
                if (!type.equals(that.type)) return false;
                if (this.configuration != null ? !this.configuration.equals(that.configuration) : that.configuration != null) return false;
                if (this.inputs != null ? !this.inputs.equals(that.inputs) : that.inputs != null) return false;
                return this.outputs != null ? this.outputs.equals(that.outputs) : that.outputs == null;
            }

            @Override
            public final int hashCode() {
                int result = this.name.hashCode();
                result = 31 * result + (this.type.hashCode());
                result = 31 * result + (this.configuration != null ? this.configuration.hashCode() : 0);
                result = 31 * result + (this.inputs != null ? this.inputs.hashCode() : 0);
                result = 31 * result + (this.outputs != null ? this.outputs.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Contains information about validation of the flow.
     * <p>
     * This data type is used in the following API operations:
     * <p>
     * <ul>
     * <li><a href="https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent_GetFlow.html#API_agent_GetFlow_ResponseSyntax">GetFlow response</a></li>
     * <li><a href="https://docs.aws.amazon.com/bedrock/latest/APIReference/API_agent_GetFlowVersion.html#API_agent_GetFlowVersion_ResponseSyntax">GetFlowVersion response</a></li>
     * </ul>
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.bedrock.*;
     * FlowValidationProperty flowValidationProperty = FlowValidationProperty.builder()
     *         .message("message")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-flow-flowvalidation.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-flow-flowvalidation.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_bedrock.CfnFlow.FlowValidationProperty")
    @software.amazon.jsii.Jsii.Proxy(FlowValidationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface FlowValidationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * A message describing the validation error.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-flow-flowvalidation.html#cfn-bedrock-flow-flowvalidation-message">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-flow-flowvalidation.html#cfn-bedrock-flow-flowvalidation-message</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getMessage();

        /**
         * @return a {@link Builder} of {@link FlowValidationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link FlowValidationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<FlowValidationProperty> {
            java.lang.String message;

            /**
             * Sets the value of {@link FlowValidationProperty#getMessage}
             * @param message A message describing the validation error. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder message(java.lang.String message) {
                this.message = message;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link FlowValidationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public FlowValidationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link FlowValidationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements FlowValidationProperty {
            private final java.lang.String message;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.message = software.amazon.jsii.Kernel.get(this, "message", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.message = java.util.Objects.requireNonNull(builder.message, "message is required");
            }

            @Override
            public final java.lang.String getMessage() {
                return this.message;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("message", om.valueToTree(this.getMessage()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_bedrock.CfnFlow.FlowValidationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                FlowValidationProperty.Jsii$Proxy that = (FlowValidationProperty.Jsii$Proxy) o;

                return this.message.equals(that.message);
            }

            @Override
            public final int hashCode() {
                int result = this.message.hashCode();
                return result;
            }
        }
    }
    /**
     * Configuration information for a guardrail that you use with the <a href="https://docs.aws.amazon.com/bedrock/latest/APIReference/API_runtime_Converse.html">Converse</a> operation.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.bedrock.*;
     * GuardrailConfigurationProperty guardrailConfigurationProperty = GuardrailConfigurationProperty.builder()
     *         .guardrailIdentifier("guardrailIdentifier")
     *         .guardrailVersion("guardrailVersion")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-flow-guardrailconfiguration.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-flow-guardrailconfiguration.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_bedrock.CfnFlow.GuardrailConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(GuardrailConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface GuardrailConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The identifier for the guardrail.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-flow-guardrailconfiguration.html#cfn-bedrock-flow-guardrailconfiguration-guardrailidentifier">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-flow-guardrailconfiguration.html#cfn-bedrock-flow-guardrailconfiguration-guardrailidentifier</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getGuardrailIdentifier() {
            return null;
        }

        /**
         * The version of the guardrail.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-flow-guardrailconfiguration.html#cfn-bedrock-flow-guardrailconfiguration-guardrailversion">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-flow-guardrailconfiguration.html#cfn-bedrock-flow-guardrailconfiguration-guardrailversion</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getGuardrailVersion() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link GuardrailConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link GuardrailConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<GuardrailConfigurationProperty> {
            java.lang.String guardrailIdentifier;
            java.lang.String guardrailVersion;

            /**
             * Sets the value of {@link GuardrailConfigurationProperty#getGuardrailIdentifier}
             * @param guardrailIdentifier The identifier for the guardrail.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder guardrailIdentifier(java.lang.String guardrailIdentifier) {
                this.guardrailIdentifier = guardrailIdentifier;
                return this;
            }

            /**
             * Sets the value of {@link GuardrailConfigurationProperty#getGuardrailVersion}
             * @param guardrailVersion The version of the guardrail.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder guardrailVersion(java.lang.String guardrailVersion) {
                this.guardrailVersion = guardrailVersion;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link GuardrailConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public GuardrailConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link GuardrailConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements GuardrailConfigurationProperty {
            private final java.lang.String guardrailIdentifier;
            private final java.lang.String guardrailVersion;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.guardrailIdentifier = software.amazon.jsii.Kernel.get(this, "guardrailIdentifier", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.guardrailVersion = software.amazon.jsii.Kernel.get(this, "guardrailVersion", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.guardrailIdentifier = builder.guardrailIdentifier;
                this.guardrailVersion = builder.guardrailVersion;
            }

            @Override
            public final java.lang.String getGuardrailIdentifier() {
                return this.guardrailIdentifier;
            }

            @Override
            public final java.lang.String getGuardrailVersion() {
                return this.guardrailVersion;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getGuardrailIdentifier() != null) {
                    data.set("guardrailIdentifier", om.valueToTree(this.getGuardrailIdentifier()));
                }
                if (this.getGuardrailVersion() != null) {
                    data.set("guardrailVersion", om.valueToTree(this.getGuardrailVersion()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_bedrock.CfnFlow.GuardrailConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                GuardrailConfigurationProperty.Jsii$Proxy that = (GuardrailConfigurationProperty.Jsii$Proxy) o;

                if (this.guardrailIdentifier != null ? !this.guardrailIdentifier.equals(that.guardrailIdentifier) : that.guardrailIdentifier != null) return false;
                return this.guardrailVersion != null ? this.guardrailVersion.equals(that.guardrailVersion) : that.guardrailVersion == null;
            }

            @Override
            public final int hashCode() {
                int result = this.guardrailIdentifier != null ? this.guardrailIdentifier.hashCode() : 0;
                result = 31 * result + (this.guardrailVersion != null ? this.guardrailVersion.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Contains configurations for a knowledge base node in a flow.
     * <p>
     * This node takes a query as the input and returns, as the output, the retrieved responses directly (as an array) or a response generated based on the retrieved responses. For more information, see <a href="https://docs.aws.amazon.com/bedrock/latest/userguide/flows-nodes.html">Node types in Amazon Bedrock works</a> in the Amazon Bedrock User Guide.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.bedrock.*;
     * KnowledgeBaseFlowNodeConfigurationProperty knowledgeBaseFlowNodeConfigurationProperty = KnowledgeBaseFlowNodeConfigurationProperty.builder()
     *         .knowledgeBaseId("knowledgeBaseId")
     *         // the properties below are optional
     *         .guardrailConfiguration(GuardrailConfigurationProperty.builder()
     *                 .guardrailIdentifier("guardrailIdentifier")
     *                 .guardrailVersion("guardrailVersion")
     *                 .build())
     *         .modelId("modelId")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-flow-knowledgebaseflownodeconfiguration.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-flow-knowledgebaseflownodeconfiguration.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_bedrock.CfnFlow.KnowledgeBaseFlowNodeConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(KnowledgeBaseFlowNodeConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface KnowledgeBaseFlowNodeConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The unique identifier of the knowledge base to query.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-flow-knowledgebaseflownodeconfiguration.html#cfn-bedrock-flow-knowledgebaseflownodeconfiguration-knowledgebaseid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-flow-knowledgebaseflownodeconfiguration.html#cfn-bedrock-flow-knowledgebaseflownodeconfiguration-knowledgebaseid</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getKnowledgeBaseId();

        /**
         * Contains configurations for a guardrail to apply during query and response generation for the knowledge base in this configuration.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-flow-knowledgebaseflownodeconfiguration.html#cfn-bedrock-flow-knowledgebaseflownodeconfiguration-guardrailconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-flow-knowledgebaseflownodeconfiguration.html#cfn-bedrock-flow-knowledgebaseflownodeconfiguration-guardrailconfiguration</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getGuardrailConfiguration() {
            return null;
        }

        /**
         * The unique identifier of the model or <a href="https://docs.aws.amazon.com/bedrock/latest/userguide/cross-region-inference.html">inference profile</a> to use to generate a response from the query results. Omit this field if you want to return the retrieved results as an array.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-flow-knowledgebaseflownodeconfiguration.html#cfn-bedrock-flow-knowledgebaseflownodeconfiguration-modelid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-flow-knowledgebaseflownodeconfiguration.html#cfn-bedrock-flow-knowledgebaseflownodeconfiguration-modelid</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getModelId() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link KnowledgeBaseFlowNodeConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link KnowledgeBaseFlowNodeConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<KnowledgeBaseFlowNodeConfigurationProperty> {
            java.lang.String knowledgeBaseId;
            java.lang.Object guardrailConfiguration;
            java.lang.String modelId;

            /**
             * Sets the value of {@link KnowledgeBaseFlowNodeConfigurationProperty#getKnowledgeBaseId}
             * @param knowledgeBaseId The unique identifier of the knowledge base to query. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder knowledgeBaseId(java.lang.String knowledgeBaseId) {
                this.knowledgeBaseId = knowledgeBaseId;
                return this;
            }

            /**
             * Sets the value of {@link KnowledgeBaseFlowNodeConfigurationProperty#getGuardrailConfiguration}
             * @param guardrailConfiguration Contains configurations for a guardrail to apply during query and response generation for the knowledge base in this configuration.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder guardrailConfiguration(software.amazon.awscdk.IResolvable guardrailConfiguration) {
                this.guardrailConfiguration = guardrailConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link KnowledgeBaseFlowNodeConfigurationProperty#getGuardrailConfiguration}
             * @param guardrailConfiguration Contains configurations for a guardrail to apply during query and response generation for the knowledge base in this configuration.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder guardrailConfiguration(software.amazon.awscdk.services.bedrock.CfnFlow.GuardrailConfigurationProperty guardrailConfiguration) {
                this.guardrailConfiguration = guardrailConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link KnowledgeBaseFlowNodeConfigurationProperty#getModelId}
             * @param modelId The unique identifier of the model or <a href="https://docs.aws.amazon.com/bedrock/latest/userguide/cross-region-inference.html">inference profile</a> to use to generate a response from the query results. Omit this field if you want to return the retrieved results as an array.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder modelId(java.lang.String modelId) {
                this.modelId = modelId;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link KnowledgeBaseFlowNodeConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public KnowledgeBaseFlowNodeConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link KnowledgeBaseFlowNodeConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements KnowledgeBaseFlowNodeConfigurationProperty {
            private final java.lang.String knowledgeBaseId;
            private final java.lang.Object guardrailConfiguration;
            private final java.lang.String modelId;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.knowledgeBaseId = software.amazon.jsii.Kernel.get(this, "knowledgeBaseId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.guardrailConfiguration = software.amazon.jsii.Kernel.get(this, "guardrailConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.modelId = software.amazon.jsii.Kernel.get(this, "modelId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.knowledgeBaseId = java.util.Objects.requireNonNull(builder.knowledgeBaseId, "knowledgeBaseId is required");
                this.guardrailConfiguration = builder.guardrailConfiguration;
                this.modelId = builder.modelId;
            }

            @Override
            public final java.lang.String getKnowledgeBaseId() {
                return this.knowledgeBaseId;
            }

            @Override
            public final java.lang.Object getGuardrailConfiguration() {
                return this.guardrailConfiguration;
            }

            @Override
            public final java.lang.String getModelId() {
                return this.modelId;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("knowledgeBaseId", om.valueToTree(this.getKnowledgeBaseId()));
                if (this.getGuardrailConfiguration() != null) {
                    data.set("guardrailConfiguration", om.valueToTree(this.getGuardrailConfiguration()));
                }
                if (this.getModelId() != null) {
                    data.set("modelId", om.valueToTree(this.getModelId()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_bedrock.CfnFlow.KnowledgeBaseFlowNodeConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                KnowledgeBaseFlowNodeConfigurationProperty.Jsii$Proxy that = (KnowledgeBaseFlowNodeConfigurationProperty.Jsii$Proxy) o;

                if (!knowledgeBaseId.equals(that.knowledgeBaseId)) return false;
                if (this.guardrailConfiguration != null ? !this.guardrailConfiguration.equals(that.guardrailConfiguration) : that.guardrailConfiguration != null) return false;
                return this.modelId != null ? this.modelId.equals(that.modelId) : that.modelId == null;
            }

            @Override
            public final int hashCode() {
                int result = this.knowledgeBaseId.hashCode();
                result = 31 * result + (this.guardrailConfiguration != null ? this.guardrailConfiguration.hashCode() : 0);
                result = 31 * result + (this.modelId != null ? this.modelId.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Contains configurations for a Lambda function node in the flow.
     * <p>
     * You specify the Lambda function to invoke and the inputs into the function. The output is the response that is defined in the Lambda function. For more information, see <a href="https://docs.aws.amazon.com/bedrock/latest/userguide/flows-nodes.html">Node types in Amazon Bedrock works</a> in the Amazon Bedrock User Guide.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.bedrock.*;
     * LambdaFunctionFlowNodeConfigurationProperty lambdaFunctionFlowNodeConfigurationProperty = LambdaFunctionFlowNodeConfigurationProperty.builder()
     *         .lambdaArn("lambdaArn")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-flow-lambdafunctionflownodeconfiguration.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-flow-lambdafunctionflownodeconfiguration.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_bedrock.CfnFlow.LambdaFunctionFlowNodeConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(LambdaFunctionFlowNodeConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface LambdaFunctionFlowNodeConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The Amazon Resource Name (ARN) of the Lambda function to invoke.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-flow-lambdafunctionflownodeconfiguration.html#cfn-bedrock-flow-lambdafunctionflownodeconfiguration-lambdaarn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-flow-lambdafunctionflownodeconfiguration.html#cfn-bedrock-flow-lambdafunctionflownodeconfiguration-lambdaarn</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getLambdaArn();

        /**
         * @return a {@link Builder} of {@link LambdaFunctionFlowNodeConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link LambdaFunctionFlowNodeConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<LambdaFunctionFlowNodeConfigurationProperty> {
            java.lang.String lambdaArn;

            /**
             * Sets the value of {@link LambdaFunctionFlowNodeConfigurationProperty#getLambdaArn}
             * @param lambdaArn The Amazon Resource Name (ARN) of the Lambda function to invoke. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder lambdaArn(java.lang.String lambdaArn) {
                this.lambdaArn = lambdaArn;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link LambdaFunctionFlowNodeConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public LambdaFunctionFlowNodeConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link LambdaFunctionFlowNodeConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements LambdaFunctionFlowNodeConfigurationProperty {
            private final java.lang.String lambdaArn;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.lambdaArn = software.amazon.jsii.Kernel.get(this, "lambdaArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.lambdaArn = java.util.Objects.requireNonNull(builder.lambdaArn, "lambdaArn is required");
            }

            @Override
            public final java.lang.String getLambdaArn() {
                return this.lambdaArn;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("lambdaArn", om.valueToTree(this.getLambdaArn()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_bedrock.CfnFlow.LambdaFunctionFlowNodeConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                LambdaFunctionFlowNodeConfigurationProperty.Jsii$Proxy that = (LambdaFunctionFlowNodeConfigurationProperty.Jsii$Proxy) o;

                return this.lambdaArn.equals(that.lambdaArn);
            }

            @Override
            public final int hashCode() {
                int result = this.lambdaArn.hashCode();
                return result;
            }
        }
    }
    /**
     * Contains configurations for a Lex node in the flow.
     * <p>
     * You specify a Amazon Lex bot to invoke. This node takes an utterance as the input and returns as the output the intent identified by the Amazon Lex bot. For more information, see <a href="https://docs.aws.amazon.com/bedrock/latest/userguide/flows-nodes.html">Node types in Amazon Bedrock works</a> in the Amazon Bedrock User Guide.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.bedrock.*;
     * LexFlowNodeConfigurationProperty lexFlowNodeConfigurationProperty = LexFlowNodeConfigurationProperty.builder()
     *         .botAliasArn("botAliasArn")
     *         .localeId("localeId")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-flow-lexflownodeconfiguration.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-flow-lexflownodeconfiguration.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_bedrock.CfnFlow.LexFlowNodeConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(LexFlowNodeConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface LexFlowNodeConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The Amazon Resource Name (ARN) of the Amazon Lex bot alias to invoke.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-flow-lexflownodeconfiguration.html#cfn-bedrock-flow-lexflownodeconfiguration-botaliasarn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-flow-lexflownodeconfiguration.html#cfn-bedrock-flow-lexflownodeconfiguration-botaliasarn</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getBotAliasArn();

        /**
         * The Region to invoke the Amazon Lex bot in.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-flow-lexflownodeconfiguration.html#cfn-bedrock-flow-lexflownodeconfiguration-localeid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-flow-lexflownodeconfiguration.html#cfn-bedrock-flow-lexflownodeconfiguration-localeid</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getLocaleId();

        /**
         * @return a {@link Builder} of {@link LexFlowNodeConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link LexFlowNodeConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<LexFlowNodeConfigurationProperty> {
            java.lang.String botAliasArn;
            java.lang.String localeId;

            /**
             * Sets the value of {@link LexFlowNodeConfigurationProperty#getBotAliasArn}
             * @param botAliasArn The Amazon Resource Name (ARN) of the Amazon Lex bot alias to invoke. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder botAliasArn(java.lang.String botAliasArn) {
                this.botAliasArn = botAliasArn;
                return this;
            }

            /**
             * Sets the value of {@link LexFlowNodeConfigurationProperty#getLocaleId}
             * @param localeId The Region to invoke the Amazon Lex bot in. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder localeId(java.lang.String localeId) {
                this.localeId = localeId;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link LexFlowNodeConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public LexFlowNodeConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link LexFlowNodeConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements LexFlowNodeConfigurationProperty {
            private final java.lang.String botAliasArn;
            private final java.lang.String localeId;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.botAliasArn = software.amazon.jsii.Kernel.get(this, "botAliasArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.localeId = software.amazon.jsii.Kernel.get(this, "localeId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.botAliasArn = java.util.Objects.requireNonNull(builder.botAliasArn, "botAliasArn is required");
                this.localeId = java.util.Objects.requireNonNull(builder.localeId, "localeId is required");
            }

            @Override
            public final java.lang.String getBotAliasArn() {
                return this.botAliasArn;
            }

            @Override
            public final java.lang.String getLocaleId() {
                return this.localeId;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("botAliasArn", om.valueToTree(this.getBotAliasArn()));
                data.set("localeId", om.valueToTree(this.getLocaleId()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_bedrock.CfnFlow.LexFlowNodeConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                LexFlowNodeConfigurationProperty.Jsii$Proxy that = (LexFlowNodeConfigurationProperty.Jsii$Proxy) o;

                if (!botAliasArn.equals(that.botAliasArn)) return false;
                return this.localeId.equals(that.localeId);
            }

            @Override
            public final int hashCode() {
                int result = this.botAliasArn.hashCode();
                result = 31 * result + (this.localeId.hashCode());
                return result;
            }
        }
    }
    /**
     * Contains configurations for a prompt node in the flow.
     * <p>
     * You can use a prompt from Prompt management or you can define one in this node. If the prompt contains variables, the inputs into this node will fill in the variables. The output from this node is the response generated by the model. For more information, see <a href="https://docs.aws.amazon.com/bedrock/latest/userguide/flows-nodes.html">Node types in Amazon Bedrock works</a> in the Amazon Bedrock User Guide.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.bedrock.*;
     * PromptFlowNodeConfigurationProperty promptFlowNodeConfigurationProperty = PromptFlowNodeConfigurationProperty.builder()
     *         .sourceConfiguration(PromptFlowNodeSourceConfigurationProperty.builder()
     *                 .inline(PromptFlowNodeInlineConfigurationProperty.builder()
     *                         .modelId("modelId")
     *                         .templateConfiguration(PromptTemplateConfigurationProperty.builder()
     *                                 .text(TextPromptTemplateConfigurationProperty.builder()
     *                                         .text("text")
     *                                         // the properties below are optional
     *                                         .inputVariables(List.of(PromptInputVariableProperty.builder()
     *                                                 .name("name")
     *                                                 .build()))
     *                                         .build())
     *                                 .build())
     *                         .templateType("templateType")
     *                         // the properties below are optional
     *                         .inferenceConfiguration(PromptInferenceConfigurationProperty.builder()
     *                                 .text(PromptModelInferenceConfigurationProperty.builder()
     *                                         .maxTokens(123)
     *                                         .stopSequences(List.of("stopSequences"))
     *                                         .temperature(123)
     *                                         .topP(123)
     *                                         .build())
     *                                 .build())
     *                         .build())
     *                 .resource(PromptFlowNodeResourceConfigurationProperty.builder()
     *                         .promptArn("promptArn")
     *                         .build())
     *                 .build())
     *         // the properties below are optional
     *         .guardrailConfiguration(GuardrailConfigurationProperty.builder()
     *                 .guardrailIdentifier("guardrailIdentifier")
     *                 .guardrailVersion("guardrailVersion")
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-flow-promptflownodeconfiguration.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-flow-promptflownodeconfiguration.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_bedrock.CfnFlow.PromptFlowNodeConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(PromptFlowNodeConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface PromptFlowNodeConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Specifies whether the prompt is from Prompt management or defined inline.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-flow-promptflownodeconfiguration.html#cfn-bedrock-flow-promptflownodeconfiguration-sourceconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-flow-promptflownodeconfiguration.html#cfn-bedrock-flow-promptflownodeconfiguration-sourceconfiguration</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getSourceConfiguration();

        /**
         * Contains configurations for a guardrail to apply to the prompt in this node and the response generated from it.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-flow-promptflownodeconfiguration.html#cfn-bedrock-flow-promptflownodeconfiguration-guardrailconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-flow-promptflownodeconfiguration.html#cfn-bedrock-flow-promptflownodeconfiguration-guardrailconfiguration</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getGuardrailConfiguration() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link PromptFlowNodeConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link PromptFlowNodeConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<PromptFlowNodeConfigurationProperty> {
            java.lang.Object sourceConfiguration;
            java.lang.Object guardrailConfiguration;

            /**
             * Sets the value of {@link PromptFlowNodeConfigurationProperty#getSourceConfiguration}
             * @param sourceConfiguration Specifies whether the prompt is from Prompt management or defined inline. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder sourceConfiguration(software.amazon.awscdk.IResolvable sourceConfiguration) {
                this.sourceConfiguration = sourceConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link PromptFlowNodeConfigurationProperty#getSourceConfiguration}
             * @param sourceConfiguration Specifies whether the prompt is from Prompt management or defined inline. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder sourceConfiguration(software.amazon.awscdk.services.bedrock.CfnFlow.PromptFlowNodeSourceConfigurationProperty sourceConfiguration) {
                this.sourceConfiguration = sourceConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link PromptFlowNodeConfigurationProperty#getGuardrailConfiguration}
             * @param guardrailConfiguration Contains configurations for a guardrail to apply to the prompt in this node and the response generated from it.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder guardrailConfiguration(software.amazon.awscdk.IResolvable guardrailConfiguration) {
                this.guardrailConfiguration = guardrailConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link PromptFlowNodeConfigurationProperty#getGuardrailConfiguration}
             * @param guardrailConfiguration Contains configurations for a guardrail to apply to the prompt in this node and the response generated from it.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder guardrailConfiguration(software.amazon.awscdk.services.bedrock.CfnFlow.GuardrailConfigurationProperty guardrailConfiguration) {
                this.guardrailConfiguration = guardrailConfiguration;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link PromptFlowNodeConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public PromptFlowNodeConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link PromptFlowNodeConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements PromptFlowNodeConfigurationProperty {
            private final java.lang.Object sourceConfiguration;
            private final java.lang.Object guardrailConfiguration;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.sourceConfiguration = software.amazon.jsii.Kernel.get(this, "sourceConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.guardrailConfiguration = software.amazon.jsii.Kernel.get(this, "guardrailConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.sourceConfiguration = java.util.Objects.requireNonNull(builder.sourceConfiguration, "sourceConfiguration is required");
                this.guardrailConfiguration = builder.guardrailConfiguration;
            }

            @Override
            public final java.lang.Object getSourceConfiguration() {
                return this.sourceConfiguration;
            }

            @Override
            public final java.lang.Object getGuardrailConfiguration() {
                return this.guardrailConfiguration;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("sourceConfiguration", om.valueToTree(this.getSourceConfiguration()));
                if (this.getGuardrailConfiguration() != null) {
                    data.set("guardrailConfiguration", om.valueToTree(this.getGuardrailConfiguration()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_bedrock.CfnFlow.PromptFlowNodeConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                PromptFlowNodeConfigurationProperty.Jsii$Proxy that = (PromptFlowNodeConfigurationProperty.Jsii$Proxy) o;

                if (!sourceConfiguration.equals(that.sourceConfiguration)) return false;
                return this.guardrailConfiguration != null ? this.guardrailConfiguration.equals(that.guardrailConfiguration) : that.guardrailConfiguration == null;
            }

            @Override
            public final int hashCode() {
                int result = this.sourceConfiguration.hashCode();
                result = 31 * result + (this.guardrailConfiguration != null ? this.guardrailConfiguration.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Contains configurations for a prompt defined inline in the node.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.bedrock.*;
     * PromptFlowNodeInlineConfigurationProperty promptFlowNodeInlineConfigurationProperty = PromptFlowNodeInlineConfigurationProperty.builder()
     *         .modelId("modelId")
     *         .templateConfiguration(PromptTemplateConfigurationProperty.builder()
     *                 .text(TextPromptTemplateConfigurationProperty.builder()
     *                         .text("text")
     *                         // the properties below are optional
     *                         .inputVariables(List.of(PromptInputVariableProperty.builder()
     *                                 .name("name")
     *                                 .build()))
     *                         .build())
     *                 .build())
     *         .templateType("templateType")
     *         // the properties below are optional
     *         .inferenceConfiguration(PromptInferenceConfigurationProperty.builder()
     *                 .text(PromptModelInferenceConfigurationProperty.builder()
     *                         .maxTokens(123)
     *                         .stopSequences(List.of("stopSequences"))
     *                         .temperature(123)
     *                         .topP(123)
     *                         .build())
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-flow-promptflownodeinlineconfiguration.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-flow-promptflownodeinlineconfiguration.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_bedrock.CfnFlow.PromptFlowNodeInlineConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(PromptFlowNodeInlineConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface PromptFlowNodeInlineConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The unique identifier of the model or <a href="https://docs.aws.amazon.com/bedrock/latest/userguide/cross-region-inference.html">inference profile</a> to run inference with.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-flow-promptflownodeinlineconfiguration.html#cfn-bedrock-flow-promptflownodeinlineconfiguration-modelid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-flow-promptflownodeinlineconfiguration.html#cfn-bedrock-flow-promptflownodeinlineconfiguration-modelid</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getModelId();

        /**
         * Contains a prompt and variables in the prompt that can be replaced with values at runtime.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-flow-promptflownodeinlineconfiguration.html#cfn-bedrock-flow-promptflownodeinlineconfiguration-templateconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-flow-promptflownodeinlineconfiguration.html#cfn-bedrock-flow-promptflownodeinlineconfiguration-templateconfiguration</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getTemplateConfiguration();

        /**
         * The type of prompt template.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-flow-promptflownodeinlineconfiguration.html#cfn-bedrock-flow-promptflownodeinlineconfiguration-templatetype">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-flow-promptflownodeinlineconfiguration.html#cfn-bedrock-flow-promptflownodeinlineconfiguration-templatetype</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getTemplateType();

        /**
         * Contains inference configurations for the prompt.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-flow-promptflownodeinlineconfiguration.html#cfn-bedrock-flow-promptflownodeinlineconfiguration-inferenceconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-flow-promptflownodeinlineconfiguration.html#cfn-bedrock-flow-promptflownodeinlineconfiguration-inferenceconfiguration</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getInferenceConfiguration() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link PromptFlowNodeInlineConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link PromptFlowNodeInlineConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<PromptFlowNodeInlineConfigurationProperty> {
            java.lang.String modelId;
            java.lang.Object templateConfiguration;
            java.lang.String templateType;
            java.lang.Object inferenceConfiguration;

            /**
             * Sets the value of {@link PromptFlowNodeInlineConfigurationProperty#getModelId}
             * @param modelId The unique identifier of the model or <a href="https://docs.aws.amazon.com/bedrock/latest/userguide/cross-region-inference.html">inference profile</a> to run inference with. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder modelId(java.lang.String modelId) {
                this.modelId = modelId;
                return this;
            }

            /**
             * Sets the value of {@link PromptFlowNodeInlineConfigurationProperty#getTemplateConfiguration}
             * @param templateConfiguration Contains a prompt and variables in the prompt that can be replaced with values at runtime. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder templateConfiguration(software.amazon.awscdk.IResolvable templateConfiguration) {
                this.templateConfiguration = templateConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link PromptFlowNodeInlineConfigurationProperty#getTemplateConfiguration}
             * @param templateConfiguration Contains a prompt and variables in the prompt that can be replaced with values at runtime. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder templateConfiguration(software.amazon.awscdk.services.bedrock.CfnFlow.PromptTemplateConfigurationProperty templateConfiguration) {
                this.templateConfiguration = templateConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link PromptFlowNodeInlineConfigurationProperty#getTemplateType}
             * @param templateType The type of prompt template. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder templateType(java.lang.String templateType) {
                this.templateType = templateType;
                return this;
            }

            /**
             * Sets the value of {@link PromptFlowNodeInlineConfigurationProperty#getInferenceConfiguration}
             * @param inferenceConfiguration Contains inference configurations for the prompt.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder inferenceConfiguration(software.amazon.awscdk.IResolvable inferenceConfiguration) {
                this.inferenceConfiguration = inferenceConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link PromptFlowNodeInlineConfigurationProperty#getInferenceConfiguration}
             * @param inferenceConfiguration Contains inference configurations for the prompt.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder inferenceConfiguration(software.amazon.awscdk.services.bedrock.CfnFlow.PromptInferenceConfigurationProperty inferenceConfiguration) {
                this.inferenceConfiguration = inferenceConfiguration;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link PromptFlowNodeInlineConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public PromptFlowNodeInlineConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link PromptFlowNodeInlineConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements PromptFlowNodeInlineConfigurationProperty {
            private final java.lang.String modelId;
            private final java.lang.Object templateConfiguration;
            private final java.lang.String templateType;
            private final java.lang.Object inferenceConfiguration;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.modelId = software.amazon.jsii.Kernel.get(this, "modelId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.templateConfiguration = software.amazon.jsii.Kernel.get(this, "templateConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.templateType = software.amazon.jsii.Kernel.get(this, "templateType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.inferenceConfiguration = software.amazon.jsii.Kernel.get(this, "inferenceConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.modelId = java.util.Objects.requireNonNull(builder.modelId, "modelId is required");
                this.templateConfiguration = java.util.Objects.requireNonNull(builder.templateConfiguration, "templateConfiguration is required");
                this.templateType = java.util.Objects.requireNonNull(builder.templateType, "templateType is required");
                this.inferenceConfiguration = builder.inferenceConfiguration;
            }

            @Override
            public final java.lang.String getModelId() {
                return this.modelId;
            }

            @Override
            public final java.lang.Object getTemplateConfiguration() {
                return this.templateConfiguration;
            }

            @Override
            public final java.lang.String getTemplateType() {
                return this.templateType;
            }

            @Override
            public final java.lang.Object getInferenceConfiguration() {
                return this.inferenceConfiguration;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("modelId", om.valueToTree(this.getModelId()));
                data.set("templateConfiguration", om.valueToTree(this.getTemplateConfiguration()));
                data.set("templateType", om.valueToTree(this.getTemplateType()));
                if (this.getInferenceConfiguration() != null) {
                    data.set("inferenceConfiguration", om.valueToTree(this.getInferenceConfiguration()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_bedrock.CfnFlow.PromptFlowNodeInlineConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                PromptFlowNodeInlineConfigurationProperty.Jsii$Proxy that = (PromptFlowNodeInlineConfigurationProperty.Jsii$Proxy) o;

                if (!modelId.equals(that.modelId)) return false;
                if (!templateConfiguration.equals(that.templateConfiguration)) return false;
                if (!templateType.equals(that.templateType)) return false;
                return this.inferenceConfiguration != null ? this.inferenceConfiguration.equals(that.inferenceConfiguration) : that.inferenceConfiguration == null;
            }

            @Override
            public final int hashCode() {
                int result = this.modelId.hashCode();
                result = 31 * result + (this.templateConfiguration.hashCode());
                result = 31 * result + (this.templateType.hashCode());
                result = 31 * result + (this.inferenceConfiguration != null ? this.inferenceConfiguration.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Contains configurations for a prompt from Prompt management to use in a node.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.bedrock.*;
     * PromptFlowNodeResourceConfigurationProperty promptFlowNodeResourceConfigurationProperty = PromptFlowNodeResourceConfigurationProperty.builder()
     *         .promptArn("promptArn")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-flow-promptflownoderesourceconfiguration.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-flow-promptflownoderesourceconfiguration.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_bedrock.CfnFlow.PromptFlowNodeResourceConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(PromptFlowNodeResourceConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface PromptFlowNodeResourceConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The Amazon Resource Name (ARN) of the prompt from Prompt management.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-flow-promptflownoderesourceconfiguration.html#cfn-bedrock-flow-promptflownoderesourceconfiguration-promptarn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-flow-promptflownoderesourceconfiguration.html#cfn-bedrock-flow-promptflownoderesourceconfiguration-promptarn</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getPromptArn();

        /**
         * @return a {@link Builder} of {@link PromptFlowNodeResourceConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link PromptFlowNodeResourceConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<PromptFlowNodeResourceConfigurationProperty> {
            java.lang.String promptArn;

            /**
             * Sets the value of {@link PromptFlowNodeResourceConfigurationProperty#getPromptArn}
             * @param promptArn The Amazon Resource Name (ARN) of the prompt from Prompt management. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder promptArn(java.lang.String promptArn) {
                this.promptArn = promptArn;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link PromptFlowNodeResourceConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public PromptFlowNodeResourceConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link PromptFlowNodeResourceConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements PromptFlowNodeResourceConfigurationProperty {
            private final java.lang.String promptArn;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.promptArn = software.amazon.jsii.Kernel.get(this, "promptArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.promptArn = java.util.Objects.requireNonNull(builder.promptArn, "promptArn is required");
            }

            @Override
            public final java.lang.String getPromptArn() {
                return this.promptArn;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("promptArn", om.valueToTree(this.getPromptArn()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_bedrock.CfnFlow.PromptFlowNodeResourceConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                PromptFlowNodeResourceConfigurationProperty.Jsii$Proxy that = (PromptFlowNodeResourceConfigurationProperty.Jsii$Proxy) o;

                return this.promptArn.equals(that.promptArn);
            }

            @Override
            public final int hashCode() {
                int result = this.promptArn.hashCode();
                return result;
            }
        }
    }
    /**
     * Contains configurations for a prompt and whether it is from Prompt management or defined inline.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.bedrock.*;
     * PromptFlowNodeSourceConfigurationProperty promptFlowNodeSourceConfigurationProperty = PromptFlowNodeSourceConfigurationProperty.builder()
     *         .inline(PromptFlowNodeInlineConfigurationProperty.builder()
     *                 .modelId("modelId")
     *                 .templateConfiguration(PromptTemplateConfigurationProperty.builder()
     *                         .text(TextPromptTemplateConfigurationProperty.builder()
     *                                 .text("text")
     *                                 // the properties below are optional
     *                                 .inputVariables(List.of(PromptInputVariableProperty.builder()
     *                                         .name("name")
     *                                         .build()))
     *                                 .build())
     *                         .build())
     *                 .templateType("templateType")
     *                 // the properties below are optional
     *                 .inferenceConfiguration(PromptInferenceConfigurationProperty.builder()
     *                         .text(PromptModelInferenceConfigurationProperty.builder()
     *                                 .maxTokens(123)
     *                                 .stopSequences(List.of("stopSequences"))
     *                                 .temperature(123)
     *                                 .topP(123)
     *                                 .build())
     *                         .build())
     *                 .build())
     *         .resource(PromptFlowNodeResourceConfigurationProperty.builder()
     *                 .promptArn("promptArn")
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-flow-promptflownodesourceconfiguration.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-flow-promptflownodesourceconfiguration.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_bedrock.CfnFlow.PromptFlowNodeSourceConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(PromptFlowNodeSourceConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface PromptFlowNodeSourceConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Contains configurations for a prompt that is defined inline.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-flow-promptflownodesourceconfiguration.html#cfn-bedrock-flow-promptflownodesourceconfiguration-inline">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-flow-promptflownodesourceconfiguration.html#cfn-bedrock-flow-promptflownodesourceconfiguration-inline</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getInline() {
            return null;
        }

        /**
         * Contains configurations for a prompt from Prompt management.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-flow-promptflownodesourceconfiguration.html#cfn-bedrock-flow-promptflownodesourceconfiguration-resource">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-flow-promptflownodesourceconfiguration.html#cfn-bedrock-flow-promptflownodesourceconfiguration-resource</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getResource() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link PromptFlowNodeSourceConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link PromptFlowNodeSourceConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<PromptFlowNodeSourceConfigurationProperty> {
            java.lang.Object inline;
            java.lang.Object resource;

            /**
             * Sets the value of {@link PromptFlowNodeSourceConfigurationProperty#getInline}
             * @param inline Contains configurations for a prompt that is defined inline.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder inline(software.amazon.awscdk.IResolvable inline) {
                this.inline = inline;
                return this;
            }

            /**
             * Sets the value of {@link PromptFlowNodeSourceConfigurationProperty#getInline}
             * @param inline Contains configurations for a prompt that is defined inline.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder inline(software.amazon.awscdk.services.bedrock.CfnFlow.PromptFlowNodeInlineConfigurationProperty inline) {
                this.inline = inline;
                return this;
            }

            /**
             * Sets the value of {@link PromptFlowNodeSourceConfigurationProperty#getResource}
             * @param resource Contains configurations for a prompt from Prompt management.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder resource(software.amazon.awscdk.IResolvable resource) {
                this.resource = resource;
                return this;
            }

            /**
             * Sets the value of {@link PromptFlowNodeSourceConfigurationProperty#getResource}
             * @param resource Contains configurations for a prompt from Prompt management.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder resource(software.amazon.awscdk.services.bedrock.CfnFlow.PromptFlowNodeResourceConfigurationProperty resource) {
                this.resource = resource;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link PromptFlowNodeSourceConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public PromptFlowNodeSourceConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link PromptFlowNodeSourceConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements PromptFlowNodeSourceConfigurationProperty {
            private final java.lang.Object inline;
            private final java.lang.Object resource;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.inline = software.amazon.jsii.Kernel.get(this, "inline", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.resource = software.amazon.jsii.Kernel.get(this, "resource", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.inline = builder.inline;
                this.resource = builder.resource;
            }

            @Override
            public final java.lang.Object getInline() {
                return this.inline;
            }

            @Override
            public final java.lang.Object getResource() {
                return this.resource;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getInline() != null) {
                    data.set("inline", om.valueToTree(this.getInline()));
                }
                if (this.getResource() != null) {
                    data.set("resource", om.valueToTree(this.getResource()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_bedrock.CfnFlow.PromptFlowNodeSourceConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                PromptFlowNodeSourceConfigurationProperty.Jsii$Proxy that = (PromptFlowNodeSourceConfigurationProperty.Jsii$Proxy) o;

                if (this.inline != null ? !this.inline.equals(that.inline) : that.inline != null) return false;
                return this.resource != null ? this.resource.equals(that.resource) : that.resource == null;
            }

            @Override
            public final int hashCode() {
                int result = this.inline != null ? this.inline.hashCode() : 0;
                result = 31 * result + (this.resource != null ? this.resource.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Contains inference configurations for the prompt.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.bedrock.*;
     * PromptInferenceConfigurationProperty promptInferenceConfigurationProperty = PromptInferenceConfigurationProperty.builder()
     *         .text(PromptModelInferenceConfigurationProperty.builder()
     *                 .maxTokens(123)
     *                 .stopSequences(List.of("stopSequences"))
     *                 .temperature(123)
     *                 .topP(123)
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-flow-promptinferenceconfiguration.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-flow-promptinferenceconfiguration.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_bedrock.CfnFlow.PromptInferenceConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(PromptInferenceConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface PromptInferenceConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Contains inference configurations for a text prompt.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-flow-promptinferenceconfiguration.html#cfn-bedrock-flow-promptinferenceconfiguration-text">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-flow-promptinferenceconfiguration.html#cfn-bedrock-flow-promptinferenceconfiguration-text</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getText();

        /**
         * @return a {@link Builder} of {@link PromptInferenceConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link PromptInferenceConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<PromptInferenceConfigurationProperty> {
            java.lang.Object text;

            /**
             * Sets the value of {@link PromptInferenceConfigurationProperty#getText}
             * @param text Contains inference configurations for a text prompt. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder text(software.amazon.awscdk.IResolvable text) {
                this.text = text;
                return this;
            }

            /**
             * Sets the value of {@link PromptInferenceConfigurationProperty#getText}
             * @param text Contains inference configurations for a text prompt. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder text(software.amazon.awscdk.services.bedrock.CfnFlow.PromptModelInferenceConfigurationProperty text) {
                this.text = text;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link PromptInferenceConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public PromptInferenceConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link PromptInferenceConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements PromptInferenceConfigurationProperty {
            private final java.lang.Object text;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.text = software.amazon.jsii.Kernel.get(this, "text", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.text = java.util.Objects.requireNonNull(builder.text, "text is required");
            }

            @Override
            public final java.lang.Object getText() {
                return this.text;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("text", om.valueToTree(this.getText()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_bedrock.CfnFlow.PromptInferenceConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                PromptInferenceConfigurationProperty.Jsii$Proxy that = (PromptInferenceConfigurationProperty.Jsii$Proxy) o;

                return this.text.equals(that.text);
            }

            @Override
            public final int hashCode() {
                int result = this.text.hashCode();
                return result;
            }
        }
    }
    /**
     * Contains information about a variable in the prompt.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.bedrock.*;
     * PromptInputVariableProperty promptInputVariableProperty = PromptInputVariableProperty.builder()
     *         .name("name")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-flow-promptinputvariable.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-flow-promptinputvariable.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_bedrock.CfnFlow.PromptInputVariableProperty")
    @software.amazon.jsii.Jsii.Proxy(PromptInputVariableProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface PromptInputVariableProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The name of the variable.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-flow-promptinputvariable.html#cfn-bedrock-flow-promptinputvariable-name">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-flow-promptinputvariable.html#cfn-bedrock-flow-promptinputvariable-name</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getName() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link PromptInputVariableProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link PromptInputVariableProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<PromptInputVariableProperty> {
            java.lang.String name;

            /**
             * Sets the value of {@link PromptInputVariableProperty#getName}
             * @param name The name of the variable.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder name(java.lang.String name) {
                this.name = name;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link PromptInputVariableProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public PromptInputVariableProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link PromptInputVariableProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements PromptInputVariableProperty {
            private final java.lang.String name;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.name = builder.name;
            }

            @Override
            public final java.lang.String getName() {
                return this.name;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getName() != null) {
                    data.set("name", om.valueToTree(this.getName()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_bedrock.CfnFlow.PromptInputVariableProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                PromptInputVariableProperty.Jsii$Proxy that = (PromptInputVariableProperty.Jsii$Proxy) o;

                return this.name != null ? this.name.equals(that.name) : that.name == null;
            }

            @Override
            public final int hashCode() {
                int result = this.name != null ? this.name.hashCode() : 0;
                return result;
            }
        }
    }
    /**
     * Contains inference configurations related to model inference for a prompt.
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/bedrock/latest/userguide/inference-parameters.html">Inference parameters</a> .
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.bedrock.*;
     * PromptModelInferenceConfigurationProperty promptModelInferenceConfigurationProperty = PromptModelInferenceConfigurationProperty.builder()
     *         .maxTokens(123)
     *         .stopSequences(List.of("stopSequences"))
     *         .temperature(123)
     *         .topP(123)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-flow-promptmodelinferenceconfiguration.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-flow-promptmodelinferenceconfiguration.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_bedrock.CfnFlow.PromptModelInferenceConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(PromptModelInferenceConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface PromptModelInferenceConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The maximum number of tokens to return in the response.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-flow-promptmodelinferenceconfiguration.html#cfn-bedrock-flow-promptmodelinferenceconfiguration-maxtokens">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-flow-promptmodelinferenceconfiguration.html#cfn-bedrock-flow-promptmodelinferenceconfiguration-maxtokens</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getMaxTokens() {
            return null;
        }

        /**
         * A list of strings that define sequences after which the model will stop generating.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-flow-promptmodelinferenceconfiguration.html#cfn-bedrock-flow-promptmodelinferenceconfiguration-stopsequences">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-flow-promptmodelinferenceconfiguration.html#cfn-bedrock-flow-promptmodelinferenceconfiguration-stopsequences</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getStopSequences() {
            return null;
        }

        /**
         * Controls the randomness of the response.
         * <p>
         * Choose a lower value for more predictable outputs and a higher value for more surprising outputs.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-flow-promptmodelinferenceconfiguration.html#cfn-bedrock-flow-promptmodelinferenceconfiguration-temperature">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-flow-promptmodelinferenceconfiguration.html#cfn-bedrock-flow-promptmodelinferenceconfiguration-temperature</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getTemperature() {
            return null;
        }

        /**
         * The percentage of most-likely candidates that the model considers for the next token.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-flow-promptmodelinferenceconfiguration.html#cfn-bedrock-flow-promptmodelinferenceconfiguration-topp">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-flow-promptmodelinferenceconfiguration.html#cfn-bedrock-flow-promptmodelinferenceconfiguration-topp</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Number getTopP() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link PromptModelInferenceConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link PromptModelInferenceConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<PromptModelInferenceConfigurationProperty> {
            java.lang.Number maxTokens;
            java.util.List<java.lang.String> stopSequences;
            java.lang.Number temperature;
            java.lang.Number topP;

            /**
             * Sets the value of {@link PromptModelInferenceConfigurationProperty#getMaxTokens}
             * @param maxTokens The maximum number of tokens to return in the response.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder maxTokens(java.lang.Number maxTokens) {
                this.maxTokens = maxTokens;
                return this;
            }

            /**
             * Sets the value of {@link PromptModelInferenceConfigurationProperty#getStopSequences}
             * @param stopSequences A list of strings that define sequences after which the model will stop generating.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder stopSequences(java.util.List<java.lang.String> stopSequences) {
                this.stopSequences = stopSequences;
                return this;
            }

            /**
             * Sets the value of {@link PromptModelInferenceConfigurationProperty#getTemperature}
             * @param temperature Controls the randomness of the response.
             *                    Choose a lower value for more predictable outputs and a higher value for more surprising outputs.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder temperature(java.lang.Number temperature) {
                this.temperature = temperature;
                return this;
            }

            /**
             * Sets the value of {@link PromptModelInferenceConfigurationProperty#getTopP}
             * @param topP The percentage of most-likely candidates that the model considers for the next token.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder topP(java.lang.Number topP) {
                this.topP = topP;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link PromptModelInferenceConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public PromptModelInferenceConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link PromptModelInferenceConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements PromptModelInferenceConfigurationProperty {
            private final java.lang.Number maxTokens;
            private final java.util.List<java.lang.String> stopSequences;
            private final java.lang.Number temperature;
            private final java.lang.Number topP;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.maxTokens = software.amazon.jsii.Kernel.get(this, "maxTokens", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.stopSequences = software.amazon.jsii.Kernel.get(this, "stopSequences", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.temperature = software.amazon.jsii.Kernel.get(this, "temperature", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
                this.topP = software.amazon.jsii.Kernel.get(this, "topP", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.maxTokens = builder.maxTokens;
                this.stopSequences = builder.stopSequences;
                this.temperature = builder.temperature;
                this.topP = builder.topP;
            }

            @Override
            public final java.lang.Number getMaxTokens() {
                return this.maxTokens;
            }

            @Override
            public final java.util.List<java.lang.String> getStopSequences() {
                return this.stopSequences;
            }

            @Override
            public final java.lang.Number getTemperature() {
                return this.temperature;
            }

            @Override
            public final java.lang.Number getTopP() {
                return this.topP;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getMaxTokens() != null) {
                    data.set("maxTokens", om.valueToTree(this.getMaxTokens()));
                }
                if (this.getStopSequences() != null) {
                    data.set("stopSequences", om.valueToTree(this.getStopSequences()));
                }
                if (this.getTemperature() != null) {
                    data.set("temperature", om.valueToTree(this.getTemperature()));
                }
                if (this.getTopP() != null) {
                    data.set("topP", om.valueToTree(this.getTopP()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_bedrock.CfnFlow.PromptModelInferenceConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                PromptModelInferenceConfigurationProperty.Jsii$Proxy that = (PromptModelInferenceConfigurationProperty.Jsii$Proxy) o;

                if (this.maxTokens != null ? !this.maxTokens.equals(that.maxTokens) : that.maxTokens != null) return false;
                if (this.stopSequences != null ? !this.stopSequences.equals(that.stopSequences) : that.stopSequences != null) return false;
                if (this.temperature != null ? !this.temperature.equals(that.temperature) : that.temperature != null) return false;
                return this.topP != null ? this.topP.equals(that.topP) : that.topP == null;
            }

            @Override
            public final int hashCode() {
                int result = this.maxTokens != null ? this.maxTokens.hashCode() : 0;
                result = 31 * result + (this.stopSequences != null ? this.stopSequences.hashCode() : 0);
                result = 31 * result + (this.temperature != null ? this.temperature.hashCode() : 0);
                result = 31 * result + (this.topP != null ? this.topP.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Contains the message for a prompt.
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/bedrock/latest/userguide/prompt-management.html">Construct and store reusable prompts with Prompt management in Amazon Bedrock</a> .
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.bedrock.*;
     * PromptTemplateConfigurationProperty promptTemplateConfigurationProperty = PromptTemplateConfigurationProperty.builder()
     *         .text(TextPromptTemplateConfigurationProperty.builder()
     *                 .text("text")
     *                 // the properties below are optional
     *                 .inputVariables(List.of(PromptInputVariableProperty.builder()
     *                         .name("name")
     *                         .build()))
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-flow-prompttemplateconfiguration.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-flow-prompttemplateconfiguration.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_bedrock.CfnFlow.PromptTemplateConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(PromptTemplateConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface PromptTemplateConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Contains configurations for the text in a message for a prompt.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-flow-prompttemplateconfiguration.html#cfn-bedrock-flow-prompttemplateconfiguration-text">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-flow-prompttemplateconfiguration.html#cfn-bedrock-flow-prompttemplateconfiguration-text</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getText();

        /**
         * @return a {@link Builder} of {@link PromptTemplateConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link PromptTemplateConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<PromptTemplateConfigurationProperty> {
            java.lang.Object text;

            /**
             * Sets the value of {@link PromptTemplateConfigurationProperty#getText}
             * @param text Contains configurations for the text in a message for a prompt. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder text(software.amazon.awscdk.IResolvable text) {
                this.text = text;
                return this;
            }

            /**
             * Sets the value of {@link PromptTemplateConfigurationProperty#getText}
             * @param text Contains configurations for the text in a message for a prompt. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder text(software.amazon.awscdk.services.bedrock.CfnFlow.TextPromptTemplateConfigurationProperty text) {
                this.text = text;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link PromptTemplateConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public PromptTemplateConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link PromptTemplateConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements PromptTemplateConfigurationProperty {
            private final java.lang.Object text;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.text = software.amazon.jsii.Kernel.get(this, "text", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.text = java.util.Objects.requireNonNull(builder.text, "text is required");
            }

            @Override
            public final java.lang.Object getText() {
                return this.text;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("text", om.valueToTree(this.getText()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_bedrock.CfnFlow.PromptTemplateConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                PromptTemplateConfigurationProperty.Jsii$Proxy that = (PromptTemplateConfigurationProperty.Jsii$Proxy) o;

                return this.text.equals(that.text);
            }

            @Override
            public final int hashCode() {
                int result = this.text.hashCode();
                return result;
            }
        }
    }
    /**
     * Contains configurations for a Retrieval node in a flow.
     * <p>
     * This node retrieves data from the Amazon S3 location that you specify and returns it as the output.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.bedrock.*;
     * RetrievalFlowNodeConfigurationProperty retrievalFlowNodeConfigurationProperty = RetrievalFlowNodeConfigurationProperty.builder()
     *         .serviceConfiguration(RetrievalFlowNodeServiceConfigurationProperty.builder()
     *                 .s3(RetrievalFlowNodeS3ConfigurationProperty.builder()
     *                         .bucketName("bucketName")
     *                         .build())
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-flow-retrievalflownodeconfiguration.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-flow-retrievalflownodeconfiguration.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_bedrock.CfnFlow.RetrievalFlowNodeConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(RetrievalFlowNodeConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface RetrievalFlowNodeConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Contains configurations for the service to use for retrieving data to return as the output from the node.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-flow-retrievalflownodeconfiguration.html#cfn-bedrock-flow-retrievalflownodeconfiguration-serviceconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-flow-retrievalflownodeconfiguration.html#cfn-bedrock-flow-retrievalflownodeconfiguration-serviceconfiguration</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getServiceConfiguration();

        /**
         * @return a {@link Builder} of {@link RetrievalFlowNodeConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link RetrievalFlowNodeConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<RetrievalFlowNodeConfigurationProperty> {
            java.lang.Object serviceConfiguration;

            /**
             * Sets the value of {@link RetrievalFlowNodeConfigurationProperty#getServiceConfiguration}
             * @param serviceConfiguration Contains configurations for the service to use for retrieving data to return as the output from the node. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder serviceConfiguration(software.amazon.awscdk.IResolvable serviceConfiguration) {
                this.serviceConfiguration = serviceConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link RetrievalFlowNodeConfigurationProperty#getServiceConfiguration}
             * @param serviceConfiguration Contains configurations for the service to use for retrieving data to return as the output from the node. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder serviceConfiguration(software.amazon.awscdk.services.bedrock.CfnFlow.RetrievalFlowNodeServiceConfigurationProperty serviceConfiguration) {
                this.serviceConfiguration = serviceConfiguration;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link RetrievalFlowNodeConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public RetrievalFlowNodeConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link RetrievalFlowNodeConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements RetrievalFlowNodeConfigurationProperty {
            private final java.lang.Object serviceConfiguration;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.serviceConfiguration = software.amazon.jsii.Kernel.get(this, "serviceConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.serviceConfiguration = java.util.Objects.requireNonNull(builder.serviceConfiguration, "serviceConfiguration is required");
            }

            @Override
            public final java.lang.Object getServiceConfiguration() {
                return this.serviceConfiguration;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("serviceConfiguration", om.valueToTree(this.getServiceConfiguration()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_bedrock.CfnFlow.RetrievalFlowNodeConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                RetrievalFlowNodeConfigurationProperty.Jsii$Proxy that = (RetrievalFlowNodeConfigurationProperty.Jsii$Proxy) o;

                return this.serviceConfiguration.equals(that.serviceConfiguration);
            }

            @Override
            public final int hashCode() {
                int result = this.serviceConfiguration.hashCode();
                return result;
            }
        }
    }
    /**
     * Contains configurations for the Amazon S3 location from which to retrieve data to return as the output from the node.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.bedrock.*;
     * RetrievalFlowNodeS3ConfigurationProperty retrievalFlowNodeS3ConfigurationProperty = RetrievalFlowNodeS3ConfigurationProperty.builder()
     *         .bucketName("bucketName")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-flow-retrievalflownodes3configuration.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-flow-retrievalflownodes3configuration.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_bedrock.CfnFlow.RetrievalFlowNodeS3ConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(RetrievalFlowNodeS3ConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface RetrievalFlowNodeS3ConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The name of the Amazon S3 bucket from which to retrieve data.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-flow-retrievalflownodes3configuration.html#cfn-bedrock-flow-retrievalflownodes3configuration-bucketname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-flow-retrievalflownodes3configuration.html#cfn-bedrock-flow-retrievalflownodes3configuration-bucketname</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getBucketName();

        /**
         * @return a {@link Builder} of {@link RetrievalFlowNodeS3ConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link RetrievalFlowNodeS3ConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<RetrievalFlowNodeS3ConfigurationProperty> {
            java.lang.String bucketName;

            /**
             * Sets the value of {@link RetrievalFlowNodeS3ConfigurationProperty#getBucketName}
             * @param bucketName The name of the Amazon S3 bucket from which to retrieve data. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder bucketName(java.lang.String bucketName) {
                this.bucketName = bucketName;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link RetrievalFlowNodeS3ConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public RetrievalFlowNodeS3ConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link RetrievalFlowNodeS3ConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements RetrievalFlowNodeS3ConfigurationProperty {
            private final java.lang.String bucketName;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.bucketName = software.amazon.jsii.Kernel.get(this, "bucketName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.bucketName = java.util.Objects.requireNonNull(builder.bucketName, "bucketName is required");
            }

            @Override
            public final java.lang.String getBucketName() {
                return this.bucketName;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("bucketName", om.valueToTree(this.getBucketName()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_bedrock.CfnFlow.RetrievalFlowNodeS3ConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                RetrievalFlowNodeS3ConfigurationProperty.Jsii$Proxy that = (RetrievalFlowNodeS3ConfigurationProperty.Jsii$Proxy) o;

                return this.bucketName.equals(that.bucketName);
            }

            @Override
            public final int hashCode() {
                int result = this.bucketName.hashCode();
                return result;
            }
        }
    }
    /**
     * Contains configurations for the service to use for retrieving data to return as the output from the node.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.bedrock.*;
     * RetrievalFlowNodeServiceConfigurationProperty retrievalFlowNodeServiceConfigurationProperty = RetrievalFlowNodeServiceConfigurationProperty.builder()
     *         .s3(RetrievalFlowNodeS3ConfigurationProperty.builder()
     *                 .bucketName("bucketName")
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-flow-retrievalflownodeserviceconfiguration.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-flow-retrievalflownodeserviceconfiguration.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_bedrock.CfnFlow.RetrievalFlowNodeServiceConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(RetrievalFlowNodeServiceConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface RetrievalFlowNodeServiceConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Contains configurations for the Amazon S3 location from which to retrieve data to return as the output from the node.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-flow-retrievalflownodeserviceconfiguration.html#cfn-bedrock-flow-retrievalflownodeserviceconfiguration-s3">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-flow-retrievalflownodeserviceconfiguration.html#cfn-bedrock-flow-retrievalflownodeserviceconfiguration-s3</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getS3() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link RetrievalFlowNodeServiceConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link RetrievalFlowNodeServiceConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<RetrievalFlowNodeServiceConfigurationProperty> {
            java.lang.Object s3;

            /**
             * Sets the value of {@link RetrievalFlowNodeServiceConfigurationProperty#getS3}
             * @param s3 Contains configurations for the Amazon S3 location from which to retrieve data to return as the output from the node.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder s3(software.amazon.awscdk.IResolvable s3) {
                this.s3 = s3;
                return this;
            }

            /**
             * Sets the value of {@link RetrievalFlowNodeServiceConfigurationProperty#getS3}
             * @param s3 Contains configurations for the Amazon S3 location from which to retrieve data to return as the output from the node.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder s3(software.amazon.awscdk.services.bedrock.CfnFlow.RetrievalFlowNodeS3ConfigurationProperty s3) {
                this.s3 = s3;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link RetrievalFlowNodeServiceConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public RetrievalFlowNodeServiceConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link RetrievalFlowNodeServiceConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements RetrievalFlowNodeServiceConfigurationProperty {
            private final java.lang.Object s3;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.s3 = software.amazon.jsii.Kernel.get(this, "s3", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.s3 = builder.s3;
            }

            @Override
            public final java.lang.Object getS3() {
                return this.s3;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getS3() != null) {
                    data.set("s3", om.valueToTree(this.getS3()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_bedrock.CfnFlow.RetrievalFlowNodeServiceConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                RetrievalFlowNodeServiceConfigurationProperty.Jsii$Proxy that = (RetrievalFlowNodeServiceConfigurationProperty.Jsii$Proxy) o;

                return this.s3 != null ? this.s3.equals(that.s3) : that.s3 == null;
            }

            @Override
            public final int hashCode() {
                int result = this.s3 != null ? this.s3.hashCode() : 0;
                return result;
            }
        }
    }
    /**
     * The S3 location of the flow definition.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.bedrock.*;
     * S3LocationProperty s3LocationProperty = S3LocationProperty.builder()
     *         .bucket("bucket")
     *         .key("key")
     *         // the properties below are optional
     *         .version("version")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-flow-s3location.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-flow-s3location.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_bedrock.CfnFlow.S3LocationProperty")
    @software.amazon.jsii.Jsii.Proxy(S3LocationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface S3LocationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The S3 bucket containing the flow definition.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-flow-s3location.html#cfn-bedrock-flow-s3location-bucket">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-flow-s3location.html#cfn-bedrock-flow-s3location-bucket</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getBucket();

        /**
         * The object key for the S3 location containing the definition.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-flow-s3location.html#cfn-bedrock-flow-s3location-key">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-flow-s3location.html#cfn-bedrock-flow-s3location-key</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getKey();

        /**
         * The Amazon S3 location from which to retrieve data for an S3 retrieve node or to which to store data for an S3 storage node.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-flow-s3location.html#cfn-bedrock-flow-s3location-version">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-flow-s3location.html#cfn-bedrock-flow-s3location-version</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getVersion() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link S3LocationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link S3LocationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<S3LocationProperty> {
            java.lang.String bucket;
            java.lang.String key;
            java.lang.String version;

            /**
             * Sets the value of {@link S3LocationProperty#getBucket}
             * @param bucket The S3 bucket containing the flow definition. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder bucket(java.lang.String bucket) {
                this.bucket = bucket;
                return this;
            }

            /**
             * Sets the value of {@link S3LocationProperty#getKey}
             * @param key The object key for the S3 location containing the definition. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder key(java.lang.String key) {
                this.key = key;
                return this;
            }

            /**
             * Sets the value of {@link S3LocationProperty#getVersion}
             * @param version The Amazon S3 location from which to retrieve data for an S3 retrieve node or to which to store data for an S3 storage node.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder version(java.lang.String version) {
                this.version = version;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link S3LocationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public S3LocationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link S3LocationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements S3LocationProperty {
            private final java.lang.String bucket;
            private final java.lang.String key;
            private final java.lang.String version;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.bucket = software.amazon.jsii.Kernel.get(this, "bucket", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.key = software.amazon.jsii.Kernel.get(this, "key", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.version = software.amazon.jsii.Kernel.get(this, "version", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.bucket = java.util.Objects.requireNonNull(builder.bucket, "bucket is required");
                this.key = java.util.Objects.requireNonNull(builder.key, "key is required");
                this.version = builder.version;
            }

            @Override
            public final java.lang.String getBucket() {
                return this.bucket;
            }

            @Override
            public final java.lang.String getKey() {
                return this.key;
            }

            @Override
            public final java.lang.String getVersion() {
                return this.version;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("bucket", om.valueToTree(this.getBucket()));
                data.set("key", om.valueToTree(this.getKey()));
                if (this.getVersion() != null) {
                    data.set("version", om.valueToTree(this.getVersion()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_bedrock.CfnFlow.S3LocationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                S3LocationProperty.Jsii$Proxy that = (S3LocationProperty.Jsii$Proxy) o;

                if (!bucket.equals(that.bucket)) return false;
                if (!key.equals(that.key)) return false;
                return this.version != null ? this.version.equals(that.version) : that.version == null;
            }

            @Override
            public final int hashCode() {
                int result = this.bucket.hashCode();
                result = 31 * result + (this.key.hashCode());
                result = 31 * result + (this.version != null ? this.version.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Contains configurations for a Storage node in a flow.
     * <p>
     * This node stores the input in an Amazon S3 location that you specify.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.bedrock.*;
     * StorageFlowNodeConfigurationProperty storageFlowNodeConfigurationProperty = StorageFlowNodeConfigurationProperty.builder()
     *         .serviceConfiguration(StorageFlowNodeServiceConfigurationProperty.builder()
     *                 .s3(StorageFlowNodeS3ConfigurationProperty.builder()
     *                         .bucketName("bucketName")
     *                         .build())
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-flow-storageflownodeconfiguration.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-flow-storageflownodeconfiguration.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_bedrock.CfnFlow.StorageFlowNodeConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(StorageFlowNodeConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface StorageFlowNodeConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Contains configurations for the service to use for storing the input into the node.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-flow-storageflownodeconfiguration.html#cfn-bedrock-flow-storageflownodeconfiguration-serviceconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-flow-storageflownodeconfiguration.html#cfn-bedrock-flow-storageflownodeconfiguration-serviceconfiguration</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getServiceConfiguration();

        /**
         * @return a {@link Builder} of {@link StorageFlowNodeConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link StorageFlowNodeConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<StorageFlowNodeConfigurationProperty> {
            java.lang.Object serviceConfiguration;

            /**
             * Sets the value of {@link StorageFlowNodeConfigurationProperty#getServiceConfiguration}
             * @param serviceConfiguration Contains configurations for the service to use for storing the input into the node. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder serviceConfiguration(software.amazon.awscdk.IResolvable serviceConfiguration) {
                this.serviceConfiguration = serviceConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link StorageFlowNodeConfigurationProperty#getServiceConfiguration}
             * @param serviceConfiguration Contains configurations for the service to use for storing the input into the node. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder serviceConfiguration(software.amazon.awscdk.services.bedrock.CfnFlow.StorageFlowNodeServiceConfigurationProperty serviceConfiguration) {
                this.serviceConfiguration = serviceConfiguration;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link StorageFlowNodeConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public StorageFlowNodeConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link StorageFlowNodeConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements StorageFlowNodeConfigurationProperty {
            private final java.lang.Object serviceConfiguration;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.serviceConfiguration = software.amazon.jsii.Kernel.get(this, "serviceConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.serviceConfiguration = java.util.Objects.requireNonNull(builder.serviceConfiguration, "serviceConfiguration is required");
            }

            @Override
            public final java.lang.Object getServiceConfiguration() {
                return this.serviceConfiguration;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("serviceConfiguration", om.valueToTree(this.getServiceConfiguration()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_bedrock.CfnFlow.StorageFlowNodeConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                StorageFlowNodeConfigurationProperty.Jsii$Proxy that = (StorageFlowNodeConfigurationProperty.Jsii$Proxy) o;

                return this.serviceConfiguration.equals(that.serviceConfiguration);
            }

            @Override
            public final int hashCode() {
                int result = this.serviceConfiguration.hashCode();
                return result;
            }
        }
    }
    /**
     * Contains configurations for the Amazon S3 location in which to store the input into the node.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.bedrock.*;
     * StorageFlowNodeS3ConfigurationProperty storageFlowNodeS3ConfigurationProperty = StorageFlowNodeS3ConfigurationProperty.builder()
     *         .bucketName("bucketName")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-flow-storageflownodes3configuration.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-flow-storageflownodes3configuration.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_bedrock.CfnFlow.StorageFlowNodeS3ConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(StorageFlowNodeS3ConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface StorageFlowNodeS3ConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The name of the Amazon S3 bucket in which to store the input into the node.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-flow-storageflownodes3configuration.html#cfn-bedrock-flow-storageflownodes3configuration-bucketname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-flow-storageflownodes3configuration.html#cfn-bedrock-flow-storageflownodes3configuration-bucketname</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getBucketName();

        /**
         * @return a {@link Builder} of {@link StorageFlowNodeS3ConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link StorageFlowNodeS3ConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<StorageFlowNodeS3ConfigurationProperty> {
            java.lang.String bucketName;

            /**
             * Sets the value of {@link StorageFlowNodeS3ConfigurationProperty#getBucketName}
             * @param bucketName The name of the Amazon S3 bucket in which to store the input into the node. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder bucketName(java.lang.String bucketName) {
                this.bucketName = bucketName;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link StorageFlowNodeS3ConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public StorageFlowNodeS3ConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link StorageFlowNodeS3ConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements StorageFlowNodeS3ConfigurationProperty {
            private final java.lang.String bucketName;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.bucketName = software.amazon.jsii.Kernel.get(this, "bucketName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.bucketName = java.util.Objects.requireNonNull(builder.bucketName, "bucketName is required");
            }

            @Override
            public final java.lang.String getBucketName() {
                return this.bucketName;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("bucketName", om.valueToTree(this.getBucketName()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_bedrock.CfnFlow.StorageFlowNodeS3ConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                StorageFlowNodeS3ConfigurationProperty.Jsii$Proxy that = (StorageFlowNodeS3ConfigurationProperty.Jsii$Proxy) o;

                return this.bucketName.equals(that.bucketName);
            }

            @Override
            public final int hashCode() {
                int result = this.bucketName.hashCode();
                return result;
            }
        }
    }
    /**
     * Contains configurations for the service to use for storing the input into the node.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.bedrock.*;
     * StorageFlowNodeServiceConfigurationProperty storageFlowNodeServiceConfigurationProperty = StorageFlowNodeServiceConfigurationProperty.builder()
     *         .s3(StorageFlowNodeS3ConfigurationProperty.builder()
     *                 .bucketName("bucketName")
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-flow-storageflownodeserviceconfiguration.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-flow-storageflownodeserviceconfiguration.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_bedrock.CfnFlow.StorageFlowNodeServiceConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(StorageFlowNodeServiceConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface StorageFlowNodeServiceConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Contains configurations for the Amazon S3 location in which to store the input into the node.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-flow-storageflownodeserviceconfiguration.html#cfn-bedrock-flow-storageflownodeserviceconfiguration-s3">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-flow-storageflownodeserviceconfiguration.html#cfn-bedrock-flow-storageflownodeserviceconfiguration-s3</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getS3() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link StorageFlowNodeServiceConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link StorageFlowNodeServiceConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<StorageFlowNodeServiceConfigurationProperty> {
            java.lang.Object s3;

            /**
             * Sets the value of {@link StorageFlowNodeServiceConfigurationProperty#getS3}
             * @param s3 Contains configurations for the Amazon S3 location in which to store the input into the node.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder s3(software.amazon.awscdk.IResolvable s3) {
                this.s3 = s3;
                return this;
            }

            /**
             * Sets the value of {@link StorageFlowNodeServiceConfigurationProperty#getS3}
             * @param s3 Contains configurations for the Amazon S3 location in which to store the input into the node.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder s3(software.amazon.awscdk.services.bedrock.CfnFlow.StorageFlowNodeS3ConfigurationProperty s3) {
                this.s3 = s3;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link StorageFlowNodeServiceConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public StorageFlowNodeServiceConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link StorageFlowNodeServiceConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements StorageFlowNodeServiceConfigurationProperty {
            private final java.lang.Object s3;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.s3 = software.amazon.jsii.Kernel.get(this, "s3", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.s3 = builder.s3;
            }

            @Override
            public final java.lang.Object getS3() {
                return this.s3;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getS3() != null) {
                    data.set("s3", om.valueToTree(this.getS3()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_bedrock.CfnFlow.StorageFlowNodeServiceConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                StorageFlowNodeServiceConfigurationProperty.Jsii$Proxy that = (StorageFlowNodeServiceConfigurationProperty.Jsii$Proxy) o;

                return this.s3 != null ? this.s3.equals(that.s3) : that.s3 == null;
            }

            @Override
            public final int hashCode() {
                int result = this.s3 != null ? this.s3.hashCode() : 0;
                return result;
            }
        }
    }
    /**
     * Contains configurations for a text prompt template.
     * <p>
     * To include a variable, enclose a word in double curly braces as in <code>{{variable}}</code> .
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.bedrock.*;
     * TextPromptTemplateConfigurationProperty textPromptTemplateConfigurationProperty = TextPromptTemplateConfigurationProperty.builder()
     *         .text("text")
     *         // the properties below are optional
     *         .inputVariables(List.of(PromptInputVariableProperty.builder()
     *                 .name("name")
     *                 .build()))
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-flow-textprompttemplateconfiguration.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-flow-textprompttemplateconfiguration.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_bedrock.CfnFlow.TextPromptTemplateConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(TextPromptTemplateConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface TextPromptTemplateConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The message for the prompt.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-flow-textprompttemplateconfiguration.html#cfn-bedrock-flow-textprompttemplateconfiguration-text">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-flow-textprompttemplateconfiguration.html#cfn-bedrock-flow-textprompttemplateconfiguration-text</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getText();

        /**
         * An array of the variables in the prompt template.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-flow-textprompttemplateconfiguration.html#cfn-bedrock-flow-textprompttemplateconfiguration-inputvariables">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-flow-textprompttemplateconfiguration.html#cfn-bedrock-flow-textprompttemplateconfiguration-inputvariables</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getInputVariables() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link TextPromptTemplateConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link TextPromptTemplateConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<TextPromptTemplateConfigurationProperty> {
            java.lang.String text;
            java.lang.Object inputVariables;

            /**
             * Sets the value of {@link TextPromptTemplateConfigurationProperty#getText}
             * @param text The message for the prompt. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder text(java.lang.String text) {
                this.text = text;
                return this;
            }

            /**
             * Sets the value of {@link TextPromptTemplateConfigurationProperty#getInputVariables}
             * @param inputVariables An array of the variables in the prompt template.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder inputVariables(software.amazon.awscdk.IResolvable inputVariables) {
                this.inputVariables = inputVariables;
                return this;
            }

            /**
             * Sets the value of {@link TextPromptTemplateConfigurationProperty#getInputVariables}
             * @param inputVariables An array of the variables in the prompt template.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder inputVariables(java.util.List<? extends java.lang.Object> inputVariables) {
                this.inputVariables = inputVariables;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link TextPromptTemplateConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public TextPromptTemplateConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link TextPromptTemplateConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements TextPromptTemplateConfigurationProperty {
            private final java.lang.String text;
            private final java.lang.Object inputVariables;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.text = software.amazon.jsii.Kernel.get(this, "text", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.inputVariables = software.amazon.jsii.Kernel.get(this, "inputVariables", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.text = java.util.Objects.requireNonNull(builder.text, "text is required");
                this.inputVariables = builder.inputVariables;
            }

            @Override
            public final java.lang.String getText() {
                return this.text;
            }

            @Override
            public final java.lang.Object getInputVariables() {
                return this.inputVariables;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("text", om.valueToTree(this.getText()));
                if (this.getInputVariables() != null) {
                    data.set("inputVariables", om.valueToTree(this.getInputVariables()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_bedrock.CfnFlow.TextPromptTemplateConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                TextPromptTemplateConfigurationProperty.Jsii$Proxy that = (TextPromptTemplateConfigurationProperty.Jsii$Proxy) o;

                if (!text.equals(that.text)) return false;
                return this.inputVariables != null ? this.inputVariables.equals(that.inputVariables) : that.inputVariables == null;
            }

            @Override
            public final int hashCode() {
                int result = this.text.hashCode();
                result = 31 * result + (this.inputVariables != null ? this.inputVariables.hashCode() : 0);
                return result;
            }
        }
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.bedrock.CfnFlow}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.bedrock.CfnFlow> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope Scope in which this resource is defined. This parameter is required.
         * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.bedrock.CfnFlowProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.bedrock.CfnFlowProps.Builder();
        }

        /**
         * The Amazon Resource Name (ARN) of the service role with permissions to create a flow.
         * <p>
         * For more information, see <a href="https://docs.aws.amazon.com/bedrock/latest/userguide/flows-permissions.html">Create a service row for flows</a> in the Amazon Bedrock User Guide.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-bedrock-flow.html#cfn-bedrock-flow-executionrolearn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-bedrock-flow.html#cfn-bedrock-flow-executionrolearn</a>
         * @param executionRoleArn The Amazon Resource Name (ARN) of the service role with permissions to create a flow. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder executionRoleArn(final java.lang.String executionRoleArn) {
            this.props.executionRoleArn(executionRoleArn);
            return this;
        }

        /**
         * The name of the flow.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-bedrock-flow.html#cfn-bedrock-flow-name">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-bedrock-flow.html#cfn-bedrock-flow-name</a>
         * @param name The name of the flow. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder name(final java.lang.String name) {
            this.props.name(name);
            return this;
        }

        /**
         * The Amazon Resource Name (ARN) of the KMS key that the flow is encrypted with.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-bedrock-flow.html#cfn-bedrock-flow-customerencryptionkeyarn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-bedrock-flow.html#cfn-bedrock-flow-customerencryptionkeyarn</a>
         * @param customerEncryptionKeyArn The Amazon Resource Name (ARN) of the KMS key that the flow is encrypted with. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder customerEncryptionKeyArn(final java.lang.String customerEncryptionKeyArn) {
            this.props.customerEncryptionKeyArn(customerEncryptionKeyArn);
            return this;
        }

        /**
         * The definition of the nodes and connections between the nodes in the flow.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-bedrock-flow.html#cfn-bedrock-flow-definition">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-bedrock-flow.html#cfn-bedrock-flow-definition</a>
         * @param definition The definition of the nodes and connections between the nodes in the flow. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder definition(final software.amazon.awscdk.IResolvable definition) {
            this.props.definition(definition);
            return this;
        }
        /**
         * The definition of the nodes and connections between the nodes in the flow.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-bedrock-flow.html#cfn-bedrock-flow-definition">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-bedrock-flow.html#cfn-bedrock-flow-definition</a>
         * @param definition The definition of the nodes and connections between the nodes in the flow. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder definition(final software.amazon.awscdk.services.bedrock.CfnFlow.FlowDefinitionProperty definition) {
            this.props.definition(definition);
            return this;
        }

        /**
         * The Amazon S3 location of the flow definition.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-bedrock-flow.html#cfn-bedrock-flow-definitions3location">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-bedrock-flow.html#cfn-bedrock-flow-definitions3location</a>
         * @param definitionS3Location The Amazon S3 location of the flow definition. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder definitionS3Location(final software.amazon.awscdk.IResolvable definitionS3Location) {
            this.props.definitionS3Location(definitionS3Location);
            return this;
        }
        /**
         * The Amazon S3 location of the flow definition.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-bedrock-flow.html#cfn-bedrock-flow-definitions3location">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-bedrock-flow.html#cfn-bedrock-flow-definitions3location</a>
         * @param definitionS3Location The Amazon S3 location of the flow definition. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder definitionS3Location(final software.amazon.awscdk.services.bedrock.CfnFlow.S3LocationProperty definitionS3Location) {
            this.props.definitionS3Location(definitionS3Location);
            return this;
        }

        /**
         * The definition of the flow as a JSON-formatted string.
         * <p>
         * The string must match the format in <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-bedrock-flow-flowdefinition.html">FlowDefinition</a> .
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-bedrock-flow.html#cfn-bedrock-flow-definitionstring">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-bedrock-flow.html#cfn-bedrock-flow-definitionstring</a>
         * @param definitionString The definition of the flow as a JSON-formatted string. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder definitionString(final java.lang.String definitionString) {
            this.props.definitionString(definitionString);
            return this;
        }

        /**
         * A map that specifies the mappings for placeholder variables in the prompt flow definition.
         * <p>
         * This enables the customer to inject values obtained at runtime. Variables can be template parameter names, resource logical IDs, resource attributes, or a variable in a key-value map. Only supported with the <code>DefinitionString</code> and <code>DefinitionS3Location</code> fields.
         * <p>
         * Substitutions must follow the syntax: <code>${key_name}</code> or <code>${variable_1,variable_2,...}</code> .
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-bedrock-flow.html#cfn-bedrock-flow-definitionsubstitutions">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-bedrock-flow.html#cfn-bedrock-flow-definitionsubstitutions</a>
         * @param definitionSubstitutions A map that specifies the mappings for placeholder variables in the prompt flow definition. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder definitionSubstitutions(final software.amazon.awscdk.IResolvable definitionSubstitutions) {
            this.props.definitionSubstitutions(definitionSubstitutions);
            return this;
        }
        /**
         * A map that specifies the mappings for placeholder variables in the prompt flow definition.
         * <p>
         * This enables the customer to inject values obtained at runtime. Variables can be template parameter names, resource logical IDs, resource attributes, or a variable in a key-value map. Only supported with the <code>DefinitionString</code> and <code>DefinitionS3Location</code> fields.
         * <p>
         * Substitutions must follow the syntax: <code>${key_name}</code> or <code>${variable_1,variable_2,...}</code> .
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-bedrock-flow.html#cfn-bedrock-flow-definitionsubstitutions">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-bedrock-flow.html#cfn-bedrock-flow-definitionsubstitutions</a>
         * @param definitionSubstitutions A map that specifies the mappings for placeholder variables in the prompt flow definition. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder definitionSubstitutions(final java.util.Map<java.lang.String, ? extends java.lang.Object> definitionSubstitutions) {
            this.props.definitionSubstitutions(definitionSubstitutions);
            return this;
        }

        /**
         * A description of the flow.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-bedrock-flow.html#cfn-bedrock-flow-description">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-bedrock-flow.html#cfn-bedrock-flow-description</a>
         * @param description A description of the flow. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder description(final java.lang.String description) {
            this.props.description(description);
            return this;
        }

        /**
         * Metadata that you can assign to a resource as key-value pairs. For more information, see the following resources:.
         * <p>
         * <ul>
         * <li><a href="https://docs.aws.amazon.com/tag-editor/latest/userguide/tagging.html#tag-conventions">Tag naming limits and requirements</a></li>
         * <li><a href="https://docs.aws.amazon.com/tag-editor/latest/userguide/tagging.html#tag-best-practices">Tagging best practices</a></li>
         * </ul>
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-bedrock-flow.html#cfn-bedrock-flow-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-bedrock-flow.html#cfn-bedrock-flow-tags</a>
         * @param tags Metadata that you can assign to a resource as key-value pairs. For more information, see the following resources:. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tags(final java.util.Map<java.lang.String, java.lang.String> tags) {
            this.props.tags(tags);
            return this;
        }

        /**
         * A map of tag keys and values.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-bedrock-flow.html#cfn-bedrock-flow-testaliastags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-bedrock-flow.html#cfn-bedrock-flow-testaliastags</a>
         * @param testAliasTags A map of tag keys and values. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder testAliasTags(final java.util.Map<java.lang.String, java.lang.String> testAliasTags) {
            this.props.testAliasTags(testAliasTags);
            return this;
        }
        /**
         * A map of tag keys and values.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-bedrock-flow.html#cfn-bedrock-flow-testaliastags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-bedrock-flow.html#cfn-bedrock-flow-testaliastags</a>
         * @param testAliasTags A map of tag keys and values. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder testAliasTags(final software.amazon.awscdk.IResolvable testAliasTags) {
            this.props.testAliasTags(testAliasTags);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.bedrock.CfnFlow}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.bedrock.CfnFlow build() {
            return new software.amazon.awscdk.services.bedrock.CfnFlow(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
