package software.amazon.awscdk.services.cleanrooms;

/**
 * Creates a new collaboration.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.cleanrooms.*;
 * CfnCollaboration cfnCollaboration = CfnCollaboration.Builder.create(this, "MyCfnCollaboration")
 *         .creatorDisplayName("creatorDisplayName")
 *         .creatorMemberAbilities(List.of("creatorMemberAbilities"))
 *         .description("description")
 *         .members(List.of(MemberSpecificationProperty.builder()
 *                 .accountId("accountId")
 *                 .displayName("displayName")
 *                 .memberAbilities(List.of("memberAbilities"))
 *                 // the properties below are optional
 *                 .mlMemberAbilities(MLMemberAbilitiesProperty.builder()
 *                         .customMlMemberAbilities(List.of("customMlMemberAbilities"))
 *                         .build())
 *                 .paymentConfiguration(PaymentConfigurationProperty.builder()
 *                         .queryCompute(QueryComputePaymentConfigProperty.builder()
 *                                 .isResponsible(false)
 *                                 .build())
 *                         // the properties below are optional
 *                         .machineLearning(MLPaymentConfigProperty.builder()
 *                                 .modelInference(ModelInferencePaymentConfigProperty.builder()
 *                                         .isResponsible(false)
 *                                         .build())
 *                                 .modelTraining(ModelTrainingPaymentConfigProperty.builder()
 *                                         .isResponsible(false)
 *                                         .build())
 *                                 .build())
 *                         .build())
 *                 .build()))
 *         .name("name")
 *         .queryLogStatus("queryLogStatus")
 *         // the properties below are optional
 *         .analyticsEngine("analyticsEngine")
 *         .creatorMlMemberAbilities(MLMemberAbilitiesProperty.builder()
 *                 .customMlMemberAbilities(List.of("customMlMemberAbilities"))
 *                 .build())
 *         .creatorPaymentConfiguration(PaymentConfigurationProperty.builder()
 *                 .queryCompute(QueryComputePaymentConfigProperty.builder()
 *                         .isResponsible(false)
 *                         .build())
 *                 // the properties below are optional
 *                 .machineLearning(MLPaymentConfigProperty.builder()
 *                         .modelInference(ModelInferencePaymentConfigProperty.builder()
 *                                 .isResponsible(false)
 *                                 .build())
 *                         .modelTraining(ModelTrainingPaymentConfigProperty.builder()
 *                                 .isResponsible(false)
 *                                 .build())
 *                         .build())
 *                 .build())
 *         .dataEncryptionMetadata(DataEncryptionMetadataProperty.builder()
 *                 .allowCleartext(false)
 *                 .allowDuplicates(false)
 *                 .allowJoinsOnColumnsWithDifferentNames(false)
 *                 .preserveNulls(false)
 *                 .build())
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cleanrooms-collaboration.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cleanrooms-collaboration.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.106.0 (build e852934)", date = "2025-02-21T03:20:29.343Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_cleanrooms.CfnCollaboration")
public class CfnCollaboration extends software.amazon.awscdk.CfnResource implements software.amazon.awscdk.IInspectable, software.amazon.awscdk.ITaggableV2 {

    protected CfnCollaboration(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnCollaboration(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.cleanrooms.CfnCollaboration.class, "CFN_RESOURCE_TYPE_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * @param scope Scope in which this resource is defined. This parameter is required.
     * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
     * @param props Resource properties. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnCollaboration(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cleanrooms.CfnCollaborationProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * @param inspector tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.TreeInspector inspector) {
        software.amazon.jsii.Kernel.call(this, "inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     * Returns the Amazon Resource Name (ARN) of the specified collaboration.
     * <p>
     * Example: <code>arn:aws:cleanrooms:us-east-1:111122223333:collaboration/a1b2c3d4-5678-90ab-cdef-EXAMPLE11111</code>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrArn() {
        return software.amazon.jsii.Kernel.get(this, "attrArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Returns the unique identifier of the specified collaboration.
     * <p>
     * Example: <code>a1b2c3d4-5678-90ab-cdef-EXAMPLE11111</code>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrCollaborationIdentifier() {
        return software.amazon.jsii.Kernel.get(this, "attrCollaborationIdentifier", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Tag Manager which manages the tags for this resource.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.TagManager getCdkTagManager() {
        return software.amazon.jsii.Kernel.get(this, "cdkTagManager", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TagManager.class));
    }

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * A display name of the collaboration creator.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getCreatorDisplayName() {
        return software.amazon.jsii.Kernel.get(this, "creatorDisplayName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * A display name of the collaboration creator.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setCreatorDisplayName(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "creatorDisplayName", java.util.Objects.requireNonNull(value, "creatorDisplayName is required"));
    }

    /**
     * The abilities granted to the collaboration creator.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> getCreatorMemberAbilities() {
        return java.util.Collections.unmodifiableList(software.amazon.jsii.Kernel.get(this, "creatorMemberAbilities", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class))));
    }

    /**
     * The abilities granted to the collaboration creator.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setCreatorMemberAbilities(final @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> value) {
        software.amazon.jsii.Kernel.set(this, "creatorMemberAbilities", java.util.Objects.requireNonNull(value, "creatorMemberAbilities is required"));
    }

    /**
     * A description of the collaboration provided by the collaboration owner.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getDescription() {
        return software.amazon.jsii.Kernel.get(this, "description", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * A description of the collaboration provided by the collaboration owner.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDescription(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "description", java.util.Objects.requireNonNull(value, "description is required"));
    }

    /**
     * A list of initial members, not including the creator.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Object getMembers() {
        return software.amazon.jsii.Kernel.get(this, "members", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * A list of initial members, not including the creator.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setMembers(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "members", java.util.Objects.requireNonNull(value, "members is required"));
    }

    /**
     * A list of initial members, not including the creator.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setMembers(final @org.jetbrains.annotations.NotNull java.util.List<java.lang.Object> value) {
        if (software.amazon.jsii.Configuration.getRuntimeTypeChecking()) {
            for (int __idx_ac66f0 = 0; __idx_ac66f0 < value.size(); __idx_ac66f0++) {
                final java.lang.Object __val_ac66f0 = value.get(__idx_ac66f0);
                if (
                     !(__val_ac66f0 instanceof software.amazon.awscdk.IResolvable)
                    && !(__val_ac66f0 instanceof software.amazon.awscdk.services.cleanrooms.CfnCollaboration.MemberSpecificationProperty)
                    && !(__val_ac66f0.getClass().equals(software.amazon.jsii.JsiiObject.class))
                ) {
                    throw new IllegalArgumentException(
                        new java.lang.StringBuilder("Expected ")
                            .append("value").append(".get(").append(__idx_ac66f0).append(")")
                            .append(" to be one of: software.amazon.awscdk.IResolvable, software.amazon.awscdk.services.cleanrooms.CfnCollaboration.MemberSpecificationProperty; received ")
                            .append(__val_ac66f0.getClass()).toString());
                }
            }
        }
        software.amazon.jsii.Kernel.set(this, "members", java.util.Objects.requireNonNull(value, "members is required"));
    }

    /**
     * A human-readable identifier provided by the collaboration owner.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getName() {
        return software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * A human-readable identifier provided by the collaboration owner.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setName(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "name", java.util.Objects.requireNonNull(value, "name is required"));
    }

    /**
     * An indicator as to whether query logging has been enabled or disabled for the collaboration.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getQueryLogStatus() {
        return software.amazon.jsii.Kernel.get(this, "queryLogStatus", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * An indicator as to whether query logging has been enabled or disabled for the collaboration.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setQueryLogStatus(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "queryLogStatus", java.util.Objects.requireNonNull(value, "queryLogStatus is required"));
    }

    /**
     * The analytics engine for the collaboration.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getAnalyticsEngine() {
        return software.amazon.jsii.Kernel.get(this, "analyticsEngine", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The analytics engine for the collaboration.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setAnalyticsEngine(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "analyticsEngine", value);
    }

    /**
     * The ML member abilities for a collaboration member.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getCreatorMlMemberAbilities() {
        return software.amazon.jsii.Kernel.get(this, "creatorMlMemberAbilities", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The ML member abilities for a collaboration member.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setCreatorMlMemberAbilities(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "creatorMlMemberAbilities", value);
    }

    /**
     * The ML member abilities for a collaboration member.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setCreatorMlMemberAbilities(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cleanrooms.CfnCollaboration.MLMemberAbilitiesProperty value) {
        software.amazon.jsii.Kernel.set(this, "creatorMlMemberAbilities", value);
    }

    /**
     * An object representing the collaboration member's payment responsibilities set by the collaboration creator.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getCreatorPaymentConfiguration() {
        return software.amazon.jsii.Kernel.get(this, "creatorPaymentConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * An object representing the collaboration member's payment responsibilities set by the collaboration creator.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setCreatorPaymentConfiguration(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "creatorPaymentConfiguration", value);
    }

    /**
     * An object representing the collaboration member's payment responsibilities set by the collaboration creator.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setCreatorPaymentConfiguration(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cleanrooms.CfnCollaboration.PaymentConfigurationProperty value) {
        software.amazon.jsii.Kernel.set(this, "creatorPaymentConfiguration", value);
    }

    /**
     * The settings for client-side encryption for cryptographic computing.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getDataEncryptionMetadata() {
        return software.amazon.jsii.Kernel.get(this, "dataEncryptionMetadata", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * The settings for client-side encryption for cryptographic computing.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDataEncryptionMetadata(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "dataEncryptionMetadata", value);
    }

    /**
     * The settings for client-side encryption for cryptographic computing.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setDataEncryptionMetadata(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cleanrooms.CfnCollaboration.DataEncryptionMetadataProperty value) {
        software.amazon.jsii.Kernel.set(this, "dataEncryptionMetadata", value);
    }

    /**
     * An optional label that you can assign to a resource when you create it.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> getTags() {
        return java.util.Optional.ofNullable((java.util.List<software.amazon.awscdk.CfnTag>)(software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.CfnTag.class))))).map(java.util.Collections::unmodifiableList).orElse(null);
    }

    /**
     * An optional label that you can assign to a resource when you create it.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setTags(final @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> value) {
        software.amazon.jsii.Kernel.set(this, "tags", value);
    }
    /**
     * The settings for client-side encryption for cryptographic computing.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.cleanrooms.*;
     * DataEncryptionMetadataProperty dataEncryptionMetadataProperty = DataEncryptionMetadataProperty.builder()
     *         .allowCleartext(false)
     *         .allowDuplicates(false)
     *         .allowJoinsOnColumnsWithDifferentNames(false)
     *         .preserveNulls(false)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cleanrooms-collaboration-dataencryptionmetadata.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cleanrooms-collaboration-dataencryptionmetadata.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_cleanrooms.CfnCollaboration.DataEncryptionMetadataProperty")
    @software.amazon.jsii.Jsii.Proxy(DataEncryptionMetadataProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface DataEncryptionMetadataProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Indicates whether encrypted tables can contain cleartext data ( <code>TRUE</code> ) or are to cryptographically process every column ( <code>FALSE</code> ).
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cleanrooms-collaboration-dataencryptionmetadata.html#cfn-cleanrooms-collaboration-dataencryptionmetadata-allowcleartext">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cleanrooms-collaboration-dataencryptionmetadata.html#cfn-cleanrooms-collaboration-dataencryptionmetadata-allowcleartext</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getAllowCleartext();

        /**
         * Indicates whether Fingerprint columns can contain duplicate entries ( <code>TRUE</code> ) or are to contain only non-repeated values ( <code>FALSE</code> ).
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cleanrooms-collaboration-dataencryptionmetadata.html#cfn-cleanrooms-collaboration-dataencryptionmetadata-allowduplicates">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cleanrooms-collaboration-dataencryptionmetadata.html#cfn-cleanrooms-collaboration-dataencryptionmetadata-allowduplicates</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getAllowDuplicates();

        /**
         * Indicates whether Fingerprint columns can be joined on any other Fingerprint column with a different name ( <code>TRUE</code> ) or can only be joined on Fingerprint columns of the same name ( <code>FALSE</code> ).
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cleanrooms-collaboration-dataencryptionmetadata.html#cfn-cleanrooms-collaboration-dataencryptionmetadata-allowjoinsoncolumnswithdifferentnames">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cleanrooms-collaboration-dataencryptionmetadata.html#cfn-cleanrooms-collaboration-dataencryptionmetadata-allowjoinsoncolumnswithdifferentnames</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getAllowJoinsOnColumnsWithDifferentNames();

        /**
         * Indicates whether NULL values are to be copied as NULL to encrypted tables ( <code>TRUE</code> ) or cryptographically processed ( <code>FALSE</code> ).
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cleanrooms-collaboration-dataencryptionmetadata.html#cfn-cleanrooms-collaboration-dataencryptionmetadata-preservenulls">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cleanrooms-collaboration-dataencryptionmetadata.html#cfn-cleanrooms-collaboration-dataencryptionmetadata-preservenulls</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getPreserveNulls();

        /**
         * @return a {@link Builder} of {@link DataEncryptionMetadataProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link DataEncryptionMetadataProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<DataEncryptionMetadataProperty> {
            java.lang.Object allowCleartext;
            java.lang.Object allowDuplicates;
            java.lang.Object allowJoinsOnColumnsWithDifferentNames;
            java.lang.Object preserveNulls;

            /**
             * Sets the value of {@link DataEncryptionMetadataProperty#getAllowCleartext}
             * @param allowCleartext Indicates whether encrypted tables can contain cleartext data ( <code>TRUE</code> ) or are to cryptographically process every column ( <code>FALSE</code> ). This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder allowCleartext(java.lang.Boolean allowCleartext) {
                this.allowCleartext = allowCleartext;
                return this;
            }

            /**
             * Sets the value of {@link DataEncryptionMetadataProperty#getAllowCleartext}
             * @param allowCleartext Indicates whether encrypted tables can contain cleartext data ( <code>TRUE</code> ) or are to cryptographically process every column ( <code>FALSE</code> ). This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder allowCleartext(software.amazon.awscdk.IResolvable allowCleartext) {
                this.allowCleartext = allowCleartext;
                return this;
            }

            /**
             * Sets the value of {@link DataEncryptionMetadataProperty#getAllowDuplicates}
             * @param allowDuplicates Indicates whether Fingerprint columns can contain duplicate entries ( <code>TRUE</code> ) or are to contain only non-repeated values ( <code>FALSE</code> ). This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder allowDuplicates(java.lang.Boolean allowDuplicates) {
                this.allowDuplicates = allowDuplicates;
                return this;
            }

            /**
             * Sets the value of {@link DataEncryptionMetadataProperty#getAllowDuplicates}
             * @param allowDuplicates Indicates whether Fingerprint columns can contain duplicate entries ( <code>TRUE</code> ) or are to contain only non-repeated values ( <code>FALSE</code> ). This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder allowDuplicates(software.amazon.awscdk.IResolvable allowDuplicates) {
                this.allowDuplicates = allowDuplicates;
                return this;
            }

            /**
             * Sets the value of {@link DataEncryptionMetadataProperty#getAllowJoinsOnColumnsWithDifferentNames}
             * @param allowJoinsOnColumnsWithDifferentNames Indicates whether Fingerprint columns can be joined on any other Fingerprint column with a different name ( <code>TRUE</code> ) or can only be joined on Fingerprint columns of the same name ( <code>FALSE</code> ). This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder allowJoinsOnColumnsWithDifferentNames(java.lang.Boolean allowJoinsOnColumnsWithDifferentNames) {
                this.allowJoinsOnColumnsWithDifferentNames = allowJoinsOnColumnsWithDifferentNames;
                return this;
            }

            /**
             * Sets the value of {@link DataEncryptionMetadataProperty#getAllowJoinsOnColumnsWithDifferentNames}
             * @param allowJoinsOnColumnsWithDifferentNames Indicates whether Fingerprint columns can be joined on any other Fingerprint column with a different name ( <code>TRUE</code> ) or can only be joined on Fingerprint columns of the same name ( <code>FALSE</code> ). This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder allowJoinsOnColumnsWithDifferentNames(software.amazon.awscdk.IResolvable allowJoinsOnColumnsWithDifferentNames) {
                this.allowJoinsOnColumnsWithDifferentNames = allowJoinsOnColumnsWithDifferentNames;
                return this;
            }

            /**
             * Sets the value of {@link DataEncryptionMetadataProperty#getPreserveNulls}
             * @param preserveNulls Indicates whether NULL values are to be copied as NULL to encrypted tables ( <code>TRUE</code> ) or cryptographically processed ( <code>FALSE</code> ). This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder preserveNulls(java.lang.Boolean preserveNulls) {
                this.preserveNulls = preserveNulls;
                return this;
            }

            /**
             * Sets the value of {@link DataEncryptionMetadataProperty#getPreserveNulls}
             * @param preserveNulls Indicates whether NULL values are to be copied as NULL to encrypted tables ( <code>TRUE</code> ) or cryptographically processed ( <code>FALSE</code> ). This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder preserveNulls(software.amazon.awscdk.IResolvable preserveNulls) {
                this.preserveNulls = preserveNulls;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link DataEncryptionMetadataProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public DataEncryptionMetadataProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link DataEncryptionMetadataProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements DataEncryptionMetadataProperty {
            private final java.lang.Object allowCleartext;
            private final java.lang.Object allowDuplicates;
            private final java.lang.Object allowJoinsOnColumnsWithDifferentNames;
            private final java.lang.Object preserveNulls;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.allowCleartext = software.amazon.jsii.Kernel.get(this, "allowCleartext", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.allowDuplicates = software.amazon.jsii.Kernel.get(this, "allowDuplicates", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.allowJoinsOnColumnsWithDifferentNames = software.amazon.jsii.Kernel.get(this, "allowJoinsOnColumnsWithDifferentNames", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.preserveNulls = software.amazon.jsii.Kernel.get(this, "preserveNulls", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.allowCleartext = java.util.Objects.requireNonNull(builder.allowCleartext, "allowCleartext is required");
                this.allowDuplicates = java.util.Objects.requireNonNull(builder.allowDuplicates, "allowDuplicates is required");
                this.allowJoinsOnColumnsWithDifferentNames = java.util.Objects.requireNonNull(builder.allowJoinsOnColumnsWithDifferentNames, "allowJoinsOnColumnsWithDifferentNames is required");
                this.preserveNulls = java.util.Objects.requireNonNull(builder.preserveNulls, "preserveNulls is required");
            }

            @Override
            public final java.lang.Object getAllowCleartext() {
                return this.allowCleartext;
            }

            @Override
            public final java.lang.Object getAllowDuplicates() {
                return this.allowDuplicates;
            }

            @Override
            public final java.lang.Object getAllowJoinsOnColumnsWithDifferentNames() {
                return this.allowJoinsOnColumnsWithDifferentNames;
            }

            @Override
            public final java.lang.Object getPreserveNulls() {
                return this.preserveNulls;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("allowCleartext", om.valueToTree(this.getAllowCleartext()));
                data.set("allowDuplicates", om.valueToTree(this.getAllowDuplicates()));
                data.set("allowJoinsOnColumnsWithDifferentNames", om.valueToTree(this.getAllowJoinsOnColumnsWithDifferentNames()));
                data.set("preserveNulls", om.valueToTree(this.getPreserveNulls()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_cleanrooms.CfnCollaboration.DataEncryptionMetadataProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                DataEncryptionMetadataProperty.Jsii$Proxy that = (DataEncryptionMetadataProperty.Jsii$Proxy) o;

                if (!allowCleartext.equals(that.allowCleartext)) return false;
                if (!allowDuplicates.equals(that.allowDuplicates)) return false;
                if (!allowJoinsOnColumnsWithDifferentNames.equals(that.allowJoinsOnColumnsWithDifferentNames)) return false;
                return this.preserveNulls.equals(that.preserveNulls);
            }

            @Override
            public final int hashCode() {
                int result = this.allowCleartext.hashCode();
                result = 31 * result + (this.allowDuplicates.hashCode());
                result = 31 * result + (this.allowJoinsOnColumnsWithDifferentNames.hashCode());
                result = 31 * result + (this.preserveNulls.hashCode());
                return result;
            }
        }
    }
    /**
     * The ML member abilities for a collaboration member.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.cleanrooms.*;
     * MLMemberAbilitiesProperty mLMemberAbilitiesProperty = MLMemberAbilitiesProperty.builder()
     *         .customMlMemberAbilities(List.of("customMlMemberAbilities"))
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cleanrooms-collaboration-mlmemberabilities.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cleanrooms-collaboration-mlmemberabilities.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_cleanrooms.CfnCollaboration.MLMemberAbilitiesProperty")
    @software.amazon.jsii.Jsii.Proxy(MLMemberAbilitiesProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface MLMemberAbilitiesProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The custom ML member abilities for a collaboration member.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cleanrooms-collaboration-mlmemberabilities.html#cfn-cleanrooms-collaboration-mlmemberabilities-custommlmemberabilities">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cleanrooms-collaboration-mlmemberabilities.html#cfn-cleanrooms-collaboration-mlmemberabilities-custommlmemberabilities</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> getCustomMlMemberAbilities();

        /**
         * @return a {@link Builder} of {@link MLMemberAbilitiesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link MLMemberAbilitiesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<MLMemberAbilitiesProperty> {
            java.util.List<java.lang.String> customMlMemberAbilities;

            /**
             * Sets the value of {@link MLMemberAbilitiesProperty#getCustomMlMemberAbilities}
             * @param customMlMemberAbilities The custom ML member abilities for a collaboration member. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder customMlMemberAbilities(java.util.List<java.lang.String> customMlMemberAbilities) {
                this.customMlMemberAbilities = customMlMemberAbilities;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link MLMemberAbilitiesProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public MLMemberAbilitiesProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link MLMemberAbilitiesProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements MLMemberAbilitiesProperty {
            private final java.util.List<java.lang.String> customMlMemberAbilities;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.customMlMemberAbilities = software.amazon.jsii.Kernel.get(this, "customMlMemberAbilities", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.customMlMemberAbilities = java.util.Objects.requireNonNull(builder.customMlMemberAbilities, "customMlMemberAbilities is required");
            }

            @Override
            public final java.util.List<java.lang.String> getCustomMlMemberAbilities() {
                return this.customMlMemberAbilities;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("customMlMemberAbilities", om.valueToTree(this.getCustomMlMemberAbilities()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_cleanrooms.CfnCollaboration.MLMemberAbilitiesProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                MLMemberAbilitiesProperty.Jsii$Proxy that = (MLMemberAbilitiesProperty.Jsii$Proxy) o;

                return this.customMlMemberAbilities.equals(that.customMlMemberAbilities);
            }

            @Override
            public final int hashCode() {
                int result = this.customMlMemberAbilities.hashCode();
                return result;
            }
        }
    }
    /**
     * An object representing the collaboration member's machine learning payment responsibilities set by the collaboration creator.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.cleanrooms.*;
     * MLPaymentConfigProperty mLPaymentConfigProperty = MLPaymentConfigProperty.builder()
     *         .modelInference(ModelInferencePaymentConfigProperty.builder()
     *                 .isResponsible(false)
     *                 .build())
     *         .modelTraining(ModelTrainingPaymentConfigProperty.builder()
     *                 .isResponsible(false)
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cleanrooms-collaboration-mlpaymentconfig.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cleanrooms-collaboration-mlpaymentconfig.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_cleanrooms.CfnCollaboration.MLPaymentConfigProperty")
    @software.amazon.jsii.Jsii.Proxy(MLPaymentConfigProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface MLPaymentConfigProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The payment responsibilities accepted by the member for model inference.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cleanrooms-collaboration-mlpaymentconfig.html#cfn-cleanrooms-collaboration-mlpaymentconfig-modelinference">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cleanrooms-collaboration-mlpaymentconfig.html#cfn-cleanrooms-collaboration-mlpaymentconfig-modelinference</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getModelInference() {
            return null;
        }

        /**
         * The payment responsibilities accepted by the member for model training.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cleanrooms-collaboration-mlpaymentconfig.html#cfn-cleanrooms-collaboration-mlpaymentconfig-modeltraining">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cleanrooms-collaboration-mlpaymentconfig.html#cfn-cleanrooms-collaboration-mlpaymentconfig-modeltraining</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getModelTraining() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link MLPaymentConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link MLPaymentConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<MLPaymentConfigProperty> {
            java.lang.Object modelInference;
            java.lang.Object modelTraining;

            /**
             * Sets the value of {@link MLPaymentConfigProperty#getModelInference}
             * @param modelInference The payment responsibilities accepted by the member for model inference.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder modelInference(software.amazon.awscdk.IResolvable modelInference) {
                this.modelInference = modelInference;
                return this;
            }

            /**
             * Sets the value of {@link MLPaymentConfigProperty#getModelInference}
             * @param modelInference The payment responsibilities accepted by the member for model inference.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder modelInference(software.amazon.awscdk.services.cleanrooms.CfnCollaboration.ModelInferencePaymentConfigProperty modelInference) {
                this.modelInference = modelInference;
                return this;
            }

            /**
             * Sets the value of {@link MLPaymentConfigProperty#getModelTraining}
             * @param modelTraining The payment responsibilities accepted by the member for model training.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder modelTraining(software.amazon.awscdk.IResolvable modelTraining) {
                this.modelTraining = modelTraining;
                return this;
            }

            /**
             * Sets the value of {@link MLPaymentConfigProperty#getModelTraining}
             * @param modelTraining The payment responsibilities accepted by the member for model training.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder modelTraining(software.amazon.awscdk.services.cleanrooms.CfnCollaboration.ModelTrainingPaymentConfigProperty modelTraining) {
                this.modelTraining = modelTraining;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link MLPaymentConfigProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public MLPaymentConfigProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link MLPaymentConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements MLPaymentConfigProperty {
            private final java.lang.Object modelInference;
            private final java.lang.Object modelTraining;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.modelInference = software.amazon.jsii.Kernel.get(this, "modelInference", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.modelTraining = software.amazon.jsii.Kernel.get(this, "modelTraining", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.modelInference = builder.modelInference;
                this.modelTraining = builder.modelTraining;
            }

            @Override
            public final java.lang.Object getModelInference() {
                return this.modelInference;
            }

            @Override
            public final java.lang.Object getModelTraining() {
                return this.modelTraining;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getModelInference() != null) {
                    data.set("modelInference", om.valueToTree(this.getModelInference()));
                }
                if (this.getModelTraining() != null) {
                    data.set("modelTraining", om.valueToTree(this.getModelTraining()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_cleanrooms.CfnCollaboration.MLPaymentConfigProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                MLPaymentConfigProperty.Jsii$Proxy that = (MLPaymentConfigProperty.Jsii$Proxy) o;

                if (this.modelInference != null ? !this.modelInference.equals(that.modelInference) : that.modelInference != null) return false;
                return this.modelTraining != null ? this.modelTraining.equals(that.modelTraining) : that.modelTraining == null;
            }

            @Override
            public final int hashCode() {
                int result = this.modelInference != null ? this.modelInference.hashCode() : 0;
                result = 31 * result + (this.modelTraining != null ? this.modelTraining.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Basic metadata used to construct a new member.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.cleanrooms.*;
     * MemberSpecificationProperty memberSpecificationProperty = MemberSpecificationProperty.builder()
     *         .accountId("accountId")
     *         .displayName("displayName")
     *         .memberAbilities(List.of("memberAbilities"))
     *         // the properties below are optional
     *         .mlMemberAbilities(MLMemberAbilitiesProperty.builder()
     *                 .customMlMemberAbilities(List.of("customMlMemberAbilities"))
     *                 .build())
     *         .paymentConfiguration(PaymentConfigurationProperty.builder()
     *                 .queryCompute(QueryComputePaymentConfigProperty.builder()
     *                         .isResponsible(false)
     *                         .build())
     *                 // the properties below are optional
     *                 .machineLearning(MLPaymentConfigProperty.builder()
     *                         .modelInference(ModelInferencePaymentConfigProperty.builder()
     *                                 .isResponsible(false)
     *                                 .build())
     *                         .modelTraining(ModelTrainingPaymentConfigProperty.builder()
     *                                 .isResponsible(false)
     *                                 .build())
     *                         .build())
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cleanrooms-collaboration-memberspecification.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cleanrooms-collaboration-memberspecification.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_cleanrooms.CfnCollaboration.MemberSpecificationProperty")
    @software.amazon.jsii.Jsii.Proxy(MemberSpecificationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface MemberSpecificationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The identifier used to reference members of the collaboration.
         * <p>
         * Currently only supports AWS account ID.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cleanrooms-collaboration-memberspecification.html#cfn-cleanrooms-collaboration-memberspecification-accountid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cleanrooms-collaboration-memberspecification.html#cfn-cleanrooms-collaboration-memberspecification-accountid</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getAccountId();

        /**
         * The member's display name.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cleanrooms-collaboration-memberspecification.html#cfn-cleanrooms-collaboration-memberspecification-displayname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cleanrooms-collaboration-memberspecification.html#cfn-cleanrooms-collaboration-memberspecification-displayname</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getDisplayName();

        /**
         * The abilities granted to the collaboration member.
         * <p>
         * <em>Allowed Values</em> : <code>CAN_QUERY</code> | <code>CAN_RECEIVE_RESULTS</code>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cleanrooms-collaboration-memberspecification.html#cfn-cleanrooms-collaboration-memberspecification-memberabilities">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cleanrooms-collaboration-memberspecification.html#cfn-cleanrooms-collaboration-memberspecification-memberabilities</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> getMemberAbilities();

        /**
         * The ML abilities granted to the collaboration member.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cleanrooms-collaboration-memberspecification.html#cfn-cleanrooms-collaboration-memberspecification-mlmemberabilities">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cleanrooms-collaboration-memberspecification.html#cfn-cleanrooms-collaboration-memberspecification-mlmemberabilities</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getMlMemberAbilities() {
            return null;
        }

        /**
         * The collaboration member's payment responsibilities set by the collaboration creator.
         * <p>
         * If the collaboration creator hasn't speciﬁed anyone as the member paying for query compute costs, then the member who can query is the default payer.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cleanrooms-collaboration-memberspecification.html#cfn-cleanrooms-collaboration-memberspecification-paymentconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cleanrooms-collaboration-memberspecification.html#cfn-cleanrooms-collaboration-memberspecification-paymentconfiguration</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getPaymentConfiguration() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link MemberSpecificationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link MemberSpecificationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<MemberSpecificationProperty> {
            java.lang.String accountId;
            java.lang.String displayName;
            java.util.List<java.lang.String> memberAbilities;
            java.lang.Object mlMemberAbilities;
            java.lang.Object paymentConfiguration;

            /**
             * Sets the value of {@link MemberSpecificationProperty#getAccountId}
             * @param accountId The identifier used to reference members of the collaboration. This parameter is required.
             *                  Currently only supports AWS account ID.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder accountId(java.lang.String accountId) {
                this.accountId = accountId;
                return this;
            }

            /**
             * Sets the value of {@link MemberSpecificationProperty#getDisplayName}
             * @param displayName The member's display name. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder displayName(java.lang.String displayName) {
                this.displayName = displayName;
                return this;
            }

            /**
             * Sets the value of {@link MemberSpecificationProperty#getMemberAbilities}
             * @param memberAbilities The abilities granted to the collaboration member. This parameter is required.
             *                        <em>Allowed Values</em> : <code>CAN_QUERY</code> | <code>CAN_RECEIVE_RESULTS</code>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder memberAbilities(java.util.List<java.lang.String> memberAbilities) {
                this.memberAbilities = memberAbilities;
                return this;
            }

            /**
             * Sets the value of {@link MemberSpecificationProperty#getMlMemberAbilities}
             * @param mlMemberAbilities The ML abilities granted to the collaboration member.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder mlMemberAbilities(software.amazon.awscdk.IResolvable mlMemberAbilities) {
                this.mlMemberAbilities = mlMemberAbilities;
                return this;
            }

            /**
             * Sets the value of {@link MemberSpecificationProperty#getMlMemberAbilities}
             * @param mlMemberAbilities The ML abilities granted to the collaboration member.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder mlMemberAbilities(software.amazon.awscdk.services.cleanrooms.CfnCollaboration.MLMemberAbilitiesProperty mlMemberAbilities) {
                this.mlMemberAbilities = mlMemberAbilities;
                return this;
            }

            /**
             * Sets the value of {@link MemberSpecificationProperty#getPaymentConfiguration}
             * @param paymentConfiguration The collaboration member's payment responsibilities set by the collaboration creator.
             *                             If the collaboration creator hasn't speciﬁed anyone as the member paying for query compute costs, then the member who can query is the default payer.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder paymentConfiguration(software.amazon.awscdk.IResolvable paymentConfiguration) {
                this.paymentConfiguration = paymentConfiguration;
                return this;
            }

            /**
             * Sets the value of {@link MemberSpecificationProperty#getPaymentConfiguration}
             * @param paymentConfiguration The collaboration member's payment responsibilities set by the collaboration creator.
             *                             If the collaboration creator hasn't speciﬁed anyone as the member paying for query compute costs, then the member who can query is the default payer.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder paymentConfiguration(software.amazon.awscdk.services.cleanrooms.CfnCollaboration.PaymentConfigurationProperty paymentConfiguration) {
                this.paymentConfiguration = paymentConfiguration;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link MemberSpecificationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public MemberSpecificationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link MemberSpecificationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements MemberSpecificationProperty {
            private final java.lang.String accountId;
            private final java.lang.String displayName;
            private final java.util.List<java.lang.String> memberAbilities;
            private final java.lang.Object mlMemberAbilities;
            private final java.lang.Object paymentConfiguration;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.accountId = software.amazon.jsii.Kernel.get(this, "accountId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.displayName = software.amazon.jsii.Kernel.get(this, "displayName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.memberAbilities = software.amazon.jsii.Kernel.get(this, "memberAbilities", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.mlMemberAbilities = software.amazon.jsii.Kernel.get(this, "mlMemberAbilities", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.paymentConfiguration = software.amazon.jsii.Kernel.get(this, "paymentConfiguration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.accountId = java.util.Objects.requireNonNull(builder.accountId, "accountId is required");
                this.displayName = java.util.Objects.requireNonNull(builder.displayName, "displayName is required");
                this.memberAbilities = java.util.Objects.requireNonNull(builder.memberAbilities, "memberAbilities is required");
                this.mlMemberAbilities = builder.mlMemberAbilities;
                this.paymentConfiguration = builder.paymentConfiguration;
            }

            @Override
            public final java.lang.String getAccountId() {
                return this.accountId;
            }

            @Override
            public final java.lang.String getDisplayName() {
                return this.displayName;
            }

            @Override
            public final java.util.List<java.lang.String> getMemberAbilities() {
                return this.memberAbilities;
            }

            @Override
            public final java.lang.Object getMlMemberAbilities() {
                return this.mlMemberAbilities;
            }

            @Override
            public final java.lang.Object getPaymentConfiguration() {
                return this.paymentConfiguration;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("accountId", om.valueToTree(this.getAccountId()));
                data.set("displayName", om.valueToTree(this.getDisplayName()));
                data.set("memberAbilities", om.valueToTree(this.getMemberAbilities()));
                if (this.getMlMemberAbilities() != null) {
                    data.set("mlMemberAbilities", om.valueToTree(this.getMlMemberAbilities()));
                }
                if (this.getPaymentConfiguration() != null) {
                    data.set("paymentConfiguration", om.valueToTree(this.getPaymentConfiguration()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_cleanrooms.CfnCollaboration.MemberSpecificationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                MemberSpecificationProperty.Jsii$Proxy that = (MemberSpecificationProperty.Jsii$Proxy) o;

                if (!accountId.equals(that.accountId)) return false;
                if (!displayName.equals(that.displayName)) return false;
                if (!memberAbilities.equals(that.memberAbilities)) return false;
                if (this.mlMemberAbilities != null ? !this.mlMemberAbilities.equals(that.mlMemberAbilities) : that.mlMemberAbilities != null) return false;
                return this.paymentConfiguration != null ? this.paymentConfiguration.equals(that.paymentConfiguration) : that.paymentConfiguration == null;
            }

            @Override
            public final int hashCode() {
                int result = this.accountId.hashCode();
                result = 31 * result + (this.displayName.hashCode());
                result = 31 * result + (this.memberAbilities.hashCode());
                result = 31 * result + (this.mlMemberAbilities != null ? this.mlMemberAbilities.hashCode() : 0);
                result = 31 * result + (this.paymentConfiguration != null ? this.paymentConfiguration.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * An object representing the collaboration member's model inference payment responsibilities set by the collaboration creator.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.cleanrooms.*;
     * ModelInferencePaymentConfigProperty modelInferencePaymentConfigProperty = ModelInferencePaymentConfigProperty.builder()
     *         .isResponsible(false)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cleanrooms-collaboration-modelinferencepaymentconfig.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cleanrooms-collaboration-modelinferencepaymentconfig.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_cleanrooms.CfnCollaboration.ModelInferencePaymentConfigProperty")
    @software.amazon.jsii.Jsii.Proxy(ModelInferencePaymentConfigProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ModelInferencePaymentConfigProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Indicates whether the collaboration creator has configured the collaboration member to pay for model inference costs ( <code>TRUE</code> ) or has not configured the collaboration member to pay for model inference costs ( <code>FALSE</code> ).
         * <p>
         * Exactly one member can be configured to pay for model inference costs. An error is returned if the collaboration creator sets a <code>TRUE</code> value for more than one member in the collaboration.
         * <p>
         * If the collaboration creator hasn't specified anyone as the member paying for model inference costs, then the member who can query is the default payer. An error is returned if the collaboration creator sets a <code>FALSE</code> value for the member who can query.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cleanrooms-collaboration-modelinferencepaymentconfig.html#cfn-cleanrooms-collaboration-modelinferencepaymentconfig-isresponsible">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cleanrooms-collaboration-modelinferencepaymentconfig.html#cfn-cleanrooms-collaboration-modelinferencepaymentconfig-isresponsible</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getIsResponsible();

        /**
         * @return a {@link Builder} of {@link ModelInferencePaymentConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ModelInferencePaymentConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ModelInferencePaymentConfigProperty> {
            java.lang.Object isResponsible;

            /**
             * Sets the value of {@link ModelInferencePaymentConfigProperty#getIsResponsible}
             * @param isResponsible Indicates whether the collaboration creator has configured the collaboration member to pay for model inference costs ( <code>TRUE</code> ) or has not configured the collaboration member to pay for model inference costs ( <code>FALSE</code> ). This parameter is required.
             *                      Exactly one member can be configured to pay for model inference costs. An error is returned if the collaboration creator sets a <code>TRUE</code> value for more than one member in the collaboration.
             *                      <p>
             *                      If the collaboration creator hasn't specified anyone as the member paying for model inference costs, then the member who can query is the default payer. An error is returned if the collaboration creator sets a <code>FALSE</code> value for the member who can query.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder isResponsible(java.lang.Boolean isResponsible) {
                this.isResponsible = isResponsible;
                return this;
            }

            /**
             * Sets the value of {@link ModelInferencePaymentConfigProperty#getIsResponsible}
             * @param isResponsible Indicates whether the collaboration creator has configured the collaboration member to pay for model inference costs ( <code>TRUE</code> ) or has not configured the collaboration member to pay for model inference costs ( <code>FALSE</code> ). This parameter is required.
             *                      Exactly one member can be configured to pay for model inference costs. An error is returned if the collaboration creator sets a <code>TRUE</code> value for more than one member in the collaboration.
             *                      <p>
             *                      If the collaboration creator hasn't specified anyone as the member paying for model inference costs, then the member who can query is the default payer. An error is returned if the collaboration creator sets a <code>FALSE</code> value for the member who can query.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder isResponsible(software.amazon.awscdk.IResolvable isResponsible) {
                this.isResponsible = isResponsible;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ModelInferencePaymentConfigProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ModelInferencePaymentConfigProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ModelInferencePaymentConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ModelInferencePaymentConfigProperty {
            private final java.lang.Object isResponsible;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.isResponsible = software.amazon.jsii.Kernel.get(this, "isResponsible", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.isResponsible = java.util.Objects.requireNonNull(builder.isResponsible, "isResponsible is required");
            }

            @Override
            public final java.lang.Object getIsResponsible() {
                return this.isResponsible;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("isResponsible", om.valueToTree(this.getIsResponsible()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_cleanrooms.CfnCollaboration.ModelInferencePaymentConfigProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ModelInferencePaymentConfigProperty.Jsii$Proxy that = (ModelInferencePaymentConfigProperty.Jsii$Proxy) o;

                return this.isResponsible.equals(that.isResponsible);
            }

            @Override
            public final int hashCode() {
                int result = this.isResponsible.hashCode();
                return result;
            }
        }
    }
    /**
     * An object representing the collaboration member's model training payment responsibilities set by the collaboration creator.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.cleanrooms.*;
     * ModelTrainingPaymentConfigProperty modelTrainingPaymentConfigProperty = ModelTrainingPaymentConfigProperty.builder()
     *         .isResponsible(false)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cleanrooms-collaboration-modeltrainingpaymentconfig.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cleanrooms-collaboration-modeltrainingpaymentconfig.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_cleanrooms.CfnCollaboration.ModelTrainingPaymentConfigProperty")
    @software.amazon.jsii.Jsii.Proxy(ModelTrainingPaymentConfigProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface ModelTrainingPaymentConfigProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Indicates whether the collaboration creator has configured the collaboration member to pay for model training costs ( <code>TRUE</code> ) or has not configured the collaboration member to pay for model training costs ( <code>FALSE</code> ).
         * <p>
         * Exactly one member can be configured to pay for model training costs. An error is returned if the collaboration creator sets a <code>TRUE</code> value for more than one member in the collaboration.
         * <p>
         * If the collaboration creator hasn't specified anyone as the member paying for model training costs, then the member who can query is the default payer. An error is returned if the collaboration creator sets a <code>FALSE</code> value for the member who can query.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cleanrooms-collaboration-modeltrainingpaymentconfig.html#cfn-cleanrooms-collaboration-modeltrainingpaymentconfig-isresponsible">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cleanrooms-collaboration-modeltrainingpaymentconfig.html#cfn-cleanrooms-collaboration-modeltrainingpaymentconfig-isresponsible</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getIsResponsible();

        /**
         * @return a {@link Builder} of {@link ModelTrainingPaymentConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link ModelTrainingPaymentConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<ModelTrainingPaymentConfigProperty> {
            java.lang.Object isResponsible;

            /**
             * Sets the value of {@link ModelTrainingPaymentConfigProperty#getIsResponsible}
             * @param isResponsible Indicates whether the collaboration creator has configured the collaboration member to pay for model training costs ( <code>TRUE</code> ) or has not configured the collaboration member to pay for model training costs ( <code>FALSE</code> ). This parameter is required.
             *                      Exactly one member can be configured to pay for model training costs. An error is returned if the collaboration creator sets a <code>TRUE</code> value for more than one member in the collaboration.
             *                      <p>
             *                      If the collaboration creator hasn't specified anyone as the member paying for model training costs, then the member who can query is the default payer. An error is returned if the collaboration creator sets a <code>FALSE</code> value for the member who can query.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder isResponsible(java.lang.Boolean isResponsible) {
                this.isResponsible = isResponsible;
                return this;
            }

            /**
             * Sets the value of {@link ModelTrainingPaymentConfigProperty#getIsResponsible}
             * @param isResponsible Indicates whether the collaboration creator has configured the collaboration member to pay for model training costs ( <code>TRUE</code> ) or has not configured the collaboration member to pay for model training costs ( <code>FALSE</code> ). This parameter is required.
             *                      Exactly one member can be configured to pay for model training costs. An error is returned if the collaboration creator sets a <code>TRUE</code> value for more than one member in the collaboration.
             *                      <p>
             *                      If the collaboration creator hasn't specified anyone as the member paying for model training costs, then the member who can query is the default payer. An error is returned if the collaboration creator sets a <code>FALSE</code> value for the member who can query.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder isResponsible(software.amazon.awscdk.IResolvable isResponsible) {
                this.isResponsible = isResponsible;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link ModelTrainingPaymentConfigProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public ModelTrainingPaymentConfigProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link ModelTrainingPaymentConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements ModelTrainingPaymentConfigProperty {
            private final java.lang.Object isResponsible;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.isResponsible = software.amazon.jsii.Kernel.get(this, "isResponsible", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.isResponsible = java.util.Objects.requireNonNull(builder.isResponsible, "isResponsible is required");
            }

            @Override
            public final java.lang.Object getIsResponsible() {
                return this.isResponsible;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("isResponsible", om.valueToTree(this.getIsResponsible()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_cleanrooms.CfnCollaboration.ModelTrainingPaymentConfigProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                ModelTrainingPaymentConfigProperty.Jsii$Proxy that = (ModelTrainingPaymentConfigProperty.Jsii$Proxy) o;

                return this.isResponsible.equals(that.isResponsible);
            }

            @Override
            public final int hashCode() {
                int result = this.isResponsible.hashCode();
                return result;
            }
        }
    }
    /**
     * An object representing the collaboration member's payment responsibilities set by the collaboration creator.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.cleanrooms.*;
     * PaymentConfigurationProperty paymentConfigurationProperty = PaymentConfigurationProperty.builder()
     *         .queryCompute(QueryComputePaymentConfigProperty.builder()
     *                 .isResponsible(false)
     *                 .build())
     *         // the properties below are optional
     *         .machineLearning(MLPaymentConfigProperty.builder()
     *                 .modelInference(ModelInferencePaymentConfigProperty.builder()
     *                         .isResponsible(false)
     *                         .build())
     *                 .modelTraining(ModelTrainingPaymentConfigProperty.builder()
     *                         .isResponsible(false)
     *                         .build())
     *                 .build())
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cleanrooms-collaboration-paymentconfiguration.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cleanrooms-collaboration-paymentconfiguration.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_cleanrooms.CfnCollaboration.PaymentConfigurationProperty")
    @software.amazon.jsii.Jsii.Proxy(PaymentConfigurationProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface PaymentConfigurationProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The collaboration member's payment responsibilities set by the collaboration creator for query compute costs.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cleanrooms-collaboration-paymentconfiguration.html#cfn-cleanrooms-collaboration-paymentconfiguration-querycompute">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cleanrooms-collaboration-paymentconfiguration.html#cfn-cleanrooms-collaboration-paymentconfiguration-querycompute</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getQueryCompute();

        /**
         * An object representing the collaboration member's machine learning payment responsibilities set by the collaboration creator.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cleanrooms-collaboration-paymentconfiguration.html#cfn-cleanrooms-collaboration-paymentconfiguration-machinelearning">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cleanrooms-collaboration-paymentconfiguration.html#cfn-cleanrooms-collaboration-paymentconfiguration-machinelearning</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getMachineLearning() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link PaymentConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link PaymentConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<PaymentConfigurationProperty> {
            java.lang.Object queryCompute;
            java.lang.Object machineLearning;

            /**
             * Sets the value of {@link PaymentConfigurationProperty#getQueryCompute}
             * @param queryCompute The collaboration member's payment responsibilities set by the collaboration creator for query compute costs. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder queryCompute(software.amazon.awscdk.IResolvable queryCompute) {
                this.queryCompute = queryCompute;
                return this;
            }

            /**
             * Sets the value of {@link PaymentConfigurationProperty#getQueryCompute}
             * @param queryCompute The collaboration member's payment responsibilities set by the collaboration creator for query compute costs. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder queryCompute(software.amazon.awscdk.services.cleanrooms.CfnCollaboration.QueryComputePaymentConfigProperty queryCompute) {
                this.queryCompute = queryCompute;
                return this;
            }

            /**
             * Sets the value of {@link PaymentConfigurationProperty#getMachineLearning}
             * @param machineLearning An object representing the collaboration member's machine learning payment responsibilities set by the collaboration creator.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder machineLearning(software.amazon.awscdk.IResolvable machineLearning) {
                this.machineLearning = machineLearning;
                return this;
            }

            /**
             * Sets the value of {@link PaymentConfigurationProperty#getMachineLearning}
             * @param machineLearning An object representing the collaboration member's machine learning payment responsibilities set by the collaboration creator.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder machineLearning(software.amazon.awscdk.services.cleanrooms.CfnCollaboration.MLPaymentConfigProperty machineLearning) {
                this.machineLearning = machineLearning;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link PaymentConfigurationProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public PaymentConfigurationProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link PaymentConfigurationProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements PaymentConfigurationProperty {
            private final java.lang.Object queryCompute;
            private final java.lang.Object machineLearning;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.queryCompute = software.amazon.jsii.Kernel.get(this, "queryCompute", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.machineLearning = software.amazon.jsii.Kernel.get(this, "machineLearning", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.queryCompute = java.util.Objects.requireNonNull(builder.queryCompute, "queryCompute is required");
                this.machineLearning = builder.machineLearning;
            }

            @Override
            public final java.lang.Object getQueryCompute() {
                return this.queryCompute;
            }

            @Override
            public final java.lang.Object getMachineLearning() {
                return this.machineLearning;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("queryCompute", om.valueToTree(this.getQueryCompute()));
                if (this.getMachineLearning() != null) {
                    data.set("machineLearning", om.valueToTree(this.getMachineLearning()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_cleanrooms.CfnCollaboration.PaymentConfigurationProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                PaymentConfigurationProperty.Jsii$Proxy that = (PaymentConfigurationProperty.Jsii$Proxy) o;

                if (!queryCompute.equals(that.queryCompute)) return false;
                return this.machineLearning != null ? this.machineLearning.equals(that.machineLearning) : that.machineLearning == null;
            }

            @Override
            public final int hashCode() {
                int result = this.queryCompute.hashCode();
                result = 31 * result + (this.machineLearning != null ? this.machineLearning.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * An object representing the collaboration member's payment responsibilities set by the collaboration creator for query compute costs.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.cleanrooms.*;
     * QueryComputePaymentConfigProperty queryComputePaymentConfigProperty = QueryComputePaymentConfigProperty.builder()
     *         .isResponsible(false)
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cleanrooms-collaboration-querycomputepaymentconfig.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cleanrooms-collaboration-querycomputepaymentconfig.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_cleanrooms.CfnCollaboration.QueryComputePaymentConfigProperty")
    @software.amazon.jsii.Jsii.Proxy(QueryComputePaymentConfigProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface QueryComputePaymentConfigProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Indicates whether the collaboration creator has configured the collaboration member to pay for query compute costs ( <code>TRUE</code> ) or has not configured the collaboration member to pay for query compute costs ( <code>FALSE</code> ).
         * <p>
         * Exactly one member can be configured to pay for query compute costs. An error is returned if the collaboration creator sets a <code>TRUE</code> value for more than one member in the collaboration.
         * <p>
         * If the collaboration creator hasn't specified anyone as the member paying for query compute costs, then the member who can query is the default payer. An error is returned if the collaboration creator sets a <code>FALSE</code> value for the member who can query.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cleanrooms-collaboration-querycomputepaymentconfig.html#cfn-cleanrooms-collaboration-querycomputepaymentconfig-isresponsible">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cleanrooms-collaboration-querycomputepaymentconfig.html#cfn-cleanrooms-collaboration-querycomputepaymentconfig-isresponsible</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getIsResponsible();

        /**
         * @return a {@link Builder} of {@link QueryComputePaymentConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link QueryComputePaymentConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<QueryComputePaymentConfigProperty> {
            java.lang.Object isResponsible;

            /**
             * Sets the value of {@link QueryComputePaymentConfigProperty#getIsResponsible}
             * @param isResponsible Indicates whether the collaboration creator has configured the collaboration member to pay for query compute costs ( <code>TRUE</code> ) or has not configured the collaboration member to pay for query compute costs ( <code>FALSE</code> ). This parameter is required.
             *                      Exactly one member can be configured to pay for query compute costs. An error is returned if the collaboration creator sets a <code>TRUE</code> value for more than one member in the collaboration.
             *                      <p>
             *                      If the collaboration creator hasn't specified anyone as the member paying for query compute costs, then the member who can query is the default payer. An error is returned if the collaboration creator sets a <code>FALSE</code> value for the member who can query.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder isResponsible(java.lang.Boolean isResponsible) {
                this.isResponsible = isResponsible;
                return this;
            }

            /**
             * Sets the value of {@link QueryComputePaymentConfigProperty#getIsResponsible}
             * @param isResponsible Indicates whether the collaboration creator has configured the collaboration member to pay for query compute costs ( <code>TRUE</code> ) or has not configured the collaboration member to pay for query compute costs ( <code>FALSE</code> ). This parameter is required.
             *                      Exactly one member can be configured to pay for query compute costs. An error is returned if the collaboration creator sets a <code>TRUE</code> value for more than one member in the collaboration.
             *                      <p>
             *                      If the collaboration creator hasn't specified anyone as the member paying for query compute costs, then the member who can query is the default payer. An error is returned if the collaboration creator sets a <code>FALSE</code> value for the member who can query.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder isResponsible(software.amazon.awscdk.IResolvable isResponsible) {
                this.isResponsible = isResponsible;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link QueryComputePaymentConfigProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public QueryComputePaymentConfigProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link QueryComputePaymentConfigProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements QueryComputePaymentConfigProperty {
            private final java.lang.Object isResponsible;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.isResponsible = software.amazon.jsii.Kernel.get(this, "isResponsible", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.isResponsible = java.util.Objects.requireNonNull(builder.isResponsible, "isResponsible is required");
            }

            @Override
            public final java.lang.Object getIsResponsible() {
                return this.isResponsible;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("isResponsible", om.valueToTree(this.getIsResponsible()));

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_cleanrooms.CfnCollaboration.QueryComputePaymentConfigProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                QueryComputePaymentConfigProperty.Jsii$Proxy that = (QueryComputePaymentConfigProperty.Jsii$Proxy) o;

                return this.isResponsible.equals(that.isResponsible);
            }

            @Override
            public final int hashCode() {
                int result = this.isResponsible.hashCode();
                return result;
            }
        }
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.cleanrooms.CfnCollaboration}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.cleanrooms.CfnCollaboration> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope Scope in which this resource is defined. This parameter is required.
         * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.cleanrooms.CfnCollaborationProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.cleanrooms.CfnCollaborationProps.Builder();
        }

        /**
         * A display name of the collaboration creator.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cleanrooms-collaboration.html#cfn-cleanrooms-collaboration-creatordisplayname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cleanrooms-collaboration.html#cfn-cleanrooms-collaboration-creatordisplayname</a>
         * @param creatorDisplayName A display name of the collaboration creator. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder creatorDisplayName(final java.lang.String creatorDisplayName) {
            this.props.creatorDisplayName(creatorDisplayName);
            return this;
        }

        /**
         * The abilities granted to the collaboration creator.
         * <p>
         * <em>Allowed values</em> <code>CAN_QUERY</code> | <code>CAN_RECEIVE_RESULTS</code>
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cleanrooms-collaboration.html#cfn-cleanrooms-collaboration-creatormemberabilities">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cleanrooms-collaboration.html#cfn-cleanrooms-collaboration-creatormemberabilities</a>
         * @param creatorMemberAbilities The abilities granted to the collaboration creator. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder creatorMemberAbilities(final java.util.List<java.lang.String> creatorMemberAbilities) {
            this.props.creatorMemberAbilities(creatorMemberAbilities);
            return this;
        }

        /**
         * A description of the collaboration provided by the collaboration owner.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cleanrooms-collaboration.html#cfn-cleanrooms-collaboration-description">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cleanrooms-collaboration.html#cfn-cleanrooms-collaboration-description</a>
         * @param description A description of the collaboration provided by the collaboration owner. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder description(final java.lang.String description) {
            this.props.description(description);
            return this;
        }

        /**
         * A list of initial members, not including the creator.
         * <p>
         * This list is immutable.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cleanrooms-collaboration.html#cfn-cleanrooms-collaboration-members">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cleanrooms-collaboration.html#cfn-cleanrooms-collaboration-members</a>
         * @param members A list of initial members, not including the creator. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder members(final software.amazon.awscdk.IResolvable members) {
            this.props.members(members);
            return this;
        }
        /**
         * A list of initial members, not including the creator.
         * <p>
         * This list is immutable.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cleanrooms-collaboration.html#cfn-cleanrooms-collaboration-members">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cleanrooms-collaboration.html#cfn-cleanrooms-collaboration-members</a>
         * @param members A list of initial members, not including the creator. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder members(final java.util.List<? extends java.lang.Object> members) {
            this.props.members(members);
            return this;
        }

        /**
         * A human-readable identifier provided by the collaboration owner.
         * <p>
         * Display names are not unique.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cleanrooms-collaboration.html#cfn-cleanrooms-collaboration-name">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cleanrooms-collaboration.html#cfn-cleanrooms-collaboration-name</a>
         * @param name A human-readable identifier provided by the collaboration owner. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder name(final java.lang.String name) {
            this.props.name(name);
            return this;
        }

        /**
         * An indicator as to whether query logging has been enabled or disabled for the collaboration.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cleanrooms-collaboration.html#cfn-cleanrooms-collaboration-querylogstatus">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cleanrooms-collaboration.html#cfn-cleanrooms-collaboration-querylogstatus</a>
         * @param queryLogStatus An indicator as to whether query logging has been enabled or disabled for the collaboration. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder queryLogStatus(final java.lang.String queryLogStatus) {
            this.props.queryLogStatus(queryLogStatus);
            return this;
        }

        /**
         * The analytics engine for the collaboration.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cleanrooms-collaboration.html#cfn-cleanrooms-collaboration-analyticsengine">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cleanrooms-collaboration.html#cfn-cleanrooms-collaboration-analyticsengine</a>
         * @param analyticsEngine The analytics engine for the collaboration. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder analyticsEngine(final java.lang.String analyticsEngine) {
            this.props.analyticsEngine(analyticsEngine);
            return this;
        }

        /**
         * The ML member abilities for a collaboration member.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cleanrooms-collaboration.html#cfn-cleanrooms-collaboration-creatormlmemberabilities">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cleanrooms-collaboration.html#cfn-cleanrooms-collaboration-creatormlmemberabilities</a>
         * @param creatorMlMemberAbilities The ML member abilities for a collaboration member. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder creatorMlMemberAbilities(final software.amazon.awscdk.IResolvable creatorMlMemberAbilities) {
            this.props.creatorMlMemberAbilities(creatorMlMemberAbilities);
            return this;
        }
        /**
         * The ML member abilities for a collaboration member.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cleanrooms-collaboration.html#cfn-cleanrooms-collaboration-creatormlmemberabilities">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cleanrooms-collaboration.html#cfn-cleanrooms-collaboration-creatormlmemberabilities</a>
         * @param creatorMlMemberAbilities The ML member abilities for a collaboration member. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder creatorMlMemberAbilities(final software.amazon.awscdk.services.cleanrooms.CfnCollaboration.MLMemberAbilitiesProperty creatorMlMemberAbilities) {
            this.props.creatorMlMemberAbilities(creatorMlMemberAbilities);
            return this;
        }

        /**
         * An object representing the collaboration member's payment responsibilities set by the collaboration creator.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cleanrooms-collaboration.html#cfn-cleanrooms-collaboration-creatorpaymentconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cleanrooms-collaboration.html#cfn-cleanrooms-collaboration-creatorpaymentconfiguration</a>
         * @param creatorPaymentConfiguration An object representing the collaboration member's payment responsibilities set by the collaboration creator. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder creatorPaymentConfiguration(final software.amazon.awscdk.IResolvable creatorPaymentConfiguration) {
            this.props.creatorPaymentConfiguration(creatorPaymentConfiguration);
            return this;
        }
        /**
         * An object representing the collaboration member's payment responsibilities set by the collaboration creator.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cleanrooms-collaboration.html#cfn-cleanrooms-collaboration-creatorpaymentconfiguration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cleanrooms-collaboration.html#cfn-cleanrooms-collaboration-creatorpaymentconfiguration</a>
         * @param creatorPaymentConfiguration An object representing the collaboration member's payment responsibilities set by the collaboration creator. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder creatorPaymentConfiguration(final software.amazon.awscdk.services.cleanrooms.CfnCollaboration.PaymentConfigurationProperty creatorPaymentConfiguration) {
            this.props.creatorPaymentConfiguration(creatorPaymentConfiguration);
            return this;
        }

        /**
         * The settings for client-side encryption for cryptographic computing.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cleanrooms-collaboration.html#cfn-cleanrooms-collaboration-dataencryptionmetadata">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cleanrooms-collaboration.html#cfn-cleanrooms-collaboration-dataencryptionmetadata</a>
         * @param dataEncryptionMetadata The settings for client-side encryption for cryptographic computing. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder dataEncryptionMetadata(final software.amazon.awscdk.IResolvable dataEncryptionMetadata) {
            this.props.dataEncryptionMetadata(dataEncryptionMetadata);
            return this;
        }
        /**
         * The settings for client-side encryption for cryptographic computing.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cleanrooms-collaboration.html#cfn-cleanrooms-collaboration-dataencryptionmetadata">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cleanrooms-collaboration.html#cfn-cleanrooms-collaboration-dataencryptionmetadata</a>
         * @param dataEncryptionMetadata The settings for client-side encryption for cryptographic computing. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder dataEncryptionMetadata(final software.amazon.awscdk.services.cleanrooms.CfnCollaboration.DataEncryptionMetadataProperty dataEncryptionMetadata) {
            this.props.dataEncryptionMetadata(dataEncryptionMetadata);
            return this;
        }

        /**
         * An optional label that you can assign to a resource when you create it.
         * <p>
         * Each tag consists of a key and an optional value, both of which you define. When you use tagging, you can also use tag-based access control in IAM policies to control access to this resource.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cleanrooms-collaboration.html#cfn-cleanrooms-collaboration-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cleanrooms-collaboration.html#cfn-cleanrooms-collaboration-tags</a>
         * @param tags An optional label that you can assign to a resource when you create it. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tags(final java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.props.tags(tags);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.cleanrooms.CfnCollaboration}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.cleanrooms.CfnCollaboration build() {
            return new software.amazon.awscdk.services.cleanrooms.CfnCollaboration(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
