package software.amazon.awscdk.services.cloudfront;

/**
 * Options for adding a new behavior to a Distribution.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // Add a behavior to a Distribution after initial creation.
 * Bucket myBucket;
 * Distribution myWebDistribution;
 * myWebDistribution.addBehavior("/images/*.jpg", new S3Origin(myBucket), AddBehaviorOptions.builder()
 *         .viewerProtocolPolicy(ViewerProtocolPolicy.REDIRECT_TO_HTTPS)
 *         .build());
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.106.0 (build e852934)", date = "2025-02-21T03:20:29.496Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_cloudfront.AddBehaviorOptions")
@software.amazon.jsii.Jsii.Proxy(AddBehaviorOptions.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface AddBehaviorOptions extends software.amazon.jsii.JsiiSerializable {

    /**
     * HTTP methods to allow for this behavior.
     * <p>
     * Default: AllowedMethods.ALLOW_GET_HEAD
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudfront.AllowedMethods getAllowedMethods() {
        return null;
    }

    /**
     * HTTP methods to cache for this behavior.
     * <p>
     * Default: CachedMethods.CACHE_GET_HEAD
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudfront.CachedMethods getCachedMethods() {
        return null;
    }

    /**
     * The cache policy for this behavior.
     * <p>
     * The cache policy determines what values are included in the cache key,
     * and the time-to-live (TTL) values for the cache.
     * <p>
     * Default: CachePolicy.CACHING_OPTIMIZED
     * <p>
     * @see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-the-cache-key.html.">https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/controlling-the-cache-key.html.</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudfront.ICachePolicy getCachePolicy() {
        return null;
    }

    /**
     * Whether you want CloudFront to automatically compress certain files for this cache behavior.
     * <p>
     * See https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/ServingCompressedFiles.html#compressed-content-cloudfront-file-types
     * for file types CloudFront will compress.
     * <p>
     * Default: true
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getCompress() {
        return null;
    }

    /**
     * The Lambda&#64;Edge functions to invoke before serving the contents.
     * <p>
     * Default: - no Lambda functions will be invoked
     * <p>
     * @see <a href="https://aws.amazon.com/lambda/edge">https://aws.amazon.com/lambda/edge</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.services.cloudfront.EdgeLambda> getEdgeLambdas() {
        return null;
    }

    /**
     * Enables your CloudFront distribution to receive gRPC requests and to proxy them directly to your origins.
     * <p>
     * If the <code>enableGrpc</code> is set to true, the following restrictions apply:
     * <p>
     * <ul>
     * <li>The <code>allowedMethods</code> property must be <code>AllowedMethods.ALLOW_ALL</code> to include POST method because gRPC only supports POST method.</li>
     * <li>The <code>httpVersion</code> property must be <code>HttpVersion.HTTP2</code> or <code>HttpVersion.HTTP2_AND_3</code> because gRPC only supports versions including HTTP/2.</li>
     * <li>The <code>edgeLambdas</code> property can't be specified because gRPC is not supported with Lambda&#64;Edge.</li>
     * </ul>
     * <p>
     * Default: false
     * <p>
     * @see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/distribution-using-grpc.html">https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/distribution-using-grpc.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getEnableGrpc() {
        return null;
    }

    /**
     * The CloudFront functions to invoke before serving the contents.
     * <p>
     * Default: - no functions will be invoked
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.services.cloudfront.FunctionAssociation> getFunctionAssociations() {
        return null;
    }

    /**
     * The origin request policy for this behavior.
     * <p>
     * The origin request policy determines which values (e.g., headers, cookies)
     * are included in requests that CloudFront sends to the origin.
     * <p>
     * Default: - none
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudfront.IOriginRequestPolicy getOriginRequestPolicy() {
        return null;
    }

    /**
     * The real-time log configuration to be attached to this cache behavior.
     * <p>
     * Default: - none
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudfront.IRealtimeLogConfig getRealtimeLogConfig() {
        return null;
    }

    /**
     * The response headers policy for this behavior.
     * <p>
     * The response headers policy determines which headers are included in responses
     * <p>
     * Default: - none
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudfront.IResponseHeadersPolicy getResponseHeadersPolicy() {
        return null;
    }

    /**
     * Set this to true to indicate you want to distribute media files in the Microsoft Smooth Streaming format using this behavior.
     * <p>
     * Default: false
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getSmoothStreaming() {
        return null;
    }

    /**
     * A list of Key Groups that CloudFront can use to validate signed URLs or signed cookies.
     * <p>
     * Default: - no KeyGroups are associated with cache behavior
     * <p>
     * @see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/PrivateContent.html">https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/PrivateContent.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.services.cloudfront.IKeyGroup> getTrustedKeyGroups() {
        return null;
    }

    /**
     * The protocol that viewers can use to access the files controlled by this behavior.
     * <p>
     * Default: ViewerProtocolPolicy.ALLOW_ALL
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudfront.ViewerProtocolPolicy getViewerProtocolPolicy() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link AddBehaviorOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link AddBehaviorOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<AddBehaviorOptions> {
        software.amazon.awscdk.services.cloudfront.AllowedMethods allowedMethods;
        software.amazon.awscdk.services.cloudfront.CachedMethods cachedMethods;
        software.amazon.awscdk.services.cloudfront.ICachePolicy cachePolicy;
        java.lang.Boolean compress;
        java.util.List<software.amazon.awscdk.services.cloudfront.EdgeLambda> edgeLambdas;
        java.lang.Boolean enableGrpc;
        java.util.List<software.amazon.awscdk.services.cloudfront.FunctionAssociation> functionAssociations;
        software.amazon.awscdk.services.cloudfront.IOriginRequestPolicy originRequestPolicy;
        software.amazon.awscdk.services.cloudfront.IRealtimeLogConfig realtimeLogConfig;
        software.amazon.awscdk.services.cloudfront.IResponseHeadersPolicy responseHeadersPolicy;
        java.lang.Boolean smoothStreaming;
        java.util.List<software.amazon.awscdk.services.cloudfront.IKeyGroup> trustedKeyGroups;
        software.amazon.awscdk.services.cloudfront.ViewerProtocolPolicy viewerProtocolPolicy;

        /**
         * Sets the value of {@link AddBehaviorOptions#getAllowedMethods}
         * @param allowedMethods HTTP methods to allow for this behavior.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder allowedMethods(software.amazon.awscdk.services.cloudfront.AllowedMethods allowedMethods) {
            this.allowedMethods = allowedMethods;
            return this;
        }

        /**
         * Sets the value of {@link AddBehaviorOptions#getCachedMethods}
         * @param cachedMethods HTTP methods to cache for this behavior.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder cachedMethods(software.amazon.awscdk.services.cloudfront.CachedMethods cachedMethods) {
            this.cachedMethods = cachedMethods;
            return this;
        }

        /**
         * Sets the value of {@link AddBehaviorOptions#getCachePolicy}
         * @param cachePolicy The cache policy for this behavior.
         *                    The cache policy determines what values are included in the cache key,
         *                    and the time-to-live (TTL) values for the cache.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder cachePolicy(software.amazon.awscdk.services.cloudfront.ICachePolicy cachePolicy) {
            this.cachePolicy = cachePolicy;
            return this;
        }

        /**
         * Sets the value of {@link AddBehaviorOptions#getCompress}
         * @param compress Whether you want CloudFront to automatically compress certain files for this cache behavior.
         *                 See https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/ServingCompressedFiles.html#compressed-content-cloudfront-file-types
         *                 for file types CloudFront will compress.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder compress(java.lang.Boolean compress) {
            this.compress = compress;
            return this;
        }

        /**
         * Sets the value of {@link AddBehaviorOptions#getEdgeLambdas}
         * @param edgeLambdas The Lambda&#64;Edge functions to invoke before serving the contents.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder edgeLambdas(java.util.List<? extends software.amazon.awscdk.services.cloudfront.EdgeLambda> edgeLambdas) {
            this.edgeLambdas = (java.util.List<software.amazon.awscdk.services.cloudfront.EdgeLambda>)edgeLambdas;
            return this;
        }

        /**
         * Sets the value of {@link AddBehaviorOptions#getEnableGrpc}
         * @param enableGrpc Enables your CloudFront distribution to receive gRPC requests and to proxy them directly to your origins.
         *                   If the <code>enableGrpc</code> is set to true, the following restrictions apply:
         *                   <p>
         *                   <ul>
         *                   <li>The <code>allowedMethods</code> property must be <code>AllowedMethods.ALLOW_ALL</code> to include POST method because gRPC only supports POST method.</li>
         *                   <li>The <code>httpVersion</code> property must be <code>HttpVersion.HTTP2</code> or <code>HttpVersion.HTTP2_AND_3</code> because gRPC only supports versions including HTTP/2.</li>
         *                   <li>The <code>edgeLambdas</code> property can't be specified because gRPC is not supported with Lambda&#64;Edge.</li>
         *                   </ul>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder enableGrpc(java.lang.Boolean enableGrpc) {
            this.enableGrpc = enableGrpc;
            return this;
        }

        /**
         * Sets the value of {@link AddBehaviorOptions#getFunctionAssociations}
         * @param functionAssociations The CloudFront functions to invoke before serving the contents.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder functionAssociations(java.util.List<? extends software.amazon.awscdk.services.cloudfront.FunctionAssociation> functionAssociations) {
            this.functionAssociations = (java.util.List<software.amazon.awscdk.services.cloudfront.FunctionAssociation>)functionAssociations;
            return this;
        }

        /**
         * Sets the value of {@link AddBehaviorOptions#getOriginRequestPolicy}
         * @param originRequestPolicy The origin request policy for this behavior.
         *                            The origin request policy determines which values (e.g., headers, cookies)
         *                            are included in requests that CloudFront sends to the origin.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder originRequestPolicy(software.amazon.awscdk.services.cloudfront.IOriginRequestPolicy originRequestPolicy) {
            this.originRequestPolicy = originRequestPolicy;
            return this;
        }

        /**
         * Sets the value of {@link AddBehaviorOptions#getRealtimeLogConfig}
         * @param realtimeLogConfig The real-time log configuration to be attached to this cache behavior.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder realtimeLogConfig(software.amazon.awscdk.services.cloudfront.IRealtimeLogConfig realtimeLogConfig) {
            this.realtimeLogConfig = realtimeLogConfig;
            return this;
        }

        /**
         * Sets the value of {@link AddBehaviorOptions#getResponseHeadersPolicy}
         * @param responseHeadersPolicy The response headers policy for this behavior.
         *                              The response headers policy determines which headers are included in responses
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder responseHeadersPolicy(software.amazon.awscdk.services.cloudfront.IResponseHeadersPolicy responseHeadersPolicy) {
            this.responseHeadersPolicy = responseHeadersPolicy;
            return this;
        }

        /**
         * Sets the value of {@link AddBehaviorOptions#getSmoothStreaming}
         * @param smoothStreaming Set this to true to indicate you want to distribute media files in the Microsoft Smooth Streaming format using this behavior.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder smoothStreaming(java.lang.Boolean smoothStreaming) {
            this.smoothStreaming = smoothStreaming;
            return this;
        }

        /**
         * Sets the value of {@link AddBehaviorOptions#getTrustedKeyGroups}
         * @param trustedKeyGroups A list of Key Groups that CloudFront can use to validate signed URLs or signed cookies.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder trustedKeyGroups(java.util.List<? extends software.amazon.awscdk.services.cloudfront.IKeyGroup> trustedKeyGroups) {
            this.trustedKeyGroups = (java.util.List<software.amazon.awscdk.services.cloudfront.IKeyGroup>)trustedKeyGroups;
            return this;
        }

        /**
         * Sets the value of {@link AddBehaviorOptions#getViewerProtocolPolicy}
         * @param viewerProtocolPolicy The protocol that viewers can use to access the files controlled by this behavior.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder viewerProtocolPolicy(software.amazon.awscdk.services.cloudfront.ViewerProtocolPolicy viewerProtocolPolicy) {
            this.viewerProtocolPolicy = viewerProtocolPolicy;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link AddBehaviorOptions}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public AddBehaviorOptions build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link AddBehaviorOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements AddBehaviorOptions {
        private final software.amazon.awscdk.services.cloudfront.AllowedMethods allowedMethods;
        private final software.amazon.awscdk.services.cloudfront.CachedMethods cachedMethods;
        private final software.amazon.awscdk.services.cloudfront.ICachePolicy cachePolicy;
        private final java.lang.Boolean compress;
        private final java.util.List<software.amazon.awscdk.services.cloudfront.EdgeLambda> edgeLambdas;
        private final java.lang.Boolean enableGrpc;
        private final java.util.List<software.amazon.awscdk.services.cloudfront.FunctionAssociation> functionAssociations;
        private final software.amazon.awscdk.services.cloudfront.IOriginRequestPolicy originRequestPolicy;
        private final software.amazon.awscdk.services.cloudfront.IRealtimeLogConfig realtimeLogConfig;
        private final software.amazon.awscdk.services.cloudfront.IResponseHeadersPolicy responseHeadersPolicy;
        private final java.lang.Boolean smoothStreaming;
        private final java.util.List<software.amazon.awscdk.services.cloudfront.IKeyGroup> trustedKeyGroups;
        private final software.amazon.awscdk.services.cloudfront.ViewerProtocolPolicy viewerProtocolPolicy;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.allowedMethods = software.amazon.jsii.Kernel.get(this, "allowedMethods", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudfront.AllowedMethods.class));
            this.cachedMethods = software.amazon.jsii.Kernel.get(this, "cachedMethods", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudfront.CachedMethods.class));
            this.cachePolicy = software.amazon.jsii.Kernel.get(this, "cachePolicy", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudfront.ICachePolicy.class));
            this.compress = software.amazon.jsii.Kernel.get(this, "compress", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.edgeLambdas = software.amazon.jsii.Kernel.get(this, "edgeLambdas", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudfront.EdgeLambda.class)));
            this.enableGrpc = software.amazon.jsii.Kernel.get(this, "enableGrpc", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.functionAssociations = software.amazon.jsii.Kernel.get(this, "functionAssociations", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudfront.FunctionAssociation.class)));
            this.originRequestPolicy = software.amazon.jsii.Kernel.get(this, "originRequestPolicy", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudfront.IOriginRequestPolicy.class));
            this.realtimeLogConfig = software.amazon.jsii.Kernel.get(this, "realtimeLogConfig", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudfront.IRealtimeLogConfig.class));
            this.responseHeadersPolicy = software.amazon.jsii.Kernel.get(this, "responseHeadersPolicy", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudfront.IResponseHeadersPolicy.class));
            this.smoothStreaming = software.amazon.jsii.Kernel.get(this, "smoothStreaming", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.trustedKeyGroups = software.amazon.jsii.Kernel.get(this, "trustedKeyGroups", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudfront.IKeyGroup.class)));
            this.viewerProtocolPolicy = software.amazon.jsii.Kernel.get(this, "viewerProtocolPolicy", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudfront.ViewerProtocolPolicy.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.allowedMethods = builder.allowedMethods;
            this.cachedMethods = builder.cachedMethods;
            this.cachePolicy = builder.cachePolicy;
            this.compress = builder.compress;
            this.edgeLambdas = (java.util.List<software.amazon.awscdk.services.cloudfront.EdgeLambda>)builder.edgeLambdas;
            this.enableGrpc = builder.enableGrpc;
            this.functionAssociations = (java.util.List<software.amazon.awscdk.services.cloudfront.FunctionAssociation>)builder.functionAssociations;
            this.originRequestPolicy = builder.originRequestPolicy;
            this.realtimeLogConfig = builder.realtimeLogConfig;
            this.responseHeadersPolicy = builder.responseHeadersPolicy;
            this.smoothStreaming = builder.smoothStreaming;
            this.trustedKeyGroups = (java.util.List<software.amazon.awscdk.services.cloudfront.IKeyGroup>)builder.trustedKeyGroups;
            this.viewerProtocolPolicy = builder.viewerProtocolPolicy;
        }

        @Override
        public final software.amazon.awscdk.services.cloudfront.AllowedMethods getAllowedMethods() {
            return this.allowedMethods;
        }

        @Override
        public final software.amazon.awscdk.services.cloudfront.CachedMethods getCachedMethods() {
            return this.cachedMethods;
        }

        @Override
        public final software.amazon.awscdk.services.cloudfront.ICachePolicy getCachePolicy() {
            return this.cachePolicy;
        }

        @Override
        public final java.lang.Boolean getCompress() {
            return this.compress;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.services.cloudfront.EdgeLambda> getEdgeLambdas() {
            return this.edgeLambdas;
        }

        @Override
        public final java.lang.Boolean getEnableGrpc() {
            return this.enableGrpc;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.services.cloudfront.FunctionAssociation> getFunctionAssociations() {
            return this.functionAssociations;
        }

        @Override
        public final software.amazon.awscdk.services.cloudfront.IOriginRequestPolicy getOriginRequestPolicy() {
            return this.originRequestPolicy;
        }

        @Override
        public final software.amazon.awscdk.services.cloudfront.IRealtimeLogConfig getRealtimeLogConfig() {
            return this.realtimeLogConfig;
        }

        @Override
        public final software.amazon.awscdk.services.cloudfront.IResponseHeadersPolicy getResponseHeadersPolicy() {
            return this.responseHeadersPolicy;
        }

        @Override
        public final java.lang.Boolean getSmoothStreaming() {
            return this.smoothStreaming;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.services.cloudfront.IKeyGroup> getTrustedKeyGroups() {
            return this.trustedKeyGroups;
        }

        @Override
        public final software.amazon.awscdk.services.cloudfront.ViewerProtocolPolicy getViewerProtocolPolicy() {
            return this.viewerProtocolPolicy;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getAllowedMethods() != null) {
                data.set("allowedMethods", om.valueToTree(this.getAllowedMethods()));
            }
            if (this.getCachedMethods() != null) {
                data.set("cachedMethods", om.valueToTree(this.getCachedMethods()));
            }
            if (this.getCachePolicy() != null) {
                data.set("cachePolicy", om.valueToTree(this.getCachePolicy()));
            }
            if (this.getCompress() != null) {
                data.set("compress", om.valueToTree(this.getCompress()));
            }
            if (this.getEdgeLambdas() != null) {
                data.set("edgeLambdas", om.valueToTree(this.getEdgeLambdas()));
            }
            if (this.getEnableGrpc() != null) {
                data.set("enableGrpc", om.valueToTree(this.getEnableGrpc()));
            }
            if (this.getFunctionAssociations() != null) {
                data.set("functionAssociations", om.valueToTree(this.getFunctionAssociations()));
            }
            if (this.getOriginRequestPolicy() != null) {
                data.set("originRequestPolicy", om.valueToTree(this.getOriginRequestPolicy()));
            }
            if (this.getRealtimeLogConfig() != null) {
                data.set("realtimeLogConfig", om.valueToTree(this.getRealtimeLogConfig()));
            }
            if (this.getResponseHeadersPolicy() != null) {
                data.set("responseHeadersPolicy", om.valueToTree(this.getResponseHeadersPolicy()));
            }
            if (this.getSmoothStreaming() != null) {
                data.set("smoothStreaming", om.valueToTree(this.getSmoothStreaming()));
            }
            if (this.getTrustedKeyGroups() != null) {
                data.set("trustedKeyGroups", om.valueToTree(this.getTrustedKeyGroups()));
            }
            if (this.getViewerProtocolPolicy() != null) {
                data.set("viewerProtocolPolicy", om.valueToTree(this.getViewerProtocolPolicy()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_cloudfront.AddBehaviorOptions"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            AddBehaviorOptions.Jsii$Proxy that = (AddBehaviorOptions.Jsii$Proxy) o;

            if (this.allowedMethods != null ? !this.allowedMethods.equals(that.allowedMethods) : that.allowedMethods != null) return false;
            if (this.cachedMethods != null ? !this.cachedMethods.equals(that.cachedMethods) : that.cachedMethods != null) return false;
            if (this.cachePolicy != null ? !this.cachePolicy.equals(that.cachePolicy) : that.cachePolicy != null) return false;
            if (this.compress != null ? !this.compress.equals(that.compress) : that.compress != null) return false;
            if (this.edgeLambdas != null ? !this.edgeLambdas.equals(that.edgeLambdas) : that.edgeLambdas != null) return false;
            if (this.enableGrpc != null ? !this.enableGrpc.equals(that.enableGrpc) : that.enableGrpc != null) return false;
            if (this.functionAssociations != null ? !this.functionAssociations.equals(that.functionAssociations) : that.functionAssociations != null) return false;
            if (this.originRequestPolicy != null ? !this.originRequestPolicy.equals(that.originRequestPolicy) : that.originRequestPolicy != null) return false;
            if (this.realtimeLogConfig != null ? !this.realtimeLogConfig.equals(that.realtimeLogConfig) : that.realtimeLogConfig != null) return false;
            if (this.responseHeadersPolicy != null ? !this.responseHeadersPolicy.equals(that.responseHeadersPolicy) : that.responseHeadersPolicy != null) return false;
            if (this.smoothStreaming != null ? !this.smoothStreaming.equals(that.smoothStreaming) : that.smoothStreaming != null) return false;
            if (this.trustedKeyGroups != null ? !this.trustedKeyGroups.equals(that.trustedKeyGroups) : that.trustedKeyGroups != null) return false;
            return this.viewerProtocolPolicy != null ? this.viewerProtocolPolicy.equals(that.viewerProtocolPolicy) : that.viewerProtocolPolicy == null;
        }

        @Override
        public final int hashCode() {
            int result = this.allowedMethods != null ? this.allowedMethods.hashCode() : 0;
            result = 31 * result + (this.cachedMethods != null ? this.cachedMethods.hashCode() : 0);
            result = 31 * result + (this.cachePolicy != null ? this.cachePolicy.hashCode() : 0);
            result = 31 * result + (this.compress != null ? this.compress.hashCode() : 0);
            result = 31 * result + (this.edgeLambdas != null ? this.edgeLambdas.hashCode() : 0);
            result = 31 * result + (this.enableGrpc != null ? this.enableGrpc.hashCode() : 0);
            result = 31 * result + (this.functionAssociations != null ? this.functionAssociations.hashCode() : 0);
            result = 31 * result + (this.originRequestPolicy != null ? this.originRequestPolicy.hashCode() : 0);
            result = 31 * result + (this.realtimeLogConfig != null ? this.realtimeLogConfig.hashCode() : 0);
            result = 31 * result + (this.responseHeadersPolicy != null ? this.responseHeadersPolicy.hashCode() : 0);
            result = 31 * result + (this.smoothStreaming != null ? this.smoothStreaming.hashCode() : 0);
            result = 31 * result + (this.trustedKeyGroups != null ? this.trustedKeyGroups.hashCode() : 0);
            result = 31 * result + (this.viewerProtocolPolicy != null ? this.viewerProtocolPolicy.hashCode() : 0);
            return result;
        }
    }
}
