package software.amazon.awscdk.services.cloudfront;

/**
 * A CloudFront Key Value Store.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * KeyValueStore store = new KeyValueStore(this, "KeyValueStore");
 * Function.Builder.create(this, "Function")
 *         .code(FunctionCode.fromInline("function handler(event) { return event.request }"))
 *         // Note that JS_2_0 must be used for Key Value Store support
 *         .runtime(FunctionRuntime.JS_2_0)
 *         .keyValueStore(store)
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.106.0 (build e852934)", date = "2025-02-21T03:20:29.649Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_cloudfront.KeyValueStore")
public class KeyValueStore extends software.amazon.awscdk.Resource implements software.amazon.awscdk.services.cloudfront.IKeyValueStore {

    protected KeyValueStore(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected KeyValueStore(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public KeyValueStore(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudfront.KeyValueStoreProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), props });
    }

    /**
     * @param scope This parameter is required.
     * @param id This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public KeyValueStore(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required") });
    }

    /**
     * Import a Key Value Store using its ARN.
     * <p>
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param keyValueStoreArn This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudfront.IKeyValueStore fromKeyValueStoreArn(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull java.lang.String keyValueStoreArn) {
        return software.amazon.jsii.JsiiObject.jsiiStaticCall(software.amazon.awscdk.services.cloudfront.KeyValueStore.class, "fromKeyValueStoreArn", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudfront.IKeyValueStore.class), new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(keyValueStoreArn, "keyValueStoreArn is required") });
    }

    /**
     * The ARN of the Key Value Store.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getKeyValueStoreArn() {
        return software.amazon.jsii.Kernel.get(this, "keyValueStoreArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The Unique ID of the Key Value Store.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getKeyValueStoreId() {
        return software.amazon.jsii.Kernel.get(this, "keyValueStoreId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The status of the Key Value Store.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getKeyValueStoreStatus() {
        return software.amazon.jsii.Kernel.get(this, "keyValueStoreStatus", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.cloudfront.KeyValueStore}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.cloudfront.KeyValueStore> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope This parameter is required.
         * @param id This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private software.amazon.awscdk.services.cloudfront.KeyValueStoreProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
        }

        /**
         * A comment for the Key Value Store.
         * <p>
         * Default: No comment will be specified
         * <p>
         * @return {@code this}
         * @param comment A comment for the Key Value Store. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder comment(final java.lang.String comment) {
            this.props().comment(comment);
            return this;
        }

        /**
         * The unique name of the Key Value Store.
         * <p>
         * Default: A generated name
         * <p>
         * @return {@code this}
         * @param keyValueStoreName The unique name of the Key Value Store. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder keyValueStoreName(final java.lang.String keyValueStoreName) {
            this.props().keyValueStoreName(keyValueStoreName);
            return this;
        }

        /**
         * The import source for the Key Value Store.
         * <p>
         * This will populate the initial items in the Key Value Store. The
         * source data must be in a valid JSON format.
         * <p>
         * Default: No data will be imported to the store
         * <p>
         * @return {@code this}
         * @param source The import source for the Key Value Store. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder source(final software.amazon.awscdk.services.cloudfront.ImportSource source) {
            this.props().source(source);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.cloudfront.KeyValueStore}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.cloudfront.KeyValueStore build() {
            return new software.amazon.awscdk.services.cloudfront.KeyValueStore(
                this.scope,
                this.id,
                this.props != null ? this.props.build() : null
            );
        }

        private software.amazon.awscdk.services.cloudfront.KeyValueStoreProps.Builder props() {
            if (this.props == null) {
                this.props = new software.amazon.awscdk.services.cloudfront.KeyValueStoreProps.Builder();
            }
            return this.props;
        }
    }
}
