package software.amazon.awscdk.services.cloudfront.origins;

/**
 * Construction properties for <code>OriginGroup</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * Bucket myBucket = new Bucket(this, "myBucket");
 * Distribution.Builder.create(this, "myDist")
 *         .defaultBehavior(BehaviorOptions.builder()
 *                 .origin(OriginGroup.Builder.create()
 *                         .primaryOrigin(S3BucketOrigin.withOriginAccessControl(myBucket))
 *                         .fallbackOrigin(new HttpOrigin("www.example.com"))
 *                         // optional, defaults to: 500, 502, 503 and 504
 *                         .fallbackStatusCodes(List.of(404))
 *                         .build())
 *                 .build())
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.106.0 (build e852934)", date = "2025-02-21T03:20:29.720Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_cloudfront_origins.OriginGroupProps")
@software.amazon.jsii.Jsii.Proxy(OriginGroupProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface OriginGroupProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The fallback origin that should serve requests when the primary fails.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudfront.IOrigin getFallbackOrigin();

    /**
     * The primary origin that should serve requests for this group.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudfront.IOrigin getPrimaryOrigin();

    /**
     * The list of HTTP status codes that, when returned from the primary origin, would cause querying the fallback origin.
     * <p>
     * Default: - 500, 502, 503 and 504
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<java.lang.Number> getFallbackStatusCodes() {
        return null;
    }

    /**
     * The selection criteria for the origin group.
     * <p>
     * Default: - OriginSelectionCriteria.DEFAULT
     * <p>
     * @see <a href="https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/high_availability_origin_failover.html#concept_origin_groups.creating">https://docs.aws.amazon.com/AmazonCloudFront/latest/DeveloperGuide/high_availability_origin_failover.html#concept_origin_groups.creating</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.cloudfront.OriginSelectionCriteria getSelectionCriteria() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link OriginGroupProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link OriginGroupProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<OriginGroupProps> {
        software.amazon.awscdk.services.cloudfront.IOrigin fallbackOrigin;
        software.amazon.awscdk.services.cloudfront.IOrigin primaryOrigin;
        java.util.List<java.lang.Number> fallbackStatusCodes;
        software.amazon.awscdk.services.cloudfront.OriginSelectionCriteria selectionCriteria;

        /**
         * Sets the value of {@link OriginGroupProps#getFallbackOrigin}
         * @param fallbackOrigin The fallback origin that should serve requests when the primary fails. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder fallbackOrigin(software.amazon.awscdk.services.cloudfront.IOrigin fallbackOrigin) {
            this.fallbackOrigin = fallbackOrigin;
            return this;
        }

        /**
         * Sets the value of {@link OriginGroupProps#getPrimaryOrigin}
         * @param primaryOrigin The primary origin that should serve requests for this group. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder primaryOrigin(software.amazon.awscdk.services.cloudfront.IOrigin primaryOrigin) {
            this.primaryOrigin = primaryOrigin;
            return this;
        }

        /**
         * Sets the value of {@link OriginGroupProps#getFallbackStatusCodes}
         * @param fallbackStatusCodes The list of HTTP status codes that, when returned from the primary origin, would cause querying the fallback origin.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder fallbackStatusCodes(java.util.List<? extends java.lang.Number> fallbackStatusCodes) {
            this.fallbackStatusCodes = (java.util.List<java.lang.Number>)fallbackStatusCodes;
            return this;
        }

        /**
         * Sets the value of {@link OriginGroupProps#getSelectionCriteria}
         * @param selectionCriteria The selection criteria for the origin group.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder selectionCriteria(software.amazon.awscdk.services.cloudfront.OriginSelectionCriteria selectionCriteria) {
            this.selectionCriteria = selectionCriteria;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link OriginGroupProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public OriginGroupProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link OriginGroupProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements OriginGroupProps {
        private final software.amazon.awscdk.services.cloudfront.IOrigin fallbackOrigin;
        private final software.amazon.awscdk.services.cloudfront.IOrigin primaryOrigin;
        private final java.util.List<java.lang.Number> fallbackStatusCodes;
        private final software.amazon.awscdk.services.cloudfront.OriginSelectionCriteria selectionCriteria;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.fallbackOrigin = software.amazon.jsii.Kernel.get(this, "fallbackOrigin", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudfront.IOrigin.class));
            this.primaryOrigin = software.amazon.jsii.Kernel.get(this, "primaryOrigin", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudfront.IOrigin.class));
            this.fallbackStatusCodes = software.amazon.jsii.Kernel.get(this, "fallbackStatusCodes", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.Number.class)));
            this.selectionCriteria = software.amazon.jsii.Kernel.get(this, "selectionCriteria", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.cloudfront.OriginSelectionCriteria.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.fallbackOrigin = java.util.Objects.requireNonNull(builder.fallbackOrigin, "fallbackOrigin is required");
            this.primaryOrigin = java.util.Objects.requireNonNull(builder.primaryOrigin, "primaryOrigin is required");
            this.fallbackStatusCodes = (java.util.List<java.lang.Number>)builder.fallbackStatusCodes;
            this.selectionCriteria = builder.selectionCriteria;
        }

        @Override
        public final software.amazon.awscdk.services.cloudfront.IOrigin getFallbackOrigin() {
            return this.fallbackOrigin;
        }

        @Override
        public final software.amazon.awscdk.services.cloudfront.IOrigin getPrimaryOrigin() {
            return this.primaryOrigin;
        }

        @Override
        public final java.util.List<java.lang.Number> getFallbackStatusCodes() {
            return this.fallbackStatusCodes;
        }

        @Override
        public final software.amazon.awscdk.services.cloudfront.OriginSelectionCriteria getSelectionCriteria() {
            return this.selectionCriteria;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("fallbackOrigin", om.valueToTree(this.getFallbackOrigin()));
            data.set("primaryOrigin", om.valueToTree(this.getPrimaryOrigin()));
            if (this.getFallbackStatusCodes() != null) {
                data.set("fallbackStatusCodes", om.valueToTree(this.getFallbackStatusCodes()));
            }
            if (this.getSelectionCriteria() != null) {
                data.set("selectionCriteria", om.valueToTree(this.getSelectionCriteria()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_cloudfront_origins.OriginGroupProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            OriginGroupProps.Jsii$Proxy that = (OriginGroupProps.Jsii$Proxy) o;

            if (!fallbackOrigin.equals(that.fallbackOrigin)) return false;
            if (!primaryOrigin.equals(that.primaryOrigin)) return false;
            if (this.fallbackStatusCodes != null ? !this.fallbackStatusCodes.equals(that.fallbackStatusCodes) : that.fallbackStatusCodes != null) return false;
            return this.selectionCriteria != null ? this.selectionCriteria.equals(that.selectionCriteria) : that.selectionCriteria == null;
        }

        @Override
        public final int hashCode() {
            int result = this.fallbackOrigin.hashCode();
            result = 31 * result + (this.primaryOrigin.hashCode());
            result = 31 * result + (this.fallbackStatusCodes != null ? this.fallbackStatusCodes.hashCode() : 0);
            result = 31 * result + (this.selectionCriteria != null ? this.selectionCriteria.hashCode() : 0);
            return result;
        }
    }
}
