package software.amazon.awscdk.services.cloudtrail;

/**
 * Creates a trail that specifies the settings for delivery of log data to an Amazon S3 bucket.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.cloudtrail.*;
 * CfnTrail cfnTrail = CfnTrail.Builder.create(this, "MyCfnTrail")
 *         .isLogging(false)
 *         .s3BucketName("s3BucketName")
 *         // the properties below are optional
 *         .advancedEventSelectors(List.of(AdvancedEventSelectorProperty.builder()
 *                 .fieldSelectors(List.of(AdvancedFieldSelectorProperty.builder()
 *                         .field("field")
 *                         // the properties below are optional
 *                         .endsWith(List.of("endsWith"))
 *                         .equalTo(List.of("equalTo"))
 *                         .notEndsWith(List.of("notEndsWith"))
 *                         .notEquals(List.of("notEquals"))
 *                         .notStartsWith(List.of("notStartsWith"))
 *                         .startsWith(List.of("startsWith"))
 *                         .build()))
 *                 // the properties below are optional
 *                 .name("name")
 *                 .build()))
 *         .cloudWatchLogsLogGroupArn("cloudWatchLogsLogGroupArn")
 *         .cloudWatchLogsRoleArn("cloudWatchLogsRoleArn")
 *         .enableLogFileValidation(false)
 *         .eventSelectors(List.of(EventSelectorProperty.builder()
 *                 .dataResources(List.of(DataResourceProperty.builder()
 *                         .type("type")
 *                         // the properties below are optional
 *                         .values(List.of("values"))
 *                         .build()))
 *                 .excludeManagementEventSources(List.of("excludeManagementEventSources"))
 *                 .includeManagementEvents(false)
 *                 .readWriteType("readWriteType")
 *                 .build()))
 *         .includeGlobalServiceEvents(false)
 *         .insightSelectors(List.of(InsightSelectorProperty.builder()
 *                 .insightType("insightType")
 *                 .build()))
 *         .isMultiRegionTrail(false)
 *         .isOrganizationTrail(false)
 *         .kmsKeyId("kmsKeyId")
 *         .s3KeyPrefix("s3KeyPrefix")
 *         .snsTopicName("snsTopicName")
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .trailName("trailName")
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudtrail-trail.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudtrail-trail.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.106.0 (build e852934)", date = "2025-02-21T03:20:29.762Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_cloudtrail.CfnTrail")
public class CfnTrail extends software.amazon.awscdk.CfnResource implements software.amazon.awscdk.IInspectable, software.amazon.awscdk.ITaggable {

    protected CfnTrail(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnTrail(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.cloudtrail.CfnTrail.class, "CFN_RESOURCE_TYPE_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * @param scope Scope in which this resource is defined. This parameter is required.
     * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
     * @param props Resource properties. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnTrail(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudtrail.CfnTrailProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * @param inspector tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.TreeInspector inspector) {
        software.amazon.jsii.Kernel.call(this, "inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     * <code>Ref</code> returns the ARN of the CloudTrail trail, such as <code>arn:aws:cloudtrail:us-east-2:123456789012:trail/myCloudTrail</code> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrArn() {
        return software.amazon.jsii.Kernel.get(this, "attrArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * <code>Ref</code> returns the ARN of the Amazon SNS topic that's associated with the CloudTrail trail, such as <code>arn:aws:sns:us-east-2:123456789012:mySNSTopic</code> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrSnsTopicArn() {
        return software.amazon.jsii.Kernel.get(this, "attrSnsTopicArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * Tag Manager which manages the tags for this resource.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.TagManager getTags() {
        return software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TagManager.class));
    }

    /**
     * Whether the CloudTrail trail is currently logging AWS API calls.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.Object getIsLogging() {
        return software.amazon.jsii.Kernel.get(this, "isLogging", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Whether the CloudTrail trail is currently logging AWS API calls.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setIsLogging(final @org.jetbrains.annotations.NotNull java.lang.Boolean value) {
        software.amazon.jsii.Kernel.set(this, "isLogging", java.util.Objects.requireNonNull(value, "isLogging is required"));
    }

    /**
     * Whether the CloudTrail trail is currently logging AWS API calls.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setIsLogging(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "isLogging", java.util.Objects.requireNonNull(value, "isLogging is required"));
    }

    /**
     * Specifies the name of the Amazon S3 bucket designated for publishing log files.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getS3BucketName() {
        return software.amazon.jsii.Kernel.get(this, "s3BucketName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Specifies the name of the Amazon S3 bucket designated for publishing log files.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setS3BucketName(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "s3BucketName", java.util.Objects.requireNonNull(value, "s3BucketName is required"));
    }

    /**
     * Specifies the settings for advanced event selectors.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getAdvancedEventSelectors() {
        return software.amazon.jsii.Kernel.get(this, "advancedEventSelectors", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Specifies the settings for advanced event selectors.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setAdvancedEventSelectors(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "advancedEventSelectors", value);
    }

    /**
     * Specifies the settings for advanced event selectors.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setAdvancedEventSelectors(final @org.jetbrains.annotations.Nullable java.util.List<java.lang.Object> value) {
        if (software.amazon.jsii.Configuration.getRuntimeTypeChecking()) {
            for (int __idx_ac66f0 = 0; __idx_ac66f0 < value.size(); __idx_ac66f0++) {
                final java.lang.Object __val_ac66f0 = value.get(__idx_ac66f0);
                if (
                     !(__val_ac66f0 instanceof software.amazon.awscdk.IResolvable)
                    && !(__val_ac66f0 instanceof software.amazon.awscdk.services.cloudtrail.CfnTrail.AdvancedEventSelectorProperty)
                    && !(__val_ac66f0.getClass().equals(software.amazon.jsii.JsiiObject.class))
                ) {
                    throw new IllegalArgumentException(
                        new java.lang.StringBuilder("Expected ")
                            .append("value").append(".get(").append(__idx_ac66f0).append(")")
                            .append(" to be one of: software.amazon.awscdk.IResolvable, software.amazon.awscdk.services.cloudtrail.CfnTrail.AdvancedEventSelectorProperty; received ")
                            .append(__val_ac66f0.getClass()).toString());
                }
            }
        }
        software.amazon.jsii.Kernel.set(this, "advancedEventSelectors", value);
    }

    /**
     * Specifies a log group name using an Amazon Resource Name (ARN), a unique identifier that represents the log group to which CloudTrail logs are delivered.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getCloudWatchLogsLogGroupArn() {
        return software.amazon.jsii.Kernel.get(this, "cloudWatchLogsLogGroupArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Specifies a log group name using an Amazon Resource Name (ARN), a unique identifier that represents the log group to which CloudTrail logs are delivered.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setCloudWatchLogsLogGroupArn(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "cloudWatchLogsLogGroupArn", value);
    }

    /**
     * Specifies the role for the CloudWatch Logs endpoint to assume to write to a user's log group.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getCloudWatchLogsRoleArn() {
        return software.amazon.jsii.Kernel.get(this, "cloudWatchLogsRoleArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Specifies the role for the CloudWatch Logs endpoint to assume to write to a user's log group.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setCloudWatchLogsRoleArn(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "cloudWatchLogsRoleArn", value);
    }

    /**
     * Specifies whether log file validation is enabled.
     * <p>
     * The default is false.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getEnableLogFileValidation() {
        return software.amazon.jsii.Kernel.get(this, "enableLogFileValidation", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Specifies whether log file validation is enabled.
     * <p>
     * The default is false.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setEnableLogFileValidation(final @org.jetbrains.annotations.Nullable java.lang.Boolean value) {
        software.amazon.jsii.Kernel.set(this, "enableLogFileValidation", value);
    }

    /**
     * Specifies whether log file validation is enabled.
     * <p>
     * The default is false.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setEnableLogFileValidation(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "enableLogFileValidation", value);
    }

    /**
     * Use event selectors to further specify the management and data event settings for your trail.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getEventSelectors() {
        return software.amazon.jsii.Kernel.get(this, "eventSelectors", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Use event selectors to further specify the management and data event settings for your trail.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setEventSelectors(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "eventSelectors", value);
    }

    /**
     * Use event selectors to further specify the management and data event settings for your trail.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setEventSelectors(final @org.jetbrains.annotations.Nullable java.util.List<java.lang.Object> value) {
        if (software.amazon.jsii.Configuration.getRuntimeTypeChecking()) {
            for (int __idx_ac66f0 = 0; __idx_ac66f0 < value.size(); __idx_ac66f0++) {
                final java.lang.Object __val_ac66f0 = value.get(__idx_ac66f0);
                if (
                     !(__val_ac66f0 instanceof software.amazon.awscdk.IResolvable)
                    && !(__val_ac66f0 instanceof software.amazon.awscdk.services.cloudtrail.CfnTrail.EventSelectorProperty)
                    && !(__val_ac66f0.getClass().equals(software.amazon.jsii.JsiiObject.class))
                ) {
                    throw new IllegalArgumentException(
                        new java.lang.StringBuilder("Expected ")
                            .append("value").append(".get(").append(__idx_ac66f0).append(")")
                            .append(" to be one of: software.amazon.awscdk.IResolvable, software.amazon.awscdk.services.cloudtrail.CfnTrail.EventSelectorProperty; received ")
                            .append(__val_ac66f0.getClass()).toString());
                }
            }
        }
        software.amazon.jsii.Kernel.set(this, "eventSelectors", value);
    }

    /**
     * Specifies whether the trail is publishing events from global services such as IAM to the log files.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getIncludeGlobalServiceEvents() {
        return software.amazon.jsii.Kernel.get(this, "includeGlobalServiceEvents", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Specifies whether the trail is publishing events from global services such as IAM to the log files.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setIncludeGlobalServiceEvents(final @org.jetbrains.annotations.Nullable java.lang.Boolean value) {
        software.amazon.jsii.Kernel.set(this, "includeGlobalServiceEvents", value);
    }

    /**
     * Specifies whether the trail is publishing events from global services such as IAM to the log files.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setIncludeGlobalServiceEvents(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "includeGlobalServiceEvents", value);
    }

    /**
     * A JSON string that contains the Insights types you want to log on a trail.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getInsightSelectors() {
        return software.amazon.jsii.Kernel.get(this, "insightSelectors", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * A JSON string that contains the Insights types you want to log on a trail.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setInsightSelectors(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "insightSelectors", value);
    }

    /**
     * A JSON string that contains the Insights types you want to log on a trail.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setInsightSelectors(final @org.jetbrains.annotations.Nullable java.util.List<java.lang.Object> value) {
        if (software.amazon.jsii.Configuration.getRuntimeTypeChecking()) {
            for (int __idx_ac66f0 = 0; __idx_ac66f0 < value.size(); __idx_ac66f0++) {
                final java.lang.Object __val_ac66f0 = value.get(__idx_ac66f0);
                if (
                     !(__val_ac66f0 instanceof software.amazon.awscdk.IResolvable)
                    && !(__val_ac66f0 instanceof software.amazon.awscdk.services.cloudtrail.CfnTrail.InsightSelectorProperty)
                    && !(__val_ac66f0.getClass().equals(software.amazon.jsii.JsiiObject.class))
                ) {
                    throw new IllegalArgumentException(
                        new java.lang.StringBuilder("Expected ")
                            .append("value").append(".get(").append(__idx_ac66f0).append(")")
                            .append(" to be one of: software.amazon.awscdk.IResolvable, software.amazon.awscdk.services.cloudtrail.CfnTrail.InsightSelectorProperty; received ")
                            .append(__val_ac66f0.getClass()).toString());
                }
            }
        }
        software.amazon.jsii.Kernel.set(this, "insightSelectors", value);
    }

    /**
     * Specifies whether the trail applies only to the current Region or to all Regions.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getIsMultiRegionTrail() {
        return software.amazon.jsii.Kernel.get(this, "isMultiRegionTrail", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Specifies whether the trail applies only to the current Region or to all Regions.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setIsMultiRegionTrail(final @org.jetbrains.annotations.Nullable java.lang.Boolean value) {
        software.amazon.jsii.Kernel.set(this, "isMultiRegionTrail", value);
    }

    /**
     * Specifies whether the trail applies only to the current Region or to all Regions.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setIsMultiRegionTrail(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "isMultiRegionTrail", value);
    }

    /**
     * Specifies whether the trail is applied to all accounts in an organization in AWS Organizations , or only for the current AWS account .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getIsOrganizationTrail() {
        return software.amazon.jsii.Kernel.get(this, "isOrganizationTrail", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Specifies whether the trail is applied to all accounts in an organization in AWS Organizations , or only for the current AWS account .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setIsOrganizationTrail(final @org.jetbrains.annotations.Nullable java.lang.Boolean value) {
        software.amazon.jsii.Kernel.set(this, "isOrganizationTrail", value);
    }

    /**
     * Specifies whether the trail is applied to all accounts in an organization in AWS Organizations , or only for the current AWS account .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setIsOrganizationTrail(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "isOrganizationTrail", value);
    }

    /**
     * Specifies the AWS KMS key ID to use to encrypt the logs delivered by CloudTrail.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getKmsKeyId() {
        return software.amazon.jsii.Kernel.get(this, "kmsKeyId", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Specifies the AWS KMS key ID to use to encrypt the logs delivered by CloudTrail.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setKmsKeyId(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "kmsKeyId", value);
    }

    /**
     * Specifies the Amazon S3 key prefix that comes after the name of the bucket you have designated for log file delivery.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getS3KeyPrefix() {
        return software.amazon.jsii.Kernel.get(this, "s3KeyPrefix", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Specifies the Amazon S3 key prefix that comes after the name of the bucket you have designated for log file delivery.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setS3KeyPrefix(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "s3KeyPrefix", value);
    }

    /**
     * Specifies the name of the Amazon SNS topic defined for notification of log file delivery.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getSnsTopicName() {
        return software.amazon.jsii.Kernel.get(this, "snsTopicName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Specifies the name of the Amazon SNS topic defined for notification of log file delivery.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setSnsTopicName(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "snsTopicName", value);
    }

    /**
     * A custom set of tags (key-value pairs) for this trail.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> getTagsRaw() {
        return java.util.Optional.ofNullable((java.util.List<software.amazon.awscdk.CfnTag>)(software.amazon.jsii.Kernel.get(this, "tagsRaw", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.CfnTag.class))))).map(java.util.Collections::unmodifiableList).orElse(null);
    }

    /**
     * A custom set of tags (key-value pairs) for this trail.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setTagsRaw(final @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> value) {
        software.amazon.jsii.Kernel.set(this, "tagsRaw", value);
    }

    /**
     * Specifies the name of the trail.
     * <p>
     * The name must meet the following requirements:.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getTrailName() {
        return software.amazon.jsii.Kernel.get(this, "trailName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Specifies the name of the trail.
     * <p>
     * The name must meet the following requirements:.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setTrailName(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "trailName", value);
    }
    /**
     * Advanced event selectors let you create fine-grained selectors for AWS CloudTrail management, data, and network activity events.
     * <p>
     * They help you control costs by logging only those events that are important to you. For more information about configuring advanced event selectors, see the <a href="https://docs.aws.amazon.com/awscloudtrail/latest/userguide/logging-data-events-with-cloudtrail.html">Logging data events</a> , <a href="https://docs.aws.amazon.com/awscloudtrail/latest/userguide/logging-network-events-with-cloudtrail.html">Logging network activity events</a> , and <a href="https://docs.aws.amazon.com/awscloudtrail/latest/userguide/logging-management-events-with-cloudtrail.html">Logging management events</a> topics in the <em>AWS CloudTrail User Guide</em> .
     * <p>
     * You cannot apply both event selectors and advanced event selectors to a trail.
     * <p>
     * <em>Supported CloudTrail event record fields for management events</em>
     * <p>
     * <ul>
     * <li><code>eventCategory</code> (required)</li>
     * <li><code>eventSource</code></li>
     * <li><code>readOnly</code></li>
     * </ul>
     * <p>
     * The following additional fields are available for event data stores:
     * <p>
     * <ul>
     * <li><code>eventName</code></li>
     * <li><code>eventType</code></li>
     * <li><code>sessionCredentialFromConsole</code></li>
     * <li><code>userIdentity.arn</code></li>
     * </ul>
     * <p>
     * <em>Supported CloudTrail event record fields for data events</em>
     * <p>
     * <ul>
     * <li><code>eventCategory</code> (required)</li>
     * <li><code>resources.type</code> (required)</li>
     * <li><code>readOnly</code></li>
     * <li><code>eventName</code></li>
     * <li><code>resources.ARN</code></li>
     * </ul>
     * <p>
     * The following additional fields are available for event data stores:
     * <p>
     * <ul>
     * <li><code>eventSource</code></li>
     * <li><code>eventType</code></li>
     * <li><code>sessionCredentialFromConsole</code></li>
     * <li><code>userIdentity.arn</code></li>
     * </ul>
     * <p>
     * <em>Supported CloudTrail event record fields for network activity events</em>
     * <p>
     * <ul>
     * <li><code>eventCategory</code> (required)</li>
     * <li><code>eventSource</code> (required)</li>
     * <li><code>eventName</code></li>
     * <li><code>errorCode</code> - The only valid value for <code>errorCode</code> is <code>VpceAccessDenied</code> .</li>
     * <li><code>vpcEndpointId</code></li>
     * </ul>
     * <p>
     * <blockquote>
     * <p>
     * For event data stores for CloudTrail Insights events, AWS Config configuration items, Audit Manager evidence, or events outside of AWS , the only supported field is <code>eventCategory</code> .
     * <p>
     * </blockquote>
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.cloudtrail.*;
     * AdvancedEventSelectorProperty advancedEventSelectorProperty = AdvancedEventSelectorProperty.builder()
     *         .fieldSelectors(List.of(AdvancedFieldSelectorProperty.builder()
     *                 .field("field")
     *                 // the properties below are optional
     *                 .endsWith(List.of("endsWith"))
     *                 .equalTo(List.of("equalTo"))
     *                 .notEndsWith(List.of("notEndsWith"))
     *                 .notEquals(List.of("notEquals"))
     *                 .notStartsWith(List.of("notStartsWith"))
     *                 .startsWith(List.of("startsWith"))
     *                 .build()))
     *         // the properties below are optional
     *         .name("name")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudtrail-trail-advancedeventselector.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudtrail-trail-advancedeventselector.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_cloudtrail.CfnTrail.AdvancedEventSelectorProperty")
    @software.amazon.jsii.Jsii.Proxy(AdvancedEventSelectorProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface AdvancedEventSelectorProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * Contains all selector statements in an advanced event selector.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudtrail-trail-advancedeventselector.html#cfn-cloudtrail-trail-advancedeventselector-fieldselectors">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudtrail-trail-advancedeventselector.html#cfn-cloudtrail-trail-advancedeventselector-fieldselectors</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.Object getFieldSelectors();

        /**
         * An optional, descriptive name for an advanced event selector, such as "Log data events for only two S3 buckets".
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudtrail-trail-advancedeventselector.html#cfn-cloudtrail-trail-advancedeventselector-name">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudtrail-trail-advancedeventselector.html#cfn-cloudtrail-trail-advancedeventselector-name</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getName() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link AdvancedEventSelectorProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link AdvancedEventSelectorProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<AdvancedEventSelectorProperty> {
            java.lang.Object fieldSelectors;
            java.lang.String name;

            /**
             * Sets the value of {@link AdvancedEventSelectorProperty#getFieldSelectors}
             * @param fieldSelectors Contains all selector statements in an advanced event selector. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder fieldSelectors(software.amazon.awscdk.IResolvable fieldSelectors) {
                this.fieldSelectors = fieldSelectors;
                return this;
            }

            /**
             * Sets the value of {@link AdvancedEventSelectorProperty#getFieldSelectors}
             * @param fieldSelectors Contains all selector statements in an advanced event selector. This parameter is required.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder fieldSelectors(java.util.List<? extends java.lang.Object> fieldSelectors) {
                this.fieldSelectors = fieldSelectors;
                return this;
            }

            /**
             * Sets the value of {@link AdvancedEventSelectorProperty#getName}
             * @param name An optional, descriptive name for an advanced event selector, such as "Log data events for only two S3 buckets".
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder name(java.lang.String name) {
                this.name = name;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link AdvancedEventSelectorProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public AdvancedEventSelectorProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link AdvancedEventSelectorProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements AdvancedEventSelectorProperty {
            private final java.lang.Object fieldSelectors;
            private final java.lang.String name;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.fieldSelectors = software.amazon.jsii.Kernel.get(this, "fieldSelectors", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.name = software.amazon.jsii.Kernel.get(this, "name", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.fieldSelectors = java.util.Objects.requireNonNull(builder.fieldSelectors, "fieldSelectors is required");
                this.name = builder.name;
            }

            @Override
            public final java.lang.Object getFieldSelectors() {
                return this.fieldSelectors;
            }

            @Override
            public final java.lang.String getName() {
                return this.name;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("fieldSelectors", om.valueToTree(this.getFieldSelectors()));
                if (this.getName() != null) {
                    data.set("name", om.valueToTree(this.getName()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_cloudtrail.CfnTrail.AdvancedEventSelectorProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                AdvancedEventSelectorProperty.Jsii$Proxy that = (AdvancedEventSelectorProperty.Jsii$Proxy) o;

                if (!fieldSelectors.equals(that.fieldSelectors)) return false;
                return this.name != null ? this.name.equals(that.name) : that.name == null;
            }

            @Override
            public final int hashCode() {
                int result = this.fieldSelectors.hashCode();
                result = 31 * result + (this.name != null ? this.name.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * A single selector statement in an advanced event selector.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.cloudtrail.*;
     * AdvancedFieldSelectorProperty advancedFieldSelectorProperty = AdvancedFieldSelectorProperty.builder()
     *         .field("field")
     *         // the properties below are optional
     *         .endsWith(List.of("endsWith"))
     *         .equalTo(List.of("equalTo"))
     *         .notEndsWith(List.of("notEndsWith"))
     *         .notEquals(List.of("notEquals"))
     *         .notStartsWith(List.of("notStartsWith"))
     *         .startsWith(List.of("startsWith"))
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudtrail-trail-advancedfieldselector.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudtrail-trail-advancedfieldselector.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_cloudtrail.CfnTrail.AdvancedFieldSelectorProperty")
    @software.amazon.jsii.Jsii.Proxy(AdvancedFieldSelectorProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface AdvancedFieldSelectorProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * A field in a CloudTrail event record on which to filter events to be logged.
         * <p>
         * For event data stores for CloudTrail Insights events, AWS Config configuration items, Audit Manager evidence, or events outside of AWS , the field is used only for selecting events as filtering is not supported.
         * <p>
         * For CloudTrail management events, supported fields include <code>eventCategory</code> (required), <code>eventSource</code> , and <code>readOnly</code> . The following additional fields are available for event data stores: <code>eventName</code> , <code>eventType</code> , <code>sessionCredentialFromConsole</code> , and <code>userIdentity.arn</code> .
         * <p>
         * For CloudTrail data events, supported fields include <code>eventCategory</code> (required), <code>resources.type</code> (required), <code>eventName</code> , <code>readOnly</code> , and <code>resources.ARN</code> . The following additional fields are available for event data stores: <code>eventSource</code> , <code>eventType</code> , <code>sessionCredentialFromConsole</code> , and <code>userIdentity.arn</code> .
         * <p>
         * For CloudTrail network activity events, supported fields include <code>eventCategory</code> (required), <code>eventSource</code> (required), <code>eventName</code> , <code>errorCode</code> , and <code>vpcEndpointId</code> .
         * <p>
         * For event data stores for CloudTrail Insights events, AWS Config configuration items, Audit Manager evidence, or events outside of AWS , the only supported field is <code>eventCategory</code> .
         * <p>
         * <blockquote>
         * <p>
         * Selectors don't support the use of wildcards like <code>*</code> . To match multiple values with a single condition, you may use <code>StartsWith</code> , <code>EndsWith</code> , <code>NotStartsWith</code> , or <code>NotEndsWith</code> to explicitly match the beginning or end of the event field.
         * <p>
         * </blockquote>
         * <p>
         * <ul>
         * <li><em><code>readOnly</code></em> - This is an optional field that is only used for management events and data events. This field can be set to <code>Equals</code> with a value of <code>true</code> or <code>false</code> . If you do not add this field, CloudTrail logs both <code>read</code> and <code>write</code> events. A value of <code>true</code> logs only <code>read</code> events. A value of <code>false</code> logs only <code>write</code> events.</li>
         * <li><em><code>eventSource</code></em> - This field is only used for management events, data events (for event data stores only), and network activity events.</li>
         * </ul>
         * <p>
         * For management events for trails, this is an optional field that can be set to <code>NotEquals</code> <code>kms.amazonaws.com</code> to exclude KMS management events, or <code>NotEquals</code> <code>rdsdata.amazonaws.com</code> to exclude RDS management events.
         * <p>
         * For management and data events for event data stores, you can use it to include or exclude any event source and can use any operator.
         * <p>
         * For network activity events, this is a required field that only uses the <code>Equals</code> operator. Set this field to the event source for which you want to log network activity events. If you want to log network activity events for multiple event sources, you must create a separate field selector for each event source.
         * <p>
         * The following are valid values for network activity events:
         * <p>
         * <ul>
         * <li><code>cloudtrail.amazonaws.com</code></li>
         * <li><code>ec2.amazonaws.com</code></li>
         * <li><code>kms.amazonaws.com</code></li>
         * <li><code>s3.amazonaws.com</code></li>
         * <li><code>secretsmanager.amazonaws.com</code></li>
         * <li><em><code>eventName</code></em> - This is an optional field that is only used for data events, management events (for event data stores only), and network activity events. You can use any operator with <code>eventName</code> . You can use it to ﬁlter in or ﬁlter out specific events. You can have multiple values for this ﬁeld, separated by commas.</li>
         * <li><em><code>eventCategory</code></em> - This field is required and must be set to <code>Equals</code> .</li>
         * <li>For CloudTrail management events, the value must be <code>Management</code> .</li>
         * <li>For CloudTrail data events, the value must be <code>Data</code> .</li>
         * <li>For CloudTrail network activity events, the value must be <code>NetworkActivity</code> .</li>
         * </ul>
         * <p>
         * The following are used only for event data stores:
         * <p>
         * <ul>
         * <li>For CloudTrail Insights events, the value must be <code>Insight</code> .</li>
         * <li>For AWS Config configuration items, the value must be <code>ConfigurationItem</code> .</li>
         * <li>For Audit Manager evidence, the value must be <code>Evidence</code> .</li>
         * <li>For events outside of AWS , the value must be <code>ActivityAuditLog</code> .</li>
         * <li><em><code>eventType</code></em> - This is an optional field available only for event data stores, which is used to filter management and data events on the event type. For information about available event types, see <a href="https://docs.aws.amazon.com/awscloudtrail/latest/userguide/cloudtrail-event-reference-record-contents.html#ct-event-type">CloudTrail record contents</a> in the <em>AWS CloudTrail user guide</em> .</li>
         * <li><em><code>errorCode</code></em> - This ﬁeld is only used to filter CloudTrail network activity events and is optional. This is the error code to filter on. Currently, the only valid <code>errorCode</code> is <code>VpceAccessDenied</code> . <code>errorCode</code> can only use the <code>Equals</code> operator.</li>
         * <li><em><code>sessionCredentialFromConsole</code></em> - This is an optional field available only for event data stores, which is used to filter management and data events based on whether the events originated from an AWS Management Console session. <code>sessionCredentialFromConsole</code> can only use the <code>Equals</code> and <code>NotEquals</code> operators.</li>
         * <li><em><code>resources.type</code></em> - This ﬁeld is required for CloudTrail data events. <code>resources.type</code> can only use the <code>Equals</code> operator.</li>
         * </ul>
         * <p>
         * For a list of available resource types for data events, see <a href="https://docs.aws.amazon.com/awscloudtrail/latest/userguide/logging-data-events-with-cloudtrail.html#logging-data-events">Data events</a> in the <em>AWS CloudTrail User Guide</em> .
         * <p>
         * You can have only one <code>resources.type</code> ﬁeld per selector. To log events on more than one resource type, add another selector.
         * <p>
         * <ul>
         * <li><em><code>resources.ARN</code></em> - The <code>resources.ARN</code> is an optional field for data events. You can use any operator with <code>resources.ARN</code> , but if you use <code>Equals</code> or <code>NotEquals</code> , the value must exactly match the ARN of a valid resource of the type you've speciﬁed in the template as the value of resources.type. To log all data events for all objects in a specific S3 bucket, use the <code>StartsWith</code> operator, and include only the bucket ARN as the matching value.</li>
         * </ul>
         * <p>
         * For information about filtering data events on the <code>resources.ARN</code> field, see <a href="https://docs.aws.amazon.com/awscloudtrail/latest/userguide/filtering-data-events.html#filtering-data-events-resourcearn">Filtering data events by resources.ARN</a> in the <em>AWS CloudTrail User Guide</em> .
         * <p>
         * <blockquote>
         * <p>
         * You can't use the <code>resources.ARN</code> field to filter resource types that do not have ARNs.
         * <p>
         * </blockquote>
         * <p>
         * <ul>
         * <li><em><code>userIdentity.arn</code></em> - This is an optional field available only for event data stores, which is used to filter management and data events on the userIdentity ARN. You can use any operator with <code>userIdentity.arn</code> . For more information on the userIdentity element, see <a href="https://docs.aws.amazon.com/awscloudtrail/latest/userguide/cloudtrail-event-reference-user-identity.html">CloudTrail userIdentity element</a> in the <em>AWS CloudTrail User Guide</em> .</li>
         * <li><em><code>vpcEndpointId</code></em> - This ﬁeld is only used to filter CloudTrail network activity events and is optional. This field identifies the VPC endpoint that the request passed through. You can use any operator with <code>vpcEndpointId</code> .</li>
         * </ul>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudtrail-trail-advancedfieldselector.html#cfn-cloudtrail-trail-advancedfieldselector-field">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudtrail-trail-advancedfieldselector.html#cfn-cloudtrail-trail-advancedfieldselector-field</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getField();

        /**
         * An operator that includes events that match the last few characters of the event record field specified as the value of <code>Field</code> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudtrail-trail-advancedfieldselector.html#cfn-cloudtrail-trail-advancedfieldselector-endswith">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudtrail-trail-advancedfieldselector.html#cfn-cloudtrail-trail-advancedfieldselector-endswith</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getEndsWith() {
            return null;
        }

        /**
         * An operator that includes events that match the exact value of the event record field specified as the value of <code>Field</code> .
         * <p>
         * This is the only valid operator that you can use with the <code>readOnly</code> , <code>eventCategory</code> , and <code>resources.type</code> fields.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudtrail-trail-advancedfieldselector.html#cfn-cloudtrail-trail-advancedfieldselector-equals">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudtrail-trail-advancedfieldselector.html#cfn-cloudtrail-trail-advancedfieldselector-equals</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getEqualTo() {
            return null;
        }

        /**
         * An operator that excludes events that match the last few characters of the event record field specified as the value of <code>Field</code> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudtrail-trail-advancedfieldselector.html#cfn-cloudtrail-trail-advancedfieldselector-notendswith">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudtrail-trail-advancedfieldselector.html#cfn-cloudtrail-trail-advancedfieldselector-notendswith</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getNotEndsWith() {
            return null;
        }

        /**
         * An operator that excludes events that match the exact value of the event record field specified as the value of <code>Field</code> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudtrail-trail-advancedfieldselector.html#cfn-cloudtrail-trail-advancedfieldselector-notequals">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudtrail-trail-advancedfieldselector.html#cfn-cloudtrail-trail-advancedfieldselector-notequals</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getNotEquals() {
            return null;
        }

        /**
         * An operator that excludes events that match the first few characters of the event record field specified as the value of <code>Field</code> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudtrail-trail-advancedfieldselector.html#cfn-cloudtrail-trail-advancedfieldselector-notstartswith">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudtrail-trail-advancedfieldselector.html#cfn-cloudtrail-trail-advancedfieldselector-notstartswith</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getNotStartsWith() {
            return null;
        }

        /**
         * An operator that includes events that match the first few characters of the event record field specified as the value of <code>Field</code> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudtrail-trail-advancedfieldselector.html#cfn-cloudtrail-trail-advancedfieldselector-startswith">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudtrail-trail-advancedfieldselector.html#cfn-cloudtrail-trail-advancedfieldselector-startswith</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getStartsWith() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link AdvancedFieldSelectorProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link AdvancedFieldSelectorProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<AdvancedFieldSelectorProperty> {
            java.lang.String field;
            java.util.List<java.lang.String> endsWith;
            java.util.List<java.lang.String> equalTo;
            java.util.List<java.lang.String> notEndsWith;
            java.util.List<java.lang.String> notEquals;
            java.util.List<java.lang.String> notStartsWith;
            java.util.List<java.lang.String> startsWith;

            /**
             * Sets the value of {@link AdvancedFieldSelectorProperty#getField}
             * @param field A field in a CloudTrail event record on which to filter events to be logged. This parameter is required.
             *              For event data stores for CloudTrail Insights events, AWS Config configuration items, Audit Manager evidence, or events outside of AWS , the field is used only for selecting events as filtering is not supported.
             *              <p>
             *              For CloudTrail management events, supported fields include <code>eventCategory</code> (required), <code>eventSource</code> , and <code>readOnly</code> . The following additional fields are available for event data stores: <code>eventName</code> , <code>eventType</code> , <code>sessionCredentialFromConsole</code> , and <code>userIdentity.arn</code> .
             *              <p>
             *              For CloudTrail data events, supported fields include <code>eventCategory</code> (required), <code>resources.type</code> (required), <code>eventName</code> , <code>readOnly</code> , and <code>resources.ARN</code> . The following additional fields are available for event data stores: <code>eventSource</code> , <code>eventType</code> , <code>sessionCredentialFromConsole</code> , and <code>userIdentity.arn</code> .
             *              <p>
             *              For CloudTrail network activity events, supported fields include <code>eventCategory</code> (required), <code>eventSource</code> (required), <code>eventName</code> , <code>errorCode</code> , and <code>vpcEndpointId</code> .
             *              <p>
             *              For event data stores for CloudTrail Insights events, AWS Config configuration items, Audit Manager evidence, or events outside of AWS , the only supported field is <code>eventCategory</code> .
             *              <p>
             *              <blockquote>
             *              <p>
             *              Selectors don't support the use of wildcards like <code>*</code> . To match multiple values with a single condition, you may use <code>StartsWith</code> , <code>EndsWith</code> , <code>NotStartsWith</code> , or <code>NotEndsWith</code> to explicitly match the beginning or end of the event field.
             *              <p>
             *              </blockquote>
             *              <p>
             *              <ul>
             *              <li><em><code>readOnly</code></em> - This is an optional field that is only used for management events and data events. This field can be set to <code>Equals</code> with a value of <code>true</code> or <code>false</code> . If you do not add this field, CloudTrail logs both <code>read</code> and <code>write</code> events. A value of <code>true</code> logs only <code>read</code> events. A value of <code>false</code> logs only <code>write</code> events.</li>
             *              <li><em><code>eventSource</code></em> - This field is only used for management events, data events (for event data stores only), and network activity events.</li>
             *              </ul>
             *              <p>
             *              For management events for trails, this is an optional field that can be set to <code>NotEquals</code> <code>kms.amazonaws.com</code> to exclude KMS management events, or <code>NotEquals</code> <code>rdsdata.amazonaws.com</code> to exclude RDS management events.
             *              <p>
             *              For management and data events for event data stores, you can use it to include or exclude any event source and can use any operator.
             *              <p>
             *              For network activity events, this is a required field that only uses the <code>Equals</code> operator. Set this field to the event source for which you want to log network activity events. If you want to log network activity events for multiple event sources, you must create a separate field selector for each event source.
             *              <p>
             *              The following are valid values for network activity events:
             *              <p>
             *              <ul>
             *              <li><code>cloudtrail.amazonaws.com</code></li>
             *              <li><code>ec2.amazonaws.com</code></li>
             *              <li><code>kms.amazonaws.com</code></li>
             *              <li><code>s3.amazonaws.com</code></li>
             *              <li><code>secretsmanager.amazonaws.com</code></li>
             *              <li><em><code>eventName</code></em> - This is an optional field that is only used for data events, management events (for event data stores only), and network activity events. You can use any operator with <code>eventName</code> . You can use it to ﬁlter in or ﬁlter out specific events. You can have multiple values for this ﬁeld, separated by commas.</li>
             *              <li><em><code>eventCategory</code></em> - This field is required and must be set to <code>Equals</code> .</li>
             *              <li>For CloudTrail management events, the value must be <code>Management</code> .</li>
             *              <li>For CloudTrail data events, the value must be <code>Data</code> .</li>
             *              <li>For CloudTrail network activity events, the value must be <code>NetworkActivity</code> .</li>
             *              </ul>
             *              <p>
             *              The following are used only for event data stores:
             *              <p>
             *              <ul>
             *              <li>For CloudTrail Insights events, the value must be <code>Insight</code> .</li>
             *              <li>For AWS Config configuration items, the value must be <code>ConfigurationItem</code> .</li>
             *              <li>For Audit Manager evidence, the value must be <code>Evidence</code> .</li>
             *              <li>For events outside of AWS , the value must be <code>ActivityAuditLog</code> .</li>
             *              <li><em><code>eventType</code></em> - This is an optional field available only for event data stores, which is used to filter management and data events on the event type. For information about available event types, see <a href="https://docs.aws.amazon.com/awscloudtrail/latest/userguide/cloudtrail-event-reference-record-contents.html#ct-event-type">CloudTrail record contents</a> in the <em>AWS CloudTrail user guide</em> .</li>
             *              <li><em><code>errorCode</code></em> - This ﬁeld is only used to filter CloudTrail network activity events and is optional. This is the error code to filter on. Currently, the only valid <code>errorCode</code> is <code>VpceAccessDenied</code> . <code>errorCode</code> can only use the <code>Equals</code> operator.</li>
             *              <li><em><code>sessionCredentialFromConsole</code></em> - This is an optional field available only for event data stores, which is used to filter management and data events based on whether the events originated from an AWS Management Console session. <code>sessionCredentialFromConsole</code> can only use the <code>Equals</code> and <code>NotEquals</code> operators.</li>
             *              <li><em><code>resources.type</code></em> - This ﬁeld is required for CloudTrail data events. <code>resources.type</code> can only use the <code>Equals</code> operator.</li>
             *              </ul>
             *              <p>
             *              For a list of available resource types for data events, see <a href="https://docs.aws.amazon.com/awscloudtrail/latest/userguide/logging-data-events-with-cloudtrail.html#logging-data-events">Data events</a> in the <em>AWS CloudTrail User Guide</em> .
             *              <p>
             *              You can have only one <code>resources.type</code> ﬁeld per selector. To log events on more than one resource type, add another selector.
             *              <p>
             *              <ul>
             *              <li><em><code>resources.ARN</code></em> - The <code>resources.ARN</code> is an optional field for data events. You can use any operator with <code>resources.ARN</code> , but if you use <code>Equals</code> or <code>NotEquals</code> , the value must exactly match the ARN of a valid resource of the type you've speciﬁed in the template as the value of resources.type. To log all data events for all objects in a specific S3 bucket, use the <code>StartsWith</code> operator, and include only the bucket ARN as the matching value.</li>
             *              </ul>
             *              <p>
             *              For information about filtering data events on the <code>resources.ARN</code> field, see <a href="https://docs.aws.amazon.com/awscloudtrail/latest/userguide/filtering-data-events.html#filtering-data-events-resourcearn">Filtering data events by resources.ARN</a> in the <em>AWS CloudTrail User Guide</em> .
             *              <p>
             *              <blockquote>
             *              <p>
             *              You can't use the <code>resources.ARN</code> field to filter resource types that do not have ARNs.
             *              <p>
             *              </blockquote>
             *              <p>
             *              <ul>
             *              <li><em><code>userIdentity.arn</code></em> - This is an optional field available only for event data stores, which is used to filter management and data events on the userIdentity ARN. You can use any operator with <code>userIdentity.arn</code> . For more information on the userIdentity element, see <a href="https://docs.aws.amazon.com/awscloudtrail/latest/userguide/cloudtrail-event-reference-user-identity.html">CloudTrail userIdentity element</a> in the <em>AWS CloudTrail User Guide</em> .</li>
             *              <li><em><code>vpcEndpointId</code></em> - This ﬁeld is only used to filter CloudTrail network activity events and is optional. This field identifies the VPC endpoint that the request passed through. You can use any operator with <code>vpcEndpointId</code> .</li>
             *              </ul>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder field(java.lang.String field) {
                this.field = field;
                return this;
            }

            /**
             * Sets the value of {@link AdvancedFieldSelectorProperty#getEndsWith}
             * @param endsWith An operator that includes events that match the last few characters of the event record field specified as the value of <code>Field</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder endsWith(java.util.List<java.lang.String> endsWith) {
                this.endsWith = endsWith;
                return this;
            }

            /**
             * Sets the value of {@link AdvancedFieldSelectorProperty#getEqualTo}
             * @param equalTo An operator that includes events that match the exact value of the event record field specified as the value of <code>Field</code> .
             *                This is the only valid operator that you can use with the <code>readOnly</code> , <code>eventCategory</code> , and <code>resources.type</code> fields.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder equalTo(java.util.List<java.lang.String> equalTo) {
                this.equalTo = equalTo;
                return this;
            }

            /**
             * Sets the value of {@link AdvancedFieldSelectorProperty#getNotEndsWith}
             * @param notEndsWith An operator that excludes events that match the last few characters of the event record field specified as the value of <code>Field</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder notEndsWith(java.util.List<java.lang.String> notEndsWith) {
                this.notEndsWith = notEndsWith;
                return this;
            }

            /**
             * Sets the value of {@link AdvancedFieldSelectorProperty#getNotEquals}
             * @param notEquals An operator that excludes events that match the exact value of the event record field specified as the value of <code>Field</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder notEquals(java.util.List<java.lang.String> notEquals) {
                this.notEquals = notEquals;
                return this;
            }

            /**
             * Sets the value of {@link AdvancedFieldSelectorProperty#getNotStartsWith}
             * @param notStartsWith An operator that excludes events that match the first few characters of the event record field specified as the value of <code>Field</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder notStartsWith(java.util.List<java.lang.String> notStartsWith) {
                this.notStartsWith = notStartsWith;
                return this;
            }

            /**
             * Sets the value of {@link AdvancedFieldSelectorProperty#getStartsWith}
             * @param startsWith An operator that includes events that match the first few characters of the event record field specified as the value of <code>Field</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder startsWith(java.util.List<java.lang.String> startsWith) {
                this.startsWith = startsWith;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link AdvancedFieldSelectorProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public AdvancedFieldSelectorProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link AdvancedFieldSelectorProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements AdvancedFieldSelectorProperty {
            private final java.lang.String field;
            private final java.util.List<java.lang.String> endsWith;
            private final java.util.List<java.lang.String> equalTo;
            private final java.util.List<java.lang.String> notEndsWith;
            private final java.util.List<java.lang.String> notEquals;
            private final java.util.List<java.lang.String> notStartsWith;
            private final java.util.List<java.lang.String> startsWith;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.field = software.amazon.jsii.Kernel.get(this, "field", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.endsWith = software.amazon.jsii.Kernel.get(this, "endsWith", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.equalTo = software.amazon.jsii.Kernel.get(this, "equalTo", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.notEndsWith = software.amazon.jsii.Kernel.get(this, "notEndsWith", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.notEquals = software.amazon.jsii.Kernel.get(this, "notEquals", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.notStartsWith = software.amazon.jsii.Kernel.get(this, "notStartsWith", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.startsWith = software.amazon.jsii.Kernel.get(this, "startsWith", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.field = java.util.Objects.requireNonNull(builder.field, "field is required");
                this.endsWith = builder.endsWith;
                this.equalTo = builder.equalTo;
                this.notEndsWith = builder.notEndsWith;
                this.notEquals = builder.notEquals;
                this.notStartsWith = builder.notStartsWith;
                this.startsWith = builder.startsWith;
            }

            @Override
            public final java.lang.String getField() {
                return this.field;
            }

            @Override
            public final java.util.List<java.lang.String> getEndsWith() {
                return this.endsWith;
            }

            @Override
            public final java.util.List<java.lang.String> getEqualTo() {
                return this.equalTo;
            }

            @Override
            public final java.util.List<java.lang.String> getNotEndsWith() {
                return this.notEndsWith;
            }

            @Override
            public final java.util.List<java.lang.String> getNotEquals() {
                return this.notEquals;
            }

            @Override
            public final java.util.List<java.lang.String> getNotStartsWith() {
                return this.notStartsWith;
            }

            @Override
            public final java.util.List<java.lang.String> getStartsWith() {
                return this.startsWith;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("field", om.valueToTree(this.getField()));
                if (this.getEndsWith() != null) {
                    data.set("endsWith", om.valueToTree(this.getEndsWith()));
                }
                if (this.getEqualTo() != null) {
                    data.set("equalTo", om.valueToTree(this.getEqualTo()));
                }
                if (this.getNotEndsWith() != null) {
                    data.set("notEndsWith", om.valueToTree(this.getNotEndsWith()));
                }
                if (this.getNotEquals() != null) {
                    data.set("notEquals", om.valueToTree(this.getNotEquals()));
                }
                if (this.getNotStartsWith() != null) {
                    data.set("notStartsWith", om.valueToTree(this.getNotStartsWith()));
                }
                if (this.getStartsWith() != null) {
                    data.set("startsWith", om.valueToTree(this.getStartsWith()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_cloudtrail.CfnTrail.AdvancedFieldSelectorProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                AdvancedFieldSelectorProperty.Jsii$Proxy that = (AdvancedFieldSelectorProperty.Jsii$Proxy) o;

                if (!field.equals(that.field)) return false;
                if (this.endsWith != null ? !this.endsWith.equals(that.endsWith) : that.endsWith != null) return false;
                if (this.equalTo != null ? !this.equalTo.equals(that.equalTo) : that.equalTo != null) return false;
                if (this.notEndsWith != null ? !this.notEndsWith.equals(that.notEndsWith) : that.notEndsWith != null) return false;
                if (this.notEquals != null ? !this.notEquals.equals(that.notEquals) : that.notEquals != null) return false;
                if (this.notStartsWith != null ? !this.notStartsWith.equals(that.notStartsWith) : that.notStartsWith != null) return false;
                return this.startsWith != null ? this.startsWith.equals(that.startsWith) : that.startsWith == null;
            }

            @Override
            public final int hashCode() {
                int result = this.field.hashCode();
                result = 31 * result + (this.endsWith != null ? this.endsWith.hashCode() : 0);
                result = 31 * result + (this.equalTo != null ? this.equalTo.hashCode() : 0);
                result = 31 * result + (this.notEndsWith != null ? this.notEndsWith.hashCode() : 0);
                result = 31 * result + (this.notEquals != null ? this.notEquals.hashCode() : 0);
                result = 31 * result + (this.notStartsWith != null ? this.notStartsWith.hashCode() : 0);
                result = 31 * result + (this.startsWith != null ? this.startsWith.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * You can configure the <code>DataResource</code> in an <code>EventSelector</code> to log data events for the following three resource types:.
     * <p>
     * <ul>
     * <li><code>AWS::DynamoDB::Table</code></li>
     * <li><code>AWS::Lambda::Function</code></li>
     * <li><code>AWS::S3::Object</code></li>
     * </ul>
     * <p>
     * To log data events for all other resource types including objects stored in <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/directory-buckets-overview.html">directory buckets</a> , you must use <a href="https://docs.aws.amazon.com/awscloudtrail/latest/APIReference/API_AdvancedEventSelector.html">AdvancedEventSelectors</a> . You must also use <code>AdvancedEventSelectors</code> if you want to filter on the <code>eventName</code> field.
     * <p>
     * Configure the <code>DataResource</code> to specify the resource type and resource ARNs for which you want to log data events.
     * <p>
     * <blockquote>
     * <p>
     * The total number of allowed data resources is 250. This number can be distributed between 1 and 5 event selectors, but the total cannot exceed 250 across all selectors for the trail.
     * <p>
     * </blockquote>
     * <p>
     * The following example demonstrates how logging works when you configure logging of all data events for a general purpose bucket named <code>amzn-s3-demo-bucket1</code> . In this example, the CloudTrail user specified an empty prefix, and the option to log both <code>Read</code> and <code>Write</code> data events.
     * <p>
     * <ul>
     * <li>A user uploads an image file to <code>amzn-s3-demo-bucket1</code> .</li>
     * <li>The <code>PutObject</code> API operation is an Amazon S3 object-level API. It is recorded as a data event in CloudTrail. Because the CloudTrail user specified an S3 bucket with an empty prefix, events that occur on any object in that bucket are logged. The trail processes and logs the event.</li>
     * <li>A user uploads an object to an Amazon S3 bucket named <code>arn:aws:s3:::amzn-s3-demo-bucket1</code> .</li>
     * <li>The <code>PutObject</code> API operation occurred for an object in an S3 bucket that the CloudTrail user didn't specify for the trail. The trail doesn’t log the event.</li>
     * </ul>
     * <p>
     * The following example demonstrates how logging works when you configure logging of AWS Lambda data events for a Lambda function named <em>MyLambdaFunction</em> , but not for all Lambda functions.
     * <p>
     * <ul>
     * <li>A user runs a script that includes a call to the <em>MyLambdaFunction</em> function and the <em>MyOtherLambdaFunction</em> function.</li>
     * <li>The <code>Invoke</code> API operation on <em>MyLambdaFunction</em> is an Lambda API. It is recorded as a data event in CloudTrail. Because the CloudTrail user specified logging data events for <em>MyLambdaFunction</em> , any invocations of that function are logged. The trail processes and logs the event.</li>
     * <li>The <code>Invoke</code> API operation on <em>MyOtherLambdaFunction</em> is an Lambda API. Because the CloudTrail user did not specify logging data events for all Lambda functions, the <code>Invoke</code> operation for <em>MyOtherLambdaFunction</em> does not match the function specified for the trail. The trail doesn’t log the event.</li>
     * </ul>
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.cloudtrail.*;
     * DataResourceProperty dataResourceProperty = DataResourceProperty.builder()
     *         .type("type")
     *         // the properties below are optional
     *         .values(List.of("values"))
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudtrail-trail-dataresource.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudtrail-trail-dataresource.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_cloudtrail.CfnTrail.DataResourceProperty")
    @software.amazon.jsii.Jsii.Proxy(DataResourceProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface DataResourceProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The resource type in which you want to log data events.
         * <p>
         * You can specify the following <em>basic</em> event selector resource types:
         * <p>
         * <ul>
         * <li><code>AWS::DynamoDB::Table</code></li>
         * <li><code>AWS::Lambda::Function</code></li>
         * <li><code>AWS::S3::Object</code></li>
         * </ul>
         * <p>
         * Additional resource types are available through <em>advanced</em> event selectors. For more information, see <a href="https://docs.aws.amazon.com/awscloudtrail/latest/APIReference/API_AdvancedEventSelector.html">AdvancedEventSelector</a> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudtrail-trail-dataresource.html#cfn-cloudtrail-trail-dataresource-type">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudtrail-trail-dataresource.html#cfn-cloudtrail-trail-dataresource-type</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @org.jetbrains.annotations.NotNull java.lang.String getType();

        /**
         * An array of Amazon Resource Name (ARN) strings or partial ARN strings for the specified resource type.
         * <p>
         * <ul>
         * <li>To log data events for all objects in all S3 buckets in your AWS account , specify the prefix as <code>arn:aws:s3</code> .</li>
         * </ul>
         * <p>
         * <blockquote>
         * <p>
         * This also enables logging of data event activity performed by any user or role in your AWS account , even if that activity is performed on a bucket that belongs to another AWS account .
         * <p>
         * </blockquote>
         * <p>
         * <ul>
         * <li>To log data events for all objects in an S3 bucket, specify the bucket and an empty object prefix such as <code>arn:aws:s3:::amzn-s3-demo-bucket1/</code> . The trail logs data events for all objects in this S3 bucket.</li>
         * <li>To log data events for specific objects, specify the S3 bucket and object prefix such as <code>arn:aws:s3:::amzn-s3-demo-bucket1/example-images</code> . The trail logs data events for objects in this S3 bucket that match the prefix.</li>
         * <li>To log data events for all Lambda functions in your AWS account , specify the prefix as <code>arn:aws:lambda</code> .</li>
         * </ul>
         * <p>
         * <blockquote>
         * <p>
         * This also enables logging of <code>Invoke</code> activity performed by any user or role in your AWS account , even if that activity is performed on a function that belongs to another AWS account .
         * <p>
         * </blockquote>
         * <p>
         * <ul>
         * <li>To log data events for a specific Lambda function, specify the function ARN.</li>
         * </ul>
         * <p>
         * <blockquote>
         * <p>
         * Lambda function ARNs are exact. For example, if you specify a function ARN <em>arn:aws:lambda:us-west-2:111111111111:function:helloworld</em> , data events will only be logged for <em>arn:aws:lambda:us-west-2:111111111111:function:helloworld</em> . They will not be logged for <em>arn:aws:lambda:us-west-2:111111111111:function:helloworld2</em> .
         * <p>
         * </blockquote>
         * <p>
         * <ul>
         * <li>To log data events for all DynamoDB tables in your AWS account , specify the prefix as <code>arn:aws:dynamodb</code> .</li>
         * </ul>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudtrail-trail-dataresource.html#cfn-cloudtrail-trail-dataresource-values">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudtrail-trail-dataresource.html#cfn-cloudtrail-trail-dataresource-values</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getValues() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link DataResourceProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link DataResourceProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<DataResourceProperty> {
            java.lang.String type;
            java.util.List<java.lang.String> values;

            /**
             * Sets the value of {@link DataResourceProperty#getType}
             * @param type The resource type in which you want to log data events. This parameter is required.
             *             You can specify the following <em>basic</em> event selector resource types:
             *             <p>
             *             <ul>
             *             <li><code>AWS::DynamoDB::Table</code></li>
             *             <li><code>AWS::Lambda::Function</code></li>
             *             <li><code>AWS::S3::Object</code></li>
             *             </ul>
             *             <p>
             *             Additional resource types are available through <em>advanced</em> event selectors. For more information, see <a href="https://docs.aws.amazon.com/awscloudtrail/latest/APIReference/API_AdvancedEventSelector.html">AdvancedEventSelector</a> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder type(java.lang.String type) {
                this.type = type;
                return this;
            }

            /**
             * Sets the value of {@link DataResourceProperty#getValues}
             * @param values An array of Amazon Resource Name (ARN) strings or partial ARN strings for the specified resource type.
             *               <ul>
             *               <li>To log data events for all objects in all S3 buckets in your AWS account , specify the prefix as <code>arn:aws:s3</code> .</li>
             *               </ul>
             *               <p>
             *               <blockquote>
             *               <p>
             *               This also enables logging of data event activity performed by any user or role in your AWS account , even if that activity is performed on a bucket that belongs to another AWS account .
             *               <p>
             *               </blockquote>
             *               <p>
             *               <ul>
             *               <li>To log data events for all objects in an S3 bucket, specify the bucket and an empty object prefix such as <code>arn:aws:s3:::amzn-s3-demo-bucket1/</code> . The trail logs data events for all objects in this S3 bucket.</li>
             *               <li>To log data events for specific objects, specify the S3 bucket and object prefix such as <code>arn:aws:s3:::amzn-s3-demo-bucket1/example-images</code> . The trail logs data events for objects in this S3 bucket that match the prefix.</li>
             *               <li>To log data events for all Lambda functions in your AWS account , specify the prefix as <code>arn:aws:lambda</code> .</li>
             *               </ul>
             *               <p>
             *               <blockquote>
             *               <p>
             *               This also enables logging of <code>Invoke</code> activity performed by any user or role in your AWS account , even if that activity is performed on a function that belongs to another AWS account .
             *               <p>
             *               </blockquote>
             *               <p>
             *               <ul>
             *               <li>To log data events for a specific Lambda function, specify the function ARN.</li>
             *               </ul>
             *               <p>
             *               <blockquote>
             *               <p>
             *               Lambda function ARNs are exact. For example, if you specify a function ARN <em>arn:aws:lambda:us-west-2:111111111111:function:helloworld</em> , data events will only be logged for <em>arn:aws:lambda:us-west-2:111111111111:function:helloworld</em> . They will not be logged for <em>arn:aws:lambda:us-west-2:111111111111:function:helloworld2</em> .
             *               <p>
             *               </blockquote>
             *               <p>
             *               <ul>
             *               <li>To log data events for all DynamoDB tables in your AWS account , specify the prefix as <code>arn:aws:dynamodb</code> .</li>
             *               </ul>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder values(java.util.List<java.lang.String> values) {
                this.values = values;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link DataResourceProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public DataResourceProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link DataResourceProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements DataResourceProperty {
            private final java.lang.String type;
            private final java.util.List<java.lang.String> values;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.type = software.amazon.jsii.Kernel.get(this, "type", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
                this.values = software.amazon.jsii.Kernel.get(this, "values", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.type = java.util.Objects.requireNonNull(builder.type, "type is required");
                this.values = builder.values;
            }

            @Override
            public final java.lang.String getType() {
                return this.type;
            }

            @Override
            public final java.util.List<java.lang.String> getValues() {
                return this.values;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                data.set("type", om.valueToTree(this.getType()));
                if (this.getValues() != null) {
                    data.set("values", om.valueToTree(this.getValues()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_cloudtrail.CfnTrail.DataResourceProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                DataResourceProperty.Jsii$Proxy that = (DataResourceProperty.Jsii$Proxy) o;

                if (!type.equals(that.type)) return false;
                return this.values != null ? this.values.equals(that.values) : that.values == null;
            }

            @Override
            public final int hashCode() {
                int result = this.type.hashCode();
                result = 31 * result + (this.values != null ? this.values.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * Use event selectors to further specify the management and data event settings for your trail.
     * <p>
     * By default, trails created without specific event selectors will be configured to log all read and write management events, and no data events. When an event occurs in your account, CloudTrail evaluates the event selector for all trails. For each trail, if the event matches any event selector, the trail processes and logs the event. If the event doesn't match any event selector, the trail doesn't log the event.
     * <p>
     * You can configure up to five event selectors for a trail.
     * <p>
     * You cannot apply both event selectors and advanced event selectors to a trail.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.cloudtrail.*;
     * EventSelectorProperty eventSelectorProperty = EventSelectorProperty.builder()
     *         .dataResources(List.of(DataResourceProperty.builder()
     *                 .type("type")
     *                 // the properties below are optional
     *                 .values(List.of("values"))
     *                 .build()))
     *         .excludeManagementEventSources(List.of("excludeManagementEventSources"))
     *         .includeManagementEvents(false)
     *         .readWriteType("readWriteType")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudtrail-trail-eventselector.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudtrail-trail-eventselector.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_cloudtrail.CfnTrail.EventSelectorProperty")
    @software.amazon.jsii.Jsii.Proxy(EventSelectorProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface EventSelectorProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * CloudTrail supports data event logging for Amazon S3 objects in standard S3 buckets, AWS Lambda functions, and Amazon DynamoDB tables with basic event selectors.
         * <p>
         * You can specify up to 250 resources for an individual event selector, but the total number of data resources cannot exceed 250 across all event selectors in a trail. This limit does not apply if you configure resource logging for all data events.
         * <p>
         * For more information, see <a href="https://docs.aws.amazon.com/awscloudtrail/latest/userguide/logging-data-events-with-cloudtrail.html">Data Events</a> and <a href="https://docs.aws.amazon.com/awscloudtrail/latest/userguide/WhatIsCloudTrail-Limits.html">Limits in AWS CloudTrail</a> in the <em>AWS CloudTrail User Guide</em> .
         * <p>
         * <blockquote>
         * <p>
         * To log data events for all other resource types including objects stored in <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/directory-buckets-overview.html">directory buckets</a> , you must use <a href="https://docs.aws.amazon.com/awscloudtrail/latest/APIReference/API_AdvancedEventSelector.html">AdvancedEventSelectors</a> . You must also use <code>AdvancedEventSelectors</code> if you want to filter on the <code>eventName</code> field.
         * <p>
         * </blockquote>
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudtrail-trail-eventselector.html#cfn-cloudtrail-trail-eventselector-dataresources">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudtrail-trail-eventselector.html#cfn-cloudtrail-trail-eventselector-dataresources</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getDataResources() {
            return null;
        }

        /**
         * An optional list of service event sources from which you do not want management events to be logged on your trail.
         * <p>
         * In this release, the list can be empty (disables the filter), or it can filter out AWS Key Management Service or Amazon RDS Data API events by containing <code>kms.amazonaws.com</code> or <code>rdsdata.amazonaws.com</code> . By default, <code>ExcludeManagementEventSources</code> is empty, and AWS KMS and Amazon RDS Data API events are logged to your trail. You can exclude management event sources only in Regions that support the event source.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudtrail-trail-eventselector.html#cfn-cloudtrail-trail-eventselector-excludemanagementeventsources">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudtrail-trail-eventselector.html#cfn-cloudtrail-trail-eventselector-excludemanagementeventsources</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getExcludeManagementEventSources() {
            return null;
        }

        /**
         * Specify if you want your event selector to include management events for your trail.
         * <p>
         * For more information, see <a href="https://docs.aws.amazon.com/awscloudtrail/latest/userguide/logging-management-events-with-cloudtrail.html">Management Events</a> in the <em>AWS CloudTrail User Guide</em> .
         * <p>
         * By default, the value is <code>true</code> .
         * <p>
         * The first copy of management events is free. You are charged for additional copies of management events that you are logging on any subsequent trail in the same Region. For more information about CloudTrail pricing, see <a href="https://docs.aws.amazon.com/cloudtrail/pricing/">AWS CloudTrail Pricing</a> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudtrail-trail-eventselector.html#cfn-cloudtrail-trail-eventselector-includemanagementevents">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudtrail-trail-eventselector.html#cfn-cloudtrail-trail-eventselector-includemanagementevents</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.Object getIncludeManagementEvents() {
            return null;
        }

        /**
         * Specify if you want your trail to log read-only events, write-only events, or all.
         * <p>
         * For example, the EC2 <code>GetConsoleOutput</code> is a read-only API operation and <code>RunInstances</code> is a write-only API operation.
         * <p>
         * By default, the value is <code>All</code> .
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudtrail-trail-eventselector.html#cfn-cloudtrail-trail-eventselector-readwritetype">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudtrail-trail-eventselector.html#cfn-cloudtrail-trail-eventselector-readwritetype</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getReadWriteType() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link EventSelectorProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link EventSelectorProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<EventSelectorProperty> {
            java.lang.Object dataResources;
            java.util.List<java.lang.String> excludeManagementEventSources;
            java.lang.Object includeManagementEvents;
            java.lang.String readWriteType;

            /**
             * Sets the value of {@link EventSelectorProperty#getDataResources}
             * @param dataResources CloudTrail supports data event logging for Amazon S3 objects in standard S3 buckets, AWS Lambda functions, and Amazon DynamoDB tables with basic event selectors.
             *                      You can specify up to 250 resources for an individual event selector, but the total number of data resources cannot exceed 250 across all event selectors in a trail. This limit does not apply if you configure resource logging for all data events.
             *                      <p>
             *                      For more information, see <a href="https://docs.aws.amazon.com/awscloudtrail/latest/userguide/logging-data-events-with-cloudtrail.html">Data Events</a> and <a href="https://docs.aws.amazon.com/awscloudtrail/latest/userguide/WhatIsCloudTrail-Limits.html">Limits in AWS CloudTrail</a> in the <em>AWS CloudTrail User Guide</em> .
             *                      <p>
             *                      <blockquote>
             *                      <p>
             *                      To log data events for all other resource types including objects stored in <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/directory-buckets-overview.html">directory buckets</a> , you must use <a href="https://docs.aws.amazon.com/awscloudtrail/latest/APIReference/API_AdvancedEventSelector.html">AdvancedEventSelectors</a> . You must also use <code>AdvancedEventSelectors</code> if you want to filter on the <code>eventName</code> field.
             *                      <p>
             *                      </blockquote>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder dataResources(software.amazon.awscdk.IResolvable dataResources) {
                this.dataResources = dataResources;
                return this;
            }

            /**
             * Sets the value of {@link EventSelectorProperty#getDataResources}
             * @param dataResources CloudTrail supports data event logging for Amazon S3 objects in standard S3 buckets, AWS Lambda functions, and Amazon DynamoDB tables with basic event selectors.
             *                      You can specify up to 250 resources for an individual event selector, but the total number of data resources cannot exceed 250 across all event selectors in a trail. This limit does not apply if you configure resource logging for all data events.
             *                      <p>
             *                      For more information, see <a href="https://docs.aws.amazon.com/awscloudtrail/latest/userguide/logging-data-events-with-cloudtrail.html">Data Events</a> and <a href="https://docs.aws.amazon.com/awscloudtrail/latest/userguide/WhatIsCloudTrail-Limits.html">Limits in AWS CloudTrail</a> in the <em>AWS CloudTrail User Guide</em> .
             *                      <p>
             *                      <blockquote>
             *                      <p>
             *                      To log data events for all other resource types including objects stored in <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/directory-buckets-overview.html">directory buckets</a> , you must use <a href="https://docs.aws.amazon.com/awscloudtrail/latest/APIReference/API_AdvancedEventSelector.html">AdvancedEventSelectors</a> . You must also use <code>AdvancedEventSelectors</code> if you want to filter on the <code>eventName</code> field.
             *                      <p>
             *                      </blockquote>
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder dataResources(java.util.List<? extends java.lang.Object> dataResources) {
                this.dataResources = dataResources;
                return this;
            }

            /**
             * Sets the value of {@link EventSelectorProperty#getExcludeManagementEventSources}
             * @param excludeManagementEventSources An optional list of service event sources from which you do not want management events to be logged on your trail.
             *                                      In this release, the list can be empty (disables the filter), or it can filter out AWS Key Management Service or Amazon RDS Data API events by containing <code>kms.amazonaws.com</code> or <code>rdsdata.amazonaws.com</code> . By default, <code>ExcludeManagementEventSources</code> is empty, and AWS KMS and Amazon RDS Data API events are logged to your trail. You can exclude management event sources only in Regions that support the event source.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder excludeManagementEventSources(java.util.List<java.lang.String> excludeManagementEventSources) {
                this.excludeManagementEventSources = excludeManagementEventSources;
                return this;
            }

            /**
             * Sets the value of {@link EventSelectorProperty#getIncludeManagementEvents}
             * @param includeManagementEvents Specify if you want your event selector to include management events for your trail.
             *                                For more information, see <a href="https://docs.aws.amazon.com/awscloudtrail/latest/userguide/logging-management-events-with-cloudtrail.html">Management Events</a> in the <em>AWS CloudTrail User Guide</em> .
             *                                <p>
             *                                By default, the value is <code>true</code> .
             *                                <p>
             *                                The first copy of management events is free. You are charged for additional copies of management events that you are logging on any subsequent trail in the same Region. For more information about CloudTrail pricing, see <a href="https://docs.aws.amazon.com/cloudtrail/pricing/">AWS CloudTrail Pricing</a> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder includeManagementEvents(java.lang.Boolean includeManagementEvents) {
                this.includeManagementEvents = includeManagementEvents;
                return this;
            }

            /**
             * Sets the value of {@link EventSelectorProperty#getIncludeManagementEvents}
             * @param includeManagementEvents Specify if you want your event selector to include management events for your trail.
             *                                For more information, see <a href="https://docs.aws.amazon.com/awscloudtrail/latest/userguide/logging-management-events-with-cloudtrail.html">Management Events</a> in the <em>AWS CloudTrail User Guide</em> .
             *                                <p>
             *                                By default, the value is <code>true</code> .
             *                                <p>
             *                                The first copy of management events is free. You are charged for additional copies of management events that you are logging on any subsequent trail in the same Region. For more information about CloudTrail pricing, see <a href="https://docs.aws.amazon.com/cloudtrail/pricing/">AWS CloudTrail Pricing</a> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder includeManagementEvents(software.amazon.awscdk.IResolvable includeManagementEvents) {
                this.includeManagementEvents = includeManagementEvents;
                return this;
            }

            /**
             * Sets the value of {@link EventSelectorProperty#getReadWriteType}
             * @param readWriteType Specify if you want your trail to log read-only events, write-only events, or all.
             *                      For example, the EC2 <code>GetConsoleOutput</code> is a read-only API operation and <code>RunInstances</code> is a write-only API operation.
             *                      <p>
             *                      By default, the value is <code>All</code> .
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder readWriteType(java.lang.String readWriteType) {
                this.readWriteType = readWriteType;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link EventSelectorProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public EventSelectorProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link EventSelectorProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements EventSelectorProperty {
            private final java.lang.Object dataResources;
            private final java.util.List<java.lang.String> excludeManagementEventSources;
            private final java.lang.Object includeManagementEvents;
            private final java.lang.String readWriteType;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.dataResources = software.amazon.jsii.Kernel.get(this, "dataResources", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.excludeManagementEventSources = software.amazon.jsii.Kernel.get(this, "excludeManagementEventSources", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
                this.includeManagementEvents = software.amazon.jsii.Kernel.get(this, "includeManagementEvents", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
                this.readWriteType = software.amazon.jsii.Kernel.get(this, "readWriteType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.dataResources = builder.dataResources;
                this.excludeManagementEventSources = builder.excludeManagementEventSources;
                this.includeManagementEvents = builder.includeManagementEvents;
                this.readWriteType = builder.readWriteType;
            }

            @Override
            public final java.lang.Object getDataResources() {
                return this.dataResources;
            }

            @Override
            public final java.util.List<java.lang.String> getExcludeManagementEventSources() {
                return this.excludeManagementEventSources;
            }

            @Override
            public final java.lang.Object getIncludeManagementEvents() {
                return this.includeManagementEvents;
            }

            @Override
            public final java.lang.String getReadWriteType() {
                return this.readWriteType;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getDataResources() != null) {
                    data.set("dataResources", om.valueToTree(this.getDataResources()));
                }
                if (this.getExcludeManagementEventSources() != null) {
                    data.set("excludeManagementEventSources", om.valueToTree(this.getExcludeManagementEventSources()));
                }
                if (this.getIncludeManagementEvents() != null) {
                    data.set("includeManagementEvents", om.valueToTree(this.getIncludeManagementEvents()));
                }
                if (this.getReadWriteType() != null) {
                    data.set("readWriteType", om.valueToTree(this.getReadWriteType()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_cloudtrail.CfnTrail.EventSelectorProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                EventSelectorProperty.Jsii$Proxy that = (EventSelectorProperty.Jsii$Proxy) o;

                if (this.dataResources != null ? !this.dataResources.equals(that.dataResources) : that.dataResources != null) return false;
                if (this.excludeManagementEventSources != null ? !this.excludeManagementEventSources.equals(that.excludeManagementEventSources) : that.excludeManagementEventSources != null) return false;
                if (this.includeManagementEvents != null ? !this.includeManagementEvents.equals(that.includeManagementEvents) : that.includeManagementEvents != null) return false;
                return this.readWriteType != null ? this.readWriteType.equals(that.readWriteType) : that.readWriteType == null;
            }

            @Override
            public final int hashCode() {
                int result = this.dataResources != null ? this.dataResources.hashCode() : 0;
                result = 31 * result + (this.excludeManagementEventSources != null ? this.excludeManagementEventSources.hashCode() : 0);
                result = 31 * result + (this.includeManagementEvents != null ? this.includeManagementEvents.hashCode() : 0);
                result = 31 * result + (this.readWriteType != null ? this.readWriteType.hashCode() : 0);
                return result;
            }
        }
    }
    /**
     * A JSON string that contains a list of Insights types that are logged on a trail.
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * // The code below shows an example of how to instantiate this type.
     * // The values are placeholders you should change.
     * import software.amazon.awscdk.services.cloudtrail.*;
     * InsightSelectorProperty insightSelectorProperty = InsightSelectorProperty.builder()
     *         .insightType("insightType")
     *         .build();
     * </pre></blockquote>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudtrail-trail-insightselector.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudtrail-trail-insightselector.html</a>
     */
    @software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_cloudtrail.CfnTrail.InsightSelectorProperty")
    @software.amazon.jsii.Jsii.Proxy(InsightSelectorProperty.Jsii$Proxy.class)
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static interface InsightSelectorProperty extends software.amazon.jsii.JsiiSerializable {

        /**
         * The type of Insights events to log on a trail. <code>ApiCallRateInsight</code> and <code>ApiErrorRateInsight</code> are valid Insight types.
         * <p>
         * The <code>ApiCallRateInsight</code> Insights type analyzes write-only management API calls that are aggregated per minute against a baseline API call volume.
         * <p>
         * The <code>ApiErrorRateInsight</code> Insights type analyzes management API calls that result in error codes. The error is shown if the API call is unsuccessful.
         * <p>
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudtrail-trail-insightselector.html#cfn-cloudtrail-trail-insightselector-insighttype">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-cloudtrail-trail-insightselector.html#cfn-cloudtrail-trail-insightselector-insighttype</a>
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        default @org.jetbrains.annotations.Nullable java.lang.String getInsightType() {
            return null;
        }

        /**
         * @return a {@link Builder} of {@link InsightSelectorProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        static Builder builder() {
            return new Builder();
        }
        /**
         * A builder for {@link InsightSelectorProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static final class Builder implements software.amazon.jsii.Builder<InsightSelectorProperty> {
            java.lang.String insightType;

            /**
             * Sets the value of {@link InsightSelectorProperty#getInsightType}
             * @param insightType The type of Insights events to log on a trail. <code>ApiCallRateInsight</code> and <code>ApiErrorRateInsight</code> are valid Insight types.
             *                    The <code>ApiCallRateInsight</code> Insights type analyzes write-only management API calls that are aggregated per minute against a baseline API call volume.
             *                    <p>
             *                    The <code>ApiErrorRateInsight</code> Insights type analyzes management API calls that result in error codes. The error is shown if the API call is unsuccessful.
             * @return {@code this}
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            public Builder insightType(java.lang.String insightType) {
                this.insightType = insightType;
                return this;
            }

            /**
             * Builds the configured instance.
             * @return a new instance of {@link InsightSelectorProperty}
             * @throws NullPointerException if any required attribute was not provided
             */
            @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
            @Override
            public InsightSelectorProperty build() {
                return new Jsii$Proxy(this);
            }
        }

        /**
         * An implementation for {@link InsightSelectorProperty}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @software.amazon.jsii.Internal
        final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements InsightSelectorProperty {
            private final java.lang.String insightType;

            /**
             * Constructor that initializes the object based on values retrieved from the JsiiObject.
             * @param objRef Reference to the JSII managed object.
             */
            protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
                super(objRef);
                this.insightType = software.amazon.jsii.Kernel.get(this, "insightType", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            }

            /**
             * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
             */
            protected Jsii$Proxy(final Builder builder) {
                super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
                this.insightType = builder.insightType;
            }

            @Override
            public final java.lang.String getInsightType() {
                return this.insightType;
            }

            @Override
            @software.amazon.jsii.Internal
            public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
                final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
                final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

                if (this.getInsightType() != null) {
                    data.set("insightType", om.valueToTree(this.getInsightType()));
                }

                final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_cloudtrail.CfnTrail.InsightSelectorProperty"));
                struct.set("data", data);

                final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
                obj.set("$jsii.struct", struct);

                return obj;
            }

            @Override
            public final boolean equals(final Object o) {
                if (this == o) return true;
                if (o == null || getClass() != o.getClass()) return false;

                InsightSelectorProperty.Jsii$Proxy that = (InsightSelectorProperty.Jsii$Proxy) o;

                return this.insightType != null ? this.insightType.equals(that.insightType) : that.insightType == null;
            }

            @Override
            public final int hashCode() {
                int result = this.insightType != null ? this.insightType.hashCode() : 0;
                return result;
            }
        }
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.cloudtrail.CfnTrail}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.cloudtrail.CfnTrail> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope Scope in which this resource is defined. This parameter is required.
         * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.cloudtrail.CfnTrailProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.cloudtrail.CfnTrailProps.Builder();
        }

        /**
         * Whether the CloudTrail trail is currently logging AWS API calls.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudtrail-trail.html#cfn-cloudtrail-trail-islogging">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudtrail-trail.html#cfn-cloudtrail-trail-islogging</a>
         * @param isLogging Whether the CloudTrail trail is currently logging AWS API calls. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder isLogging(final java.lang.Boolean isLogging) {
            this.props.isLogging(isLogging);
            return this;
        }
        /**
         * Whether the CloudTrail trail is currently logging AWS API calls.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudtrail-trail.html#cfn-cloudtrail-trail-islogging">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudtrail-trail.html#cfn-cloudtrail-trail-islogging</a>
         * @param isLogging Whether the CloudTrail trail is currently logging AWS API calls. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder isLogging(final software.amazon.awscdk.IResolvable isLogging) {
            this.props.isLogging(isLogging);
            return this;
        }

        /**
         * Specifies the name of the Amazon S3 bucket designated for publishing log files.
         * <p>
         * See <a href="https://docs.aws.amazon.com/AmazonS3/latest/userguide/bucketnamingrules.html">Amazon S3 Bucket naming rules</a> .
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudtrail-trail.html#cfn-cloudtrail-trail-s3bucketname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudtrail-trail.html#cfn-cloudtrail-trail-s3bucketname</a>
         * @param s3BucketName Specifies the name of the Amazon S3 bucket designated for publishing log files. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder s3BucketName(final java.lang.String s3BucketName) {
            this.props.s3BucketName(s3BucketName);
            return this;
        }

        /**
         * Specifies the settings for advanced event selectors.
         * <p>
         * You can use advanced event selectors to log management events, data events for all resource types, and network activity events.
         * <p>
         * You can add advanced event selectors, and conditions for your advanced event selectors, up to a maximum of 500 values for all conditions and selectors on a trail. You can use either <code>AdvancedEventSelectors</code> or <code>EventSelectors</code> , but not both. If you apply <code>AdvancedEventSelectors</code> to a trail, any existing <code>EventSelectors</code> are overwritten. For more information about advanced event selectors, see <a href="https://docs.aws.amazon.com/awscloudtrail/latest/userguide/logging-data-events-with-cloudtrail.html">Logging data events</a> and <a href="https://docs.aws.amazon.com/awscloudtrail/latest/userguide/logging-network-events-with-cloudtrail.html">Logging network activity events</a> in the <em>AWS CloudTrail User Guide</em> .
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudtrail-trail.html#cfn-cloudtrail-trail-advancedeventselectors">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudtrail-trail.html#cfn-cloudtrail-trail-advancedeventselectors</a>
         * @param advancedEventSelectors Specifies the settings for advanced event selectors. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder advancedEventSelectors(final software.amazon.awscdk.IResolvable advancedEventSelectors) {
            this.props.advancedEventSelectors(advancedEventSelectors);
            return this;
        }
        /**
         * Specifies the settings for advanced event selectors.
         * <p>
         * You can use advanced event selectors to log management events, data events for all resource types, and network activity events.
         * <p>
         * You can add advanced event selectors, and conditions for your advanced event selectors, up to a maximum of 500 values for all conditions and selectors on a trail. You can use either <code>AdvancedEventSelectors</code> or <code>EventSelectors</code> , but not both. If you apply <code>AdvancedEventSelectors</code> to a trail, any existing <code>EventSelectors</code> are overwritten. For more information about advanced event selectors, see <a href="https://docs.aws.amazon.com/awscloudtrail/latest/userguide/logging-data-events-with-cloudtrail.html">Logging data events</a> and <a href="https://docs.aws.amazon.com/awscloudtrail/latest/userguide/logging-network-events-with-cloudtrail.html">Logging network activity events</a> in the <em>AWS CloudTrail User Guide</em> .
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudtrail-trail.html#cfn-cloudtrail-trail-advancedeventselectors">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudtrail-trail.html#cfn-cloudtrail-trail-advancedeventselectors</a>
         * @param advancedEventSelectors Specifies the settings for advanced event selectors. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder advancedEventSelectors(final java.util.List<? extends java.lang.Object> advancedEventSelectors) {
            this.props.advancedEventSelectors(advancedEventSelectors);
            return this;
        }

        /**
         * Specifies a log group name using an Amazon Resource Name (ARN), a unique identifier that represents the log group to which CloudTrail logs are delivered.
         * <p>
         * You must use a log group that exists in your account.
         * <p>
         * To enable CloudWatch Logs delivery, you must provide values for <code>CloudWatchLogsLogGroupArn</code> and <code>CloudWatchLogsRoleArn</code> .
         * <p>
         * <blockquote>
         * <p>
         * If you previously enabled CloudWatch Logs delivery and want to disable CloudWatch Logs delivery, you must set the values of the <code>CloudWatchLogsRoleArn</code> and <code>CloudWatchLogsLogGroupArn</code> fields to <code>""</code> .
         * <p>
         * </blockquote>
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudtrail-trail.html#cfn-cloudtrail-trail-cloudwatchlogsloggrouparn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudtrail-trail.html#cfn-cloudtrail-trail-cloudwatchlogsloggrouparn</a>
         * @param cloudWatchLogsLogGroupArn Specifies a log group name using an Amazon Resource Name (ARN), a unique identifier that represents the log group to which CloudTrail logs are delivered. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder cloudWatchLogsLogGroupArn(final java.lang.String cloudWatchLogsLogGroupArn) {
            this.props.cloudWatchLogsLogGroupArn(cloudWatchLogsLogGroupArn);
            return this;
        }

        /**
         * Specifies the role for the CloudWatch Logs endpoint to assume to write to a user's log group.
         * <p>
         * You must use a role that exists in your account.
         * <p>
         * To enable CloudWatch Logs delivery, you must provide values for <code>CloudWatchLogsLogGroupArn</code> and <code>CloudWatchLogsRoleArn</code> .
         * <p>
         * <blockquote>
         * <p>
         * If you previously enabled CloudWatch Logs delivery and want to disable CloudWatch Logs delivery, you must set the values of the <code>CloudWatchLogsRoleArn</code> and <code>CloudWatchLogsLogGroupArn</code> fields to <code>""</code> .
         * <p>
         * </blockquote>
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudtrail-trail.html#cfn-cloudtrail-trail-cloudwatchlogsrolearn">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudtrail-trail.html#cfn-cloudtrail-trail-cloudwatchlogsrolearn</a>
         * @param cloudWatchLogsRoleArn Specifies the role for the CloudWatch Logs endpoint to assume to write to a user's log group. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder cloudWatchLogsRoleArn(final java.lang.String cloudWatchLogsRoleArn) {
            this.props.cloudWatchLogsRoleArn(cloudWatchLogsRoleArn);
            return this;
        }

        /**
         * Specifies whether log file validation is enabled. The default is false.
         * <p>
         * <blockquote>
         * <p>
         * When you disable log file integrity validation, the chain of digest files is broken after one hour. CloudTrail does not create digest files for log files that were delivered during a period in which log file integrity validation was disabled. For example, if you enable log file integrity validation at noon on January 1, disable it at noon on January 2, and re-enable it at noon on January 10, digest files will not be created for the log files delivered from noon on January 2 to noon on January 10. The same applies whenever you stop CloudTrail logging or delete a trail.
         * <p>
         * </blockquote>
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudtrail-trail.html#cfn-cloudtrail-trail-enablelogfilevalidation">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudtrail-trail.html#cfn-cloudtrail-trail-enablelogfilevalidation</a>
         * @param enableLogFileValidation Specifies whether log file validation is enabled. The default is false. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder enableLogFileValidation(final java.lang.Boolean enableLogFileValidation) {
            this.props.enableLogFileValidation(enableLogFileValidation);
            return this;
        }
        /**
         * Specifies whether log file validation is enabled. The default is false.
         * <p>
         * <blockquote>
         * <p>
         * When you disable log file integrity validation, the chain of digest files is broken after one hour. CloudTrail does not create digest files for log files that were delivered during a period in which log file integrity validation was disabled. For example, if you enable log file integrity validation at noon on January 1, disable it at noon on January 2, and re-enable it at noon on January 10, digest files will not be created for the log files delivered from noon on January 2 to noon on January 10. The same applies whenever you stop CloudTrail logging or delete a trail.
         * <p>
         * </blockquote>
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudtrail-trail.html#cfn-cloudtrail-trail-enablelogfilevalidation">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudtrail-trail.html#cfn-cloudtrail-trail-enablelogfilevalidation</a>
         * @param enableLogFileValidation Specifies whether log file validation is enabled. The default is false. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder enableLogFileValidation(final software.amazon.awscdk.IResolvable enableLogFileValidation) {
            this.props.enableLogFileValidation(enableLogFileValidation);
            return this;
        }

        /**
         * Use event selectors to further specify the management and data event settings for your trail.
         * <p>
         * By default, trails created without specific event selectors will be configured to log all read and write management events, and no data events. When an event occurs in your account, CloudTrail evaluates the event selector for all trails. For each trail, if the event matches any event selector, the trail processes and logs the event. If the event doesn't match any event selector, the trail doesn't log the event.
         * <p>
         * You can configure up to five event selectors for a trail.
         * <p>
         * You cannot apply both event selectors and advanced event selectors to a trail.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudtrail-trail.html#cfn-cloudtrail-trail-eventselectors">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudtrail-trail.html#cfn-cloudtrail-trail-eventselectors</a>
         * @param eventSelectors Use event selectors to further specify the management and data event settings for your trail. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder eventSelectors(final software.amazon.awscdk.IResolvable eventSelectors) {
            this.props.eventSelectors(eventSelectors);
            return this;
        }
        /**
         * Use event selectors to further specify the management and data event settings for your trail.
         * <p>
         * By default, trails created without specific event selectors will be configured to log all read and write management events, and no data events. When an event occurs in your account, CloudTrail evaluates the event selector for all trails. For each trail, if the event matches any event selector, the trail processes and logs the event. If the event doesn't match any event selector, the trail doesn't log the event.
         * <p>
         * You can configure up to five event selectors for a trail.
         * <p>
         * You cannot apply both event selectors and advanced event selectors to a trail.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudtrail-trail.html#cfn-cloudtrail-trail-eventselectors">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudtrail-trail.html#cfn-cloudtrail-trail-eventselectors</a>
         * @param eventSelectors Use event selectors to further specify the management and data event settings for your trail. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder eventSelectors(final java.util.List<? extends java.lang.Object> eventSelectors) {
            this.props.eventSelectors(eventSelectors);
            return this;
        }

        /**
         * Specifies whether the trail is publishing events from global services such as IAM to the log files.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudtrail-trail.html#cfn-cloudtrail-trail-includeglobalserviceevents">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudtrail-trail.html#cfn-cloudtrail-trail-includeglobalserviceevents</a>
         * @param includeGlobalServiceEvents Specifies whether the trail is publishing events from global services such as IAM to the log files. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder includeGlobalServiceEvents(final java.lang.Boolean includeGlobalServiceEvents) {
            this.props.includeGlobalServiceEvents(includeGlobalServiceEvents);
            return this;
        }
        /**
         * Specifies whether the trail is publishing events from global services such as IAM to the log files.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudtrail-trail.html#cfn-cloudtrail-trail-includeglobalserviceevents">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudtrail-trail.html#cfn-cloudtrail-trail-includeglobalserviceevents</a>
         * @param includeGlobalServiceEvents Specifies whether the trail is publishing events from global services such as IAM to the log files. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder includeGlobalServiceEvents(final software.amazon.awscdk.IResolvable includeGlobalServiceEvents) {
            this.props.includeGlobalServiceEvents(includeGlobalServiceEvents);
            return this;
        }

        /**
         * A JSON string that contains the Insights types you want to log on a trail.
         * <p>
         * <code>ApiCallRateInsight</code> and <code>ApiErrorRateInsight</code> are valid Insight types.
         * <p>
         * The <code>ApiCallRateInsight</code> Insights type analyzes write-only management API calls that are aggregated per minute against a baseline API call volume.
         * <p>
         * The <code>ApiErrorRateInsight</code> Insights type analyzes management API calls that result in error codes. The error is shown if the API call is unsuccessful.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudtrail-trail.html#cfn-cloudtrail-trail-insightselectors">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudtrail-trail.html#cfn-cloudtrail-trail-insightselectors</a>
         * @param insightSelectors A JSON string that contains the Insights types you want to log on a trail. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder insightSelectors(final software.amazon.awscdk.IResolvable insightSelectors) {
            this.props.insightSelectors(insightSelectors);
            return this;
        }
        /**
         * A JSON string that contains the Insights types you want to log on a trail.
         * <p>
         * <code>ApiCallRateInsight</code> and <code>ApiErrorRateInsight</code> are valid Insight types.
         * <p>
         * The <code>ApiCallRateInsight</code> Insights type analyzes write-only management API calls that are aggregated per minute against a baseline API call volume.
         * <p>
         * The <code>ApiErrorRateInsight</code> Insights type analyzes management API calls that result in error codes. The error is shown if the API call is unsuccessful.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudtrail-trail.html#cfn-cloudtrail-trail-insightselectors">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudtrail-trail.html#cfn-cloudtrail-trail-insightselectors</a>
         * @param insightSelectors A JSON string that contains the Insights types you want to log on a trail. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder insightSelectors(final java.util.List<? extends java.lang.Object> insightSelectors) {
            this.props.insightSelectors(insightSelectors);
            return this;
        }

        /**
         * Specifies whether the trail applies only to the current Region or to all Regions.
         * <p>
         * The default is false. If the trail exists only in the current Region and this value is set to true, shadow trails (replications of the trail) will be created in the other Regions. If the trail exists in all Regions and this value is set to false, the trail will remain in the Region where it was created, and its shadow trails in other Regions will be deleted. As a best practice, consider using trails that log events in all Regions.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudtrail-trail.html#cfn-cloudtrail-trail-ismultiregiontrail">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudtrail-trail.html#cfn-cloudtrail-trail-ismultiregiontrail</a>
         * @param isMultiRegionTrail Specifies whether the trail applies only to the current Region or to all Regions. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder isMultiRegionTrail(final java.lang.Boolean isMultiRegionTrail) {
            this.props.isMultiRegionTrail(isMultiRegionTrail);
            return this;
        }
        /**
         * Specifies whether the trail applies only to the current Region or to all Regions.
         * <p>
         * The default is false. If the trail exists only in the current Region and this value is set to true, shadow trails (replications of the trail) will be created in the other Regions. If the trail exists in all Regions and this value is set to false, the trail will remain in the Region where it was created, and its shadow trails in other Regions will be deleted. As a best practice, consider using trails that log events in all Regions.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudtrail-trail.html#cfn-cloudtrail-trail-ismultiregiontrail">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudtrail-trail.html#cfn-cloudtrail-trail-ismultiregiontrail</a>
         * @param isMultiRegionTrail Specifies whether the trail applies only to the current Region or to all Regions. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder isMultiRegionTrail(final software.amazon.awscdk.IResolvable isMultiRegionTrail) {
            this.props.isMultiRegionTrail(isMultiRegionTrail);
            return this;
        }

        /**
         * Specifies whether the trail is applied to all accounts in an organization in AWS Organizations , or only for the current AWS account .
         * <p>
         * The default is false, and cannot be true unless the call is made on behalf of an AWS account that is the management account for an organization in AWS Organizations . If the trail is not an organization trail and this is set to <code>true</code> , the trail will be created in all AWS accounts that belong to the organization. If the trail is an organization trail and this is set to <code>false</code> , the trail will remain in the current AWS account but be deleted from all member accounts in the organization.
         * <p>
         * <blockquote>
         * <p>
         * Only the management account for the organization can convert an organization trail to a non-organization trail, or convert a non-organization trail to an organization trail.
         * <p>
         * </blockquote>
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudtrail-trail.html#cfn-cloudtrail-trail-isorganizationtrail">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudtrail-trail.html#cfn-cloudtrail-trail-isorganizationtrail</a>
         * @param isOrganizationTrail Specifies whether the trail is applied to all accounts in an organization in AWS Organizations , or only for the current AWS account . This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder isOrganizationTrail(final java.lang.Boolean isOrganizationTrail) {
            this.props.isOrganizationTrail(isOrganizationTrail);
            return this;
        }
        /**
         * Specifies whether the trail is applied to all accounts in an organization in AWS Organizations , or only for the current AWS account .
         * <p>
         * The default is false, and cannot be true unless the call is made on behalf of an AWS account that is the management account for an organization in AWS Organizations . If the trail is not an organization trail and this is set to <code>true</code> , the trail will be created in all AWS accounts that belong to the organization. If the trail is an organization trail and this is set to <code>false</code> , the trail will remain in the current AWS account but be deleted from all member accounts in the organization.
         * <p>
         * <blockquote>
         * <p>
         * Only the management account for the organization can convert an organization trail to a non-organization trail, or convert a non-organization trail to an organization trail.
         * <p>
         * </blockquote>
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudtrail-trail.html#cfn-cloudtrail-trail-isorganizationtrail">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudtrail-trail.html#cfn-cloudtrail-trail-isorganizationtrail</a>
         * @param isOrganizationTrail Specifies whether the trail is applied to all accounts in an organization in AWS Organizations , or only for the current AWS account . This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder isOrganizationTrail(final software.amazon.awscdk.IResolvable isOrganizationTrail) {
            this.props.isOrganizationTrail(isOrganizationTrail);
            return this;
        }

        /**
         * Specifies the AWS KMS key ID to use to encrypt the logs delivered by CloudTrail.
         * <p>
         * The value can be an alias name prefixed by "alias/", a fully specified ARN to an alias, a fully specified ARN to a key, or a globally unique identifier.
         * <p>
         * CloudTrail also supports AWS KMS multi-Region keys. For more information about multi-Region keys, see <a href="https://docs.aws.amazon.com/kms/latest/developerguide/multi-region-keys-overview.html">Using multi-Region keys</a> in the <em>AWS Key Management Service Developer Guide</em> .
         * <p>
         * Examples:
         * <p>
         * <ul>
         * <li>alias/MyAliasName</li>
         * <li>arn:aws:kms:us-east-2:123456789012:alias/MyAliasName</li>
         * <li>arn:aws:kms:us-east-2:123456789012:key/12345678-1234-1234-1234-123456789012</li>
         * <li>12345678-1234-1234-1234-123456789012</li>
         * </ul>
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudtrail-trail.html#cfn-cloudtrail-trail-kmskeyid">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudtrail-trail.html#cfn-cloudtrail-trail-kmskeyid</a>
         * @param kmsKeyId Specifies the AWS KMS key ID to use to encrypt the logs delivered by CloudTrail. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder kmsKeyId(final java.lang.String kmsKeyId) {
            this.props.kmsKeyId(kmsKeyId);
            return this;
        }

        /**
         * Specifies the Amazon S3 key prefix that comes after the name of the bucket you have designated for log file delivery.
         * <p>
         * For more information, see <a href="https://docs.aws.amazon.com/awscloudtrail/latest/userguide/get-and-view-cloudtrail-log-files.html#cloudtrail-find-log-files">Finding Your CloudTrail Log Files</a> . The maximum length is 200 characters.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudtrail-trail.html#cfn-cloudtrail-trail-s3keyprefix">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudtrail-trail.html#cfn-cloudtrail-trail-s3keyprefix</a>
         * @param s3KeyPrefix Specifies the Amazon S3 key prefix that comes after the name of the bucket you have designated for log file delivery. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder s3KeyPrefix(final java.lang.String s3KeyPrefix) {
            this.props.s3KeyPrefix(s3KeyPrefix);
            return this;
        }

        /**
         * Specifies the name of the Amazon SNS topic defined for notification of log file delivery.
         * <p>
         * The maximum length is 256 characters.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudtrail-trail.html#cfn-cloudtrail-trail-snstopicname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudtrail-trail.html#cfn-cloudtrail-trail-snstopicname</a>
         * @param snsTopicName Specifies the name of the Amazon SNS topic defined for notification of log file delivery. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder snsTopicName(final java.lang.String snsTopicName) {
            this.props.snsTopicName(snsTopicName);
            return this;
        }

        /**
         * A custom set of tags (key-value pairs) for this trail.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudtrail-trail.html#cfn-cloudtrail-trail-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudtrail-trail.html#cfn-cloudtrail-trail-tags</a>
         * @param tags A custom set of tags (key-value pairs) for this trail. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tags(final java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.props.tags(tags);
            return this;
        }

        /**
         * Specifies the name of the trail. The name must meet the following requirements:.
         * <p>
         * <ul>
         * <li>Contain only ASCII letters (a-z, A-Z), numbers (0-9), periods (.), underscores (_), or dashes (-)</li>
         * <li>Start with a letter or number, and end with a letter or number</li>
         * <li>Be between 3 and 128 characters</li>
         * <li>Have no adjacent periods, underscores or dashes. Names like <code>my-_namespace</code> and <code>my--namespace</code> are not valid.</li>
         * <li>Not be in IP address format (for example, 192.168.5.4)</li>
         * </ul>
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudtrail-trail.html#cfn-cloudtrail-trail-trailname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudtrail-trail.html#cfn-cloudtrail-trail-trailname</a>
         * @param trailName Specifies the name of the trail. The name must meet the following requirements:. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder trailName(final java.lang.String trailName) {
            this.props.trailName(trailName);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.cloudtrail.CfnTrail}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.cloudtrail.CfnTrail build() {
            return new software.amazon.awscdk.services.cloudtrail.CfnTrail(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
