package software.amazon.awscdk.services.cloudwatch;

/**
 * The <code>AWS::CloudWatch::CompositeAlarm</code> type creates or updates a composite alarm.
 * <p>
 * When you create a composite alarm, you specify a rule expression for the alarm that takes into account the alarm states of other alarms that you have created. The composite alarm goes into ALARM state only if all conditions of the rule are met.
 * <p>
 * The alarms specified in a composite alarm's rule expression can include metric alarms and other composite alarms.
 * <p>
 * Using composite alarms can reduce alarm noise. You can create multiple metric alarms, and also create a composite alarm and set up alerts only for the composite alarm. For example, you could create a composite alarm that goes into ALARM state only when more than one of the underlying metric alarms are in ALARM state.
 * <p>
 * When this operation creates an alarm, the alarm state is immediately set to INSUFFICIENT_DATA. The alarm is then evaluated and its state is set appropriately. Any actions associated with the new state are then executed. For a composite alarm, this initial time after creation is the only time that the alarm can be in INSUFFICIENT_DATA state.
 * <p>
 * When you update an existing alarm, its state is left unchanged, but the update completely overwrites the previous configuration of the alarm.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.cloudwatch.*;
 * CfnCompositeAlarm cfnCompositeAlarm = CfnCompositeAlarm.Builder.create(this, "MyCfnCompositeAlarm")
 *         .alarmRule("alarmRule")
 *         // the properties below are optional
 *         .actionsEnabled(false)
 *         .actionsSuppressor("actionsSuppressor")
 *         .actionsSuppressorExtensionPeriod(123)
 *         .actionsSuppressorWaitPeriod(123)
 *         .alarmActions(List.of("alarmActions"))
 *         .alarmDescription("alarmDescription")
 *         .alarmName("alarmName")
 *         .insufficientDataActions(List.of("insufficientDataActions"))
 *         .okActions(List.of("okActions"))
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudwatch-compositealarm.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudwatch-compositealarm.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.106.0 (build e852934)", date = "2025-02-21T03:20:29.831Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_cloudwatch.CfnCompositeAlarm")
public class CfnCompositeAlarm extends software.amazon.awscdk.CfnResource implements software.amazon.awscdk.IInspectable, software.amazon.awscdk.ITaggableV2 {

    protected CfnCompositeAlarm(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CfnCompositeAlarm(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    static {
        CFN_RESOURCE_TYPE_NAME = software.amazon.jsii.JsiiObject.jsiiStaticGet(software.amazon.awscdk.services.cloudwatch.CfnCompositeAlarm.class, "CFN_RESOURCE_TYPE_NAME", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * @param scope Scope in which this resource is defined. This parameter is required.
     * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
     * @param props Resource properties. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CfnCompositeAlarm(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.cloudwatch.CfnCompositeAlarmProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * Examines the CloudFormation resource and discloses attributes.
     * <p>
     * @param inspector tree inspector to collect and process attributes. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public void inspect(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.TreeInspector inspector) {
        software.amazon.jsii.Kernel.call(this, "inspect", software.amazon.jsii.NativeType.VOID, new Object[] { java.util.Objects.requireNonNull(inspector, "inspector is required") });
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> renderProperties(final @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> props) {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.call(this, "renderProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class)), new Object[] { java.util.Objects.requireNonNull(props, "props is required") }));
    }

    /**
     * The CloudFormation resource type name for this resource class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public final static java.lang.String CFN_RESOURCE_TYPE_NAME;

    /**
     * The ARN of the composite alarm, such as <code>arn:aws:cloudwatch:us-west-2:123456789012:alarm/CompositeAlarmName</code> .
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAttrArn() {
        return software.amazon.jsii.Kernel.get(this, "attrArn", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Tag Manager which manages the tags for this resource.
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.TagManager getCdkTagManager() {
        return software.amazon.jsii.Kernel.get(this, "cdkTagManager", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.TagManager.class));
    }

    /**
     */
    @Override
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    protected @org.jetbrains.annotations.NotNull java.util.Map<java.lang.String, java.lang.Object> getCfnProperties() {
        return java.util.Collections.unmodifiableMap(software.amazon.jsii.Kernel.get(this, "cfnProperties", software.amazon.jsii.NativeType.mapOf(software.amazon.jsii.NativeType.forClass(java.lang.Object.class))));
    }

    /**
     * An expression that specifies which other alarms are to be evaluated to determine this composite alarm's state.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String getAlarmRule() {
        return software.amazon.jsii.Kernel.get(this, "alarmRule", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * An expression that specifies which other alarms are to be evaluated to determine this composite alarm's state.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setAlarmRule(final @org.jetbrains.annotations.NotNull java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "alarmRule", java.util.Objects.requireNonNull(value, "alarmRule is required"));
    }

    /**
     * Indicates whether actions should be executed during any changes to the alarm state of the composite alarm.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Object getActionsEnabled() {
        return software.amazon.jsii.Kernel.get(this, "actionsEnabled", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
    }

    /**
     * Indicates whether actions should be executed during any changes to the alarm state of the composite alarm.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setActionsEnabled(final @org.jetbrains.annotations.Nullable java.lang.Boolean value) {
        software.amazon.jsii.Kernel.set(this, "actionsEnabled", value);
    }

    /**
     * Indicates whether actions should be executed during any changes to the alarm state of the composite alarm.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setActionsEnabled(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.IResolvable value) {
        software.amazon.jsii.Kernel.set(this, "actionsEnabled", value);
    }

    /**
     * Actions will be suppressed if the suppressor alarm is in the <code>ALARM</code> state.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getActionsSuppressor() {
        return software.amazon.jsii.Kernel.get(this, "actionsSuppressor", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * Actions will be suppressed if the suppressor alarm is in the <code>ALARM</code> state.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setActionsSuppressor(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "actionsSuppressor", value);
    }

    /**
     * The maximum time in seconds that the composite alarm waits after suppressor alarm goes out of the <code>ALARM</code> state.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Number getActionsSuppressorExtensionPeriod() {
        return software.amazon.jsii.Kernel.get(this, "actionsSuppressorExtensionPeriod", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
    }

    /**
     * The maximum time in seconds that the composite alarm waits after suppressor alarm goes out of the <code>ALARM</code> state.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setActionsSuppressorExtensionPeriod(final @org.jetbrains.annotations.Nullable java.lang.Number value) {
        software.amazon.jsii.Kernel.set(this, "actionsSuppressorExtensionPeriod", value);
    }

    /**
     * The maximum time in seconds that the composite alarm waits for the suppressor alarm to go into the <code>ALARM</code> state.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.Number getActionsSuppressorWaitPeriod() {
        return software.amazon.jsii.Kernel.get(this, "actionsSuppressorWaitPeriod", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
    }

    /**
     * The maximum time in seconds that the composite alarm waits for the suppressor alarm to go into the <code>ALARM</code> state.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setActionsSuppressorWaitPeriod(final @org.jetbrains.annotations.Nullable java.lang.Number value) {
        software.amazon.jsii.Kernel.set(this, "actionsSuppressorWaitPeriod", value);
    }

    /**
     * The actions to execute when this alarm transitions to the ALARM state from any other state.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getAlarmActions() {
        return java.util.Optional.ofNullable((java.util.List<java.lang.String>)(software.amazon.jsii.Kernel.get(this, "alarmActions", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class))))).map(java.util.Collections::unmodifiableList).orElse(null);
    }

    /**
     * The actions to execute when this alarm transitions to the ALARM state from any other state.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setAlarmActions(final @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> value) {
        software.amazon.jsii.Kernel.set(this, "alarmActions", value);
    }

    /**
     * The description for the composite alarm.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getAlarmDescription() {
        return software.amazon.jsii.Kernel.get(this, "alarmDescription", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The description for the composite alarm.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setAlarmDescription(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "alarmDescription", value);
    }

    /**
     * The name for the composite alarm.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.lang.String getAlarmName() {
        return software.amazon.jsii.Kernel.get(this, "alarmName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
    }

    /**
     * The name for the composite alarm.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setAlarmName(final @org.jetbrains.annotations.Nullable java.lang.String value) {
        software.amazon.jsii.Kernel.set(this, "alarmName", value);
    }

    /**
     * The actions to execute when this alarm transitions to the INSUFFICIENT_DATA state from any other state.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getInsufficientDataActions() {
        return java.util.Optional.ofNullable((java.util.List<java.lang.String>)(software.amazon.jsii.Kernel.get(this, "insufficientDataActions", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class))))).map(java.util.Collections::unmodifiableList).orElse(null);
    }

    /**
     * The actions to execute when this alarm transitions to the INSUFFICIENT_DATA state from any other state.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setInsufficientDataActions(final @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> value) {
        software.amazon.jsii.Kernel.set(this, "insufficientDataActions", value);
    }

    /**
     * The actions to execute when this alarm transitions to the OK state from any other state.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getOkActions() {
        return java.util.Optional.ofNullable((java.util.List<java.lang.String>)(software.amazon.jsii.Kernel.get(this, "okActions", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class))))).map(java.util.Collections::unmodifiableList).orElse(null);
    }

    /**
     * The actions to execute when this alarm transitions to the OK state from any other state.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setOkActions(final @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> value) {
        software.amazon.jsii.Kernel.set(this, "okActions", value);
    }

    /**
     * A list of key-value pairs to associate with the alarm.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> getTags() {
        return java.util.Optional.ofNullable((java.util.List<software.amazon.awscdk.CfnTag>)(software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.CfnTag.class))))).map(java.util.Collections::unmodifiableList).orElse(null);
    }

    /**
     * A list of key-value pairs to associate with the alarm.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public void setTags(final @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> value) {
        software.amazon.jsii.Kernel.set(this, "tags", value);
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.cloudwatch.CfnCompositeAlarm}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.cloudwatch.CfnCompositeAlarm> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope Scope in which this resource is defined. This parameter is required.
         * @param id Construct identifier for this resource (unique in its scope). This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private final software.amazon.awscdk.services.cloudwatch.CfnCompositeAlarmProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
            this.props = new software.amazon.awscdk.services.cloudwatch.CfnCompositeAlarmProps.Builder();
        }

        /**
         * An expression that specifies which other alarms are to be evaluated to determine this composite alarm's state.
         * <p>
         * For each alarm that you reference, you designate a function that specifies whether that alarm needs to be in ALARM state, OK state, or INSUFFICIENT_DATA state. You can use operators (AND, OR and NOT) to combine multiple functions in a single expression. You can use parenthesis to logically group the functions in your expression.
         * <p>
         * You can use either alarm names or ARNs to reference the other alarms that are to be evaluated.
         * <p>
         * Functions can include the following:
         * <p>
         * <ul>
         * <li>ALARM("alarm-name or alarm-ARN") is TRUE if the named alarm is in ALARM state.</li>
         * <li>OK("alarm-name or alarm-ARN") is TRUE if the named alarm is in OK state.</li>
         * <li>INSUFFICIENT_DATA("alarm-name or alarm-ARN") is TRUE if the named alarm is in INSUFFICIENT_DATA state.</li>
         * <li>TRUE always evaluates to TRUE.</li>
         * <li>FALSE always evaluates to FALSE.</li>
         * </ul>
         * <p>
         * TRUE and FALSE are useful for testing a complex AlarmRule structure, and for testing your alarm actions.
         * <p>
         * For more information about <code>AlarmRule</code> syntax, see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/APIReference/API_PutCompositeAlarm.html">PutCompositeAlarm</a> in the <em>Amazon CloudWatch API Reference</em> .
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudwatch-compositealarm.html#cfn-cloudwatch-compositealarm-alarmrule">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudwatch-compositealarm.html#cfn-cloudwatch-compositealarm-alarmrule</a>
         * @param alarmRule An expression that specifies which other alarms are to be evaluated to determine this composite alarm's state. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder alarmRule(final java.lang.String alarmRule) {
            this.props.alarmRule(alarmRule);
            return this;
        }

        /**
         * Indicates whether actions should be executed during any changes to the alarm state of the composite alarm.
         * <p>
         * The default is TRUE.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudwatch-compositealarm.html#cfn-cloudwatch-compositealarm-actionsenabled">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudwatch-compositealarm.html#cfn-cloudwatch-compositealarm-actionsenabled</a>
         * @param actionsEnabled Indicates whether actions should be executed during any changes to the alarm state of the composite alarm. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder actionsEnabled(final java.lang.Boolean actionsEnabled) {
            this.props.actionsEnabled(actionsEnabled);
            return this;
        }
        /**
         * Indicates whether actions should be executed during any changes to the alarm state of the composite alarm.
         * <p>
         * The default is TRUE.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudwatch-compositealarm.html#cfn-cloudwatch-compositealarm-actionsenabled">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudwatch-compositealarm.html#cfn-cloudwatch-compositealarm-actionsenabled</a>
         * @param actionsEnabled Indicates whether actions should be executed during any changes to the alarm state of the composite alarm. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder actionsEnabled(final software.amazon.awscdk.IResolvable actionsEnabled) {
            this.props.actionsEnabled(actionsEnabled);
            return this;
        }

        /**
         * Actions will be suppressed if the suppressor alarm is in the <code>ALARM</code> state.
         * <p>
         * <code>ActionsSuppressor</code> can be an AlarmName or an Amazon Resource Name (ARN) from an existing alarm.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudwatch-compositealarm.html#cfn-cloudwatch-compositealarm-actionssuppressor">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudwatch-compositealarm.html#cfn-cloudwatch-compositealarm-actionssuppressor</a>
         * @param actionsSuppressor Actions will be suppressed if the suppressor alarm is in the <code>ALARM</code> state. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder actionsSuppressor(final java.lang.String actionsSuppressor) {
            this.props.actionsSuppressor(actionsSuppressor);
            return this;
        }

        /**
         * The maximum time in seconds that the composite alarm waits after suppressor alarm goes out of the <code>ALARM</code> state.
         * <p>
         * After this time, the composite alarm performs its actions.
         * <p>
         * <blockquote>
         * <p>
         * <code>ExtensionPeriod</code> is required only when <code>ActionsSuppressor</code> is specified.
         * <p>
         * </blockquote>
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudwatch-compositealarm.html#cfn-cloudwatch-compositealarm-actionssuppressorextensionperiod">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudwatch-compositealarm.html#cfn-cloudwatch-compositealarm-actionssuppressorextensionperiod</a>
         * @param actionsSuppressorExtensionPeriod The maximum time in seconds that the composite alarm waits after suppressor alarm goes out of the <code>ALARM</code> state. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder actionsSuppressorExtensionPeriod(final java.lang.Number actionsSuppressorExtensionPeriod) {
            this.props.actionsSuppressorExtensionPeriod(actionsSuppressorExtensionPeriod);
            return this;
        }

        /**
         * The maximum time in seconds that the composite alarm waits for the suppressor alarm to go into the <code>ALARM</code> state.
         * <p>
         * After this time, the composite alarm performs its actions.
         * <p>
         * <blockquote>
         * <p>
         * <code>WaitPeriod</code> is required only when <code>ActionsSuppressor</code> is specified.
         * <p>
         * </blockquote>
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudwatch-compositealarm.html#cfn-cloudwatch-compositealarm-actionssuppressorwaitperiod">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudwatch-compositealarm.html#cfn-cloudwatch-compositealarm-actionssuppressorwaitperiod</a>
         * @param actionsSuppressorWaitPeriod The maximum time in seconds that the composite alarm waits for the suppressor alarm to go into the <code>ALARM</code> state. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder actionsSuppressorWaitPeriod(final java.lang.Number actionsSuppressorWaitPeriod) {
            this.props.actionsSuppressorWaitPeriod(actionsSuppressorWaitPeriod);
            return this;
        }

        /**
         * The actions to execute when this alarm transitions to the ALARM state from any other state.
         * <p>
         * Each action is specified as an Amazon Resource Name (ARN). For more information about creating alarms and the actions that you can specify, see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/APIReference/API_PutCompositeAlarm.html">PutCompositeAlarm</a> in the <em>Amazon CloudWatch API Reference</em> .
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudwatch-compositealarm.html#cfn-cloudwatch-compositealarm-alarmactions">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudwatch-compositealarm.html#cfn-cloudwatch-compositealarm-alarmactions</a>
         * @param alarmActions The actions to execute when this alarm transitions to the ALARM state from any other state. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder alarmActions(final java.util.List<java.lang.String> alarmActions) {
            this.props.alarmActions(alarmActions);
            return this;
        }

        /**
         * The description for the composite alarm.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudwatch-compositealarm.html#cfn-cloudwatch-compositealarm-alarmdescription">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudwatch-compositealarm.html#cfn-cloudwatch-compositealarm-alarmdescription</a>
         * @param alarmDescription The description for the composite alarm. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder alarmDescription(final java.lang.String alarmDescription) {
            this.props.alarmDescription(alarmDescription);
            return this;
        }

        /**
         * The name for the composite alarm.
         * <p>
         * This name must be unique within your AWS account.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudwatch-compositealarm.html#cfn-cloudwatch-compositealarm-alarmname">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudwatch-compositealarm.html#cfn-cloudwatch-compositealarm-alarmname</a>
         * @param alarmName The name for the composite alarm. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder alarmName(final java.lang.String alarmName) {
            this.props.alarmName(alarmName);
            return this;
        }

        /**
         * The actions to execute when this alarm transitions to the INSUFFICIENT_DATA state from any other state.
         * <p>
         * Each action is specified as an Amazon Resource Name (ARN). For more information about creating alarms and the actions that you can specify, see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/APIReference/API_PutCompositeAlarm.html">PutCompositeAlarm</a> in the <em>Amazon CloudWatch API Reference</em> .
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudwatch-compositealarm.html#cfn-cloudwatch-compositealarm-insufficientdataactions">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudwatch-compositealarm.html#cfn-cloudwatch-compositealarm-insufficientdataactions</a>
         * @param insufficientDataActions The actions to execute when this alarm transitions to the INSUFFICIENT_DATA state from any other state. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder insufficientDataActions(final java.util.List<java.lang.String> insufficientDataActions) {
            this.props.insufficientDataActions(insufficientDataActions);
            return this;
        }

        /**
         * The actions to execute when this alarm transitions to the OK state from any other state.
         * <p>
         * Each action is specified as an Amazon Resource Name (ARN). For more information about creating alarms and the actions that you can specify, see <a href="https://docs.aws.amazon.com/AmazonCloudWatch/latest/APIReference/API_PutCompositeAlarm.html">PutCompositeAlarm</a> in the <em>Amazon CloudWatch API Reference</em> .
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudwatch-compositealarm.html#cfn-cloudwatch-compositealarm-okactions">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudwatch-compositealarm.html#cfn-cloudwatch-compositealarm-okactions</a>
         * @param okActions The actions to execute when this alarm transitions to the OK state from any other state. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder okActions(final java.util.List<java.lang.String> okActions) {
            this.props.okActions(okActions);
            return this;
        }

        /**
         * A list of key-value pairs to associate with the alarm.
         * <p>
         * You can associate as many as 50 tags with an alarm. To be able to associate tags with the alarm when you create the alarm, you must have the <code>cloudwatch:TagResource</code> permission.
         * <p>
         * Tags can help you organize and categorize your resources. You can also use them to scope user permissions by granting a user permission to access or change only resources with certain tag values.
         * <p>
         * @return {@code this}
         * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudwatch-compositealarm.html#cfn-cloudwatch-compositealarm-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-cloudwatch-compositealarm.html#cfn-cloudwatch-compositealarm-tags</a>
         * @param tags A list of key-value pairs to associate with the alarm. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tags(final java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.props.tags(tags);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.cloudwatch.CfnCompositeAlarm}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.cloudwatch.CfnCompositeAlarm build() {
            return new software.amazon.awscdk.services.cloudwatch.CfnCompositeAlarm(
                this.scope,
                this.id,
                this.props.build()
            );
        }
    }
}
