package software.amazon.awscdk.services.cloudwatch;

/**
 * Search components for use with {@link Values.fromSearchComponents}.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * import software.amazon.awscdk.services.cloudwatch.*;
 * Dashboard dashboard = Dashboard.Builder.create(this, "Dash")
 *         .defaultInterval(Duration.days(7))
 *         .variables(List.of(DashboardVariable.Builder.create()
 *                 .id("functionName")
 *                 .type(VariableType.PATTERN)
 *                 .label("Function")
 *                 .inputType(VariableInputType.RADIO)
 *                 .value("originalFuncNameInDashboard")
 *                 // equivalent to cw.Values.fromSearch('{AWS/Lambda,FunctionName} MetricName=\"Duration\"', 'FunctionName')
 *                 .values(Values.fromSearchComponents(SearchComponents.builder()
 *                         .namespace("AWS/Lambda")
 *                         .dimensions(List.of("FunctionName"))
 *                         .metricName("Duration")
 *                         .populateFrom("FunctionName")
 *                         .build()))
 *                 .defaultValue(DefaultValue.FIRST)
 *                 .visible(true)
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.106.0 (build e852934)", date = "2025-02-21T03:20:29.878Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_cloudwatch.SearchComponents")
@software.amazon.jsii.Jsii.Proxy(SearchComponents.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface SearchComponents extends software.amazon.jsii.JsiiSerializable {

    /**
     * The list of dimensions to be used in the search expression.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.util.List<java.lang.String> getDimensions();

    /**
     * The metric name to be used in the search expression.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getMetricName();

    /**
     * The namespace to be used in the search expression.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getNamespace();

    /**
     * The dimension name, that the search expression retrieves, whose values will be used to populate the values to choose from.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getPopulateFrom();

    /**
     * @return a {@link Builder} of {@link SearchComponents}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link SearchComponents}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<SearchComponents> {
        java.util.List<java.lang.String> dimensions;
        java.lang.String metricName;
        java.lang.String namespace;
        java.lang.String populateFrom;

        /**
         * Sets the value of {@link SearchComponents#getDimensions}
         * @param dimensions The list of dimensions to be used in the search expression. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder dimensions(java.util.List<java.lang.String> dimensions) {
            this.dimensions = dimensions;
            return this;
        }

        /**
         * Sets the value of {@link SearchComponents#getMetricName}
         * @param metricName The metric name to be used in the search expression. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder metricName(java.lang.String metricName) {
            this.metricName = metricName;
            return this;
        }

        /**
         * Sets the value of {@link SearchComponents#getNamespace}
         * @param namespace The namespace to be used in the search expression. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder namespace(java.lang.String namespace) {
            this.namespace = namespace;
            return this;
        }

        /**
         * Sets the value of {@link SearchComponents#getPopulateFrom}
         * @param populateFrom The dimension name, that the search expression retrieves, whose values will be used to populate the values to choose from. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder populateFrom(java.lang.String populateFrom) {
            this.populateFrom = populateFrom;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link SearchComponents}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public SearchComponents build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link SearchComponents}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements SearchComponents {
        private final java.util.List<java.lang.String> dimensions;
        private final java.lang.String metricName;
        private final java.lang.String namespace;
        private final java.lang.String populateFrom;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.dimensions = software.amazon.jsii.Kernel.get(this, "dimensions", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.metricName = software.amazon.jsii.Kernel.get(this, "metricName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.namespace = software.amazon.jsii.Kernel.get(this, "namespace", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.populateFrom = software.amazon.jsii.Kernel.get(this, "populateFrom", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.dimensions = java.util.Objects.requireNonNull(builder.dimensions, "dimensions is required");
            this.metricName = java.util.Objects.requireNonNull(builder.metricName, "metricName is required");
            this.namespace = java.util.Objects.requireNonNull(builder.namespace, "namespace is required");
            this.populateFrom = java.util.Objects.requireNonNull(builder.populateFrom, "populateFrom is required");
        }

        @Override
        public final java.util.List<java.lang.String> getDimensions() {
            return this.dimensions;
        }

        @Override
        public final java.lang.String getMetricName() {
            return this.metricName;
        }

        @Override
        public final java.lang.String getNamespace() {
            return this.namespace;
        }

        @Override
        public final java.lang.String getPopulateFrom() {
            return this.populateFrom;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("dimensions", om.valueToTree(this.getDimensions()));
            data.set("metricName", om.valueToTree(this.getMetricName()));
            data.set("namespace", om.valueToTree(this.getNamespace()));
            data.set("populateFrom", om.valueToTree(this.getPopulateFrom()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_cloudwatch.SearchComponents"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            SearchComponents.Jsii$Proxy that = (SearchComponents.Jsii$Proxy) o;

            if (!dimensions.equals(that.dimensions)) return false;
            if (!metricName.equals(that.metricName)) return false;
            if (!namespace.equals(that.namespace)) return false;
            return this.populateFrom.equals(that.populateFrom);
        }

        @Override
        public final int hashCode() {
            int result = this.dimensions.hashCode();
            result = 31 * result + (this.metricName.hashCode());
            result = 31 * result + (this.namespace.hashCode());
            result = 31 * result + (this.populateFrom.hashCode());
            return result;
        }
    }
}
