package software.amazon.awscdk.services.codepipeline;

/**
 * Properties of registering a custom Action.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // Make a custom CodePipeline Action
 * // Make a custom CodePipeline Action
 * CustomActionRegistration.Builder.create(this, "GenericGitSourceProviderResource")
 *         .category(ActionCategory.SOURCE)
 *         .artifactBounds(ActionArtifactBounds.builder().minInputs(0).maxInputs(0).minOutputs(1).maxOutputs(1).build())
 *         .provider("GenericGitSource")
 *         .version("1")
 *         .entityUrl("https://docs.aws.amazon.com/codepipeline/latest/userguide/actions-create-custom-action.html")
 *         .executionUrl("https://docs.aws.amazon.com/codepipeline/latest/userguide/actions-create-custom-action.html")
 *         .actionProperties(List.of(CustomActionProperty.builder()
 *                 .name("Branch")
 *                 .required(true)
 *                 .key(false)
 *                 .secret(false)
 *                 .queryable(false)
 *                 .description("Git branch to pull")
 *                 .type("String")
 *                 .build(), CustomActionProperty.builder()
 *                 .name("GitUrl")
 *                 .required(true)
 *                 .key(false)
 *                 .secret(false)
 *                 .queryable(false)
 *                 .description("SSH git clone URL")
 *                 .type("String")
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.106.0 (build e852934)", date = "2025-02-21T03:20:30.243Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_codepipeline.CustomActionRegistrationProps")
@software.amazon.jsii.Jsii.Proxy(CustomActionRegistrationProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CustomActionRegistrationProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The artifact bounds of the Action.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.codepipeline.ActionArtifactBounds getArtifactBounds();

    /**
     * The category of the Action.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.codepipeline.ActionCategory getCategory();

    /**
     * The provider of the Action.
     * <p>
     * For example, <code>'MyCustomActionProvider'</code>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.String getProvider();

    /**
     * The properties used for customizing the instance of your Action.
     * <p>
     * Default: []
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.services.codepipeline.CustomActionProperty> getActionProperties() {
        return null;
    }

    /**
     * The URL shown for the entire Action in the Pipeline UI.
     * <p>
     * Default: none
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getEntityUrl() {
        return null;
    }

    /**
     * The URL shown for a particular execution of an Action in the Pipeline UI.
     * <p>
     * Default: none
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getExecutionUrl() {
        return null;
    }

    /**
     * The version of your Action.
     * <p>
     * Default: '1'
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getVersion() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CustomActionRegistrationProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CustomActionRegistrationProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CustomActionRegistrationProps> {
        software.amazon.awscdk.services.codepipeline.ActionArtifactBounds artifactBounds;
        software.amazon.awscdk.services.codepipeline.ActionCategory category;
        java.lang.String provider;
        java.util.List<software.amazon.awscdk.services.codepipeline.CustomActionProperty> actionProperties;
        java.lang.String entityUrl;
        java.lang.String executionUrl;
        java.lang.String version;

        /**
         * Sets the value of {@link CustomActionRegistrationProps#getArtifactBounds}
         * @param artifactBounds The artifact bounds of the Action. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder artifactBounds(software.amazon.awscdk.services.codepipeline.ActionArtifactBounds artifactBounds) {
            this.artifactBounds = artifactBounds;
            return this;
        }

        /**
         * Sets the value of {@link CustomActionRegistrationProps#getCategory}
         * @param category The category of the Action. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder category(software.amazon.awscdk.services.codepipeline.ActionCategory category) {
            this.category = category;
            return this;
        }

        /**
         * Sets the value of {@link CustomActionRegistrationProps#getProvider}
         * @param provider The provider of the Action. This parameter is required.
         *                 For example, <code>'MyCustomActionProvider'</code>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder provider(java.lang.String provider) {
            this.provider = provider;
            return this;
        }

        /**
         * Sets the value of {@link CustomActionRegistrationProps#getActionProperties}
         * @param actionProperties The properties used for customizing the instance of your Action.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder actionProperties(java.util.List<? extends software.amazon.awscdk.services.codepipeline.CustomActionProperty> actionProperties) {
            this.actionProperties = (java.util.List<software.amazon.awscdk.services.codepipeline.CustomActionProperty>)actionProperties;
            return this;
        }

        /**
         * Sets the value of {@link CustomActionRegistrationProps#getEntityUrl}
         * @param entityUrl The URL shown for the entire Action in the Pipeline UI.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder entityUrl(java.lang.String entityUrl) {
            this.entityUrl = entityUrl;
            return this;
        }

        /**
         * Sets the value of {@link CustomActionRegistrationProps#getExecutionUrl}
         * @param executionUrl The URL shown for a particular execution of an Action in the Pipeline UI.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder executionUrl(java.lang.String executionUrl) {
            this.executionUrl = executionUrl;
            return this;
        }

        /**
         * Sets the value of {@link CustomActionRegistrationProps#getVersion}
         * @param version The version of your Action.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder version(java.lang.String version) {
            this.version = version;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CustomActionRegistrationProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CustomActionRegistrationProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CustomActionRegistrationProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CustomActionRegistrationProps {
        private final software.amazon.awscdk.services.codepipeline.ActionArtifactBounds artifactBounds;
        private final software.amazon.awscdk.services.codepipeline.ActionCategory category;
        private final java.lang.String provider;
        private final java.util.List<software.amazon.awscdk.services.codepipeline.CustomActionProperty> actionProperties;
        private final java.lang.String entityUrl;
        private final java.lang.String executionUrl;
        private final java.lang.String version;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.artifactBounds = software.amazon.jsii.Kernel.get(this, "artifactBounds", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.codepipeline.ActionArtifactBounds.class));
            this.category = software.amazon.jsii.Kernel.get(this, "category", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.codepipeline.ActionCategory.class));
            this.provider = software.amazon.jsii.Kernel.get(this, "provider", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.actionProperties = software.amazon.jsii.Kernel.get(this, "actionProperties", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.codepipeline.CustomActionProperty.class)));
            this.entityUrl = software.amazon.jsii.Kernel.get(this, "entityUrl", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.executionUrl = software.amazon.jsii.Kernel.get(this, "executionUrl", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.version = software.amazon.jsii.Kernel.get(this, "version", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.artifactBounds = java.util.Objects.requireNonNull(builder.artifactBounds, "artifactBounds is required");
            this.category = java.util.Objects.requireNonNull(builder.category, "category is required");
            this.provider = java.util.Objects.requireNonNull(builder.provider, "provider is required");
            this.actionProperties = (java.util.List<software.amazon.awscdk.services.codepipeline.CustomActionProperty>)builder.actionProperties;
            this.entityUrl = builder.entityUrl;
            this.executionUrl = builder.executionUrl;
            this.version = builder.version;
        }

        @Override
        public final software.amazon.awscdk.services.codepipeline.ActionArtifactBounds getArtifactBounds() {
            return this.artifactBounds;
        }

        @Override
        public final software.amazon.awscdk.services.codepipeline.ActionCategory getCategory() {
            return this.category;
        }

        @Override
        public final java.lang.String getProvider() {
            return this.provider;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.services.codepipeline.CustomActionProperty> getActionProperties() {
            return this.actionProperties;
        }

        @Override
        public final java.lang.String getEntityUrl() {
            return this.entityUrl;
        }

        @Override
        public final java.lang.String getExecutionUrl() {
            return this.executionUrl;
        }

        @Override
        public final java.lang.String getVersion() {
            return this.version;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("artifactBounds", om.valueToTree(this.getArtifactBounds()));
            data.set("category", om.valueToTree(this.getCategory()));
            data.set("provider", om.valueToTree(this.getProvider()));
            if (this.getActionProperties() != null) {
                data.set("actionProperties", om.valueToTree(this.getActionProperties()));
            }
            if (this.getEntityUrl() != null) {
                data.set("entityUrl", om.valueToTree(this.getEntityUrl()));
            }
            if (this.getExecutionUrl() != null) {
                data.set("executionUrl", om.valueToTree(this.getExecutionUrl()));
            }
            if (this.getVersion() != null) {
                data.set("version", om.valueToTree(this.getVersion()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_codepipeline.CustomActionRegistrationProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CustomActionRegistrationProps.Jsii$Proxy that = (CustomActionRegistrationProps.Jsii$Proxy) o;

            if (!artifactBounds.equals(that.artifactBounds)) return false;
            if (!category.equals(that.category)) return false;
            if (!provider.equals(that.provider)) return false;
            if (this.actionProperties != null ? !this.actionProperties.equals(that.actionProperties) : that.actionProperties != null) return false;
            if (this.entityUrl != null ? !this.entityUrl.equals(that.entityUrl) : that.entityUrl != null) return false;
            if (this.executionUrl != null ? !this.executionUrl.equals(that.executionUrl) : that.executionUrl != null) return false;
            return this.version != null ? this.version.equals(that.version) : that.version == null;
        }

        @Override
        public final int hashCode() {
            int result = this.artifactBounds.hashCode();
            result = 31 * result + (this.category.hashCode());
            result = 31 * result + (this.provider.hashCode());
            result = 31 * result + (this.actionProperties != null ? this.actionProperties.hashCode() : 0);
            result = 31 * result + (this.entityUrl != null ? this.entityUrl.hashCode() : 0);
            result = 31 * result + (this.executionUrl != null ? this.executionUrl.hashCode() : 0);
            result = 31 * result + (this.version != null ? this.version.hashCode() : 0);
            return result;
        }
    }
}
