package software.amazon.awscdk.services.codepipeline.actions;

/**
 * CodePipeline compute action that uses AWS Commands.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * Artifact sourceArtifact;
 * Artifact outputArtifact;
 * CommandsAction commandsAction = CommandsAction.Builder.create()
 *         .actionName("Commands")
 *         .commands(List.of("export MY_OUTPUT=my-key"))
 *         .input(sourceArtifact)
 *         .output(outputArtifact)
 *         .outputVariables(List.of("MY_OUTPUT", "CODEBUILD_BUILD_ID"))
 *         .build();
 * // Deploy action
 * S3DeployAction deployAction = S3DeployAction.Builder.create()
 *         .actionName("DeployAction")
 *         .extract(true)
 *         .input(outputArtifact)
 *         .bucket(new Bucket(this, "DeployBucket"))
 *         .objectKey(commandsAction.variable("MY_OUTPUT"))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.106.0 (build e852934)", date = "2025-02-21T03:20:30.330Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_codepipeline_actions.CommandsAction")
public class CommandsAction extends software.amazon.awscdk.services.codepipeline.actions.Action {

    protected CommandsAction(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected CommandsAction(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * @param props This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public CommandsAction(final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.codepipeline.actions.CommandsActionProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(props, "props is required") });
    }

    /**
     * This is a renamed version of the <code>IAction.bind</code> method.
     * <p>
     * @param scope This parameter is required.
     * @param stage This parameter is required.
     * @param options This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    protected @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.codepipeline.ActionConfig bound(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.codepipeline.IStage stage, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.codepipeline.ActionBindOptions options) {
        return software.amazon.jsii.Kernel.call(this, "bound", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.codepipeline.ActionConfig.class), new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(stage, "stage is required"), java.util.Objects.requireNonNull(options, "options is required") });
    }

    /**
     * Reference a CodePipeline variable exported in the Commands action.
     * <p>
     * @see <a href="https://docs.aws.amazon.com/codebuild/latest/userguide/build-env-ref-env-vars.html">https://docs.aws.amazon.com/codebuild/latest/userguide/build-env-ref-env-vars.html</a>
     * @param variableName the name of the variable exported by <code>outputVariables</code>. This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull java.lang.String variable(final @org.jetbrains.annotations.NotNull java.lang.String variableName) {
        return software.amazon.jsii.Kernel.call(this, "variable", software.amazon.jsii.NativeType.forClass(java.lang.String.class), new Object[] { java.util.Objects.requireNonNull(variableName, "variableName is required") });
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.codepipeline.actions.CommandsAction}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.codepipeline.actions.CommandsAction> {
        /**
         * @return a new instance of {@link Builder}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create() {
            return new Builder();
        }

        private final software.amazon.awscdk.services.codepipeline.actions.CommandsActionProps.Builder props;

        private Builder() {
            this.props = new software.amazon.awscdk.services.codepipeline.actions.CommandsActionProps.Builder();
        }

        /**
         * The physical, human-readable name of the Action.
         * <p>
         * Note that Action names must be unique within a single Stage.
         * <p>
         * @return {@code this}
         * @param actionName The physical, human-readable name of the Action. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder actionName(final java.lang.String actionName) {
            this.props.actionName(actionName);
            return this;
        }

        /**
         * The runOrder property for this Action.
         * <p>
         * RunOrder determines the relative order in which multiple Actions in the same Stage execute.
         * <p>
         * Default: 1
         * <p>
         * @return {@code this}
         * @see <a href="https://docs.aws.amazon.com/codepipeline/latest/userguide/reference-pipeline-structure.html">https://docs.aws.amazon.com/codepipeline/latest/userguide/reference-pipeline-structure.html</a>
         * @param runOrder The runOrder property for this Action. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder runOrder(final java.lang.Number runOrder) {
            this.props.runOrder(runOrder);
            return this;
        }

        /**
         * The name of the namespace to use for variables emitted by this action.
         * <p>
         * Default: - a name will be generated, based on the stage and action names,
         * if any of the action's variables were referenced - otherwise,
         * no namespace will be set
         * <p>
         * @return {@code this}
         * @param variablesNamespace The name of the namespace to use for variables emitted by this action. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder variablesNamespace(final java.lang.String variablesNamespace) {
            this.props.variablesNamespace(variablesNamespace);
            return this;
        }

        /**
         * The Role in which context's this Action will be executing in.
         * <p>
         * The Pipeline's Role will assume this Role
         * (the required permissions for that will be granted automatically)
         * right before executing this Action.
         * This Action will be passed into your <code>IAction.bind</code>
         * method in the <code>ActionBindOptions.role</code> property.
         * <p>
         * Default: a new Role will be generated
         * <p>
         * @return {@code this}
         * @param role The Role in which context's this Action will be executing in. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder role(final software.amazon.awscdk.services.iam.IRole role) {
            this.props.role(role);
            return this;
        }

        /**
         * Shell commands for the Commands action to run.
         * <p>
         * All formats are supported except multi-line formats.
         * <p>
         * The length of the commands array must be between 1 and 50.
         * <p>
         * @return {@code this}
         * @param commands Shell commands for the Commands action to run. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder commands(final java.util.List<java.lang.String> commands) {
            this.props.commands(commands);
            return this;
        }

        /**
         * The source to use as input for this action.
         * <p>
         * @return {@code this}
         * @param input The source to use as input for this action. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder input(final software.amazon.awscdk.services.codepipeline.Artifact input) {
            this.props.input(input);
            return this;
        }

        /**
         * The list of additional input artifacts for this action.
         * <p>
         * Default: - no extra inputs
         * <p>
         * @return {@code this}
         * @param extraInputs The list of additional input artifacts for this action. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder extraInputs(final java.util.List<? extends software.amazon.awscdk.services.codepipeline.Artifact> extraInputs) {
            this.props.extraInputs(extraInputs);
            return this;
        }

        /**
         * The output artifact for this action.
         * <p>
         * You can filter files that you want to export as the output artifact for the action.
         * <p>
         * Default: - no output artifact
         * <p>
         * Example:
         * <p>
         * <blockquote><pre>
         * new Artifact("CommandsArtifact", List.of("my-dir/**"));
         * </pre></blockquote>
         * <p>
         * @return {@code this}
         * @param output The output artifact for this action. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder output(final software.amazon.awscdk.services.codepipeline.Artifact output) {
            this.props.output(output);
            return this;
        }

        /**
         * The names of the variables in your environment that you want to export.
         * <p>
         * These variables can be referenced in other actions by using the <code>variable</code> method
         * of this class.
         * <p>
         * Default: - No output variables are exported
         * <p>
         * @return {@code this}
         * @see <a href="https://docs.aws.amazon.com/codebuild/latest/userguide/build-env-ref-env-vars.html">https://docs.aws.amazon.com/codebuild/latest/userguide/build-env-ref-env-vars.html</a>
         * @param outputVariables The names of the variables in your environment that you want to export. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder outputVariables(final java.util.List<java.lang.String> outputVariables) {
            this.props.outputVariables(outputVariables);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.codepipeline.actions.CommandsAction}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.codepipeline.actions.CommandsAction build() {
            return new software.amazon.awscdk.services.codepipeline.actions.CommandsAction(
                this.props.build()
            );
        }
    }
}
