package software.amazon.awscdk.services.cognito;

/**
 * Device tracking settings.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * UserPool.Builder.create(this, "myuserpool")
 *         // ...
 *         .deviceTracking(DeviceTracking.builder()
 *                 .challengeRequiredOnNewDevice(true)
 *                 .deviceOnlyRememberedOnUserPrompt(true)
 *                 .build())
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/amazon-cognito-user-pools-device-tracking.html">https://docs.aws.amazon.com/cognito/latest/developerguide/amazon-cognito-user-pools-device-tracking.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.106.0 (build e852934)", date = "2025-02-21T03:20:30.524Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_cognito.DeviceTracking")
@software.amazon.jsii.Jsii.Proxy(DeviceTracking.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface DeviceTracking extends software.amazon.jsii.JsiiSerializable {

    /**
     * Indicates whether a challenge is required on a new device.
     * <p>
     * Only applicable to a new device.
     * <p>
     * Default: false
     * <p>
     * @see <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/amazon-cognito-user-pools-device-tracking.html">https://docs.aws.amazon.com/cognito/latest/developerguide/amazon-cognito-user-pools-device-tracking.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.Boolean getChallengeRequiredOnNewDevice();

    /**
     * If true, a device is only remembered on user prompt.
     * <p>
     * Default: false
     * <p>
     * @see <a href="https://docs.aws.amazon.com/cognito/latest/developerguide/amazon-cognito-user-pools-device-tracking.html">https://docs.aws.amazon.com/cognito/latest/developerguide/amazon-cognito-user-pools-device-tracking.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull java.lang.Boolean getDeviceOnlyRememberedOnUserPrompt();

    /**
     * @return a {@link Builder} of {@link DeviceTracking}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link DeviceTracking}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<DeviceTracking> {
        java.lang.Boolean challengeRequiredOnNewDevice;
        java.lang.Boolean deviceOnlyRememberedOnUserPrompt;

        /**
         * Sets the value of {@link DeviceTracking#getChallengeRequiredOnNewDevice}
         * @param challengeRequiredOnNewDevice Indicates whether a challenge is required on a new device. This parameter is required.
         *                                     Only applicable to a new device.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder challengeRequiredOnNewDevice(java.lang.Boolean challengeRequiredOnNewDevice) {
            this.challengeRequiredOnNewDevice = challengeRequiredOnNewDevice;
            return this;
        }

        /**
         * Sets the value of {@link DeviceTracking#getDeviceOnlyRememberedOnUserPrompt}
         * @param deviceOnlyRememberedOnUserPrompt If true, a device is only remembered on user prompt. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder deviceOnlyRememberedOnUserPrompt(java.lang.Boolean deviceOnlyRememberedOnUserPrompt) {
            this.deviceOnlyRememberedOnUserPrompt = deviceOnlyRememberedOnUserPrompt;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link DeviceTracking}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public DeviceTracking build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link DeviceTracking}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements DeviceTracking {
        private final java.lang.Boolean challengeRequiredOnNewDevice;
        private final java.lang.Boolean deviceOnlyRememberedOnUserPrompt;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.challengeRequiredOnNewDevice = software.amazon.jsii.Kernel.get(this, "challengeRequiredOnNewDevice", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.deviceOnlyRememberedOnUserPrompt = software.amazon.jsii.Kernel.get(this, "deviceOnlyRememberedOnUserPrompt", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.challengeRequiredOnNewDevice = java.util.Objects.requireNonNull(builder.challengeRequiredOnNewDevice, "challengeRequiredOnNewDevice is required");
            this.deviceOnlyRememberedOnUserPrompt = java.util.Objects.requireNonNull(builder.deviceOnlyRememberedOnUserPrompt, "deviceOnlyRememberedOnUserPrompt is required");
        }

        @Override
        public final java.lang.Boolean getChallengeRequiredOnNewDevice() {
            return this.challengeRequiredOnNewDevice;
        }

        @Override
        public final java.lang.Boolean getDeviceOnlyRememberedOnUserPrompt() {
            return this.deviceOnlyRememberedOnUserPrompt;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("challengeRequiredOnNewDevice", om.valueToTree(this.getChallengeRequiredOnNewDevice()));
            data.set("deviceOnlyRememberedOnUserPrompt", om.valueToTree(this.getDeviceOnlyRememberedOnUserPrompt()));

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_cognito.DeviceTracking"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            DeviceTracking.Jsii$Proxy that = (DeviceTracking.Jsii$Proxy) o;

            if (!challengeRequiredOnNewDevice.equals(that.challengeRequiredOnNewDevice)) return false;
            return this.deviceOnlyRememberedOnUserPrompt.equals(that.deviceOnlyRememberedOnUserPrompt);
        }

        @Override
        public final int hashCode() {
            int result = this.challengeRequiredOnNewDevice.hashCode();
            result = 31 * result + (this.deviceOnlyRememberedOnUserPrompt.hashCode());
            return result;
        }
    }
}
