package software.amazon.awscdk.services.ec2;

/**
 * Block device options for an EBS volume created from a snapshot.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.ec2.*;
 * EbsDeviceSnapshotOptions ebsDeviceSnapshotOptions = EbsDeviceSnapshotOptions.builder()
 *         .deleteOnTermination(false)
 *         .iops(123)
 *         .throughput(123)
 *         .volumeSize(123)
 *         .volumeType(EbsDeviceVolumeType.STANDARD)
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.106.0 (build e852934)", date = "2025-02-21T03:20:32.061Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ec2.EbsDeviceSnapshotOptions")
@software.amazon.jsii.Jsii.Proxy(EbsDeviceSnapshotOptions.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface EbsDeviceSnapshotOptions extends software.amazon.jsii.JsiiSerializable, software.amazon.awscdk.services.ec2.EbsDeviceOptionsBase {

    /**
     * The volume size, in Gibibytes (GiB).
     * <p>
     * If you specify volumeSize, it must be equal or greater than the size of the snapshot.
     * <p>
     * Default: - The snapshot size
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getVolumeSize() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link EbsDeviceSnapshotOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link EbsDeviceSnapshotOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<EbsDeviceSnapshotOptions> {
        java.lang.Number volumeSize;
        java.lang.Boolean deleteOnTermination;
        java.lang.Number iops;
        java.lang.Number throughput;
        software.amazon.awscdk.services.ec2.EbsDeviceVolumeType volumeType;

        /**
         * Sets the value of {@link EbsDeviceSnapshotOptions#getVolumeSize}
         * @param volumeSize The volume size, in Gibibytes (GiB).
         *                   If you specify volumeSize, it must be equal or greater than the size of the snapshot.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder volumeSize(java.lang.Number volumeSize) {
            this.volumeSize = volumeSize;
            return this;
        }

        /**
         * Sets the value of {@link EbsDeviceSnapshotOptions#getDeleteOnTermination}
         * @param deleteOnTermination Indicates whether to delete the volume when the instance is terminated.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder deleteOnTermination(java.lang.Boolean deleteOnTermination) {
            this.deleteOnTermination = deleteOnTermination;
            return this;
        }

        /**
         * Sets the value of {@link EbsDeviceSnapshotOptions#getIops}
         * @param iops The number of I/O operations per second (IOPS) to provision for the volume.
         *             Must only be set for <code>volumeType</code>: <code>EbsDeviceVolumeType.IO1</code>
         *             <p>
         *             The maximum ratio of IOPS to volume size (in GiB) is 50:1, so for 5,000 provisioned IOPS,
         *             you need at least 100 GiB storage on the volume.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder iops(java.lang.Number iops) {
            this.iops = iops;
            return this;
        }

        /**
         * Sets the value of {@link EbsDeviceSnapshotOptions#getThroughput}
         * @param throughput The throughput to provision for a <code>gp3</code> volume.
         *                   Valid Range: Minimum value of 125. Maximum value of 1000.
         *                   <p>
         *                   <code>gp3</code> volumes deliver a consistent baseline throughput performance of 125 MiB/s.
         *                   You can provision additional throughput for an additional cost at a ratio of 0.25 MiB/s per provisioned IOPS.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder throughput(java.lang.Number throughput) {
            this.throughput = throughput;
            return this;
        }

        /**
         * Sets the value of {@link EbsDeviceSnapshotOptions#getVolumeType}
         * @param volumeType The EBS volume type.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder volumeType(software.amazon.awscdk.services.ec2.EbsDeviceVolumeType volumeType) {
            this.volumeType = volumeType;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link EbsDeviceSnapshotOptions}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public EbsDeviceSnapshotOptions build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link EbsDeviceSnapshotOptions}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements EbsDeviceSnapshotOptions {
        private final java.lang.Number volumeSize;
        private final java.lang.Boolean deleteOnTermination;
        private final java.lang.Number iops;
        private final java.lang.Number throughput;
        private final software.amazon.awscdk.services.ec2.EbsDeviceVolumeType volumeType;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.volumeSize = software.amazon.jsii.Kernel.get(this, "volumeSize", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.deleteOnTermination = software.amazon.jsii.Kernel.get(this, "deleteOnTermination", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.iops = software.amazon.jsii.Kernel.get(this, "iops", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.throughput = software.amazon.jsii.Kernel.get(this, "throughput", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.volumeType = software.amazon.jsii.Kernel.get(this, "volumeType", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.EbsDeviceVolumeType.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.volumeSize = builder.volumeSize;
            this.deleteOnTermination = builder.deleteOnTermination;
            this.iops = builder.iops;
            this.throughput = builder.throughput;
            this.volumeType = builder.volumeType;
        }

        @Override
        public final java.lang.Number getVolumeSize() {
            return this.volumeSize;
        }

        @Override
        public final java.lang.Boolean getDeleteOnTermination() {
            return this.deleteOnTermination;
        }

        @Override
        public final java.lang.Number getIops() {
            return this.iops;
        }

        @Override
        public final java.lang.Number getThroughput() {
            return this.throughput;
        }

        @Override
        public final software.amazon.awscdk.services.ec2.EbsDeviceVolumeType getVolumeType() {
            return this.volumeType;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getVolumeSize() != null) {
                data.set("volumeSize", om.valueToTree(this.getVolumeSize()));
            }
            if (this.getDeleteOnTermination() != null) {
                data.set("deleteOnTermination", om.valueToTree(this.getDeleteOnTermination()));
            }
            if (this.getIops() != null) {
                data.set("iops", om.valueToTree(this.getIops()));
            }
            if (this.getThroughput() != null) {
                data.set("throughput", om.valueToTree(this.getThroughput()));
            }
            if (this.getVolumeType() != null) {
                data.set("volumeType", om.valueToTree(this.getVolumeType()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_ec2.EbsDeviceSnapshotOptions"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            EbsDeviceSnapshotOptions.Jsii$Proxy that = (EbsDeviceSnapshotOptions.Jsii$Proxy) o;

            if (this.volumeSize != null ? !this.volumeSize.equals(that.volumeSize) : that.volumeSize != null) return false;
            if (this.deleteOnTermination != null ? !this.deleteOnTermination.equals(that.deleteOnTermination) : that.deleteOnTermination != null) return false;
            if (this.iops != null ? !this.iops.equals(that.iops) : that.iops != null) return false;
            if (this.throughput != null ? !this.throughput.equals(that.throughput) : that.throughput != null) return false;
            return this.volumeType != null ? this.volumeType.equals(that.volumeType) : that.volumeType == null;
        }

        @Override
        public final int hashCode() {
            int result = this.volumeSize != null ? this.volumeSize.hashCode() : 0;
            result = 31 * result + (this.deleteOnTermination != null ? this.deleteOnTermination.hashCode() : 0);
            result = 31 * result + (this.iops != null ? this.iops.hashCode() : 0);
            result = 31 * result + (this.throughput != null ? this.throughput.hashCode() : 0);
            result = 31 * result + (this.volumeType != null ? this.volumeType.hashCode() : 0);
            return result;
        }
    }
}
