package software.amazon.awscdk.services.ec2;

/**
 * Properties of an EC2 Instance.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // Creates a distribution from an EC2 instance
 * Vpc vpc;
 * // Create an EC2 instance in a VPC. 'subnetType' can be private.
 * Instance instance = Instance.Builder.create(this, "Instance")
 *         .vpc(vpc)
 *         .instanceType(InstanceType.of(InstanceClass.BURSTABLE3, InstanceSize.MICRO))
 *         .machineImage(MachineImage.latestAmazonLinux2023())
 *         .vpcSubnets(SubnetSelection.builder().subnetType(SubnetType.PRIVATE_WITH_EGRESS).build())
 *         .build();
 * Distribution.Builder.create(this, "myDist")
 *         .defaultBehavior(BehaviorOptions.builder().origin(VpcOrigin.withEc2Instance(instance)).build())
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.106.0 (build e852934)", date = "2025-02-21T03:20:32.129Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ec2.InstanceProps")
@software.amazon.jsii.Jsii.Proxy(InstanceProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface InstanceProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * Type of instance to launch.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.InstanceType getInstanceType();

    /**
     * AMI to launch.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.IMachineImage getMachineImage();

    /**
     * VPC to launch the instance in.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ec2.IVpc getVpc();

    /**
     * Whether the instance could initiate IPv6 connections to anywhere by default.
     * <p>
     * This property is only used when you do not provide a security group.
     * <p>
     * Default: false
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getAllowAllIpv6Outbound() {
        return null;
    }

    /**
     * Whether the instance could initiate connections to anywhere by default.
     * <p>
     * This property is only used when you do not provide a security group.
     * <p>
     * Default: true
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getAllowAllOutbound() {
        return null;
    }

    /**
     * Whether to associate a public IP address to the primary network interface attached to this instance.
     * <p>
     * You cannot specify this property and <code>ipv6AddressCount</code> at the same time.
     * <p>
     * Default: - public IP address is automatically assigned based on default behavior
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getAssociatePublicIpAddress() {
        return null;
    }

    /**
     * In which AZ to place the instance within the VPC.
     * <p>
     * Default: - Random zone.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getAvailabilityZone() {
        return null;
    }

    /**
     * Specifies how block devices are exposed to the instance. You can specify virtual devices and EBS volumes.
     * <p>
     * Each instance that is launched has an associated root device volume,
     * either an Amazon EBS volume or an instance store volume.
     * You can use block device mappings to specify additional EBS volumes or
     * instance store volumes to attach to an instance when it is launched.
     * <p>
     * Default: - Uses the block device mapping of the AMI
     * <p>
     * @see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/block-device-mapping-concepts.html">https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/block-device-mapping-concepts.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.services.ec2.BlockDevice> getBlockDevices() {
        return null;
    }

    /**
     * Specifying the CPU credit type for burstable EC2 instance types (T2, T3, T3a, etc).
     * <p>
     * The unlimited CPU credit option is not supported for T3 instances with a dedicated host.
     * <p>
     * Default: - T2 instances are standard, while T3, T4g, and T3a instances are unlimited.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.ec2.CpuCredits getCreditSpecification() {
        return null;
    }

    /**
     * Whether "Detailed Monitoring" is enabled for this instance Keep in mind that Detailed Monitoring results in extra charges.
     * <p>
     * Default: - false
     * <p>
     * @see <a href="http://aws.amazon.com/cloudwatch/pricing/">http://aws.amazon.com/cloudwatch/pricing/</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getDetailedMonitoring() {
        return null;
    }

    /**
     * If true, the instance will not be able to be terminated using the Amazon EC2 console, CLI, or API.
     * <p>
     * To change this attribute after launch, use <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_ModifyInstanceAttribute.html">ModifyInstanceAttribute</a>.
     * Alternatively, if you set InstanceInitiatedShutdownBehavior to terminate, you can terminate the instance
     * by running the shutdown command from the instance.
     * <p>
     * Default: false
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-instance.html#cfn-ec2-instance-disableapitermination">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ec2-instance.html#cfn-ec2-instance-disableapitermination</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getDisableApiTermination() {
        return null;
    }

    /**
     * Indicates whether the instance is optimized for Amazon EBS I/O.
     * <p>
     * This optimization provides dedicated throughput to Amazon EBS and an optimized configuration stack to provide optimal Amazon EBS I/O performance.
     * This optimization isn't available with all instance types.
     * Additional usage charges apply when using an EBS-optimized instance.
     * <p>
     * Default: false
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getEbsOptimized() {
        return null;
    }

    /**
     * Whether the instance is enabled for AWS Nitro Enclaves.
     * <p>
     * Nitro Enclaves requires a Nitro-based virtualized parent instance with specific Intel/AMD with at least 4 vCPUs
     * or Graviton with at least 2 vCPUs instance types and Linux/Windows host OS,
     * while the enclave itself supports only Linux OS.
     * <p>
     * You can't set both <code>enclaveEnabled</code> and <code>hibernationEnabled</code> to true on the same instance.
     * <p>
     * Default: - false
     * <p>
     * @see <a href="https://docs.aws.amazon.com/enclaves/latest/user/nitro-enclave.html#nitro-enclave-reqs">https://docs.aws.amazon.com/enclaves/latest/user/nitro-enclave.html#nitro-enclave-reqs</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getEnclaveEnabled() {
        return null;
    }

    /**
     * Whether the instance is enabled for hibernation.
     * <p>
     * You can't set both <code>enclaveEnabled</code> and <code>hibernationEnabled</code> to true on the same instance.
     * <p>
     * Default: - false
     * <p>
     * @see <a href="https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance-hibernationoptions.html">https://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-properties-ec2-instance-hibernationoptions.html</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getHibernationEnabled() {
        return null;
    }

    /**
     * Apply the given CloudFormation Init configuration to the instance at startup.
     * <p>
     * Default: - no CloudFormation init
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.ec2.CloudFormationInit getInit() {
        return null;
    }

    /**
     * Use the given options for applying CloudFormation Init.
     * <p>
     * Describes the configsets to use and the timeout to wait
     * <p>
     * Default: - default options
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.ec2.ApplyCloudFormationInitOptions getInitOptions() {
        return null;
    }

    /**
     * Indicates whether an instance stops or terminates when you initiate shutdown from the instance (using the operating system command for system shutdown).
     * <p>
     * Default: InstanceInitiatedShutdownBehavior.STOP
     * <p>
     * @see <a href="https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/terminating-instances.html#Using_ChangingInstanceInitiatedShutdownBehavior">https://docs.aws.amazon.com/AWSEC2/latest/UserGuide/terminating-instances.html#Using_ChangingInstanceInitiatedShutdownBehavior</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.ec2.InstanceInitiatedShutdownBehavior getInstanceInitiatedShutdownBehavior() {
        return null;
    }

    /**
     * The name of the instance.
     * <p>
     * Default: - CDK generated name
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getInstanceName() {
        return null;
    }

    /**
     * The instance profile used to pass role information to EC2 instances.
     * <p>
     * Note: You can provide an instanceProfile or a role, but not both.
     * <p>
     * Default: - No instance profile
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.iam.IInstanceProfile getInstanceProfile() {
        return null;
    }

    /**
     * The number of IPv6 addresses to associate with the primary network interface.
     * <p>
     * Amazon EC2 chooses the IPv6 addresses from the range of your subnet.
     * <p>
     * You cannot specify this property and <code>associatePublicIpAddress</code> at the same time.
     * <p>
     * Default: - For instances associated with an IPv6 subnet, use 1; otherwise, use 0.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Number getIpv6AddressCount() {
        return null;
    }

    /**
     * (deprecated) Name of SSH keypair to grant access to instance.
     * <p>
     * Default: - No SSH access will be possible.
     * <p>
     * @deprecated <ul>
     * <li>Use <code>keyPair</code> instead - https://docs.aws.amazon.com/cdk/api/v2/docs/aws-cdk-lib.aws_ec2-readme.html#using-an-existing-ec2-key-pair</li>
     * </ul>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
    @Deprecated
    default @org.jetbrains.annotations.Nullable java.lang.String getKeyName() {
        return null;
    }

    /**
     * The SSH keypair to grant access to the instance.
     * <p>
     * Default: - No SSH access will be possible.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.ec2.IKeyPair getKeyPair() {
        return null;
    }

    /**
     * The placement group that you want to launch the instance into.
     * <p>
     * Default: - no placement group will be used for this instance.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.ec2.IPlacementGroup getPlacementGroup() {
        return null;
    }

    /**
     * Defines a private IP address to associate with an instance.
     * <p>
     * Private IP should be available within the VPC that the instance is build within.
     * <p>
     * Default: - no association
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getPrivateIpAddress() {
        return null;
    }

    /**
     * Propagate the EC2 instance tags to the EBS volumes.
     * <p>
     * Default: - false
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getPropagateTagsToVolumeOnCreation() {
        return null;
    }

    /**
     * Whether IMDSv2 should be required on this instance.
     * <p>
     * Default: - false
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getRequireImdsv2() {
        return null;
    }

    /**
     * The length of time to wait for the resourceSignalCount.
     * <p>
     * The maximum value is 43200 (12 hours).
     * <p>
     * Default: Duration.minutes(5)
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.Duration getResourceSignalTimeout() {
        return null;
    }

    /**
     * An IAM role to associate with the instance profile assigned to this Auto Scaling Group.
     * <p>
     * The role must be assumable by the service principal <code>ec2.amazonaws.com</code>:
     * Note: You can provide an instanceProfile or a role, but not both.
     * <p>
     * Default: - A role will automatically be created, it can be accessed via the `role` property
     * <p>
     * Example:
     * <p>
     * <blockquote><pre>
     * Role role = Role.Builder.create(this, "MyRole")
     *         .assumedBy(new ServicePrincipal("ec2.amazonaws.com"))
     *         .build();
     * </pre></blockquote>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.iam.IRole getRole() {
        return null;
    }

    /**
     * Security Group to assign to this instance.
     * <p>
     * Default: - create new security group
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.ec2.ISecurityGroup getSecurityGroup() {
        return null;
    }

    /**
     * Specifies whether to enable an instance launched in a VPC to perform NAT.
     * <p>
     * This controls whether source/destination checking is enabled on the instance.
     * A value of true means that checking is enabled, and false means that checking is disabled.
     * The value must be false for the instance to perform NAT.
     * <p>
     * Default: true
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getSourceDestCheck() {
        return null;
    }

    /**
     * Add SSM session permissions to the instance role.
     * <p>
     * Setting this to <code>true</code> adds the necessary permissions to connect
     * to the instance using SSM Session Manager. You can do this
     * from the AWS Console.
     * <p>
     * NOTE: Setting this flag to <code>true</code> may not be enough by itself.
     * You must also use an AMI that comes with the SSM Agent, or install
     * the SSM Agent yourself. See
     * <a href="https://docs.aws.amazon.com/systems-manager/latest/userguide/ssm-agent.html">Working with SSM Agent</a>
     * in the SSM Developer Guide.
     * <p>
     * Default: false
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getSsmSessionPermissions() {
        return null;
    }

    /**
     * Specific UserData to use.
     * <p>
     * The UserData may still be mutated after creation.
     * <p>
     * Default: - A UserData object appropriate for the MachineImage's
     * Operating System is created.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.ec2.UserData getUserData() {
        return null;
    }

    /**
     * Changes to the UserData force replacement.
     * <p>
     * Depending the EC2 instance type, changing UserData either
     * restarts the instance or replaces the instance.
     * <p>
     * <ul>
     * <li>Instance store-backed instances are replaced.</li>
     * <li>EBS-backed instances are restarted.</li>
     * </ul>
     * <p>
     * By default, restarting does not execute the new UserData so you
     * will need a different mechanism to ensure the instance is restarted.
     * <p>
     * Setting this to <code>true</code> will make the instance's Logical ID depend on the
     * UserData, which will cause CloudFormation to replace it if the UserData
     * changes.
     * <p>
     * Default: - true if `initOptions` is specified, false otherwise.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Boolean getUserDataCausesReplacement() {
        return null;
    }

    /**
     * Where to place the instance within the VPC.
     * <p>
     * Default: - Private subnets.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.ec2.SubnetSelection getVpcSubnets() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link InstanceProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link InstanceProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<InstanceProps> {
        software.amazon.awscdk.services.ec2.InstanceType instanceType;
        software.amazon.awscdk.services.ec2.IMachineImage machineImage;
        software.amazon.awscdk.services.ec2.IVpc vpc;
        java.lang.Boolean allowAllIpv6Outbound;
        java.lang.Boolean allowAllOutbound;
        java.lang.Boolean associatePublicIpAddress;
        java.lang.String availabilityZone;
        java.util.List<software.amazon.awscdk.services.ec2.BlockDevice> blockDevices;
        software.amazon.awscdk.services.ec2.CpuCredits creditSpecification;
        java.lang.Boolean detailedMonitoring;
        java.lang.Boolean disableApiTermination;
        java.lang.Boolean ebsOptimized;
        java.lang.Boolean enclaveEnabled;
        java.lang.Boolean hibernationEnabled;
        software.amazon.awscdk.services.ec2.CloudFormationInit init;
        software.amazon.awscdk.services.ec2.ApplyCloudFormationInitOptions initOptions;
        software.amazon.awscdk.services.ec2.InstanceInitiatedShutdownBehavior instanceInitiatedShutdownBehavior;
        java.lang.String instanceName;
        software.amazon.awscdk.services.iam.IInstanceProfile instanceProfile;
        java.lang.Number ipv6AddressCount;
        java.lang.String keyName;
        software.amazon.awscdk.services.ec2.IKeyPair keyPair;
        software.amazon.awscdk.services.ec2.IPlacementGroup placementGroup;
        java.lang.String privateIpAddress;
        java.lang.Boolean propagateTagsToVolumeOnCreation;
        java.lang.Boolean requireImdsv2;
        software.amazon.awscdk.Duration resourceSignalTimeout;
        software.amazon.awscdk.services.iam.IRole role;
        software.amazon.awscdk.services.ec2.ISecurityGroup securityGroup;
        java.lang.Boolean sourceDestCheck;
        java.lang.Boolean ssmSessionPermissions;
        software.amazon.awscdk.services.ec2.UserData userData;
        java.lang.Boolean userDataCausesReplacement;
        software.amazon.awscdk.services.ec2.SubnetSelection vpcSubnets;

        /**
         * Sets the value of {@link InstanceProps#getInstanceType}
         * @param instanceType Type of instance to launch. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder instanceType(software.amazon.awscdk.services.ec2.InstanceType instanceType) {
            this.instanceType = instanceType;
            return this;
        }

        /**
         * Sets the value of {@link InstanceProps#getMachineImage}
         * @param machineImage AMI to launch. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder machineImage(software.amazon.awscdk.services.ec2.IMachineImage machineImage) {
            this.machineImage = machineImage;
            return this;
        }

        /**
         * Sets the value of {@link InstanceProps#getVpc}
         * @param vpc VPC to launch the instance in. This parameter is required.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder vpc(software.amazon.awscdk.services.ec2.IVpc vpc) {
            this.vpc = vpc;
            return this;
        }

        /**
         * Sets the value of {@link InstanceProps#getAllowAllIpv6Outbound}
         * @param allowAllIpv6Outbound Whether the instance could initiate IPv6 connections to anywhere by default.
         *                             This property is only used when you do not provide a security group.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder allowAllIpv6Outbound(java.lang.Boolean allowAllIpv6Outbound) {
            this.allowAllIpv6Outbound = allowAllIpv6Outbound;
            return this;
        }

        /**
         * Sets the value of {@link InstanceProps#getAllowAllOutbound}
         * @param allowAllOutbound Whether the instance could initiate connections to anywhere by default.
         *                         This property is only used when you do not provide a security group.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder allowAllOutbound(java.lang.Boolean allowAllOutbound) {
            this.allowAllOutbound = allowAllOutbound;
            return this;
        }

        /**
         * Sets the value of {@link InstanceProps#getAssociatePublicIpAddress}
         * @param associatePublicIpAddress Whether to associate a public IP address to the primary network interface attached to this instance.
         *                                 You cannot specify this property and <code>ipv6AddressCount</code> at the same time.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder associatePublicIpAddress(java.lang.Boolean associatePublicIpAddress) {
            this.associatePublicIpAddress = associatePublicIpAddress;
            return this;
        }

        /**
         * Sets the value of {@link InstanceProps#getAvailabilityZone}
         * @param availabilityZone In which AZ to place the instance within the VPC.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder availabilityZone(java.lang.String availabilityZone) {
            this.availabilityZone = availabilityZone;
            return this;
        }

        /**
         * Sets the value of {@link InstanceProps#getBlockDevices}
         * @param blockDevices Specifies how block devices are exposed to the instance. You can specify virtual devices and EBS volumes.
         *                     Each instance that is launched has an associated root device volume,
         *                     either an Amazon EBS volume or an instance store volume.
         *                     You can use block device mappings to specify additional EBS volumes or
         *                     instance store volumes to attach to an instance when it is launched.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder blockDevices(java.util.List<? extends software.amazon.awscdk.services.ec2.BlockDevice> blockDevices) {
            this.blockDevices = (java.util.List<software.amazon.awscdk.services.ec2.BlockDevice>)blockDevices;
            return this;
        }

        /**
         * Sets the value of {@link InstanceProps#getCreditSpecification}
         * @param creditSpecification Specifying the CPU credit type for burstable EC2 instance types (T2, T3, T3a, etc).
         *                            The unlimited CPU credit option is not supported for T3 instances with a dedicated host.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder creditSpecification(software.amazon.awscdk.services.ec2.CpuCredits creditSpecification) {
            this.creditSpecification = creditSpecification;
            return this;
        }

        /**
         * Sets the value of {@link InstanceProps#getDetailedMonitoring}
         * @param detailedMonitoring Whether "Detailed Monitoring" is enabled for this instance Keep in mind that Detailed Monitoring results in extra charges.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder detailedMonitoring(java.lang.Boolean detailedMonitoring) {
            this.detailedMonitoring = detailedMonitoring;
            return this;
        }

        /**
         * Sets the value of {@link InstanceProps#getDisableApiTermination}
         * @param disableApiTermination If true, the instance will not be able to be terminated using the Amazon EC2 console, CLI, or API.
         *                              To change this attribute after launch, use <a href="https://docs.aws.amazon.com/AWSEC2/latest/APIReference/API_ModifyInstanceAttribute.html">ModifyInstanceAttribute</a>.
         *                              Alternatively, if you set InstanceInitiatedShutdownBehavior to terminate, you can terminate the instance
         *                              by running the shutdown command from the instance.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder disableApiTermination(java.lang.Boolean disableApiTermination) {
            this.disableApiTermination = disableApiTermination;
            return this;
        }

        /**
         * Sets the value of {@link InstanceProps#getEbsOptimized}
         * @param ebsOptimized Indicates whether the instance is optimized for Amazon EBS I/O.
         *                     This optimization provides dedicated throughput to Amazon EBS and an optimized configuration stack to provide optimal Amazon EBS I/O performance.
         *                     This optimization isn't available with all instance types.
         *                     Additional usage charges apply when using an EBS-optimized instance.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder ebsOptimized(java.lang.Boolean ebsOptimized) {
            this.ebsOptimized = ebsOptimized;
            return this;
        }

        /**
         * Sets the value of {@link InstanceProps#getEnclaveEnabled}
         * @param enclaveEnabled Whether the instance is enabled for AWS Nitro Enclaves.
         *                       Nitro Enclaves requires a Nitro-based virtualized parent instance with specific Intel/AMD with at least 4 vCPUs
         *                       or Graviton with at least 2 vCPUs instance types and Linux/Windows host OS,
         *                       while the enclave itself supports only Linux OS.
         *                       <p>
         *                       You can't set both <code>enclaveEnabled</code> and <code>hibernationEnabled</code> to true on the same instance.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder enclaveEnabled(java.lang.Boolean enclaveEnabled) {
            this.enclaveEnabled = enclaveEnabled;
            return this;
        }

        /**
         * Sets the value of {@link InstanceProps#getHibernationEnabled}
         * @param hibernationEnabled Whether the instance is enabled for hibernation.
         *                           You can't set both <code>enclaveEnabled</code> and <code>hibernationEnabled</code> to true on the same instance.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder hibernationEnabled(java.lang.Boolean hibernationEnabled) {
            this.hibernationEnabled = hibernationEnabled;
            return this;
        }

        /**
         * Sets the value of {@link InstanceProps#getInit}
         * @param init Apply the given CloudFormation Init configuration to the instance at startup.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder init(software.amazon.awscdk.services.ec2.CloudFormationInit init) {
            this.init = init;
            return this;
        }

        /**
         * Sets the value of {@link InstanceProps#getInitOptions}
         * @param initOptions Use the given options for applying CloudFormation Init.
         *                    Describes the configsets to use and the timeout to wait
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder initOptions(software.amazon.awscdk.services.ec2.ApplyCloudFormationInitOptions initOptions) {
            this.initOptions = initOptions;
            return this;
        }

        /**
         * Sets the value of {@link InstanceProps#getInstanceInitiatedShutdownBehavior}
         * @param instanceInitiatedShutdownBehavior Indicates whether an instance stops or terminates when you initiate shutdown from the instance (using the operating system command for system shutdown).
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder instanceInitiatedShutdownBehavior(software.amazon.awscdk.services.ec2.InstanceInitiatedShutdownBehavior instanceInitiatedShutdownBehavior) {
            this.instanceInitiatedShutdownBehavior = instanceInitiatedShutdownBehavior;
            return this;
        }

        /**
         * Sets the value of {@link InstanceProps#getInstanceName}
         * @param instanceName The name of the instance.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder instanceName(java.lang.String instanceName) {
            this.instanceName = instanceName;
            return this;
        }

        /**
         * Sets the value of {@link InstanceProps#getInstanceProfile}
         * @param instanceProfile The instance profile used to pass role information to EC2 instances.
         *                        Note: You can provide an instanceProfile or a role, but not both.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder instanceProfile(software.amazon.awscdk.services.iam.IInstanceProfile instanceProfile) {
            this.instanceProfile = instanceProfile;
            return this;
        }

        /**
         * Sets the value of {@link InstanceProps#getIpv6AddressCount}
         * @param ipv6AddressCount The number of IPv6 addresses to associate with the primary network interface.
         *                         Amazon EC2 chooses the IPv6 addresses from the range of your subnet.
         *                         <p>
         *                         You cannot specify this property and <code>associatePublicIpAddress</code> at the same time.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder ipv6AddressCount(java.lang.Number ipv6AddressCount) {
            this.ipv6AddressCount = ipv6AddressCount;
            return this;
        }

        /**
         * Sets the value of {@link InstanceProps#getKeyName}
         * @param keyName Name of SSH keypair to grant access to instance.
         * @return {@code this}
         * @deprecated - Use `keyPair` instead - https://docs.aws.amazon.com/cdk/api/v2/docs/aws-cdk-lib.aws_ec2-readme.html#using-an-existing-ec2-key-pair
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Deprecated)
        @Deprecated
        public Builder keyName(java.lang.String keyName) {
            this.keyName = keyName;
            return this;
        }

        /**
         * Sets the value of {@link InstanceProps#getKeyPair}
         * @param keyPair The SSH keypair to grant access to the instance.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder keyPair(software.amazon.awscdk.services.ec2.IKeyPair keyPair) {
            this.keyPair = keyPair;
            return this;
        }

        /**
         * Sets the value of {@link InstanceProps#getPlacementGroup}
         * @param placementGroup The placement group that you want to launch the instance into.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder placementGroup(software.amazon.awscdk.services.ec2.IPlacementGroup placementGroup) {
            this.placementGroup = placementGroup;
            return this;
        }

        /**
         * Sets the value of {@link InstanceProps#getPrivateIpAddress}
         * @param privateIpAddress Defines a private IP address to associate with an instance.
         *                         Private IP should be available within the VPC that the instance is build within.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder privateIpAddress(java.lang.String privateIpAddress) {
            this.privateIpAddress = privateIpAddress;
            return this;
        }

        /**
         * Sets the value of {@link InstanceProps#getPropagateTagsToVolumeOnCreation}
         * @param propagateTagsToVolumeOnCreation Propagate the EC2 instance tags to the EBS volumes.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder propagateTagsToVolumeOnCreation(java.lang.Boolean propagateTagsToVolumeOnCreation) {
            this.propagateTagsToVolumeOnCreation = propagateTagsToVolumeOnCreation;
            return this;
        }

        /**
         * Sets the value of {@link InstanceProps#getRequireImdsv2}
         * @param requireImdsv2 Whether IMDSv2 should be required on this instance.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder requireImdsv2(java.lang.Boolean requireImdsv2) {
            this.requireImdsv2 = requireImdsv2;
            return this;
        }

        /**
         * Sets the value of {@link InstanceProps#getResourceSignalTimeout}
         * @param resourceSignalTimeout The length of time to wait for the resourceSignalCount.
         *                              The maximum value is 43200 (12 hours).
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder resourceSignalTimeout(software.amazon.awscdk.Duration resourceSignalTimeout) {
            this.resourceSignalTimeout = resourceSignalTimeout;
            return this;
        }

        /**
         * Sets the value of {@link InstanceProps#getRole}
         * @param role An IAM role to associate with the instance profile assigned to this Auto Scaling Group.
         *             The role must be assumable by the service principal <code>ec2.amazonaws.com</code>:
         *             Note: You can provide an instanceProfile or a role, but not both.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder role(software.amazon.awscdk.services.iam.IRole role) {
            this.role = role;
            return this;
        }

        /**
         * Sets the value of {@link InstanceProps#getSecurityGroup}
         * @param securityGroup Security Group to assign to this instance.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder securityGroup(software.amazon.awscdk.services.ec2.ISecurityGroup securityGroup) {
            this.securityGroup = securityGroup;
            return this;
        }

        /**
         * Sets the value of {@link InstanceProps#getSourceDestCheck}
         * @param sourceDestCheck Specifies whether to enable an instance launched in a VPC to perform NAT.
         *                        This controls whether source/destination checking is enabled on the instance.
         *                        A value of true means that checking is enabled, and false means that checking is disabled.
         *                        The value must be false for the instance to perform NAT.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder sourceDestCheck(java.lang.Boolean sourceDestCheck) {
            this.sourceDestCheck = sourceDestCheck;
            return this;
        }

        /**
         * Sets the value of {@link InstanceProps#getSsmSessionPermissions}
         * @param ssmSessionPermissions Add SSM session permissions to the instance role.
         *                              Setting this to <code>true</code> adds the necessary permissions to connect
         *                              to the instance using SSM Session Manager. You can do this
         *                              from the AWS Console.
         *                              <p>
         *                              NOTE: Setting this flag to <code>true</code> may not be enough by itself.
         *                              You must also use an AMI that comes with the SSM Agent, or install
         *                              the SSM Agent yourself. See
         *                              <a href="https://docs.aws.amazon.com/systems-manager/latest/userguide/ssm-agent.html">Working with SSM Agent</a>
         *                              in the SSM Developer Guide.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder ssmSessionPermissions(java.lang.Boolean ssmSessionPermissions) {
            this.ssmSessionPermissions = ssmSessionPermissions;
            return this;
        }

        /**
         * Sets the value of {@link InstanceProps#getUserData}
         * @param userData Specific UserData to use.
         *                 The UserData may still be mutated after creation.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder userData(software.amazon.awscdk.services.ec2.UserData userData) {
            this.userData = userData;
            return this;
        }

        /**
         * Sets the value of {@link InstanceProps#getUserDataCausesReplacement}
         * @param userDataCausesReplacement Changes to the UserData force replacement.
         *                                  Depending the EC2 instance type, changing UserData either
         *                                  restarts the instance or replaces the instance.
         *                                  <p>
         *                                  <ul>
         *                                  <li>Instance store-backed instances are replaced.</li>
         *                                  <li>EBS-backed instances are restarted.</li>
         *                                  </ul>
         *                                  <p>
         *                                  By default, restarting does not execute the new UserData so you
         *                                  will need a different mechanism to ensure the instance is restarted.
         *                                  <p>
         *                                  Setting this to <code>true</code> will make the instance's Logical ID depend on the
         *                                  UserData, which will cause CloudFormation to replace it if the UserData
         *                                  changes.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder userDataCausesReplacement(java.lang.Boolean userDataCausesReplacement) {
            this.userDataCausesReplacement = userDataCausesReplacement;
            return this;
        }

        /**
         * Sets the value of {@link InstanceProps#getVpcSubnets}
         * @param vpcSubnets Where to place the instance within the VPC.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder vpcSubnets(software.amazon.awscdk.services.ec2.SubnetSelection vpcSubnets) {
            this.vpcSubnets = vpcSubnets;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link InstanceProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public InstanceProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link InstanceProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements InstanceProps {
        private final software.amazon.awscdk.services.ec2.InstanceType instanceType;
        private final software.amazon.awscdk.services.ec2.IMachineImage machineImage;
        private final software.amazon.awscdk.services.ec2.IVpc vpc;
        private final java.lang.Boolean allowAllIpv6Outbound;
        private final java.lang.Boolean allowAllOutbound;
        private final java.lang.Boolean associatePublicIpAddress;
        private final java.lang.String availabilityZone;
        private final java.util.List<software.amazon.awscdk.services.ec2.BlockDevice> blockDevices;
        private final software.amazon.awscdk.services.ec2.CpuCredits creditSpecification;
        private final java.lang.Boolean detailedMonitoring;
        private final java.lang.Boolean disableApiTermination;
        private final java.lang.Boolean ebsOptimized;
        private final java.lang.Boolean enclaveEnabled;
        private final java.lang.Boolean hibernationEnabled;
        private final software.amazon.awscdk.services.ec2.CloudFormationInit init;
        private final software.amazon.awscdk.services.ec2.ApplyCloudFormationInitOptions initOptions;
        private final software.amazon.awscdk.services.ec2.InstanceInitiatedShutdownBehavior instanceInitiatedShutdownBehavior;
        private final java.lang.String instanceName;
        private final software.amazon.awscdk.services.iam.IInstanceProfile instanceProfile;
        private final java.lang.Number ipv6AddressCount;
        private final java.lang.String keyName;
        private final software.amazon.awscdk.services.ec2.IKeyPair keyPair;
        private final software.amazon.awscdk.services.ec2.IPlacementGroup placementGroup;
        private final java.lang.String privateIpAddress;
        private final java.lang.Boolean propagateTagsToVolumeOnCreation;
        private final java.lang.Boolean requireImdsv2;
        private final software.amazon.awscdk.Duration resourceSignalTimeout;
        private final software.amazon.awscdk.services.iam.IRole role;
        private final software.amazon.awscdk.services.ec2.ISecurityGroup securityGroup;
        private final java.lang.Boolean sourceDestCheck;
        private final java.lang.Boolean ssmSessionPermissions;
        private final software.amazon.awscdk.services.ec2.UserData userData;
        private final java.lang.Boolean userDataCausesReplacement;
        private final software.amazon.awscdk.services.ec2.SubnetSelection vpcSubnets;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.instanceType = software.amazon.jsii.Kernel.get(this, "instanceType", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.InstanceType.class));
            this.machineImage = software.amazon.jsii.Kernel.get(this, "machineImage", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.IMachineImage.class));
            this.vpc = software.amazon.jsii.Kernel.get(this, "vpc", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.IVpc.class));
            this.allowAllIpv6Outbound = software.amazon.jsii.Kernel.get(this, "allowAllIpv6Outbound", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.allowAllOutbound = software.amazon.jsii.Kernel.get(this, "allowAllOutbound", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.associatePublicIpAddress = software.amazon.jsii.Kernel.get(this, "associatePublicIpAddress", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.availabilityZone = software.amazon.jsii.Kernel.get(this, "availabilityZone", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.blockDevices = software.amazon.jsii.Kernel.get(this, "blockDevices", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.BlockDevice.class)));
            this.creditSpecification = software.amazon.jsii.Kernel.get(this, "creditSpecification", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.CpuCredits.class));
            this.detailedMonitoring = software.amazon.jsii.Kernel.get(this, "detailedMonitoring", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.disableApiTermination = software.amazon.jsii.Kernel.get(this, "disableApiTermination", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.ebsOptimized = software.amazon.jsii.Kernel.get(this, "ebsOptimized", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.enclaveEnabled = software.amazon.jsii.Kernel.get(this, "enclaveEnabled", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.hibernationEnabled = software.amazon.jsii.Kernel.get(this, "hibernationEnabled", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.init = software.amazon.jsii.Kernel.get(this, "init", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.CloudFormationInit.class));
            this.initOptions = software.amazon.jsii.Kernel.get(this, "initOptions", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.ApplyCloudFormationInitOptions.class));
            this.instanceInitiatedShutdownBehavior = software.amazon.jsii.Kernel.get(this, "instanceInitiatedShutdownBehavior", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.InstanceInitiatedShutdownBehavior.class));
            this.instanceName = software.amazon.jsii.Kernel.get(this, "instanceName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.instanceProfile = software.amazon.jsii.Kernel.get(this, "instanceProfile", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.IInstanceProfile.class));
            this.ipv6AddressCount = software.amazon.jsii.Kernel.get(this, "ipv6AddressCount", software.amazon.jsii.NativeType.forClass(java.lang.Number.class));
            this.keyName = software.amazon.jsii.Kernel.get(this, "keyName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.keyPair = software.amazon.jsii.Kernel.get(this, "keyPair", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.IKeyPair.class));
            this.placementGroup = software.amazon.jsii.Kernel.get(this, "placementGroup", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.IPlacementGroup.class));
            this.privateIpAddress = software.amazon.jsii.Kernel.get(this, "privateIpAddress", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.propagateTagsToVolumeOnCreation = software.amazon.jsii.Kernel.get(this, "propagateTagsToVolumeOnCreation", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.requireImdsv2 = software.amazon.jsii.Kernel.get(this, "requireImdsv2", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.resourceSignalTimeout = software.amazon.jsii.Kernel.get(this, "resourceSignalTimeout", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.Duration.class));
            this.role = software.amazon.jsii.Kernel.get(this, "role", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.iam.IRole.class));
            this.securityGroup = software.amazon.jsii.Kernel.get(this, "securityGroup", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.ISecurityGroup.class));
            this.sourceDestCheck = software.amazon.jsii.Kernel.get(this, "sourceDestCheck", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.ssmSessionPermissions = software.amazon.jsii.Kernel.get(this, "ssmSessionPermissions", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.userData = software.amazon.jsii.Kernel.get(this, "userData", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.UserData.class));
            this.userDataCausesReplacement = software.amazon.jsii.Kernel.get(this, "userDataCausesReplacement", software.amazon.jsii.NativeType.forClass(java.lang.Boolean.class));
            this.vpcSubnets = software.amazon.jsii.Kernel.get(this, "vpcSubnets", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ec2.SubnetSelection.class));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.instanceType = java.util.Objects.requireNonNull(builder.instanceType, "instanceType is required");
            this.machineImage = java.util.Objects.requireNonNull(builder.machineImage, "machineImage is required");
            this.vpc = java.util.Objects.requireNonNull(builder.vpc, "vpc is required");
            this.allowAllIpv6Outbound = builder.allowAllIpv6Outbound;
            this.allowAllOutbound = builder.allowAllOutbound;
            this.associatePublicIpAddress = builder.associatePublicIpAddress;
            this.availabilityZone = builder.availabilityZone;
            this.blockDevices = (java.util.List<software.amazon.awscdk.services.ec2.BlockDevice>)builder.blockDevices;
            this.creditSpecification = builder.creditSpecification;
            this.detailedMonitoring = builder.detailedMonitoring;
            this.disableApiTermination = builder.disableApiTermination;
            this.ebsOptimized = builder.ebsOptimized;
            this.enclaveEnabled = builder.enclaveEnabled;
            this.hibernationEnabled = builder.hibernationEnabled;
            this.init = builder.init;
            this.initOptions = builder.initOptions;
            this.instanceInitiatedShutdownBehavior = builder.instanceInitiatedShutdownBehavior;
            this.instanceName = builder.instanceName;
            this.instanceProfile = builder.instanceProfile;
            this.ipv6AddressCount = builder.ipv6AddressCount;
            this.keyName = builder.keyName;
            this.keyPair = builder.keyPair;
            this.placementGroup = builder.placementGroup;
            this.privateIpAddress = builder.privateIpAddress;
            this.propagateTagsToVolumeOnCreation = builder.propagateTagsToVolumeOnCreation;
            this.requireImdsv2 = builder.requireImdsv2;
            this.resourceSignalTimeout = builder.resourceSignalTimeout;
            this.role = builder.role;
            this.securityGroup = builder.securityGroup;
            this.sourceDestCheck = builder.sourceDestCheck;
            this.ssmSessionPermissions = builder.ssmSessionPermissions;
            this.userData = builder.userData;
            this.userDataCausesReplacement = builder.userDataCausesReplacement;
            this.vpcSubnets = builder.vpcSubnets;
        }

        @Override
        public final software.amazon.awscdk.services.ec2.InstanceType getInstanceType() {
            return this.instanceType;
        }

        @Override
        public final software.amazon.awscdk.services.ec2.IMachineImage getMachineImage() {
            return this.machineImage;
        }

        @Override
        public final software.amazon.awscdk.services.ec2.IVpc getVpc() {
            return this.vpc;
        }

        @Override
        public final java.lang.Boolean getAllowAllIpv6Outbound() {
            return this.allowAllIpv6Outbound;
        }

        @Override
        public final java.lang.Boolean getAllowAllOutbound() {
            return this.allowAllOutbound;
        }

        @Override
        public final java.lang.Boolean getAssociatePublicIpAddress() {
            return this.associatePublicIpAddress;
        }

        @Override
        public final java.lang.String getAvailabilityZone() {
            return this.availabilityZone;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.services.ec2.BlockDevice> getBlockDevices() {
            return this.blockDevices;
        }

        @Override
        public final software.amazon.awscdk.services.ec2.CpuCredits getCreditSpecification() {
            return this.creditSpecification;
        }

        @Override
        public final java.lang.Boolean getDetailedMonitoring() {
            return this.detailedMonitoring;
        }

        @Override
        public final java.lang.Boolean getDisableApiTermination() {
            return this.disableApiTermination;
        }

        @Override
        public final java.lang.Boolean getEbsOptimized() {
            return this.ebsOptimized;
        }

        @Override
        public final java.lang.Boolean getEnclaveEnabled() {
            return this.enclaveEnabled;
        }

        @Override
        public final java.lang.Boolean getHibernationEnabled() {
            return this.hibernationEnabled;
        }

        @Override
        public final software.amazon.awscdk.services.ec2.CloudFormationInit getInit() {
            return this.init;
        }

        @Override
        public final software.amazon.awscdk.services.ec2.ApplyCloudFormationInitOptions getInitOptions() {
            return this.initOptions;
        }

        @Override
        public final software.amazon.awscdk.services.ec2.InstanceInitiatedShutdownBehavior getInstanceInitiatedShutdownBehavior() {
            return this.instanceInitiatedShutdownBehavior;
        }

        @Override
        public final java.lang.String getInstanceName() {
            return this.instanceName;
        }

        @Override
        public final software.amazon.awscdk.services.iam.IInstanceProfile getInstanceProfile() {
            return this.instanceProfile;
        }

        @Override
        public final java.lang.Number getIpv6AddressCount() {
            return this.ipv6AddressCount;
        }

        @Override
        public final java.lang.String getKeyName() {
            return this.keyName;
        }

        @Override
        public final software.amazon.awscdk.services.ec2.IKeyPair getKeyPair() {
            return this.keyPair;
        }

        @Override
        public final software.amazon.awscdk.services.ec2.IPlacementGroup getPlacementGroup() {
            return this.placementGroup;
        }

        @Override
        public final java.lang.String getPrivateIpAddress() {
            return this.privateIpAddress;
        }

        @Override
        public final java.lang.Boolean getPropagateTagsToVolumeOnCreation() {
            return this.propagateTagsToVolumeOnCreation;
        }

        @Override
        public final java.lang.Boolean getRequireImdsv2() {
            return this.requireImdsv2;
        }

        @Override
        public final software.amazon.awscdk.Duration getResourceSignalTimeout() {
            return this.resourceSignalTimeout;
        }

        @Override
        public final software.amazon.awscdk.services.iam.IRole getRole() {
            return this.role;
        }

        @Override
        public final software.amazon.awscdk.services.ec2.ISecurityGroup getSecurityGroup() {
            return this.securityGroup;
        }

        @Override
        public final java.lang.Boolean getSourceDestCheck() {
            return this.sourceDestCheck;
        }

        @Override
        public final java.lang.Boolean getSsmSessionPermissions() {
            return this.ssmSessionPermissions;
        }

        @Override
        public final software.amazon.awscdk.services.ec2.UserData getUserData() {
            return this.userData;
        }

        @Override
        public final java.lang.Boolean getUserDataCausesReplacement() {
            return this.userDataCausesReplacement;
        }

        @Override
        public final software.amazon.awscdk.services.ec2.SubnetSelection getVpcSubnets() {
            return this.vpcSubnets;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            data.set("instanceType", om.valueToTree(this.getInstanceType()));
            data.set("machineImage", om.valueToTree(this.getMachineImage()));
            data.set("vpc", om.valueToTree(this.getVpc()));
            if (this.getAllowAllIpv6Outbound() != null) {
                data.set("allowAllIpv6Outbound", om.valueToTree(this.getAllowAllIpv6Outbound()));
            }
            if (this.getAllowAllOutbound() != null) {
                data.set("allowAllOutbound", om.valueToTree(this.getAllowAllOutbound()));
            }
            if (this.getAssociatePublicIpAddress() != null) {
                data.set("associatePublicIpAddress", om.valueToTree(this.getAssociatePublicIpAddress()));
            }
            if (this.getAvailabilityZone() != null) {
                data.set("availabilityZone", om.valueToTree(this.getAvailabilityZone()));
            }
            if (this.getBlockDevices() != null) {
                data.set("blockDevices", om.valueToTree(this.getBlockDevices()));
            }
            if (this.getCreditSpecification() != null) {
                data.set("creditSpecification", om.valueToTree(this.getCreditSpecification()));
            }
            if (this.getDetailedMonitoring() != null) {
                data.set("detailedMonitoring", om.valueToTree(this.getDetailedMonitoring()));
            }
            if (this.getDisableApiTermination() != null) {
                data.set("disableApiTermination", om.valueToTree(this.getDisableApiTermination()));
            }
            if (this.getEbsOptimized() != null) {
                data.set("ebsOptimized", om.valueToTree(this.getEbsOptimized()));
            }
            if (this.getEnclaveEnabled() != null) {
                data.set("enclaveEnabled", om.valueToTree(this.getEnclaveEnabled()));
            }
            if (this.getHibernationEnabled() != null) {
                data.set("hibernationEnabled", om.valueToTree(this.getHibernationEnabled()));
            }
            if (this.getInit() != null) {
                data.set("init", om.valueToTree(this.getInit()));
            }
            if (this.getInitOptions() != null) {
                data.set("initOptions", om.valueToTree(this.getInitOptions()));
            }
            if (this.getInstanceInitiatedShutdownBehavior() != null) {
                data.set("instanceInitiatedShutdownBehavior", om.valueToTree(this.getInstanceInitiatedShutdownBehavior()));
            }
            if (this.getInstanceName() != null) {
                data.set("instanceName", om.valueToTree(this.getInstanceName()));
            }
            if (this.getInstanceProfile() != null) {
                data.set("instanceProfile", om.valueToTree(this.getInstanceProfile()));
            }
            if (this.getIpv6AddressCount() != null) {
                data.set("ipv6AddressCount", om.valueToTree(this.getIpv6AddressCount()));
            }
            if (this.getKeyName() != null) {
                data.set("keyName", om.valueToTree(this.getKeyName()));
            }
            if (this.getKeyPair() != null) {
                data.set("keyPair", om.valueToTree(this.getKeyPair()));
            }
            if (this.getPlacementGroup() != null) {
                data.set("placementGroup", om.valueToTree(this.getPlacementGroup()));
            }
            if (this.getPrivateIpAddress() != null) {
                data.set("privateIpAddress", om.valueToTree(this.getPrivateIpAddress()));
            }
            if (this.getPropagateTagsToVolumeOnCreation() != null) {
                data.set("propagateTagsToVolumeOnCreation", om.valueToTree(this.getPropagateTagsToVolumeOnCreation()));
            }
            if (this.getRequireImdsv2() != null) {
                data.set("requireImdsv2", om.valueToTree(this.getRequireImdsv2()));
            }
            if (this.getResourceSignalTimeout() != null) {
                data.set("resourceSignalTimeout", om.valueToTree(this.getResourceSignalTimeout()));
            }
            if (this.getRole() != null) {
                data.set("role", om.valueToTree(this.getRole()));
            }
            if (this.getSecurityGroup() != null) {
                data.set("securityGroup", om.valueToTree(this.getSecurityGroup()));
            }
            if (this.getSourceDestCheck() != null) {
                data.set("sourceDestCheck", om.valueToTree(this.getSourceDestCheck()));
            }
            if (this.getSsmSessionPermissions() != null) {
                data.set("ssmSessionPermissions", om.valueToTree(this.getSsmSessionPermissions()));
            }
            if (this.getUserData() != null) {
                data.set("userData", om.valueToTree(this.getUserData()));
            }
            if (this.getUserDataCausesReplacement() != null) {
                data.set("userDataCausesReplacement", om.valueToTree(this.getUserDataCausesReplacement()));
            }
            if (this.getVpcSubnets() != null) {
                data.set("vpcSubnets", om.valueToTree(this.getVpcSubnets()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_ec2.InstanceProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            InstanceProps.Jsii$Proxy that = (InstanceProps.Jsii$Proxy) o;

            if (!instanceType.equals(that.instanceType)) return false;
            if (!machineImage.equals(that.machineImage)) return false;
            if (!vpc.equals(that.vpc)) return false;
            if (this.allowAllIpv6Outbound != null ? !this.allowAllIpv6Outbound.equals(that.allowAllIpv6Outbound) : that.allowAllIpv6Outbound != null) return false;
            if (this.allowAllOutbound != null ? !this.allowAllOutbound.equals(that.allowAllOutbound) : that.allowAllOutbound != null) return false;
            if (this.associatePublicIpAddress != null ? !this.associatePublicIpAddress.equals(that.associatePublicIpAddress) : that.associatePublicIpAddress != null) return false;
            if (this.availabilityZone != null ? !this.availabilityZone.equals(that.availabilityZone) : that.availabilityZone != null) return false;
            if (this.blockDevices != null ? !this.blockDevices.equals(that.blockDevices) : that.blockDevices != null) return false;
            if (this.creditSpecification != null ? !this.creditSpecification.equals(that.creditSpecification) : that.creditSpecification != null) return false;
            if (this.detailedMonitoring != null ? !this.detailedMonitoring.equals(that.detailedMonitoring) : that.detailedMonitoring != null) return false;
            if (this.disableApiTermination != null ? !this.disableApiTermination.equals(that.disableApiTermination) : that.disableApiTermination != null) return false;
            if (this.ebsOptimized != null ? !this.ebsOptimized.equals(that.ebsOptimized) : that.ebsOptimized != null) return false;
            if (this.enclaveEnabled != null ? !this.enclaveEnabled.equals(that.enclaveEnabled) : that.enclaveEnabled != null) return false;
            if (this.hibernationEnabled != null ? !this.hibernationEnabled.equals(that.hibernationEnabled) : that.hibernationEnabled != null) return false;
            if (this.init != null ? !this.init.equals(that.init) : that.init != null) return false;
            if (this.initOptions != null ? !this.initOptions.equals(that.initOptions) : that.initOptions != null) return false;
            if (this.instanceInitiatedShutdownBehavior != null ? !this.instanceInitiatedShutdownBehavior.equals(that.instanceInitiatedShutdownBehavior) : that.instanceInitiatedShutdownBehavior != null) return false;
            if (this.instanceName != null ? !this.instanceName.equals(that.instanceName) : that.instanceName != null) return false;
            if (this.instanceProfile != null ? !this.instanceProfile.equals(that.instanceProfile) : that.instanceProfile != null) return false;
            if (this.ipv6AddressCount != null ? !this.ipv6AddressCount.equals(that.ipv6AddressCount) : that.ipv6AddressCount != null) return false;
            if (this.keyName != null ? !this.keyName.equals(that.keyName) : that.keyName != null) return false;
            if (this.keyPair != null ? !this.keyPair.equals(that.keyPair) : that.keyPair != null) return false;
            if (this.placementGroup != null ? !this.placementGroup.equals(that.placementGroup) : that.placementGroup != null) return false;
            if (this.privateIpAddress != null ? !this.privateIpAddress.equals(that.privateIpAddress) : that.privateIpAddress != null) return false;
            if (this.propagateTagsToVolumeOnCreation != null ? !this.propagateTagsToVolumeOnCreation.equals(that.propagateTagsToVolumeOnCreation) : that.propagateTagsToVolumeOnCreation != null) return false;
            if (this.requireImdsv2 != null ? !this.requireImdsv2.equals(that.requireImdsv2) : that.requireImdsv2 != null) return false;
            if (this.resourceSignalTimeout != null ? !this.resourceSignalTimeout.equals(that.resourceSignalTimeout) : that.resourceSignalTimeout != null) return false;
            if (this.role != null ? !this.role.equals(that.role) : that.role != null) return false;
            if (this.securityGroup != null ? !this.securityGroup.equals(that.securityGroup) : that.securityGroup != null) return false;
            if (this.sourceDestCheck != null ? !this.sourceDestCheck.equals(that.sourceDestCheck) : that.sourceDestCheck != null) return false;
            if (this.ssmSessionPermissions != null ? !this.ssmSessionPermissions.equals(that.ssmSessionPermissions) : that.ssmSessionPermissions != null) return false;
            if (this.userData != null ? !this.userData.equals(that.userData) : that.userData != null) return false;
            if (this.userDataCausesReplacement != null ? !this.userDataCausesReplacement.equals(that.userDataCausesReplacement) : that.userDataCausesReplacement != null) return false;
            return this.vpcSubnets != null ? this.vpcSubnets.equals(that.vpcSubnets) : that.vpcSubnets == null;
        }

        @Override
        public final int hashCode() {
            int result = this.instanceType.hashCode();
            result = 31 * result + (this.machineImage.hashCode());
            result = 31 * result + (this.vpc.hashCode());
            result = 31 * result + (this.allowAllIpv6Outbound != null ? this.allowAllIpv6Outbound.hashCode() : 0);
            result = 31 * result + (this.allowAllOutbound != null ? this.allowAllOutbound.hashCode() : 0);
            result = 31 * result + (this.associatePublicIpAddress != null ? this.associatePublicIpAddress.hashCode() : 0);
            result = 31 * result + (this.availabilityZone != null ? this.availabilityZone.hashCode() : 0);
            result = 31 * result + (this.blockDevices != null ? this.blockDevices.hashCode() : 0);
            result = 31 * result + (this.creditSpecification != null ? this.creditSpecification.hashCode() : 0);
            result = 31 * result + (this.detailedMonitoring != null ? this.detailedMonitoring.hashCode() : 0);
            result = 31 * result + (this.disableApiTermination != null ? this.disableApiTermination.hashCode() : 0);
            result = 31 * result + (this.ebsOptimized != null ? this.ebsOptimized.hashCode() : 0);
            result = 31 * result + (this.enclaveEnabled != null ? this.enclaveEnabled.hashCode() : 0);
            result = 31 * result + (this.hibernationEnabled != null ? this.hibernationEnabled.hashCode() : 0);
            result = 31 * result + (this.init != null ? this.init.hashCode() : 0);
            result = 31 * result + (this.initOptions != null ? this.initOptions.hashCode() : 0);
            result = 31 * result + (this.instanceInitiatedShutdownBehavior != null ? this.instanceInitiatedShutdownBehavior.hashCode() : 0);
            result = 31 * result + (this.instanceName != null ? this.instanceName.hashCode() : 0);
            result = 31 * result + (this.instanceProfile != null ? this.instanceProfile.hashCode() : 0);
            result = 31 * result + (this.ipv6AddressCount != null ? this.ipv6AddressCount.hashCode() : 0);
            result = 31 * result + (this.keyName != null ? this.keyName.hashCode() : 0);
            result = 31 * result + (this.keyPair != null ? this.keyPair.hashCode() : 0);
            result = 31 * result + (this.placementGroup != null ? this.placementGroup.hashCode() : 0);
            result = 31 * result + (this.privateIpAddress != null ? this.privateIpAddress.hashCode() : 0);
            result = 31 * result + (this.propagateTagsToVolumeOnCreation != null ? this.propagateTagsToVolumeOnCreation.hashCode() : 0);
            result = 31 * result + (this.requireImdsv2 != null ? this.requireImdsv2.hashCode() : 0);
            result = 31 * result + (this.resourceSignalTimeout != null ? this.resourceSignalTimeout.hashCode() : 0);
            result = 31 * result + (this.role != null ? this.role.hashCode() : 0);
            result = 31 * result + (this.securityGroup != null ? this.securityGroup.hashCode() : 0);
            result = 31 * result + (this.sourceDestCheck != null ? this.sourceDestCheck.hashCode() : 0);
            result = 31 * result + (this.ssmSessionPermissions != null ? this.ssmSessionPermissions.hashCode() : 0);
            result = 31 * result + (this.userData != null ? this.userData.hashCode() : 0);
            result = 31 * result + (this.userDataCausesReplacement != null ? this.userDataCausesReplacement.hashCode() : 0);
            result = 31 * result + (this.vpcSubnets != null ? this.vpcSubnets.hashCode() : 0);
            return result;
        }
    }
}
