package software.amazon.awscdk.services.ecs;

/**
 * Properties for defining a <code>CfnCluster</code>.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.ecs.*;
 * CfnClusterProps cfnClusterProps = CfnClusterProps.builder()
 *         .capacityProviders(List.of("capacityProviders"))
 *         .clusterName("clusterName")
 *         .clusterSettings(List.of(ClusterSettingsProperty.builder()
 *                 .name("name")
 *                 .value("value")
 *                 .build()))
 *         .configuration(ClusterConfigurationProperty.builder()
 *                 .executeCommandConfiguration(ExecuteCommandConfigurationProperty.builder()
 *                         .kmsKeyId("kmsKeyId")
 *                         .logConfiguration(ExecuteCommandLogConfigurationProperty.builder()
 *                                 .cloudWatchEncryptionEnabled(false)
 *                                 .cloudWatchLogGroupName("cloudWatchLogGroupName")
 *                                 .s3BucketName("s3BucketName")
 *                                 .s3EncryptionEnabled(false)
 *                                 .s3KeyPrefix("s3KeyPrefix")
 *                                 .build())
 *                         .logging("logging")
 *                         .build())
 *                 .managedStorageConfiguration(ManagedStorageConfigurationProperty.builder()
 *                         .fargateEphemeralStorageKmsKeyId("fargateEphemeralStorageKmsKeyId")
 *                         .kmsKeyId("kmsKeyId")
 *                         .build())
 *                 .build())
 *         .defaultCapacityProviderStrategy(List.of(CapacityProviderStrategyItemProperty.builder()
 *                 .base(123)
 *                 .capacityProvider("capacityProvider")
 *                 .weight(123)
 *                 .build()))
 *         .serviceConnectDefaults(ServiceConnectDefaultsProperty.builder()
 *                 .namespace("namespace")
 *                 .build())
 *         .tags(List.of(CfnTag.builder()
 *                 .key("key")
 *                 .value("value")
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ecs-cluster.html">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ecs-cluster.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.106.0 (build e852934)", date = "2025-02-21T03:20:32.381Z")
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ecs.CfnClusterProps")
@software.amazon.jsii.Jsii.Proxy(CfnClusterProps.Jsii$Proxy.class)
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
public interface CfnClusterProps extends software.amazon.jsii.JsiiSerializable {

    /**
     * The short name of one or more capacity providers to associate with the cluster.
     * <p>
     * A capacity provider must be associated with a cluster before it can be included as part of the default capacity provider strategy of the cluster or used in a capacity provider strategy when calling the <a href="https://docs.aws.amazon.com/AmazonECS/latest/APIReference/API_CreateService.html">CreateService</a> or <a href="https://docs.aws.amazon.com/AmazonECS/latest/APIReference/API_RunTask.html">RunTask</a> actions.
     * <p>
     * If specifying a capacity provider that uses an Auto Scaling group, the capacity provider must be created but not associated with another cluster. New Auto Scaling group capacity providers can be created with the <a href="https://docs.aws.amazon.com/AmazonECS/latest/APIReference/API_CreateCapacityProvider.html">CreateCapacityProvider</a> API operation.
     * <p>
     * To use a AWS Fargate capacity provider, specify either the <code>FARGATE</code> or <code>FARGATE_SPOT</code> capacity providers. The AWS Fargate capacity providers are available to all accounts and only need to be associated with a cluster to be used.
     * <p>
     * The <a href="https://docs.aws.amazon.com/AmazonECS/latest/APIReference/API_PutCapacityProvider.html">PutCapacityProvider</a> API operation is used to update the list of available capacity providers for a cluster after the cluster is created.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ecs-cluster.html#cfn-ecs-cluster-capacityproviders">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ecs-cluster.html#cfn-ecs-cluster-capacityproviders</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<java.lang.String> getCapacityProviders() {
        return null;
    }

    /**
     * A user-generated string that you use to identify your cluster.
     * <p>
     * If you don't specify a name, AWS CloudFormation generates a unique physical ID for the name.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ecs-cluster.html#cfn-ecs-cluster-clustername">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ecs-cluster.html#cfn-ecs-cluster-clustername</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.String getClusterName() {
        return null;
    }

    /**
     * The settings to use when creating a cluster.
     * <p>
     * This parameter is used to turn on CloudWatch Container Insights with enhanced observability or CloudWatch Container Insights for a cluster.
     * <p>
     * Container Insights with enhanced observability provides all the Container Insights metrics, plus additional task and container metrics. This version supports enhanced observability for Amazon ECS clusters using the Amazon EC2 and Fargate launch types. After you configure Container Insights with enhanced observability on Amazon ECS, Container Insights auto-collects detailed infrastructure telemetry from the cluster level down to the container level in your environment and displays these critical performance data in curated dashboards removing the heavy lifting in observability set-up.
     * <p>
     * For more information, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/cloudwatch-container-insights.html">Monitor Amazon ECS containers using Container Insights with enhanced observability</a> in the <em>Amazon Elastic Container Service Developer Guide</em> .
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ecs-cluster.html#cfn-ecs-cluster-clustersettings">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ecs-cluster.html#cfn-ecs-cluster-clustersettings</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getClusterSettings() {
        return null;
    }

    /**
     * The execute command and managed storage configuration for the cluster.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ecs-cluster.html#cfn-ecs-cluster-configuration">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ecs-cluster.html#cfn-ecs-cluster-configuration</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getConfiguration() {
        return null;
    }

    /**
     * The default capacity provider strategy for the cluster.
     * <p>
     * When services or tasks are run in the cluster with no launch type or capacity provider strategy specified, the default capacity provider strategy is used.
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ecs-cluster.html#cfn-ecs-cluster-defaultcapacityproviderstrategy">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ecs-cluster.html#cfn-ecs-cluster-defaultcapacityproviderstrategy</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getDefaultCapacityProviderStrategy() {
        return null;
    }

    /**
     * Use this parameter to set a default Service Connect namespace.
     * <p>
     * After you set a default Service Connect namespace, any new services with Service Connect turned on that are created in the cluster are added as client services in the namespace. This setting only applies to new services that set the <code>enabled</code> parameter to <code>true</code> in the <code>ServiceConnectConfiguration</code> . You can set the namespace of each service individually in the <code>ServiceConnectConfiguration</code> to override this default parameter.
     * <p>
     * Tasks that run in a namespace can use short names to connect to services in the namespace. Tasks can connect to services across all of the clusters in the namespace. Tasks connect through a managed proxy container that collects logs and metrics for increased visibility. Only the tasks that Amazon ECS services create are supported with Service Connect. For more information, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/service-connect.html">Service Connect</a> in the <em>Amazon Elastic Container Service Developer Guide</em> .
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ecs-cluster.html#cfn-ecs-cluster-serviceconnectdefaults">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ecs-cluster.html#cfn-ecs-cluster-serviceconnectdefaults</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.lang.Object getServiceConnectDefaults() {
        return null;
    }

    /**
     * The metadata that you apply to the cluster to help you categorize and organize them.
     * <p>
     * Each tag consists of a key and an optional value. You define both.
     * <p>
     * The following basic restrictions apply to tags:
     * <p>
     * <ul>
     * <li>Maximum number of tags per resource - 50</li>
     * <li>For each resource, each tag key must be unique, and each tag key can have only one value.</li>
     * <li>Maximum key length - 128 Unicode characters in UTF-8</li>
     * <li>Maximum value length - 256 Unicode characters in UTF-8</li>
     * <li>If your tagging schema is used across multiple services and resources, remember that other services may have restrictions on allowed characters. Generally allowed characters are: letters, numbers, and spaces representable in UTF-8, and the following characters: + - = . _ : /</li>
     * </ul>
     * <p>
     * @see <a href="http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ecs-cluster.html#cfn-ecs-cluster-tags">http://docs.aws.amazon.com/AWSCloudFormation/latest/UserGuide/aws-resource-ecs-cluster.html#cfn-ecs-cluster-tags</a>
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    default @org.jetbrains.annotations.Nullable java.util.List<software.amazon.awscdk.CfnTag> getTags() {
        return null;
    }

    /**
     * @return a {@link Builder} of {@link CfnClusterProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    static Builder builder() {
        return new Builder();
    }
    /**
     * A builder for {@link CfnClusterProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<CfnClusterProps> {
        java.util.List<java.lang.String> capacityProviders;
        java.lang.String clusterName;
        java.lang.Object clusterSettings;
        java.lang.Object configuration;
        java.lang.Object defaultCapacityProviderStrategy;
        java.lang.Object serviceConnectDefaults;
        java.util.List<software.amazon.awscdk.CfnTag> tags;

        /**
         * Sets the value of {@link CfnClusterProps#getCapacityProviders}
         * @param capacityProviders The short name of one or more capacity providers to associate with the cluster.
         *                          A capacity provider must be associated with a cluster before it can be included as part of the default capacity provider strategy of the cluster or used in a capacity provider strategy when calling the <a href="https://docs.aws.amazon.com/AmazonECS/latest/APIReference/API_CreateService.html">CreateService</a> or <a href="https://docs.aws.amazon.com/AmazonECS/latest/APIReference/API_RunTask.html">RunTask</a> actions.
         *                          <p>
         *                          If specifying a capacity provider that uses an Auto Scaling group, the capacity provider must be created but not associated with another cluster. New Auto Scaling group capacity providers can be created with the <a href="https://docs.aws.amazon.com/AmazonECS/latest/APIReference/API_CreateCapacityProvider.html">CreateCapacityProvider</a> API operation.
         *                          <p>
         *                          To use a AWS Fargate capacity provider, specify either the <code>FARGATE</code> or <code>FARGATE_SPOT</code> capacity providers. The AWS Fargate capacity providers are available to all accounts and only need to be associated with a cluster to be used.
         *                          <p>
         *                          The <a href="https://docs.aws.amazon.com/AmazonECS/latest/APIReference/API_PutCapacityProvider.html">PutCapacityProvider</a> API operation is used to update the list of available capacity providers for a cluster after the cluster is created.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder capacityProviders(java.util.List<java.lang.String> capacityProviders) {
            this.capacityProviders = capacityProviders;
            return this;
        }

        /**
         * Sets the value of {@link CfnClusterProps#getClusterName}
         * @param clusterName A user-generated string that you use to identify your cluster.
         *                    If you don't specify a name, AWS CloudFormation generates a unique physical ID for the name.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder clusterName(java.lang.String clusterName) {
            this.clusterName = clusterName;
            return this;
        }

        /**
         * Sets the value of {@link CfnClusterProps#getClusterSettings}
         * @param clusterSettings The settings to use when creating a cluster.
         *                        This parameter is used to turn on CloudWatch Container Insights with enhanced observability or CloudWatch Container Insights for a cluster.
         *                        <p>
         *                        Container Insights with enhanced observability provides all the Container Insights metrics, plus additional task and container metrics. This version supports enhanced observability for Amazon ECS clusters using the Amazon EC2 and Fargate launch types. After you configure Container Insights with enhanced observability on Amazon ECS, Container Insights auto-collects detailed infrastructure telemetry from the cluster level down to the container level in your environment and displays these critical performance data in curated dashboards removing the heavy lifting in observability set-up.
         *                        <p>
         *                        For more information, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/cloudwatch-container-insights.html">Monitor Amazon ECS containers using Container Insights with enhanced observability</a> in the <em>Amazon Elastic Container Service Developer Guide</em> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder clusterSettings(software.amazon.awscdk.IResolvable clusterSettings) {
            this.clusterSettings = clusterSettings;
            return this;
        }

        /**
         * Sets the value of {@link CfnClusterProps#getClusterSettings}
         * @param clusterSettings The settings to use when creating a cluster.
         *                        This parameter is used to turn on CloudWatch Container Insights with enhanced observability or CloudWatch Container Insights for a cluster.
         *                        <p>
         *                        Container Insights with enhanced observability provides all the Container Insights metrics, plus additional task and container metrics. This version supports enhanced observability for Amazon ECS clusters using the Amazon EC2 and Fargate launch types. After you configure Container Insights with enhanced observability on Amazon ECS, Container Insights auto-collects detailed infrastructure telemetry from the cluster level down to the container level in your environment and displays these critical performance data in curated dashboards removing the heavy lifting in observability set-up.
         *                        <p>
         *                        For more information, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/cloudwatch-container-insights.html">Monitor Amazon ECS containers using Container Insights with enhanced observability</a> in the <em>Amazon Elastic Container Service Developer Guide</em> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder clusterSettings(java.util.List<? extends java.lang.Object> clusterSettings) {
            this.clusterSettings = clusterSettings;
            return this;
        }

        /**
         * Sets the value of {@link CfnClusterProps#getConfiguration}
         * @param configuration The execute command and managed storage configuration for the cluster.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder configuration(software.amazon.awscdk.IResolvable configuration) {
            this.configuration = configuration;
            return this;
        }

        /**
         * Sets the value of {@link CfnClusterProps#getConfiguration}
         * @param configuration The execute command and managed storage configuration for the cluster.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder configuration(software.amazon.awscdk.services.ecs.CfnCluster.ClusterConfigurationProperty configuration) {
            this.configuration = configuration;
            return this;
        }

        /**
         * Sets the value of {@link CfnClusterProps#getDefaultCapacityProviderStrategy}
         * @param defaultCapacityProviderStrategy The default capacity provider strategy for the cluster.
         *                                        When services or tasks are run in the cluster with no launch type or capacity provider strategy specified, the default capacity provider strategy is used.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder defaultCapacityProviderStrategy(software.amazon.awscdk.IResolvable defaultCapacityProviderStrategy) {
            this.defaultCapacityProviderStrategy = defaultCapacityProviderStrategy;
            return this;
        }

        /**
         * Sets the value of {@link CfnClusterProps#getDefaultCapacityProviderStrategy}
         * @param defaultCapacityProviderStrategy The default capacity provider strategy for the cluster.
         *                                        When services or tasks are run in the cluster with no launch type or capacity provider strategy specified, the default capacity provider strategy is used.
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder defaultCapacityProviderStrategy(java.util.List<? extends java.lang.Object> defaultCapacityProviderStrategy) {
            this.defaultCapacityProviderStrategy = defaultCapacityProviderStrategy;
            return this;
        }

        /**
         * Sets the value of {@link CfnClusterProps#getServiceConnectDefaults}
         * @param serviceConnectDefaults Use this parameter to set a default Service Connect namespace.
         *                               After you set a default Service Connect namespace, any new services with Service Connect turned on that are created in the cluster are added as client services in the namespace. This setting only applies to new services that set the <code>enabled</code> parameter to <code>true</code> in the <code>ServiceConnectConfiguration</code> . You can set the namespace of each service individually in the <code>ServiceConnectConfiguration</code> to override this default parameter.
         *                               <p>
         *                               Tasks that run in a namespace can use short names to connect to services in the namespace. Tasks can connect to services across all of the clusters in the namespace. Tasks connect through a managed proxy container that collects logs and metrics for increased visibility. Only the tasks that Amazon ECS services create are supported with Service Connect. For more information, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/service-connect.html">Service Connect</a> in the <em>Amazon Elastic Container Service Developer Guide</em> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder serviceConnectDefaults(software.amazon.awscdk.IResolvable serviceConnectDefaults) {
            this.serviceConnectDefaults = serviceConnectDefaults;
            return this;
        }

        /**
         * Sets the value of {@link CfnClusterProps#getServiceConnectDefaults}
         * @param serviceConnectDefaults Use this parameter to set a default Service Connect namespace.
         *                               After you set a default Service Connect namespace, any new services with Service Connect turned on that are created in the cluster are added as client services in the namespace. This setting only applies to new services that set the <code>enabled</code> parameter to <code>true</code> in the <code>ServiceConnectConfiguration</code> . You can set the namespace of each service individually in the <code>ServiceConnectConfiguration</code> to override this default parameter.
         *                               <p>
         *                               Tasks that run in a namespace can use short names to connect to services in the namespace. Tasks can connect to services across all of the clusters in the namespace. Tasks connect through a managed proxy container that collects logs and metrics for increased visibility. Only the tasks that Amazon ECS services create are supported with Service Connect. For more information, see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/service-connect.html">Service Connect</a> in the <em>Amazon Elastic Container Service Developer Guide</em> .
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder serviceConnectDefaults(software.amazon.awscdk.services.ecs.CfnCluster.ServiceConnectDefaultsProperty serviceConnectDefaults) {
            this.serviceConnectDefaults = serviceConnectDefaults;
            return this;
        }

        /**
         * Sets the value of {@link CfnClusterProps#getTags}
         * @param tags The metadata that you apply to the cluster to help you categorize and organize them.
         *             Each tag consists of a key and an optional value. You define both.
         *             <p>
         *             The following basic restrictions apply to tags:
         *             <p>
         *             <ul>
         *             <li>Maximum number of tags per resource - 50</li>
         *             <li>For each resource, each tag key must be unique, and each tag key can have only one value.</li>
         *             <li>Maximum key length - 128 Unicode characters in UTF-8</li>
         *             <li>Maximum value length - 256 Unicode characters in UTF-8</li>
         *             <li>If your tagging schema is used across multiple services and resources, remember that other services may have restrictions on allowed characters. Generally allowed characters are: letters, numbers, and spaces representable in UTF-8, and the following characters: + - = . _ : /</li>
         *             </ul>
         * @return {@code this}
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @SuppressWarnings("unchecked")
        public Builder tags(java.util.List<? extends software.amazon.awscdk.CfnTag> tags) {
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)tags;
            return this;
        }

        /**
         * Builds the configured instance.
         * @return a new instance of {@link CfnClusterProps}
         * @throws NullPointerException if any required attribute was not provided
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public CfnClusterProps build() {
            return new Jsii$Proxy(this);
        }
    }

    /**
     * An implementation for {@link CfnClusterProps}
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @software.amazon.jsii.Internal
    final class Jsii$Proxy extends software.amazon.jsii.JsiiObject implements CfnClusterProps {
        private final java.util.List<java.lang.String> capacityProviders;
        private final java.lang.String clusterName;
        private final java.lang.Object clusterSettings;
        private final java.lang.Object configuration;
        private final java.lang.Object defaultCapacityProviderStrategy;
        private final java.lang.Object serviceConnectDefaults;
        private final java.util.List<software.amazon.awscdk.CfnTag> tags;

        /**
         * Constructor that initializes the object based on values retrieved from the JsiiObject.
         * @param objRef Reference to the JSII managed object.
         */
        protected Jsii$Proxy(final software.amazon.jsii.JsiiObjectRef objRef) {
            super(objRef);
            this.capacityProviders = software.amazon.jsii.Kernel.get(this, "capacityProviders", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(java.lang.String.class)));
            this.clusterName = software.amazon.jsii.Kernel.get(this, "clusterName", software.amazon.jsii.NativeType.forClass(java.lang.String.class));
            this.clusterSettings = software.amazon.jsii.Kernel.get(this, "clusterSettings", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.configuration = software.amazon.jsii.Kernel.get(this, "configuration", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.defaultCapacityProviderStrategy = software.amazon.jsii.Kernel.get(this, "defaultCapacityProviderStrategy", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.serviceConnectDefaults = software.amazon.jsii.Kernel.get(this, "serviceConnectDefaults", software.amazon.jsii.NativeType.forClass(java.lang.Object.class));
            this.tags = software.amazon.jsii.Kernel.get(this, "tags", software.amazon.jsii.NativeType.listOf(software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.CfnTag.class)));
        }

        /**
         * Constructor that initializes the object based on literal property values passed by the {@link Builder}.
         */
        @SuppressWarnings("unchecked")
        protected Jsii$Proxy(final Builder builder) {
            super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
            this.capacityProviders = builder.capacityProviders;
            this.clusterName = builder.clusterName;
            this.clusterSettings = builder.clusterSettings;
            this.configuration = builder.configuration;
            this.defaultCapacityProviderStrategy = builder.defaultCapacityProviderStrategy;
            this.serviceConnectDefaults = builder.serviceConnectDefaults;
            this.tags = (java.util.List<software.amazon.awscdk.CfnTag>)builder.tags;
        }

        @Override
        public final java.util.List<java.lang.String> getCapacityProviders() {
            return this.capacityProviders;
        }

        @Override
        public final java.lang.String getClusterName() {
            return this.clusterName;
        }

        @Override
        public final java.lang.Object getClusterSettings() {
            return this.clusterSettings;
        }

        @Override
        public final java.lang.Object getConfiguration() {
            return this.configuration;
        }

        @Override
        public final java.lang.Object getDefaultCapacityProviderStrategy() {
            return this.defaultCapacityProviderStrategy;
        }

        @Override
        public final java.lang.Object getServiceConnectDefaults() {
            return this.serviceConnectDefaults;
        }

        @Override
        public final java.util.List<software.amazon.awscdk.CfnTag> getTags() {
            return this.tags;
        }

        @Override
        @software.amazon.jsii.Internal
        public com.fasterxml.jackson.databind.JsonNode $jsii$toJson() {
            final com.fasterxml.jackson.databind.ObjectMapper om = software.amazon.jsii.JsiiObjectMapper.INSTANCE;
            final com.fasterxml.jackson.databind.node.ObjectNode data = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();

            if (this.getCapacityProviders() != null) {
                data.set("capacityProviders", om.valueToTree(this.getCapacityProviders()));
            }
            if (this.getClusterName() != null) {
                data.set("clusterName", om.valueToTree(this.getClusterName()));
            }
            if (this.getClusterSettings() != null) {
                data.set("clusterSettings", om.valueToTree(this.getClusterSettings()));
            }
            if (this.getConfiguration() != null) {
                data.set("configuration", om.valueToTree(this.getConfiguration()));
            }
            if (this.getDefaultCapacityProviderStrategy() != null) {
                data.set("defaultCapacityProviderStrategy", om.valueToTree(this.getDefaultCapacityProviderStrategy()));
            }
            if (this.getServiceConnectDefaults() != null) {
                data.set("serviceConnectDefaults", om.valueToTree(this.getServiceConnectDefaults()));
            }
            if (this.getTags() != null) {
                data.set("tags", om.valueToTree(this.getTags()));
            }

            final com.fasterxml.jackson.databind.node.ObjectNode struct = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            struct.set("fqn", om.valueToTree("aws-cdk-lib.aws_ecs.CfnClusterProps"));
            struct.set("data", data);

            final com.fasterxml.jackson.databind.node.ObjectNode obj = com.fasterxml.jackson.databind.node.JsonNodeFactory.instance.objectNode();
            obj.set("$jsii.struct", struct);

            return obj;
        }

        @Override
        public final boolean equals(final Object o) {
            if (this == o) return true;
            if (o == null || getClass() != o.getClass()) return false;

            CfnClusterProps.Jsii$Proxy that = (CfnClusterProps.Jsii$Proxy) o;

            if (this.capacityProviders != null ? !this.capacityProviders.equals(that.capacityProviders) : that.capacityProviders != null) return false;
            if (this.clusterName != null ? !this.clusterName.equals(that.clusterName) : that.clusterName != null) return false;
            if (this.clusterSettings != null ? !this.clusterSettings.equals(that.clusterSettings) : that.clusterSettings != null) return false;
            if (this.configuration != null ? !this.configuration.equals(that.configuration) : that.configuration != null) return false;
            if (this.defaultCapacityProviderStrategy != null ? !this.defaultCapacityProviderStrategy.equals(that.defaultCapacityProviderStrategy) : that.defaultCapacityProviderStrategy != null) return false;
            if (this.serviceConnectDefaults != null ? !this.serviceConnectDefaults.equals(that.serviceConnectDefaults) : that.serviceConnectDefaults != null) return false;
            return this.tags != null ? this.tags.equals(that.tags) : that.tags == null;
        }

        @Override
        public final int hashCode() {
            int result = this.capacityProviders != null ? this.capacityProviders.hashCode() : 0;
            result = 31 * result + (this.clusterName != null ? this.clusterName.hashCode() : 0);
            result = 31 * result + (this.clusterSettings != null ? this.clusterSettings.hashCode() : 0);
            result = 31 * result + (this.configuration != null ? this.configuration.hashCode() : 0);
            result = 31 * result + (this.defaultCapacityProviderStrategy != null ? this.defaultCapacityProviderStrategy.hashCode() : 0);
            result = 31 * result + (this.serviceConnectDefaults != null ? this.serviceConnectDefaults.hashCode() : 0);
            result = 31 * result + (this.tags != null ? this.tags.hashCode() : 0);
            return result;
        }
    }
}
