package software.amazon.awscdk.services.ecs;

/**
 * The CloudWatch Container Insights setting.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * Cluster cluster = Cluster.Builder.create(this, "Cluster")
 *         .containerInsightsV2(ContainerInsights.ENHANCED)
 *         .build();
 * </pre></blockquote>
 * <p>
 * @see <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/cloudwatch-container-insights.html">https://docs.aws.amazon.com/AmazonECS/latest/developerguide/cloudwatch-container-insights.html</a>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.106.0 (build e852934)", date = "2025-02-21T03:20:32.508Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ecs.ContainerInsights")
public enum ContainerInsights {
    /**
     * Enable CloudWatch Container Insights for the cluster.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    ENABLED,
    /**
     * Disable CloudWatch Container Insights for the cluster.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    DISABLED,
    /**
     * Enable CloudWatch Container Insights with enhanced observability for the cluster.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    ENHANCED,
}
