package software.amazon.awscdk.services.ecs;

/**
 * The deployment controller type to use for the service.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * EcsApplication myApplication;
 * Cluster cluster;
 * FargateTaskDefinition taskDefinition;
 * ITargetGroup blueTargetGroup;
 * ITargetGroup greenTargetGroup;
 * IApplicationListener listener;
 * FargateService service = FargateService.Builder.create(this, "Service")
 *         .cluster(cluster)
 *         .taskDefinition(taskDefinition)
 *         .deploymentController(DeploymentController.builder()
 *                 .type(DeploymentControllerType.CODE_DEPLOY)
 *                 .build())
 *         .build();
 * EcsDeploymentGroup.Builder.create(this, "BlueGreenDG")
 *         .service(service)
 *         .blueGreenDeploymentConfig(EcsBlueGreenDeploymentConfig.builder()
 *                 .blueTargetGroup(blueTargetGroup)
 *                 .greenTargetGroup(greenTargetGroup)
 *                 .listener(listener)
 *                 .build())
 *         .deploymentConfig(EcsDeploymentConfig.CANARY_10PERCENT_5MINUTES)
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.106.0 (build e852934)", date = "2025-02-21T03:20:32.511Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ecs.DeploymentControllerType")
public enum DeploymentControllerType {
    /**
     * The rolling update (ECS) deployment type involves replacing the current running version of the container with the latest version.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    ECS,
    /**
     * The blue/green (CODE_DEPLOY) deployment type uses the blue/green deployment model powered by AWS CodeDeploy.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    CODE_DEPLOY,
    /**
     * The external (EXTERNAL) deployment type enables you to use any third-party deployment controller.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    EXTERNAL,
}
