package software.amazon.awscdk.services.ecs;

/**
 * A log driver that sends log information to journald Logs.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // The code below shows an example of how to instantiate this type.
 * // The values are placeholders you should change.
 * import software.amazon.awscdk.services.ecs.*;
 * JournaldLogDriver journaldLogDriver = JournaldLogDriver.Builder.create()
 *         .env(List.of("env"))
 *         .envRegex("envRegex")
 *         .labels(List.of("labels"))
 *         .tag("tag")
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.106.0 (build e852934)", date = "2025-02-21T03:20:32.582Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ecs.JournaldLogDriver")
public class JournaldLogDriver extends software.amazon.awscdk.services.ecs.LogDriver {

    protected JournaldLogDriver(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected JournaldLogDriver(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * Constructs a new instance of the JournaldLogDriver class.
     * <p>
     * @param props the journald log driver configuration options.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public JournaldLogDriver(final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.ecs.JournaldLogDriverProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { props });
    }

    /**
     * Constructs a new instance of the JournaldLogDriver class.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public JournaldLogDriver() {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this);
    }

    /**
     * Called when the log driver is configured on a container.
     * <p>
     * @param _scope This parameter is required.
     * @param _containerDefinition This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    @Override
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ecs.LogDriverConfig bind(final @org.jetbrains.annotations.NotNull software.constructs.Construct _scope, final @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ecs.ContainerDefinition _containerDefinition) {
        return software.amazon.jsii.Kernel.call(this, "bind", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ecs.LogDriverConfig.class), new Object[] { java.util.Objects.requireNonNull(_scope, "_scope is required"), java.util.Objects.requireNonNull(_containerDefinition, "_containerDefinition is required") });
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.ecs.JournaldLogDriver}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.ecs.JournaldLogDriver> {
        /**
         * @return a new instance of {@link Builder}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create() {
            return new Builder();
        }

        private software.amazon.awscdk.services.ecs.JournaldLogDriverProps.Builder props;

        private Builder() {
        }

        /**
         * The env option takes an array of keys.
         * <p>
         * If there is collision between
         * label and env keys, the value of the env takes precedence. Adds additional fields
         * to the extra attributes of a logging message.
         * <p>
         * Default: - No env
         * <p>
         * @return {@code this}
         * @param env The env option takes an array of keys. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder env(final java.util.List<java.lang.String> env) {
            this.props().env(env);
            return this;
        }

        /**
         * The env-regex option is similar to and compatible with env.
         * <p>
         * Its value is a regular
         * expression to match logging-related environment variables. It is used for advanced
         * log tag options.
         * <p>
         * Default: - No envRegex
         * <p>
         * @return {@code this}
         * @param envRegex The env-regex option is similar to and compatible with env. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder envRegex(final java.lang.String envRegex) {
            this.props().envRegex(envRegex);
            return this;
        }

        /**
         * The labels option takes an array of keys.
         * <p>
         * If there is collision
         * between label and env keys, the value of the env takes precedence. Adds additional
         * fields to the extra attributes of a logging message.
         * <p>
         * Default: - No labels
         * <p>
         * @return {@code this}
         * @param labels The labels option takes an array of keys. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder labels(final java.util.List<java.lang.String> labels) {
            this.props().labels(labels);
            return this;
        }

        /**
         * By default, Docker uses the first 12 characters of the container ID to tag log messages.
         * <p>
         * Refer to the log tag option documentation for customizing the
         * log tag format.
         * <p>
         * Default: - The first 12 characters of the container ID
         * <p>
         * @return {@code this}
         * @param tag By default, Docker uses the first 12 characters of the container ID to tag log messages. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder tag(final java.lang.String tag) {
            this.props().tag(tag);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.ecs.JournaldLogDriver}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.ecs.JournaldLogDriver build() {
            return new software.amazon.awscdk.services.ecs.JournaldLogDriver(
                this.props != null ? this.props.build() : null
            );
        }

        private software.amazon.awscdk.services.ecs.JournaldLogDriverProps.Builder props() {
            if (this.props == null) {
                this.props = new software.amazon.awscdk.services.ecs.JournaldLogDriverProps.Builder();
            }
            return this.props;
        }
    }
}
