package software.amazon.awscdk.services.ecs.patterns;

/**
 * Class to create a queue processing Fargate service.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * Cluster cluster;
 * cluster.enableFargateCapacityProviders();
 * QueueProcessingFargateService queueProcessingFargateService = QueueProcessingFargateService.Builder.create(this, "Service")
 *         .cluster(cluster)
 *         .memoryLimitMiB(512)
 *         .image(ContainerImage.fromRegistry("test"))
 *         .minHealthyPercent(100)
 *         .capacityProviderStrategies(List.of(CapacityProviderStrategy.builder()
 *                 .capacityProvider("FARGATE_SPOT")
 *                 .weight(2)
 *                 .build(), CapacityProviderStrategy.builder()
 *                 .capacityProvider("FARGATE")
 *                 .weight(1)
 *                 .build()))
 *         .build();
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.106.0 (build e852934)", date = "2025-02-21T03:20:32.728Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_ecs_patterns.QueueProcessingFargateService")
public class QueueProcessingFargateService extends software.amazon.awscdk.services.ecs.patterns.QueueProcessingServiceBase {

    protected QueueProcessingFargateService(final software.amazon.jsii.JsiiObjectRef objRef) {
        super(objRef);
    }

    protected QueueProcessingFargateService(final software.amazon.jsii.JsiiObject.InitializationMode initializationMode) {
        super(initializationMode);
    }

    /**
     * Constructs a new instance of the QueueProcessingFargateService class.
     * <p>
     * @param scope This parameter is required.
     * @param id This parameter is required.
     * @param props
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public QueueProcessingFargateService(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id, final @org.jetbrains.annotations.Nullable software.amazon.awscdk.services.ecs.patterns.QueueProcessingFargateServiceProps props) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required"), props });
    }

    /**
     * Constructs a new instance of the QueueProcessingFargateService class.
     * <p>
     * @param scope This parameter is required.
     * @param id This parameter is required.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public QueueProcessingFargateService(final @org.jetbrains.annotations.NotNull software.constructs.Construct scope, final @org.jetbrains.annotations.NotNull java.lang.String id) {
        super(software.amazon.jsii.JsiiObject.InitializationMode.JSII);
        software.amazon.jsii.JsiiEngine.getInstance().createNewObject(this, new Object[] { java.util.Objects.requireNonNull(scope, "scope is required"), java.util.Objects.requireNonNull(id, "id is required") });
    }

    /**
     * The Fargate service in this construct.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ecs.FargateService getService() {
        return software.amazon.jsii.Kernel.get(this, "service", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ecs.FargateService.class));
    }

    /**
     * The Fargate task definition in this construct.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public @org.jetbrains.annotations.NotNull software.amazon.awscdk.services.ecs.FargateTaskDefinition getTaskDefinition() {
        return software.amazon.jsii.Kernel.get(this, "taskDefinition", software.amazon.jsii.NativeType.forClass(software.amazon.awscdk.services.ecs.FargateTaskDefinition.class));
    }

    /**
     * A fluent builder for {@link software.amazon.awscdk.services.ecs.patterns.QueueProcessingFargateService}.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    public static final class Builder implements software.amazon.jsii.Builder<software.amazon.awscdk.services.ecs.patterns.QueueProcessingFargateService> {
        /**
         * @return a new instance of {@link Builder}.
         * @param scope This parameter is required.
         * @param id This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public static Builder create(final software.constructs.Construct scope, final java.lang.String id) {
            return new Builder(scope, id);
        }

        private final software.constructs.Construct scope;
        private final java.lang.String id;
        private software.amazon.awscdk.services.ecs.patterns.QueueProcessingFargateServiceProps.Builder props;

        private Builder(final software.constructs.Construct scope, final java.lang.String id) {
            this.scope = scope;
            this.id = id;
        }

        /**
         * A list of Capacity Provider strategies used to place a service.
         * <p>
         * Default: - undefined
         * <p>
         * @return {@code this}
         * @param capacityProviderStrategies A list of Capacity Provider strategies used to place a service. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder capacityProviderStrategies(final java.util.List<? extends software.amazon.awscdk.services.ecs.CapacityProviderStrategy> capacityProviderStrategies) {
            this.props().capacityProviderStrategies(capacityProviderStrategies);
            return this;
        }

        /**
         * Whether to enable the deployment circuit breaker.
         * <p>
         * If this property is defined, circuit breaker will be implicitly
         * enabled.
         * <p>
         * Default: - disabled
         * <p>
         * @return {@code this}
         * @param circuitBreaker Whether to enable the deployment circuit breaker. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder circuitBreaker(final software.amazon.awscdk.services.ecs.DeploymentCircuitBreaker circuitBreaker) {
            this.props().circuitBreaker(circuitBreaker);
            return this;
        }

        /**
         * The name of the cluster that hosts the service.
         * <p>
         * If a cluster is specified, the vpc construct should be omitted. Alternatively, you can omit both cluster and vpc.
         * <p>
         * Default: - create a new cluster; if both cluster and vpc are omitted, a new VPC will be created for you.
         * <p>
         * @return {@code this}
         * @param cluster The name of the cluster that hosts the service. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder cluster(final software.amazon.awscdk.services.ecs.ICluster cluster) {
            this.props().cluster(cluster);
            return this;
        }

        /**
         * The command that is passed to the container.
         * <p>
         * If you provide a shell command as a single string, you have to quote command-line arguments.
         * <p>
         * Default: - CMD value built into container image.
         * <p>
         * @return {@code this}
         * @param command The command that is passed to the container. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder command(final java.util.List<java.lang.String> command) {
            this.props().command(command);
            return this;
        }

        /**
         * Grace period after scaling activity in seconds.
         * <p>
         * Subsequent scale outs during the cooldown period are squashed so that only
         * the biggest scale out happens.
         * <p>
         * Subsequent scale ins during the cooldown period are ignored.
         * <p>
         * Default: 300 seconds
         * <p>
         * @return {@code this}
         * @see <a href="https://docs.aws.amazon.com/autoscaling/application/APIReference/API_StepScalingPolicyConfiguration.html">https://docs.aws.amazon.com/autoscaling/application/APIReference/API_StepScalingPolicyConfiguration.html</a>
         * @param cooldown Grace period after scaling activity in seconds. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder cooldown(final software.amazon.awscdk.Duration cooldown) {
            this.props().cooldown(cooldown);
            return this;
        }

        /**
         * The target CPU utilization percentage for CPU based scaling strategy when enabled.
         * <p>
         * Default: - 50
         * <p>
         * @return {@code this}
         * @param cpuTargetUtilizationPercent The target CPU utilization percentage for CPU based scaling strategy when enabled. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder cpuTargetUtilizationPercent(final java.lang.Number cpuTargetUtilizationPercent) {
            this.props().cpuTargetUtilizationPercent(cpuTargetUtilizationPercent);
            return this;
        }

        /**
         * Specifies which deployment controller to use for the service.
         * <p>
         * For more information, see
         * <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/deployment-types.html">Amazon ECS Deployment Types</a>
         * <p>
         * Default: - Rolling update (ECS)
         * <p>
         * @return {@code this}
         * @param deploymentController Specifies which deployment controller to use for the service. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder deploymentController(final software.amazon.awscdk.services.ecs.DeploymentController deploymentController) {
            this.props().deploymentController(deploymentController);
            return this;
        }

        /**
         * Flag to disable CPU based auto scaling strategy on the service.
         * <p>
         * Default: - false
         * <p>
         * @return {@code this}
         * @param disableCpuBasedScaling Flag to disable CPU based auto scaling strategy on the service. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder disableCpuBasedScaling(final java.lang.Boolean disableCpuBasedScaling) {
            this.props().disableCpuBasedScaling(disableCpuBasedScaling);
            return this;
        }

        /**
         * Specifies whether to enable Amazon ECS managed tags for the tasks within the service.
         * <p>
         * For more information, see
         * <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/ecs-using-tags.html">Tagging Your Amazon ECS Resources</a>
         * <p>
         * Default: false
         * <p>
         * @return {@code this}
         * @param enableEcsManagedTags Specifies whether to enable Amazon ECS managed tags for the tasks within the service. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder enableEcsManagedTags(final java.lang.Boolean enableEcsManagedTags) {
            this.props().enableEcsManagedTags(enableEcsManagedTags);
            return this;
        }

        /**
         * Whether ECS Exec should be enabled.
         * <p>
         * Default: - false
         * <p>
         * @return {@code this}
         * @param enableExecuteCommand Whether ECS Exec should be enabled. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder enableExecuteCommand(final java.lang.Boolean enableExecuteCommand) {
            this.props().enableExecuteCommand(enableExecuteCommand);
            return this;
        }

        /**
         * Flag to indicate whether to enable logging.
         * <p>
         * Default: true
         * <p>
         * @return {@code this}
         * @param enableLogging Flag to indicate whether to enable logging. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder enableLogging(final java.lang.Boolean enableLogging) {
            this.props().enableLogging(enableLogging);
            return this;
        }

        /**
         * The environment variables to pass to the container.
         * <p>
         * The variable <code>QUEUE_NAME</code> with value <code>queue.queueName</code> will
         * always be passed.
         * <p>
         * Default: 'QUEUE_NAME: queue.queueName'
         * <p>
         * @return {@code this}
         * @param environment The environment variables to pass to the container. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder environment(final java.util.Map<java.lang.String, java.lang.String> environment) {
            this.props().environment(environment);
            return this;
        }

        /**
         * The name of a family that the task definition is registered to.
         * <p>
         * A family groups multiple versions of a task definition.
         * <p>
         * Default: - Automatically generated name.
         * <p>
         * @return {@code this}
         * @param family The name of a family that the task definition is registered to. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder family(final java.lang.String family) {
            this.props().family(family);
            return this;
        }

        /**
         * The image used to start a container.
         * <p>
         * For <code>QueueProcessingFargateService</code>, either <code>image</code> or <code>taskDefinition</code> must be specified, but not both.
         * For <code>QueueProcessingEc2Service</code>, <code>image</code> is required.
         * <p>
         * Default: - the image of the task definition is used for Fargate, required otherwise
         * <p>
         * @return {@code this}
         * @param image The image used to start a container. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder image(final software.amazon.awscdk.services.ecs.ContainerImage image) {
            this.props().image(image);
            return this;
        }

        /**
         * The log driver to use.
         * <p>
         * Default: - AwsLogDriver if enableLogging is true
         * <p>
         * @return {@code this}
         * @param logDriver The log driver to use. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder logDriver(final software.amazon.awscdk.services.ecs.LogDriver logDriver) {
            this.props().logDriver(logDriver);
            return this;
        }

        /**
         * The maximum number of tasks, specified as a percentage of the Amazon ECS service's DesiredCount value, that can run in a service during a deployment.
         * <p>
         * Default: - default from underlying service.
         * <p>
         * @return {@code this}
         * @param maxHealthyPercent The maximum number of tasks, specified as a percentage of the Amazon ECS service's DesiredCount value, that can run in a service during a deployment. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder maxHealthyPercent(final java.lang.Number maxHealthyPercent) {
            this.props().maxHealthyPercent(maxHealthyPercent);
            return this;
        }

        /**
         * The maximum number of times that a message can be received by consumers.
         * <p>
         * When this value is exceeded for a message the message will be automatically sent to the Dead Letter Queue.
         * <p>
         * If the queue construct is specified, maxReceiveCount should be omitted.
         * <p>
         * Default: 3
         * <p>
         * @return {@code this}
         * @param maxReceiveCount The maximum number of times that a message can be received by consumers. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder maxReceiveCount(final java.lang.Number maxReceiveCount) {
            this.props().maxReceiveCount(maxReceiveCount);
            return this;
        }

        /**
         * Maximum capacity to scale to.
         * <p>
         * Default: 2
         * <p>
         * @return {@code this}
         * @param maxScalingCapacity Maximum capacity to scale to. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder maxScalingCapacity(final java.lang.Number maxScalingCapacity) {
            this.props().maxScalingCapacity(maxScalingCapacity);
            return this;
        }

        /**
         * The minimum number of tasks, specified as a percentage of the Amazon ECS service's DesiredCount value, that must continue to run and remain healthy during a deployment.
         * <p>
         * Default: - default from underlying service.
         * <p>
         * @return {@code this}
         * @param minHealthyPercent The minimum number of tasks, specified as a percentage of the Amazon ECS service's DesiredCount value, that must continue to run and remain healthy during a deployment. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder minHealthyPercent(final java.lang.Number minHealthyPercent) {
            this.props().minHealthyPercent(minHealthyPercent);
            return this;
        }

        /**
         * Minimum capacity to scale to.
         * <p>
         * Default: 1
         * <p>
         * @return {@code this}
         * @param minScalingCapacity Minimum capacity to scale to. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder minScalingCapacity(final java.lang.Number minScalingCapacity) {
            this.props().minScalingCapacity(minScalingCapacity);
            return this;
        }

        /**
         * Specifies whether to propagate the tags from the task definition or the service to the tasks in the service.
         * <p>
         * Tags can only be propagated to the tasks within the service during service creation.
         * <p>
         * Default: - none
         * <p>
         * @return {@code this}
         * @param propagateTags Specifies whether to propagate the tags from the task definition or the service to the tasks in the service. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder propagateTags(final software.amazon.awscdk.services.ecs.PropagatedTagSource propagateTags) {
            this.props().propagateTags(propagateTags);
            return this;
        }

        /**
         * A queue for which to process items from.
         * <p>
         * If specified and this is a FIFO queue, the queue name must end in the string '.fifo'. See
         * <a href="https://docs.aws.amazon.com/AWSSimpleQueueService/latest/APIReference/API_CreateQueue.html">CreateQueue</a>
         * <p>
         * Default: 'SQSQueue with CloudFormation-generated name'
         * <p>
         * @return {@code this}
         * @param queue A queue for which to process items from. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder queue(final software.amazon.awscdk.services.sqs.IQueue queue) {
            this.props().queue(queue);
            return this;
        }

        /**
         * The number of seconds that Dead Letter Queue retains a message.
         * <p>
         * If the queue construct is specified, retentionPeriod should be omitted.
         * <p>
         * Default: Duration.days(14)
         * <p>
         * @return {@code this}
         * @param retentionPeriod The number of seconds that Dead Letter Queue retains a message. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder retentionPeriod(final software.amazon.awscdk.Duration retentionPeriod) {
            this.props().retentionPeriod(retentionPeriod);
            return this;
        }

        /**
         * The intervals for scaling based on the SQS queue's ApproximateNumberOfMessagesVisible metric.
         * <p>
         * Maps a range of metric values to a particular scaling behavior. See
         * <a href="https://docs.aws.amazon.com/autoscaling/ec2/userguide/as-scaling-simple-step.html">Simple and Step Scaling Policies for Amazon EC2 Auto Scaling</a>
         * <p>
         * Default: [{ upper: 0, change: -1 },{ lower: 100, change: +1 },{ lower: 500, change: +5 }]
         * <p>
         * @return {@code this}
         * @param scalingSteps The intervals for scaling based on the SQS queue's ApproximateNumberOfMessagesVisible metric. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder scalingSteps(final java.util.List<? extends software.amazon.awscdk.services.applicationautoscaling.ScalingInterval> scalingSteps) {
            this.props().scalingSteps(scalingSteps);
            return this;
        }

        /**
         * The secret to expose to the container as an environment variable.
         * <p>
         * Default: - No secret environment variables.
         * <p>
         * @return {@code this}
         * @param secrets The secret to expose to the container as an environment variable. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder secrets(final java.util.Map<java.lang.String, ? extends software.amazon.awscdk.services.ecs.Secret> secrets) {
            this.props().secrets(secrets);
            return this;
        }

        /**
         * The name of the service.
         * <p>
         * Default: - CloudFormation-generated name.
         * <p>
         * @return {@code this}
         * @param serviceName The name of the service. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder serviceName(final java.lang.String serviceName) {
            this.props().serviceName(serviceName);
            return this;
        }

        /**
         * Timeout of processing a single message.
         * <p>
         * After dequeuing, the processor has this much time to handle the message and delete it from the queue
         * before it becomes visible again for dequeueing by another processor. Values must be between 0 and (12 hours).
         * <p>
         * If the queue construct is specified, visibilityTimeout should be omitted.
         * <p>
         * Default: Duration.seconds(30)
         * <p>
         * @return {@code this}
         * @param visibilityTimeout Timeout of processing a single message. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder visibilityTimeout(final software.amazon.awscdk.Duration visibilityTimeout) {
            this.props().visibilityTimeout(visibilityTimeout);
            return this;
        }

        /**
         * The VPC where the container instances will be launched or the elastic network interfaces (ENIs) will be deployed.
         * <p>
         * If a vpc is specified, the cluster construct should be omitted. Alternatively, you can omit both vpc and cluster.
         * <p>
         * Default: - uses the VPC defined in the cluster or creates a new VPC.
         * <p>
         * @return {@code this}
         * @param vpc The VPC where the container instances will be launched or the elastic network interfaces (ENIs) will be deployed. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder vpc(final software.amazon.awscdk.services.ec2.IVpc vpc) {
            this.props().vpc(vpc);
            return this;
        }

        /**
         * The number of cpu units used by the task.
         * <p>
         * Valid values, which determines your range of valid values for the memory parameter:
         * <p>
         * 256 (.25 vCPU) - Available memory values: 0.5GB, 1GB, 2GB
         * <p>
         * 512 (.5 vCPU) - Available memory values: 1GB, 2GB, 3GB, 4GB
         * <p>
         * 1024 (1 vCPU) - Available memory values: 2GB, 3GB, 4GB, 5GB, 6GB, 7GB, 8GB
         * <p>
         * 2048 (2 vCPU) - Available memory values: Between 4GB and 16GB in 1GB increments
         * <p>
         * 4096 (4 vCPU) - Available memory values: Between 8GB and 30GB in 1GB increments
         * <p>
         * 8192 (8 vCPU) - Available memory values: Between 16GB and 60GB in 4GB increments
         * <p>
         * 16384 (16 vCPU) - Available memory values: Between 32GB and 120GB in 8GB increments
         * <p>
         * This default is set in the underlying FargateTaskDefinition construct.
         * <p>
         * Default: 256
         * <p>
         * @return {@code this}
         * @param cpu The number of cpu units used by the task. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder cpu(final java.lang.Number cpu) {
            this.props().cpu(cpu);
            return this;
        }

        /**
         * The amount (in GiB) of ephemeral storage to be allocated to the task.
         * <p>
         * The minimum supported value is <code>21</code> GiB and the maximum supported value is <code>200</code> GiB.
         * <p>
         * Only supported in Fargate platform version 1.4.0 or later.
         * <p>
         * Default: Undefined, in which case, the task will receive 20GiB ephemeral storage.
         * <p>
         * @return {@code this}
         * @param ephemeralStorageGiB The amount (in GiB) of ephemeral storage to be allocated to the task. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder ephemeralStorageGiB(final java.lang.Number ephemeralStorageGiB) {
            this.props().ephemeralStorageGiB(ephemeralStorageGiB);
            return this;
        }

        /**
         * The amount (in MiB) of memory used by the task.
         * <p>
         * This field is required and you must use one of the following values, which determines your range of valid values
         * for the cpu parameter:
         * <p>
         * 512 (0.5 GB), 1024 (1 GB), 2048 (2 GB) - Available cpu values: 256 (.25 vCPU)
         * <p>
         * 1024 (1 GB), 2048 (2 GB), 3072 (3 GB), 4096 (4 GB) - Available cpu values: 512 (.5 vCPU)
         * <p>
         * 2048 (2 GB), 3072 (3 GB), 4096 (4 GB), 5120 (5 GB), 6144 (6 GB), 7168 (7 GB), 8192 (8 GB) - Available cpu values: 1024 (1 vCPU)
         * <p>
         * Between 4096 (4 GB) and 16384 (16 GB) in increments of 1024 (1 GB) - Available cpu values: 2048 (2 vCPU)
         * <p>
         * Between 8192 (8 GB) and 30720 (30 GB) in increments of 1024 (1 GB) - Available cpu values: 4096 (4 vCPU)
         * <p>
         * Between 16384 (16 GB) and 61440 (60 GB) in increments of 4096 (4 GB) - Available cpu values: 8192 (8 vCPU)
         * <p>
         * Between 32768 (32 GB) and 122880 (120 GB) in increments of 8192 (8 GB) - Available cpu values: 16384 (16 vCPU)
         * <p>
         * This default is set in the underlying FargateTaskDefinition construct.
         * <p>
         * Default: 512
         * <p>
         * @return {@code this}
         * @param memoryLimitMiB The amount (in MiB) of memory used by the task. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder memoryLimitMiB(final java.lang.Number memoryLimitMiB) {
            this.props().memoryLimitMiB(memoryLimitMiB);
            return this;
        }

        /**
         * The platform version on which to run your service.
         * <p>
         * If one is not specified, the LATEST platform version is used by default. For more information, see
         * <a href="https://docs.aws.amazon.com/AmazonECS/latest/developerguide/platform_versions.html">AWS Fargate Platform Versions</a>
         * in the Amazon Elastic Container Service Developer Guide.
         * <p>
         * Default: Latest
         * <p>
         * @return {@code this}
         * @param platformVersion The platform version on which to run your service. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder platformVersion(final software.amazon.awscdk.services.ecs.FargatePlatformVersion platformVersion) {
            this.props().platformVersion(platformVersion);
            return this;
        }

        /**
         * The runtime platform of the task definition.
         * <p>
         * Default: - If the property is undefined, `operatingSystemFamily` is LINUX and `cpuArchitecture` is X86_64
         * <p>
         * @return {@code this}
         * @param runtimePlatform The runtime platform of the task definition. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder runtimePlatform(final software.amazon.awscdk.services.ecs.RuntimePlatform runtimePlatform) {
            this.props().runtimePlatform(runtimePlatform);
            return this;
        }

        /**
         * The task definition to use for tasks in the service. TaskDefinition or TaskImageOptions must be specified, but not both.
         * <p>
         * [disable-awslint:ref-via-interface]
         * <p>
         * Default: - none
         * <p>
         * @return {@code this}
         * @param taskDefinition The task definition to use for tasks in the service. TaskDefinition or TaskImageOptions must be specified, but not both. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder taskDefinition(final software.amazon.awscdk.services.ecs.FargateTaskDefinition taskDefinition) {
            this.props().taskDefinition(taskDefinition);
            return this;
        }

        /**
         * Specifies whether the task's elastic network interface receives a public IP address.
         * <p>
         * If true, each task will receive a public IP address.
         * <p>
         * Default: false
         * <p>
         * @return {@code this}
         * @param assignPublicIp Specifies whether the task's elastic network interface receives a public IP address. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder assignPublicIp(final java.lang.Boolean assignPublicIp) {
            this.props().assignPublicIp(assignPublicIp);
            return this;
        }

        /**
         * Optional name for the container added.
         * <p>
         * This name is not used when <code>taskDefinition</code> is provided.
         * <p>
         * Default: - QueueProcessingContainer
         * <p>
         * @return {@code this}
         * @param containerName Optional name for the container added. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder containerName(final java.lang.String containerName) {
            this.props().containerName(containerName);
            return this;
        }

        /**
         * The health check command and associated configuration parameters for the container.
         * <p>
         * Default: - Health check configuration from container.
         * <p>
         * @return {@code this}
         * @param healthCheck The health check command and associated configuration parameters for the container. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder healthCheck(final software.amazon.awscdk.services.ecs.HealthCheck healthCheck) {
            this.props().healthCheck(healthCheck);
            return this;
        }

        /**
         * The security groups to associate with the service.
         * <p>
         * If you do not specify a security group, a new security group is created.
         * <p>
         * Default: - A new security group is created.
         * <p>
         * @return {@code this}
         * @param securityGroups The security groups to associate with the service. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder securityGroups(final java.util.List<? extends software.amazon.awscdk.services.ec2.ISecurityGroup> securityGroups) {
            this.props().securityGroups(securityGroups);
            return this;
        }

        /**
         * The subnets to associate with the service.
         * <p>
         * Default: - Public subnets if `assignPublicIp` is set, otherwise the first available one of Private, Isolated, Public, in that order.
         * <p>
         * @return {@code this}
         * @param taskSubnets The subnets to associate with the service. This parameter is required.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        public Builder taskSubnets(final software.amazon.awscdk.services.ec2.SubnetSelection taskSubnets) {
            this.props().taskSubnets(taskSubnets);
            return this;
        }

        /**
         * @return a newly built instance of {@link software.amazon.awscdk.services.ecs.patterns.QueueProcessingFargateService}.
         */
        @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
        @Override
        public software.amazon.awscdk.services.ecs.patterns.QueueProcessingFargateService build() {
            return new software.amazon.awscdk.services.ecs.patterns.QueueProcessingFargateService(
                this.scope,
                this.id,
                this.props != null ? this.props.build() : null
            );
        }

        private software.amazon.awscdk.services.ecs.patterns.QueueProcessingFargateServiceProps.Builder props() {
            if (this.props == null) {
                this.props = new software.amazon.awscdk.services.ecs.patterns.QueueProcessingFargateServiceProps.Builder();
            }
            return this.props;
        }
    }
}
