package software.amazon.awscdk.services.eks;

/**
 * Represents the scope type of an access policy.
 * <p>
 * The scope type determines the level of access granted by the policy.
 * <p>
 * Example:
 * <p>
 * <blockquote><pre>
 * // AmazonEKSClusterAdminPolicy with `cluster` scope
 * AccessPolicy.fromAccessPolicyName("AmazonEKSClusterAdminPolicy", AccessPolicyNameOptions.builder()
 *         .accessScopeType(AccessScopeType.CLUSTER)
 *         .build());
 * // AmazonEKSAdminPolicy with `namespace` scope
 * AccessPolicy.fromAccessPolicyName("AmazonEKSAdminPolicy", AccessPolicyNameOptions.builder()
 *         .accessScopeType(AccessScopeType.NAMESPACE)
 *         .namespaces(List.of("foo", "bar"))
 *         .build());
 * </pre></blockquote>
 */
@javax.annotation.Generated(value = "jsii-pacmak/1.106.0 (build e852934)", date = "2025-02-21T03:20:32.814Z")
@software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
@software.amazon.jsii.Jsii(module = software.amazon.awscdk.$Module.class, fqn = "aws-cdk-lib.aws_eks.AccessScopeType")
public enum AccessScopeType {
    /**
     * The policy applies to a specific namespace within the cluster.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    NAMESPACE,
    /**
     * The policy applies to the entire cluster.
     */
    @software.amazon.jsii.Stability(software.amazon.jsii.Stability.Level.Stable)
    CLUSTER,
}
